var codeExport = 
[
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\computers\\LOCComputer.java",
    "code": "\"package BlueTurtle.computers;\n\nimport java.io.BufferedReader;\nimport java.io.FileReader;\nimport java.io.IOException;\n\n/**\n * This class can be used to find the (physical) lines of code for a file.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:hideutilityclassconstructor\")\npublic final class LOCComputer {\n\n\tprivate static LOCComputer locComputer \u003d null;\n\n\t/**\n\t * Constructor. Only this class can instantiate itself.\n\t */\n\tprivate LOCComputer() { }\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of this class.\n\t */\n\tpublic static LOCComputer getInstance() {\n\t\tif (locComputer \u003d\u003d null) {\n\t\t\tlocComputer \u003d new LOCComputer();\n\t\t}\n\t\treturn locComputer;\n\t}\n\n\t/**\n\t * Find the number of (physical) lines for a source code file.\n\t * \n\t * @param filePath\n\t *            the path to the source code file.\n\t * @return the number of (physical) lines.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic int computeLOC(String filePath) throws IOException {\n\t\tint numLines \u003d 0;\n\t\tBufferedReader reader \u003d new BufferedReader(new FileReader(filePath));\n\t\tString line \u003d reader.readLine();\n\t\twhile (line !\u003d null) {\n\t\t\tif (!line.isEmpty() \u0026\u0026 !line.startsWith(\"import\")) {\n\t\t\t\tnumLines++;\n\t\t\t}\n\t\t\tline \u003d reader.readLine();\n\t\t}\n\t\treader.close();\n\t\treturn numLines;\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\finders\\PackageNameFinder.java",
    "code": "\"package BlueTurtle.finders;\n\nimport java.io.BufferedReader;\nimport java.io.FileReader;\nimport java.io.IOException;\n\n/**\n * This class can be used for finding the package name of a component.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:hideutilityclassconstructor\")\npublic final class PackageNameFinder {\n\n\tprivate static PackageNameFinder packageNameFinder \u003d null;\n\n\t/**\n\t * Constructor. Only this class can instantiate itself.\n\t */\n\tprivate PackageNameFinder() { }\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of PackageNameFinder.\n\t */\n\tpublic static PackageNameFinder getInstance() {\n\t\tif (packageNameFinder \u003d\u003d null) {\n\t\t\tpackageNameFinder \u003d new PackageNameFinder();\n\t\t}\n\t\treturn packageNameFinder;\n\t}\n\n\t/**\n\t * Find the package name based on the given file path.\n\t * \n\t * @param filePath\n\t *            the path to the file.\n\t * @return the package name.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic String findPackageName(String filePath) throws IOException {\n\t\tString packageName \u003d \"default\";\n\t\tBufferedReader reader \u003d new BufferedReader(new FileReader(filePath));\n\t\tString line \u003d reader.readLine();\n\t\tString[] packageInfo \u003d line.split(\" \");\n\n\t\tif (packageInfo[0].equals(\"package\")) {\n\t\t\tpackageName \u003d packageInfo[1].split(\";\")[0];\n\t\t}\n\n\t\treader.close();\n\t\treturn packageName;\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\finders\\ProjectInfoFinder.java",
    "code": "\"package BlueTurtle.finders;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.HashSet;\nimport java.util.Set;\n\nimport BlueTurtle.TSE.CodeFile;\nimport BlueTurtle.computers.LOCComputer;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.writers.JSWriter;\nimport lombok.Getter;\n\n/**\n * Find all information of the project given the source directory of project.\n * \n * @author BlueTurtle.\n *\n */\npublic class ProjectInfoFinder {\n\n\t@Getter private static ArrayList\u003cString\u003e classPaths \u003d new ArrayList\u003cString\u003e();\n\t@Getter private static HashMap\u003cString, Integer\u003e classLocs \u003d new HashMap\u003cString, Integer\u003e();\n\t@Getter private static HashMap\u003cString, String\u003e classPackage \u003d new HashMap\u003cString, String\u003e();\n\t@Getter private static Set\u003cString\u003e packages \u003d new HashSet\u003cString\u003e();\n\t@Getter private ArrayList\u003cCodeFile\u003e codeFiles \u003d new ArrayList\u003cCodeFile\u003e();\n\t@Getter private static HashMap\u003cASAT, ArrayList\u003cString\u003e\u003e outputFilesPaths \u003d new HashMap\u003cASAT, ArrayList\u003cString\u003e\u003e();\n\n\t/**\n\t * Find the class files or the output files of the ASATs (recursively) in the directory.\n\t * \n\t * @param srcDir\n\t *            the source directory to search in.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the files.\n\t */\n\tpublic void findFiles(File srcDir) throws IOException {\n\t\t// Find all subdirectories.\n\t\tFile[] subdirs \u003d srcDir.listFiles();\n\n\t\t// Go through all subdirectories.\n\t\tfor (File subdir : subdirs) {\n\t\t\t// if it is a directory, keep searching for file.\n\t\t\tif (subdir.isDirectory()) {\n\t\t\t\tfindFiles(subdir);\n\t\t\t} else {\n\t\t\t\t// if file is found, compute the informations.\n\t\t\t\tcomputeFileInfo(subdir);\n\t\t\t}\n\t\t}\n\t}\n\n\t/**\n\t * Compute the information of the file that is found.\n\t * \n\t * @param file\n\t *            the file that is found.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic void computeFileInfo(File file) throws IOException {\n\t\t// if it is a java file, then compute information for the class.\n\t\tif (file.getName().endsWith(\".java\")) {\n\t\t\tcomputeClassInfo(file);\n\t\t} else if (file.getName().endsWith(\".xml\") \u0026\u0026 checkForASATOutputFile(file.getName())) {\n\t\t\t//If it is an output file the compute the information of the output file.\n\t\t\tcomputeOutputFileInfo(file);\n\t\t}\n\t}\n\n\t/**\n\t * Computes all the information of a class file.\n\t * \n\t * @param file\n\t *            the class file.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic static void computeClassInfo(File file) throws IOException {\n\t\tString path \u003d file.getAbsolutePath();\n\t\tclassPaths.add(path); // add the path\n\t\tclassLocs.put(path, LOCComputer.getInstance().computeLOC(path)); // add the LOC\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(path); //find the package name\n\t\tclassPackage.put(path, packageName); // put entry of class and its package\n\t\tpackages.add(packageName); // add package to the list of packages\n\t}\n\t\n\t/**\n\t * Compute the paths of the output files of the ASAT. \n\t * @param file \n\t * \t\t\t   output file of the ASAT.\n\t */\n\tpublic void computeOutputFileInfo(File file) {\n\t\tswitch (file.getName()) {\n\t\tcase \"checkstyle-result.xml\":\n\t\t\taddOutputFilePath(ASAT.CheckStyle, file.getAbsolutePath());\n\t\t\tbreak;\n\t\tcase \"findbugs.xml\":\n\t\t\taddOutputFilePath(ASAT.FindBugs, file.getAbsolutePath());\n\t\t\tbreak;\n\t\tcase \"pmd.xml\": \n\t\t\taddOutputFilePath(ASAT.PMD, file.getAbsolutePath());\n\t\t\tbreak;\n\t\tdefault:\n\t\t\t//unreachable\n\t\t\tthrow new IllegalArgumentException(\"This is not an output file of an ASAT.\");\n\t\t}\n\t}\n\t\n\t/**\n\t * Add the path of an output file to the \"outputFilesPaths\".\n\t * @param asat \n\t * \t\t\t\tthe ASAT type.\n\t * @param filePath \n\t * \t\t\t\tthe path of the output file.\n\t */\n\tpublic void addOutputFilePath(ASAT asat, String filePath) {\n\t\tif (outputFilesPaths.containsKey(asat)) {\n\t\t\toutputFilesPaths.get(asat).add(filePath);\n\t\t}\n\t\telse {\n\t\t\toutputFilesPaths.put(asat, new ArrayList\u003cString\u003e());\n\t\t\toutputFilesPaths.get(asat).add(filePath);\n\t\t}\n\t}\n\t\n\t/**\n\t * Check whether the file is an output file of an ASAT.\n\t * @param fileName\n\t *            the name of the file.\n\t * @return \n\t * \t\t\treturns true if it is an output file of an ASAT.\n\t */\n\tpublic Boolean checkForASATOutputFile(String fileName) {\n\t\treturn (fileName.contains(\"checkstyle-result\") || fileName.contains(\"pmd.\") || fileName.contains(\"findbugs.\"));\n\t}\n\n\t/**\n\t * Retrieves the code from every file located through the filepath in\n\t * classPaths. The code is stored in a CodeFile object which is added to the\n\t * codeFiles field. These files are then written to an output file.\n\t * \n\t * @throws IOException\n\t *             if file is not found, inaccessible, etc.\n\t */\n\tpublic void retrieveCodeFiles() throws IOException {\n\t\tfor (String classPath : classPaths) {\n\t\t\tFile currFile \u003d new File(classPath);\n\t\t\tCodeFile codeFile \u003d new CodeFile();\n\t\t\tcodeFile.setPath(classPath);\n\t\t\tcodeFile.getCodeFromFile(currFile);\n\t\t\tcodeFiles.add(codeFile);\n\t\t}\n\t\tJSWriter jswriter \u003d JSWriter.getInstance();\n\n\t\tjswriter.writeSourceCodeToJS(codeFiles, \"visualization/JSON/outputCodeJSON.js\");\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\groupers\\Grouper.java",
    "code": "\"package BlueTurtle.groupers;\n\nimport java.util.List;\n\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.summarizers.Summarizer;\n\n/**\n * This interface is used for a grouper (class that groups things together).\n * \n * @author BlueTurtle.\n *\n */\npublic interface Grouper {\n\t/**\n\t * Group things based on the given criteria.\n\t * \n\t * @param criteria\n\t *            list of criterium for grouping things together.\n\t * @return a list of things that are grouped together.\n\t */\n\tList\u003cSummarizer\u003e groupBy(Enum\u003cCriteria\u003e criteria);\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\groupers\\WarningGrouper.java",
    "code": "\"package BlueTurtle.groupers;\n\nimport java.io.File;\nimport java.util.ArrayList;\nimport java.util.EnumMap;\nimport java.util.List;\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.summarizers.ComponentSummarizer;\nimport BlueTurtle.summarizers.PackageSummarizer;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class is used to group warnings together (by their type or by\n * components).\n * \n * @author BlueTurtle.\n *\n */\npublic class WarningGrouper implements Grouper {\n\n\t/**\n\t * The types of criteria for grouping warnings.\n\t * \n\t * @author BlueTurtle.\n\t *\n\t */\n\tpublic enum Criteria {\n\t\tCOMPONENTS, PACKAGES\n\t}\n\n\t@Getter private EnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e summarizedWarnings;\n\t@Getter private List\u003cWarning\u003e warningList;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param warningList\n\t *            the list of warnings.\n\t */\n\tpublic WarningGrouper(List\u003cWarning\u003e warningList) {\n\t\tthis.warningList \u003d warningList;\n\t\tthis.summarizedWarnings \u003d new EnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e(Criteria.class);\n\t\tsummarizedWarnings.put(Criteria.COMPONENTS, groupByComponent());\n\t\tsummarizedWarnings.put(Criteria.PACKAGES, groupByPackage());\n\t}\n\n\t/**\n\t * Group things together, based on the criteria.\n\t * \n\t * @param criteria\n\t *            the criteria for grouping things together.\n\t */\n\t@Override\n\tpublic List\u003cSummarizer\u003e groupBy(Enum\u003cCriteria\u003e criteria) {\n\t\treturn summarizedWarnings.get(criteria);\n\t}\n\n\t/**\n\t * Group warnings by the component that they are from.\n\t * \n\t * @return a list of Summarizer objects.\n\t */\n\tpublic List\u003cSummarizer\u003e groupByComponent() {\n\t\tList\u003cSummarizer\u003e csList \u003d new ArrayList\u003cSummarizer\u003e();\n\n\t\tfor (String classPath : ProjectInfoFinder.getClassPaths()) {\n\t\t\tString fileName \u003d classPath.substring(classPath.lastIndexOf(File.separator) + 1, classPath.length());\n\t\t\tString filePath \u003d classPath;\n\t\t\tString packageName \u003d ProjectInfoFinder.getClassPackage().get(filePath);\n\t\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\t\tcs.summarise(getWarningList());\n\t\t\tcsList.add(cs);\n\t\t}\n\n\t\treturn csList;\n\t}\n\n\t/**\n\t * Group the warnings by the package they are from.\n\t * \n\t * @return a list of summarizer objects.\n\t */\n\tpublic List\u003cSummarizer\u003e groupByPackage() {\n\t\tList\u003cSummarizer\u003e result \u003d new ArrayList\u003cSummarizer\u003e();\n\n\t\tfor (String p : ProjectInfoFinder.getPackages()) {\n\t\t\tPackageSummarizer ps \u003d new PackageSummarizer(p);\n\t\t\tps.summarise(warningList);\n\t\t\tresult.add(ps);\n\t\t}\n\n\t\treturn result;\n\t}\n\n\t/**\n\t * Check whether two Warning grouper are equal.\n\t * \n\t * @param other\n\t *            the other WarningGrouper object\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\t\tif (!(other instanceof WarningGrouper)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tWarningGrouper that \u003d (WarningGrouper) other;\n\n\t\t// fix SimplifyBooleanReturn, Conditional logic can be removed.\n\t\treturn (warningList.equals(that.getWarningList()) \u0026\u0026 summarizedWarnings.equals(that.summarizedWarnings));\n\t}\n\n\t/**\n\t * HashCode for WarningGrouper.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(warningList, summarizedWarnings);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\gui\\AlertCreator.java",
    "code": "\"package BlueTurtle.gui;\n\nimport javafx.scene.control.Alert;\nimport javafx.scene.control.Alert.AlertType;\n\n/**\n * This class is for creating alert dialogs.\n * \n * @author BlueTurtle.\n *\n */\npublic final class AlertCreator {\n\n\tprivate static AlertCreator alertCreator \u003d null;\n\n\t/**\n\t * Only this class can instantiate itself.\n\t */\n\tprivate AlertCreator() {\n\t}\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of the DialogCreator.\n\t */\n\tpublic static AlertCreator getInstance() {\n\t\tif (alertCreator \u003d\u003d null) {\n\t\t\talertCreator \u003d new AlertCreator();\n\t\t}\n\t\treturn alertCreator;\n\t}\n\n\t/**\n\t * Create an alert dialog.\n\t * \n\t * @param type\n\t *            the type of the alert.\n\t * @param title\n\t *            the title of the dialog box.\n\t * @param message\n\t *            the message in the dialog box.\n\t * @return an alert dialog.\n\t */\n\tpublic Alert createAlert(AlertType type, String title, String message) {\n\t\tAlert alert \u003d new Alert(type);\n\t\talert.setTitle(title);\n\t\talert.setContentText(message);\n\t\treturn alert;\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\gui\\GUI.java",
    "code": "\"package BlueTurtle.gui;\n\nimport javafx.application.Application;\nimport javafx.application.Platform;\nimport javafx.fxml.FXMLLoader;\nimport javafx.scene.Scene;\nimport javafx.scene.control.SplitPane;\nimport javafx.scene.image.Image;\nimport javafx.stage.Stage;\n\n/**\n * This class the GUI component of the system.\n * \n * @author BlueTurtle.\n *\n */\npublic class GUI extends Application {\n\n\t/**\n\t * Start the GUI.\n\t */\n\tpublic void startGUI() {\n\t\tApplication.launch(GUI.class, (java.lang.String[]) null);\n\t}\n\n\t/**\n\t * Start the scene.\n\t * \n\t * @param stage\n\t *            the stage.\n\t */\n\t@Override\n\tpublic void start(Stage stage) {\n\t\ttry {\n\t\t\tstage.setTitle(\"BlueTurtle Visualizer\");\n\t\t\tstage.getIcons().add(new Image(GUI.class.getResourceAsStream(\"/blueturtlelogo.png\")));\n\t\t\tstage.setHeight(420);\n\t\t\tstage.setWidth(1083);\n\t\t\tstage.setResizable(false);\n\t\t\tstage.setScene(new Scene((SplitPane) new FXMLLoader(getClass().getResource(\"/Menu.fxml\")).load()));\n\t\t\tstage.show();\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n\t/**\n\t * Stop the application / GUI.\n\t */\n\tpublic void stop() {\n\t\tPlatform.exit();\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\gui\\GUIController.java",
    "code": "\"package BlueTurtle.gui;\n\nimport java.awt.Desktop;\nimport java.awt.TextField;\n\nimport javafx.scene.control.Alert;\nimport javafx.scene.control.Alert.AlertType; \nimport java.io.File;\nimport java.io.IOException;\nimport java.net.URL;\nimport java.util.ResourceBundle;\n\nimport javax.swing.Popup;\n\nimport BlueTurtle.TSE.JavaController;\nimport BlueTurtle.TSE.Main;\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport javafx.event.EventHandler;\nimport javafx.fxml.FXML;\nimport javafx.scene.control.Button;\nimport javafx.scene.input.MouseEvent;\nimport javafx.scene.text.Text;\nimport javafx.stage.DirectoryChooser;\nimport javafx.stage.Stage;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * Controller class for the GUI.\n * \n * @author BlueTurtle.\n *\n */\npublic class GUIController {\n\n\n\t/**\n\t * Enums to represent the ASATs.\n\t * \n\t * @author BlueTurtle.\n\t *\n\t */\n\tpublic enum ASAT { CheckStyle, PMD, FindBugs; }\n\n\t@FXML // ResourceBundle that was given to the FXMLLoader\n\tprivate ResourceBundle resources; //NOPMD - needed for the FXMLLoader.\n\n\t@FXML // URL location of the FXML file that was given to the FXMLLoader\n\tprivate URL location; //NOPMD - needed for the FXMLLoader.\n\n\t@FXML // fx:id\u003d\"selectButton\"\n\tprivate Button selectButton; // Value injected by FXMLLoader\n\n\t@FXML // fx:id\u003d\"projectSourcePathText\"\n\tprivate Text projectSourcePathText; // Value injected by FXMLLoader\n\n\t@FXML // fx:id\u003d\"visualizeButton\"\n\tprivate Button visualizeButton; // Value injected by FXMLLoader\n\t\n\t@Getter @Setter private static String projectPath; //NOPMD - warning caused by lombok.\n\t\n\t/**\n\t * Event for CheckStyle button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectCheckStyleConfigEvent(MouseEvent event) { }\n\n\t/**\n\t * Event for PMD button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectPMDConfigEvent(MouseEvent event) { }\n\n\t/**\n\t * Event for FindBugs button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectFindBugsConfigEvent(MouseEvent event) { }\n\n\t/**\n\t * Events for the LoadButton.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectButtonEvent(MouseEvent event) { }\n\n\t/**\n\t * Events from the VisualizeButton.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid visualizeButtonEvent(MouseEvent event) { }\n\n\t/**\n\t * Initialize the buttons.\n\t */\n\t@FXML\n\tvoid initialize() {\n\t\tassert visualizeButton !\u003d null : \"fx:id\u003d\\\"visualizeButton\\\" was not injected: check your FXML file \u0027Menu.fxml\u0027.\";\n\t\tassert projectSourcePathText !\u003d null : \"fx:id\u003d\\\"projectSourcePathText\\\" was not injected: check your FXML file \u0027Menu.fxml\u0027.\";\n\t\tassert selectButton !\u003d null : \"fx:id\u003d\\\"selectButton\\\" was not injected: check your FXML file \u0027Menu.fxml\u0027.\";\n\n\t\t// Set the event handlers for the buttons.\n\t\tselectButton.setOnMouseClicked(new SelectButtonEventHandler(projectSourcePathText, visualizeButton));\n\t\tvisualizeButton.setOnMouseClicked(new VisualizeButtonEventHandler());\n\t}\n\t\n}\n\n/**\n * EventHandler class for select button of GUI.\n * \n * @author BlueTurtle.\n *\n */\nclass SelectButtonEventHandler implements EventHandler\u003cMouseEvent\u003e {\n\n\t@Getter private Text sourcePathText;\n\t@Getter private Button visualizeButton;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param sourcePathText\n\t *            the text field that shows the path of the project.\n\t * @param vButton\n\t *            the visualize button. This is needed for enabling the button\n\t *            after the project folder is selected.\n\t */\n\tpublic SelectButtonEventHandler(Text sourcePathText, Button vButton) {\n\t\tthis.sourcePathText \u003d sourcePathText;\n\t\tthis.visualizeButton \u003d vButton;\n\t}\n\t\n\n\t/**\n\t * Event handler for the button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@Override\n\tpublic void handle(MouseEvent event) {\n\t\tDirectoryChooser directoryChooser \u003d new DirectoryChooser();\n\t\tFile selectedDirectory \u003d directoryChooser.showDialog(new Stage());\n\n\t\tif (selectedDirectory \u003d\u003d null) {\n\t\t\tsourcePathText.setText(\"No Directory selected\");\n\t\t} else {\n\t\t\tsourcePathText.setText(selectedDirectory.getAbsolutePath());\n\t\t\tGUIController.setProjectPath(sourcePathText.getText());\n\t\t\tAlertCreator.getInstance().createAlert(AlertType.INFORMATION, \"Info\", \"Please make sure that you have run mvn site\" + \"\\n\"\n\t\t\t\t\t+ \"before clicking on the \" + \u0027\"\u0027 + \"Visualize\" + \u0027\"\u0027 + \" button!\").showAndWait();\n\t\t\tvisualizeButton.setDisable(false);\n\t\t}\n\t}\n\n}\n\n/**\n * EventHandler class for visualize button of GUI.\n * \n * @author BlueTurtle.\n *\n */\nclass VisualizeButtonEventHandler implements EventHandler\u003cMouseEvent\u003e {\n\t\n\t@Getter @Setter private AlertCreator alertCreator \u003d AlertCreator.getInstance();\n\n\t/**\n\t * Event handler for the button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@Override\n\tpublic void handle(MouseEvent event) {\n\t\ttry {\n\t\t\tfindProjectInfo();\n\t\t\tAlert alert \u003d alertCreator.createAlert(AlertType.INFORMATION, \"info\", \"Collecting the data may take a few minutes for large projects.\");\n\t\t\talert.show();\n\t\t\t\n\t\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\t\tpif.findFiles(new File(GUIController.getProjectPath()));\n\t\t\tpif.retrieveCodeFiles();\n\t\t\tMain.runVisualization();\n\t\t\tDesktop.getDesktop().browse(new File(\"visualization/main.html\").toURI());\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n\t/**\n\t * Find all necessary information of the project.\n\t * @throws IOException \n\t * \t\t\t\tthrows an exception if a problem is encountered while reading the files.\n\t */\n\tpublic void findProjectInfo() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(GUIController.getProjectPath()));\n\t\tsetListOfOutputFiles();\n\t\tpif.retrieveCodeFiles();\n\t}\n\t\n\t/**\n\t * Set the list of output files (generated by Maven) for each ASAT.\n\t */\n\tpublic void setListOfOutputFiles() {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, ProjectInfoFinder.getOutputFilesPaths().get(ASAT.CheckStyle));\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, ProjectInfoFinder.getOutputFilesPaths().get(ASAT.PMD));\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, ProjectInfoFinder.getOutputFilesPaths().get(ASAT.FindBugs));\n\t}\n}\n\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\CheckStyleXMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\nimport org.w3c.dom.Node;\nimport org.w3c.dom.Element;\nimport java.io.File;\nimport java.util.Arrays;\nimport java.util.LinkedList;\nimport java.util.List;\nimport java.util.regex.Matcher;\n\n/**\n * This class can be used to parse a CheckStyle XML output file.\n * \n * @author BlueTurtle.\n *\n */\npublic class CheckStyleXMLParser extends XMLParser {\n\n\t/**\n\t * Parse a CheckStyle report file.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the CheckStyle report.\n\t * @return a list of CheckStyle warnings.\n\t */\n\t@Override\n\tpublic List\u003cWarning\u003e parseFile(String xmlFilePath) {\n\t\t// List to store the warnings.\n\t\tList\u003cWarning\u003e checkStyleWarnings \u003d new LinkedList\u003cWarning\u003e();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tNodeList nList \u003d setUp(xmlFilePath);\n\t\t\t\n\t\t\t// if there are no files with warnings, there return an empty list of warnings.\n\t\t\tif (nList \u003d\u003d null) { \n\t\t\t\treturn checkStyleWarnings; \n\t\t\t}\n\n\t\t\tfor (int i \u003d 0; i \u003c nList.getLength(); i++) {\n\t\t\t\t// Get the file from the list.\n\t\t\t\tNode file \u003d nList.item(i);\n\n\t\t\t\t\t// Get the path of the file where the warning is from.\n\t\t\t\t\tString filePath \u003d ((Element) file).getAttribute(\"name\");\n\n\t\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\t\tString fileName \u003d filePath.substring(filePath.lastIndexOf(\"src\") + 3, filePath.length());\n\n\t\t\t\t\t// Get all the warnings.\n\t\t\t\t\tNodeList warningList \u003d ((Element) file).getElementsByTagName(\"error\");\n\n\t\t\t\t\taddWarnings(fileName, warningList, checkStyleWarnings);\n\t\t\t}\n\n\t\treturn checkStyleWarnings;\n\t}\n\n\t/**\n\t * Add individual warning to the warningList.\n\t * \n\t * @param fileName\n\t *            is the file name of the warning.\n\t * @param warningList\n\t *            is a list of warnings.\n\t * @param checkStyleWarnings\n\t *            is the CheckStyle warnings.\n\t * @return a list of CheckStyle warnings.\n\t */\n\tpublic List\u003cWarning\u003e addWarnings(String fileName, NodeList warningList, List\u003cWarning\u003e checkStyleWarnings) {\n\t\tfor (int j \u003d 0; j \u003c warningList.getLength(); j++) {\n\t\t\t// Get the warning from the list of warnings.\n\t\t\tNode warning \u003d warningList.item(j);\n\t\t\t\n\t\t\t\t// Convert the node to an element.\n\t\t\t\tElement warningElement \u003d (Element) warning;\n\n\t\t\t\t// The message contained by the warning.\n\t\t\t\tString message \u003d warningElement.getAttribute(\"message\");\n\n\t\t\t\t// line number where the warning is located.\n\t\t\t\tint line \u003d Integer.parseInt(warningElement.getAttribute(\"line\"));\n\n\t\t\t\t// Get the category of the warning.\n\t\t\t\tString ruleName \u003d getRuleName(warningElement.getAttribute(\"source\"));\n\n\t\t\t\tString classification \u003d classify(ruleName);\n\n\t\t\t\t// replace the backward slash in the file name with file separator.\n\t\t\t\tString fileNWithSep \u003d fileName.replaceAll(\"\\\\\\\\\", Matcher.quoteReplacement(File.separator));\n\n\t\t\t\t// for-loop in stream, find correct filePath.\n\t\t\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(p -\u003e p.endsWith(fileNWithSep)).findFirst().get();\n\n\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\tString finalFileName \u003d fileNWithSep.substring(fileNWithSep.lastIndexOf(File.separatorChar) + 1, fileNWithSep.length());\n\n\t\t\t\t// Add warning to the list of warnings.\n\t\t\t\tcheckStyleWarnings.add(new CheckStyleWarning(filePath, finalFileName, line, message, ruleName, classification));\n\t\t}\n\t\t\n\t\treturn checkStyleWarnings;\n\n\t}\n\n\t/**\n\t * Get the rule name of the CheckStyle warning.\n\t * \n\t * @param source\n\t *            the source of the check.\n\t * @return the category of the CheckStyle warning.\n\t */\n\tpublic static String getRuleName(String source) {\n\t\t// Remove the substring \"Check\" from the source.\n\t\tString[] temp \u003d source.split(\"Check\");\n\n\t\t// Build the string back.\n\t\tsource \u003d Arrays.toString(temp);\n\n\t\t// Return only the name of the check.\n\t\treturn source.substring(source.lastIndexOf(\u0027.\u0027) + 1, source.length() - 1);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\FindBugsXMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.LinkedList;\nimport java.util.List;\nimport java.util.regex.Matcher;\n\nimport org.w3c.dom.Element;\nimport org.w3c.dom.Node;\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.FindBugsWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * This class can be used to parse a FindBugs XML output file.\n * \n * @author BlueTurtle.\n *\n */\npublic class FindBugsXMLParser extends XMLParser {\n\n\t/**\n\t * Parse a FindBugs report file.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the FindBugs report.\n\t * @return a list of FindBugs warnings.\n\t */\n\t@Override\n\tpublic List\u003cWarning\u003e parseFile(String xmlFilePath) {\n\n\t\t// List to store the warnings.\n\t\tList\u003cWarning\u003e findBugsWarnings \u003d new LinkedList\u003cWarning\u003e();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tNodeList nList \u003d setUp(xmlFilePath);\n\t\t\t\n\t\t\t// if there are no files with warnings, there return an empty list of warnings.\n\t\t\tif (nList \u003d\u003d null) { \n\t\t\t\treturn findBugsWarnings; \n\t\t\t}\n\n\t\t\tfor (int i \u003d 0; i \u003c nList.getLength(); i++) {\n\t\t\t\t// Get the file from the list.\n\t\t\t\tNode file \u003d nList.item(i);\n\n\t\t\t\t\t// Convert the node to an element.\n\t\t\t\t\tElement fileElement \u003d (Element) file;\n\n\t\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\t\tString fileName \u003d fileElement.getAttribute(\"classname\");\n\n\t\t\t\t\t// Get all the warnings.\n\t\t\t\t\tNodeList warningList \u003d fileElement.getElementsByTagName(\"BugInstance\");\n\n\t\t\t\t\taddWarnings(fileName, warningList, findBugsWarnings, nList);\n\t\t\t}\n\n\t\treturn findBugsWarnings;\n\t}\n\n\t/**\n\t * add individual warning to the warningList.\n\t * \n\t * @param fileName\n\t *            is the file name of the warning.\n\t * @param warningList\n\t *            is a list of warnings.\n\t * @param nList\n\t *            is the node list.\n\t * @param findBugsWarnings\n\t *            is the findBugs warnings.\n\t */\n\tpublic void addWarnings(String fileName, NodeList warningList, List\u003cWarning\u003e findBugsWarnings, NodeList nList) {\n\n\t\tfor (int j \u003d 0; j \u003c warningList.getLength(); j++) {\n\t\t\t// Get the warning from the list of warnings.\n\t\t\tNode warning \u003d warningList.item(j);\n\n\t\t\t\t// Convert the node to an element.\n\t\t\t\tElement warningElement \u003d (Element) warning;\n\n\t\t\t\t// The message contained by the warning.\n\t\t\t\tString message \u003d warningElement.getAttribute(\"message\");\n\n\t\t\t\t// The category of warning.\n\t\t\t\tString category \u003d warningElement.getAttribute(\"category\");\n\n\t\t\t\t// The priority of warning, can be high or low.\n\t\t\t\tString priority \u003d warningElement.getAttribute(\"priority\");\n\n\t\t\t\t// line number where the warning is located.\n\t\t\t\tint line \u003d Integer.parseInt(warningElement.getAttribute(\"lineNumber\"));\n\n\t\t\t\t// Get the category of the warning.\n\t\t\t\tString ruleName \u003d warningElement.getAttribute(\"type\");\n\n\t\t\t\tString classification \u003d classify(ruleName);\n\n\t\t\t\t// replace the dot in the file name with file separator.\n\t\t\t\tString fileNWithSep \u003d fileName.replaceAll(\"\\\\.\", Matcher.quoteReplacement(File.separator)) + \".java\";\n\n\t\t\t\t// for-loop in stream.\n\t\t\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(p -\u003e p.endsWith(fileNWithSep)).findFirst().get();\n\n\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\tString finalFileName \u003d fileNWithSep.substring(fileNWithSep.lastIndexOf(File.separatorChar) + 1, fileNWithSep.length());\n\n\t\t\t\t// Construct the new FindBugsWarning.\n\t\t\t\tFindBugsWarning fbw \u003d new FindBugsWarning(filePath, finalFileName, line, message, category, priority, ruleName, classification);\n\n\t\t\t\t// Add warning to the list of warnings.\n\t\t\t\tfindBugsWarnings.add(fbw);\n\t\t}\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\GDCParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.HashMap;\nimport org.jsoup.Jsoup;\nimport org.jsoup.nodes.Document;\nimport org.jsoup.select.Elements;\n\nimport lombok.Getter;\n\n\n/**\n * This class can be used to parse the General Defect Classification (GDC) grouping to a file.\n * \n * @author BlueTurtle.\n * \n * Reference: Moritz Beller, Radjino Bholanath, Shane McIntosh, Andy Zaidman: Analyzing\n * the State of Static Analysis: A Large-Scale Evaluation in Open Source Software\n * in 23rd IEEE International Conference on Software Analysis, Evolution, and\n * Reengineering (SANER), Osaka (Japan), 2016.\n *\n */\npublic final class GDCParser extends MarkdownParser {\n\t\n\tprivate static GDCParser gdcParser \u003d null;\n\t\n\t@Getter\n\tprivate static HashMap\u003cString, String\u003e categoryInfo;\n\t\n\t/**\n\t * Constructor. Only through this can GDCParser instantiate itself.\n\t */\n\tprivate GDCParser() { }\n\n\t/**\n\t * Get an instance of GDCParser.\n\t * \n\t * @return an instance of current class.\n\t */\n\tpublic static synchronized GDCParser getInstance() {\n\t\tif (gdcParser \u003d\u003d null) {\n\t\t\tgdcParser \u003d new GDCParser();\n\t\t}\n\t\treturn gdcParser;\n\t}\n\n\t/**\n\t * Parse a GDC grouping file.\n\t * \n\t * @param mdFilePath\n\t *            the location of the GDC grouping file.\n\t * @return a Hashmap of category informations.\n\t */\n\tpublic HashMap\u003cString, String\u003e parseFile(String mdFilePath) {\n\t\t// the hashmap to store the category informations.\n\t\tcategoryInfo \u003d new HashMap\u003cString, String\u003e();\n\t\t\n\t\ttry {\n\t\t\t// Instantiate things that are necessary for the parser.\n\t\t\tFile inputFile \u003d new File(mdFilePath);\n\t\t\t\n\t\t\t// parse the file.\n\t\t\tDocument doc \u003d Jsoup.parse(inputFile, \"UTF-8\");\n\t\t\t\n\t\t\t// select all the rows in the tables.\n\t\t\tElements rows \u003d doc.select(\"tbody\").select(\"tr\");\n\n\t\t\t// loop through each row of the entire GDC table\n\t\t\tfor (int i \u003d 0; i \u003c rows.size(); i++) {\n\t\t\t\tElements cols \u003d rows.get(i).select(\"td\");\n\t\t\t\t// first column is the warning name.\n\t\t\t\tString warning \u003d cols.get(0).text();\n\t\t\t\t// second column is the category of warning.\n\t\t\t\tString category \u003d cols.get(1).text();\n\n\t\t\t\t// update the warningList of the category.\n\t\t\t\tcategoryInfo.put(warning, category);\n\t\t\t}\n\t\t\t\t\t\t\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\t\n\t\treturn categoryInfo;\n\t\t\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\MarkdownParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.util.HashMap;\n\n/**\n * This class can be used to parse a Markdown file.\n * \n * @author BlueTurtle.\n *\n */\npublic abstract class MarkdownParser {\n\n\t/**\n\t * Parse a Markdown file.\n\t * \n\t * @param filePath\n\t *            the path to the file that needs to be parsed.\n\t * @return returns a HashMap.\n\t */\n\tpublic abstract HashMap\u003cString, String\u003e parseFile(String filePath);\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\Parser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.util.List;\n\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Interface for a parser. The parser has only one method, which is to parse a\n * file.\n * \n * @author BlueTurtle.\n *\n */\npublic interface Parser {\n\n\t/**\n\t * Parse the file.\n\t * \n\t * @param filePath\n\t *            the location of the file.\n\t * @return a list containing warning objects.\n\t */\n\tList\u003cWarning\u003e parseFile(String filePath);\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\PMDXMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.LinkedList;\nimport java.util.List;\nimport java.util.regex.Matcher;\n\nimport org.w3c.dom.Element;\nimport org.w3c.dom.Node;\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.PMDWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * This class can be used to parse a PMD XML output file.\n * \n * @author BlueTurtle.\n *\n */\npublic class PMDXMLParser extends XMLParser {\n\n\t/**\n\t * Parse a PMD report file.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the PMD report.\n\t * @return a list of PMD warnings.\n\t */\n\t@Override\n\tpublic List\u003cWarning\u003e parseFile(String xmlFilePath) {\n\t\t// List to store the warnings.\n\t\tList\u003cWarning\u003e pmdWarnings \u003d new LinkedList\u003cWarning\u003e();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tNodeList nList \u003d setUp(xmlFilePath);\n\n\t\t\t// if there are no files with warnings, there return an empty list of warnings.\n\t\t\tif (nList \u003d\u003d null) {\n\t\t\t\treturn pmdWarnings;\n\t\t\t}\n\t\t\t\n\t\t\tfor (int i \u003d 0; i \u003c nList.getLength(); i++) {\n\t\t\t\t// Get the file from the list.\n\t\t\t\tNode file \u003d nList.item(i);\n\n\n\t\t\t\t\t// Convert the node to an element.\n\t\t\t\t\tElement fileElement \u003d (Element) file;\n\n\t\t\t\t\t// Get the path of the file where the warning is from.\n\t\t\t\t\tString filePath \u003d fileElement.getAttribute(\"name\");\n\n\t\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\t\tString fileName \u003d filePath.substring(filePath.lastIndexOf(\"src\") + 3, filePath.length());\n\t\t\t\t\t\n\t\t\t\t\taddWarnings(fileName, fileElement, pmdWarnings);\n\n\n\t\t\t}\n\n\t\treturn pmdWarnings;\n\t}\n\n\t/**\n\t * Add individual warning to the warningList.\n\t * \n\t * @param fileName\n\t *            is the file name of the warning.\n\t * @param fileElement\n\t *            is a file element which contains all the warnings.\n\t * @param pmdWarnings\n\t *            is list of PMD warnings.\n\t */\n\tpublic void addWarnings(String fileName, Element fileElement, List\u003cWarning\u003e pmdWarnings) {\n\n\t\t// Get all the warnings.\n\t\tNodeList warningList \u003d fileElement.getElementsByTagName(\"violation\");\n\t\t\n\t\tfor (int j \u003d 0; j \u003c warningList.getLength(); j++) {\n\t\t\t// Get the warning from the list of warnings.\n\t\t\tNode warning \u003d warningList.item(j);\n\n\t\t\t\t// Convert the node to an element.\n\t\t\t\tElement warningElement \u003d (Element) warning;\n\n\t\t\t\t// package which warning is in.\n\t\t\t\tString packageName \u003d warningElement.getAttribute(\"package\");\n\n\t\t\t\t// the ruleSet of warning.\n\t\t\t\tString ruleSet \u003d warningElement.getAttribute(\"ruleset\");\n\n\t\t\t\t// method of warning.\n\t\t\t\tString method \u003d warningElement.getAttribute(\"method\");\n\n\t\t\t\t// line number where the warning is located.\n\t\t\t\tint line \u003d Integer.parseInt(warningElement.getAttribute(\"beginline\"));\n\n\t\t\t\t// Get the category of the warning.\n\t\t\t\tString ruleName \u003d warningElement.getAttribute(\"rule\");\n\n\t\t\t\t// find the correct classification given the rule name and the rule set.\n\t\t\t\tString classification \u003d classify(ruleName);\n\t\t\t\t\n\t\t\t\t// replace the backward slash in the file name with file separator.\n\t\t\t\tString fileNWithSep \u003d fileName.replaceAll(\"\\\\\\\\\", Matcher.quoteReplacement(File.separator));\n\n\t\t\t\t// for-loop in stream, find correct filePath.\n\t\t\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(p -\u003e p.endsWith(fileNWithSep)).findFirst().get();\n\n\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\tString finalFileName \u003d fileNWithSep.substring(fileNWithSep.lastIndexOf(File.separatorChar) + 1, fileNWithSep.length());\n\n\t\t\t\t// Retrieve the message corresponds to this warning.\n\t\t\t\tString message \u003d fileElement.getElementsByTagName(\"violation\").item(j).getTextContent();\n\n\t\t\t\t// Add warning to the list of warnings.\n\t\t\t\tpmdWarnings.add(new PMDWarning(filePath, finalFileName, line, packageName, ruleSet, method, ruleName, message, classification));\n\t\t}\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\XMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.HashMap;\nimport java.util.List;\n\nimport javax.xml.parsers.DocumentBuilder;\nimport javax.xml.parsers.DocumentBuilderFactory;\n\nimport org.w3c.dom.Document;\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.warnings.Warning;\n\n/**\n * This class can be used to parse a XML file.\n * \n * @author BlueTurtle.\n *\n */\npublic abstract class XMLParser implements Parser {\n\n\tprivate static String mdFilePath \u003d \"./src/main/resources/asat-gdc-mapping.html\";\n\n\t/**\n\t * Parse a XML file.\n\t * \n\t * @param filePath\n\t *            the path to the file that needs to be parsed.\n\t * @return a list of warnings.\n\t */\n\tpublic abstract List\u003cWarning\u003e parseFile(String filePath);\n\n\t/**\n\t * Set up.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the CheckStyle report.\n\t * @return a list of files where there are warnings.\n\t */\n\tpublic NodeList setUp(String xmlFilePath) {\n\t\t// set up an empty list.\n\t\tNodeList nList \u003d null;\n\t\ttry {\n\t\t\t// Instantiate things that are necessary for the parser.\n\t\t\tFile inputFile \u003d new File(xmlFilePath);\n\t\t\tDocumentBuilderFactory dbFactory \u003d DocumentBuilderFactory.newInstance();\n\t\t\tDocumentBuilder dBuilder \u003d dbFactory.newDocumentBuilder();\n\n\t\t\t// Parse the file.\n\t\t\tDocument doc \u003d dBuilder.parse(inputFile);\n\n\t\t\t// Normalize the elements of the document.\n\t\t\tdoc.getDocumentElement().normalize();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tnList \u003d doc.getElementsByTagName(\"file\");\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\n\t\treturn nList;\n\t}\n\n\t/**\n\t * Classify the rule name to the correct classification according to\n\t * categoryInfo.\n\t * \n\t * @param ruleName\n\t *            the violated rule name of the warning.\n\t *\n\t * @return the category of a warning(based on the GDC).\n\t */\n\tpublic static String classify(String ruleName) {\n\t\tGDCParser gp \u003d GDCParser.getInstance();\n\t\tgp.parseFile(mdFilePath);\n\t\tHashMap\u003cString, String\u003e categoryInfo \u003d GDCParser.getCategoryInfo();\n\t\tString finalRuleName \u003d categoryInfo.keySet().stream().filter(p -\u003e p.endsWith(ruleName)).findFirst().get();\n\t\treturn categoryInfo.get(finalRuleName);\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\summarizers\\ComponentSummarizer.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class can be used to summarise the warnings for a specific component.\n * \n * @author BlueTurtle.\n *\n */\npublic class ComponentSummarizer extends Summarizer {\n\n\t@Getter\n\tprivate String fileName;\n\t@Getter\n\tprivate String filePath;\n\t@Getter\n\tprivate List\u003cWarning\u003e warningList;\n\t@Getter\n\tprivate int loc;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param fileName\n\t *            the name of the component.\n\t * @param filePath\n\t *            the path to the component.\n\t * @param packageName\n\t *            the name of the package where the component is from.\n\t */\n\tpublic ComponentSummarizer(String fileName, String filePath, String packageName) {\n\t\tsuper(packageName);\n\t\tthis.fileName \u003d fileName;\n\t\tthis.filePath \u003d filePath;\n\t\tthis.loc \u003d ProjectInfoFinder.getClassLocs().get(filePath);\n\t\tthis.warningList \u003d new ArrayList\u003cWarning\u003e();\n\t}\n\n\t/**\n\t * Summarise the warnings.\n\t * \n\t * @param warnings\n\t *            the list of warnings to be summarized.\n\t */\n\t@Override\n\tpublic void summarise(List\u003cWarning\u003e warnings) {\n\t\tfor (Warning w : warnings) {\n\n\t\t\tString pn \u003d ProjectInfoFinder.getClassPackage().get(w.getFilePath());\n\t\t\tif (w.getFileName().equals(getFileName()) \u0026\u0026 pn.equals(getPackageName())) {\n\t\t\t\tString warningType \u003d w.getType();\n\t\t\t\tif (!warningTypes.contains(warningType)) {\n\t\t\t\t\twarningTypes.add(w.getType());\n\t\t\t\t}\n\t\t\t\twarningList.add(w);\n\t\t\t\tincrementNumberOfWarnings(ASAT.valueOf(warningType));\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\t/**\n\t * Check whether two ComponentSummarizer are equal.\n\t * \n\t * @param other\n\t *            the other ComponentSummarizer.\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof ComponentSummarizer)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tComponentSummarizer that \u003d (ComponentSummarizer) other;\n\n\t\treturn (packageName.equals(that.packageName) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 filePath.equals(that.filePath)\n\t\t\t\t\u0026\u0026 warningList.equals(that.warningList) \u0026\u0026 numberOfWarnings \u003d\u003d that.numberOfWarnings\n\t\t\t\t\u0026\u0026 warningTypes.equals(that.warningTypes));\n\n\t}\n\n\t/**\n\t * HashCode for ComponentSummarizer.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(packageName, fileName, filePath, warningList, numberOfWarnings, warningTypes);\n\t}\n\n\t/**\n\t * toString method for ComponentSummarizer.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"ComponentSummarizer [fileName\u003d\" + fileName + \", filePath\u003d\" + filePath + \", warningList\u003d\" + warningList\n\t\t\t\t+ \", loc\u003d\" + loc + \", packageName\u003d\" + packageName + \", numberOfWarnings\u003d\" + numberOfWarnings\n\t\t\t\t+ \", warningTypes\u003d\" + warningTypes + \", numberOfCheckStyleWarnings\u003d\" + numberOfCheckStyleWarnings\n\t\t\t\t+ \", numberOfPMDWarnings\u003d\" + numberOfPMDWarnings + \", numberOfFindBugsWarnings\u003d\"\n\t\t\t\t+ numberOfFindBugsWarnings + \"]\";\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\summarizers\\PackageSummarizer.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map.Entry;\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class summarises the warnings of a specific package.\n * \n * @author BlueTurtle.\n *\n */\npublic class PackageSummarizer extends Summarizer {\n\n\t@Getter private List\u003cComponentSummarizer\u003e classes;\n\t@Getter private int numberOfClasses;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param packageName\n\t *            the name of the package.\n\t */\n\tpublic PackageSummarizer(String packageName) {\n\t\tsuper(packageName);\n\t\tthis.classes \u003d new ArrayList\u003cComponentSummarizer\u003e();\n\t\tthis.numberOfClasses \u003d 0;\n\t}\n\n\t/**\n\t * Summarise the warnings for this package.\n\t * \n\t * @param warnings\n\t *            list of warnings.\n\t */\n\t@Override\n\tpublic void summarise(List\u003cWarning\u003e warnings) {\n\t\tHashMap\u003cString, String\u003e classesInfo \u003d findOwnClasses(warnings);\n\t\t\n\t\tfor (Entry\u003cString, String\u003e ci : classesInfo.entrySet()) {\n\t\t\tComponentSummarizer cs \u003d new ComponentSummarizer(ci.getKey(), ci.getValue(), packageName);\n\t\t\tcs.summarise(warnings);\n\t\t\tclasses.add(cs);\n\t\t\twarningTypes.addAll(cs.getWarningTypes());\n\t\t\tnumberOfWarnings +\u003d cs.getNumberOfWarnings();\n\t\t\tnumberOfCheckStyleWarnings +\u003d cs.getNumberOfCheckStyleWarnings();\n\t\t\tnumberOfPMDWarnings +\u003d cs.getNumberOfPMDWarnings();\n\t\t\tnumberOfFindBugsWarnings +\u003d cs.getNumberOfFindBugsWarnings();\n\t\t\tnumberOfClasses++;\n\t\t}\n\t\t\n\t}\n\n\t/**\n\t * Find the classes that belongs to this package.\n\t * \n\t * @param warnings\n\t *            the list of warnings.\n\t * @return a HashMap containing the classes and their file path that is from\n\t *         this package.\n\t */\n\tpublic HashMap\u003cString, String\u003e findOwnClasses(List\u003cWarning\u003e warnings) {\n\t\tHashMap\u003cString, String\u003e ownClasses \u003d new HashMap\u003cString, String\u003e();\n\t\t\n\t\tfor (Warning w : warnings) {\n\t\t\tString fileName \u003d w.getFileName();\n\t\t\tString filePath \u003d w.getFilePath();\n\n\t\t\tif (ProjectInfoFinder.getClassPackage().get(filePath).equals(packageName)\n\t\t\t\t\t\u0026\u0026 !ownClasses.containsKey(fileName)) {\n\t\t\t\townClasses.put(fileName, filePath);\n\t\t\t}\n\n\t\t}\n\n\t\treturn ownClasses;\n\t}\n\n\t/**\n\t * Check whether two PackageSummarizer are equal.\n\t * \n\t * @param other\n\t *            the other PacakgeSummarizer.\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof PackageSummarizer)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tPackageSummarizer that \u003d (PackageSummarizer) other;\n\n\t\treturn (packageName.equals(that.packageName) \u0026\u0026 numberOfWarnings \u003d\u003d that.numberOfWarnings\n\t\t\t\t\u0026\u0026 classes.equals(that.classes) \u0026\u0026 warningTypes.equals(that.warningTypes));\n\n\t}\n\n\t/**\n\t * HashCode for PackageSummarizer.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(packageName, numberOfWarnings, classes, warningTypes);\n\t}\n\t\n\t/**\n\t * toString method for PackageSummarizer.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"PackageSummarizer [classes\u003d\" + classes + \", numberOfClasses\u003d\" + numberOfClasses + \", packageName\u003d\"\n\t\t\t\t+ packageName + \", numberOfWarnings\u003d\" + numberOfWarnings + \", warningTypes\u003d\" + warningTypes\n\t\t\t\t+ \", numberOfCheckStyleWarnings\u003d\" + numberOfCheckStyleWarnings + \", numberOfPMDWarnings\u003d\"\n\t\t\t\t+ numberOfPMDWarnings + \", numberOfFindBugsWarnings\u003d\" + numberOfFindBugsWarnings + \"]\";\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\summarizers\\Summarizer.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport java.util.HashSet;\nimport java.util.List;\nimport java.util.Set;\n\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class can be used to summarize warnings.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:visibilitymodifier\")\npublic abstract class Summarizer {\n\t\n\n\t@Getter protected String packageName;\n\t@Getter protected int numberOfWarnings;\n\t@Getter protected Set\u003cString\u003e warningTypes;\n\t@Getter protected int numberOfCheckStyleWarnings;\n\t@Getter protected int numberOfPMDWarnings;\n\t@Getter protected int numberOfFindBugsWarnings;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param packageName\n\t *            the name of the package that the summarizer is working on.\n\t */\n\tpublic Summarizer(String packageName) {\n\t\tthis.packageName \u003d packageName;\n\t\tthis.warningTypes \u003d new HashSet\u003cString\u003e();\n\t\tthis.numberOfWarnings \u003d 0;\n\t\tthis.numberOfCheckStyleWarnings \u003d 0;\n\t\tthis.numberOfPMDWarnings \u003d 0;\n\t\tthis.numberOfFindBugsWarnings \u003d 0;\n\t}\n\n\t/**\n\t * Increment the number of warnings.\n\t * \n\t * @param type\n\t *            the type of the warning.\n\t */\n\tpublic void incrementNumberOfWarnings(ASAT type) {\n\t\tswitch (type) {\n\t\tcase CheckStyle:\n\t\t\tnumberOfCheckStyleWarnings++;\n\t\t\tnumberOfWarnings++;\n\t\t\tbreak;\n\t\tcase PMD:\n\t\t\tnumberOfPMDWarnings++;\n\t\t\tnumberOfWarnings++;\n\t\t\tbreak;\n\t\tcase FindBugs:\n\t\t\tnumberOfFindBugsWarnings++;\n\t\t\tnumberOfWarnings++;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\t// Unreachable\n\t\t\tthrow new IllegalArgumentException(\"This is not a right type of warning\");\n\t\t}\n\t}\n\n\t/**\n\t * Summarise the result of the warnings.\n\t * \n\t * @param warnings\n\t *            the list of warnings to be summarized.\n\t */\n\tpublic abstract void summarise(List\u003cWarning\u003e warnings);\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\CodeFile.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.BufferedReader;\nimport java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * Represents a file of code on the system. Consists of two strings:\n * the path to the file and the contents of the file. \n * @author michiel\n *\n */\npublic class CodeFile {\n\t@Getter @Setter private String path; //NOPMD - Warning caused by lombok.\n\t@Getter @Setter private String code \u003d \"\"; //NOPMD - Warning caused by lombok.\n\t\n\t/**\n\t * Reads the code from a file and saves it in the code field.\n\t * @param file \n\t * \t\t\tfile to read from.\n\t * @throws IOException\n\t * \t\t\tif file is not found, inaccessible, etc.\n\t */\n\tpublic void getCodeFromFile(File file) throws IOException {\n\t\tBufferedReader reader \u003d new BufferedReader(new FileReader(file));\n\n\t\tString nextLine;\n\t\tStringBuilder stringBuilder \u003d new StringBuilder();\n\t\tstringBuilder.append(\u0027\"\u0027);\n\t\twhile ((nextLine \u003d reader.readLine()) !\u003d null) {\n\t\t\tstringBuilder.append(nextLine);\n\t\t\tstringBuilder.append(\u0027\\n\u0027);\n\t\t}\n\t\tstringBuilder.append(\u0027\"\u0027);\n\t\tsetCode(stringBuilder.toString());\n\t\treader.close();\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\Controller.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.IOException;\n\n/**\n * The controller interface.\n * \n * @author BlueTurtle.\n *\n */\npublic interface Controller {\n\n\t/**\n\t * Execute controller.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered during\n\t *             execution.\n\t */\n\tvoid execute() throws IOException;\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\JavaController.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.IOException;\nimport java.util.ArrayList;\n\nimport BlueTurtle.gui.GUIController.ASAT;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * JavaController controls the analyser to make it analyse java code. It\n * constructs an AnalyserCommand for every ASAT which has to be run and passes\n * this to the analyser.\n * \n * @author BlueTurtle.\n *\n */\npublic class JavaController implements Controller {\n\t\n\t@Getter @Setter private static String userDir \u003d System.getProperty(\"user.dir\"); //NOPMD - caused by lombok.\n\t@Getter @Setter private static ArrayList\u003cString\u003e checkStyleOutputFiles; //NOPMD - caused by lombok.\n\t@Getter @Setter private static ArrayList\u003cString\u003e pmdOutputFiles; //NOPMD - caused by lombok.\n\t@Getter @Setter private static ArrayList\u003cString\u003e findBugsOutputFiles; //NOPMD - caused by lombok.\n\n\t/**\n\t * Execute controller. A command is constructed for every ASAT which needs\n\t * to be run.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered when\n\t *             executing the commands.\n\t */\n\tpublic void execute() throws IOException {\n\t\tnew JSONFormatter().format();\n\t}\n\t\n\t/**\n\t * Set the output paths for the ASAT.\n\t * \n\t * @param asat\n\t *            the ASAT type.\n\t * @param filePaths\n\t *            the list of output file paths.\n\t */\n\tpublic static void setASATOutputFiles(ASAT asat, ArrayList\u003cString\u003e filePaths) {\n\t\tif (filePaths \u003d\u003d null) {\n\t\t\treturn;\n\t\t}\n\t\tswitch (asat) {\n\t\tcase PMD:\n\t\t\tpmdOutputFiles \u003d filePaths;\n\t\t\tbreak;\n\t\tcase CheckStyle:\n\t\t\tcheckStyleOutputFiles \u003d filePaths;\n\t\t\tbreak;\n\t\tcase FindBugs:\n\t\t\tfindBugsOutputFiles \u003d filePaths;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\JSONFormatter.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\nimport BlueTurtle.groupers.WarningGrouper;\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.parsers.CheckStyleXMLParser;\nimport BlueTurtle.parsers.FindBugsXMLParser;\nimport BlueTurtle.parsers.PMDXMLParser;\nimport BlueTurtle.parsers.XMLParser;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.Warning;\nimport BlueTurtle.writers.JSWriter;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * JSONFormatter reads the output of Checkstyle, Findbugs and PMD and produces a\n * summarized defect output.\n * \n * @author BlueTurtle.\n *\n */\npublic class JSONFormatter {\n\t@Getter @Setter private List\u003cWarning\u003e totalWarnings \u003d new ArrayList\u003cWarning\u003e();\n\n\t/**\n\t * Produces a list of warnings for by reading the output of PMD, Checkstyle\n\t * and Findbugs. Then converts it to JSON format and writes it to a\n\t * JavaScript file.\n\t * \n\t * @throws IOException\n\t *             File not found.\n\t */\n\tpublic void format() throws IOException {\n\t\t\t\t\n\t\tparseListOfFiles(new CheckStyleXMLParser(), JavaController.getCheckStyleOutputFiles());\n\n\t\tparseListOfFiles(new PMDXMLParser(), JavaController.getPmdOutputFiles());\n\n\t\tparseListOfFiles(new FindBugsXMLParser(), JavaController.getFindBugsOutputFiles());\n\t\t\n\t\twriteJSON();\n\t}\n\t\n\t/**\n\t * Parse the list of output files for an ASAT.\n\t * @param xmlParser \n\t * \t\t\t\tthe parser for parsing the xml files.\n\t * @param filePaths\n\t * \t\t\t\tthe list containing the paths of the output files of an ASAT.\n\t * @throws IOException \n\t * \t\t\t\tthrows an exception if problem is encountered while parsing the files.\n\t */\n\tprivate void parseListOfFiles(XMLParser xmlParser, ArrayList\u003cString\u003e filePaths) throws IOException {\n\t\tif (filePaths !\u003d null) {\n\t\t\tfor (String path : filePaths) {\n\t\t\t\tparseFile(xmlParser, path);\n\t\t\t}\n\t\t}\n\t}\n\n\t/**\n\t * Parse an single output file of an ASAT.\n\t * \n\t * @throws IOException\n\t *             Throws an exception if problem is encountered while parsing the file.\n\t */\n\tprivate void parseFile(XMLParser xmlParser, String filePath) throws IOException {\n\t\tif (!new File(filePath).exists()) {\n\t\t\treturn;\n\t\t}\n\t\ttotalWarnings.addAll(xmlParser.parseFile(filePath));\n\t}\n\n\t/**\n\t * Groups the warnings together by packages and writes it as JSON output to\n\t * a JavaScript file.\n\t * \n\t * @param warnings\n\t *            List of warnings to work with.\n\t * @throws IOException\n\t *             Output file not found.\n\t */\n\tprivate void writeJSON() throws IOException {\n\t\tWarningGrouper wg \u003d new WarningGrouper(totalWarnings);\n\t\tList\u003cSummarizer\u003e list \u003d wg.groupBy(Criteria.PACKAGES);\n\n\t\tJSWriter jwriter \u003d JSWriter.getInstance();\n\t\tjwriter.setSummarizedWarnings(list);\n\t\tjwriter.writeToJSFormat(\"visualization/JSON/outputWarningsJSON.js\");\t\n\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\Main.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.IOException;\n\n\nimport BlueTurtle.gui.GUI;\n\n/**\n * Main class to run the system.\n * \n * @author BlueTurtle.\n *\n */\npublic final class Main {\n\n\t/**\n\t * All the modes (programming languages).\n\t * \n\t * @author BlueTurtle.\n\t *\n\t */\n\tenum Mode {\n\t\tJAVA\n\t}\n\n\tprivate static Controller controller;\n\tprivate static Mode currentMode \u003d Mode.JAVA;\n\t\n\t/**\n\t * Private constructor for this utility class.\n\t */\n\tprivate Main() {\n\t\t// not called\n\t}\n\t\n\t/**\n\t * Main method.\n\t * \n\t * @param args\n\t *            the arguments.\n\t * @throws IOException\n\t *             throws an exception if a problem is encountered during the\n\t *             execution of the controller.\n\t */\n\tpublic static void main(String[] args) throws IOException {\n\n\t\tswitch (currentMode) {\n\t\tcase JAVA:\n\t\t\tcontroller \u003d new JavaController();\n\t\t\tGUI gui \u003d new GUI();\n\t\t\tgui.startGUI();\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t\tSystem.out.println(\"Done.\");\n\t}\n\n\t/**\n\t * Run compute all the necessary information needed for the visualization.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while computing\n\t *             the information.\n\t */\n\tpublic static void runVisualization() throws IOException {\n\t\tcontroller.execute();\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\CheckStyleWarning.java",
    "code": "\"package BlueTurtle.warnings;\n\n/**\n * This class is used to represent a checkstyle warning.\n * \n * @author BlueTurtle.\n *\n */\npublic class CheckStyleWarning extends Warning {\n\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param message\n\t *            the message of the warning.\n\t * \n\t * @param ruleName\n\t *            the rule name of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t */\n\tpublic CheckStyleWarning(String filePath, String filename, int line, String message, String ruleName, String classification) {\n\t\tsuper(filePath, filename, line, \"CheckStyle\", ruleName, message, classification);\n\t\tsetMessage(message.replaceAll(\"\u0027\", \"\"));\n\t}\n\n\t/**\n\t * Check whether two CheckStyle warnings are the same.\n\t * \n\t * @param other\n\t *            the other warning.\n\t * @return a boolean\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof CheckStyleWarning)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tCheckStyleWarning that \u003d (CheckStyleWarning) other;\n\n\t\t// fixed SimplifyBooleanReturn, Conditional logic can be removed.\n\t\treturn (ruleName.equals(that.ruleName) \u0026\u0026 filePath.equals(that.filePath) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 line \u003d\u003d that.line\n\t\t\t\t\u0026\u0026 message.equals(that.message) \u0026\u0026 classification.equals(that.classification) \u0026\u0026 type.equals(that.type));\n\n\t}\n\n\t/**\n\t * HashCode for the CheckStyle Warning.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(filePath, fileName, type, line, message, ruleName, classification);\n\t}\n\t\n\t/**\n\t * toString method for CheckStylWarning.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"CheckStyleWarning [line\u003d\" + line + \", message\u003d\" + message + \", classification\u003d\" + classification\n\t\t\t\t+ \", fileName\u003d\" + fileName + \", type\u003d\" + type + \", filePath\u003d\" + filePath + \", ruleName\u003d\" + ruleName\n\t\t\t\t+ \"]\";\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\FindBugsWarning.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class is used to represent a FindBugs warning.\n * \n * @author BlueTurtle.\n *\n */\npublic class FindBugsWarning extends Warning {\n\n\t\n\t@Getter @Setter private String category;\n\t@Getter @Setter private String priority;\n\n\t\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param message\n\t *            the message of the warning.\n\t * @param category\n\t *            the category of the warning.\n\t * @param priority\n\t *            the priority of the warning.            \n\t * @param ruleName\n\t *            the rule name of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t */\n\tpublic FindBugsWarning(String filePath, String filename, int line, String message, String category, String priority, String ruleName, String classification) {\n\t\tsuper(filePath, filename, line, \"FindBugs\", ruleName, message, classification);\n\t\tsetCategory(category);\n\t\tsetPriority(priority);\n\t}\n\t\n\n\t/**\n\t * Check whether two FindBugs warnings are the same.\n\t * \n\t * @param other\n\t *            the other warning.\n\t * @return a boolean\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof FindBugsWarning)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tFindBugsWarning that \u003d (FindBugsWarning) other;\n\n\t\treturn (filePath.equals(that.filePath) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 line \u003d\u003d that.line\n\t\t\t\t\u0026\u0026 message.equals(that.message) \u0026\u0026 category.equals(that.category) \u0026\u0026 classification.equals(that.classification)\n\t\t\t\t\u0026\u0026 priority.equals(that.priority) \u0026\u0026 type.equals(that.type) \u0026\u0026 ruleName.equals(that.ruleName));\n\t}\n\t\n\t/**\n\t * HashCode for the FindBugsWarning.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(filePath, fileName, type, line, message, category, priority, ruleName, classification);\n\t}\n\t\n\t/**\n\t * toString method for FindBugsWarning.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"FindBugsWarning [lineNumber\u003d\" + line + \", message\u003d\" + message + \", category\u003d\" + category\n\t\t\t\t+ \", priority\u003d\" + priority + \", classification\u003d\"\n\t\t\t\t+ classification + \", fileName\u003d\" + fileName + \", type\u003d\" + type + \", filePath\u003d\" + filePath\n\t\t\t\t+ \", ruleName\u003d\" + ruleName + \"]\";\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\PMDWarning.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class is used to represent a PMD warning.\n * \n * @author BlueTurtle.\n *\n */\npublic class PMDWarning extends Warning {\n\n\t@Getter @Setter private String ruleSet;\n\t@Getter @Setter private String method;\n\t@Getter @Setter private String packageName;\n\t\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param packageName\n\t *            the package of the warning.\n\t * @param ruleName\n\t *            the rule name of the warning.\n\t * @param ruleSet\n\t *            the ruleSet of the warning.\n\t * @param method\n\t *            the method of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t * @param message\n\t * \t\t\t  the message of the warning.\n\t */\n\tpublic PMDWarning(String filePath, String filename, int line, String packageName, String ruleSet, String method,  String ruleName, String message, String classification) {\n\t\tsuper(filePath, filename, line, \"PMD\", ruleName, message, classification);\n\t\tsetPackageName(packageName);\n\t\tsetRuleSet(ruleSet);\n\t\tsetMethod(method);\n\t}\n\n\t/**\n\t * Check whether two PMD warnings are the same.\n\t * \n\t * @param other\n\t *            the other warning.\n\t * @return a boolean\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof PMDWarning)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tPMDWarning that \u003d (PMDWarning) other;\n\n\t\treturn (filePath.equals(that.filePath) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 line \u003d\u003d that.line \u0026\u0026 message.equals(that.message)\n\t\t\t\t\u0026\u0026 classification.equals(that.classification) \u0026\u0026 packageName.equals(that.packageName) \u0026\u0026 type.equals(that.type) \n\t\t\t\t\u0026\u0026 ruleSet.equals(that.ruleSet) \u0026\u0026 method.equals(that.method) \u0026\u0026 ruleName.equals(that.ruleName));\n\t}\n\t\n\t/**\n\t * HashCode for the CheckStyle Warning.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(filePath, fileName, type, line, packageName, ruleSet, method, ruleName, message, classification);\n\t}\n\t\n\t/**\n\t * toString method for PMDWarning.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"PMDWarning [line\u003d\" + line + \", ruleSet\u003d\" + ruleSet + \", method\u003d\" + method + \", packageName\u003d\"\n\t\t\t\t+ packageName + \", classification\u003d\" + classification + \", fileName\u003d\" + fileName + \", type\u003d\" + type\n\t\t\t\t+ \", filePath\u003d\" + filePath + \", message\u003d\" + message + \", ruleName\u003d\" + ruleName + \"]\";\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\Warning.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class is used to represent a warning.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:visibilitymodifier\")\npublic abstract class Warning {\n\n\t@Getter @Setter protected String classification;\n\t@Getter @Setter protected String fileName;\n\t@Getter @Setter protected String type;\n\t@Getter @Setter protected String filePath;\n\t@Getter @Setter protected String ruleName;\n\t@Getter @Setter protected String message;\n\t@Getter @Setter protected int line;\n\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param type\n\t *            the type of the warning e.g. PMD.\n\t * @param ruleName\n\t *            the violated rule name of the warning.\n\t * @param message\n\t *            the message of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t */\n\tpublic Warning(String filePath, String filename, int line, String type, String ruleName, String message, String classification) {\n\t\tsetFileName(filename);\n\t\tsetFilePath(filePath);\n\t\tsetLine(line);\n\t\tsetType(type);\n\t\tsetRuleName(ruleName);\n\t\tsetClassification(classification); \n\t\tsetMessage(message);\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\writers\\JSWriter.java",
    "code": "\"package BlueTurtle.writers;\n\nimport java.io.BufferedWriter;\nimport java.io.File;\nimport java.io.FileWriter;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport com.google.gson.Gson;\nimport com.google.gson.GsonBuilder;\n\nimport BlueTurtle.TSE.CodeFile;\nimport BlueTurtle.gui.GUIController;\nimport BlueTurtle.summarizers.Summarizer;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class can be used to write the output of the analyzer to JavaScript\n * format.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:nowhitespacebefore\")\npublic final class JSWriter {\n\n\tprivate static JSWriter jsWriter \u003d null;\n\n\t@Getter @Setter private List\u003cSummarizer\u003e summarizedWarnings;\n\n\t/**\n\t * Constructor. Only this class can instantiate itself.\n\t */\n\tprivate JSWriter() {\n\t}\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of this class.\n\t */\n\tpublic static synchronized JSWriter getInstance() {\n\t\tif (jsWriter \u003d\u003d null) {\n\t\t\tjsWriter \u003d new JSWriter();\n\t\t}\n\t\treturn jsWriter;\n\t}\n\n\t/**\n\t * Write the summarized warnings to a file in JavaScript format.\n\t * \n\t * @param outputFilePath\n\t *            path to write the output to.\n\t * @throws IOException\n\t *             throws an exception if something went wrong in the process of\n\t *             writing to file.\n\t */\n\tpublic void writeToJSFormat(String outputFilePath) throws IOException {\n\t\tBufferedWriter writer \u003d new BufferedWriter(new FileWriter(outputFilePath));\n\t\tGson gson \u003d new GsonBuilder().setPrettyPrinting().create();\n\t\tString json \u003d gson.toJson(summarizedWarnings) + \u0027;\u0027;\n\t\twriter.write(\"var inputData \u003d \");\n\t\twriter.newLine();\n\t\twriter.write(json);\n\t\twriter.newLine();\n\t\twriter.write(\"var projectName \u003d \" + \u0027\"\u0027 + GUIController.getProjectPath().substring(\n\t\t\t\tGUIController.getProjectPath().lastIndexOf(File.separator) + 1,\n\t\t\t\tGUIController.getProjectPath().length()) + \u0027\"\u0027 + \u0027;\u0027) ;\n\t\twriter.flush();\n\t\twriter.close();\n\t}\n\n\t/**\n\t * Write the codefiles as JSON to a javascript file.\n\t * \n\t * @param codeFiles\n\t *            codefiles to write.\n\t * @param outputFilePath\n\t *            file to write to.\n\t * @throws IOException\n\t *             if outputfile is not found, inaccessible, etc.\n\t */\n\tpublic void writeSourceCodeToJS(ArrayList\u003cCodeFile\u003e codeFiles, String outputFilePath) throws IOException {\n\t\tBufferedWriter writer \u003d new BufferedWriter(new FileWriter(outputFilePath));\n\t\tGson gson \u003d new GsonBuilder().setPrettyPrinting().create();\n\t\tString json \u003d gson.toJson(codeFiles) + \u0027;\u0027;\n\t\twriter.write(\"var codeExport \u003d \");\n\t\twriter.newLine();\n\t\twriter.write(json);\n\t\twriter.flush();\n\t\twriter.close();\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\resources\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\resources\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\resources\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\computers\\LOCComputerTest.java",
    "code": "\"package BlueTurtle.computers;\n\nimport static org.junit.Assert.assertSame;\n\nimport java.io.IOException;\n\nimport org.junit.Test;\n\n/**\n * Test for LOCFinder class.\n * \n * @author BlueTurtle.\n *\n */\npublic class LOCComputerTest {\n\n\t/**\n\t * Test that the right right number of lines is found from the file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t * \n\t */\n\t@Test\n\tpublic void testRightLOCFound() throws IOException {\n\t\tint numLines \u003d LOCComputer.getInstance().computeLOC(\"./src/test/resources/DefaultClass.java\");\n\t\tassertSame(5, numLines);\n\t}\n\n\t/**\n\t * Test finding the right number of lines is found in another file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testFindingLOCOnDifferentFile() throws IOException {\n\t\tint numLines \u003d LOCComputer.getInstance().computeLOC(\"./src/test/resources/ExampleTestClass.java\");\n\t\tassertSame(6, numLines);\n\t}\n\n\t/**\n\t * Test finding LOC in a non existing file should return zero.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test(expected \u003d IOException.class)\n\tpublic void testFindingLOCInNonExistingFile() throws IOException {\n\t\tint zero \u003d LOCComputer.getInstance().computeLOC(\"./NonExistingClass.java\");\n\t\tassertSame(0, zero);\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\finders\\PackageNameFinderTest.java",
    "code": "\"package BlueTurtle.finders;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\n\nimport java.io.IOException;\n\nimport org.junit.Test;\n\n/**\n * Test for PackageNameFinder class.\n * \n * @author BlueTurtle.\n *\n */\npublic class PackageNameFinderTest {\n\n\t/**\n\t * Test that the right package name is found from the file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testRightPackageNameFound() throws IOException {\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(\"./src/test/resources/ExampleClass.java\");\n\t\tassertEquals(\"SomePackage.subpackage\", packageName);\n\t}\n\n\t/**\n\t * Test finding the package name in another file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testFindingPackageNameOnDifferentFile() throws IOException {\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(\"./src/test/resources/ExampleTestClass.java\");\n\t\tassertNotEquals(\"SomePackage.subpackage\", packageName);\n\t}\n\n\t/**\n\t * Testing class that is in the default package.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testClassInDefaultPackage() throws IOException {\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(\"./src/test/resources/DefaultClass.java\");\n\t\tassertEquals(\"default\", packageName);\n\t}\n\n\t/**\n\t * Test finding package name in a non-existing file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test(expected \u003d IOException.class)\n\tpublic void testFindingNameInNonExistingFile() throws IOException {\n\t\tPackageNameFinder.getInstance().findPackageName(\"./NonExstingFile.java\");\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\finders\\ProjectInfoFinderTest.java",
    "code": "\"package BlueTurtle.finders;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertFalse;\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Paths;\nimport java.util.HashSet;\nimport java.util.Set;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\n/**\n * Test for the ProjectInforFinder class.\n * \n * @author BlueTurtle.\n *\n */\npublic class ProjectInfoFinderTest {\n\n\tprivate ProjectInfoFinder pif;\n\tprivate String exampleFilePath;\n\n\t/**\n\t * Initialize the objects that are needed.\n\t * \n\t * @throws Exception\n\t *             throws an exception if problem is encountered while\n\t *             instantiating the objects.\n\t */\n\t@Before\n\tpublic void setUp() throws Exception {\n\t\tpif \u003d new ProjectInfoFinder();\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getOutputFilesPaths().clear();\n\t\texampleFilePath \u003d Paths.get(\"src\", \"test\", \"resources\", \"TestCodeFolder\", \"AllClosestPoints.java\")\n\t\t\t\t.toAbsolutePath().toString();\n\t\tpif.findFiles(new File(Paths.get(\"src\", \"test\", \"resources\").toAbsolutePath().toString()));\n\t}\n\n\t/**\n\t * Cleanup the fields of ProjectInfoFinder used for testing.\n\t * \n\t * @throws Exception\n\t *             throws an exception if problem is encountered while cleaning\n\t *             up the attributes.\n\t */\n\t@After\n\tpublic void cleanUp() throws Exception {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getOutputFilesPaths().clear();\n\t}\n\n\t/**\n\t * Test finding files does not give an empty list of paths.\n\t * \n\t */\n\t@Test\n\tpublic void testFindFilesNonEmptyListOfPaths() {\n\t\tassertFalse(ProjectInfoFinder.getClassPaths().isEmpty());\n\t}\n\n\t/**\n\t * Test that the right package name is returned given a path to a file.\n\t * \n\t */\n\t@Test\n\tpublic void testRightPackageNameForPathIsReturned() {\n\t\tString packageName \u003d ProjectInfoFinder.getClassPackage().get(exampleFilePath);\n\t\tassertEquals(\"default\", packageName);\n\t}\n\n\t/**\n\t * Test that the right loc is returned given path.\n\t * \n\t */\n\t@Test\n\tpublic void testRightLOCForPathIsReturned() {\n\t\tint actual \u003d ProjectInfoFinder.getClassLocs().get(exampleFilePath);\n\t\tassertEquals(272, actual);\n\t}\n\n\t/**\n\t * Test that the right set of packages names is returned given path.\n\t * \n\t */\n\t@Test\n\tpublic void testRightSetOfPackagesIsReturned() {\n\t\tSet\u003cString\u003e actual \u003d ProjectInfoFinder.getPackages();\n\t\tSet\u003cString\u003e expected \u003d new HashSet\u003cString\u003e();\n\t\texpected.add(\"default\");\n\t\texpected.add(\"SomePackage.different\");\n\t\texpected.add(\"SomePackage.subpackage\");\t\t\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test retrieveCodeFiles method. At least one instance of CodeFile should be added to codeFiles field.\n\t * @throws IOException\n\t * \t\t\t\tif file is not found, inaccessible, etc.\n\t */\n\t@Test\n\tpublic void testRetrieveCodeFiles() throws IOException {\n\t\tpif.retrieveCodeFiles();\n\t\tassertTrue(pif.getCodeFiles().size() \u003e 0);\n\t}\n\t\n\t\n\t/**\n\t * Test the correct behaviour of checkForOutputFile.\n\t */\n\t@Test\n\tpublic void testCheckForOutputFileTrue() {\n\t\tassertTrue(new ProjectInfoFinder().checkForASATOutputFile(\"checkstyle-result.xml\"));\n\t}\n\t\n\t/**\n\t * Test the correct behaviour of checkForOutputFile.\n\t */\n\t@Test\n\tpublic void testCheckForOutputFileFalse() {\n\t\tassertFalse(new ProjectInfoFinder().checkForASATOutputFile(\"Hello I am a test string\"));\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\groupers\\WarningGrouperTest.java",
    "code": "\"package BlueTurtle.groupers;\n\nimport static org.junit.Assert.assertNull;\nimport static org.junit.Assert.assertTrue;\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertFalse;\nimport static org.junit.Assert.assertNotEquals;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Paths;\nimport java.util.ArrayList;\nimport java.util.EnumMap;\nimport java.util.List;\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.summarizers.ComponentSummarizer;\nimport BlueTurtle.summarizers.PackageSummarizer;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Tests for the WarningGrouper class.\n * \n * @author BlueTurtle.\n *\n */\npublic class WarningGrouperTest {\n\n\tprivate ComponentSummarizer cs;\n\tprivate ComponentSummarizer cs2;\n\tprivate ComponentSummarizer cs3;\n\tprivate ComponentSummarizer cs4;\n\tprivate PackageSummarizer ps;\n\tprivate PackageSummarizer ps2;\n\tprivate List\u003cWarning\u003e warnings;\n\tprivate Warning w;\n\tprivate Warning w2;\n\tprivate Warning w3;\n\tprivate Warning w4;\n\n\t/**\n\t * Initialize necessary objects.\n\t * \n\t * @throws IOException\n\t *             throws an exception if there problem was encountered while\n\t *             reading file.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\tString filePath \u003d Paths.get(\"src\", \"test\", \"resources\", \"ExampleClass.java\").toAbsolutePath().toString();\n\t\tString filePath2 \u003d Paths.get(\"src\", \"test\", \"resources\", \"ExampleTestClass.java\").toAbsolutePath().toString();\n\t\tString filePath3 \u003d Paths.get(\"src\", \"test\", \"resources\", \"TestCodeFolder\", \"AllClosestPoints.java\").toAbsolutePath().toString();\n\t\tString filePath4 \u003d Paths.get(\"src\", \"test\", \"resources\", \"DefaultClass.java\").toAbsolutePath().toString();\n\t\tw \u003d new CheckStyleWarning(filePath, \"ExampleClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw2 \u003d new CheckStyleWarning(filePath2, \"ExampleTestClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw3 \u003d new CheckStyleWarning(filePath3, \"AllClosestPoints.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw4 \u003d new CheckStyleWarning(filePath4, \"DefaultClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tcs \u003d new ComponentSummarizer(\"ExampleClass.java\", filePath, \"SomePackage.subpackage\");\n\t\tcs2 \u003d new ComponentSummarizer(\"ExampleTestClass.java\", filePath2, \"SomePackage.different\");\n\t\tcs3 \u003d new ComponentSummarizer(\"AllClosestPoints.java\", filePath3, \"default\");\n\t\tcs4 \u003d new ComponentSummarizer(\"DefaultClass.java\", filePath4, \"default\");\n\t\tps \u003d new PackageSummarizer(\"SomePackage.subpackage\");\n\t\tps2 \u003d new PackageSummarizer(\"SomePackage.different\");\n\t\twarnings \u003d new ArrayList\u003cWarning\u003e();\n\t\twarnings.add(w);\n\t\twarnings.add(w2);\n\t\twarnings.add(w3);\n\t\twarnings.add(w4);\t\t\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanAttributes() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t}\n\n\t/**\n\t * Test group by default case.\n\t */\n\t@Test\n\tpublic void testGroupByDefaultCase() {\n\t\tList\u003cWarning\u003e warnings \u003d new ArrayList\u003cWarning\u003e();\n\t\twarnings.add(w);\n\t\twarnings.add(w2);\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tassertNull(wg.groupBy(null));\n\t}\n\n\t/**\n\t * Test group by components.\n\t */\n\t@Test\n\tpublic void testGroupByComponents() {\n\t\tList\u003cSummarizer\u003e expected \u003d new ArrayList\u003cSummarizer\u003e();\n\t\tcs.summarise(warnings);\n\t\tcs2.summarise(warnings);\n\t\tcs3.summarise(warnings);\n\t\tcs4.summarise(warnings);\n\t\texpected.add(cs4);\n\t\texpected.add(cs);\n\t\texpected.add(cs2);\n\t\texpected.add(cs3);\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tassertTrue(expected.containsAll(wg.groupBy(Criteria.COMPONENTS)));\n\t}\n\n\t/**\n\t * Test group by packages.\n\t */\n\t@Test\n\tpublic void testGroupByPackages() {\n\t\tps.summarise(warnings);\n\t\tps2.summarise(warnings);\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tList\u003cSummarizer\u003e list \u003d wg.groupBy(Criteria.PACKAGES);\n\n\t\t// because the order of the set is not always the same.\n\t\tboolean answer \u003d list.contains(ps) \u0026\u0026 list.contains(ps2);\n\t\tassertTrue(answer);\n\t}\n\n\t/**\n\t * Test equals where both grouper are the same.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tWarningGrouper wg2 \u003d new WarningGrouper(warnings);\n\t\tassertEquals(wg, wg2);\n\t}\n\n\t/**\n\t * Test objects that are the same should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tWarningGrouper wg2 \u003d new WarningGrouper(warnings);\n\t\tassertEquals(wg.hashCode(), wg2.hashCode());\n\t}\n\n\t/**\n\t * Test equals where the warnings are different.\n\t */\n\t@Test\n\tpublic void testEqualsFalseDifferentWarningList() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(new ArrayList\u003cWarning\u003e());\n\t\tWarningGrouper wg2 \u003d new WarningGrouper(warnings);\n\t\tassertNotEquals(wg, wg2);\n\t}\n\n\t/**\n\t * Test equals with different object (that is not a grouper).\n\t */\n\t@Test\n\tpublic void testEqualsFalseDifferentObject() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tboolean answer \u003d wg.equals(Integer.valueOf(6));\n\t\tassertFalse(answer);\n\t}\n\n\t/**\n\t * Test summarizedWarnings.\n\t */\n\t@Test\n\tpublic void testSummarizedWarnings() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tEnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e empty \u003d new EnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e(Criteria.class);\n\t\tEnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e actual \u003d wg.getSummarizedWarnings();\n\t\tassertNotEquals(empty, actual);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\CheckStyleXMLParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.List;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test class for CheckStyleXMLParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class CheckStyleXMLParserTest {\n\n\tprivate static String testSet \u003d \"./src/test/resources/exampleCheckstyle1.xml\";\n\tprivate static String testSet2 \u003d \"./src/test/resources/exampleCheckstyle2.xml\";\n\tprivate static String srcDir \u003d System.getProperty(\"user.dir\") + \"/src\";\n\n\tprivate static String testSet2FileName \u003d \"Warning.java\";\n\tprivate static String testSet2Message \u003d \"Unused @param tag for \u0027filePath\u0027.\";\n\tprivate static String testSet2RuleName \u003d \"JavadocMethod\";\n\tprivate static String testSet2Classification \u003d \"Documentation Conventions\";\n\tprivate static String testSet3FilePath \u003d System.getProperty(\"user.dir\") + File.separatorChar + \"src\"\n\t\t\t+ File.separatorChar + \"main\" + File.separatorChar + \"java\" + File.separatorChar + \"BlueTurtle\"\n\t\t\t+ File.separatorChar + \"warnings\" + File.separatorChar + \"Warning.java\";\n\n\t/**\n\t * Set up the GDP parser, parse the category information.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is ecountered while reading\n\t *             the files.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tnew ProjectInfoFinder().findFiles(new File(srcDir));\n\t}\n\t\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanUp() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t}\n\n\t/**\n\t * Test that the parser can parse a valid CheckStyle output file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertSame(5, warnings.size());\n\t}\n\n\t/**\n\t * Test whether the getRuleName method works as it should.\n\t */\n\t@Test\n\tpublic void testGetRuleNameCorrectBehaviour() {\n\t\tString expected \u003d \"PackageName\";\n\t\tString actual \u003d CheckStyleXMLParser\n\t\t\t\t.getRuleName(\"com.puppycrawl.tools.checkstyle.checks.naming.PackageNameCheck\");\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(testSet3FilePath, testSet2FileName, 20, testSet2Message,\n\t\t\t\ttestSet2RuleName, testSet2Classification);\n\n\t\tCheckStyleWarning actual \u003d (CheckStyleWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test that the parser created the right amount of warnings.\n\t */\n\t@Test\n\tpublic void testCreateRightAmountOfWarnings() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertNotSame(6, warnings.size());\n\t}\n\n\t/**\n\t * Test whether the method work for another rule name.\n\t */\n\t@Test\n\tpublic void testGetRuleNameCorrectBehaviour2() {\n\t\tString expected \u003d \"PackageName\";\n\t\tString actual \u003d CheckStyleXMLParser\n\t\t\t\t.getRuleName(\"com.puppycrawl.tools.checkstyle.checks.naming.JavadocMethodCheck\");\n\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning2() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(testSet3FilePath, testSet2FileName, 21, testSet2Message,\n\t\t\t\ttestSet2RuleName, testSet2Classification);\n\n\t\tCheckStyleWarning actual \u003d (CheckStyleWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tString testSet3 \u003d \"/ex.xml\";\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet3);\n\n\t\tassertSame(0, warnings.size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\FindBugsXMLParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.List;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.FindBugsWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test class for FindBugsXMLParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class FindBugsXMLParserTest {\n\n\tprivate static String testSet2 \u003d \"./src/test/resources/exampleFindbugs1.xml\";\n\tprivate static String srcDir \u003d System.getProperty(\"user.dir\") + \"/src\";\n\n\tprivate static String testSet2FileName \u003d \"FindBugsWarning.java\";\n\tprivate static String testSet2RuleName \u003d \"HE_EQUALS_USE_HASHCODE\";\n\tprivate static String testSet2Message \u003d \"BlueTurtle.warnings.FindBugsWarning defines equals and uses Object.hashCode()\";\n\tprivate static String testSet2Category \u003d \"BAD_PRACTICE\";\n\tprivate static String testSet2Priority \u003d \"High\";\n\tprivate static String testSet2Classification \u003d \"Interface\";\n\tprivate static String testSet3FilePath \u003d System.getProperty(\"user.dir\") + File.separatorChar + \"src\"\n\t\t\t+ File.separatorChar + \"main\" + File.separatorChar + \"java\" + File.separatorChar + \"BlueTurtle\"\n\t\t\t+ File.separatorChar + \"warnings\" + File.separatorChar + \"FindBugsWarning.java\";\n\n\t/**\n\t * Set up the GDP parser, parse the category information.\n\t * \n\t * @throws IOException\n\t *             throws an exception while reading the files.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tnew ProjectInfoFinder().findFiles(new File(srcDir));\n\t}\n\n\t/**\n\t * Clear the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void tearDown() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\n\t}\n\n\t/**\n\t * Test that the parser can parse a valid FindBugs output file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tFindBugsXMLParser parser \u003d new FindBugsXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet2);\n\n\t\tassertSame(2, warnings.size());\n\t}\n\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning() {\n\t\tFindBugsXMLParser parser \u003d new FindBugsXMLParser();\n\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(testSet3FilePath, testSet2FileName, 47, testSet2Message,\n\t\t\t\ttestSet2Category, testSet2Priority, testSet2RuleName, testSet2Classification);\n\n\t\tFindBugsWarning actual \u003d (FindBugsWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tFindBugsXMLParser parser \u003d new FindBugsXMLParser();\n\n\t\tString testSet3 \u003d \"/ex.xml\";\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet3);\n\n\t\tassertSame(0, warnings.size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\GDCParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.util.HashMap;\n\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertTrue;\n\nimport org.junit.Test;\n\n/**\n * Test class for GDCParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class GDCParserTest {\n\n\tprivate static String testSet \u003d \"./src/test/resources/htmlExample.html\";\n\n\n\t/**\n\t * Test that the parser can parse a valid GDC html file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tGDCParser parser \u003d GDCParser.getInstance();\n\n\t\tHashMap\u003cString, String\u003e categoryInfo \u003d parser.parseFile(testSet);\n\n\t\tassertTrue(categoryInfo.containsValue(\"Naming Conventions\"));\n\t}\n\t\n\t/**\n\t * Test that the parser created the right amount of warnings.\n\t */\n\t@Test\n\tpublic void testCreateRightAmountOfWarnings() {\n\t\tGDCParser parser \u003d GDCParser.getInstance();\n\n\t\tHashMap\u003cString, String\u003e categoryInfo \u003d parser.parseFile(testSet);\n\n\t\tassertSame(2, categoryInfo.size());\n\t}\t\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tGDCParser parser \u003d GDCParser.getInstance();\n\t\t\n\t\tString testSet3 \u003d \"./src/test/resources/ex.xml\";\n\n\t\tHashMap\u003cString, String\u003e warnings \u003d parser.parseFile(testSet3);\n\t\t\n\t\tassertNotSame(6, warnings.size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\PMDXMLParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.List;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.PMDWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test class for PMDXMLParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class PMDXMLParserTest {\n\n\tprivate static String testSet \u003d \"./src/test/resources/examplePmd1.xml\";\n\tprivate static String testSet2 \u003d \"./src/test/resources/examplePmd2.xml\";\n\tprivate static String srcDir \u003d System.getProperty(\"user.dir\") + \"/src\";\n\n\tprivate static String testSetFileName \u003d \"CheckStyleWarning.java\";\n\tprivate static String testSetRuleName \u003d \"OverrideBothEqualsAndHashcode\";\n\tprivate static String testSetPackageName \u003d \"BlueTurtle.warnings\";\n\tprivate static String testSetRuleSet \u003d \"Basic\";\n\tprivate static String testSetMethod \u003d \"equals\";\n\tprivate static String testSetClassification \u003d \"Interface\";\n\tprivate static String testSetMessage \u003d \"\\nEnsure you override both equals() and hashCode()\\n\";\n\tprivate static String testSet3FilePath \u003d System.getProperty(\"user.dir\") + File.separatorChar + \"src\"\n\t\t\t+ File.separatorChar + \"main\" + File.separatorChar + \"java\" + File.separatorChar + \"BlueTurtle\"\n\t\t\t+ File.separatorChar + \"warnings\" + File.separatorChar + \"CheckStyleWarning.java\";\n\n\t/**\n\t * Set up the GDP parser, parse the category information.\n\t * \n\t * @throws IOException\n\t *             throws an exception if there was a problem found while\n\t *             reading the file.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tnew ProjectInfoFinder().findFiles(new File(srcDir));\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanUp() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t}\n\n\t/**\n\t * Test that the parser can parse a valid PMD output file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertSame(1, warnings.size());\n\t}\n\n\t// The PMD parser need to be fixed, the rule name need to be combined with\n\t// ruleset and rulename, basic.xml/OverrideBoth.\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tPMDWarning expected \u003d new PMDWarning(testSet3FilePath, testSetFileName, 43, testSetPackageName, testSetRuleSet,\n\t\t\t\ttestSetMethod, testSetRuleName, testSetMessage, testSetClassification);\n\n\t\tPMDWarning actual \u003d (PMDWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertEquals(expected.getMessage(), actual.getMessage());\n\t}\n\n\t/**\n\t * Test that the parser created the right amount of warnings.\n\t */\n\t@Test\n\tpublic void testCreateRightAmountOfWarnings() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertNotSame(6, warnings.size());\n\t}\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tString testSet3 \u003d \"/ex.xml\";\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet3);\n\n\t\tassertSame(0, warnings.size());\n\t}\n\n\t/**\n\t * Test that the XML parser classify method.\n\t */\n\t@Test\n\tpublic void testXMLParserClassify() {\n\t\tString classification \u003d XMLParser.classify(\"AbstractClassName\");\n\n\t\tassertEquals(\"Naming Conventions\", classification);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\summarizers\\ComponentSummarizerTest.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.FindBugsWarning;\nimport BlueTurtle.warnings.PMDWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test for the ComponentSummarizer class.\n * \n * @author BlueTurtle.\n *\n */\npublic class ComponentSummarizerTest {\n\n\tprivate String filePath;\n\tprivate String filePath2;\n\tprivate String fileName;\n\tprivate String packageName;\n\tprivate List\u003cWarning\u003e warningList;\n\tprivate Warning w;\n\tprivate List\u003cWarning\u003e warningList2;\n\tprivate Warning w2;\n\n\t/**\n\t * Initialize necessary objects.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\tfilePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\n\t\t\t\t\"src\" + File.separator + \"test\" + File.separator + \"resources\" + File.separator + \"ExampleClass.java\"))\n\t\t\t\t.findFirst().get();\n\t\tfilePath2 \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\"src\" + File.separator\n\t\t\t\t+ \"test\" + File.separator + \"resources\" + File.separator + \"ExampleTestClass.java\")).findFirst().get();\n\t\tfileName \u003d \"ExampleClass.java\";\n\t\tpackageName \u003d \"SomePackage.subpackage\";\n\t\tw \u003d new CheckStyleWarning(filePath, fileName, 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw2 \u003d new CheckStyleWarning(filePath2, fileName, 3, \"Test\", \"TestRule\", \"Class\");\n\t\twarningList \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2 \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2.add(w2);\n\t\twarningList.add(w);\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void clearAttributes() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t}\n\n\t/**\n\t * Test that the number of warnings is zero when the object is just created.\n\t */\n\t@Test\n\tpublic void testNumWarningsIsZero() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertSame(0, cs.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test the file path of the summarizer.\n\t */\n\t@Test\n\tpublic void testFilePath() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertSame(filePath, cs.getFilePath());\n\t}\n\n\t/**\n\t * Test that the number of warnings is not zero after summarise has been\n\t * called.\n\t */\n\t@Test\n\tpublic void testNumWarningsIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tassertSame(cs.getWarningList().size(), cs.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * name and file path.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentNameAndPath() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(\"ExampleTestClass.java\", filePath2, packageName);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * name.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentName() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(\"Not same name\", filePath, packageName);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * file path.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentPath() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath2, packageName);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * package name.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentPackageName() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, \"Not same package\");\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. Both do summarizes the\n\t * warnings.\n\t */\n\t@Test\n\tpublic void testEqualsTrueAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tcs2.summarise(warningList);\n\t\tassertEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test objects that are the same should return same hashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertEquals(cs.hashCode(), cs2.hashCode());\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. Only one summarizes the\n\t * warnings.\n\t */\n\t@Test\n\tpublic void testEqualsFalseAfterWithOneSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test summarizing warnings from components with same name but from\n\t * different package.\n\t */\n\t@Test\n\tpublic void testSummarizingWarningDiffrentPackage() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList2);\n\t\tassertSame(0, cs.getNumberOfWarnings());\n\t}\n\n\t/**\n\t * Test equal with different object.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDiffernetObject() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertNotEquals(cs, Integer.valueOf(1));\n\t}\n\n\t/**\n\t * Test that the number of PMD warnings is not zero after summarise has been\n\t * called.\n\t */\n\t@Test\n\tpublic void testNumPMDWarningsIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\twarningList.add(new PMDWarning(filePath, fileName, 3, packageName, \"test\", \"test2\", \"test3\", \"test4\", \"Class\"));\n\t\tcs.summarise(warningList);\n\t\tassertSame(1, cs.numberOfPMDWarnings);\n\t}\n\n\t/**\n\t * Test that the number of FindBugs warnings is not zero after summarise has\n\t * been called.\n\t */\n\t@Test\n\tpublic void testNumFindBugsWarningsIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\twarningList.add(new FindBugsWarning(filePath, fileName, 3, \"testMessage\", \"test\", \"test2\", \"test3\", \"test4\"));\n\t\tcs.summarise(warningList);\n\t\tassertSame(1, cs.numberOfFindBugsWarnings);\n\t}\n\n\t/**\n\t * Test that a IllegalArgumentException is thrown for incrementNumWarnings.\n\t * called.\n\t */\n\t@Test(expected \u003d IllegalArgumentException.class)\n\tpublic void testIllegalArgumentExceptionIncrementNumWarnings() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\twarningList.add(new FindBugsWarning(filePath, fileName, 3, \"testMessage\", \"test\", \"test2\", \"test3\", \"test4\"));\n\t\tcs.summarise(warningList);\n\t\tcs.incrementNumberOfWarnings(ASAT.valueOf(\"Not a right type of ASAT\"));\n\t}\n\n\t/**\n\t * Test that the loc is not zero after summarise has been called.\n\t */\n\t@Test\n\tpublic void testLOCIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tassertNotSame(0, cs.getLoc());\n\t}\n\t\n\t/**\n\t * Test two equal ComponentSummarizer return the same string.\n\t */\n\t@Test\n\tpublic void testSameStringShouldBeReturned() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertEquals(cs.toString(), cs2.toString());\n\t}\n\t\n\t/**\n\t * Test two different ComponentSummarizer return the different string.\n\t */\n\t@Test\n\tpublic void testDifferentStringShouldBeReturned() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(\"Test\", filePath, packageName);\n\t\tassertNotEquals(cs.toString(), cs2.toString());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\summarizers\\PackageSummarizerTest.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertFalse;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.HashSet;\nimport java.util.List;\nimport java.util.Set;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test for the PackageSummarizer class.\n * \n * @author BlueTurtle.\n *\n */\npublic class PackageSummarizerTest {\n\n\tprivate String packageName;\n\tprivate List\u003cWarning\u003e warningList;\n\tprivate Warning w;\n\tprivate List\u003cWarning\u003e warningList2;\n\tprivate Warning w2;\n\tprivate String filePath;\n\tprivate String filePath2;\n\n\t/**\n\t * Initialize necessary objects.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem was encountered while reading\n\t *             files.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\tfilePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\n\t\t\t\t\"src\" + File.separator + \"test\" + File.separator + \"resources\" + File.separator + \"ExampleClass.java\"))\n\t\t\t\t.findFirst().get();\n\t\tfilePath2 \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\"src\" + File.separator\n\t\t\t\t+ \"test\" + File.separator + \"resources\" + File.separator + \"ExampleTestClass.java\")).findFirst().get();\n\t\tpackageName \u003d \"SomePackage.subpackage\";\n\t\tw \u003d new CheckStyleWarning(filePath, \"ExampleClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw2 \u003d new CheckStyleWarning(filePath2, \"ExampleTestClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\twarningList \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2 \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2.add(w2);\n\t\twarningList2.add(w);\n\t\twarningList.add(w);\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanUpAttributes() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t}\n\n\t/**\n\t * Test that there is no warning when the object is made.\n\t */\n\t@Test\n\tpublic void testNumWarningIsZero() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tassertSame(0, ps.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test that the number of warning is not zero after summarise.\n\t */\n\t@Test\n\tpublic void testNotZeroSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tassertNotSame(0, ps.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test that the number of CheckStyle warnings is not zero after summarise.\n\t */\n\t@Test\n\tpublic void testCheckStyleWarningsIsNotZero() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tassertNotSame(0, ps.numberOfCheckStyleWarnings);\n\t}\n\n\t/**\n\t * Test that the number of classes is not zero after summarise.\n\t */\n\t@Test\n\tpublic void testNumClassesIsNotZero() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tassertSame(1, ps.getNumberOfClasses());\n\t}\n\n\t/**\n\t * Test that warning types is not empty after summarise.\n\t */\n\t@Test\n\tpublic void testWarningTypeIsNotEmptyAfterSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tSet\u003cString\u003e expected \u003d new HashSet\u003cString\u003e();\n\t\texpected.add(\"CheckStyle\");\n\t\tassertEquals(expected, ps.warningTypes);\n\t}\n\n\t/**\n\t * Test that classes is not empty after summarise.\n\t */\n\t@Test\n\tpublic void testClassesIsNotEmptyAfterSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tList\u003cComponentSummarizer\u003e list \u003d new ArrayList\u003cComponentSummarizer\u003e();\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(\"ExampleClass.java\", filePath, packageName);\n\t\tcs.summarise(warningList2);\n\t\tlist.add(cs);\n\t\tassertEquals(list, ps.getClasses());\n\t}\n\n\t/**\n\t * Test findOwnClasses.\n\t */\n\t@Test\n\tpublic void testfindOwnClasses() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tHashMap\u003cString, String\u003e expected \u003d new HashMap\u003cString, String\u003e();\n\t\texpected.put(\"ExampleClass.java\", filePath);\n\n\t\tHashMap\u003cString, String\u003e actual \u003d ps.findOwnClasses(warningList2);\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equals false with only one PackageSummarizer running summarise.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithOneRunningSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertNotEquals(ps2, ps);\n\t}\n\n\t/**\n\t * Test equals where both is running summarise.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tps2.summarise(warningList2);\n\t\tassertEquals(ps2, ps);\n\t}\n\n\t/**\n\t * Test objects that are the same should return same hashCode.\n\t */\n\t@Test\n\tpublic void tesSameHashCode() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertEquals(ps2.hashCode(), ps.hashCode());\n\t}\n\n\t/**\n\t * Test equals with another object.\n\t */\n\t@Test\n\tpublic void testEqualsWithAnotherObject() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tboolean answer \u003d ps.equals(Integer.valueOf(5));\n\t\tassertFalse(answer);\n\t}\n\t\n\t/**\n\t * Test two equals PackageSummarizer return the same string.\n\t */\n\t@Test\n\tpublic void testSameStringIsReturned() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertEquals(ps2.toString(), ps.toString());\n\t}\n\t\n\t/**\n\t * Test two different PackageSummarizer return the different string.\n\t */\n\t@Test\n\tpublic void testDifferentStringShouldBeReturned() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(\"Test\");\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertNotEquals(ps.toString(), ps2.toString());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\TSE\\CodeFileTest.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\n\nimport org.junit.Before;\nimport org.junit.Test;\n\n/**\n * Test CodeFile class.\n * @author michiel\n *\n */\npublic class CodeFileTest {\n\tprivate CodeFile codeFile;\n\tprivate File testFile \u003d new File(\"./src/test/resources/CodeFileTestFile.txt\");\n\t\n\t/**\n\t * Setup method, initialize CodeFile.\n\t * @throws IOException\n\t * \t\t\t\tif file not found, inaccessible, etc.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tcodeFile \u003d new CodeFile();\n\t}\n\t\n\t/**\n\t * Test if the getCodeFromFile method actually reads and stores code from a file.\n\t * @throws IOException\n\t * \t\t\t\tif file not found, inaccessible, etc.\n\t */\n\t@Test\n\tpublic void testGetCodeFromFile() throws IOException {\n\t\tcodeFile.getCodeFromFile(testFile);\n\t\tassertTrue(codeFile.getCode().length() \u003e 0);\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\TSE\\JavaControllerTest.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController;\nimport BlueTurtle.gui.GUIController.ASAT;\n\n/**\n * Test for the JavaController class.\n * \n * @author BlueTurtle.\n *\n */\npublic class JavaControllerTest {\n\n\tprivate String userDir \u003d System.getProperty(\"user.dir\");\n\tprivate ArrayList\u003cString\u003e checkstyleList \u003d new ArrayList\u003cString\u003e();\n\tprivate ArrayList\u003cString\u003e pmdList \u003d new ArrayList\u003cString\u003e();\n\tprivate ArrayList\u003cString\u003e findBugsList \u003d new ArrayList\u003cString\u003e();\n\tprivate String checkStyleOutputFilePath \u003d userDir + \"/src/test/resources/exampleCheckstyle1.xml\";\n\tprivate String pmdOutputFilePath \u003d userDir + \"/src/test/resources/examplePmd1.xml\";\n\tprivate String findBugsOutputFilePath \u003d userDir + \"/src/test/resources/exampleFindbugs1.xml\";\n\n\t/**\n\t * Clear the attributes of JavaController.\n\t * \n\t * @throws IOException\n\t *             throws an exception if there was a problem encounterd while\n\t *             reading the files.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tGUIController.setProjectPath(\"test\");\n\t\tcheckstyleList.add(checkStyleOutputFilePath);\n\t\tpmdList.add(pmdOutputFilePath);\n\t\tfindBugsList.add(findBugsOutputFilePath);\n\t\tnew ProjectInfoFinder().findFiles(new File(userDir));\n\t\tJavaController.setCheckStyleOutputFiles(null);\n\t\tJavaController.setPmdOutputFiles(null);\n\t\tJavaController.setFindBugsOutputFiles(null);\n\t}\n\n\t/**\n\t * Delete the created files.\n\t */\n\t@After\n\tpublic void cleanUp() {\n\t\tFile f \u003d new File(userDir + \"/src/main/resources/SummarizedOuput.js\");\n\t\tGUIController.setProjectPath(null);\n\t\tif (f.exists()) {\n\t\t\tf.delete();\n\t\t}\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t}\n\n\t/**\n\t * Test that the user direction path is the same.\n\t */\n\t@Test\n\tpublic void testUserDir() {\n\t\tString expected \u003d userDir;\n\t\tString actual \u003d JavaController.getUserDir();\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test that all files are null at first.\n\t */\n\t@Test\n\tpublic void allFilesStringsAreNull() {\n\t\tassertTrue(JavaController.getCheckStyleOutputFiles() \u003d\u003d null \u0026\u0026 JavaController.getPmdOutputFiles() \u003d\u003d null\n\t\t\t\t\u0026\u0026 JavaController.getFindBugsOutputFiles() \u003d\u003d null);\n\t}\n\n\t/**\n\t * Test changing CheckStyle list of output file.\n\t */\n\t@Test\n\tpublic void testChangingCheckStyleOutputFile() {\n\t\tArrayList\u003cString\u003e list \u003d JavaController.getCheckStyleOutputFiles();\n\t\tArrayList\u003cString\u003e newList \u003d new ArrayList\u003cString\u003e();\n\t\tnewList.add(\"test path for checkstyle\");\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, newList);\n\t\tassertNotEquals(list, JavaController.getCheckStyleOutputFiles());\n\t}\n\n\t/**\n\t * Test changing PMD list of output file.\n\t */\n\t@Test\n\tpublic void testChangingPMDOutputFile() {\n\t\tArrayList\u003cString\u003e list \u003d JavaController.getPmdOutputFiles();\n\t\tArrayList\u003cString\u003e newList \u003d new ArrayList\u003cString\u003e();\n\t\tnewList.add(\"test path for pmd\");\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, newList);\n\t\tassertNotEquals(list, JavaController.getPmdOutputFiles());\n\t}\n\n\t/**\n\t * Test changing FindBugs list of output files.\n\t */\n\t@Test\n\tpublic void testChangingFindBugsOutputFile() {\n\t\tArrayList\u003cString\u003e list \u003d JavaController.getFindBugsOutputFiles();\n\t\tArrayList\u003cString\u003e newList \u003d new ArrayList\u003cString\u003e();\n\t\tnewList.add(\"test path for findbugs\");\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, newList);\n\t\tassertNotEquals(list, JavaController.getFindBugsOutputFiles());\n\t}\n\n\t/**\n\t * Test SetASATOutputFiles with a null.\n\t */\n\t@Test\n\tpublic void testSetOutputWithNull() {\n\t\tArrayList\u003cString\u003e fileList \u003d JavaController.getCheckStyleOutputFiles();\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, null);\n\t\tassertEquals(fileList, JavaController.getCheckStyleOutputFiles());\n\t}\n\n\t/**\n\t * Test execute should produce an output file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testExecute() throws IOException {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, new ArrayList\u003cString\u003e());\n\t\tJavaController jc \u003d new JavaController();\n\t\tjc.execute();\n\t\tassertTrue(new File(userDir + \"/visualization/JSON/outputWarningsJSON.js\").exists());\n\t}\n\n\t/**\n\t * Tests if the JSONFormatter generates an empty list of warnings when it\n\t * finds no output files.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testNoOutputFile() throws IOException {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, new ArrayList\u003cString\u003e());\n\t\tJSONFormatter jsonFormatter \u003d new JSONFormatter();\n\t\tjsonFormatter.format();\n\t\tassertSame(jsonFormatter.getTotalWarnings().size(), 0);\n\t}\n\n\t/**\n\t * Tests if the JSONFormatter generates a list of warnings when the list of\n\t * output files are not empty There is just one output file for each ASAT.\n\t * The output files are modified (smaller output files) for the test.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testListOfOneOutputFile() throws IOException {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, checkstyleList);\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, pmdList);\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, findBugsList);\n\t\tJSONFormatter jsonFormatter \u003d new JSONFormatter();\n\t\tjsonFormatter.format();\n\t\tassertSame(jsonFormatter.getTotalWarnings().size(), 8);\n\t}\n\t\n\t/**\n\t * Tests if the JSONFormatter generates a list of warnings when the list of\n\t * output files are not empty. There are two output files for each ASAT.\n\t * The output files are modified (smaller output files) for the test.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testListOfTwoOutputFile() throws IOException {\n\t\tcheckstyleList.add(checkStyleOutputFilePath);\n\t\tpmdList.add(pmdOutputFilePath);\n\t\tfindBugsList.add(findBugsOutputFilePath);\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, checkstyleList);\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, pmdList);\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, findBugsList);\n\t\tJSONFormatter jsonFormatter \u003d new JSONFormatter();\n\t\tjsonFormatter.format();\n\t\tassertSame(jsonFormatter.getTotalWarnings().size(), 16);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\warnings\\ChecktStyleWarningTest.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.Test;\n\n/**\n * Test for CheckStyleWarning class.\n * \n * @author BlueTurtle.\n *\n */\npublic class ChecktStyleWarningTest {\n\n\tprivate static String filePath \u003d \"\\\\Dummy\\\\Cool.java\";\n\tprivate static String fileName \u003d \"Cool.java\";\n\tprivate static String message \u003d \"Unused @param tag for \u0027filePath\u0027.\";\n\tprivate static String ruleName \u003d \"JavadocMethod\";\n\tprivate static String classification \u003d \" Documentation Conventions\";\n\n\t\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test objects that are equal should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected.hashCode(), actual.hashCode());\n\t}\n\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrueWithSet() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\texpected.setFileName(\"\");\n\t\texpected.setFileName(fileName);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where both objects does represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsFalse() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, \"Hot.java\", 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where they have different file path.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPath() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(\"\\\\Another\\\\Awesome.java\", fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where they have different message.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentMessage() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(\"\\\\Another\\\\Awesome.java\", fileName, 1, message, ruleName, classification);\n\t\texpected.setMessage(\"This is not cool\");\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where they have a different rule name.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRule() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(\"\\\\Another\\\\Awesome.java\", fileName, 1, message, ruleName, classification);\n\t\texpected.setClassification(\"This is not a rule\");\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where one object has PMDWarning, the other one has\n\t * CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalsePMDandCheckStyle() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, \"\", \"\", \"\", ruleName, \"\", classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, \"lalala\", ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test the change of the message of a CheckStyle warning.\n\t */\n\t@Test\n\tpublic void testChangeOfMessage() {\n\t\tString expected \u003d \"cool\";\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, \"test\", ruleName, classification);\n\t\tString actual \u003d cw.getMessage();\n\t\tcw.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test the change of the line of a CheckStyle warning.\n\t */\n\t@Test\n\tpublic void testChangeOfLine() {\n\t\tint expected \u003d 5;\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tint actual \u003d cw.getLine();\n\t\tcw.setLine(expected);\n\t\tassertNotSame(expected, actual);\n\t}\n\n\t/**\n\t * Test equals between an Integer object and a CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithIntegerObject() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tboolean actual \u003d cw.equals(Integer.valueOf(1));\n\t\tassertSame(false, actual);\n\t}\n\n\t/**\n\t * Test equals between two CheckStyleWarning with different rule and\n\t * message.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRuleAndMessage() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, \"random\", ruleName, classification);\n\t\tCheckStyleWarning diff \u003d new CheckStyleWarning(filePath, fileName, 1, message, \"unknown rule\", classification);\n\t\tassertNotEquals(cw, diff);\n\t}\n\t\n\t/**\n\t * Test equals between two CheckStyleWarning with different rule and\n\t * and line.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRuleAndLine() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning diff \u003d new CheckStyleWarning(filePath, fileName, 5, message, \"test\", classification);\n\t\tassertNotEquals(cw, diff);\n\t}\n\t\n\t/**\n\t * Test equals between two CheckStyleWarning with different rule and\n\t * and line.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentMessageAndRule() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, \"rule\", classification);\n\t\tCheckStyleWarning diff \u003d new CheckStyleWarning(filePath, fileName, 1, \"hey\", ruleName, classification);\n\t\tassertNotEquals(cw, diff);\n\t}\n\t\n\t/**\n\t * Test two equal CheckStylWarning should return same string.\n\t */\n\t@Test\n\tpublic void testTwoEqualWarningReturnSameString() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\t\n\t/**\n\t * Test two different CheckStylWarning should return different string.\n\t */\n\t@Test\n\tpublic void testTwoDifferentWarningReturnDifferentString() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\warnings\\FindBugsWarningTest.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\n\nimport org.junit.Test;\n\n\n/**\n * Test for FindBugsWarning class.\n * @author BlueTurtle.\n *\n */\npublic class FindBugsWarningTest {\n\t\n\tprivate static String filePath \u003d \"\\\\src\\\\test\\\\TestPMD.java\";\n\tprivate static String fileName \u003d \"FindBugs.java\";\n\tprivate static String message \u003d \"BlueTurtle.warnings.PMDWarning defines equals and uses Object.hashCode()\";\n\tprivate static String ruleName \u003d \"HE_EQUALS_USE_HASHCODE\";\n\tprivate static String category \u003d \"BAD_PRACTICE\";\n\tprivate static String priority \u003d \"High\";\n\tprivate static String classification \u003d \"Interface\";\n\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test objects that are equals should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertEquals(expected.hashCode(), actual.hashCode());\n\t}\n\n\t/**\n\t * Test equal method where objects have different file paths.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPath() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setFilePath(\"\\\\src\\\\temp\\\\\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different file names.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentFileName() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setFileName(\"okay.java\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\n\t/**\n\t * Test equal method where objects have different line numbers.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentLines() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 2, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test equal method where objects have different rules.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRules() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setClassification(\"UUF_UNUSED_FIELD\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different categories.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentCategories() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setCategory(\"STYLE\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different priorities.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPriority() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setPriority(\"Normal\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\t\n\t\n\t/**\n\t * Test equal method where one object has FindBugsWarning, the other one has CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalsePMDandCheckStyle() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, \"lalala\", ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test the change of the line of a FindBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfLine() {\n\t\tint expected \u003d 5;\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tint actual \u003d fb.getLine();\n\t\tfb.setLine(expected);\n\t\tassertNotSame(expected, actual);\n\t}\n\t\n\t/**\n\t * Test the change of the message of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfMessage() {\n\t\tString expected \u003d \"cool\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getMessage();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\n\t/**\n\t * Test the change of the category of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfCategory() {\n\t\tString expected \u003d \"I18N\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getCategory();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the priority of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfPriority() {\n\t\tString expected \u003d \"Low\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getPriority();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the rule name of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfRuleName() {\n\t\tString expected \u003d \"DM_DEFAULT_ENCODING\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getClassification();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\n\t/**\n\t * Test the change of the file name of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfFileName() {\n\t\tString expected \u003d \"this.java\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getFileName();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test the change of the type of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfType() {\n\t\tString expected \u003d \"PMD\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getType();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\n\t/**\n\t * Test the change of the file path of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfFilePath() {\n\t\tString expected \u003d \"\\\\Documents\\\\GitHub\\\\Contextproject-TSE\\\\src\\\\main\\\\java\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getFilePath();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test two equal FindBugsWarning return the same string.\n\t */\n\t@Test\n\tpublic void testTwoEqualsWarningReturnSameString() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\t\n\t/**\n\t * Test two different FindBugsWarning return the different strings.\n\t */\n\t@Test\n\tpublic void testDifferentEqualsWarningReturnDifferentString() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 6, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected.toString(), actual.toString());\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\warnings\\PMDWarningTest.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\n\nimport org.junit.Test;\n\n/**\n * Test for PMDWarning class.\n * @author BlueTurtle.\n *\n */\npublic class PMDWarningTest {\n\t\n\tprivate static String filePath \u003d \"\\\\src\\\\test\\\\TestPMD.java\";\n\tprivate static String fileName \u003d \"PMD.java\";\n\tprivate static String packageName \u003d \"test\";\n\tprivate static String ruleName \u003d \"UnnecessaryBooleanAssertion\";\n\tprivate static String ruleSet \u003d \"JUnit\";\n\tprivate static String method \u003d \"equals\";\n\tprivate static String classification \u003d \"Refactorings - Redundancies\";\n\tprivate static String message \u003d \"Ensure you override both equals() and hashCode()\";\n\n\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test objects that are equal should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertEquals(expected.hashCode(), actual.hashCode());\n\t}\n\n\t/**\n\t * Test equal method where objects have different file paths.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPath() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setFilePath(\"\\\\src\\\\temp\\\\\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different file names.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentFileName() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setFileName(\"okay.java\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\n\t/**\n\t * Test equal method where objects have different line numbers.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentLines() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test equal method where objects have different rules.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRules() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setClassification(\"OverrideBothEqualsAndHashcode\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different packages.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPackages() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setPackageName(\"BlueTurtle.warnings\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different types.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentTypes() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setType(\"warning1\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tactual.setType(\"warning2\");\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\t\n\t/**\n\t * Test equal method where objects have different ruleSets.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRuleSets() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setMessage(\"Basic\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\n\t/**\n\t * Test equal method where objects have different methods.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentMethods() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setMethod(\"foo\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where one object has PMDWarning, the other one has CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalsePMDandCheckStyle() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the line of a PMD warning.\n\t */\n\t@Test\n\tpublic void testChangeOfLine() {\n\t\tint expected \u003d 5;\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tint actual \u003d pmd.getLine();\n\t\tpmd.setLine(expected);\n\t\tassertNotSame(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the package name of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfPackageName() {\n\t\tString expected \u003d \"BlueTurtle.parsers\";\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tString actual \u003d pmd.getPackageName();\n\t\tpmd.setPackageName(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\t\n\t/**\n\t * Test the change of the rule set of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfRuleSet() {\n\t\tString expected \u003d \"Basic1\";\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tString actual \u003d pmd.getMessage();\n\t\tpmd.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test the change of the method of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfMethod() {\n\t\tString expected \u003d \"func\";\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tString actual \u003d pmd.getMethod();\n\t\tpmd.setMethod(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test two equal PMDWarning return the same string.\n\t */\n\t@Test\n\tpublic void testTwoEqualWarningReturnSameString() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\t\n\t/**\n\t * Test two different PMDWarning return different strings.\n\t */\n\t@Test\n\tpublic void testTwoDifferentWarningReturnDifferentString() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 5, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected.toString(), actual.toString());\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\writers\\JSWriterTest.java",
    "code": "\"package BlueTurtle.writers;\n\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.groupers.WarningGrouper;\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.gui.GUIController;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Tests for the JsonWriter class.\n * \n * @author BlueTurtle.\n *\n */\npublic class JSWriterTest {\n\n\tprivate String outputPath;\n\tprivate List\u003cSummarizer\u003e summarizedWarnings;\n\tprivate JSWriter jsWriter \u003d JSWriter.getInstance();\n\n\t/**\n\t * Intitialize the things that are needed.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the files.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\toutputPath \u003d \"./src/test/resources/testOutput.js\";\n\t\tList\u003cWarning\u003e list \u003d new ArrayList\u003cWarning\u003e();\n\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\n\t\t\t\t\"src\" + File.separator + \"test\" + File.separator + \"resources\" + File.separator + \"ExampleClass.java\"))\n\t\t\t\t.findFirst().get();\n\t\tlist.add(new CheckStyleWarning(filePath, \"ExampleClass.java\", 5, \"test\", \"test\", \"Class\"));\n\t\tWarningGrouper wg \u003d new WarningGrouper(list);\n\t\tsummarizedWarnings \u003d wg.groupBy(Criteria.PACKAGES);\n\t\tjsWriter.setSummarizedWarnings(summarizedWarnings);\n\t\tGUIController.setProjectPath(\"test\");\n\n\t\t// make sure that the file does not already exist by coincidence.\n\t\tFile file \u003d new File(outputPath);\n\t\tif (file.exists()) {\n\t\t\tfile.delete();\n\t\t}\n\n\t}\n\n\t/**\n\t * Cleanup the files that were created and also the attributes of\n\t * ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanup() {\n\t\tFile file \u003d new File(outputPath);\n\t\tfile.delete();\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tGUIController.setProjectPath(null);\n\t}\n\n\t/**\n\t * Test writing summarized warnings to a file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if something has happened when writing to\n\t *             a file.\n\t */\n\t@Test\n\tpublic void testWriteToJsonFormat() throws IOException {\n\t\tjsWriter.writeToJSFormat(outputPath);\n\n\t\tFile file \u003d new File(outputPath);\n\t\tboolean fileWritten \u003d file.exists();\n\t\tassertTrue(fileWritten);\n\t}\n\n\t/**\n\t * Test changing the summarizedWarnings.\n\t */\n\t@Test\n\tpublic void testChangingSummarizedWarnings() {\n\t\tjsWriter.setSummarizedWarnings(new ArrayList\u003cSummarizer\u003e());\n\t\tassertSame(0, jsWriter.getSummarizedWarnings().size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\TestCodeFolder\\AllClosestPoints.java",
    "code": "\"import java.io.BufferedReader;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.InputStream;\nimport java.io.InputStreamReader;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\n\npublic class AllClosestPoints {\n\tpublic static Point[] nearestNeighbours;\n\n\tpublic static void main(String[] args) throws FileNotFoundException {\n\t\tint i \u003d 1;\n\t\twhile(i \u003c\u003d 10000000) {\t\t\n\t\t\tint points \u003d i;\n\t\t\tlong startTime \u003d System.currentTimeMillis();\n\t\t\texecute(points);\n\t\t\tlong stopTime \u003d System.currentTimeMillis();\n\t\t\tlong elapsedTime \u003d stopTime - startTime;\n\t\t\tSystem.out.println(\"Execution for all nearest neighbours with \" + points + \" took \" + elapsedTime + \" ms\\n\");\n\t\t\ti*\u003d10;\n\t\t}\n\t}\n\n\n\tpublic static class PointPair {\n\t\tpublic Point p1;\n\t\tpublic Point p2;\n\n\t\tpublic PointPair(Point p1, Point p2) {\n\t\t\tthis.p1 \u003d p1;\n\t\t\tthis.p2 \u003d p2;\n\t\t}\n\n\t\tpublic double computeDistance() {\n\t\t\treturn Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointPairIntersectionYCoordinateComparator implements Comparator\u003cPointPair\u003e {\n\t\t@Override\n\t\tpublic int compare(PointPair pp1, PointPair pp2) {\n\t\t\treturn Double.compare(pp1.p2.y, pp2.p2.y);\n\t\t}\n\t}\n\n\tpublic static class Circle {\n\t\tpublic double radius;\n\t\tpublic Point center;\n\n\t\tpublic Circle(double radius, Point center) {\n\t\t\tthis.radius \u003d radius;\n\t\t\tthis.center \u003d center;\n\t\t}\n\n\t\tpublic Point computeIntersectionPointMedian(double median) {\n\t\t\tif(median \u003e center.x + radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tif(median \u003c center.x - radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif(median \u003d\u003d center.x + radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\t\t\tif(median \u003d\u003d center.x - radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\n\t\t\tdouble yLength \u003d Math.sqrt(Math.pow(radius, 2) - Math.pow(Math.abs(median - center.x), 2));\n\n\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y + yLength);\n\t\t}\n\t}\n\n\tpublic static class Point {\n\t\tpublic int id;\n\t\tpublic double x;\n\t\tpublic double y;\n\n\t\tpublic Point(int id, double x, double y) {\n\t\t\tthis.id \u003d id;\n\t\t\tthis.x \u003d x;\n\t\t\tthis.y \u003d y;\n\t\t}\n\n\t\tpublic double computeDistanceToXMedian(double xMedian) {\n\t\t\treturn Math.sqrt(Math.pow(xMedian - x, 2));\n\t\t}\n\n\t\tpublic boolean equals(Point other) {\n\t\t\tif(other instanceof Point) {\n\t\t\t\tif(id \u003d\u003d other.id) {\n\t\t\t\t\tif(x \u003d\u003d other.x) {\n\t\t\t\t\t\tif(y \u003d\u003d other.y) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn false;\n\t\t} \n\n\t\tpublic double computeDistanceToOtherPoint(Point other) {\n\t\t\tif(other \u003d\u003d null) {\n\t\t\t\treturn Double.MAX_VALUE;\n\t\t\t}\n\t\t\treturn Math.sqrt(Math.pow(other.x - x, 2) + Math.pow(other.y - y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointXComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.x, p2.x);\n\t\t}\n\t}\n\n\tpublic static class PointYComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.y, p2.y);\n\t\t}\n\t}\n\n\tpublic static void execute(int numPoints) {\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\tdouble x \u003d i;\n\t\t\tdouble y \u003d i;\n\t\t\tpoints.add(new Point(i, x, y));\n\t\t}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\t}\n\n\tpublic static String run(InputStream in){\n\t\tBufferedReader reader \u003d new BufferedReader(new InputStreamReader(in));\n\t\tint numPoints \u003d 0;\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\n\t\ttry{\n\t\t\tnumPoints \u003d Integer.parseInt(reader.readLine());\n\n\t\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\t\tString[] line \u003d reader.readLine().split(\" \");\n\t\t\t\tdouble x \u003d Double.parseDouble(line[0]);\n\t\t\t\tdouble y \u003d Double.parseDouble(line[1]);\n\t\t\t\tpoints.add(new Point(i, x, y));\n\t\t\t}\n\t\t} catch (Exception e){}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\n\t\tStringBuilder stringBuilder \u003d new StringBuilder();\n\t\tfor(int i \u003d 0; i \u003c nearestNeighbours.length; i++) {\n\t\t\tstringBuilder.append(nearestNeighbours[i].id);\n\t\t\tstringBuilder.append(\u0027\\n\u0027);\n\t\t}\n\t\treturn stringBuilder.toString();\n\t}\n\n\tpublic static double computeMedian(ArrayList\u003cPoint\u003e points){\n\t\tint middle \u003d points.size()/2;\n\n\t\tif (points.size() % 2 \u003d\u003d 1) {\n\t\t\treturn points.get(middle).x;\n\t\t} else {\n\t\t\treturn (points.get(middle-1).x + points.get(middle).x) / 2.0;\n\t\t}\n\t}\n\n\tpublic static int findClosestPoint(double y_coordinate, ArrayList\u003cPointPair\u003e pointsAndIntersections) {\n\t\tif(pointsAndIntersections.size() \u003d\u003d 0) {\n\t\t\treturn -1;\n\t\t}\n\t\tint highIndex \u003d pointsAndIntersections.size() -1;\n\t\tint lowIndex \u003d 0;\n\t\tint index \u003d Integer.MAX_VALUE;\t\n\t\twhile(highIndex \u003e lowIndex) {\n\t\t\tindex \u003d (highIndex + lowIndex) / 2;\n\t\t\tPoint intersectionPoint \u003d pointsAndIntersections.get(index).p2;\n\t\t\tif(pointsAndIntersections.get(lowIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn lowIndex;\n\t\t\t} else if(intersectionPoint.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn index;\n\t\t\t} else if(pointsAndIntersections.get(highIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn highIndex;\n\t\t\t} else if(intersectionPoint.y \u003e y_coordinate) {\n\t\t\t\tif (highIndex \u003d\u003d index) {\n\t\t\t\t\treturn highIndex;\n\t\t\t\t}\n\t\t\t\thighIndex \u003d index;\n\t\t\t} else {\n\t\t\t\tif(lowIndex \u003d\u003d index) {\n\t\t\t\t\treturn lowIndex;\n\t\t\t\t}\n\t\t\t\tlowIndex \u003d index;\n\t\t\t}\n\t\t}\n\t\treturn highIndex;\n\t}\n\n\tpublic static void allClosestPairs(ArrayList\u003cPoint\u003e points) {\n\t\tif(points.size() \u003c 2) {\n\t\t\treturn;\n\t\t}\n\t\tif(points.size()\u003d\u003d2) {\n\t\t\tnearestNeighbours[points.get(0).id] \u003d points.get(1);\n\t\t\tnearestNeighbours[points.get(1).id] \u003d points.get(0);\n\t\t\treturn;\n\t\t}\n\n\t\tif(points.size()\u003d\u003d3) {\n\t\t\tfor(Point currPoint : points) {\n\t\t\t\tfor(Point comparePoint : points) {\n\t\t\t\t\tif(!currPoint.equals(comparePoint)) {\n\t\t\t\t\t\tdouble distance \u003d currPoint.computeDistanceToOtherPoint(comparePoint);\n\t\t\t\t\t\tdouble storedDistance \u003d currPoint.computeDistanceToOtherPoint(nearestNeighbours[currPoint.id]);\n\t\t\t\t\t\tif(distance \u003c storedDistance) {\n\t\t\t\t\t\t\tnearestNeighbours[currPoint.id] \u003d comparePoint;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\n\t\tCollections.sort(points, new PointXComparator());\n\t\tdouble median \u003d computeMedian(points);\n\n\t\tArrayList\u003cPoint\u003e leftHalf \u003d new ArrayList\u003cPoint\u003e();\n\t\tArrayList\u003cPoint\u003e rightHalf \u003d new ArrayList\u003cPoint\u003e();\n\n\t\tfor(Point currPoint : points) {\n\t\t\tif(currPoint.x \u003c\u003d median) {\n\t\t\t\tleftHalf.add(currPoint);\n\t\t\t} else {\n\t\t\t\trightHalf.add(currPoint);\n\t\t\t}\n\t\t}\n\n\t\tallClosestPairs(leftHalf);\n\t\tallClosestPairs(rightHalf);\n\n\t\tArrayList\u003cPointPair\u003e leftPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\t\tArrayList\u003cPointPair\u003e rightPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\tleftPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\trightPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tCollections.sort(leftPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\t\tCollections.sort(rightPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, rightPointsAndIntersections);\n\n\t\t\tif(rightPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index - 4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c rightPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, leftPointsAndIntersections);\n\t\t\tif(leftPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index -4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c leftPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\classes\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\classes\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\classes\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\TestCodeFolder\\AllClosestPoints.java",
    "code": "\"import java.io.BufferedReader;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.InputStream;\nimport java.io.InputStreamReader;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\n\npublic class AllClosestPoints {\n\tpublic static Point[] nearestNeighbours;\n\n\tpublic static void main(String[] args) throws FileNotFoundException {\n\t\tint i \u003d 1;\n\t\twhile(i \u003c\u003d 10000000) {\t\t\n\t\t\tint points \u003d i;\n\t\t\tlong startTime \u003d System.currentTimeMillis();\n\t\t\texecute(points);\n\t\t\tlong stopTime \u003d System.currentTimeMillis();\n\t\t\tlong elapsedTime \u003d stopTime - startTime;\n\t\t\tSystem.out.println(\"Execution for all nearest neighbours with \" + points + \" took \" + elapsedTime + \" ms\\n\");\n\t\t\ti*\u003d10;\n\t\t}\n\t}\n\n\n\tpublic static class PointPair {\n\t\tpublic Point p1;\n\t\tpublic Point p2;\n\n\t\tpublic PointPair(Point p1, Point p2) {\n\t\t\tthis.p1 \u003d p1;\n\t\t\tthis.p2 \u003d p2;\n\t\t}\n\n\t\tpublic double computeDistance() {\n\t\t\treturn Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointPairIntersectionYCoordinateComparator implements Comparator\u003cPointPair\u003e {\n\t\t@Override\n\t\tpublic int compare(PointPair pp1, PointPair pp2) {\n\t\t\treturn Double.compare(pp1.p2.y, pp2.p2.y);\n\t\t}\n\t}\n\n\tpublic static class Circle {\n\t\tpublic double radius;\n\t\tpublic Point center;\n\n\t\tpublic Circle(double radius, Point center) {\n\t\t\tthis.radius \u003d radius;\n\t\t\tthis.center \u003d center;\n\t\t}\n\n\t\tpublic Point computeIntersectionPointMedian(double median) {\n\t\t\tif(median \u003e center.x + radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tif(median \u003c center.x - radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif(median \u003d\u003d center.x + radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\t\t\tif(median \u003d\u003d center.x - radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\n\t\t\tdouble yLength \u003d Math.sqrt(Math.pow(radius, 2) - Math.pow(Math.abs(median - center.x), 2));\n\n\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y + yLength);\n\t\t}\n\t}\n\n\tpublic static class Point {\n\t\tpublic int id;\n\t\tpublic double x;\n\t\tpublic double y;\n\n\t\tpublic Point(int id, double x, double y) {\n\t\t\tthis.id \u003d id;\n\t\t\tthis.x \u003d x;\n\t\t\tthis.y \u003d y;\n\t\t}\n\n\t\tpublic double computeDistanceToXMedian(double xMedian) {\n\t\t\treturn Math.sqrt(Math.pow(xMedian - x, 2));\n\t\t}\n\n\t\tpublic boolean equals(Point other) {\n\t\t\tif(other instanceof Point) {\n\t\t\t\tif(id \u003d\u003d other.id) {\n\t\t\t\t\tif(x \u003d\u003d other.x) {\n\t\t\t\t\t\tif(y \u003d\u003d other.y) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn false;\n\t\t} \n\n\t\tpublic double computeDistanceToOtherPoint(Point other) {\n\t\t\tif(other \u003d\u003d null) {\n\t\t\t\treturn Double.MAX_VALUE;\n\t\t\t}\n\t\t\treturn Math.sqrt(Math.pow(other.x - x, 2) + Math.pow(other.y - y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointXComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.x, p2.x);\n\t\t}\n\t}\n\n\tpublic static class PointYComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.y, p2.y);\n\t\t}\n\t}\n\n\tpublic static void execute(int numPoints) {\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\tdouble x \u003d i;\n\t\t\tdouble y \u003d i;\n\t\t\tpoints.add(new Point(i, x, y));\n\t\t}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\t}\n\n\tpublic static String run(InputStream in){\n\t\tBufferedReader reader \u003d new BufferedReader(new InputStreamReader(in));\n\t\tint numPoints \u003d 0;\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\n\t\ttry{\n\t\t\tnumPoints \u003d Integer.parseInt(reader.readLine());\n\n\t\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\t\tString[] line \u003d reader.readLine().split(\" \");\n\t\t\t\tdouble x \u003d Double.parseDouble(line[0]);\n\t\t\t\tdouble y \u003d Double.parseDouble(line[1]);\n\t\t\t\tpoints.add(new Point(i, x, y));\n\t\t\t}\n\t\t} catch (Exception e){}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\n\t\tStringBuilder stringBuilder \u003d new StringBuilder();\n\t\tfor(int i \u003d 0; i \u003c nearestNeighbours.length; i++) {\n\t\t\tstringBuilder.append(nearestNeighbours[i].id);\n\t\t\tstringBuilder.append(\u0027\\n\u0027);\n\t\t}\n\t\treturn stringBuilder.toString();\n\t}\n\n\tpublic static double computeMedian(ArrayList\u003cPoint\u003e points){\n\t\tint middle \u003d points.size()/2;\n\n\t\tif (points.size() % 2 \u003d\u003d 1) {\n\t\t\treturn points.get(middle).x;\n\t\t} else {\n\t\t\treturn (points.get(middle-1).x + points.get(middle).x) / 2.0;\n\t\t}\n\t}\n\n\tpublic static int findClosestPoint(double y_coordinate, ArrayList\u003cPointPair\u003e pointsAndIntersections) {\n\t\tif(pointsAndIntersections.size() \u003d\u003d 0) {\n\t\t\treturn -1;\n\t\t}\n\t\tint highIndex \u003d pointsAndIntersections.size() -1;\n\t\tint lowIndex \u003d 0;\n\t\tint index \u003d Integer.MAX_VALUE;\t\n\t\twhile(highIndex \u003e lowIndex) {\n\t\t\tindex \u003d (highIndex + lowIndex) / 2;\n\t\t\tPoint intersectionPoint \u003d pointsAndIntersections.get(index).p2;\n\t\t\tif(pointsAndIntersections.get(lowIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn lowIndex;\n\t\t\t} else if(intersectionPoint.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn index;\n\t\t\t} else if(pointsAndIntersections.get(highIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn highIndex;\n\t\t\t} else if(intersectionPoint.y \u003e y_coordinate) {\n\t\t\t\tif (highIndex \u003d\u003d index) {\n\t\t\t\t\treturn highIndex;\n\t\t\t\t}\n\t\t\t\thighIndex \u003d index;\n\t\t\t} else {\n\t\t\t\tif(lowIndex \u003d\u003d index) {\n\t\t\t\t\treturn lowIndex;\n\t\t\t\t}\n\t\t\t\tlowIndex \u003d index;\n\t\t\t}\n\t\t}\n\t\treturn highIndex;\n\t}\n\n\tpublic static void allClosestPairs(ArrayList\u003cPoint\u003e points) {\n\t\tif(points.size() \u003c 2) {\n\t\t\treturn;\n\t\t}\n\t\tif(points.size()\u003d\u003d2) {\n\t\t\tnearestNeighbours[points.get(0).id] \u003d points.get(1);\n\t\t\tnearestNeighbours[points.get(1).id] \u003d points.get(0);\n\t\t\treturn;\n\t\t}\n\n\t\tif(points.size()\u003d\u003d3) {\n\t\t\tfor(Point currPoint : points) {\n\t\t\t\tfor(Point comparePoint : points) {\n\t\t\t\t\tif(!currPoint.equals(comparePoint)) {\n\t\t\t\t\t\tdouble distance \u003d currPoint.computeDistanceToOtherPoint(comparePoint);\n\t\t\t\t\t\tdouble storedDistance \u003d currPoint.computeDistanceToOtherPoint(nearestNeighbours[currPoint.id]);\n\t\t\t\t\t\tif(distance \u003c storedDistance) {\n\t\t\t\t\t\t\tnearestNeighbours[currPoint.id] \u003d comparePoint;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\n\t\tCollections.sort(points, new PointXComparator());\n\t\tdouble median \u003d computeMedian(points);\n\n\t\tArrayList\u003cPoint\u003e leftHalf \u003d new ArrayList\u003cPoint\u003e();\n\t\tArrayList\u003cPoint\u003e rightHalf \u003d new ArrayList\u003cPoint\u003e();\n\n\t\tfor(Point currPoint : points) {\n\t\t\tif(currPoint.x \u003c\u003d median) {\n\t\t\t\tleftHalf.add(currPoint);\n\t\t\t} else {\n\t\t\t\trightHalf.add(currPoint);\n\t\t\t}\n\t\t}\n\n\t\tallClosestPairs(leftHalf);\n\t\tallClosestPairs(rightHalf);\n\n\t\tArrayList\u003cPointPair\u003e leftPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\t\tArrayList\u003cPointPair\u003e rightPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\tleftPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\trightPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tCollections.sort(leftPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\t\tCollections.sort(rightPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, rightPointsAndIntersections);\n\n\t\t\tif(rightPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index - 4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c rightPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, leftPointsAndIntersections);\n\t\t\tif(leftPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index -4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c leftPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\computers\\LOCComputer.java",
    "code": "\"package BlueTurtle.computers;\n\nimport java.io.BufferedReader;\nimport java.io.FileReader;\nimport java.io.IOException;\n\n/**\n * This class can be used to find the (physical) lines of code for a file.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:hideutilityclassconstructor\")\npublic final class LOCComputer {\n\n\tprivate static LOCComputer locComputer \u003d null;\n\n\t/**\n\t * Constructor. Only this class can instantiate itself.\n\t */\n\tprivate LOCComputer() { }\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of this class.\n\t */\n\tpublic static LOCComputer getInstance() {\n\t\tif (locComputer \u003d\u003d null) {\n\t\t\tlocComputer \u003d new LOCComputer();\n\t\t}\n\t\treturn locComputer;\n\t}\n\n\t/**\n\t * Find the number of (physical) lines for a source code file.\n\t * \n\t * @param filePath\n\t *            the path to the source code file.\n\t * @return the number of (physical) lines.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic int computeLOC(String filePath) throws IOException {\n\t\tint numLines \u003d 0;\n\t\tBufferedReader reader \u003d new BufferedReader(new FileReader(filePath));\n\t\tString line \u003d reader.readLine();\n\t\twhile (line !\u003d null) {\n\t\t\tif (!line.isEmpty() \u0026\u0026 !line.startsWith(\"import\")) {\n\t\t\t\tnumLines++;\n\t\t\t}\n\t\t\tline \u003d reader.readLine();\n\t\t}\n\t\treader.close();\n\t\treturn numLines;\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\finders\\PackageNameFinder.java",
    "code": "\"package BlueTurtle.finders;\n\nimport java.io.BufferedReader;\nimport java.io.FileReader;\nimport java.io.IOException;\n\n/**\n * This class can be used for finding the package name of a component.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:hideutilityclassconstructor\")\npublic final class PackageNameFinder {\n\n\tprivate static PackageNameFinder packageNameFinder \u003d null;\n\n\t/**\n\t * Constructor. Only this class can instantiate itself.\n\t */\n\tprivate PackageNameFinder() { }\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of PackageNameFinder.\n\t */\n\tpublic static PackageNameFinder getInstance() {\n\t\tif (packageNameFinder \u003d\u003d null) {\n\t\t\tpackageNameFinder \u003d new PackageNameFinder();\n\t\t}\n\t\treturn packageNameFinder;\n\t}\n\n\t/**\n\t * Find the package name based on the given file path.\n\t * \n\t * @param filePath\n\t *            the path to the file.\n\t * @return the package name.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic String findPackageName(String filePath) throws IOException {\n\t\tString packageName \u003d \"default\";\n\t\tBufferedReader reader \u003d new BufferedReader(new FileReader(filePath));\n\t\tString line \u003d reader.readLine();\n\t\tString[] packageInfo \u003d line.split(\" \");\n\n\t\tif (packageInfo[0].equals(\"package\")) {\n\t\t\tpackageName \u003d packageInfo[1].split(\";\")[0];\n\t\t}\n\n\t\treader.close();\n\t\treturn packageName;\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\finders\\ProjectInfoFinder.java",
    "code": "\"package BlueTurtle.finders;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.HashSet;\nimport java.util.Set;\n\nimport BlueTurtle.TSE.CodeFile;\nimport BlueTurtle.computers.LOCComputer;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.writers.JSWriter;\nimport lombok.Getter;\n\n/**\n * Find all information of the project given the source directory of project.\n * \n * @author BlueTurtle.\n *\n */\npublic class ProjectInfoFinder {\n\n\t@Getter private static ArrayList\u003cString\u003e classPaths \u003d new ArrayList\u003cString\u003e();\n\t@Getter private static HashMap\u003cString, Integer\u003e classLocs \u003d new HashMap\u003cString, Integer\u003e();\n\t@Getter private static HashMap\u003cString, String\u003e classPackage \u003d new HashMap\u003cString, String\u003e();\n\t@Getter private static Set\u003cString\u003e packages \u003d new HashSet\u003cString\u003e();\n\t@Getter private ArrayList\u003cCodeFile\u003e codeFiles \u003d new ArrayList\u003cCodeFile\u003e();\n\t@Getter private static HashMap\u003cASAT, ArrayList\u003cString\u003e\u003e outputFilesPaths \u003d new HashMap\u003cASAT, ArrayList\u003cString\u003e\u003e();\n\n\t/**\n\t * Find the class files or the output files of the ASATs (recursively) in the directory.\n\t * \n\t * @param srcDir\n\t *            the source directory to search in.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the files.\n\t */\n\tpublic void findFiles(File srcDir) throws IOException {\n\t\t// Find all subdirectories.\n\t\tFile[] subdirs \u003d srcDir.listFiles();\n\n\t\t// Go through all subdirectories.\n\t\tfor (File subdir : subdirs) {\n\t\t\t// if it is a directory, keep searching for file.\n\t\t\tif (subdir.isDirectory()) {\n\t\t\t\tfindFiles(subdir);\n\t\t\t} else {\n\t\t\t\t// if file is found, compute the informations.\n\t\t\t\tcomputeFileInfo(subdir);\n\t\t\t}\n\t\t}\n\t}\n\n\t/**\n\t * Compute the information of the file that is found.\n\t * \n\t * @param file\n\t *            the file that is found.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic void computeFileInfo(File file) throws IOException {\n\t\t// if it is a java file, then compute information for the class.\n\t\tif (file.getName().endsWith(\".java\")) {\n\t\t\tcomputeClassInfo(file);\n\t\t} else if (file.getName().endsWith(\".xml\") \u0026\u0026 checkForASATOutputFile(file.getName())) {\n\t\t\t//If it is an output file the compute the information of the output file.\n\t\t\tcomputeOutputFileInfo(file);\n\t\t}\n\t}\n\n\t/**\n\t * Computes all the information of a class file.\n\t * \n\t * @param file\n\t *            the class file.\n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\tpublic static void computeClassInfo(File file) throws IOException {\n\t\tString path \u003d file.getAbsolutePath();\n\t\tclassPaths.add(path); // add the path\n\t\tclassLocs.put(path, LOCComputer.getInstance().computeLOC(path)); // add the LOC\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(path); //find the package name\n\t\tclassPackage.put(path, packageName); // put entry of class and its package\n\t\tpackages.add(packageName); // add package to the list of packages\n\t}\n\t\n\t/**\n\t * Compute the paths of the output files of the ASAT. \n\t * @param file \n\t * \t\t\t   output file of the ASAT.\n\t */\n\tpublic void computeOutputFileInfo(File file) {\n\t\tswitch (file.getName()) {\n\t\tcase \"checkstyle-result.xml\":\n\t\t\taddOutputFilePath(ASAT.CheckStyle, file.getAbsolutePath());\n\t\t\tbreak;\n\t\tcase \"findbugs.xml\":\n\t\t\taddOutputFilePath(ASAT.FindBugs, file.getAbsolutePath());\n\t\t\tbreak;\n\t\tcase \"pmd.xml\": \n\t\t\taddOutputFilePath(ASAT.PMD, file.getAbsolutePath());\n\t\t\tbreak;\n\t\tdefault:\n\t\t\t//unreachable\n\t\t\tthrow new IllegalArgumentException(\"This is not an output file of an ASAT.\");\n\t\t}\n\t}\n\t\n\t/**\n\t * Add the path of an output file to the \"outputFilesPaths\".\n\t * @param asat \n\t * \t\t\t\tthe ASAT type.\n\t * @param filePath \n\t * \t\t\t\tthe path of the output file.\n\t */\n\tpublic void addOutputFilePath(ASAT asat, String filePath) {\n\t\tif (outputFilesPaths.containsKey(asat)) {\n\t\t\toutputFilesPaths.get(asat).add(filePath);\n\t\t}\n\t\telse {\n\t\t\toutputFilesPaths.put(asat, new ArrayList\u003cString\u003e());\n\t\t\toutputFilesPaths.get(asat).add(filePath);\n\t\t}\n\t}\n\t\n\t/**\n\t * Check whether the file is an output file of an ASAT.\n\t * @param fileName\n\t *            the name of the file.\n\t * @return \n\t * \t\t\treturns true if it is an output file of an ASAT.\n\t */\n\tpublic Boolean checkForASATOutputFile(String fileName) {\n\t\treturn (fileName.contains(\"checkstyle-result\") || fileName.contains(\"pmd.\") || fileName.contains(\"findbugs.\"));\n\t}\n\n\t/**\n\t * Retrieves the code from every file located through the filepath in\n\t * classPaths. The code is stored in a CodeFile object which is added to the\n\t * codeFiles field. These files are then written to an output file.\n\t * \n\t * @throws IOException\n\t *             if file is not found, inaccessible, etc.\n\t */\n\tpublic void retrieveCodeFiles() throws IOException {\n\t\tfor (String classPath : classPaths) {\n\t\t\tFile currFile \u003d new File(classPath);\n\t\t\tCodeFile codeFile \u003d new CodeFile();\n\t\t\tcodeFile.setPath(classPath);\n\t\t\tcodeFile.getCodeFromFile(currFile);\n\t\t\tcodeFiles.add(codeFile);\n\t\t}\n\t\tJSWriter jswriter \u003d JSWriter.getInstance();\n\n\t\tjswriter.writeSourceCodeToJS(codeFiles, \"visualization/JSON/outputCodeJSON.js\");\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\groupers\\Grouper.java",
    "code": "\"package BlueTurtle.groupers;\n\nimport java.util.List;\n\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.summarizers.Summarizer;\n\n/**\n * This interface is used for a grouper (class that groups things together).\n * \n * @author BlueTurtle.\n *\n */\npublic interface Grouper {\n\t/**\n\t * Group things based on the given criteria.\n\t * \n\t * @param criteria\n\t *            list of criterium for grouping things together.\n\t * @return a list of things that are grouped together.\n\t */\n\tList\u003cSummarizer\u003e groupBy(Enum\u003cCriteria\u003e criteria);\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\groupers\\WarningGrouper.java",
    "code": "\"package BlueTurtle.groupers;\n\nimport java.io.File;\nimport java.util.ArrayList;\nimport java.util.EnumMap;\nimport java.util.List;\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.summarizers.ComponentSummarizer;\nimport BlueTurtle.summarizers.PackageSummarizer;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class is used to group warnings together (by their type or by\n * components).\n * \n * @author BlueTurtle.\n *\n */\npublic class WarningGrouper implements Grouper {\n\n\t/**\n\t * The types of criteria for grouping warnings.\n\t * \n\t * @author BlueTurtle.\n\t *\n\t */\n\tpublic enum Criteria {\n\t\tCOMPONENTS, PACKAGES\n\t}\n\n\t@Getter private EnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e summarizedWarnings;\n\t@Getter private List\u003cWarning\u003e warningList;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param warningList\n\t *            the list of warnings.\n\t */\n\tpublic WarningGrouper(List\u003cWarning\u003e warningList) {\n\t\tthis.warningList \u003d warningList;\n\t\tthis.summarizedWarnings \u003d new EnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e(Criteria.class);\n\t\tsummarizedWarnings.put(Criteria.COMPONENTS, groupByComponent());\n\t\tsummarizedWarnings.put(Criteria.PACKAGES, groupByPackage());\n\t}\n\n\t/**\n\t * Group things together, based on the criteria.\n\t * \n\t * @param criteria\n\t *            the criteria for grouping things together.\n\t */\n\t@Override\n\tpublic List\u003cSummarizer\u003e groupBy(Enum\u003cCriteria\u003e criteria) {\n\t\treturn summarizedWarnings.get(criteria);\n\t}\n\n\t/**\n\t * Group warnings by the component that they are from.\n\t * \n\t * @return a list of Summarizer objects.\n\t */\n\tpublic List\u003cSummarizer\u003e groupByComponent() {\n\t\tList\u003cSummarizer\u003e csList \u003d new ArrayList\u003cSummarizer\u003e();\n\n\t\tfor (String classPath : ProjectInfoFinder.getClassPaths()) {\n\t\t\tString fileName \u003d classPath.substring(classPath.lastIndexOf(File.separator) + 1, classPath.length());\n\t\t\tString filePath \u003d classPath;\n\t\t\tString packageName \u003d ProjectInfoFinder.getClassPackage().get(filePath);\n\t\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\t\tcs.summarise(getWarningList());\n\t\t\tcsList.add(cs);\n\t\t}\n\n\t\treturn csList;\n\t}\n\n\t/**\n\t * Group the warnings by the package they are from.\n\t * \n\t * @return a list of summarizer objects.\n\t */\n\tpublic List\u003cSummarizer\u003e groupByPackage() {\n\t\tList\u003cSummarizer\u003e result \u003d new ArrayList\u003cSummarizer\u003e();\n\n\t\tfor (String p : ProjectInfoFinder.getPackages()) {\n\t\t\tPackageSummarizer ps \u003d new PackageSummarizer(p);\n\t\t\tps.summarise(warningList);\n\t\t\tresult.add(ps);\n\t\t}\n\n\t\treturn result;\n\t}\n\n\t/**\n\t * Check whether two Warning grouper are equal.\n\t * \n\t * @param other\n\t *            the other WarningGrouper object\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\t\tif (!(other instanceof WarningGrouper)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tWarningGrouper that \u003d (WarningGrouper) other;\n\n\t\t// fix SimplifyBooleanReturn, Conditional logic can be removed.\n\t\treturn (warningList.equals(that.getWarningList()) \u0026\u0026 summarizedWarnings.equals(that.summarizedWarnings));\n\t}\n\n\t/**\n\t * HashCode for WarningGrouper.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(warningList, summarizedWarnings);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\gui\\AlertCreator.java",
    "code": "\"package BlueTurtle.gui;\n\nimport javafx.scene.control.Alert;\nimport javafx.scene.control.Alert.AlertType;\n\n/**\n * This class is for creating alert dialogs.\n * \n * @author BlueTurtle.\n *\n */\npublic final class AlertCreator {\n\n\tprivate static AlertCreator alertCreator \u003d null;\n\n\t/**\n\t * Only this class can instantiate itself.\n\t */\n\tprivate AlertCreator() {\n\t}\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of the DialogCreator.\n\t */\n\tpublic static AlertCreator getInstance() {\n\t\tif (alertCreator \u003d\u003d null) {\n\t\t\talertCreator \u003d new AlertCreator();\n\t\t}\n\t\treturn alertCreator;\n\t}\n\n\t/**\n\t * Create an alert dialog.\n\t * \n\t * @param type\n\t *            the type of the alert.\n\t * @param title\n\t *            the title of the dialog box.\n\t * @param message\n\t *            the message in the dialog box.\n\t * @return an alert dialog.\n\t */\n\tpublic Alert createAlert(AlertType type, String title, String message) {\n\t\tAlert alert \u003d new Alert(type);\n\t\talert.setTitle(title);\n\t\talert.setContentText(message);\n\t\treturn alert;\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\gui\\GUI.java",
    "code": "\"package BlueTurtle.gui;\n\nimport javafx.application.Application;\nimport javafx.application.Platform;\nimport javafx.fxml.FXMLLoader;\nimport javafx.scene.Scene;\nimport javafx.scene.control.SplitPane;\nimport javafx.scene.image.Image;\nimport javafx.stage.Stage;\n\n/**\n * This class the GUI component of the system.\n * \n * @author BlueTurtle.\n *\n */\npublic class GUI extends Application {\n\n\t/**\n\t * Start the GUI.\n\t */\n\tpublic void startGUI() {\n\t\tApplication.launch(GUI.class, (java.lang.String[]) null);\n\t}\n\n\t/**\n\t * Start the scene.\n\t * \n\t * @param stage\n\t *            the stage.\n\t */\n\t@Override\n\tpublic void start(Stage stage) {\n\t\ttry {\n\t\t\tstage.setTitle(\"BlueTurtle Visualizer\");\n\t\t\tstage.getIcons().add(new Image(GUI.class.getResourceAsStream(\"/blueturtlelogo.png\")));\n\t\t\tstage.setHeight(420);\n\t\t\tstage.setWidth(1083);\n\t\t\tstage.setResizable(false);\n\t\t\tstage.setScene(new Scene((SplitPane) new FXMLLoader(getClass().getResource(\"/Menu.fxml\")).load()));\n\t\t\tstage.show();\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n\t/**\n\t * Stop the application / GUI.\n\t */\n\tpublic void stop() {\n\t\tPlatform.exit();\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\gui\\GUIController.java",
    "code": "\"package BlueTurtle.gui;\n\nimport java.awt.Desktop;\nimport java.awt.TextField;\n\nimport javafx.scene.control.Alert;\nimport javafx.scene.control.Alert.AlertType; \nimport java.io.File;\nimport java.io.IOException;\nimport java.net.URL;\nimport java.util.ResourceBundle;\n\nimport javax.swing.Popup;\n\nimport BlueTurtle.TSE.JavaController;\nimport BlueTurtle.TSE.Main;\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport javafx.event.EventHandler;\nimport javafx.fxml.FXML;\nimport javafx.scene.control.Button;\nimport javafx.scene.input.MouseEvent;\nimport javafx.scene.text.Text;\nimport javafx.stage.DirectoryChooser;\nimport javafx.stage.Stage;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * Controller class for the GUI.\n * \n * @author BlueTurtle.\n *\n */\npublic class GUIController {\n\n\n\t/**\n\t * Enums to represent the ASATs.\n\t * \n\t * @author BlueTurtle.\n\t *\n\t */\n\tpublic enum ASAT { CheckStyle, PMD, FindBugs; }\n\n\t@FXML // ResourceBundle that was given to the FXMLLoader\n\tprivate ResourceBundle resources; //NOPMD - needed for the FXMLLoader.\n\n\t@FXML // URL location of the FXML file that was given to the FXMLLoader\n\tprivate URL location; //NOPMD - needed for the FXMLLoader.\n\n\t@FXML // fx:id\u003d\"selectButton\"\n\tprivate Button selectButton; // Value injected by FXMLLoader\n\n\t@FXML // fx:id\u003d\"projectSourcePathText\"\n\tprivate Text projectSourcePathText; // Value injected by FXMLLoader\n\n\t@FXML // fx:id\u003d\"visualizeButton\"\n\tprivate Button visualizeButton; // Value injected by FXMLLoader\n\t\n\t@Getter @Setter private static String projectPath; //NOPMD - warning caused by lombok.\n\t\n\t/**\n\t * Event for CheckStyle button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectCheckStyleConfigEvent(MouseEvent event) { }\n\n\t/**\n\t * Event for PMD button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectPMDConfigEvent(MouseEvent event) { }\n\n\t/**\n\t * Event for FindBugs button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectFindBugsConfigEvent(MouseEvent event) { }\n\n\t/**\n\t * Events for the LoadButton.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid selectButtonEvent(MouseEvent event) { }\n\n\t/**\n\t * Events from the VisualizeButton.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@FXML\n\tvoid visualizeButtonEvent(MouseEvent event) { }\n\n\t/**\n\t * Initialize the buttons.\n\t */\n\t@FXML\n\tvoid initialize() {\n\t\tassert visualizeButton !\u003d null : \"fx:id\u003d\\\"visualizeButton\\\" was not injected: check your FXML file \u0027Menu.fxml\u0027.\";\n\t\tassert projectSourcePathText !\u003d null : \"fx:id\u003d\\\"projectSourcePathText\\\" was not injected: check your FXML file \u0027Menu.fxml\u0027.\";\n\t\tassert selectButton !\u003d null : \"fx:id\u003d\\\"selectButton\\\" was not injected: check your FXML file \u0027Menu.fxml\u0027.\";\n\n\t\t// Set the event handlers for the buttons.\n\t\tselectButton.setOnMouseClicked(new SelectButtonEventHandler(projectSourcePathText, visualizeButton));\n\t\tvisualizeButton.setOnMouseClicked(new VisualizeButtonEventHandler());\n\t}\n\t\n}\n\n/**\n * EventHandler class for select button of GUI.\n * \n * @author BlueTurtle.\n *\n */\nclass SelectButtonEventHandler implements EventHandler\u003cMouseEvent\u003e {\n\n\t@Getter private Text sourcePathText;\n\t@Getter private Button visualizeButton;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param sourcePathText\n\t *            the text field that shows the path of the project.\n\t * @param vButton\n\t *            the visualize button. This is needed for enabling the button\n\t *            after the project folder is selected.\n\t */\n\tpublic SelectButtonEventHandler(Text sourcePathText, Button vButton) {\n\t\tthis.sourcePathText \u003d sourcePathText;\n\t\tthis.visualizeButton \u003d vButton;\n\t}\n\t\n\n\t/**\n\t * Event handler for the button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@Override\n\tpublic void handle(MouseEvent event) {\n\t\tDirectoryChooser directoryChooser \u003d new DirectoryChooser();\n\t\tFile selectedDirectory \u003d directoryChooser.showDialog(new Stage());\n\n\t\tif (selectedDirectory \u003d\u003d null) {\n\t\t\tsourcePathText.setText(\"No Directory selected\");\n\t\t} else {\n\t\t\tsourcePathText.setText(selectedDirectory.getAbsolutePath());\n\t\t\tGUIController.setProjectPath(sourcePathText.getText());\n\t\t\tAlertCreator.getInstance().createAlert(AlertType.INFORMATION, \"Info\", \"Please make sure that you have run mvn site\" + \"\\n\"\n\t\t\t\t\t+ \"before clicking on the \" + \u0027\"\u0027 + \"Visualize\" + \u0027\"\u0027 + \" button!\").showAndWait();\n\t\t\tvisualizeButton.setDisable(false);\n\t\t}\n\t}\n\n}\n\n/**\n * EventHandler class for visualize button of GUI.\n * \n * @author BlueTurtle.\n *\n */\nclass VisualizeButtonEventHandler implements EventHandler\u003cMouseEvent\u003e {\n\t\n\t@Getter @Setter private AlertCreator alertCreator \u003d AlertCreator.getInstance();\n\n\t/**\n\t * Event handler for the button.\n\t * \n\t * @param event\n\t *            the event.\n\t */\n\t@Override\n\tpublic void handle(MouseEvent event) {\n\t\ttry {\n\t\t\tfindProjectInfo();\n\t\t\tAlert alert \u003d alertCreator.createAlert(AlertType.INFORMATION, \"info\", \"Collecting the data may take a few minutes for large projects.\");\n\t\t\talert.show();\n\t\t\t\n\t\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\t\tpif.findFiles(new File(GUIController.getProjectPath()));\n\t\t\tpif.retrieveCodeFiles();\n\t\t\tMain.runVisualization();\n\t\t\tDesktop.getDesktop().browse(new File(\"visualization/main.html\").toURI());\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n\t/**\n\t * Find all necessary information of the project.\n\t * @throws IOException \n\t * \t\t\t\tthrows an exception if a problem is encountered while reading the files.\n\t */\n\tpublic void findProjectInfo() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(GUIController.getProjectPath()));\n\t\tsetListOfOutputFiles();\n\t\tpif.retrieveCodeFiles();\n\t}\n\t\n\t/**\n\t * Set the list of output files (generated by Maven) for each ASAT.\n\t */\n\tpublic void setListOfOutputFiles() {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, ProjectInfoFinder.getOutputFilesPaths().get(ASAT.CheckStyle));\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, ProjectInfoFinder.getOutputFilesPaths().get(ASAT.PMD));\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, ProjectInfoFinder.getOutputFilesPaths().get(ASAT.FindBugs));\n\t}\n}\n\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\CheckStyleXMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\nimport org.w3c.dom.Node;\nimport org.w3c.dom.Element;\nimport java.io.File;\nimport java.util.Arrays;\nimport java.util.LinkedList;\nimport java.util.List;\nimport java.util.regex.Matcher;\n\n/**\n * This class can be used to parse a CheckStyle XML output file.\n * \n * @author BlueTurtle.\n *\n */\npublic class CheckStyleXMLParser extends XMLParser {\n\n\t/**\n\t * Parse a CheckStyle report file.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the CheckStyle report.\n\t * @return a list of CheckStyle warnings.\n\t */\n\t@Override\n\tpublic List\u003cWarning\u003e parseFile(String xmlFilePath) {\n\t\t// List to store the warnings.\n\t\tList\u003cWarning\u003e checkStyleWarnings \u003d new LinkedList\u003cWarning\u003e();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tNodeList nList \u003d setUp(xmlFilePath);\n\t\t\t\n\t\t\t// if there are no files with warnings, there return an empty list of warnings.\n\t\t\tif (nList \u003d\u003d null) { \n\t\t\t\treturn checkStyleWarnings; \n\t\t\t}\n\n\t\t\tfor (int i \u003d 0; i \u003c nList.getLength(); i++) {\n\t\t\t\t// Get the file from the list.\n\t\t\t\tNode file \u003d nList.item(i);\n\n\t\t\t\t\t// Get the path of the file where the warning is from.\n\t\t\t\t\tString filePath \u003d ((Element) file).getAttribute(\"name\");\n\n\t\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\t\tString fileName \u003d filePath.substring(filePath.lastIndexOf(\"src\") + 3, filePath.length());\n\n\t\t\t\t\t// Get all the warnings.\n\t\t\t\t\tNodeList warningList \u003d ((Element) file).getElementsByTagName(\"error\");\n\n\t\t\t\t\taddWarnings(fileName, warningList, checkStyleWarnings);\n\t\t\t}\n\n\t\treturn checkStyleWarnings;\n\t}\n\n\t/**\n\t * Add individual warning to the warningList.\n\t * \n\t * @param fileName\n\t *            is the file name of the warning.\n\t * @param warningList\n\t *            is a list of warnings.\n\t * @param checkStyleWarnings\n\t *            is the CheckStyle warnings.\n\t * @return a list of CheckStyle warnings.\n\t */\n\tpublic List\u003cWarning\u003e addWarnings(String fileName, NodeList warningList, List\u003cWarning\u003e checkStyleWarnings) {\n\t\tfor (int j \u003d 0; j \u003c warningList.getLength(); j++) {\n\t\t\t// Get the warning from the list of warnings.\n\t\t\tNode warning \u003d warningList.item(j);\n\t\t\t\n\t\t\t\t// Convert the node to an element.\n\t\t\t\tElement warningElement \u003d (Element) warning;\n\n\t\t\t\t// The message contained by the warning.\n\t\t\t\tString message \u003d warningElement.getAttribute(\"message\");\n\n\t\t\t\t// line number where the warning is located.\n\t\t\t\tint line \u003d Integer.parseInt(warningElement.getAttribute(\"line\"));\n\n\t\t\t\t// Get the category of the warning.\n\t\t\t\tString ruleName \u003d getRuleName(warningElement.getAttribute(\"source\"));\n\n\t\t\t\tString classification \u003d classify(ruleName);\n\n\t\t\t\t// replace the backward slash in the file name with file separator.\n\t\t\t\tString fileNWithSep \u003d fileName.replaceAll(\"\\\\\\\\\", Matcher.quoteReplacement(File.separator));\n\n\t\t\t\t// for-loop in stream, find correct filePath.\n\t\t\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(p -\u003e p.endsWith(fileNWithSep)).findFirst().get();\n\n\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\tString finalFileName \u003d fileNWithSep.substring(fileNWithSep.lastIndexOf(File.separatorChar) + 1, fileNWithSep.length());\n\n\t\t\t\t// Add warning to the list of warnings.\n\t\t\t\tcheckStyleWarnings.add(new CheckStyleWarning(filePath, finalFileName, line, message, ruleName, classification));\n\t\t}\n\t\t\n\t\treturn checkStyleWarnings;\n\n\t}\n\n\t/**\n\t * Get the rule name of the CheckStyle warning.\n\t * \n\t * @param source\n\t *            the source of the check.\n\t * @return the category of the CheckStyle warning.\n\t */\n\tpublic static String getRuleName(String source) {\n\t\t// Remove the substring \"Check\" from the source.\n\t\tString[] temp \u003d source.split(\"Check\");\n\n\t\t// Build the string back.\n\t\tsource \u003d Arrays.toString(temp);\n\n\t\t// Return only the name of the check.\n\t\treturn source.substring(source.lastIndexOf(\u0027.\u0027) + 1, source.length() - 1);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\FindBugsXMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.LinkedList;\nimport java.util.List;\nimport java.util.regex.Matcher;\n\nimport org.w3c.dom.Element;\nimport org.w3c.dom.Node;\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.FindBugsWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * This class can be used to parse a FindBugs XML output file.\n * \n * @author BlueTurtle.\n *\n */\npublic class FindBugsXMLParser extends XMLParser {\n\n\t/**\n\t * Parse a FindBugs report file.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the FindBugs report.\n\t * @return a list of FindBugs warnings.\n\t */\n\t@Override\n\tpublic List\u003cWarning\u003e parseFile(String xmlFilePath) {\n\n\t\t// List to store the warnings.\n\t\tList\u003cWarning\u003e findBugsWarnings \u003d new LinkedList\u003cWarning\u003e();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tNodeList nList \u003d setUp(xmlFilePath);\n\t\t\t\n\t\t\t// if there are no files with warnings, there return an empty list of warnings.\n\t\t\tif (nList \u003d\u003d null) { \n\t\t\t\treturn findBugsWarnings; \n\t\t\t}\n\n\t\t\tfor (int i \u003d 0; i \u003c nList.getLength(); i++) {\n\t\t\t\t// Get the file from the list.\n\t\t\t\tNode file \u003d nList.item(i);\n\n\t\t\t\t\t// Convert the node to an element.\n\t\t\t\t\tElement fileElement \u003d (Element) file;\n\n\t\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\t\tString fileName \u003d fileElement.getAttribute(\"classname\");\n\n\t\t\t\t\t// Get all the warnings.\n\t\t\t\t\tNodeList warningList \u003d fileElement.getElementsByTagName(\"BugInstance\");\n\n\t\t\t\t\taddWarnings(fileName, warningList, findBugsWarnings, nList);\n\t\t\t}\n\n\t\treturn findBugsWarnings;\n\t}\n\n\t/**\n\t * add individual warning to the warningList.\n\t * \n\t * @param fileName\n\t *            is the file name of the warning.\n\t * @param warningList\n\t *            is a list of warnings.\n\t * @param nList\n\t *            is the node list.\n\t * @param findBugsWarnings\n\t *            is the findBugs warnings.\n\t */\n\tpublic void addWarnings(String fileName, NodeList warningList, List\u003cWarning\u003e findBugsWarnings, NodeList nList) {\n\n\t\tfor (int j \u003d 0; j \u003c warningList.getLength(); j++) {\n\t\t\t// Get the warning from the list of warnings.\n\t\t\tNode warning \u003d warningList.item(j);\n\n\t\t\t\t// Convert the node to an element.\n\t\t\t\tElement warningElement \u003d (Element) warning;\n\n\t\t\t\t// The message contained by the warning.\n\t\t\t\tString message \u003d warningElement.getAttribute(\"message\");\n\n\t\t\t\t// The category of warning.\n\t\t\t\tString category \u003d warningElement.getAttribute(\"category\");\n\n\t\t\t\t// The priority of warning, can be high or low.\n\t\t\t\tString priority \u003d warningElement.getAttribute(\"priority\");\n\n\t\t\t\t// line number where the warning is located.\n\t\t\t\tint line \u003d Integer.parseInt(warningElement.getAttribute(\"lineNumber\"));\n\n\t\t\t\t// Get the category of the warning.\n\t\t\t\tString ruleName \u003d warningElement.getAttribute(\"type\");\n\n\t\t\t\tString classification \u003d classify(ruleName);\n\n\t\t\t\t// replace the dot in the file name with file separator.\n\t\t\t\tString fileNWithSep \u003d fileName.replaceAll(\"\\\\.\", Matcher.quoteReplacement(File.separator)) + \".java\";\n\n\t\t\t\t// for-loop in stream.\n\t\t\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(p -\u003e p.endsWith(fileNWithSep)).findFirst().get();\n\n\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\tString finalFileName \u003d fileNWithSep.substring(fileNWithSep.lastIndexOf(File.separatorChar) + 1, fileNWithSep.length());\n\n\t\t\t\t// Construct the new FindBugsWarning.\n\t\t\t\tFindBugsWarning fbw \u003d new FindBugsWarning(filePath, finalFileName, line, message, category, priority, ruleName, classification);\n\n\t\t\t\t// Add warning to the list of warnings.\n\t\t\t\tfindBugsWarnings.add(fbw);\n\t\t}\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\GDCParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.HashMap;\nimport org.jsoup.Jsoup;\nimport org.jsoup.nodes.Document;\nimport org.jsoup.select.Elements;\n\nimport lombok.Getter;\n\n\n/**\n * This class can be used to parse the General Defect Classification (GDC) grouping to a file.\n * \n * @author BlueTurtle.\n * \n * Reference: Moritz Beller, Radjino Bholanath, Shane McIntosh, Andy Zaidman: Analyzing\n * the State of Static Analysis: A Large-Scale Evaluation in Open Source Software\n * in 23rd IEEE International Conference on Software Analysis, Evolution, and\n * Reengineering (SANER), Osaka (Japan), 2016.\n *\n */\npublic final class GDCParser extends MarkdownParser {\n\t\n\tprivate static GDCParser gdcParser \u003d null;\n\t\n\t@Getter\n\tprivate static HashMap\u003cString, String\u003e categoryInfo;\n\t\n\t/**\n\t * Constructor. Only through this can GDCParser instantiate itself.\n\t */\n\tprivate GDCParser() { }\n\n\t/**\n\t * Get an instance of GDCParser.\n\t * \n\t * @return an instance of current class.\n\t */\n\tpublic static synchronized GDCParser getInstance() {\n\t\tif (gdcParser \u003d\u003d null) {\n\t\t\tgdcParser \u003d new GDCParser();\n\t\t}\n\t\treturn gdcParser;\n\t}\n\n\t/**\n\t * Parse a GDC grouping file.\n\t * \n\t * @param mdFilePath\n\t *            the location of the GDC grouping file.\n\t * @return a Hashmap of category informations.\n\t */\n\tpublic HashMap\u003cString, String\u003e parseFile(String mdFilePath) {\n\t\t// the hashmap to store the category informations.\n\t\tcategoryInfo \u003d new HashMap\u003cString, String\u003e();\n\t\t\n\t\ttry {\n\t\t\t// Instantiate things that are necessary for the parser.\n\t\t\tFile inputFile \u003d new File(mdFilePath);\n\t\t\t\n\t\t\t// parse the file.\n\t\t\tDocument doc \u003d Jsoup.parse(inputFile, \"UTF-8\");\n\t\t\t\n\t\t\t// select all the rows in the tables.\n\t\t\tElements rows \u003d doc.select(\"tbody\").select(\"tr\");\n\n\t\t\t// loop through each row of the entire GDC table\n\t\t\tfor (int i \u003d 0; i \u003c rows.size(); i++) {\n\t\t\t\tElements cols \u003d rows.get(i).select(\"td\");\n\t\t\t\t// first column is the warning name.\n\t\t\t\tString warning \u003d cols.get(0).text();\n\t\t\t\t// second column is the category of warning.\n\t\t\t\tString category \u003d cols.get(1).text();\n\n\t\t\t\t// update the warningList of the category.\n\t\t\t\tcategoryInfo.put(warning, category);\n\t\t\t}\n\t\t\t\t\t\t\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\t\n\t\treturn categoryInfo;\n\t\t\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\MarkdownParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.util.HashMap;\n\n/**\n * This class can be used to parse a Markdown file.\n * \n * @author BlueTurtle.\n *\n */\npublic abstract class MarkdownParser {\n\n\t/**\n\t * Parse a Markdown file.\n\t * \n\t * @param filePath\n\t *            the path to the file that needs to be parsed.\n\t * @return returns a HashMap.\n\t */\n\tpublic abstract HashMap\u003cString, String\u003e parseFile(String filePath);\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\Parser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.util.List;\n\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Interface for a parser. The parser has only one method, which is to parse a\n * file.\n * \n * @author BlueTurtle.\n *\n */\npublic interface Parser {\n\n\t/**\n\t * Parse the file.\n\t * \n\t * @param filePath\n\t *            the location of the file.\n\t * @return a list containing warning objects.\n\t */\n\tList\u003cWarning\u003e parseFile(String filePath);\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\PMDXMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.LinkedList;\nimport java.util.List;\nimport java.util.regex.Matcher;\n\nimport org.w3c.dom.Element;\nimport org.w3c.dom.Node;\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.PMDWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * This class can be used to parse a PMD XML output file.\n * \n * @author BlueTurtle.\n *\n */\npublic class PMDXMLParser extends XMLParser {\n\n\t/**\n\t * Parse a PMD report file.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the PMD report.\n\t * @return a list of PMD warnings.\n\t */\n\t@Override\n\tpublic List\u003cWarning\u003e parseFile(String xmlFilePath) {\n\t\t// List to store the warnings.\n\t\tList\u003cWarning\u003e pmdWarnings \u003d new LinkedList\u003cWarning\u003e();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tNodeList nList \u003d setUp(xmlFilePath);\n\n\t\t\t// if there are no files with warnings, there return an empty list of warnings.\n\t\t\tif (nList \u003d\u003d null) {\n\t\t\t\treturn pmdWarnings;\n\t\t\t}\n\t\t\t\n\t\t\tfor (int i \u003d 0; i \u003c nList.getLength(); i++) {\n\t\t\t\t// Get the file from the list.\n\t\t\t\tNode file \u003d nList.item(i);\n\n\n\t\t\t\t\t// Convert the node to an element.\n\t\t\t\t\tElement fileElement \u003d (Element) file;\n\n\t\t\t\t\t// Get the path of the file where the warning is from.\n\t\t\t\t\tString filePath \u003d fileElement.getAttribute(\"name\");\n\n\t\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\t\tString fileName \u003d filePath.substring(filePath.lastIndexOf(\"src\") + 3, filePath.length());\n\t\t\t\t\t\n\t\t\t\t\taddWarnings(fileName, fileElement, pmdWarnings);\n\n\n\t\t\t}\n\n\t\treturn pmdWarnings;\n\t}\n\n\t/**\n\t * Add individual warning to the warningList.\n\t * \n\t * @param fileName\n\t *            is the file name of the warning.\n\t * @param fileElement\n\t *            is a file element which contains all the warnings.\n\t * @param pmdWarnings\n\t *            is list of PMD warnings.\n\t */\n\tpublic void addWarnings(String fileName, Element fileElement, List\u003cWarning\u003e pmdWarnings) {\n\n\t\t// Get all the warnings.\n\t\tNodeList warningList \u003d fileElement.getElementsByTagName(\"violation\");\n\t\t\n\t\tfor (int j \u003d 0; j \u003c warningList.getLength(); j++) {\n\t\t\t// Get the warning from the list of warnings.\n\t\t\tNode warning \u003d warningList.item(j);\n\n\t\t\t\t// Convert the node to an element.\n\t\t\t\tElement warningElement \u003d (Element) warning;\n\n\t\t\t\t// package which warning is in.\n\t\t\t\tString packageName \u003d warningElement.getAttribute(\"package\");\n\n\t\t\t\t// the ruleSet of warning.\n\t\t\t\tString ruleSet \u003d warningElement.getAttribute(\"ruleset\");\n\n\t\t\t\t// method of warning.\n\t\t\t\tString method \u003d warningElement.getAttribute(\"method\");\n\n\t\t\t\t// line number where the warning is located.\n\t\t\t\tint line \u003d Integer.parseInt(warningElement.getAttribute(\"beginline\"));\n\n\t\t\t\t// Get the category of the warning.\n\t\t\t\tString ruleName \u003d warningElement.getAttribute(\"rule\");\n\n\t\t\t\t// find the correct classification given the rule name and the rule set.\n\t\t\t\tString classification \u003d classify(ruleName);\n\t\t\t\t\n\t\t\t\t// replace the backward slash in the file name with file separator.\n\t\t\t\tString fileNWithSep \u003d fileName.replaceAll(\"\\\\\\\\\", Matcher.quoteReplacement(File.separator));\n\n\t\t\t\t// for-loop in stream, find correct filePath.\n\t\t\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(p -\u003e p.endsWith(fileNWithSep)).findFirst().get();\n\n\t\t\t\t// Get the name of the file where the warning is from.\n\t\t\t\tString finalFileName \u003d fileNWithSep.substring(fileNWithSep.lastIndexOf(File.separatorChar) + 1, fileNWithSep.length());\n\n\t\t\t\t// Retrieve the message corresponds to this warning.\n\t\t\t\tString message \u003d fileElement.getElementsByTagName(\"violation\").item(j).getTextContent();\n\n\t\t\t\t// Add warning to the list of warnings.\n\t\t\t\tpmdWarnings.add(new PMDWarning(filePath, finalFileName, line, packageName, ruleSet, method, ruleName, message, classification));\n\t\t}\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\parsers\\XMLParser.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.util.HashMap;\nimport java.util.List;\n\nimport javax.xml.parsers.DocumentBuilder;\nimport javax.xml.parsers.DocumentBuilderFactory;\n\nimport org.w3c.dom.Document;\nimport org.w3c.dom.NodeList;\n\nimport BlueTurtle.warnings.Warning;\n\n/**\n * This class can be used to parse a XML file.\n * \n * @author BlueTurtle.\n *\n */\npublic abstract class XMLParser implements Parser {\n\n\tprivate static String mdFilePath \u003d \"./src/main/resources/asat-gdc-mapping.html\";\n\n\t/**\n\t * Parse a XML file.\n\t * \n\t * @param filePath\n\t *            the path to the file that needs to be parsed.\n\t * @return a list of warnings.\n\t */\n\tpublic abstract List\u003cWarning\u003e parseFile(String filePath);\n\n\t/**\n\t * Set up.\n\t * \n\t * @param xmlFilePath\n\t *            the location of the CheckStyle report.\n\t * @return a list of files where there are warnings.\n\t */\n\tpublic NodeList setUp(String xmlFilePath) {\n\t\t// set up an empty list.\n\t\tNodeList nList \u003d null;\n\t\ttry {\n\t\t\t// Instantiate things that are necessary for the parser.\n\t\t\tFile inputFile \u003d new File(xmlFilePath);\n\t\t\tDocumentBuilderFactory dbFactory \u003d DocumentBuilderFactory.newInstance();\n\t\t\tDocumentBuilder dBuilder \u003d dbFactory.newDocumentBuilder();\n\n\t\t\t// Parse the file.\n\t\t\tDocument doc \u003d dBuilder.parse(inputFile);\n\n\t\t\t// Normalize the elements of the document.\n\t\t\tdoc.getDocumentElement().normalize();\n\n\t\t\t// Get all list of files where there are warnings.\n\t\t\tnList \u003d doc.getElementsByTagName(\"file\");\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\n\t\treturn nList;\n\t}\n\n\t/**\n\t * Classify the rule name to the correct classification according to\n\t * categoryInfo.\n\t * \n\t * @param ruleName\n\t *            the violated rule name of the warning.\n\t *\n\t * @return the category of a warning(based on the GDC).\n\t */\n\tpublic static String classify(String ruleName) {\n\t\tGDCParser gp \u003d GDCParser.getInstance();\n\t\tgp.parseFile(mdFilePath);\n\t\tHashMap\u003cString, String\u003e categoryInfo \u003d GDCParser.getCategoryInfo();\n\t\tString finalRuleName \u003d categoryInfo.keySet().stream().filter(p -\u003e p.endsWith(ruleName)).findFirst().get();\n\t\treturn categoryInfo.get(finalRuleName);\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\summarizers\\ComponentSummarizer.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class can be used to summarise the warnings for a specific component.\n * \n * @author BlueTurtle.\n *\n */\npublic class ComponentSummarizer extends Summarizer {\n\n\t@Getter\n\tprivate String fileName;\n\t@Getter\n\tprivate String filePath;\n\t@Getter\n\tprivate List\u003cWarning\u003e warningList;\n\t@Getter\n\tprivate int loc;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param fileName\n\t *            the name of the component.\n\t * @param filePath\n\t *            the path to the component.\n\t * @param packageName\n\t *            the name of the package where the component is from.\n\t */\n\tpublic ComponentSummarizer(String fileName, String filePath, String packageName) {\n\t\tsuper(packageName);\n\t\tthis.fileName \u003d fileName;\n\t\tthis.filePath \u003d filePath;\n\t\tthis.loc \u003d ProjectInfoFinder.getClassLocs().get(filePath);\n\t\tthis.warningList \u003d new ArrayList\u003cWarning\u003e();\n\t}\n\n\t/**\n\t * Summarise the warnings.\n\t * \n\t * @param warnings\n\t *            the list of warnings to be summarized.\n\t */\n\t@Override\n\tpublic void summarise(List\u003cWarning\u003e warnings) {\n\t\tfor (Warning w : warnings) {\n\n\t\t\tString pn \u003d ProjectInfoFinder.getClassPackage().get(w.getFilePath());\n\t\t\tif (w.getFileName().equals(getFileName()) \u0026\u0026 pn.equals(getPackageName())) {\n\t\t\t\tString warningType \u003d w.getType();\n\t\t\t\tif (!warningTypes.contains(warningType)) {\n\t\t\t\t\twarningTypes.add(w.getType());\n\t\t\t\t}\n\t\t\t\twarningList.add(w);\n\t\t\t\tincrementNumberOfWarnings(ASAT.valueOf(warningType));\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\t/**\n\t * Check whether two ComponentSummarizer are equal.\n\t * \n\t * @param other\n\t *            the other ComponentSummarizer.\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof ComponentSummarizer)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tComponentSummarizer that \u003d (ComponentSummarizer) other;\n\n\t\treturn (packageName.equals(that.packageName) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 filePath.equals(that.filePath)\n\t\t\t\t\u0026\u0026 warningList.equals(that.warningList) \u0026\u0026 numberOfWarnings \u003d\u003d that.numberOfWarnings\n\t\t\t\t\u0026\u0026 warningTypes.equals(that.warningTypes));\n\n\t}\n\n\t/**\n\t * HashCode for ComponentSummarizer.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(packageName, fileName, filePath, warningList, numberOfWarnings, warningTypes);\n\t}\n\n\t/**\n\t * toString method for ComponentSummarizer.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"ComponentSummarizer [fileName\u003d\" + fileName + \", filePath\u003d\" + filePath + \", warningList\u003d\" + warningList\n\t\t\t\t+ \", loc\u003d\" + loc + \", packageName\u003d\" + packageName + \", numberOfWarnings\u003d\" + numberOfWarnings\n\t\t\t\t+ \", warningTypes\u003d\" + warningTypes + \", numberOfCheckStyleWarnings\u003d\" + numberOfCheckStyleWarnings\n\t\t\t\t+ \", numberOfPMDWarnings\u003d\" + numberOfPMDWarnings + \", numberOfFindBugsWarnings\u003d\"\n\t\t\t\t+ numberOfFindBugsWarnings + \"]\";\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\summarizers\\PackageSummarizer.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map.Entry;\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class summarises the warnings of a specific package.\n * \n * @author BlueTurtle.\n *\n */\npublic class PackageSummarizer extends Summarizer {\n\n\t@Getter private List\u003cComponentSummarizer\u003e classes;\n\t@Getter private int numberOfClasses;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param packageName\n\t *            the name of the package.\n\t */\n\tpublic PackageSummarizer(String packageName) {\n\t\tsuper(packageName);\n\t\tthis.classes \u003d new ArrayList\u003cComponentSummarizer\u003e();\n\t\tthis.numberOfClasses \u003d 0;\n\t}\n\n\t/**\n\t * Summarise the warnings for this package.\n\t * \n\t * @param warnings\n\t *            list of warnings.\n\t */\n\t@Override\n\tpublic void summarise(List\u003cWarning\u003e warnings) {\n\t\tHashMap\u003cString, String\u003e classesInfo \u003d findOwnClasses(warnings);\n\t\t\n\t\tfor (Entry\u003cString, String\u003e ci : classesInfo.entrySet()) {\n\t\t\tComponentSummarizer cs \u003d new ComponentSummarizer(ci.getKey(), ci.getValue(), packageName);\n\t\t\tcs.summarise(warnings);\n\t\t\tclasses.add(cs);\n\t\t\twarningTypes.addAll(cs.getWarningTypes());\n\t\t\tnumberOfWarnings +\u003d cs.getNumberOfWarnings();\n\t\t\tnumberOfCheckStyleWarnings +\u003d cs.getNumberOfCheckStyleWarnings();\n\t\t\tnumberOfPMDWarnings +\u003d cs.getNumberOfPMDWarnings();\n\t\t\tnumberOfFindBugsWarnings +\u003d cs.getNumberOfFindBugsWarnings();\n\t\t\tnumberOfClasses++;\n\t\t}\n\t\t\n\t}\n\n\t/**\n\t * Find the classes that belongs to this package.\n\t * \n\t * @param warnings\n\t *            the list of warnings.\n\t * @return a HashMap containing the classes and their file path that is from\n\t *         this package.\n\t */\n\tpublic HashMap\u003cString, String\u003e findOwnClasses(List\u003cWarning\u003e warnings) {\n\t\tHashMap\u003cString, String\u003e ownClasses \u003d new HashMap\u003cString, String\u003e();\n\t\t\n\t\tfor (Warning w : warnings) {\n\t\t\tString fileName \u003d w.getFileName();\n\t\t\tString filePath \u003d w.getFilePath();\n\n\t\t\tif (ProjectInfoFinder.getClassPackage().get(filePath).equals(packageName)\n\t\t\t\t\t\u0026\u0026 !ownClasses.containsKey(fileName)) {\n\t\t\t\townClasses.put(fileName, filePath);\n\t\t\t}\n\n\t\t}\n\n\t\treturn ownClasses;\n\t}\n\n\t/**\n\t * Check whether two PackageSummarizer are equal.\n\t * \n\t * @param other\n\t *            the other PacakgeSummarizer.\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof PackageSummarizer)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tPackageSummarizer that \u003d (PackageSummarizer) other;\n\n\t\treturn (packageName.equals(that.packageName) \u0026\u0026 numberOfWarnings \u003d\u003d that.numberOfWarnings\n\t\t\t\t\u0026\u0026 classes.equals(that.classes) \u0026\u0026 warningTypes.equals(that.warningTypes));\n\n\t}\n\n\t/**\n\t * HashCode for PackageSummarizer.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(packageName, numberOfWarnings, classes, warningTypes);\n\t}\n\t\n\t/**\n\t * toString method for PackageSummarizer.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"PackageSummarizer [classes\u003d\" + classes + \", numberOfClasses\u003d\" + numberOfClasses + \", packageName\u003d\"\n\t\t\t\t+ packageName + \", numberOfWarnings\u003d\" + numberOfWarnings + \", warningTypes\u003d\" + warningTypes\n\t\t\t\t+ \", numberOfCheckStyleWarnings\u003d\" + numberOfCheckStyleWarnings + \", numberOfPMDWarnings\u003d\"\n\t\t\t\t+ numberOfPMDWarnings + \", numberOfFindBugsWarnings\u003d\" + numberOfFindBugsWarnings + \"]\";\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\summarizers\\Summarizer.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport java.util.HashSet;\nimport java.util.List;\nimport java.util.Set;\n\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.warnings.Warning;\nimport lombok.Getter;\n\n/**\n * This class can be used to summarize warnings.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:visibilitymodifier\")\npublic abstract class Summarizer {\n\t\n\n\t@Getter protected String packageName;\n\t@Getter protected int numberOfWarnings;\n\t@Getter protected Set\u003cString\u003e warningTypes;\n\t@Getter protected int numberOfCheckStyleWarnings;\n\t@Getter protected int numberOfPMDWarnings;\n\t@Getter protected int numberOfFindBugsWarnings;\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param packageName\n\t *            the name of the package that the summarizer is working on.\n\t */\n\tpublic Summarizer(String packageName) {\n\t\tthis.packageName \u003d packageName;\n\t\tthis.warningTypes \u003d new HashSet\u003cString\u003e();\n\t\tthis.numberOfWarnings \u003d 0;\n\t\tthis.numberOfCheckStyleWarnings \u003d 0;\n\t\tthis.numberOfPMDWarnings \u003d 0;\n\t\tthis.numberOfFindBugsWarnings \u003d 0;\n\t}\n\n\t/**\n\t * Increment the number of warnings.\n\t * \n\t * @param type\n\t *            the type of the warning.\n\t */\n\tpublic void incrementNumberOfWarnings(ASAT type) {\n\t\tswitch (type) {\n\t\tcase CheckStyle:\n\t\t\tnumberOfCheckStyleWarnings++;\n\t\t\tnumberOfWarnings++;\n\t\t\tbreak;\n\t\tcase PMD:\n\t\t\tnumberOfPMDWarnings++;\n\t\t\tnumberOfWarnings++;\n\t\t\tbreak;\n\t\tcase FindBugs:\n\t\t\tnumberOfFindBugsWarnings++;\n\t\t\tnumberOfWarnings++;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\t// Unreachable\n\t\t\tthrow new IllegalArgumentException(\"This is not a right type of warning\");\n\t\t}\n\t}\n\n\t/**\n\t * Summarise the result of the warnings.\n\t * \n\t * @param warnings\n\t *            the list of warnings to be summarized.\n\t */\n\tpublic abstract void summarise(List\u003cWarning\u003e warnings);\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\CodeFile.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.BufferedReader;\nimport java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * Represents a file of code on the system. Consists of two strings:\n * the path to the file and the contents of the file. \n * @author michiel\n *\n */\npublic class CodeFile {\n\t@Getter @Setter private String path; //NOPMD - Warning caused by lombok.\n\t@Getter @Setter private String code \u003d \"\"; //NOPMD - Warning caused by lombok.\n\t\n\t/**\n\t * Reads the code from a file and saves it in the code field.\n\t * @param file \n\t * \t\t\tfile to read from.\n\t * @throws IOException\n\t * \t\t\tif file is not found, inaccessible, etc.\n\t */\n\tpublic void getCodeFromFile(File file) throws IOException {\n\t\tBufferedReader reader \u003d new BufferedReader(new FileReader(file));\n\n\t\tString nextLine;\n\t\tStringBuilder stringBuilder \u003d new StringBuilder();\n\t\tstringBuilder.append(\u0027\"\u0027);\n\t\twhile ((nextLine \u003d reader.readLine()) !\u003d null) {\n\t\t\tstringBuilder.append(nextLine);\n\t\t\tstringBuilder.append(\u0027\\n\u0027);\n\t\t}\n\t\tstringBuilder.append(\u0027\"\u0027);\n\t\tsetCode(stringBuilder.toString());\n\t\treader.close();\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\Controller.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.IOException;\n\n/**\n * The controller interface.\n * \n * @author BlueTurtle.\n *\n */\npublic interface Controller {\n\n\t/**\n\t * Execute controller.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered during\n\t *             execution.\n\t */\n\tvoid execute() throws IOException;\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\JavaController.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.IOException;\nimport java.util.ArrayList;\n\nimport BlueTurtle.gui.GUIController.ASAT;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * JavaController controls the analyser to make it analyse java code. It\n * constructs an AnalyserCommand for every ASAT which has to be run and passes\n * this to the analyser.\n * \n * @author BlueTurtle.\n *\n */\npublic class JavaController implements Controller {\n\t\n\t@Getter @Setter private static String userDir \u003d System.getProperty(\"user.dir\"); //NOPMD - caused by lombok.\n\t@Getter @Setter private static ArrayList\u003cString\u003e checkStyleOutputFiles; //NOPMD - caused by lombok.\n\t@Getter @Setter private static ArrayList\u003cString\u003e pmdOutputFiles; //NOPMD - caused by lombok.\n\t@Getter @Setter private static ArrayList\u003cString\u003e findBugsOutputFiles; //NOPMD - caused by lombok.\n\n\t/**\n\t * Execute controller. A command is constructed for every ASAT which needs\n\t * to be run.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered when\n\t *             executing the commands.\n\t */\n\tpublic void execute() throws IOException {\n\t\tnew JSONFormatter().format();\n\t}\n\t\n\t/**\n\t * Set the output paths for the ASAT.\n\t * \n\t * @param asat\n\t *            the ASAT type.\n\t * @param filePaths\n\t *            the list of output file paths.\n\t */\n\tpublic static void setASATOutputFiles(ASAT asat, ArrayList\u003cString\u003e filePaths) {\n\t\tif (filePaths \u003d\u003d null) {\n\t\t\treturn;\n\t\t}\n\t\tswitch (asat) {\n\t\tcase PMD:\n\t\t\tpmdOutputFiles \u003d filePaths;\n\t\t\tbreak;\n\t\tcase CheckStyle:\n\t\t\tcheckStyleOutputFiles \u003d filePaths;\n\t\t\tbreak;\n\t\tcase FindBugs:\n\t\t\tfindBugsOutputFiles \u003d filePaths;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\JSONFormatter.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\nimport BlueTurtle.groupers.WarningGrouper;\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.parsers.CheckStyleXMLParser;\nimport BlueTurtle.parsers.FindBugsXMLParser;\nimport BlueTurtle.parsers.PMDXMLParser;\nimport BlueTurtle.parsers.XMLParser;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.Warning;\nimport BlueTurtle.writers.JSWriter;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * JSONFormatter reads the output of Checkstyle, Findbugs and PMD and produces a\n * summarized defect output.\n * \n * @author BlueTurtle.\n *\n */\npublic class JSONFormatter {\n\t@Getter @Setter private List\u003cWarning\u003e totalWarnings \u003d new ArrayList\u003cWarning\u003e();\n\n\t/**\n\t * Produces a list of warnings for by reading the output of PMD, Checkstyle\n\t * and Findbugs. Then converts it to JSON format and writes it to a\n\t * JavaScript file.\n\t * \n\t * @throws IOException\n\t *             File not found.\n\t */\n\tpublic void format() throws IOException {\n\t\t\t\t\n\t\tparseListOfFiles(new CheckStyleXMLParser(), JavaController.getCheckStyleOutputFiles());\n\n\t\tparseListOfFiles(new PMDXMLParser(), JavaController.getPmdOutputFiles());\n\n\t\tparseListOfFiles(new FindBugsXMLParser(), JavaController.getFindBugsOutputFiles());\n\t\t\n\t\twriteJSON();\n\t}\n\t\n\t/**\n\t * Parse the list of output files for an ASAT.\n\t * @param xmlParser \n\t * \t\t\t\tthe parser for parsing the xml files.\n\t * @param filePaths\n\t * \t\t\t\tthe list containing the paths of the output files of an ASAT.\n\t * @throws IOException \n\t * \t\t\t\tthrows an exception if problem is encountered while parsing the files.\n\t */\n\tprivate void parseListOfFiles(XMLParser xmlParser, ArrayList\u003cString\u003e filePaths) throws IOException {\n\t\tif (filePaths !\u003d null) {\n\t\t\tfor (String path : filePaths) {\n\t\t\t\tparseFile(xmlParser, path);\n\t\t\t}\n\t\t}\n\t}\n\n\t/**\n\t * Parse an single output file of an ASAT.\n\t * \n\t * @throws IOException\n\t *             Throws an exception if problem is encountered while parsing the file.\n\t */\n\tprivate void parseFile(XMLParser xmlParser, String filePath) throws IOException {\n\t\tif (!new File(filePath).exists()) {\n\t\t\treturn;\n\t\t}\n\t\ttotalWarnings.addAll(xmlParser.parseFile(filePath));\n\t}\n\n\t/**\n\t * Groups the warnings together by packages and writes it as JSON output to\n\t * a JavaScript file.\n\t * \n\t * @param warnings\n\t *            List of warnings to work with.\n\t * @throws IOException\n\t *             Output file not found.\n\t */\n\tprivate void writeJSON() throws IOException {\n\t\tWarningGrouper wg \u003d new WarningGrouper(totalWarnings);\n\t\tList\u003cSummarizer\u003e list \u003d wg.groupBy(Criteria.PACKAGES);\n\n\t\tJSWriter jwriter \u003d JSWriter.getInstance();\n\t\tjwriter.setSummarizedWarnings(list);\n\t\tjwriter.writeToJSFormat(\"visualization/JSON/outputWarningsJSON.js\");\t\n\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\TSE\\Main.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport java.io.IOException;\n\n\nimport BlueTurtle.gui.GUI;\n\n/**\n * Main class to run the system.\n * \n * @author BlueTurtle.\n *\n */\npublic final class Main {\n\n\t/**\n\t * All the modes (programming languages).\n\t * \n\t * @author BlueTurtle.\n\t *\n\t */\n\tenum Mode {\n\t\tJAVA\n\t}\n\n\tprivate static Controller controller;\n\tprivate static Mode currentMode \u003d Mode.JAVA;\n\t\n\t/**\n\t * Private constructor for this utility class.\n\t */\n\tprivate Main() {\n\t\t// not called\n\t}\n\t\n\t/**\n\t * Main method.\n\t * \n\t * @param args\n\t *            the arguments.\n\t * @throws IOException\n\t *             throws an exception if a problem is encountered during the\n\t *             execution of the controller.\n\t */\n\tpublic static void main(String[] args) throws IOException {\n\n\t\tswitch (currentMode) {\n\t\tcase JAVA:\n\t\t\tcontroller \u003d new JavaController();\n\t\t\tGUI gui \u003d new GUI();\n\t\t\tgui.startGUI();\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t\tSystem.out.println(\"Done.\");\n\t}\n\n\t/**\n\t * Run compute all the necessary information needed for the visualization.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while computing\n\t *             the information.\n\t */\n\tpublic static void runVisualization() throws IOException {\n\t\tcontroller.execute();\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\CheckStyleWarning.java",
    "code": "\"package BlueTurtle.warnings;\n\n/**\n * This class is used to represent a checkstyle warning.\n * \n * @author BlueTurtle.\n *\n */\npublic class CheckStyleWarning extends Warning {\n\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param message\n\t *            the message of the warning.\n\t * \n\t * @param ruleName\n\t *            the rule name of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t */\n\tpublic CheckStyleWarning(String filePath, String filename, int line, String message, String ruleName, String classification) {\n\t\tsuper(filePath, filename, line, \"CheckStyle\", ruleName, message, classification);\n\t\tsetMessage(message.replaceAll(\"\u0027\", \"\"));\n\t}\n\n\t/**\n\t * Check whether two CheckStyle warnings are the same.\n\t * \n\t * @param other\n\t *            the other warning.\n\t * @return a boolean\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof CheckStyleWarning)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tCheckStyleWarning that \u003d (CheckStyleWarning) other;\n\n\t\t// fixed SimplifyBooleanReturn, Conditional logic can be removed.\n\t\treturn (ruleName.equals(that.ruleName) \u0026\u0026 filePath.equals(that.filePath) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 line \u003d\u003d that.line\n\t\t\t\t\u0026\u0026 message.equals(that.message) \u0026\u0026 classification.equals(that.classification) \u0026\u0026 type.equals(that.type));\n\n\t}\n\n\t/**\n\t * HashCode for the CheckStyle Warning.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(filePath, fileName, type, line, message, ruleName, classification);\n\t}\n\t\n\t/**\n\t * toString method for CheckStylWarning.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"CheckStyleWarning [line\u003d\" + line + \", message\u003d\" + message + \", classification\u003d\" + classification\n\t\t\t\t+ \", fileName\u003d\" + fileName + \", type\u003d\" + type + \", filePath\u003d\" + filePath + \", ruleName\u003d\" + ruleName\n\t\t\t\t+ \"]\";\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\FindBugsWarning.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class is used to represent a FindBugs warning.\n * \n * @author BlueTurtle.\n *\n */\npublic class FindBugsWarning extends Warning {\n\n\t\n\t@Getter @Setter private String category;\n\t@Getter @Setter private String priority;\n\n\t\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param message\n\t *            the message of the warning.\n\t * @param category\n\t *            the category of the warning.\n\t * @param priority\n\t *            the priority of the warning.            \n\t * @param ruleName\n\t *            the rule name of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t */\n\tpublic FindBugsWarning(String filePath, String filename, int line, String message, String category, String priority, String ruleName, String classification) {\n\t\tsuper(filePath, filename, line, \"FindBugs\", ruleName, message, classification);\n\t\tsetCategory(category);\n\t\tsetPriority(priority);\n\t}\n\t\n\n\t/**\n\t * Check whether two FindBugs warnings are the same.\n\t * \n\t * @param other\n\t *            the other warning.\n\t * @return a boolean\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof FindBugsWarning)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tFindBugsWarning that \u003d (FindBugsWarning) other;\n\n\t\treturn (filePath.equals(that.filePath) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 line \u003d\u003d that.line\n\t\t\t\t\u0026\u0026 message.equals(that.message) \u0026\u0026 category.equals(that.category) \u0026\u0026 classification.equals(that.classification)\n\t\t\t\t\u0026\u0026 priority.equals(that.priority) \u0026\u0026 type.equals(that.type) \u0026\u0026 ruleName.equals(that.ruleName));\n\t}\n\t\n\t/**\n\t * HashCode for the FindBugsWarning.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(filePath, fileName, type, line, message, category, priority, ruleName, classification);\n\t}\n\t\n\t/**\n\t * toString method for FindBugsWarning.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"FindBugsWarning [lineNumber\u003d\" + line + \", message\u003d\" + message + \", category\u003d\" + category\n\t\t\t\t+ \", priority\u003d\" + priority + \", classification\u003d\"\n\t\t\t\t+ classification + \", fileName\u003d\" + fileName + \", type\u003d\" + type + \", filePath\u003d\" + filePath\n\t\t\t\t+ \", ruleName\u003d\" + ruleName + \"]\";\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\PMDWarning.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class is used to represent a PMD warning.\n * \n * @author BlueTurtle.\n *\n */\npublic class PMDWarning extends Warning {\n\n\t@Getter @Setter private String ruleSet;\n\t@Getter @Setter private String method;\n\t@Getter @Setter private String packageName;\n\t\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param packageName\n\t *            the package of the warning.\n\t * @param ruleName\n\t *            the rule name of the warning.\n\t * @param ruleSet\n\t *            the ruleSet of the warning.\n\t * @param method\n\t *            the method of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t * @param message\n\t * \t\t\t  the message of the warning.\n\t */\n\tpublic PMDWarning(String filePath, String filename, int line, String packageName, String ruleSet, String method,  String ruleName, String message, String classification) {\n\t\tsuper(filePath, filename, line, \"PMD\", ruleName, message, classification);\n\t\tsetPackageName(packageName);\n\t\tsetRuleSet(ruleSet);\n\t\tsetMethod(method);\n\t}\n\n\t/**\n\t * Check whether two PMD warnings are the same.\n\t * \n\t * @param other\n\t *            the other warning.\n\t * @return a boolean\n\t */\n\t@Override\n\tpublic boolean equals(Object other) {\n\n\t\tif (!(other instanceof PMDWarning)) {\n\t\t\treturn false;\n\t\t}\n\n\t\tPMDWarning that \u003d (PMDWarning) other;\n\n\t\treturn (filePath.equals(that.filePath) \u0026\u0026 fileName.equals(that.fileName) \u0026\u0026 line \u003d\u003d that.line \u0026\u0026 message.equals(that.message)\n\t\t\t\t\u0026\u0026 classification.equals(that.classification) \u0026\u0026 packageName.equals(that.packageName) \u0026\u0026 type.equals(that.type) \n\t\t\t\t\u0026\u0026 ruleSet.equals(that.ruleSet) \u0026\u0026 method.equals(that.method) \u0026\u0026 ruleName.equals(that.ruleName));\n\t}\n\t\n\t/**\n\t * HashCode for the CheckStyle Warning.\n\t */\n\t@Override\n\tpublic int hashCode() {\n\t\treturn java.util.Objects.hash(filePath, fileName, type, line, packageName, ruleSet, method, ruleName, message, classification);\n\t}\n\t\n\t/**\n\t * toString method for PMDWarning.\n\t */\n\t@Override\n\tpublic String toString() {\n\t\treturn \"PMDWarning [line\u003d\" + line + \", ruleSet\u003d\" + ruleSet + \", method\u003d\" + method + \", packageName\u003d\"\n\t\t\t\t+ packageName + \", classification\u003d\" + classification + \", fileName\u003d\" + fileName + \", type\u003d\" + type\n\t\t\t\t+ \", filePath\u003d\" + filePath + \", message\u003d\" + message + \", ruleName\u003d\" + ruleName + \"]\";\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\warnings\\Warning.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class is used to represent a warning.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:visibilitymodifier\")\npublic abstract class Warning {\n\n\t@Getter @Setter protected String classification;\n\t@Getter @Setter protected String fileName;\n\t@Getter @Setter protected String type;\n\t@Getter @Setter protected String filePath;\n\t@Getter @Setter protected String ruleName;\n\t@Getter @Setter protected String message;\n\t@Getter @Setter protected int line;\n\n\n\t/**\n\t * Constructor.\n\t * \n\t * @param filePath\n\t *            the path to the file where the warning is located.\n\t * @param filename\n\t *            the name of the file where the warning is located.\n\t * @param line\n\t *            the line number where the warning is located.\n\t * @param type\n\t *            the type of the warning e.g. PMD.\n\t * @param ruleName\n\t *            the violated rule name of the warning.\n\t * @param message\n\t *            the message of the warning.\n\t * @param classification\n\t *            of the violated rule of the warning.\n\t */\n\tpublic Warning(String filePath, String filename, int line, String type, String ruleName, String message, String classification) {\n\t\tsetFileName(filename);\n\t\tsetFilePath(filePath);\n\t\tsetLine(line);\n\t\tsetType(type);\n\t\tsetRuleName(ruleName);\n\t\tsetClassification(classification); \n\t\tsetMessage(message);\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\java\\BlueTurtle\\writers\\JSWriter.java",
    "code": "\"package BlueTurtle.writers;\n\nimport java.io.BufferedWriter;\nimport java.io.File;\nimport java.io.FileWriter;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport com.google.gson.Gson;\nimport com.google.gson.GsonBuilder;\n\nimport BlueTurtle.TSE.CodeFile;\nimport BlueTurtle.gui.GUIController;\nimport BlueTurtle.summarizers.Summarizer;\nimport lombok.Getter;\nimport lombok.Setter;\n\n/**\n * This class can be used to write the output of the analyzer to JavaScript\n * format.\n * \n * @author BlueTurtle.\n *\n */\n@SuppressWarnings(\"checkstyle:nowhitespacebefore\")\npublic final class JSWriter {\n\n\tprivate static JSWriter jsWriter \u003d null;\n\n\t@Getter @Setter private List\u003cSummarizer\u003e summarizedWarnings;\n\n\t/**\n\t * Constructor. Only this class can instantiate itself.\n\t */\n\tprivate JSWriter() {\n\t}\n\n\t/**\n\t * Get an instance of this class.\n\t * \n\t * @return an instance of this class.\n\t */\n\tpublic static synchronized JSWriter getInstance() {\n\t\tif (jsWriter \u003d\u003d null) {\n\t\t\tjsWriter \u003d new JSWriter();\n\t\t}\n\t\treturn jsWriter;\n\t}\n\n\t/**\n\t * Write the summarized warnings to a file in JavaScript format.\n\t * \n\t * @param outputFilePath\n\t *            path to write the output to.\n\t * @throws IOException\n\t *             throws an exception if something went wrong in the process of\n\t *             writing to file.\n\t */\n\tpublic void writeToJSFormat(String outputFilePath) throws IOException {\n\t\tBufferedWriter writer \u003d new BufferedWriter(new FileWriter(outputFilePath));\n\t\tGson gson \u003d new GsonBuilder().setPrettyPrinting().create();\n\t\tString json \u003d gson.toJson(summarizedWarnings) + \u0027;\u0027;\n\t\twriter.write(\"var inputData \u003d \");\n\t\twriter.newLine();\n\t\twriter.write(json);\n\t\twriter.newLine();\n\t\twriter.write(\"var projectName \u003d \" + \u0027\"\u0027 + GUIController.getProjectPath().substring(\n\t\t\t\tGUIController.getProjectPath().lastIndexOf(File.separator) + 1,\n\t\t\t\tGUIController.getProjectPath().length()) + \u0027\"\u0027 + \u0027;\u0027) ;\n\t\twriter.flush();\n\t\twriter.close();\n\t}\n\n\t/**\n\t * Write the codefiles as JSON to a javascript file.\n\t * \n\t * @param codeFiles\n\t *            codefiles to write.\n\t * @param outputFilePath\n\t *            file to write to.\n\t * @throws IOException\n\t *             if outputfile is not found, inaccessible, etc.\n\t */\n\tpublic void writeSourceCodeToJS(ArrayList\u003cCodeFile\u003e codeFiles, String outputFilePath) throws IOException {\n\t\tBufferedWriter writer \u003d new BufferedWriter(new FileWriter(outputFilePath));\n\t\tGson gson \u003d new GsonBuilder().setPrettyPrinting().create();\n\t\tString json \u003d gson.toJson(codeFiles) + \u0027;\u0027;\n\t\twriter.write(\"var codeExport \u003d \");\n\t\twriter.newLine();\n\t\twriter.write(json);\n\t\twriter.flush();\n\t\twriter.close();\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\resources\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\resources\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\main\\resources\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\computers\\LOCComputerTest.java",
    "code": "\"package BlueTurtle.computers;\n\nimport static org.junit.Assert.assertSame;\n\nimport java.io.IOException;\n\nimport org.junit.Test;\n\n/**\n * Test for LOCFinder class.\n * \n * @author BlueTurtle.\n *\n */\npublic class LOCComputerTest {\n\n\t/**\n\t * Test that the right right number of lines is found from the file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t * \n\t */\n\t@Test\n\tpublic void testRightLOCFound() throws IOException {\n\t\tint numLines \u003d LOCComputer.getInstance().computeLOC(\"./src/test/resources/DefaultClass.java\");\n\t\tassertSame(5, numLines);\n\t}\n\n\t/**\n\t * Test finding the right number of lines is found in another file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testFindingLOCOnDifferentFile() throws IOException {\n\t\tint numLines \u003d LOCComputer.getInstance().computeLOC(\"./src/test/resources/ExampleTestClass.java\");\n\t\tassertSame(6, numLines);\n\t}\n\n\t/**\n\t * Test finding LOC in a non existing file should return zero.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test(expected \u003d IOException.class)\n\tpublic void testFindingLOCInNonExistingFile() throws IOException {\n\t\tint zero \u003d LOCComputer.getInstance().computeLOC(\"./NonExistingClass.java\");\n\t\tassertSame(0, zero);\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\finders\\PackageNameFinderTest.java",
    "code": "\"package BlueTurtle.finders;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\n\nimport java.io.IOException;\n\nimport org.junit.Test;\n\n/**\n * Test for PackageNameFinder class.\n * \n * @author BlueTurtle.\n *\n */\npublic class PackageNameFinderTest {\n\n\t/**\n\t * Test that the right package name is found from the file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testRightPackageNameFound() throws IOException {\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(\"./src/test/resources/ExampleClass.java\");\n\t\tassertEquals(\"SomePackage.subpackage\", packageName);\n\t}\n\n\t/**\n\t * Test finding the package name in another file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testFindingPackageNameOnDifferentFile() throws IOException {\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(\"./src/test/resources/ExampleTestClass.java\");\n\t\tassertNotEquals(\"SomePackage.subpackage\", packageName);\n\t}\n\n\t/**\n\t * Testing class that is in the default package.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testClassInDefaultPackage() throws IOException {\n\t\tString packageName \u003d PackageNameFinder.getInstance().findPackageName(\"./src/test/resources/DefaultClass.java\");\n\t\tassertEquals(\"default\", packageName);\n\t}\n\n\t/**\n\t * Test finding package name in a non-existing file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test(expected \u003d IOException.class)\n\tpublic void testFindingNameInNonExistingFile() throws IOException {\n\t\tPackageNameFinder.getInstance().findPackageName(\"./NonExstingFile.java\");\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\finders\\ProjectInfoFinderTest.java",
    "code": "\"package BlueTurtle.finders;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertFalse;\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Paths;\nimport java.util.HashSet;\nimport java.util.Set;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\n/**\n * Test for the ProjectInforFinder class.\n * \n * @author BlueTurtle.\n *\n */\npublic class ProjectInfoFinderTest {\n\n\tprivate ProjectInfoFinder pif;\n\tprivate String exampleFilePath;\n\n\t/**\n\t * Initialize the objects that are needed.\n\t * \n\t * @throws Exception\n\t *             throws an exception if problem is encountered while\n\t *             instantiating the objects.\n\t */\n\t@Before\n\tpublic void setUp() throws Exception {\n\t\tpif \u003d new ProjectInfoFinder();\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getOutputFilesPaths().clear();\n\t\texampleFilePath \u003d Paths.get(\"src\", \"test\", \"resources\", \"TestCodeFolder\", \"AllClosestPoints.java\")\n\t\t\t\t.toAbsolutePath().toString();\n\t\tpif.findFiles(new File(Paths.get(\"src\", \"test\", \"resources\").toAbsolutePath().toString()));\n\t}\n\n\t/**\n\t * Cleanup the fields of ProjectInfoFinder used for testing.\n\t * \n\t * @throws Exception\n\t *             throws an exception if problem is encountered while cleaning\n\t *             up the attributes.\n\t */\n\t@After\n\tpublic void cleanUp() throws Exception {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getOutputFilesPaths().clear();\n\t}\n\n\t/**\n\t * Test finding files does not give an empty list of paths.\n\t * \n\t */\n\t@Test\n\tpublic void testFindFilesNonEmptyListOfPaths() {\n\t\tassertFalse(ProjectInfoFinder.getClassPaths().isEmpty());\n\t}\n\n\t/**\n\t * Test that the right package name is returned given a path to a file.\n\t * \n\t */\n\t@Test\n\tpublic void testRightPackageNameForPathIsReturned() {\n\t\tString packageName \u003d ProjectInfoFinder.getClassPackage().get(exampleFilePath);\n\t\tassertEquals(\"default\", packageName);\n\t}\n\n\t/**\n\t * Test that the right loc is returned given path.\n\t * \n\t */\n\t@Test\n\tpublic void testRightLOCForPathIsReturned() {\n\t\tint actual \u003d ProjectInfoFinder.getClassLocs().get(exampleFilePath);\n\t\tassertEquals(272, actual);\n\t}\n\n\t/**\n\t * Test that the right set of packages names is returned given path.\n\t * \n\t */\n\t@Test\n\tpublic void testRightSetOfPackagesIsReturned() {\n\t\tSet\u003cString\u003e actual \u003d ProjectInfoFinder.getPackages();\n\t\tSet\u003cString\u003e expected \u003d new HashSet\u003cString\u003e();\n\t\texpected.add(\"default\");\n\t\texpected.add(\"SomePackage.different\");\n\t\texpected.add(\"SomePackage.subpackage\");\t\t\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test retrieveCodeFiles method. At least one instance of CodeFile should be added to codeFiles field.\n\t * @throws IOException\n\t * \t\t\t\tif file is not found, inaccessible, etc.\n\t */\n\t@Test\n\tpublic void testRetrieveCodeFiles() throws IOException {\n\t\tpif.retrieveCodeFiles();\n\t\tassertTrue(pif.getCodeFiles().size() \u003e 0);\n\t}\n\t\n\t\n\t/**\n\t * Test the correct behaviour of checkForOutputFile.\n\t */\n\t@Test\n\tpublic void testCheckForOutputFileTrue() {\n\t\tassertTrue(new ProjectInfoFinder().checkForASATOutputFile(\"checkstyle-result.xml\"));\n\t}\n\t\n\t/**\n\t * Test the correct behaviour of checkForOutputFile.\n\t */\n\t@Test\n\tpublic void testCheckForOutputFileFalse() {\n\t\tassertFalse(new ProjectInfoFinder().checkForASATOutputFile(\"Hello I am a test string\"));\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\groupers\\WarningGrouperTest.java",
    "code": "\"package BlueTurtle.groupers;\n\nimport static org.junit.Assert.assertNull;\nimport static org.junit.Assert.assertTrue;\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertFalse;\nimport static org.junit.Assert.assertNotEquals;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Paths;\nimport java.util.ArrayList;\nimport java.util.EnumMap;\nimport java.util.List;\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.summarizers.ComponentSummarizer;\nimport BlueTurtle.summarizers.PackageSummarizer;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Tests for the WarningGrouper class.\n * \n * @author BlueTurtle.\n *\n */\npublic class WarningGrouperTest {\n\n\tprivate ComponentSummarizer cs;\n\tprivate ComponentSummarizer cs2;\n\tprivate ComponentSummarizer cs3;\n\tprivate ComponentSummarizer cs4;\n\tprivate PackageSummarizer ps;\n\tprivate PackageSummarizer ps2;\n\tprivate List\u003cWarning\u003e warnings;\n\tprivate Warning w;\n\tprivate Warning w2;\n\tprivate Warning w3;\n\tprivate Warning w4;\n\n\t/**\n\t * Initialize necessary objects.\n\t * \n\t * @throws IOException\n\t *             throws an exception if there problem was encountered while\n\t *             reading file.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\tString filePath \u003d Paths.get(\"src\", \"test\", \"resources\", \"ExampleClass.java\").toAbsolutePath().toString();\n\t\tString filePath2 \u003d Paths.get(\"src\", \"test\", \"resources\", \"ExampleTestClass.java\").toAbsolutePath().toString();\n\t\tString filePath3 \u003d Paths.get(\"src\", \"test\", \"resources\", \"TestCodeFolder\", \"AllClosestPoints.java\").toAbsolutePath().toString();\n\t\tString filePath4 \u003d Paths.get(\"src\", \"test\", \"resources\", \"DefaultClass.java\").toAbsolutePath().toString();\n\t\tw \u003d new CheckStyleWarning(filePath, \"ExampleClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw2 \u003d new CheckStyleWarning(filePath2, \"ExampleTestClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw3 \u003d new CheckStyleWarning(filePath3, \"AllClosestPoints.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw4 \u003d new CheckStyleWarning(filePath4, \"DefaultClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tcs \u003d new ComponentSummarizer(\"ExampleClass.java\", filePath, \"SomePackage.subpackage\");\n\t\tcs2 \u003d new ComponentSummarizer(\"ExampleTestClass.java\", filePath2, \"SomePackage.different\");\n\t\tcs3 \u003d new ComponentSummarizer(\"AllClosestPoints.java\", filePath3, \"default\");\n\t\tcs4 \u003d new ComponentSummarizer(\"DefaultClass.java\", filePath4, \"default\");\n\t\tps \u003d new PackageSummarizer(\"SomePackage.subpackage\");\n\t\tps2 \u003d new PackageSummarizer(\"SomePackage.different\");\n\t\twarnings \u003d new ArrayList\u003cWarning\u003e();\n\t\twarnings.add(w);\n\t\twarnings.add(w2);\n\t\twarnings.add(w3);\n\t\twarnings.add(w4);\t\t\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanAttributes() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t}\n\n\t/**\n\t * Test group by default case.\n\t */\n\t@Test\n\tpublic void testGroupByDefaultCase() {\n\t\tList\u003cWarning\u003e warnings \u003d new ArrayList\u003cWarning\u003e();\n\t\twarnings.add(w);\n\t\twarnings.add(w2);\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tassertNull(wg.groupBy(null));\n\t}\n\n\t/**\n\t * Test group by components.\n\t */\n\t@Test\n\tpublic void testGroupByComponents() {\n\t\tList\u003cSummarizer\u003e expected \u003d new ArrayList\u003cSummarizer\u003e();\n\t\tcs.summarise(warnings);\n\t\tcs2.summarise(warnings);\n\t\tcs3.summarise(warnings);\n\t\tcs4.summarise(warnings);\n\t\texpected.add(cs4);\n\t\texpected.add(cs);\n\t\texpected.add(cs2);\n\t\texpected.add(cs3);\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tassertTrue(expected.containsAll(wg.groupBy(Criteria.COMPONENTS)));\n\t}\n\n\t/**\n\t * Test group by packages.\n\t */\n\t@Test\n\tpublic void testGroupByPackages() {\n\t\tps.summarise(warnings);\n\t\tps2.summarise(warnings);\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tList\u003cSummarizer\u003e list \u003d wg.groupBy(Criteria.PACKAGES);\n\n\t\t// because the order of the set is not always the same.\n\t\tboolean answer \u003d list.contains(ps) \u0026\u0026 list.contains(ps2);\n\t\tassertTrue(answer);\n\t}\n\n\t/**\n\t * Test equals where both grouper are the same.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tWarningGrouper wg2 \u003d new WarningGrouper(warnings);\n\t\tassertEquals(wg, wg2);\n\t}\n\n\t/**\n\t * Test objects that are the same should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tWarningGrouper wg2 \u003d new WarningGrouper(warnings);\n\t\tassertEquals(wg.hashCode(), wg2.hashCode());\n\t}\n\n\t/**\n\t * Test equals where the warnings are different.\n\t */\n\t@Test\n\tpublic void testEqualsFalseDifferentWarningList() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(new ArrayList\u003cWarning\u003e());\n\t\tWarningGrouper wg2 \u003d new WarningGrouper(warnings);\n\t\tassertNotEquals(wg, wg2);\n\t}\n\n\t/**\n\t * Test equals with different object (that is not a grouper).\n\t */\n\t@Test\n\tpublic void testEqualsFalseDifferentObject() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tboolean answer \u003d wg.equals(Integer.valueOf(6));\n\t\tassertFalse(answer);\n\t}\n\n\t/**\n\t * Test summarizedWarnings.\n\t */\n\t@Test\n\tpublic void testSummarizedWarnings() {\n\t\tWarningGrouper wg \u003d new WarningGrouper(warnings);\n\t\tEnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e empty \u003d new EnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e(Criteria.class);\n\t\tEnumMap\u003cCriteria, List\u003cSummarizer\u003e\u003e actual \u003d wg.getSummarizedWarnings();\n\t\tassertNotEquals(empty, actual);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\CheckStyleXMLParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.List;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test class for CheckStyleXMLParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class CheckStyleXMLParserTest {\n\n\tprivate static String testSet \u003d \"./src/test/resources/exampleCheckstyle1.xml\";\n\tprivate static String testSet2 \u003d \"./src/test/resources/exampleCheckstyle2.xml\";\n\tprivate static String srcDir \u003d System.getProperty(\"user.dir\") + \"/src\";\n\n\tprivate static String testSet2FileName \u003d \"Warning.java\";\n\tprivate static String testSet2Message \u003d \"Unused @param tag for \u0027filePath\u0027.\";\n\tprivate static String testSet2RuleName \u003d \"JavadocMethod\";\n\tprivate static String testSet2Classification \u003d \"Documentation Conventions\";\n\tprivate static String testSet3FilePath \u003d System.getProperty(\"user.dir\") + File.separatorChar + \"src\"\n\t\t\t+ File.separatorChar + \"main\" + File.separatorChar + \"java\" + File.separatorChar + \"BlueTurtle\"\n\t\t\t+ File.separatorChar + \"warnings\" + File.separatorChar + \"Warning.java\";\n\n\t/**\n\t * Set up the GDP parser, parse the category information.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is ecountered while reading\n\t *             the files.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tnew ProjectInfoFinder().findFiles(new File(srcDir));\n\t}\n\t\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanUp() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t}\n\n\t/**\n\t * Test that the parser can parse a valid CheckStyle output file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertSame(5, warnings.size());\n\t}\n\n\t/**\n\t * Test whether the getRuleName method works as it should.\n\t */\n\t@Test\n\tpublic void testGetRuleNameCorrectBehaviour() {\n\t\tString expected \u003d \"PackageName\";\n\t\tString actual \u003d CheckStyleXMLParser\n\t\t\t\t.getRuleName(\"com.puppycrawl.tools.checkstyle.checks.naming.PackageNameCheck\");\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(testSet3FilePath, testSet2FileName, 20, testSet2Message,\n\t\t\t\ttestSet2RuleName, testSet2Classification);\n\n\t\tCheckStyleWarning actual \u003d (CheckStyleWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test that the parser created the right amount of warnings.\n\t */\n\t@Test\n\tpublic void testCreateRightAmountOfWarnings() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertNotSame(6, warnings.size());\n\t}\n\n\t/**\n\t * Test whether the method work for another rule name.\n\t */\n\t@Test\n\tpublic void testGetRuleNameCorrectBehaviour2() {\n\t\tString expected \u003d \"PackageName\";\n\t\tString actual \u003d CheckStyleXMLParser\n\t\t\t\t.getRuleName(\"com.puppycrawl.tools.checkstyle.checks.naming.JavadocMethodCheck\");\n\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning2() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(testSet3FilePath, testSet2FileName, 21, testSet2Message,\n\t\t\t\ttestSet2RuleName, testSet2Classification);\n\n\t\tCheckStyleWarning actual \u003d (CheckStyleWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tXMLParser parser \u003d new CheckStyleXMLParser();\n\n\t\tString testSet3 \u003d \"/ex.xml\";\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet3);\n\n\t\tassertSame(0, warnings.size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\FindBugsXMLParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.List;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.FindBugsWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test class for FindBugsXMLParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class FindBugsXMLParserTest {\n\n\tprivate static String testSet2 \u003d \"./src/test/resources/exampleFindbugs1.xml\";\n\tprivate static String srcDir \u003d System.getProperty(\"user.dir\") + \"/src\";\n\n\tprivate static String testSet2FileName \u003d \"FindBugsWarning.java\";\n\tprivate static String testSet2RuleName \u003d \"HE_EQUALS_USE_HASHCODE\";\n\tprivate static String testSet2Message \u003d \"BlueTurtle.warnings.FindBugsWarning defines equals and uses Object.hashCode()\";\n\tprivate static String testSet2Category \u003d \"BAD_PRACTICE\";\n\tprivate static String testSet2Priority \u003d \"High\";\n\tprivate static String testSet2Classification \u003d \"Interface\";\n\tprivate static String testSet3FilePath \u003d System.getProperty(\"user.dir\") + File.separatorChar + \"src\"\n\t\t\t+ File.separatorChar + \"main\" + File.separatorChar + \"java\" + File.separatorChar + \"BlueTurtle\"\n\t\t\t+ File.separatorChar + \"warnings\" + File.separatorChar + \"FindBugsWarning.java\";\n\n\t/**\n\t * Set up the GDP parser, parse the category information.\n\t * \n\t * @throws IOException\n\t *             throws an exception while reading the files.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tnew ProjectInfoFinder().findFiles(new File(srcDir));\n\t}\n\n\t/**\n\t * Clear the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void tearDown() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\n\t}\n\n\t/**\n\t * Test that the parser can parse a valid FindBugs output file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tFindBugsXMLParser parser \u003d new FindBugsXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet2);\n\n\t\tassertSame(2, warnings.size());\n\t}\n\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning() {\n\t\tFindBugsXMLParser parser \u003d new FindBugsXMLParser();\n\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(testSet3FilePath, testSet2FileName, 47, testSet2Message,\n\t\t\t\ttestSet2Category, testSet2Priority, testSet2RuleName, testSet2Classification);\n\n\t\tFindBugsWarning actual \u003d (FindBugsWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tFindBugsXMLParser parser \u003d new FindBugsXMLParser();\n\n\t\tString testSet3 \u003d \"/ex.xml\";\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet3);\n\n\t\tassertSame(0, warnings.size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\GDCParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.util.HashMap;\n\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertTrue;\n\nimport org.junit.Test;\n\n/**\n * Test class for GDCParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class GDCParserTest {\n\n\tprivate static String testSet \u003d \"./src/test/resources/htmlExample.html\";\n\n\n\t/**\n\t * Test that the parser can parse a valid GDC html file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tGDCParser parser \u003d GDCParser.getInstance();\n\n\t\tHashMap\u003cString, String\u003e categoryInfo \u003d parser.parseFile(testSet);\n\n\t\tassertTrue(categoryInfo.containsValue(\"Naming Conventions\"));\n\t}\n\t\n\t/**\n\t * Test that the parser created the right amount of warnings.\n\t */\n\t@Test\n\tpublic void testCreateRightAmountOfWarnings() {\n\t\tGDCParser parser \u003d GDCParser.getInstance();\n\n\t\tHashMap\u003cString, String\u003e categoryInfo \u003d parser.parseFile(testSet);\n\n\t\tassertSame(2, categoryInfo.size());\n\t}\t\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tGDCParser parser \u003d GDCParser.getInstance();\n\t\t\n\t\tString testSet3 \u003d \"./src/test/resources/ex.xml\";\n\n\t\tHashMap\u003cString, String\u003e warnings \u003d parser.parseFile(testSet3);\n\t\t\n\t\tassertNotSame(6, warnings.size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\parsers\\PMDXMLParserTest.java",
    "code": "\"package BlueTurtle.parsers;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.List;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.PMDWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test class for PMDXMLParser.\n * \n * @author BlueTurtle.\n *\n */\npublic class PMDXMLParserTest {\n\n\tprivate static String testSet \u003d \"./src/test/resources/examplePmd1.xml\";\n\tprivate static String testSet2 \u003d \"./src/test/resources/examplePmd2.xml\";\n\tprivate static String srcDir \u003d System.getProperty(\"user.dir\") + \"/src\";\n\n\tprivate static String testSetFileName \u003d \"CheckStyleWarning.java\";\n\tprivate static String testSetRuleName \u003d \"OverrideBothEqualsAndHashcode\";\n\tprivate static String testSetPackageName \u003d \"BlueTurtle.warnings\";\n\tprivate static String testSetRuleSet \u003d \"Basic\";\n\tprivate static String testSetMethod \u003d \"equals\";\n\tprivate static String testSetClassification \u003d \"Interface\";\n\tprivate static String testSetMessage \u003d \"\\nEnsure you override both equals() and hashCode()\\n\";\n\tprivate static String testSet3FilePath \u003d System.getProperty(\"user.dir\") + File.separatorChar + \"src\"\n\t\t\t+ File.separatorChar + \"main\" + File.separatorChar + \"java\" + File.separatorChar + \"BlueTurtle\"\n\t\t\t+ File.separatorChar + \"warnings\" + File.separatorChar + \"CheckStyleWarning.java\";\n\n\t/**\n\t * Set up the GDP parser, parse the category information.\n\t * \n\t * @throws IOException\n\t *             throws an exception if there was a problem found while\n\t *             reading the file.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tnew ProjectInfoFinder().findFiles(new File(srcDir));\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanUp() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t}\n\n\t/**\n\t * Test that the parser can parse a valid PMD output file.\n\t */\n\t@Test\n\tpublic void testParseCorrectBehaviour() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertSame(1, warnings.size());\n\t}\n\n\t// The PMD parser need to be fixed, the rule name need to be combined with\n\t// ruleset and rulename, basic.xml/OverrideBoth.\n\t/**\n\t * Test whether the parser creates the right object.\n\t */\n\t@Test\n\tpublic void testParsingOneWarning() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tPMDWarning expected \u003d new PMDWarning(testSet3FilePath, testSetFileName, 43, testSetPackageName, testSetRuleSet,\n\t\t\t\ttestSetMethod, testSetRuleName, testSetMessage, testSetClassification);\n\n\t\tPMDWarning actual \u003d (PMDWarning) parser.parseFile(testSet2).get(0);\n\n\t\tassertEquals(expected.getMessage(), actual.getMessage());\n\t}\n\n\t/**\n\t * Test that the parser created the right amount of warnings.\n\t */\n\t@Test\n\tpublic void testCreateRightAmountOfWarnings() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet);\n\n\t\tassertNotSame(6, warnings.size());\n\t}\n\n\t/**\n\t * Test that the parser parse the wrong file.\n\t */\n\t@Test\n\tpublic void testParseTheWrongFile() {\n\t\tXMLParser parser \u003d new PMDXMLParser();\n\n\t\tString testSet3 \u003d \"/ex.xml\";\n\n\t\tList\u003cWarning\u003e warnings \u003d parser.parseFile(testSet3);\n\n\t\tassertSame(0, warnings.size());\n\t}\n\n\t/**\n\t * Test that the XML parser classify method.\n\t */\n\t@Test\n\tpublic void testXMLParserClassify() {\n\t\tString classification \u003d XMLParser.classify(\"AbstractClassName\");\n\n\t\tassertEquals(\"Naming Conventions\", classification);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\summarizers\\ComponentSummarizerTest.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController.ASAT;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.FindBugsWarning;\nimport BlueTurtle.warnings.PMDWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test for the ComponentSummarizer class.\n * \n * @author BlueTurtle.\n *\n */\npublic class ComponentSummarizerTest {\n\n\tprivate String filePath;\n\tprivate String filePath2;\n\tprivate String fileName;\n\tprivate String packageName;\n\tprivate List\u003cWarning\u003e warningList;\n\tprivate Warning w;\n\tprivate List\u003cWarning\u003e warningList2;\n\tprivate Warning w2;\n\n\t/**\n\t * Initialize necessary objects.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the file.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\tfilePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\n\t\t\t\t\"src\" + File.separator + \"test\" + File.separator + \"resources\" + File.separator + \"ExampleClass.java\"))\n\t\t\t\t.findFirst().get();\n\t\tfilePath2 \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\"src\" + File.separator\n\t\t\t\t+ \"test\" + File.separator + \"resources\" + File.separator + \"ExampleTestClass.java\")).findFirst().get();\n\t\tfileName \u003d \"ExampleClass.java\";\n\t\tpackageName \u003d \"SomePackage.subpackage\";\n\t\tw \u003d new CheckStyleWarning(filePath, fileName, 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw2 \u003d new CheckStyleWarning(filePath2, fileName, 3, \"Test\", \"TestRule\", \"Class\");\n\t\twarningList \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2 \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2.add(w2);\n\t\twarningList.add(w);\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void clearAttributes() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t}\n\n\t/**\n\t * Test that the number of warnings is zero when the object is just created.\n\t */\n\t@Test\n\tpublic void testNumWarningsIsZero() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertSame(0, cs.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test the file path of the summarizer.\n\t */\n\t@Test\n\tpublic void testFilePath() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertSame(filePath, cs.getFilePath());\n\t}\n\n\t/**\n\t * Test that the number of warnings is not zero after summarise has been\n\t * called.\n\t */\n\t@Test\n\tpublic void testNumWarningsIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tassertSame(cs.getWarningList().size(), cs.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * name and file path.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentNameAndPath() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(\"ExampleTestClass.java\", filePath2, packageName);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * name.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentName() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(\"Not same name\", filePath, packageName);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * file path.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentPath() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath2, packageName);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. They have different file\n\t * package name.\n\t */\n\t@Test\n\tpublic void testEqualsWithDifferentPackageName() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, \"Not same package\");\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. Both do summarizes the\n\t * warnings.\n\t */\n\t@Test\n\tpublic void testEqualsTrueAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tcs2.summarise(warningList);\n\t\tassertEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test objects that are the same should return same hashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertEquals(cs.hashCode(), cs2.hashCode());\n\t}\n\n\t/**\n\t * Test equals between two component summarizer. Only one summarizes the\n\t * warnings.\n\t */\n\t@Test\n\tpublic void testEqualsFalseAfterWithOneSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tassertNotEquals(cs, cs2);\n\t}\n\n\t/**\n\t * Test summarizing warnings from components with same name but from\n\t * different package.\n\t */\n\t@Test\n\tpublic void testSummarizingWarningDiffrentPackage() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList2);\n\t\tassertSame(0, cs.getNumberOfWarnings());\n\t}\n\n\t/**\n\t * Test equal with different object.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDiffernetObject() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertNotEquals(cs, Integer.valueOf(1));\n\t}\n\n\t/**\n\t * Test that the number of PMD warnings is not zero after summarise has been\n\t * called.\n\t */\n\t@Test\n\tpublic void testNumPMDWarningsIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\twarningList.add(new PMDWarning(filePath, fileName, 3, packageName, \"test\", \"test2\", \"test3\", \"test4\", \"Class\"));\n\t\tcs.summarise(warningList);\n\t\tassertSame(1, cs.numberOfPMDWarnings);\n\t}\n\n\t/**\n\t * Test that the number of FindBugs warnings is not zero after summarise has\n\t * been called.\n\t */\n\t@Test\n\tpublic void testNumFindBugsWarningsIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\twarningList.add(new FindBugsWarning(filePath, fileName, 3, \"testMessage\", \"test\", \"test2\", \"test3\", \"test4\"));\n\t\tcs.summarise(warningList);\n\t\tassertSame(1, cs.numberOfFindBugsWarnings);\n\t}\n\n\t/**\n\t * Test that a IllegalArgumentException is thrown for incrementNumWarnings.\n\t * called.\n\t */\n\t@Test(expected \u003d IllegalArgumentException.class)\n\tpublic void testIllegalArgumentExceptionIncrementNumWarnings() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\twarningList.add(new FindBugsWarning(filePath, fileName, 3, \"testMessage\", \"test\", \"test2\", \"test3\", \"test4\"));\n\t\tcs.summarise(warningList);\n\t\tcs.incrementNumberOfWarnings(ASAT.valueOf(\"Not a right type of ASAT\"));\n\t}\n\n\t/**\n\t * Test that the loc is not zero after summarise has been called.\n\t */\n\t@Test\n\tpublic void testLOCIsNotZeroAfterSummarise() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tcs.summarise(warningList);\n\t\tassertNotSame(0, cs.getLoc());\n\t}\n\t\n\t/**\n\t * Test two equal ComponentSummarizer return the same string.\n\t */\n\t@Test\n\tpublic void testSameStringShouldBeReturned() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tassertEquals(cs.toString(), cs2.toString());\n\t}\n\t\n\t/**\n\t * Test two different ComponentSummarizer return the different string.\n\t */\n\t@Test\n\tpublic void testDifferentStringShouldBeReturned() {\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(fileName, filePath, packageName);\n\t\tComponentSummarizer cs2 \u003d new ComponentSummarizer(\"Test\", filePath, packageName);\n\t\tassertNotEquals(cs.toString(), cs2.toString());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\summarizers\\PackageSummarizerTest.java",
    "code": "\"package BlueTurtle.summarizers;\n\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertFalse;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.HashSet;\nimport java.util.List;\nimport java.util.Set;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Test for the PackageSummarizer class.\n * \n * @author BlueTurtle.\n *\n */\npublic class PackageSummarizerTest {\n\n\tprivate String packageName;\n\tprivate List\u003cWarning\u003e warningList;\n\tprivate Warning w;\n\tprivate List\u003cWarning\u003e warningList2;\n\tprivate Warning w2;\n\tprivate String filePath;\n\tprivate String filePath2;\n\n\t/**\n\t * Initialize necessary objects.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem was encountered while reading\n\t *             files.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\tfilePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\n\t\t\t\t\"src\" + File.separator + \"test\" + File.separator + \"resources\" + File.separator + \"ExampleClass.java\"))\n\t\t\t\t.findFirst().get();\n\t\tfilePath2 \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\"src\" + File.separator\n\t\t\t\t+ \"test\" + File.separator + \"resources\" + File.separator + \"ExampleTestClass.java\")).findFirst().get();\n\t\tpackageName \u003d \"SomePackage.subpackage\";\n\t\tw \u003d new CheckStyleWarning(filePath, \"ExampleClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\tw2 \u003d new CheckStyleWarning(filePath2, \"ExampleTestClass.java\", 3, \"Test\", \"TestRule\", \"Class\");\n\t\twarningList \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2 \u003d new ArrayList\u003cWarning\u003e();\n\t\twarningList2.add(w2);\n\t\twarningList2.add(w);\n\t\twarningList.add(w);\n\t}\n\n\t/**\n\t * Clean up the attributes of ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanUpAttributes() {\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t}\n\n\t/**\n\t * Test that there is no warning when the object is made.\n\t */\n\t@Test\n\tpublic void testNumWarningIsZero() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tassertSame(0, ps.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test that the number of warning is not zero after summarise.\n\t */\n\t@Test\n\tpublic void testNotZeroSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tassertNotSame(0, ps.numberOfWarnings);\n\t}\n\n\t/**\n\t * Test that the number of CheckStyle warnings is not zero after summarise.\n\t */\n\t@Test\n\tpublic void testCheckStyleWarningsIsNotZero() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tassertNotSame(0, ps.numberOfCheckStyleWarnings);\n\t}\n\n\t/**\n\t * Test that the number of classes is not zero after summarise.\n\t */\n\t@Test\n\tpublic void testNumClassesIsNotZero() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tassertSame(1, ps.getNumberOfClasses());\n\t}\n\n\t/**\n\t * Test that warning types is not empty after summarise.\n\t */\n\t@Test\n\tpublic void testWarningTypeIsNotEmptyAfterSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList);\n\t\tSet\u003cString\u003e expected \u003d new HashSet\u003cString\u003e();\n\t\texpected.add(\"CheckStyle\");\n\t\tassertEquals(expected, ps.warningTypes);\n\t}\n\n\t/**\n\t * Test that classes is not empty after summarise.\n\t */\n\t@Test\n\tpublic void testClassesIsNotEmptyAfterSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tList\u003cComponentSummarizer\u003e list \u003d new ArrayList\u003cComponentSummarizer\u003e();\n\t\tComponentSummarizer cs \u003d new ComponentSummarizer(\"ExampleClass.java\", filePath, packageName);\n\t\tcs.summarise(warningList2);\n\t\tlist.add(cs);\n\t\tassertEquals(list, ps.getClasses());\n\t}\n\n\t/**\n\t * Test findOwnClasses.\n\t */\n\t@Test\n\tpublic void testfindOwnClasses() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tHashMap\u003cString, String\u003e expected \u003d new HashMap\u003cString, String\u003e();\n\t\texpected.put(\"ExampleClass.java\", filePath);\n\n\t\tHashMap\u003cString, String\u003e actual \u003d ps.findOwnClasses(warningList2);\n\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equals false with only one PackageSummarizer running summarise.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithOneRunningSummarise() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertNotEquals(ps2, ps);\n\t}\n\n\t/**\n\t * Test equals where both is running summarise.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tps2.summarise(warningList2);\n\t\tassertEquals(ps2, ps);\n\t}\n\n\t/**\n\t * Test objects that are the same should return same hashCode.\n\t */\n\t@Test\n\tpublic void tesSameHashCode() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertEquals(ps2.hashCode(), ps.hashCode());\n\t}\n\n\t/**\n\t * Test equals with another object.\n\t */\n\t@Test\n\tpublic void testEqualsWithAnotherObject() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tps.summarise(warningList2);\n\t\tboolean answer \u003d ps.equals(Integer.valueOf(5));\n\t\tassertFalse(answer);\n\t}\n\t\n\t/**\n\t * Test two equals PackageSummarizer return the same string.\n\t */\n\t@Test\n\tpublic void testSameStringIsReturned() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(packageName);\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertEquals(ps2.toString(), ps.toString());\n\t}\n\t\n\t/**\n\t * Test two different PackageSummarizer return the different string.\n\t */\n\t@Test\n\tpublic void testDifferentStringShouldBeReturned() {\n\t\tPackageSummarizer ps \u003d new PackageSummarizer(\"Test\");\n\t\tPackageSummarizer ps2 \u003d new PackageSummarizer(packageName);\n\t\tassertNotEquals(ps.toString(), ps2.toString());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\TSE\\CodeFileTest.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\n\nimport org.junit.Before;\nimport org.junit.Test;\n\n/**\n * Test CodeFile class.\n * @author michiel\n *\n */\npublic class CodeFileTest {\n\tprivate CodeFile codeFile;\n\tprivate File testFile \u003d new File(\"./src/test/resources/CodeFileTestFile.txt\");\n\t\n\t/**\n\t * Setup method, initialize CodeFile.\n\t * @throws IOException\n\t * \t\t\t\tif file not found, inaccessible, etc.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tcodeFile \u003d new CodeFile();\n\t}\n\t\n\t/**\n\t * Test if the getCodeFromFile method actually reads and stores code from a file.\n\t * @throws IOException\n\t * \t\t\t\tif file not found, inaccessible, etc.\n\t */\n\t@Test\n\tpublic void testGetCodeFromFile() throws IOException {\n\t\tcodeFile.getCodeFromFile(testFile);\n\t\tassertTrue(codeFile.getCode().length() \u003e 0);\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\TSE\\JavaControllerTest.java",
    "code": "\"package BlueTurtle.TSE;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\n\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.gui.GUIController;\nimport BlueTurtle.gui.GUIController.ASAT;\n\n/**\n * Test for the JavaController class.\n * \n * @author BlueTurtle.\n *\n */\npublic class JavaControllerTest {\n\n\tprivate String userDir \u003d System.getProperty(\"user.dir\");\n\tprivate ArrayList\u003cString\u003e checkstyleList \u003d new ArrayList\u003cString\u003e();\n\tprivate ArrayList\u003cString\u003e pmdList \u003d new ArrayList\u003cString\u003e();\n\tprivate ArrayList\u003cString\u003e findBugsList \u003d new ArrayList\u003cString\u003e();\n\tprivate String checkStyleOutputFilePath \u003d userDir + \"/src/test/resources/exampleCheckstyle1.xml\";\n\tprivate String pmdOutputFilePath \u003d userDir + \"/src/test/resources/examplePmd1.xml\";\n\tprivate String findBugsOutputFilePath \u003d userDir + \"/src/test/resources/exampleFindbugs1.xml\";\n\n\t/**\n\t * Clear the attributes of JavaController.\n\t * \n\t * @throws IOException\n\t *             throws an exception if there was a problem encounterd while\n\t *             reading the files.\n\t */\n\t@Before\n\tpublic void setUp() throws IOException {\n\t\tGUIController.setProjectPath(\"test\");\n\t\tcheckstyleList.add(checkStyleOutputFilePath);\n\t\tpmdList.add(pmdOutputFilePath);\n\t\tfindBugsList.add(findBugsOutputFilePath);\n\t\tnew ProjectInfoFinder().findFiles(new File(userDir));\n\t\tJavaController.setCheckStyleOutputFiles(null);\n\t\tJavaController.setPmdOutputFiles(null);\n\t\tJavaController.setFindBugsOutputFiles(null);\n\t}\n\n\t/**\n\t * Delete the created files.\n\t */\n\t@After\n\tpublic void cleanUp() {\n\t\tFile f \u003d new File(userDir + \"/src/main/resources/SummarizedOuput.js\");\n\t\tGUIController.setProjectPath(null);\n\t\tif (f.exists()) {\n\t\t\tf.delete();\n\t\t}\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t}\n\n\t/**\n\t * Test that the user direction path is the same.\n\t */\n\t@Test\n\tpublic void testUserDir() {\n\t\tString expected \u003d userDir;\n\t\tString actual \u003d JavaController.getUserDir();\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test that all files are null at first.\n\t */\n\t@Test\n\tpublic void allFilesStringsAreNull() {\n\t\tassertTrue(JavaController.getCheckStyleOutputFiles() \u003d\u003d null \u0026\u0026 JavaController.getPmdOutputFiles() \u003d\u003d null\n\t\t\t\t\u0026\u0026 JavaController.getFindBugsOutputFiles() \u003d\u003d null);\n\t}\n\n\t/**\n\t * Test changing CheckStyle list of output file.\n\t */\n\t@Test\n\tpublic void testChangingCheckStyleOutputFile() {\n\t\tArrayList\u003cString\u003e list \u003d JavaController.getCheckStyleOutputFiles();\n\t\tArrayList\u003cString\u003e newList \u003d new ArrayList\u003cString\u003e();\n\t\tnewList.add(\"test path for checkstyle\");\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, newList);\n\t\tassertNotEquals(list, JavaController.getCheckStyleOutputFiles());\n\t}\n\n\t/**\n\t * Test changing PMD list of output file.\n\t */\n\t@Test\n\tpublic void testChangingPMDOutputFile() {\n\t\tArrayList\u003cString\u003e list \u003d JavaController.getPmdOutputFiles();\n\t\tArrayList\u003cString\u003e newList \u003d new ArrayList\u003cString\u003e();\n\t\tnewList.add(\"test path for pmd\");\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, newList);\n\t\tassertNotEquals(list, JavaController.getPmdOutputFiles());\n\t}\n\n\t/**\n\t * Test changing FindBugs list of output files.\n\t */\n\t@Test\n\tpublic void testChangingFindBugsOutputFile() {\n\t\tArrayList\u003cString\u003e list \u003d JavaController.getFindBugsOutputFiles();\n\t\tArrayList\u003cString\u003e newList \u003d new ArrayList\u003cString\u003e();\n\t\tnewList.add(\"test path for findbugs\");\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, newList);\n\t\tassertNotEquals(list, JavaController.getFindBugsOutputFiles());\n\t}\n\n\t/**\n\t * Test SetASATOutputFiles with a null.\n\t */\n\t@Test\n\tpublic void testSetOutputWithNull() {\n\t\tArrayList\u003cString\u003e fileList \u003d JavaController.getCheckStyleOutputFiles();\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, null);\n\t\tassertEquals(fileList, JavaController.getCheckStyleOutputFiles());\n\t}\n\n\t/**\n\t * Test execute should produce an output file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testExecute() throws IOException {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, new ArrayList\u003cString\u003e());\n\t\tJavaController jc \u003d new JavaController();\n\t\tjc.execute();\n\t\tassertTrue(new File(userDir + \"/visualization/JSON/outputWarningsJSON.js\").exists());\n\t}\n\n\t/**\n\t * Tests if the JSONFormatter generates an empty list of warnings when it\n\t * finds no output files.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testNoOutputFile() throws IOException {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, new ArrayList\u003cString\u003e());\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, new ArrayList\u003cString\u003e());\n\t\tJSONFormatter jsonFormatter \u003d new JSONFormatter();\n\t\tjsonFormatter.format();\n\t\tassertSame(jsonFormatter.getTotalWarnings().size(), 0);\n\t}\n\n\t/**\n\t * Tests if the JSONFormatter generates a list of warnings when the list of\n\t * output files are not empty There is just one output file for each ASAT.\n\t * The output files are modified (smaller output files) for the test.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testListOfOneOutputFile() throws IOException {\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, checkstyleList);\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, pmdList);\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, findBugsList);\n\t\tJSONFormatter jsonFormatter \u003d new JSONFormatter();\n\t\tjsonFormatter.format();\n\t\tassertSame(jsonFormatter.getTotalWarnings().size(), 8);\n\t}\n\t\n\t/**\n\t * Tests if the JSONFormatter generates a list of warnings when the list of\n\t * output files are not empty. There are two output files for each ASAT.\n\t * The output files are modified (smaller output files) for the test.\n\t * \n\t * @throws IOException\n\t *             throws an exception if a problem is encountered while reading\n\t *             the file.\n\t */\n\t@Test\n\tpublic void testListOfTwoOutputFile() throws IOException {\n\t\tcheckstyleList.add(checkStyleOutputFilePath);\n\t\tpmdList.add(pmdOutputFilePath);\n\t\tfindBugsList.add(findBugsOutputFilePath);\n\t\tJavaController.setASATOutputFiles(ASAT.CheckStyle, checkstyleList);\n\t\tJavaController.setASATOutputFiles(ASAT.PMD, pmdList);\n\t\tJavaController.setASATOutputFiles(ASAT.FindBugs, findBugsList);\n\t\tJSONFormatter jsonFormatter \u003d new JSONFormatter();\n\t\tjsonFormatter.format();\n\t\tassertSame(jsonFormatter.getTotalWarnings().size(), 16);\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\warnings\\ChecktStyleWarningTest.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\nimport static org.junit.Assert.assertSame;\n\nimport org.junit.Test;\n\n/**\n * Test for CheckStyleWarning class.\n * \n * @author BlueTurtle.\n *\n */\npublic class ChecktStyleWarningTest {\n\n\tprivate static String filePath \u003d \"\\\\Dummy\\\\Cool.java\";\n\tprivate static String fileName \u003d \"Cool.java\";\n\tprivate static String message \u003d \"Unused @param tag for \u0027filePath\u0027.\";\n\tprivate static String ruleName \u003d \"JavadocMethod\";\n\tprivate static String classification \u003d \" Documentation Conventions\";\n\n\t\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test objects that are equal should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected.hashCode(), actual.hashCode());\n\t}\n\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrueWithSet() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\texpected.setFileName(\"\");\n\t\texpected.setFileName(fileName);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where both objects does represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsFalse() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, \"Hot.java\", 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where they have different file path.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPath() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(\"\\\\Another\\\\Awesome.java\", fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where they have different message.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentMessage() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(\"\\\\Another\\\\Awesome.java\", fileName, 1, message, ruleName, classification);\n\t\texpected.setMessage(\"This is not cool\");\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where they have a different rule name.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRule() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(\"\\\\Another\\\\Awesome.java\", fileName, 1, message, ruleName, classification);\n\t\texpected.setClassification(\"This is not a rule\");\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test equal method where one object has PMDWarning, the other one has\n\t * CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalsePMDandCheckStyle() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, \"\", \"\", \"\", ruleName, \"\", classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, \"lalala\", ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test the change of the message of a CheckStyle warning.\n\t */\n\t@Test\n\tpublic void testChangeOfMessage() {\n\t\tString expected \u003d \"cool\";\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, \"test\", ruleName, classification);\n\t\tString actual \u003d cw.getMessage();\n\t\tcw.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test the change of the line of a CheckStyle warning.\n\t */\n\t@Test\n\tpublic void testChangeOfLine() {\n\t\tint expected \u003d 5;\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tint actual \u003d cw.getLine();\n\t\tcw.setLine(expected);\n\t\tassertNotSame(expected, actual);\n\t}\n\n\t/**\n\t * Test equals between an Integer object and a CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithIntegerObject() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tboolean actual \u003d cw.equals(Integer.valueOf(1));\n\t\tassertSame(false, actual);\n\t}\n\n\t/**\n\t * Test equals between two CheckStyleWarning with different rule and\n\t * message.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRuleAndMessage() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, \"random\", ruleName, classification);\n\t\tCheckStyleWarning diff \u003d new CheckStyleWarning(filePath, fileName, 1, message, \"unknown rule\", classification);\n\t\tassertNotEquals(cw, diff);\n\t}\n\t\n\t/**\n\t * Test equals between two CheckStyleWarning with different rule and\n\t * and line.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRuleAndLine() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning diff \u003d new CheckStyleWarning(filePath, fileName, 5, message, \"test\", classification);\n\t\tassertNotEquals(cw, diff);\n\t}\n\t\n\t/**\n\t * Test equals between two CheckStyleWarning with different rule and\n\t * and line.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentMessageAndRule() {\n\t\tCheckStyleWarning cw \u003d new CheckStyleWarning(filePath, fileName, 1, message, \"rule\", classification);\n\t\tCheckStyleWarning diff \u003d new CheckStyleWarning(filePath, fileName, 1, \"hey\", ruleName, classification);\n\t\tassertNotEquals(cw, diff);\n\t}\n\t\n\t/**\n\t * Test two equal CheckStylWarning should return same string.\n\t */\n\t@Test\n\tpublic void testTwoEqualWarningReturnSameString() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\t\n\t/**\n\t * Test two different CheckStylWarning should return different string.\n\t */\n\t@Test\n\tpublic void testTwoDifferentWarningReturnDifferentString() {\n\t\tCheckStyleWarning expected \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\warnings\\FindBugsWarningTest.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\n\nimport org.junit.Test;\n\n\n/**\n * Test for FindBugsWarning class.\n * @author BlueTurtle.\n *\n */\npublic class FindBugsWarningTest {\n\t\n\tprivate static String filePath \u003d \"\\\\src\\\\test\\\\TestPMD.java\";\n\tprivate static String fileName \u003d \"FindBugs.java\";\n\tprivate static String message \u003d \"BlueTurtle.warnings.PMDWarning defines equals and uses Object.hashCode()\";\n\tprivate static String ruleName \u003d \"HE_EQUALS_USE_HASHCODE\";\n\tprivate static String category \u003d \"BAD_PRACTICE\";\n\tprivate static String priority \u003d \"High\";\n\tprivate static String classification \u003d \"Interface\";\n\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test objects that are equals should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertEquals(expected.hashCode(), actual.hashCode());\n\t}\n\n\t/**\n\t * Test equal method where objects have different file paths.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPath() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setFilePath(\"\\\\src\\\\temp\\\\\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different file names.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentFileName() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setFileName(\"okay.java\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\n\t/**\n\t * Test equal method where objects have different line numbers.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentLines() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 2, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test equal method where objects have different rules.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRules() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setClassification(\"UUF_UNUSED_FIELD\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different categories.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentCategories() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setCategory(\"STYLE\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different priorities.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPriority() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\texpected.setPriority(\"Normal\");\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\t\n\t\n\t/**\n\t * Test equal method where one object has FindBugsWarning, the other one has CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalsePMDandCheckStyle() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, \"lalala\", ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test the change of the line of a FindBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfLine() {\n\t\tint expected \u003d 5;\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tint actual \u003d fb.getLine();\n\t\tfb.setLine(expected);\n\t\tassertNotSame(expected, actual);\n\t}\n\t\n\t/**\n\t * Test the change of the message of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfMessage() {\n\t\tString expected \u003d \"cool\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getMessage();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\n\t/**\n\t * Test the change of the category of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfCategory() {\n\t\tString expected \u003d \"I18N\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getCategory();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the priority of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfPriority() {\n\t\tString expected \u003d \"Low\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getPriority();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the rule name of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfRuleName() {\n\t\tString expected \u003d \"DM_DEFAULT_ENCODING\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getClassification();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\n\t/**\n\t * Test the change of the file name of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfFileName() {\n\t\tString expected \u003d \"this.java\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getFileName();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\n\t/**\n\t * Test the change of the type of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfType() {\n\t\tString expected \u003d \"PMD\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getType();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\n\t/**\n\t * Test the change of the file path of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfFilePath() {\n\t\tString expected \u003d \"\\\\Documents\\\\GitHub\\\\Contextproject-TSE\\\\src\\\\main\\\\java\";\n\t\tFindBugsWarning fb \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tString actual \u003d fb.getFilePath();\n\t\tfb.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test two equal FindBugsWarning return the same string.\n\t */\n\t@Test\n\tpublic void testTwoEqualsWarningReturnSameString() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\t\n\t/**\n\t * Test two different FindBugsWarning return the different strings.\n\t */\n\t@Test\n\tpublic void testDifferentEqualsWarningReturnDifferentString() {\n\t\tFindBugsWarning expected \u003d new FindBugsWarning(filePath, fileName, 6, message, category, priority, ruleName, classification);\n\t\tFindBugsWarning actual \u003d new FindBugsWarning(filePath, fileName, 1, message, category, priority, ruleName, classification);\n\t\tassertNotEquals(expected.toString(), actual.toString());\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\warnings\\PMDWarningTest.java",
    "code": "\"package BlueTurtle.warnings;\n\nimport static org.junit.Assert.assertEquals;\nimport static org.junit.Assert.assertNotEquals;\nimport static org.junit.Assert.assertNotSame;\n\nimport org.junit.Test;\n\n/**\n * Test for PMDWarning class.\n * @author BlueTurtle.\n *\n */\npublic class PMDWarningTest {\n\t\n\tprivate static String filePath \u003d \"\\\\src\\\\test\\\\TestPMD.java\";\n\tprivate static String fileName \u003d \"PMD.java\";\n\tprivate static String packageName \u003d \"test\";\n\tprivate static String ruleName \u003d \"UnnecessaryBooleanAssertion\";\n\tprivate static String ruleSet \u003d \"JUnit\";\n\tprivate static String method \u003d \"equals\";\n\tprivate static String classification \u003d \"Refactorings - Redundancies\";\n\tprivate static String message \u003d \"Ensure you override both equals() and hashCode()\";\n\n\n\t/**\n\t * Test equal method where both objects represent the same warning.\n\t */\n\t@Test\n\tpublic void testEqualsTrue() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test objects that are equal should return same HashCode.\n\t */\n\t@Test\n\tpublic void testSameHashCode() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertEquals(expected.hashCode(), actual.hashCode());\n\t}\n\n\t/**\n\t * Test equal method where objects have different file paths.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPath() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setFilePath(\"\\\\src\\\\temp\\\\\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different file names.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentFileName() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setFileName(\"okay.java\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\n\t/**\n\t * Test equal method where objects have different line numbers.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentLines() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test equal method where objects have different rules.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRules() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setClassification(\"OverrideBothEqualsAndHashcode\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different packages.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentPackages() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setPackageName(\"BlueTurtle.warnings\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where objects have different types.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentTypes() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setType(\"warning1\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tactual.setType(\"warning2\");\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\t\n\t/**\n\t * Test equal method where objects have different ruleSets.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentRuleSets() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setMessage(\"Basic\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\n\t/**\n\t * Test equal method where objects have different methods.\n\t */\n\t@Test\n\tpublic void testEqualsFalseWithDifferentMethods() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 2, packageName, ruleSet, method, ruleName, message, classification);\n\t\texpected.setMethod(\"foo\");\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test equal method where one object has PMDWarning, the other one has CheckStyleWarning.\n\t */\n\t@Test\n\tpublic void testEqualsFalsePMDandCheckStyle() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tCheckStyleWarning actual \u003d new CheckStyleWarning(filePath, fileName, 1, message, ruleName, classification);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the line of a PMD warning.\n\t */\n\t@Test\n\tpublic void testChangeOfLine() {\n\t\tint expected \u003d 5;\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tint actual \u003d pmd.getLine();\n\t\tpmd.setLine(expected);\n\t\tassertNotSame(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test the change of the package name of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfPackageName() {\n\t\tString expected \u003d \"BlueTurtle.parsers\";\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tString actual \u003d pmd.getPackageName();\n\t\tpmd.setPackageName(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\t\n\t\n\t/**\n\t * Test the change of the rule set of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfRuleSet() {\n\t\tString expected \u003d \"Basic1\";\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tString actual \u003d pmd.getMessage();\n\t\tpmd.setMessage(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\n\t\n\t/**\n\t * Test the change of the method of a FingBugs warning.\n\t */\n\t@Test\n\tpublic void testChangeOfMethod() {\n\t\tString expected \u003d \"func\";\n\t\tPMDWarning pmd \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tString actual \u003d pmd.getMethod();\n\t\tpmd.setMethod(expected);\n\t\tassertNotEquals(expected, actual);\n\t}\t\n\t\n\t/**\n\t * Test two equal PMDWarning return the same string.\n\t */\n\t@Test\n\tpublic void testTwoEqualWarningReturnSameString() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertEquals(expected.toString(), actual.toString());\n\t}\n\t\n\t/**\n\t * Test two different PMDWarning return different strings.\n\t */\n\t@Test\n\tpublic void testTwoDifferentWarningReturnDifferentString() {\n\t\tPMDWarning expected \u003d new PMDWarning(filePath, fileName, 1, packageName, ruleSet, method, ruleName, message, classification);\n\t\tPMDWarning actual \u003d new PMDWarning(filePath, fileName, 5, packageName, ruleSet, method, ruleName, message, classification);\n\t\tassertNotEquals(expected.toString(), actual.toString());\n\t}\n\t\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\java\\BlueTurtle\\writers\\JSWriterTest.java",
    "code": "\"package BlueTurtle.writers;\n\nimport static org.junit.Assert.assertSame;\nimport static org.junit.Assert.assertTrue;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.junit.After;\nimport org.junit.Before;\nimport org.junit.Test;\n\nimport BlueTurtle.finders.ProjectInfoFinder;\nimport BlueTurtle.groupers.WarningGrouper;\nimport BlueTurtle.groupers.WarningGrouper.Criteria;\nimport BlueTurtle.gui.GUIController;\nimport BlueTurtle.summarizers.Summarizer;\nimport BlueTurtle.warnings.CheckStyleWarning;\nimport BlueTurtle.warnings.Warning;\n\n/**\n * Tests for the JsonWriter class.\n * \n * @author BlueTurtle.\n *\n */\npublic class JSWriterTest {\n\n\tprivate String outputPath;\n\tprivate List\u003cSummarizer\u003e summarizedWarnings;\n\tprivate JSWriter jsWriter \u003d JSWriter.getInstance();\n\n\t/**\n\t * Intitialize the things that are needed.\n\t * \n\t * @throws IOException\n\t *             throws an exception if problem is encountered while reading\n\t *             the files.\n\t */\n\t@Before\n\tpublic void initialize() throws IOException {\n\t\tProjectInfoFinder pif \u003d new ProjectInfoFinder();\n\t\tpif.findFiles(new File(System.getProperty(\"user.dir\") + \"/src/test/resources\"));\n\t\toutputPath \u003d \"./src/test/resources/testOutput.js\";\n\t\tList\u003cWarning\u003e list \u003d new ArrayList\u003cWarning\u003e();\n\t\tString filePath \u003d ProjectInfoFinder.getClassPaths().stream().filter(path -\u003e path.endsWith(\n\t\t\t\t\"src\" + File.separator + \"test\" + File.separator + \"resources\" + File.separator + \"ExampleClass.java\"))\n\t\t\t\t.findFirst().get();\n\t\tlist.add(new CheckStyleWarning(filePath, \"ExampleClass.java\", 5, \"test\", \"test\", \"Class\"));\n\t\tWarningGrouper wg \u003d new WarningGrouper(list);\n\t\tsummarizedWarnings \u003d wg.groupBy(Criteria.PACKAGES);\n\t\tjsWriter.setSummarizedWarnings(summarizedWarnings);\n\t\tGUIController.setProjectPath(\"test\");\n\n\t\t// make sure that the file does not already exist by coincidence.\n\t\tFile file \u003d new File(outputPath);\n\t\tif (file.exists()) {\n\t\t\tfile.delete();\n\t\t}\n\n\t}\n\n\t/**\n\t * Cleanup the files that were created and also the attributes of\n\t * ProjectInfoFinder.\n\t */\n\t@After\n\tpublic void cleanup() {\n\t\tFile file \u003d new File(outputPath);\n\t\tfile.delete();\n\t\tProjectInfoFinder.getClassLocs().clear();\n\t\tProjectInfoFinder.getClassPaths().clear();\n\t\tProjectInfoFinder.getClassPackage().clear();\n\t\tProjectInfoFinder.getPackages().clear();\n\t\tGUIController.setProjectPath(null);\n\t}\n\n\t/**\n\t * Test writing summarized warnings to a file.\n\t * \n\t * @throws IOException\n\t *             throws an exception if something has happened when writing to\n\t *             a file.\n\t */\n\t@Test\n\tpublic void testWriteToJsonFormat() throws IOException {\n\t\tjsWriter.writeToJSFormat(outputPath);\n\n\t\tFile file \u003d new File(outputPath);\n\t\tboolean fileWritten \u003d file.exists();\n\t\tassertTrue(fileWritten);\n\t}\n\n\t/**\n\t * Test changing the summarizedWarnings.\n\t */\n\t@Test\n\tpublic void testChangingSummarizedWarnings() {\n\t\tjsWriter.setSummarizedWarnings(new ArrayList\u003cSummarizer\u003e());\n\t\tassertSame(0, jsWriter.getSummarizedWarnings().size());\n\t}\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\TestCodeFolder\\AllClosestPoints.java",
    "code": "\"import java.io.BufferedReader;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.InputStream;\nimport java.io.InputStreamReader;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\n\npublic class AllClosestPoints {\n\tpublic static Point[] nearestNeighbours;\n\n\tpublic static void main(String[] args) throws FileNotFoundException {\n\t\tint i \u003d 1;\n\t\twhile(i \u003c\u003d 10000000) {\t\t\n\t\t\tint points \u003d i;\n\t\t\tlong startTime \u003d System.currentTimeMillis();\n\t\t\texecute(points);\n\t\t\tlong stopTime \u003d System.currentTimeMillis();\n\t\t\tlong elapsedTime \u003d stopTime - startTime;\n\t\t\tSystem.out.println(\"Execution for all nearest neighbours with \" + points + \" took \" + elapsedTime + \" ms\\n\");\n\t\t\ti*\u003d10;\n\t\t}\n\t}\n\n\n\tpublic static class PointPair {\n\t\tpublic Point p1;\n\t\tpublic Point p2;\n\n\t\tpublic PointPair(Point p1, Point p2) {\n\t\t\tthis.p1 \u003d p1;\n\t\t\tthis.p2 \u003d p2;\n\t\t}\n\n\t\tpublic double computeDistance() {\n\t\t\treturn Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointPairIntersectionYCoordinateComparator implements Comparator\u003cPointPair\u003e {\n\t\t@Override\n\t\tpublic int compare(PointPair pp1, PointPair pp2) {\n\t\t\treturn Double.compare(pp1.p2.y, pp2.p2.y);\n\t\t}\n\t}\n\n\tpublic static class Circle {\n\t\tpublic double radius;\n\t\tpublic Point center;\n\n\t\tpublic Circle(double radius, Point center) {\n\t\t\tthis.radius \u003d radius;\n\t\t\tthis.center \u003d center;\n\t\t}\n\n\t\tpublic Point computeIntersectionPointMedian(double median) {\n\t\t\tif(median \u003e center.x + radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tif(median \u003c center.x - radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif(median \u003d\u003d center.x + radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\t\t\tif(median \u003d\u003d center.x - radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\n\t\t\tdouble yLength \u003d Math.sqrt(Math.pow(radius, 2) - Math.pow(Math.abs(median - center.x), 2));\n\n\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y + yLength);\n\t\t}\n\t}\n\n\tpublic static class Point {\n\t\tpublic int id;\n\t\tpublic double x;\n\t\tpublic double y;\n\n\t\tpublic Point(int id, double x, double y) {\n\t\t\tthis.id \u003d id;\n\t\t\tthis.x \u003d x;\n\t\t\tthis.y \u003d y;\n\t\t}\n\n\t\tpublic double computeDistanceToXMedian(double xMedian) {\n\t\t\treturn Math.sqrt(Math.pow(xMedian - x, 2));\n\t\t}\n\n\t\tpublic boolean equals(Point other) {\n\t\t\tif(other instanceof Point) {\n\t\t\t\tif(id \u003d\u003d other.id) {\n\t\t\t\t\tif(x \u003d\u003d other.x) {\n\t\t\t\t\t\tif(y \u003d\u003d other.y) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn false;\n\t\t} \n\n\t\tpublic double computeDistanceToOtherPoint(Point other) {\n\t\t\tif(other \u003d\u003d null) {\n\t\t\t\treturn Double.MAX_VALUE;\n\t\t\t}\n\t\t\treturn Math.sqrt(Math.pow(other.x - x, 2) + Math.pow(other.y - y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointXComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.x, p2.x);\n\t\t}\n\t}\n\n\tpublic static class PointYComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.y, p2.y);\n\t\t}\n\t}\n\n\tpublic static void execute(int numPoints) {\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\tdouble x \u003d i;\n\t\t\tdouble y \u003d i;\n\t\t\tpoints.add(new Point(i, x, y));\n\t\t}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\t}\n\n\tpublic static String run(InputStream in){\n\t\tBufferedReader reader \u003d new BufferedReader(new InputStreamReader(in));\n\t\tint numPoints \u003d 0;\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\n\t\ttry{\n\t\t\tnumPoints \u003d Integer.parseInt(reader.readLine());\n\n\t\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\t\tString[] line \u003d reader.readLine().split(\" \");\n\t\t\t\tdouble x \u003d Double.parseDouble(line[0]);\n\t\t\t\tdouble y \u003d Double.parseDouble(line[1]);\n\t\t\t\tpoints.add(new Point(i, x, y));\n\t\t\t}\n\t\t} catch (Exception e){}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\n\t\tStringBuilder stringBuilder \u003d new StringBuilder();\n\t\tfor(int i \u003d 0; i \u003c nearestNeighbours.length; i++) {\n\t\t\tstringBuilder.append(nearestNeighbours[i].id);\n\t\t\tstringBuilder.append(\u0027\\n\u0027);\n\t\t}\n\t\treturn stringBuilder.toString();\n\t}\n\n\tpublic static double computeMedian(ArrayList\u003cPoint\u003e points){\n\t\tint middle \u003d points.size()/2;\n\n\t\tif (points.size() % 2 \u003d\u003d 1) {\n\t\t\treturn points.get(middle).x;\n\t\t} else {\n\t\t\treturn (points.get(middle-1).x + points.get(middle).x) / 2.0;\n\t\t}\n\t}\n\n\tpublic static int findClosestPoint(double y_coordinate, ArrayList\u003cPointPair\u003e pointsAndIntersections) {\n\t\tif(pointsAndIntersections.size() \u003d\u003d 0) {\n\t\t\treturn -1;\n\t\t}\n\t\tint highIndex \u003d pointsAndIntersections.size() -1;\n\t\tint lowIndex \u003d 0;\n\t\tint index \u003d Integer.MAX_VALUE;\t\n\t\twhile(highIndex \u003e lowIndex) {\n\t\t\tindex \u003d (highIndex + lowIndex) / 2;\n\t\t\tPoint intersectionPoint \u003d pointsAndIntersections.get(index).p2;\n\t\t\tif(pointsAndIntersections.get(lowIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn lowIndex;\n\t\t\t} else if(intersectionPoint.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn index;\n\t\t\t} else if(pointsAndIntersections.get(highIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn highIndex;\n\t\t\t} else if(intersectionPoint.y \u003e y_coordinate) {\n\t\t\t\tif (highIndex \u003d\u003d index) {\n\t\t\t\t\treturn highIndex;\n\t\t\t\t}\n\t\t\t\thighIndex \u003d index;\n\t\t\t} else {\n\t\t\t\tif(lowIndex \u003d\u003d index) {\n\t\t\t\t\treturn lowIndex;\n\t\t\t\t}\n\t\t\t\tlowIndex \u003d index;\n\t\t\t}\n\t\t}\n\t\treturn highIndex;\n\t}\n\n\tpublic static void allClosestPairs(ArrayList\u003cPoint\u003e points) {\n\t\tif(points.size() \u003c 2) {\n\t\t\treturn;\n\t\t}\n\t\tif(points.size()\u003d\u003d2) {\n\t\t\tnearestNeighbours[points.get(0).id] \u003d points.get(1);\n\t\t\tnearestNeighbours[points.get(1).id] \u003d points.get(0);\n\t\t\treturn;\n\t\t}\n\n\t\tif(points.size()\u003d\u003d3) {\n\t\t\tfor(Point currPoint : points) {\n\t\t\t\tfor(Point comparePoint : points) {\n\t\t\t\t\tif(!currPoint.equals(comparePoint)) {\n\t\t\t\t\t\tdouble distance \u003d currPoint.computeDistanceToOtherPoint(comparePoint);\n\t\t\t\t\t\tdouble storedDistance \u003d currPoint.computeDistanceToOtherPoint(nearestNeighbours[currPoint.id]);\n\t\t\t\t\t\tif(distance \u003c storedDistance) {\n\t\t\t\t\t\t\tnearestNeighbours[currPoint.id] \u003d comparePoint;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\n\t\tCollections.sort(points, new PointXComparator());\n\t\tdouble median \u003d computeMedian(points);\n\n\t\tArrayList\u003cPoint\u003e leftHalf \u003d new ArrayList\u003cPoint\u003e();\n\t\tArrayList\u003cPoint\u003e rightHalf \u003d new ArrayList\u003cPoint\u003e();\n\n\t\tfor(Point currPoint : points) {\n\t\t\tif(currPoint.x \u003c\u003d median) {\n\t\t\t\tleftHalf.add(currPoint);\n\t\t\t} else {\n\t\t\t\trightHalf.add(currPoint);\n\t\t\t}\n\t\t}\n\n\t\tallClosestPairs(leftHalf);\n\t\tallClosestPairs(rightHalf);\n\n\t\tArrayList\u003cPointPair\u003e leftPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\t\tArrayList\u003cPointPair\u003e rightPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\tleftPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\trightPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tCollections.sort(leftPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\t\tCollections.sort(rightPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, rightPointsAndIntersections);\n\n\t\t\tif(rightPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index - 4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c rightPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, leftPointsAndIntersections);\n\t\t\tif(leftPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index -4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c leftPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\classes\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\classes\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\classes\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\target\\test-classes\\TestCodeFolder\\AllClosestPoints.java",
    "code": "\"import java.io.BufferedReader;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.InputStream;\nimport java.io.InputStreamReader;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\n\npublic class AllClosestPoints {\n\tpublic static Point[] nearestNeighbours;\n\n\tpublic static void main(String[] args) throws FileNotFoundException {\n\t\tint i \u003d 1;\n\t\twhile(i \u003c\u003d 10000000) {\t\t\n\t\t\tint points \u003d i;\n\t\t\tlong startTime \u003d System.currentTimeMillis();\n\t\t\texecute(points);\n\t\t\tlong stopTime \u003d System.currentTimeMillis();\n\t\t\tlong elapsedTime \u003d stopTime - startTime;\n\t\t\tSystem.out.println(\"Execution for all nearest neighbours with \" + points + \" took \" + elapsedTime + \" ms\\n\");\n\t\t\ti*\u003d10;\n\t\t}\n\t}\n\n\n\tpublic static class PointPair {\n\t\tpublic Point p1;\n\t\tpublic Point p2;\n\n\t\tpublic PointPair(Point p1, Point p2) {\n\t\t\tthis.p1 \u003d p1;\n\t\t\tthis.p2 \u003d p2;\n\t\t}\n\n\t\tpublic double computeDistance() {\n\t\t\treturn Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointPairIntersectionYCoordinateComparator implements Comparator\u003cPointPair\u003e {\n\t\t@Override\n\t\tpublic int compare(PointPair pp1, PointPair pp2) {\n\t\t\treturn Double.compare(pp1.p2.y, pp2.p2.y);\n\t\t}\n\t}\n\n\tpublic static class Circle {\n\t\tpublic double radius;\n\t\tpublic Point center;\n\n\t\tpublic Circle(double radius, Point center) {\n\t\t\tthis.radius \u003d radius;\n\t\t\tthis.center \u003d center;\n\t\t}\n\n\t\tpublic Point computeIntersectionPointMedian(double median) {\n\t\t\tif(median \u003e center.x + radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tif(median \u003c center.x - radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif(median \u003d\u003d center.x + radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\t\t\tif(median \u003d\u003d center.x - radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\n\t\t\tdouble yLength \u003d Math.sqrt(Math.pow(radius, 2) - Math.pow(Math.abs(median - center.x), 2));\n\n\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y + yLength);\n\t\t}\n\t}\n\n\tpublic static class Point {\n\t\tpublic int id;\n\t\tpublic double x;\n\t\tpublic double y;\n\n\t\tpublic Point(int id, double x, double y) {\n\t\t\tthis.id \u003d id;\n\t\t\tthis.x \u003d x;\n\t\t\tthis.y \u003d y;\n\t\t}\n\n\t\tpublic double computeDistanceToXMedian(double xMedian) {\n\t\t\treturn Math.sqrt(Math.pow(xMedian - x, 2));\n\t\t}\n\n\t\tpublic boolean equals(Point other) {\n\t\t\tif(other instanceof Point) {\n\t\t\t\tif(id \u003d\u003d other.id) {\n\t\t\t\t\tif(x \u003d\u003d other.x) {\n\t\t\t\t\t\tif(y \u003d\u003d other.y) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn false;\n\t\t} \n\n\t\tpublic double computeDistanceToOtherPoint(Point other) {\n\t\t\tif(other \u003d\u003d null) {\n\t\t\t\treturn Double.MAX_VALUE;\n\t\t\t}\n\t\t\treturn Math.sqrt(Math.pow(other.x - x, 2) + Math.pow(other.y - y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointXComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.x, p2.x);\n\t\t}\n\t}\n\n\tpublic static class PointYComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.y, p2.y);\n\t\t}\n\t}\n\n\tpublic static void execute(int numPoints) {\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\tdouble x \u003d i;\n\t\t\tdouble y \u003d i;\n\t\t\tpoints.add(new Point(i, x, y));\n\t\t}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\t}\n\n\tpublic static String run(InputStream in){\n\t\tBufferedReader reader \u003d new BufferedReader(new InputStreamReader(in));\n\t\tint numPoints \u003d 0;\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\n\t\ttry{\n\t\t\tnumPoints \u003d Integer.parseInt(reader.readLine());\n\n\t\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\t\tString[] line \u003d reader.readLine().split(\" \");\n\t\t\t\tdouble x \u003d Double.parseDouble(line[0]);\n\t\t\t\tdouble y \u003d Double.parseDouble(line[1]);\n\t\t\t\tpoints.add(new Point(i, x, y));\n\t\t\t}\n\t\t} catch (Exception e){}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\n\t\tStringBuilder stringBuilder \u003d new StringBuilder();\n\t\tfor(int i \u003d 0; i \u003c nearestNeighbours.length; i++) {\n\t\t\tstringBuilder.append(nearestNeighbours[i].id);\n\t\t\tstringBuilder.append(\u0027\\n\u0027);\n\t\t}\n\t\treturn stringBuilder.toString();\n\t}\n\n\tpublic static double computeMedian(ArrayList\u003cPoint\u003e points){\n\t\tint middle \u003d points.size()/2;\n\n\t\tif (points.size() % 2 \u003d\u003d 1) {\n\t\t\treturn points.get(middle).x;\n\t\t} else {\n\t\t\treturn (points.get(middle-1).x + points.get(middle).x) / 2.0;\n\t\t}\n\t}\n\n\tpublic static int findClosestPoint(double y_coordinate, ArrayList\u003cPointPair\u003e pointsAndIntersections) {\n\t\tif(pointsAndIntersections.size() \u003d\u003d 0) {\n\t\t\treturn -1;\n\t\t}\n\t\tint highIndex \u003d pointsAndIntersections.size() -1;\n\t\tint lowIndex \u003d 0;\n\t\tint index \u003d Integer.MAX_VALUE;\t\n\t\twhile(highIndex \u003e lowIndex) {\n\t\t\tindex \u003d (highIndex + lowIndex) / 2;\n\t\t\tPoint intersectionPoint \u003d pointsAndIntersections.get(index).p2;\n\t\t\tif(pointsAndIntersections.get(lowIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn lowIndex;\n\t\t\t} else if(intersectionPoint.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn index;\n\t\t\t} else if(pointsAndIntersections.get(highIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn highIndex;\n\t\t\t} else if(intersectionPoint.y \u003e y_coordinate) {\n\t\t\t\tif (highIndex \u003d\u003d index) {\n\t\t\t\t\treturn highIndex;\n\t\t\t\t}\n\t\t\t\thighIndex \u003d index;\n\t\t\t} else {\n\t\t\t\tif(lowIndex \u003d\u003d index) {\n\t\t\t\t\treturn lowIndex;\n\t\t\t\t}\n\t\t\t\tlowIndex \u003d index;\n\t\t\t}\n\t\t}\n\t\treturn highIndex;\n\t}\n\n\tpublic static void allClosestPairs(ArrayList\u003cPoint\u003e points) {\n\t\tif(points.size() \u003c 2) {\n\t\t\treturn;\n\t\t}\n\t\tif(points.size()\u003d\u003d2) {\n\t\t\tnearestNeighbours[points.get(0).id] \u003d points.get(1);\n\t\t\tnearestNeighbours[points.get(1).id] \u003d points.get(0);\n\t\t\treturn;\n\t\t}\n\n\t\tif(points.size()\u003d\u003d3) {\n\t\t\tfor(Point currPoint : points) {\n\t\t\t\tfor(Point comparePoint : points) {\n\t\t\t\t\tif(!currPoint.equals(comparePoint)) {\n\t\t\t\t\t\tdouble distance \u003d currPoint.computeDistanceToOtherPoint(comparePoint);\n\t\t\t\t\t\tdouble storedDistance \u003d currPoint.computeDistanceToOtherPoint(nearestNeighbours[currPoint.id]);\n\t\t\t\t\t\tif(distance \u003c storedDistance) {\n\t\t\t\t\t\t\tnearestNeighbours[currPoint.id] \u003d comparePoint;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\n\t\tCollections.sort(points, new PointXComparator());\n\t\tdouble median \u003d computeMedian(points);\n\n\t\tArrayList\u003cPoint\u003e leftHalf \u003d new ArrayList\u003cPoint\u003e();\n\t\tArrayList\u003cPoint\u003e rightHalf \u003d new ArrayList\u003cPoint\u003e();\n\n\t\tfor(Point currPoint : points) {\n\t\t\tif(currPoint.x \u003c\u003d median) {\n\t\t\t\tleftHalf.add(currPoint);\n\t\t\t} else {\n\t\t\t\trightHalf.add(currPoint);\n\t\t\t}\n\t\t}\n\n\t\tallClosestPairs(leftHalf);\n\t\tallClosestPairs(rightHalf);\n\n\t\tArrayList\u003cPointPair\u003e leftPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\t\tArrayList\u003cPointPair\u003e rightPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\tleftPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\trightPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tCollections.sort(leftPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\t\tCollections.sort(rightPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, rightPointsAndIntersections);\n\n\t\t\tif(rightPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index - 4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c rightPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, leftPointsAndIntersections);\n\t\t\tif(leftPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index -4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c leftPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\""
  }
];