var inputData = 
[
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\DefaultClass.java",
    "code": "\"\npublic class DefaultClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\ExampleClass.java",
    "code": "\"package SomePackage.subpackage;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\ExampleTestClass.java",
    "code": "\"package SomePackage.different;\n\npublic class exampleClass {\n\n  public static void main(String[] args) {\n    System.out.println(\"Hello, this is an example class for testing\");\n  }\n\n}\n\""
  },
  {
    "path": "C:\\Users\\michiel\\workspace\\Contextproject-TSE\\src\\test\\resources\\TestCodeFolder\\AllClosestPoints.java",
    "code": "\"import java.io.BufferedReader;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.InputStream;\nimport java.io.InputStreamReader;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\n\npublic class AllClosestPoints {\n\tpublic static Point[] nearestNeighbours;\n\n\tpublic static void main(String[] args) throws FileNotFoundException {\n\t\tint i \u003d 1;\n\t\twhile(i \u003c\u003d 10000000) {\t\t\n\t\t\tint points \u003d i;\n\t\t\tlong startTime \u003d System.currentTimeMillis();\n\t\t\texecute(points);\n\t\t\tlong stopTime \u003d System.currentTimeMillis();\n\t\t\tlong elapsedTime \u003d stopTime - startTime;\n\t\t\tSystem.out.println(\"Execution for all nearest neighbours with \" + points + \" took \" + elapsedTime + \" ms\\n\");\n\t\t\ti*\u003d10;\n\t\t}\n\t}\n\n\n\tpublic static class PointPair {\n\t\tpublic Point p1;\n\t\tpublic Point p2;\n\n\t\tpublic PointPair(Point p1, Point p2) {\n\t\t\tthis.p1 \u003d p1;\n\t\t\tthis.p2 \u003d p2;\n\t\t}\n\n\t\tpublic double computeDistance() {\n\t\t\treturn Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointPairIntersectionYCoordinateComparator implements Comparator\u003cPointPair\u003e {\n\t\t@Override\n\t\tpublic int compare(PointPair pp1, PointPair pp2) {\n\t\t\treturn Double.compare(pp1.p2.y, pp2.p2.y);\n\t\t}\n\t}\n\n\tpublic static class Circle {\n\t\tpublic double radius;\n\t\tpublic Point center;\n\n\t\tpublic Circle(double radius, Point center) {\n\t\t\tthis.radius \u003d radius;\n\t\t\tthis.center \u003d center;\n\t\t}\n\n\t\tpublic Point computeIntersectionPointMedian(double median) {\n\t\t\tif(median \u003e center.x + radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tif(median \u003c center.x - radius) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif(median \u003d\u003d center.x + radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\t\t\tif(median \u003d\u003d center.x - radius) {\n\t\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y);\n\t\t\t}\n\n\t\t\tdouble yLength \u003d Math.sqrt(Math.pow(radius, 2) - Math.pow(Math.abs(median - center.x), 2));\n\n\t\t\treturn new Point(Integer.MIN_VALUE, median, center.y + yLength);\n\t\t}\n\t}\n\n\tpublic static class Point {\n\t\tpublic int id;\n\t\tpublic double x;\n\t\tpublic double y;\n\n\t\tpublic Point(int id, double x, double y) {\n\t\t\tthis.id \u003d id;\n\t\t\tthis.x \u003d x;\n\t\t\tthis.y \u003d y;\n\t\t}\n\n\t\tpublic double computeDistanceToXMedian(double xMedian) {\n\t\t\treturn Math.sqrt(Math.pow(xMedian - x, 2));\n\t\t}\n\n\t\tpublic boolean equals(Point other) {\n\t\t\tif(other instanceof Point) {\n\t\t\t\tif(id \u003d\u003d other.id) {\n\t\t\t\t\tif(x \u003d\u003d other.x) {\n\t\t\t\t\t\tif(y \u003d\u003d other.y) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn false;\n\t\t} \n\n\t\tpublic double computeDistanceToOtherPoint(Point other) {\n\t\t\tif(other \u003d\u003d null) {\n\t\t\t\treturn Double.MAX_VALUE;\n\t\t\t}\n\t\t\treturn Math.sqrt(Math.pow(other.x - x, 2) + Math.pow(other.y - y, 2));\n\t\t}\n\t}\n\n\tpublic static class PointXComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.x, p2.x);\n\t\t}\n\t}\n\n\tpublic static class PointYComparator implements Comparator\u003cPoint\u003e {\n\t\t@Override\n\t\tpublic int compare(Point p1, Point p2) {\n\t\t\treturn Double.compare(p1.y, p2.y);\n\t\t}\n\t}\n\n\tpublic static void execute(int numPoints) {\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\tdouble x \u003d i;\n\t\t\tdouble y \u003d i;\n\t\t\tpoints.add(new Point(i, x, y));\n\t\t}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\t}\n\n\tpublic static String run(InputStream in){\n\t\tBufferedReader reader \u003d new BufferedReader(new InputStreamReader(in));\n\t\tint numPoints \u003d 0;\n\t\tArrayList\u003cPoint\u003e points \u003d new ArrayList\u003cPoint\u003e();\n\n\t\ttry{\n\t\t\tnumPoints \u003d Integer.parseInt(reader.readLine());\n\n\t\t\tfor(int i \u003d 0; i \u003c numPoints; i++) {\n\t\t\t\tString[] line \u003d reader.readLine().split(\" \");\n\t\t\t\tdouble x \u003d Double.parseDouble(line[0]);\n\t\t\t\tdouble y \u003d Double.parseDouble(line[1]);\n\t\t\t\tpoints.add(new Point(i, x, y));\n\t\t\t}\n\t\t} catch (Exception e){}\n\t\tnearestNeighbours \u003d new Point[numPoints];\n\t\tallClosestPairs(points);\n\n\t\tStringBuilder stringBuilder \u003d new StringBuilder();\n\t\tfor(int i \u003d 0; i \u003c nearestNeighbours.length; i++) {\n\t\t\tstringBuilder.append(nearestNeighbours[i].id);\n\t\t\tstringBuilder.append(\u0027\\n\u0027);\n\t\t}\n\t\treturn stringBuilder.toString();\n\t}\n\n\tpublic static double computeMedian(ArrayList\u003cPoint\u003e points){\n\t\tint middle \u003d points.size()/2;\n\n\t\tif (points.size() % 2 \u003d\u003d 1) {\n\t\t\treturn points.get(middle).x;\n\t\t} else {\n\t\t\treturn (points.get(middle-1).x + points.get(middle).x) / 2.0;\n\t\t}\n\t}\n\n\tpublic static int findClosestPoint(double y_coordinate, ArrayList\u003cPointPair\u003e pointsAndIntersections) {\n\t\tif(pointsAndIntersections.size() \u003d\u003d 0) {\n\t\t\treturn -1;\n\t\t}\n\t\tint highIndex \u003d pointsAndIntersections.size() -1;\n\t\tint lowIndex \u003d 0;\n\t\tint index \u003d Integer.MAX_VALUE;\t\n\t\twhile(highIndex \u003e lowIndex) {\n\t\t\tindex \u003d (highIndex + lowIndex) / 2;\n\t\t\tPoint intersectionPoint \u003d pointsAndIntersections.get(index).p2;\n\t\t\tif(pointsAndIntersections.get(lowIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn lowIndex;\n\t\t\t} else if(intersectionPoint.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn index;\n\t\t\t} else if(pointsAndIntersections.get(highIndex).p2.y \u003d\u003d y_coordinate) {\n\t\t\t\treturn highIndex;\n\t\t\t} else if(intersectionPoint.y \u003e y_coordinate) {\n\t\t\t\tif (highIndex \u003d\u003d index) {\n\t\t\t\t\treturn highIndex;\n\t\t\t\t}\n\t\t\t\thighIndex \u003d index;\n\t\t\t} else {\n\t\t\t\tif(lowIndex \u003d\u003d index) {\n\t\t\t\t\treturn lowIndex;\n\t\t\t\t}\n\t\t\t\tlowIndex \u003d index;\n\t\t\t}\n\t\t}\n\t\treturn highIndex;\n\t}\n\n\tpublic static void allClosestPairs(ArrayList\u003cPoint\u003e points) {\n\t\tif(points.size() \u003c 2) {\n\t\t\treturn;\n\t\t}\n\t\tif(points.size()\u003d\u003d2) {\n\t\t\tnearestNeighbours[points.get(0).id] \u003d points.get(1);\n\t\t\tnearestNeighbours[points.get(1).id] \u003d points.get(0);\n\t\t\treturn;\n\t\t}\n\n\t\tif(points.size()\u003d\u003d3) {\n\t\t\tfor(Point currPoint : points) {\n\t\t\t\tfor(Point comparePoint : points) {\n\t\t\t\t\tif(!currPoint.equals(comparePoint)) {\n\t\t\t\t\t\tdouble distance \u003d currPoint.computeDistanceToOtherPoint(comparePoint);\n\t\t\t\t\t\tdouble storedDistance \u003d currPoint.computeDistanceToOtherPoint(nearestNeighbours[currPoint.id]);\n\t\t\t\t\t\tif(distance \u003c storedDistance) {\n\t\t\t\t\t\t\tnearestNeighbours[currPoint.id] \u003d comparePoint;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\n\t\tCollections.sort(points, new PointXComparator());\n\t\tdouble median \u003d computeMedian(points);\n\n\t\tArrayList\u003cPoint\u003e leftHalf \u003d new ArrayList\u003cPoint\u003e();\n\t\tArrayList\u003cPoint\u003e rightHalf \u003d new ArrayList\u003cPoint\u003e();\n\n\t\tfor(Point currPoint : points) {\n\t\t\tif(currPoint.x \u003c\u003d median) {\n\t\t\t\tleftHalf.add(currPoint);\n\t\t\t} else {\n\t\t\t\trightHalf.add(currPoint);\n\t\t\t}\n\t\t}\n\n\t\tallClosestPairs(leftHalf);\n\t\tallClosestPairs(rightHalf);\n\n\t\tArrayList\u003cPointPair\u003e leftPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\t\tArrayList\u003cPointPair\u003e rightPointsAndIntersections \u003d new ArrayList\u003cPointPair\u003e();\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\tleftPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tPoint NN \u003d nearestNeighbours[currPoint.id];\n\t\t\tCircle NNBall \u003d new Circle(currPoint.computeDistanceToOtherPoint(NN), currPoint);\n\n\t\t\tPoint intersectionWithMedian \u003d NNBall.computeIntersectionPointMedian(median);\n\n\t\t\tPointPair pointAndIntersection \u003d new PointPair(currPoint, intersectionWithMedian);\n\n\t\t\tif(pointAndIntersection.p2 !\u003d null) {\n\t\t\t\trightPointsAndIntersections.add(pointAndIntersection);\n\t\t\t}\n\t\t}\n\n\t\tCollections.sort(leftPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\t\tCollections.sort(rightPointsAndIntersections, new PointPairIntersectionYCoordinateComparator());\n\n\t\tfor(Point currPoint : leftHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, rightPointsAndIntersections);\n\n\t\t\tif(rightPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index - 4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c rightPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d rightPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfor(Point currPoint : rightHalf) {\n\t\t\tdouble y_coordinate \u003d currPoint.y;\n\n\t\t\tint index \u003d findClosestPoint(y_coordinate, leftPointsAndIntersections);\n\t\t\tif(leftPointsAndIntersections.size() \u003e 0) {\n\t\t\t\tfor(int i \u003d index; i \u003e index -4 \u0026\u0026 i \u003e -1; i--) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor(int i \u003d index; i \u003c index + 4 \u0026\u0026 i \u003c leftPointsAndIntersections.size(); i++) {\n\t\t\t\t\tPoint comparePoint \u003d leftPointsAndIntersections.get(i).p1;\n\t\t\t\t\tdouble newDistance \u003d comparePoint.computeDistanceToOtherPoint(currPoint);\n\t\t\t\t\tdouble storedDistance \u003d comparePoint.computeDistanceToOtherPoint(nearestNeighbours[comparePoint.id]);\n\n\t\t\t\t\tif(newDistance \u003c storedDistance) {\n\t\t\t\t\t\tnearestNeighbours[comparePoint.id] \u003d currPoint;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\""
  }
];