# Unified ASAT Visualizer &nbsp; [![Build Status](https://travis-ci.org/ClintonCao/UnifiedASATVisualizer.svg?branch=master)](https://travis-ci.org/ClintonCao/UnifiedASATVisualizer) [![Coverage Status](https://coveralls.io/repos/github/ClintonCao/UnifiedASATVisualizer/badge.svg?branch=master)](https://coveralls.io/github/ClintonCao/UnifiedASATVisualizer) [![MIT license](http://img.shields.io/badge/license-MIT-blue.svg)](http://opensource.org/licenses/MIT)

## About
This tool is for creating a visualization of the warnings/defects that were generated by the ASATs (Automated Static Analysis Tools). With this visualization you can get information about the following things:
* From which ASAT most of the warnings are from.
* From which packages (and also classes) most of the warnings are from.
* From which of the three categories (_Functional Defects_, _Maintainability Defects_ and _Other_) most of the warnings are from. (Please take a look at this [paper](http://www.st.ewi.tudelft.nl/~zaidman/publications/bellerSANER2016.pdf) for more information on the three categories.)

## Requirements:
* One of the following internet browsers: Google Chrome or Safari.
* Java JDK 1.8 (Update 40 or higher).
* ASATs version:
  * Checkstyle 6.1.1, PMD 5.2.3 and FindBugs 3.0.1. (CheckStyle 6.17 and PMD version 5.3.2 also work).
* Users must have Maven (IDE plugin or standalone app) installed to run `mvn site`.
* The project that is going to be analyzed must be a Maven Project.
* The project that is going to be analyzed must support the execution of ASATs. We support FindBugs, Checkstyle, PMD. 

## Building
* Run `mvn package`.
* If you want to contribute to UAV's development, please install Lombok to auto-generate getters and setters. (Via `java -jar lib/lombok.jar install path/to/your/ide`)

## Running the Program:
Running UAV is simple: After building it, the latest executable Jar has been conviently placed in the project's base folder. All you have to do is:
* Start UAV via `java -jar UnifiedASATVisualizer-1.1.2.jar`
* Follow the instruction on UAV's User Interface.
* Select the top-level project directory (on your computer) that you want to visualize.
* Click the `Visualize` button. Depending on the project's size and number of warnings, this may take some time to generate the HTML visualization.
* If the visualization does not open automatically (known problems with Linux) or the Java application appears to have crashed, manually open ./visualization/main.html in Chrome or Safari.

UAV requires you to run on a Java project with ASAT warnings generated via `maven site`. Many famous projects include this already, but if you want to analyze a project which does not, here is how you do it:

* Add the following snippet to the project's pom.xml file that you want to analyze:

```XML
 <reporting>
    <plugins>
    
      <plugin>
        <groupId>org.apache.maven.plugins</groupId>
        <artifactId>maven-checkstyle-plugin</artifactId>
        <version>2.17</version>
        <reportSets>
          <reportSet>
            <reports>
              <report>checkstyle</report>
            </reports>
          </reportSet>
        </reportSets>
      </plugin>

      <plugin>
        <groupId>org.apache.maven.plugins</groupId>
        <artifactId>maven-pmd-plugin</artifactId>
        <version>3.7</version>
      </plugin>
    
      <plugin>
        <groupId>org.codehaus.mojo</groupId>
        <artifactId>findbugs-maven-plugin</artifactId>
        <version>3.0.4</version>
      </plugin>
    
    </plugins>
 </reporting>
```
Copy the whole snippet **only** if you do not have `<reporting>` in your pom.xml. If you do, then just copy the plugins. For more information on how to exclude certain files or how to use specific rulesets, please check the following links: ([FindBugs](http://gleclaire.github.io/findbugs-maven-plugin/usage.html), [CheckStyle](https://maven.apache.org/plugins/maven-checkstyle-plugin/usage.html), [PMD](https://maven.apache.org/plugins/maven-pmd-plugin/usage.html))

* Run `mvn site` on the project you want to analyze (this generates the ASAT reports which are read-in by UAV).

