package proto

import (
	"testing"
)

func TestTCP(t *testing.T) {
	b := []byte{
		131, 245, 0, 80, 39, 234, 129, 166, 26, 15, 86, 5, 128, 24, 0,
		229, 192, 75, 0, 0, 1, 1, 8, 10, 0, 69, 127, 134, 37, 240, 54,
		6, 72, 69, 65, 68, 32, 47, 32, 72, 84, 84, 80, 47, 49, 46, 49,
		13, 10, 85, 115, 101, 114, 45, 65, 103, 101, 110, 116, 58, 32,
		99, 117, 114, 108, 47, 55, 46, 51, 53, 46, 48, 13, 10, 72, 111,
		115, 116, 58, 32, 109, 105, 115, 102, 114, 97, 46, 109, 101,
		13, 10, 65, 99, 99, 101, 112, 116, 58, 32, 42, 47, 42, 13, 10,
		13, 10,
	}

	tcpPacket, err := DecodeTCP(b)
	if err != nil {
		t.Fatal(err)
	}

	if tcpPacket.DestinationPort != 80 {
		t.Errorf("expected destination port %v, got %v", 80, tcpPacket.DestinationPort)
	}
}

func BenchmarkTCP(b *testing.B) {
	buf := [...]byte{
		131, 245, 0, 80, 39, 234, 129, 166, 26, 15, 86, 5, 128, 24, 0,
		229, 192, 75, 0, 0, 1, 1, 8, 10, 0, 69, 127, 134, 37, 240, 54,
		6, 72, 69, 65, 68, 32, 47, 32, 72, 84, 84, 80, 47, 49, 46, 49,
		13, 10, 85, 115, 101, 114, 45, 65, 103, 101, 110, 116, 58, 32,
		99, 117, 114, 108, 47, 55, 46, 51, 53, 46, 48, 13, 10, 72, 111,
		115, 116, 58, 32, 109, 105, 115, 102, 114, 97, 46, 109, 101,
		13, 10, 65, 99, 99, 101, 112, 116, 58, 32, 42, 47, 42, 13, 10,
		13, 10,
	}

	for i := 0; i < b.N; i++ {
		DecodeTCP(buf[:])
	}
}
