#pragma once

// Dumped with Dumper-7!

#include "pch.h"
#include "../SDK.hpp"

namespace SDK
{
	class UGameEngine* UGameEngine::GetEngine()
	{
		static class UGameEngine* GameEngine = nullptr;

		if (!GameEngine)
		{
			GameEngine = static_cast<class UGameEngine*>(UEngine::GetEngine());

			if (!GameEngine->IsA(UGameEngine::StaticClass()))
				GameEngine = nullptr;
		}

		return GameEngine; 
	}

	class UEngine* UEngine::GetEngine()
	{
		static UEngine* GEngine = nullptr;

		if (!GEngine)
		{
			for (int i = 0; i < UObject::GObjects->Num(); i++)
			{
				UObject* Obj = UObject::GObjects->GetByIndex(i);

				if (!Obj)
					continue;

				if (Obj->IsA(UEngine::StaticClass()) && !Obj->IsDefaultObject())
				{
					GEngine = static_cast<UEngine*>(Obj);
					break;
				}
			}
		}

		return GEngine; 
	}

	class UWorld* UWorld::GetWorld()
	{
		if (UEngine* Engine = UEngine::GetEngine())
		{
			if (!Engine->GameViewport)
				return nullptr;

			return Engine->GameViewport->World;
		}

		return nullptr;
	}

//---------------------------------------------------------------------------------------------------------------------
// FUNCTIONS
//---------------------------------------------------------------------------------------------------------------------


// Class Engine.ActorComponent
// (None)

class UClass* UActorComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("ActorComponent");

	return Clss;
}


// ActorComponent Engine.Default__ActorComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class UActorComponent* UActorComponent::GetDefaultObj()
{
	static class UActorComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<UActorComponent*>(UActorComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.ActorComponent.ToggleActive
// (Native, Public, BlueprintCallable)
// Parameters:

void UActorComponent::ToggleActive()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "ToggleActive");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetTickGroup
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class ETickingGroup           NewTickGroup                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetTickGroup(enum class ETickingGroup NewTickGroup)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetTickGroup");

	Params::UActorComponent_SetTickGroup_Params Parms{};

	Parms.NewTickGroup = NewTickGroup;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetTickableWhenPaused
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bTickableWhenPaused                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetTickableWhenPaused(bool bTickableWhenPaused)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetTickableWhenPaused");

	Params::UActorComponent_SetTickableWhenPaused_Params Parms{};

	Parms.bTickableWhenPaused = bTickableWhenPaused;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetIsReplicated
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               ShouldReplicate                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetIsReplicated(bool ShouldReplicate)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetIsReplicated");

	Params::UActorComponent_SetIsReplicated_Params Parms{};

	Parms.ShouldReplicate = ShouldReplicate;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetComponentTickIntervalAndCooldown
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              TickInterval                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetComponentTickIntervalAndCooldown(float TickInterval)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetComponentTickIntervalAndCooldown");

	Params::UActorComponent_SetComponentTickIntervalAndCooldown_Params Parms{};

	Parms.TickInterval = TickInterval;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetComponentTickInterval
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              TickInterval                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetComponentTickInterval(float TickInterval)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetComponentTickInterval");

	Params::UActorComponent_SetComponentTickInterval_Params Parms{};

	Parms.TickInterval = TickInterval;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetComponentTickEnabled
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bEnabled                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetComponentTickEnabled(bool bEnabled)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetComponentTickEnabled");

	Params::UActorComponent_SetComponentTickEnabled_Params Parms{};

	Parms.bEnabled = bEnabled;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetAutoActivate
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewAutoActivate                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetAutoActivate(bool bNewAutoActivate)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetAutoActivate");

	Params::UActorComponent_SetAutoActivate_Params Parms{};

	Parms.bNewAutoActivate = bNewAutoActivate;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.SetActive
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewActive                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bReset                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::SetActive(bool bNewActive, bool bReset)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "SetActive");

	Params::UActorComponent_SetActive_Params Parms{};

	Parms.bNewActive = bNewActive;
	Parms.bReset = bReset;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.RemoveTickPrerequisiteComponent
// (Native, Public, BlueprintCallable)
// Parameters:
// class UActorComponent*             PrerequisiteComponent                                            (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::RemoveTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "RemoveTickPrerequisiteComponent");

	Params::UActorComponent_RemoveTickPrerequisiteComponent_Params Parms{};

	Parms.PrerequisiteComponent = PrerequisiteComponent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.RemoveTickPrerequisiteActor
// (Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      PrerequisiteActor                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::RemoveTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "RemoveTickPrerequisiteActor");

	Params::UActorComponent_RemoveTickPrerequisiteActor_Params Parms{};

	Parms.PrerequisiteActor = PrerequisiteActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.ReceiveTick
// (Event, Public, BlueprintEvent)
// Parameters:
// float                              DeltaSeconds                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::ReceiveTick(float DeltaSeconds)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "ReceiveTick");

	Params::UActorComponent_ReceiveTick_Params Parms{};

	Parms.DeltaSeconds = DeltaSeconds;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.ActorComponent.ReceiveEndPlay
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class EEndPlayReason          EndPlayReason                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::ReceiveEndPlay(enum class EEndPlayReason EndPlayReason)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "ReceiveEndPlay");

	Params::UActorComponent_ReceiveEndPlay_Params Parms{};

	Parms.EndPlayReason = EndPlayReason;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.ActorComponent.ReceiveBeginPlay
// (Event, Public, BlueprintEvent)
// Parameters:

void UActorComponent::ReceiveBeginPlay()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "ReceiveBeginPlay");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.ActorComponent.ReceiveAsyncPhysicsTick
// (Event, Public, BlueprintEvent)
// Parameters:
// float                              DeltaSeconds                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              SimSeconds                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::ReceiveAsyncPhysicsTick(float DeltaSeconds, float SimSeconds)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "ReceiveAsyncPhysicsTick");

	Params::UActorComponent_ReceiveAsyncPhysicsTick_Params Parms{};

	Parms.DeltaSeconds = DeltaSeconds;
	Parms.SimSeconds = SimSeconds;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.ActorComponent.OnRep_IsActive
// (Native, Public)
// Parameters:

void UActorComponent::OnRep_IsActive()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "OnRep_IsActive");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.K2_DestroyComponent
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UObject*                     Object                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::K2_DestroyComponent(class UObject* Object)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "K2_DestroyComponent");

	Params::UActorComponent_K2_DestroyComponent_Params Parms{};

	Parms.Object = Object;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.IsComponentTickEnabled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UActorComponent::IsComponentTickEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "IsComponentTickEnabled");

	Params::UActorComponent_IsComponentTickEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.ActorComponent.IsBeingDestroyed
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UActorComponent::IsBeingDestroyed()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "IsBeingDestroyed");

	Params::UActorComponent_IsBeingDestroyed_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.ActorComponent.IsActive
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UActorComponent::IsActive()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "IsActive");

	Params::UActorComponent_IsActive_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.ActorComponent.GetOwner
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* UActorComponent::GetOwner()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "GetOwner");

	Params::UActorComponent_GetOwner_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.ActorComponent.GetComponentTickInterval
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UActorComponent::GetComponentTickInterval()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "GetComponentTickInterval");

	Params::UActorComponent_GetComponentTickInterval_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.ActorComponent.Deactivate
// (Native, Public, BlueprintCallable)
// Parameters:

void UActorComponent::Deactivate()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "Deactivate");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.ComponentHasTag
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        Tag                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UActorComponent::ComponentHasTag(class FName Tag)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "ComponentHasTag");

	Params::UActorComponent_ComponentHasTag_Params Parms{};

	Parms.Tag = Tag;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.ActorComponent.AddTickPrerequisiteComponent
// (Native, Public, BlueprintCallable)
// Parameters:
// class UActorComponent*             PrerequisiteComponent                                            (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::AddTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "AddTickPrerequisiteComponent");

	Params::UActorComponent_AddTickPrerequisiteComponent_Params Parms{};

	Parms.PrerequisiteComponent = PrerequisiteComponent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.AddTickPrerequisiteActor
// (Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      PrerequisiteActor                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::AddTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "AddTickPrerequisiteActor");

	Params::UActorComponent_AddTickPrerequisiteActor_Params Parms{};

	Parms.PrerequisiteActor = PrerequisiteActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.ActorComponent.Activate
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bReset                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UActorComponent::Activate(bool bReset)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("ActorComponent", "Activate");

	Params::UActorComponent_Activate_Params Parms{};

	Parms.bReset = bReset;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.Actor
// (Actor)

class UClass* AActor::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Actor");

	return Clss;
}


// Actor Engine.Default__Actor
// (Public, ClassDefaultObject, ArchetypeObject)

class AActor* AActor::GetDefaultObj()
{
	static class AActor* Default = nullptr;

	if (!Default)
		Default = static_cast<AActor*>(AActor::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.Actor.WasRecentlyRendered
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Tolerance                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::WasRecentlyRendered(float Tolerance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "WasRecentlyRendered");

	Params::AActor_WasRecentlyRendered_Params Parms{};

	Parms.Tolerance = Tolerance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.UserConstructionScript
// (Event, Public, BlueprintEvent)
// Parameters:

void AActor::UserConstructionScript()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "UserConstructionScript");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.Actor.TearOff
// (Native, Public, BlueprintCallable)
// Parameters:

void AActor::TearOff()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "TearOff");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetTickGroup
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class ETickingGroup           NewTickGroup                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetTickGroup(enum class ETickingGroup NewTickGroup)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetTickGroup");

	Params::AActor_SetTickGroup_Params Parms{};

	Parms.NewTickGroup = NewTickGroup;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetTickableWhenPaused
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bTickableWhenPaused                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetTickableWhenPaused(bool bTickableWhenPaused)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetTickableWhenPaused");

	Params::AActor_SetTickableWhenPaused_Params Parms{};

	Parms.bTickableWhenPaused = bTickableWhenPaused;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetReplicates
// (Final, BlueprintAuthorityOnly, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInReplicates                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetReplicates(bool bInReplicates)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetReplicates");

	Params::AActor_SetReplicates_Params Parms{};

	Parms.bInReplicates = bInReplicates;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetReplicateMovement
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInReplicateMovement                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetReplicateMovement(bool bInReplicateMovement)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetReplicateMovement");

	Params::AActor_SetReplicateMovement_Params Parms{};

	Parms.bInReplicateMovement = bInReplicateMovement;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetRayTracingGroupId
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              InRaytracingGroupId                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetRayTracingGroupId(int32 InRaytracingGroupId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetRayTracingGroupId");

	Params::AActor_SetRayTracingGroupId_Params Parms{};

	Parms.InRaytracingGroupId = InRaytracingGroupId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetOwner
// (Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      NewOwner                                                         (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetOwner(class AActor* NewOwner)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetOwner");

	Params::AActor_SetOwner_Params Parms{};

	Parms.NewOwner = NewOwner;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetNetDormancy
// (Final, BlueprintAuthorityOnly, Native, Public, BlueprintCallable)
// Parameters:
// enum class ENetDormancy            NewDormancy                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetNetDormancy(enum class ENetDormancy NewDormancy)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetNetDormancy");

	Params::AActor_SetNetDormancy_Params Parms{};

	Parms.NewDormancy = NewDormancy;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetLifeSpan
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              InLifespan                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetLifeSpan(float InLifespan)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetLifeSpan");

	Params::AActor_SetLifeSpan_Params Parms{};

	Parms.InLifespan = InLifespan;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetAutoDestroyWhenFinished
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bVal                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetAutoDestroyWhenFinished(bool bVal)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetAutoDestroyWhenFinished");

	Params::AActor_SetAutoDestroyWhenFinished_Params Parms{};

	Parms.bVal = bVal;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetActorTickInterval
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              TickInterval                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetActorTickInterval(float TickInterval)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetActorTickInterval");

	Params::AActor_SetActorTickInterval_Params Parms{};

	Parms.TickInterval = TickInterval;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetActorTickEnabled
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bEnabled                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetActorTickEnabled(bool bEnabled)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetActorTickEnabled");

	Params::AActor_SetActorTickEnabled_Params Parms{};

	Parms.bEnabled = bEnabled;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetActorScale3D
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewScale3D                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetActorScale3D(const struct FVector& NewScale3D)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetActorScale3D");

	Params::AActor_SetActorScale3D_Params Parms{};

	Parms.NewScale3D = NewScale3D;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetActorRelativeScale3D
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewRelativeScale                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetActorRelativeScale3D(const struct FVector& NewRelativeScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetActorRelativeScale3D");

	Params::AActor_SetActorRelativeScale3D_Params Parms{};

	Parms.NewRelativeScale = NewRelativeScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetActorHiddenInGame
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewHidden                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetActorHiddenInGame(bool bNewHidden)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetActorHiddenInGame");

	Params::AActor_SetActorHiddenInGame_Params Parms{};

	Parms.bNewHidden = bNewHidden;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.SetActorEnableCollision
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewActorEnableCollision                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::SetActorEnableCollision(bool bNewActorEnableCollision)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "SetActorEnableCollision");

	Params::AActor_SetActorEnableCollision_Params Parms{};

	Parms.bNewActorEnableCollision = bNewActorEnableCollision;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.RemoveTickPrerequisiteComponent
// (Native, Public, BlueprintCallable)
// Parameters:
// class UActorComponent*             PrerequisiteComponent                                            (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::RemoveTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "RemoveTickPrerequisiteComponent");

	Params::AActor_RemoveTickPrerequisiteComponent_Params Parms{};

	Parms.PrerequisiteComponent = PrerequisiteComponent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.RemoveTickPrerequisiteActor
// (Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      PrerequisiteActor                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::RemoveTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "RemoveTickPrerequisiteActor");

	Params::AActor_RemoveTickPrerequisiteActor_Params Parms{};

	Parms.PrerequisiteActor = PrerequisiteActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.ReceiveTick
// (Event, Public, BlueprintEvent)
// Parameters:
// float                              DeltaSeconds                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveTick(float DeltaSeconds)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveTick");

	Params::AActor_ReceiveTick_Params Parms{};

	Parms.DeltaSeconds = DeltaSeconds;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveRadialDamage
// (BlueprintAuthorityOnly, Event, Public, HasOutParams, HasDefaults, BlueprintEvent)
// Parameters:
// float                              DamageReceived                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UDamageType*                 DamageType                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Origin                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitInfo                                                          (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// class AController*                 InstigatedBy                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      DamageCauser                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveRadialDamage(float DamageReceived, class UDamageType* DamageType, const struct FVector& Origin, struct FHitResult& HitInfo, class AController* InstigatedBy, class AActor* DamageCauser)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveRadialDamage");

	Params::AActor_ReceiveRadialDamage_Params Parms{};

	Parms.DamageReceived = DamageReceived;
	Parms.DamageType = DamageType;
	Parms.Origin = Origin;
	Parms.HitInfo = HitInfo;
	Parms.InstigatedBy = InstigatedBy;
	Parms.DamageCauser = DamageCauser;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceivePointDamage
// (BlueprintAuthorityOnly, Event, Public, HasOutParams, HasDefaults, BlueprintEvent)
// Parameters:
// float                              Damage                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UDamageType*                 DamageType                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitNormal                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         HitComponent                                                     (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ShotFromDirection                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AController*                 InstigatedBy                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      DamageCauser                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitInfo                                                          (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)

void AActor::ReceivePointDamage(float Damage, class UDamageType* DamageType, const struct FVector& HitLocation, const struct FVector& HitNormal, class UPrimitiveComponent* HitComponent, class FName BoneName, const struct FVector& ShotFromDirection, class AController* InstigatedBy, class AActor* DamageCauser, struct FHitResult& HitInfo)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceivePointDamage");

	Params::AActor_ReceivePointDamage_Params Parms{};

	Parms.Damage = Damage;
	Parms.DamageType = DamageType;
	Parms.HitLocation = HitLocation;
	Parms.HitNormal = HitNormal;
	Parms.HitComponent = HitComponent;
	Parms.BoneName = BoneName;
	Parms.ShotFromDirection = ShotFromDirection;
	Parms.InstigatedBy = InstigatedBy;
	Parms.DamageCauser = DamageCauser;
	Parms.HitInfo = HitInfo;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveHit
// (Event, Public, HasOutParams, HasDefaults, BlueprintEvent)
// Parameters:
// class UPrimitiveComponent*         MyComp                                                           (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      Other                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         OtherComp                                                        (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSelfMoved                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitNormal                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     NormalImpulse                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  Hit                                                              (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)

void AActor::ReceiveHit(class UPrimitiveComponent* MyComp, class AActor* Other, class UPrimitiveComponent* OtherComp, bool bSelfMoved, const struct FVector& HitLocation, const struct FVector& HitNormal, const struct FVector& NormalImpulse, struct FHitResult& Hit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveHit");

	Params::AActor_ReceiveHit_Params Parms{};

	Parms.MyComp = MyComp;
	Parms.Other = Other;
	Parms.OtherComp = OtherComp;
	Parms.bSelfMoved = bSelfMoved;
	Parms.HitLocation = HitLocation;
	Parms.HitNormal = HitNormal;
	Parms.NormalImpulse = NormalImpulse;
	Parms.Hit = Hit;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveEndPlay
// (Event, Protected, BlueprintEvent)
// Parameters:
// enum class EEndPlayReason          EndPlayReason                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveEndPlay(enum class EEndPlayReason EndPlayReason)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveEndPlay");

	Params::AActor_ReceiveEndPlay_Params Parms{};

	Parms.EndPlayReason = EndPlayReason;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveDestroyed
// (Event, Public, BlueprintEvent)
// Parameters:

void AActor::ReceiveDestroyed()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveDestroyed");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.Actor.ReceiveBeginPlay
// (Event, Protected, BlueprintEvent)
// Parameters:

void AActor::ReceiveBeginPlay()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveBeginPlay");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.Actor.ReceiveAsyncPhysicsTick
// (Event, Public, BlueprintEvent)
// Parameters:
// float                              DeltaSeconds                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              SimSeconds                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveAsyncPhysicsTick(float DeltaSeconds, float SimSeconds)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveAsyncPhysicsTick");

	Params::AActor_ReceiveAsyncPhysicsTick_Params Parms{};

	Parms.DeltaSeconds = DeltaSeconds;
	Parms.SimSeconds = SimSeconds;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveAnyDamage
// (BlueprintAuthorityOnly, Event, Public, BlueprintEvent)
// Parameters:
// float                              Damage                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UDamageType*                 DamageType                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AController*                 InstigatedBy                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      DamageCauser                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveAnyDamage(float Damage, class UDamageType* DamageType, class AController* InstigatedBy, class AActor* DamageCauser)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveAnyDamage");

	Params::AActor_ReceiveAnyDamage_Params Parms{};

	Parms.Damage = Damage;
	Parms.DamageType = DamageType;
	Parms.InstigatedBy = InstigatedBy;
	Parms.DamageCauser = DamageCauser;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorOnReleased
// (Event, Public, BlueprintEvent)
// Parameters:
// struct FKey                        ButtonReleased                                                   (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorOnReleased(const struct FKey& ButtonReleased)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorOnReleased");

	Params::AActor_ReceiveActorOnReleased_Params Parms{};

	Parms.ButtonReleased = ButtonReleased;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorOnInputTouchLeave
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorOnInputTouchLeave(enum class ETouchIndex FingerIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorOnInputTouchLeave");

	Params::AActor_ReceiveActorOnInputTouchLeave_Params Parms{};

	Parms.FingerIndex = FingerIndex;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorOnInputTouchEnter
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorOnInputTouchEnter(enum class ETouchIndex FingerIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorOnInputTouchEnter");

	Params::AActor_ReceiveActorOnInputTouchEnter_Params Parms{};

	Parms.FingerIndex = FingerIndex;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorOnInputTouchEnd
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorOnInputTouchEnd(enum class ETouchIndex FingerIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorOnInputTouchEnd");

	Params::AActor_ReceiveActorOnInputTouchEnd_Params Parms{};

	Parms.FingerIndex = FingerIndex;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorOnInputTouchBegin
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorOnInputTouchBegin(enum class ETouchIndex FingerIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorOnInputTouchBegin");

	Params::AActor_ReceiveActorOnInputTouchBegin_Params Parms{};

	Parms.FingerIndex = FingerIndex;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorOnClicked
// (Event, Public, BlueprintEvent)
// Parameters:
// struct FKey                        ButtonPressed                                                    (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorOnClicked(const struct FKey& ButtonPressed)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorOnClicked");

	Params::AActor_ReceiveActorOnClicked_Params Parms{};

	Parms.ButtonPressed = ButtonPressed;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorEndOverlap
// (Event, Public, BlueprintEvent)
// Parameters:
// class AActor*                      OtherActor                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorEndOverlap(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorEndOverlap");

	Params::AActor_ReceiveActorEndOverlap_Params Parms{};

	Parms.OtherActor = OtherActor;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorEndCursorOver
// (Event, Public, BlueprintEvent)
// Parameters:

void AActor::ReceiveActorEndCursorOver()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorEndCursorOver");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.Actor.ReceiveActorBeginOverlap
// (Event, Public, BlueprintEvent)
// Parameters:
// class AActor*                      OtherActor                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::ReceiveActorBeginOverlap(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorBeginOverlap");

	Params::AActor_ReceiveActorBeginOverlap_Params Parms{};

	Parms.OtherActor = OtherActor;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.ReceiveActorBeginCursorOver
// (Event, Public, BlueprintEvent)
// Parameters:

void AActor::ReceiveActorBeginCursorOver()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ReceiveActorBeginCursorOver");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.Actor.PrestreamTextures
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Seconds                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bEnableStreaming                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              CinematicTextureGroups                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::PrestreamTextures(float Seconds, bool bEnableStreaming, int32 CinematicTextureGroups)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "PrestreamTextures");

	Params::AActor_PrestreamTextures_Params Parms{};

	Parms.Seconds = Seconds;
	Parms.bEnableStreaming = bEnableStreaming;
	Parms.CinematicTextureGroups = CinematicTextureGroups;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.OnRep_ReplicateMovement
// (Native, Public)
// Parameters:

void AActor::OnRep_ReplicateMovement()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "OnRep_ReplicateMovement");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.OnRep_ReplicatedMovement
// (Native, Public)
// Parameters:

void AActor::OnRep_ReplicatedMovement()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "OnRep_ReplicatedMovement");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.OnRep_Owner
// (Native, Protected)
// Parameters:

void AActor::OnRep_Owner()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "OnRep_Owner");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.OnRep_Instigator
// (Native, Public)
// Parameters:

void AActor::OnRep_Instigator()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "OnRep_Instigator");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.OnRep_AttachmentReplication
// (Native, Public)
// Parameters:

void AActor::OnRep_AttachmentReplication()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "OnRep_AttachmentReplication");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.MakeNoise
// (Final, BlueprintAuthorityOnly, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// float                              Loudness                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class APawn*                       NoiseInstigator                                                  (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     NoiseLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MaxRange                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        Tag                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::MakeNoise(float Loudness, class APawn* NoiseInstigator, const struct FVector& NoiseLocation, float MaxRange, class FName Tag)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "MakeNoise");

	Params::AActor_MakeNoise_Params Parms{};

	Parms.Loudness = Loudness;
	Parms.NoiseInstigator = NoiseInstigator;
	Parms.NoiseLocation = NoiseLocation;
	Parms.MaxRange = MaxRange;
	Parms.Tag = Tag;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.K2_TeleportTo
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     DestLocation                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    DestRotation                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::K2_TeleportTo(const struct FVector& DestLocation, const struct FRotator& DestRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_TeleportTo");

	Params::AActor_K2_TeleportTo_Params Parms{};

	Parms.DestLocation = DestLocation;
	Parms.DestRotation = DestRotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_SetActorTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  NewTransform                                                     (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::K2_SetActorTransform(struct FTransform& NewTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_SetActorTransform");

	Params::AActor_K2_SetActorTransform_Params Parms{};

	Parms.NewTransform = NewTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_SetActorRotation
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bTeleportPhysics                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::K2_SetActorRotation(const struct FRotator& NewRotation, bool bTeleportPhysics)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_SetActorRotation");

	Params::AActor_K2_SetActorRotation_Params Parms{};

	Parms.NewRotation = NewRotation;
	Parms.bTeleportPhysics = bTeleportPhysics;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_SetActorRelativeTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  NewRelativeTransform                                             (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_SetActorRelativeTransform(struct FTransform& NewRelativeTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_SetActorRelativeTransform");

	Params::AActor_K2_SetActorRelativeTransform_Params Parms{};

	Parms.NewRelativeTransform = NewRelativeTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_SetActorRelativeRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    NewRelativeRotation                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_SetActorRelativeRotation(const struct FRotator& NewRelativeRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_SetActorRelativeRotation");

	Params::AActor_K2_SetActorRelativeRotation_Params Parms{};

	Parms.NewRelativeRotation = NewRelativeRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_SetActorRelativeLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewRelativeLocation                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_SetActorRelativeLocation(const struct FVector& NewRelativeLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_SetActorRelativeLocation");

	Params::AActor_K2_SetActorRelativeLocation_Params Parms{};

	Parms.NewRelativeLocation = NewRelativeLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_SetActorLocationAndRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::K2_SetActorLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_SetActorLocationAndRotation");

	Params::AActor_K2_SetActorLocationAndRotation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.NewRotation = NewRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_SetActorLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::K2_SetActorLocation(const struct FVector& NewLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_SetActorLocation");

	Params::AActor_K2_SetActorLocation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_OnReset
// (Event, Public, BlueprintEvent)
// Parameters:

void AActor::K2_OnReset()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_OnReset");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.Actor.K2_OnEndViewTarget
// (Event, Public, BlueprintEvent)
// Parameters:
// class APlayerController*           PC                                                               (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_OnEndViewTarget(class APlayerController* PC)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_OnEndViewTarget");

	Params::AActor_K2_OnEndViewTarget_Params Parms{};

	Parms.PC = PC;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.K2_OnBecomeViewTarget
// (Event, Public, BlueprintEvent)
// Parameters:
// class APlayerController*           PC                                                               (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_OnBecomeViewTarget(class APlayerController* PC)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_OnBecomeViewTarget");

	Params::AActor_K2_OnBecomeViewTarget_Params Parms{};

	Parms.PC = PC;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Actor.K2_GetRootComponent
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class USceneComponent*             ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USceneComponent* AActor::K2_GetRootComponent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_GetRootComponent");

	Params::AActor_K2_GetRootComponent_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_GetComponentsByClass
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TSubclassOf<class UActorComponent> ComponentClass                                                   (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<class UActorComponent*>     ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, ContainsInstancedReference, NativeAccessSpecifierPublic)

TArray<class UActorComponent*> AActor::K2_GetComponentsByClass(TSubclassOf<class UActorComponent> ComponentClass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_GetComponentsByClass");

	Params::AActor_K2_GetComponentsByClass_Params Parms{};

	Parms.ComponentClass = ComponentClass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_GetActorRotation
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator AActor::K2_GetActorRotation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_GetActorRotation");

	Params::AActor_K2_GetActorRotation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_GetActorLocation
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::K2_GetActorLocation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_GetActorLocation");

	Params::AActor_K2_GetActorLocation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.K2_DetachFromActor
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class EDetachmentRule         LocationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EDetachmentRule         RotationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EDetachmentRule         ScaleRule                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_DetachFromActor(enum class EDetachmentRule LocationRule, enum class EDetachmentRule RotationRule, enum class EDetachmentRule ScaleRule)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_DetachFromActor");

	Params::AActor_K2_DetachFromActor_Params Parms{};

	Parms.LocationRule = LocationRule;
	Parms.RotationRule = RotationRule;
	Parms.ScaleRule = ScaleRule;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.K2_DestroyActor
// (Native, Public, BlueprintCallable)
// Parameters:

void AActor::K2_DestroyActor()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_DestroyActor");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.K2_AttachToComponent
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USceneComponent*             Parent                                                           (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        SocketName                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         LocationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         RotationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         ScaleRule                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bWeldSimulatedBodies                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AttachToComponent(class USceneComponent* Parent, class FName SocketName, enum class EAttachmentRule LocationRule, enum class EAttachmentRule RotationRule, enum class EAttachmentRule ScaleRule, bool bWeldSimulatedBodies)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AttachToComponent");

	Params::AActor_K2_AttachToComponent_Params Parms{};

	Parms.Parent = Parent;
	Parms.SocketName = SocketName;
	Parms.LocationRule = LocationRule;
	Parms.RotationRule = RotationRule;
	Parms.ScaleRule = ScaleRule;
	Parms.bWeldSimulatedBodies = bWeldSimulatedBodies;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.K2_AttachToActor
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      ParentActor                                                      (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        SocketName                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         LocationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         RotationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         ScaleRule                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bWeldSimulatedBodies                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AttachToActor(class AActor* ParentActor, class FName SocketName, enum class EAttachmentRule LocationRule, enum class EAttachmentRule RotationRule, enum class EAttachmentRule ScaleRule, bool bWeldSimulatedBodies)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AttachToActor");

	Params::AActor_K2_AttachToActor_Params Parms{};

	Parms.ParentActor = ParentActor;
	Parms.SocketName = SocketName;
	Parms.LocationRule = LocationRule;
	Parms.RotationRule = RotationRule;
	Parms.ScaleRule = ScaleRule;
	Parms.bWeldSimulatedBodies = bWeldSimulatedBodies;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.K2_AttachRootComponentToActor
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      InParentActor                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachLocation         AttachLocationType                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bWeldSimulatedBodies                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AttachRootComponentToActor(class AActor* InParentActor, class FName InSocketName, enum class EAttachLocation AttachLocationType, bool bWeldSimulatedBodies)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AttachRootComponentToActor");

	Params::AActor_K2_AttachRootComponentToActor_Params Parms{};

	Parms.InParentActor = InParentActor;
	Parms.InSocketName = InSocketName;
	Parms.AttachLocationType = AttachLocationType;
	Parms.bWeldSimulatedBodies = bWeldSimulatedBodies;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.K2_AttachRootComponentTo
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USceneComponent*             InParent                                                         (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachLocation         AttachLocationType                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bWeldSimulatedBodies                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AttachRootComponentTo(class USceneComponent* InParent, class FName InSocketName, enum class EAttachLocation AttachLocationType, bool bWeldSimulatedBodies)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AttachRootComponentTo");

	Params::AActor_K2_AttachRootComponentTo_Params Parms{};

	Parms.InParent = InParent;
	Parms.InSocketName = InSocketName;
	Parms.AttachLocationType = AttachLocationType;
	Parms.bWeldSimulatedBodies = bWeldSimulatedBodies;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.K2_AddActorWorldTransformKeepScale
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  DeltaTransform                                                   (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AddActorWorldTransformKeepScale(struct FTransform& DeltaTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AddActorWorldTransformKeepScale");

	Params::AActor_K2_AddActorWorldTransformKeepScale_Params Parms{};

	Parms.DeltaTransform = DeltaTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_AddActorWorldTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  DeltaTransform                                                   (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AddActorWorldTransform(struct FTransform& DeltaTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AddActorWorldTransform");

	Params::AActor_K2_AddActorWorldTransform_Params Parms{};

	Parms.DeltaTransform = DeltaTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_AddActorWorldRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    DeltaRotation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AddActorWorldRotation(const struct FRotator& DeltaRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AddActorWorldRotation");

	Params::AActor_K2_AddActorWorldRotation_Params Parms{};

	Parms.DeltaRotation = DeltaRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_AddActorWorldOffset
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     DeltaLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AddActorWorldOffset(const struct FVector& DeltaLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AddActorWorldOffset");

	Params::AActor_K2_AddActorWorldOffset_Params Parms{};

	Parms.DeltaLocation = DeltaLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_AddActorLocalTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  NewTransform                                                     (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AddActorLocalTransform(struct FTransform& NewTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AddActorLocalTransform");

	Params::AActor_K2_AddActorLocalTransform_Params Parms{};

	Parms.NewTransform = NewTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_AddActorLocalRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    DeltaRotation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AddActorLocalRotation(const struct FRotator& DeltaRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AddActorLocalRotation");

	Params::AActor_K2_AddActorLocalRotation_Params Parms{};

	Parms.DeltaRotation = DeltaRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.K2_AddActorLocalOffset
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     DeltaLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::K2_AddActorLocalOffset(const struct FVector& DeltaLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "K2_AddActorLocalOffset");

	Params::AActor_K2_AddActorLocalOffset_Params Parms{};

	Parms.DeltaLocation = DeltaLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.Actor.IsOverlappingActor
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      Other                                                            (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::IsOverlappingActor(class AActor* Other)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "IsOverlappingActor");

	Params::AActor_IsOverlappingActor_Params Parms{};

	Parms.Other = Other;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.IsChildActor
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::IsChildActor()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "IsChildActor");

	Params::AActor_IsChildActor_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.IsActorTickEnabled
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::IsActorTickEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "IsActorTickEnabled");

	Params::AActor_IsActorTickEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.IsActorBeingDestroyed
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::IsActorBeingDestroyed()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "IsActorBeingDestroyed");

	Params::AActor_IsActorBeingDestroyed_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.HasAuthority
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::HasAuthority()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "HasAuthority");

	Params::AActor_HasAuthority_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetVerticalDistanceTo
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      OtherActor                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetVerticalDistanceTo(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetVerticalDistanceTo");

	Params::AActor_GetVerticalDistanceTo_Params Parms{};

	Parms.OtherActor = OtherActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetVelocity
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::GetVelocity()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetVelocity");

	Params::AActor_GetVelocity_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetTransform
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FTransform                  ReturnValue                                                      (ConstParm, Parm, OutParm, ReturnParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform AActor::GetTransform()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetTransform");

	Params::AActor_GetTransform_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetTickableWhenPaused
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::GetTickableWhenPaused()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetTickableWhenPaused");

	Params::AActor_GetTickableWhenPaused_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetSquaredHorizontalDistanceTo
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      OtherActor                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetSquaredHorizontalDistanceTo(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetSquaredHorizontalDistanceTo");

	Params::AActor_GetSquaredHorizontalDistanceTo_Params Parms{};

	Parms.OtherActor = OtherActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetSquaredDistanceTo
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      OtherActor                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetSquaredDistanceTo(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetSquaredDistanceTo");

	Params::AActor_GetSquaredDistanceTo_Params Parms{};

	Parms.OtherActor = OtherActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetRemoteRole
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ENetRole                ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class ENetRole AActor::GetRemoteRole()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetRemoteRole");

	Params::AActor_GetRemoteRole_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetRayTracingGroupId
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 AActor::GetRayTracingGroupId()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetRayTracingGroupId");

	Params::AActor_GetRayTracingGroupId_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetParentComponent
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UChildActorComponent*        ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UChildActorComponent* AActor::GetParentComponent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetParentComponent");

	Params::AActor_GetParentComponent_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetParentActor
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* AActor::GetParentActor()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetParentActor");

	Params::AActor_GetParentActor_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetOwner
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* AActor::GetOwner()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetOwner");

	Params::AActor_GetOwner_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetOverlappingComponents
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class UPrimitiveComponent*> OverlappingComponents                                            (Parm, OutParm, ZeroConstructor, ContainsInstancedReference, NativeAccessSpecifierPublic)

void AActor::GetOverlappingComponents(TArray<class UPrimitiveComponent*>* OverlappingComponents)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetOverlappingComponents");

	Params::AActor_GetOverlappingComponents_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OverlappingComponents != nullptr)
		*OverlappingComponents = std::move(Parms.OverlappingComponents);

}


// Function Engine.Actor.GetOverlappingActors
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class AActor*>              OverlappingActors                                                (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// TSubclassOf<class AActor>          ClassFilter                                                      (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::GetOverlappingActors(TArray<class AActor*>* OverlappingActors, TSubclassOf<class AActor> ClassFilter)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetOverlappingActors");

	Params::AActor_GetOverlappingActors_Params Parms{};

	Parms.ClassFilter = ClassFilter;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OverlappingActors != nullptr)
		*OverlappingActors = std::move(Parms.OverlappingActors);

}


// Function Engine.Actor.GetLocalRole
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ENetRole                ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class ENetRole AActor::GetLocalRole()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetLocalRole");

	Params::AActor_GetLocalRole_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetLifeSpan
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetLifeSpan()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetLifeSpan");

	Params::AActor_GetLifeSpan_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetLevelTransform
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform AActor::GetLevelTransform()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetLevelTransform");

	Params::AActor_GetLevelTransform_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetLevel
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class ULevel*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class ULevel* AActor::GetLevel()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetLevel");

	Params::AActor_GetLevel_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetInstigatorController
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AController*                 ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AController* AActor::GetInstigatorController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetInstigatorController");

	Params::AActor_GetInstigatorController_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetInstigator
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class APawn*                       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APawn* AActor::GetInstigator()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetInstigator");

	Params::AActor_GetInstigator_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetInputVectorAxisValue
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        InputAxisKey                                                     (ConstParm, Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::GetInputVectorAxisValue(const struct FKey& InputAxisKey)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetInputVectorAxisValue");

	Params::AActor_GetInputVectorAxisValue_Params Parms{};

	Parms.InputAxisKey = InputAxisKey;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetInputAxisValue
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InputAxisName                                                    (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetInputAxisValue(class FName InputAxisName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetInputAxisValue");

	Params::AActor_GetInputAxisValue_Params Parms{};

	Parms.InputAxisName = InputAxisName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetInputAxisKeyValue
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        InputAxisKey                                                     (ConstParm, Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetInputAxisKeyValue(const struct FKey& InputAxisKey)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetInputAxisKeyValue");

	Params::AActor_GetInputAxisKeyValue_Params Parms{};

	Parms.InputAxisKey = InputAxisKey;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetHorizontalDotProductTo
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      OtherActor                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetHorizontalDotProductTo(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetHorizontalDotProductTo");

	Params::AActor_GetHorizontalDotProductTo_Params Parms{};

	Parms.OtherActor = OtherActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetHorizontalDistanceTo
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      OtherActor                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetHorizontalDistanceTo(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetHorizontalDistanceTo");

	Params::AActor_GetHorizontalDistanceTo_Params Parms{};

	Parms.OtherActor = OtherActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetGameTimeSinceCreation
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetGameTimeSinceCreation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetGameTimeSinceCreation");

	Params::AActor_GetGameTimeSinceCreation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetDotProductTo
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      OtherActor                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetDotProductTo(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetDotProductTo");

	Params::AActor_GetDotProductTo_Params Parms{};

	Parms.OtherActor = OtherActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetDistanceTo
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      OtherActor                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetDistanceTo(class AActor* OtherActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetDistanceTo");

	Params::AActor_GetDistanceTo_Params Parms{};

	Parms.OtherActor = OtherActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetComponentsByTag
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TSubclassOf<class UActorComponent> ComponentClass                                                   (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        Tag                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<class UActorComponent*>     ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, ContainsInstancedReference, NativeAccessSpecifierPublic)

TArray<class UActorComponent*> AActor::GetComponentsByTag(TSubclassOf<class UActorComponent> ComponentClass, class FName Tag)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetComponentsByTag");

	Params::AActor_GetComponentsByTag_Params Parms{};

	Parms.ComponentClass = ComponentClass;
	Parms.Tag = Tag;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetComponentsByInterface
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TSubclassOf<class IInterface>      Interface                                                        (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<class UActorComponent*>     ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, ContainsInstancedReference, NativeAccessSpecifierPublic)

TArray<class UActorComponent*> AActor::GetComponentsByInterface(TSubclassOf<class IInterface> Interface)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetComponentsByInterface");

	Params::AActor_GetComponentsByInterface_Params Parms{};

	Parms.Interface = Interface;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetComponentByClass
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TSubclassOf<class UActorComponent> ComponentClass                                                   (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UActorComponent*             ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UActorComponent* AActor::GetComponentByClass(TSubclassOf<class UActorComponent> ComponentClass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetComponentByClass");

	Params::AActor_GetComponentByClass_Params Parms{};

	Parms.ComponentClass = ComponentClass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetAttachParentSocketName
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName AActor::GetAttachParentSocketName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetAttachParentSocketName");

	Params::AActor_GetAttachParentSocketName_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetAttachParentActor
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* AActor::GetAttachParentActor()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetAttachParentActor");

	Params::AActor_GetAttachParentActor_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetAttachedActors
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class AActor*>              OutActors                                                        (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// bool                               bResetArray                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bRecursivelyIncludeAttachedActors                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::GetAttachedActors(TArray<class AActor*>* OutActors, bool bResetArray, bool bRecursivelyIncludeAttachedActors)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetAttachedActors");

	Params::AActor_GetAttachedActors_Params Parms{};

	Parms.bResetArray = bResetArray;
	Parms.bRecursivelyIncludeAttachedActors = bRecursivelyIncludeAttachedActors;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutActors != nullptr)
		*OutActors = std::move(Parms.OutActors);

}


// Function Engine.Actor.GetAllChildActors
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class AActor*>              ChildActors                                                      (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// bool                               bIncludeDescendants                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::GetAllChildActors(TArray<class AActor*>* ChildActors, bool bIncludeDescendants)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetAllChildActors");

	Params::AActor_GetAllChildActors_Params Parms{};

	Parms.bIncludeDescendants = bIncludeDescendants;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (ChildActors != nullptr)
		*ChildActors = std::move(Parms.ChildActors);

}


// Function Engine.Actor.GetActorUpVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::GetActorUpVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorUpVector");

	Params::AActor_GetActorUpVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorTimeDilation
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetActorTimeDilation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorTimeDilation");

	Params::AActor_GetActorTimeDilation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorTickInterval
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AActor::GetActorTickInterval()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorTickInterval");

	Params::AActor_GetActorTickInterval_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorScale3D
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::GetActorScale3D()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorScale3D");

	Params::AActor_GetActorScale3D_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorRightVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::GetActorRightVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorRightVector");

	Params::AActor_GetActorRightVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorRelativeScale3D
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::GetActorRelativeScale3D()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorRelativeScale3D");

	Params::AActor_GetActorRelativeScale3D_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorForwardVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector AActor::GetActorForwardVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorForwardVector");

	Params::AActor_GetActorForwardVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorEyesViewPoint
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     OutLocation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    OutRotation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void AActor::GetActorEyesViewPoint(struct FVector* OutLocation, struct FRotator* OutRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorEyesViewPoint");

	Params::AActor_GetActorEyesViewPoint_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutLocation != nullptr)
		*OutLocation = std::move(Parms.OutLocation);

	if (OutRotation != nullptr)
		*OutRotation = std::move(Parms.OutRotation);

}


// Function Engine.Actor.GetActorEnableCollision
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::GetActorEnableCollision()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorEnableCollision");

	Params::AActor_GetActorEnableCollision_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.GetActorBounds
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               bOnlyCollidingComponents                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Origin                                                           (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     BoxExtent                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bIncludeFromChildActors                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::GetActorBounds(bool bOnlyCollidingComponents, struct FVector* Origin, struct FVector* BoxExtent, bool bIncludeFromChildActors)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "GetActorBounds");

	Params::AActor_GetActorBounds_Params Parms{};

	Parms.bOnlyCollidingComponents = bOnlyCollidingComponents;
	Parms.bIncludeFromChildActors = bIncludeFromChildActors;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (Origin != nullptr)
		*Origin = std::move(Parms.Origin);

	if (BoxExtent != nullptr)
		*BoxExtent = std::move(Parms.BoxExtent);

}


// Function Engine.Actor.ForceNetUpdate
// (Native, Public, BlueprintCallable)
// Parameters:

void AActor::ForceNetUpdate()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ForceNetUpdate");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.FlushNetDormancy
// (Final, BlueprintAuthorityOnly, Native, Public, BlueprintCallable)
// Parameters:

void AActor::FlushNetDormancy()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "FlushNetDormancy");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.FinishAddComponent
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// class UActorComponent*             Component                                                        (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bManualAttachment                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  RelativeTransform                                                (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::FinishAddComponent(class UActorComponent* Component, bool bManualAttachment, struct FTransform& RelativeTransform)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "FinishAddComponent");

	Params::AActor_FinishAddComponent_Params Parms{};

	Parms.Component = Component;
	Parms.bManualAttachment = bManualAttachment;
	Parms.RelativeTransform = RelativeTransform;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.EnableInput
// (Native, Public, BlueprintCallable)
// Parameters:
// class APlayerController*           PlayerController                                                 (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::EnableInput(class APlayerController* PlayerController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "EnableInput");

	Params::AActor_EnableInput_Params Parms{};

	Parms.PlayerController = PlayerController;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.DisableInput
// (Native, Public, BlueprintCallable)
// Parameters:
// class APlayerController*           PlayerController                                                 (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::DisableInput(class APlayerController* PlayerController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "DisableInput");

	Params::AActor_DisableInput_Params Parms{};

	Parms.PlayerController = PlayerController;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.DetachRootComponentFromParent
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bMaintainWorldPosition                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::DetachRootComponentFromParent(bool bMaintainWorldPosition)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "DetachRootComponentFromParent");

	Params::AActor_DetachRootComponentFromParent_Params Parms{};

	Parms.bMaintainWorldPosition = bMaintainWorldPosition;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.AddTickPrerequisiteComponent
// (Native, Public, BlueprintCallable)
// Parameters:
// class UActorComponent*             PrerequisiteComponent                                            (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::AddTickPrerequisiteComponent(class UActorComponent* PrerequisiteComponent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "AddTickPrerequisiteComponent");

	Params::AActor_AddTickPrerequisiteComponent_Params Parms{};

	Parms.PrerequisiteComponent = PrerequisiteComponent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.AddTickPrerequisiteActor
// (Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      PrerequisiteActor                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AActor::AddTickPrerequisiteActor(class AActor* PrerequisiteActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "AddTickPrerequisiteActor");

	Params::AActor_AddTickPrerequisiteActor_Params Parms{};

	Parms.PrerequisiteActor = PrerequisiteActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Actor.AddComponentByClass
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// TSubclassOf<class UActorComponent> Class                                                            (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bManualAttachment                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  RelativeTransform                                                (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bDeferredFinish                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UActorComponent*             ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UActorComponent* AActor::AddComponentByClass(TSubclassOf<class UActorComponent> Class, bool bManualAttachment, struct FTransform& RelativeTransform, bool bDeferredFinish)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "AddComponentByClass");

	Params::AActor_AddComponentByClass_Params Parms{};

	Parms.Class = Class;
	Parms.bManualAttachment = bManualAttachment;
	Parms.RelativeTransform = RelativeTransform;
	Parms.bDeferredFinish = bDeferredFinish;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.AddComponent
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        TemplateName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bManualAttachment                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  RelativeTransform                                                (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UObject*                     ComponentTemplateContext                                         (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bDeferredFinish                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UActorComponent*             ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UActorComponent* AActor::AddComponent(class FName TemplateName, bool bManualAttachment, struct FTransform& RelativeTransform, class UObject* ComponentTemplateContext, bool bDeferredFinish)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "AddComponent");

	Params::AActor_AddComponent_Params Parms{};

	Parms.TemplateName = TemplateName;
	Parms.bManualAttachment = bManualAttachment;
	Parms.RelativeTransform = RelativeTransform;
	Parms.ComponentTemplateContext = ComponentTemplateContext;
	Parms.bDeferredFinish = bDeferredFinish;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Actor.ActorHasTag
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        Tag                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AActor::ActorHasTag(class FName Tag)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Actor", "ActorHasTag");

	Params::AActor_ActorHasTag_Params Parms{};

	Parms.Tag = Tag;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.Subsystem
// (None)

class UClass* USubsystem::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Subsystem");

	return Clss;
}


// Subsystem Engine.Default__Subsystem
// (Public, ClassDefaultObject, ArchetypeObject)

class USubsystem* USubsystem::GetDefaultObj()
{
	static class USubsystem* Default = nullptr;

	if (!Default)
		Default = static_cast<USubsystem*>(USubsystem::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.DynamicSubsystem
// (None)

class UClass* UDynamicSubsystem::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("DynamicSubsystem");

	return Clss;
}


// DynamicSubsystem Engine.Default__DynamicSubsystem
// (Public, ClassDefaultObject, ArchetypeObject)

class UDynamicSubsystem* UDynamicSubsystem::GetDefaultObj()
{
	static class UDynamicSubsystem* Default = nullptr;

	if (!Default)
		Default = static_cast<UDynamicSubsystem*>(UDynamicSubsystem::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.EngineSubsystem
// (None)

class UClass* UEngineSubsystem::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("EngineSubsystem");

	return Clss;
}


// EngineSubsystem Engine.Default__EngineSubsystem
// (Public, ClassDefaultObject, ArchetypeObject)

class UEngineSubsystem* UEngineSubsystem::GetDefaultObj()
{
	static class UEngineSubsystem* Default = nullptr;

	if (!Default)
		Default = static_cast<UEngineSubsystem*>(UEngineSubsystem::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.SceneComponent
// (SceneComponent)

class UClass* USceneComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("SceneComponent");

	return Clss;
}


// SceneComponent Engine.Default__SceneComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class USceneComponent* USceneComponent::GetDefaultObj()
{
	static class USceneComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<USceneComponent*>(USceneComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.SceneComponent.ToggleVisibility
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bPropagateToChildren                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::ToggleVisibility(bool bPropagateToChildren)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "ToggleVisibility");

	Params::USceneComponent_ToggleVisibility_Params Parms{};

	Parms.bPropagateToChildren = bPropagateToChildren;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.SetWorldScale3D
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewScale                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::SetWorldScale3D(const struct FVector& NewScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "SetWorldScale3D");

	Params::USceneComponent_SetWorldScale3D_Params Parms{};

	Parms.NewScale = NewScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.SetVisibility
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewVisibility                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPropagateToChildren                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::SetVisibility(bool bNewVisibility, bool bPropagateToChildren)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "SetVisibility");

	Params::USceneComponent_SetVisibility_Params Parms{};

	Parms.bNewVisibility = bNewVisibility;
	Parms.bPropagateToChildren = bPropagateToChildren;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.SetShouldUpdatePhysicsVolume
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInShouldUpdatePhysicsVolume                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::SetShouldUpdatePhysicsVolume(bool bInShouldUpdatePhysicsVolume)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "SetShouldUpdatePhysicsVolume");

	Params::USceneComponent_SetShouldUpdatePhysicsVolume_Params Parms{};

	Parms.bInShouldUpdatePhysicsVolume = bInShouldUpdatePhysicsVolume;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.SetRelativeScale3D
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewScale3D                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::SetRelativeScale3D(const struct FVector& NewScale3D)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "SetRelativeScale3D");

	Params::USceneComponent_SetRelativeScale3D_Params Parms{};

	Parms.NewScale3D = NewScale3D;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.SetMobility
// (Native, Public, BlueprintCallable)
// Parameters:
// enum class EComponentMobility      NewMobility                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::SetMobility(enum class EComponentMobility NewMobility)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "SetMobility");

	Params::USceneComponent_SetMobility_Params Parms{};

	Parms.NewMobility = NewMobility;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.SetHiddenInGame
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               NewHidden                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPropagateToChildren                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::SetHiddenInGame(bool NewHidden, bool bPropagateToChildren)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "SetHiddenInGame");

	Params::USceneComponent_SetHiddenInGame_Params Parms{};

	Parms.NewHidden = NewHidden;
	Parms.bPropagateToChildren = bPropagateToChildren;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.SetAbsolute
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewAbsoluteLocation                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNewAbsoluteRotation                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNewAbsoluteScale                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::SetAbsolute(bool bNewAbsoluteLocation, bool bNewAbsoluteRotation, bool bNewAbsoluteScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "SetAbsolute");

	Params::USceneComponent_SetAbsolute_Params Parms{};

	Parms.bNewAbsoluteLocation = bNewAbsoluteLocation;
	Parms.bNewAbsoluteRotation = bNewAbsoluteRotation;
	Parms.bNewAbsoluteScale = bNewAbsoluteScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.ResetRelativeTransform
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void USceneComponent::ResetRelativeTransform()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "ResetRelativeTransform");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.OnRep_Visibility
// (Final, Native, Private)
// Parameters:
// bool                               OldValue                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::OnRep_Visibility(bool OldValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "OnRep_Visibility");

	Params::USceneComponent_OnRep_Visibility_Params Parms{};

	Parms.OldValue = OldValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.OnRep_Transform
// (Final, Native, Private)
// Parameters:

void USceneComponent::OnRep_Transform()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "OnRep_Transform");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.OnRep_AttachSocketName
// (Final, Native, Private)
// Parameters:

void USceneComponent::OnRep_AttachSocketName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "OnRep_AttachSocketName");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.OnRep_AttachParent
// (Final, Native, Private)
// Parameters:

void USceneComponent::OnRep_AttachParent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "OnRep_AttachParent");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.OnRep_AttachChildren
// (Final, Native, Private)
// Parameters:

void USceneComponent::OnRep_AttachChildren()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "OnRep_AttachChildren");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.K2_SetWorldTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  NewTransform                                                     (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetWorldTransform(struct FTransform& NewTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetWorldTransform");

	Params::USceneComponent_K2_SetWorldTransform_Params Parms{};

	Parms.NewTransform = NewTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_SetWorldRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetWorldRotation(const struct FRotator& NewRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetWorldRotation");

	Params::USceneComponent_K2_SetWorldRotation_Params Parms{};

	Parms.NewRotation = NewRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_SetWorldLocationAndRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetWorldLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetWorldLocationAndRotation");

	Params::USceneComponent_K2_SetWorldLocationAndRotation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.NewRotation = NewRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_SetWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetWorldLocation(const struct FVector& NewLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetWorldLocation");

	Params::USceneComponent_K2_SetWorldLocation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_SetRelativeTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  NewTransform                                                     (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetRelativeTransform(struct FTransform& NewTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetRelativeTransform");

	Params::USceneComponent_K2_SetRelativeTransform_Params Parms{};

	Parms.NewTransform = NewTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_SetRelativeRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetRelativeRotation(const struct FRotator& NewRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetRelativeRotation");

	Params::USceneComponent_K2_SetRelativeRotation_Params Parms{};

	Parms.NewRotation = NewRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_SetRelativeLocationAndRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetRelativeLocationAndRotation(const struct FVector& NewLocation, const struct FRotator& NewRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetRelativeLocationAndRotation");

	Params::USceneComponent_K2_SetRelativeLocationAndRotation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.NewRotation = NewRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_SetRelativeLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_SetRelativeLocation(const struct FVector& NewLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_SetRelativeLocation");

	Params::USceneComponent_K2_SetRelativeLocation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_GetComponentToWorld
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USceneComponent::K2_GetComponentToWorld()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_GetComponentToWorld");

	Params::USceneComponent_K2_GetComponentToWorld_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.K2_GetComponentScale
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USceneComponent::K2_GetComponentScale()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_GetComponentScale");

	Params::USceneComponent_K2_GetComponentScale_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.K2_GetComponentRotation
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USceneComponent::K2_GetComponentRotation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_GetComponentRotation");

	Params::USceneComponent_K2_GetComponentRotation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.K2_GetComponentLocation
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USceneComponent::K2_GetComponentLocation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_GetComponentLocation");

	Params::USceneComponent_K2_GetComponentLocation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.K2_DetachFromComponent
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class EDetachmentRule         LocationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EDetachmentRule         RotationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EDetachmentRule         ScaleRule                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bCallModify                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_DetachFromComponent(enum class EDetachmentRule LocationRule, enum class EDetachmentRule RotationRule, enum class EDetachmentRule ScaleRule, bool bCallModify)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_DetachFromComponent");

	Params::USceneComponent_K2_DetachFromComponent_Params Parms{};

	Parms.LocationRule = LocationRule;
	Parms.RotationRule = RotationRule;
	Parms.ScaleRule = ScaleRule;
	Parms.bCallModify = bCallModify;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SceneComponent.K2_AttachToComponent
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USceneComponent*             Parent                                                           (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        SocketName                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         LocationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         RotationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         ScaleRule                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bWeldSimulatedBodies                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USceneComponent::K2_AttachToComponent(class USceneComponent* Parent, class FName SocketName, enum class EAttachmentRule LocationRule, enum class EAttachmentRule RotationRule, enum class EAttachmentRule ScaleRule, bool bWeldSimulatedBodies)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AttachToComponent");

	Params::USceneComponent_K2_AttachToComponent_Params Parms{};

	Parms.Parent = Parent;
	Parms.SocketName = SocketName;
	Parms.LocationRule = LocationRule;
	Parms.RotationRule = RotationRule;
	Parms.ScaleRule = ScaleRule;
	Parms.bWeldSimulatedBodies = bWeldSimulatedBodies;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.K2_AttachTo
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USceneComponent*             InParent                                                         (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachLocation         AttachType                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bWeldSimulatedBodies                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USceneComponent::K2_AttachTo(class USceneComponent* InParent, class FName InSocketName, enum class EAttachLocation AttachType, bool bWeldSimulatedBodies)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AttachTo");

	Params::USceneComponent_K2_AttachTo_Params Parms{};

	Parms.InParent = InParent;
	Parms.InSocketName = InSocketName;
	Parms.AttachType = AttachType;
	Parms.bWeldSimulatedBodies = bWeldSimulatedBodies;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.K2_AddWorldTransformKeepScale
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  DeltaTransform                                                   (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddWorldTransformKeepScale(struct FTransform& DeltaTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddWorldTransformKeepScale");

	Params::USceneComponent_K2_AddWorldTransformKeepScale_Params Parms{};

	Parms.DeltaTransform = DeltaTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddWorldTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  DeltaTransform                                                   (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddWorldTransform(struct FTransform& DeltaTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddWorldTransform");

	Params::USceneComponent_K2_AddWorldTransform_Params Parms{};

	Parms.DeltaTransform = DeltaTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddWorldRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    DeltaRotation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddWorldRotation(const struct FRotator& DeltaRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddWorldRotation");

	Params::USceneComponent_K2_AddWorldRotation_Params Parms{};

	Parms.DeltaRotation = DeltaRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddWorldOffset
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     DeltaLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddWorldOffset(const struct FVector& DeltaLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddWorldOffset");

	Params::USceneComponent_K2_AddWorldOffset_Params Parms{};

	Parms.DeltaLocation = DeltaLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddRelativeRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    DeltaRotation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddRelativeRotation(const struct FRotator& DeltaRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddRelativeRotation");

	Params::USceneComponent_K2_AddRelativeRotation_Params Parms{};

	Parms.DeltaRotation = DeltaRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddRelativeLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     DeltaLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddRelativeLocation(const struct FVector& DeltaLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddRelativeLocation");

	Params::USceneComponent_K2_AddRelativeLocation_Params Parms{};

	Parms.DeltaLocation = DeltaLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddLocalTransform
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FTransform                  DeltaTransform                                                   (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddLocalTransform(struct FTransform& DeltaTransform, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddLocalTransform");

	Params::USceneComponent_K2_AddLocalTransform_Params Parms{};

	Parms.DeltaTransform = DeltaTransform;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddLocalRotation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    DeltaRotation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, AdvancedDisplay, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddLocalRotation(const struct FRotator& DeltaRotation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddLocalRotation");

	Params::USceneComponent_K2_AddLocalRotation_Params Parms{};

	Parms.DeltaRotation = DeltaRotation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.K2_AddLocalOffset
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     DeltaLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSweep                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  SweepHitResult                                                   (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               bTeleport                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::K2_AddLocalOffset(const struct FVector& DeltaLocation, bool bSweep, struct FHitResult* SweepHitResult, bool bTeleport)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "K2_AddLocalOffset");

	Params::USceneComponent_K2_AddLocalOffset_Params Parms{};

	Parms.DeltaLocation = DeltaLocation;
	Parms.bSweep = bSweep;
	Parms.bTeleport = bTeleport;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SweepHitResult != nullptr)
		*SweepHitResult = std::move(Parms.SweepHitResult);

}


// Function Engine.SceneComponent.IsVisible
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USceneComponent::IsVisible()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "IsVisible");

	Params::USceneComponent_IsVisible_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.IsSimulatingPhysics
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USceneComponent::IsSimulatingPhysics(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "IsSimulatingPhysics");

	Params::USceneComponent_IsSimulatingPhysics_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.IsAnySimulatingPhysics
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USceneComponent::IsAnySimulatingPhysics()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "IsAnySimulatingPhysics");

	Params::USceneComponent_IsAnySimulatingPhysics_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetUpVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USceneComponent::GetUpVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetUpVector");

	Params::USceneComponent_GetUpVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetSocketTransform
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ERelativeTransformSpace TransformSpace                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USceneComponent::GetSocketTransform(class FName InSocketName, enum class ERelativeTransformSpace TransformSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetSocketTransform");

	Params::USceneComponent_GetSocketTransform_Params Parms{};

	Parms.InSocketName = InSocketName;
	Parms.TransformSpace = TransformSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetSocketRotation
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USceneComponent::GetSocketRotation(class FName InSocketName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetSocketRotation");

	Params::USceneComponent_GetSocketRotation_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetSocketQuaternion
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FQuat                       ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FQuat USceneComponent::GetSocketQuaternion(class FName InSocketName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetSocketQuaternion");

	Params::USceneComponent_GetSocketQuaternion_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetSocketLocation
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USceneComponent::GetSocketLocation(class FName InSocketName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetSocketLocation");

	Params::USceneComponent_GetSocketLocation_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetShouldUpdatePhysicsVolume
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USceneComponent::GetShouldUpdatePhysicsVolume()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetShouldUpdatePhysicsVolume");

	Params::USceneComponent_GetShouldUpdatePhysicsVolume_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetRightVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USceneComponent::GetRightVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetRightVector");

	Params::USceneComponent_GetRightVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetRelativeTransform
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USceneComponent::GetRelativeTransform()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetRelativeTransform");

	Params::USceneComponent_GetRelativeTransform_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetPhysicsVolume
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class APhysicsVolume*              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APhysicsVolume* USceneComponent::GetPhysicsVolume()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetPhysicsVolume");

	Params::USceneComponent_GetPhysicsVolume_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetParentComponents
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class USceneComponent*>     Parents                                                          (Parm, OutParm, ZeroConstructor, ContainsInstancedReference, NativeAccessSpecifierPublic)

void USceneComponent::GetParentComponents(TArray<class USceneComponent*>* Parents)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetParentComponents");

	Params::USceneComponent_GetParentComponents_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (Parents != nullptr)
		*Parents = std::move(Parms.Parents);

}


// Function Engine.SceneComponent.GetNumChildrenComponents
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USceneComponent::GetNumChildrenComponents()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetNumChildrenComponents");

	Params::USceneComponent_GetNumChildrenComponents_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetForwardVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USceneComponent::GetForwardVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetForwardVector");

	Params::USceneComponent_GetForwardVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetComponentVelocity
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USceneComponent::GetComponentVelocity()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetComponentVelocity");

	Params::USceneComponent_GetComponentVelocity_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetChildrenComponents
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               bIncludeAllDescendants                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<class USceneComponent*>     Children                                                         (Parm, OutParm, ZeroConstructor, ContainsInstancedReference, NativeAccessSpecifierPublic)

void USceneComponent::GetChildrenComponents(bool bIncludeAllDescendants, TArray<class USceneComponent*>* Children)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetChildrenComponents");

	Params::USceneComponent_GetChildrenComponents_Params Parms{};

	Parms.bIncludeAllDescendants = bIncludeAllDescendants;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (Children != nullptr)
		*Children = std::move(Parms.Children);

}


// Function Engine.SceneComponent.GetChildComponent
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ChildIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class USceneComponent*             ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USceneComponent* USceneComponent::GetChildComponent(int32 ChildIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetChildComponent");

	Params::USceneComponent_GetChildComponent_Params Parms{};

	Parms.ChildIndex = ChildIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetAttachSocketName
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName USceneComponent::GetAttachSocketName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetAttachSocketName");

	Params::USceneComponent_GetAttachSocketName_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetAttachParent
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class USceneComponent*             ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USceneComponent* USceneComponent::GetAttachParent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetAttachParent");

	Params::USceneComponent_GetAttachParent_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.GetAllSocketNames
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class FName>                ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NativeAccessSpecifierPublic)

TArray<class FName> USceneComponent::GetAllSocketNames()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "GetAllSocketNames");

	Params::USceneComponent_GetAllSocketNames_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.DoesSocketExist
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USceneComponent::DoesSocketExist(class FName InSocketName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "DoesSocketExist");

	Params::USceneComponent_DoesSocketExist_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SceneComponent.DetachFromParent
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bMaintainWorldPosition                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bCallModify                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USceneComponent::DetachFromParent(bool bMaintainWorldPosition, bool bCallModify)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SceneComponent", "DetachFromParent");

	Params::USceneComponent_DetachFromParent_Params Parms{};

	Parms.bMaintainWorldPosition = bMaintainWorldPosition;
	Parms.bCallModify = bCallModify;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.PrimitiveComponent
// (SceneComponent, PrimitiveComponent)

class UClass* UPrimitiveComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("PrimitiveComponent");

	return Clss;
}


// PrimitiveComponent Engine.Default__PrimitiveComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class UPrimitiveComponent* UPrimitiveComponent::GetDefaultObj()
{
	static class UPrimitiveComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<UPrimitiveComponent*>(UPrimitiveComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.PrimitiveComponent.WasRecentlyRendered
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Tolerance                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::WasRecentlyRendered(float Tolerance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "WasRecentlyRendered");

	Params::UPrimitiveComponent_WasRecentlyRendered_Params Parms{};

	Parms.Tolerance = Tolerance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.WakeRigidBody
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::WakeRigidBody(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "WakeRigidBody");

	Params::UPrimitiveComponent_WakeRigidBody_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.WakeAllRigidBodies
// (Native, Public, BlueprintCallable)
// Parameters:

void UPrimitiveComponent::WakeAllRigidBodies()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "WakeAllRigidBodies");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetWalkableSlopeOverride
// (Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// struct FWalkableSlopeOverride      NewOverride                                                      (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetWalkableSlopeOverride(struct FWalkableSlopeOverride& NewOverride)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetWalkableSlopeOverride");

	Params::UPrimitiveComponent_SetWalkableSlopeOverride_Params Parms{};

	Parms.NewOverride = NewOverride;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetVisibleInSceneCaptureOnly
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bValue                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetVisibleInSceneCaptureOnly(bool bValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetVisibleInSceneCaptureOnly");

	Params::UPrimitiveComponent_SetVisibleInSceneCaptureOnly_Params Parms{};

	Parms.bValue = bValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetVisibleInRayTracing
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewVisibleInRayTracing                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetVisibleInRayTracing(bool bNewVisibleInRayTracing)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetVisibleInRayTracing");

	Params::UPrimitiveComponent_SetVisibleInRayTracing_Params Parms{};

	Parms.bNewVisibleInRayTracing = bNewVisibleInRayTracing;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetVectorParameterForDefaultCustomPrimitiveData
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector4                    Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetVectorParameterForDefaultCustomPrimitiveData(class FName ParameterName, const struct FVector4& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetVectorParameterForDefaultCustomPrimitiveData");

	Params::UPrimitiveComponent_SetVectorParameterForDefaultCustomPrimitiveData_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetVectorParameterForCustomPrimitiveData
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector4                    Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetVectorParameterForCustomPrimitiveData(class FName ParameterName, const struct FVector4& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetVectorParameterForCustomPrimitiveData");

	Params::UPrimitiveComponent_SetVectorParameterForCustomPrimitiveData_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetUseCCD
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               InUseCCD                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetUseCCD(bool InUseCCD, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetUseCCD");

	Params::UPrimitiveComponent_SetUseCCD_Params Parms{};

	Parms.InUseCCD = InUseCCD;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetTranslucentSortPriority
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              NewTranslucentSortPriority                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetTranslucentSortPriority(int32 NewTranslucentSortPriority)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetTranslucentSortPriority");

	Params::UPrimitiveComponent_SetTranslucentSortPriority_Params Parms{};

	Parms.NewTranslucentSortPriority = NewTranslucentSortPriority;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetTranslucencySortDistanceOffset
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewTranslucencySortDistanceOffset                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetTranslucencySortDistanceOffset(float NewTranslucencySortDistanceOffset)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetTranslucencySortDistanceOffset");

	Params::UPrimitiveComponent_SetTranslucencySortDistanceOffset_Params Parms{};

	Parms.NewTranslucencySortDistanceOffset = NewTranslucencySortDistanceOffset;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetSingleSampleShadowFromStationaryLights
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewSingleSampleShadowFromStationaryLights                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetSingleSampleShadowFromStationaryLights(bool bNewSingleSampleShadowFromStationaryLights)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetSingleSampleShadowFromStationaryLights");

	Params::UPrimitiveComponent_SetSingleSampleShadowFromStationaryLights_Params Parms{};

	Parms.bNewSingleSampleShadowFromStationaryLights = bNewSingleSampleShadowFromStationaryLights;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetSimulatePhysics
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bSimulate                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetSimulatePhysics(bool bSimulate)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetSimulatePhysics");

	Params::UPrimitiveComponent_SetSimulatePhysics_Params Parms{};

	Parms.bSimulate = bSimulate;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetScalarParameterForDefaultCustomPrimitiveData
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetScalarParameterForDefaultCustomPrimitiveData(class FName ParameterName, float Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetScalarParameterForDefaultCustomPrimitiveData");

	Params::UPrimitiveComponent_SetScalarParameterForDefaultCustomPrimitiveData_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetScalarParameterForCustomPrimitiveData
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetScalarParameterForCustomPrimitiveData(class FName ParameterName, float Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetScalarParameterForCustomPrimitiveData");

	Params::UPrimitiveComponent_SetScalarParameterForCustomPrimitiveData_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetRenderInMainPass
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bValue                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetRenderInMainPass(bool bValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetRenderInMainPass");

	Params::UPrimitiveComponent_SetRenderInMainPass_Params Parms{};

	Parms.bValue = bValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetRenderInDepthPass
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bValue                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetRenderInDepthPass(bool bValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetRenderInDepthPass");

	Params::UPrimitiveComponent_SetRenderInDepthPass_Params Parms{};

	Parms.bValue = bValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetRenderCustomDepth
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bValue                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetRenderCustomDepth(bool bValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetRenderCustomDepth");

	Params::UPrimitiveComponent_SetRenderCustomDepth_Params Parms{};

	Parms.bValue = bValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetReceivesDecals
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewReceivesDecals                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetReceivesDecals(bool bNewReceivesDecals)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetReceivesDecals");

	Params::UPrimitiveComponent_SetReceivesDecals_Params Parms{};

	Parms.bNewReceivesDecals = bNewReceivesDecals;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetPhysMaterialOverride
// (Native, Public, BlueprintCallable)
// Parameters:
// class UPhysicalMaterial*           NewPhysMaterial                                                  (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetPhysMaterialOverride(class UPhysicalMaterial* NewPhysMaterial)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetPhysMaterialOverride");

	Params::UPrimitiveComponent_SetPhysMaterialOverride_Params Parms{};

	Parms.NewPhysMaterial = NewPhysMaterial;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocityInRadians
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewMaxAngVel                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetPhysicsMaxAngularVelocityInRadians(float NewMaxAngVel, bool bAddToCurrent, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetPhysicsMaxAngularVelocityInRadians");

	Params::UPrimitiveComponent_SetPhysicsMaxAngularVelocityInRadians_Params Parms{};

	Parms.NewMaxAngVel = NewMaxAngVel;
	Parms.bAddToCurrent = bAddToCurrent;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetPhysicsMaxAngularVelocityInDegrees
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewMaxAngVel                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetPhysicsMaxAngularVelocityInDegrees(float NewMaxAngVel, bool bAddToCurrent, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetPhysicsMaxAngularVelocityInDegrees");

	Params::UPrimitiveComponent_SetPhysicsMaxAngularVelocityInDegrees_Params Parms{};

	Parms.NewMaxAngVel = NewMaxAngVel;
	Parms.bAddToCurrent = bAddToCurrent;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetPhysicsLinearVelocity
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewVel                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetPhysicsLinearVelocity(const struct FVector& NewVel, bool bAddToCurrent, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetPhysicsLinearVelocity");

	Params::UPrimitiveComponent_SetPhysicsLinearVelocity_Params Parms{};

	Parms.NewVel = NewVel;
	Parms.bAddToCurrent = bAddToCurrent;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetPhysicsAngularVelocityInRadians
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewAngVel                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetPhysicsAngularVelocityInRadians(const struct FVector& NewAngVel, bool bAddToCurrent, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetPhysicsAngularVelocityInRadians");

	Params::UPrimitiveComponent_SetPhysicsAngularVelocityInRadians_Params Parms{};

	Parms.NewAngVel = NewAngVel;
	Parms.bAddToCurrent = bAddToCurrent;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetPhysicsAngularVelocityInDegrees
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewAngVel                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetPhysicsAngularVelocityInDegrees(const struct FVector& NewAngVel, bool bAddToCurrent, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetPhysicsAngularVelocityInDegrees");

	Params::UPrimitiveComponent_SetPhysicsAngularVelocityInDegrees_Params Parms{};

	Parms.NewAngVel = NewAngVel;
	Parms.bAddToCurrent = bAddToCurrent;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetOwnerNoSee
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewOwnerNoSee                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetOwnerNoSee(bool bNewOwnerNoSee)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetOwnerNoSee");

	Params::UPrimitiveComponent_SetOwnerNoSee_Params Parms{};

	Parms.bNewOwnerNoSee = bNewOwnerNoSee;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetOnlyOwnerSee
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewOnlyOwnerSee                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetOnlyOwnerSee(bool bNewOnlyOwnerSee)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetOnlyOwnerSee");

	Params::UPrimitiveComponent_SetOnlyOwnerSee_Params Parms{};

	Parms.bNewOnlyOwnerSee = bNewOnlyOwnerSee;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetNotifyRigidBodyCollision
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewNotifyRigidBodyCollision                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetNotifyRigidBodyCollision(bool bNewNotifyRigidBodyCollision)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetNotifyRigidBodyCollision");

	Params::UPrimitiveComponent_SetNotifyRigidBodyCollision_Params Parms{};

	Parms.bNewNotifyRigidBodyCollision = bNewNotifyRigidBodyCollision;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetMaterialByName
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        MaterialSlotName                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInterface*          Material                                                         (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetMaterialByName(class FName MaterialSlotName, class UMaterialInterface* Material)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetMaterialByName");

	Params::UPrimitiveComponent_SetMaterialByName_Params Parms{};

	Parms.MaterialSlotName = MaterialSlotName;
	Parms.Material = Material;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetMaterial
// (Native, Public, BlueprintCallable)
// Parameters:
// int32                              ElementIndex                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInterface*          Material                                                         (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetMaterial(int32 ElementIndex, class UMaterialInterface* Material)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetMaterial");

	Params::UPrimitiveComponent_SetMaterial_Params Parms{};

	Parms.ElementIndex = ElementIndex;
	Parms.Material = Material;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetMassScale
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              InMassScale                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetMassScale(class FName BoneName, float InMassScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetMassScale");

	Params::UPrimitiveComponent_SetMassScale_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.InMassScale = InMassScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetMassOverrideInKg
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MassInKg                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bOverrideMass                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetMassOverrideInKg(class FName BoneName, float MassInKg, bool bOverrideMass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetMassOverrideInKg");

	Params::UPrimitiveComponent_SetMassOverrideInKg_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.MassInKg = MassInKg;
	Parms.bOverrideMass = bOverrideMass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetLinearDamping
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              InDamping                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetLinearDamping(float InDamping)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetLinearDamping");

	Params::UPrimitiveComponent_SetLinearDamping_Params Parms{};

	Parms.InDamping = InDamping;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetLightingChannels
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bChannel0                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bChannel1                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bChannel2                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetLightingChannels(bool bChannel0, bool bChannel1, bool bChannel2)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetLightingChannels");

	Params::UPrimitiveComponent_SetLightingChannels_Params Parms{};

	Parms.bChannel0 = bChannel0;
	Parms.bChannel1 = bChannel1;
	Parms.bChannel2 = bChannel2;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetLightAttachmentsAsGroup
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInLightAttachmentsAsGroup                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetLightAttachmentsAsGroup(bool bInLightAttachmentsAsGroup)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetLightAttachmentsAsGroup");

	Params::UPrimitiveComponent_SetLightAttachmentsAsGroup_Params Parms{};

	Parms.bInLightAttachmentsAsGroup = bInLightAttachmentsAsGroup;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetHiddenInSceneCapture
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bValue                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetHiddenInSceneCapture(bool bValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetHiddenInSceneCapture");

	Params::UPrimitiveComponent_SetHiddenInSceneCapture_Params Parms{};

	Parms.bValue = bValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetGenerateOverlapEvents
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInGenerateOverlapEvents                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetGenerateOverlapEvents(bool bInGenerateOverlapEvents)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetGenerateOverlapEvents");

	Params::UPrimitiveComponent_SetGenerateOverlapEvents_Params Parms{};

	Parms.bInGenerateOverlapEvents = bInGenerateOverlapEvents;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetExcludeFromLightAttachmentGroup
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInExcludeFromLightAttachmentGroup                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetExcludeFromLightAttachmentGroup(bool bInExcludeFromLightAttachmentGroup)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetExcludeFromLightAttachmentGroup");

	Params::UPrimitiveComponent_SetExcludeFromLightAttachmentGroup_Params Parms{};

	Parms.bInExcludeFromLightAttachmentGroup = bInExcludeFromLightAttachmentGroup;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetEnableGravity
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bGravityEnabled                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetEnableGravity(bool bGravityEnabled)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetEnableGravity");

	Params::UPrimitiveComponent_SetEnableGravity_Params Parms{};

	Parms.bGravityEnabled = bGravityEnabled;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetEmissiveLightSource
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               NewEmissiveLightSource                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetEmissiveLightSource(bool NewEmissiveLightSource)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetEmissiveLightSource");

	Params::UPrimitiveComponent_SetEmissiveLightSource_Params Parms{};

	Parms.NewEmissiveLightSource = NewEmissiveLightSource;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetDefaultCustomPrimitiveDataVector4
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector4                    Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetDefaultCustomPrimitiveDataVector4(int32 DataIndex, const struct FVector4& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetDefaultCustomPrimitiveDataVector4");

	Params::UPrimitiveComponent_SetDefaultCustomPrimitiveDataVector4_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetDefaultCustomPrimitiveDataVector3
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetDefaultCustomPrimitiveDataVector3(int32 DataIndex, const struct FVector& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetDefaultCustomPrimitiveDataVector3");

	Params::UPrimitiveComponent_SetDefaultCustomPrimitiveDataVector3_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetDefaultCustomPrimitiveDataVector2
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector2D                   Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetDefaultCustomPrimitiveDataVector2(int32 DataIndex, const struct FVector2D& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetDefaultCustomPrimitiveDataVector2");

	Params::UPrimitiveComponent_SetDefaultCustomPrimitiveDataVector2_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetDefaultCustomPrimitiveDataFloat
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetDefaultCustomPrimitiveDataFloat(int32 DataIndex, float Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetDefaultCustomPrimitiveDataFloat");

	Params::UPrimitiveComponent_SetDefaultCustomPrimitiveDataFloat_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCustomPrimitiveDataVector4
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector4                    Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCustomPrimitiveDataVector4(int32 DataIndex, const struct FVector4& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCustomPrimitiveDataVector4");

	Params::UPrimitiveComponent_SetCustomPrimitiveDataVector4_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCustomPrimitiveDataVector3
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCustomPrimitiveDataVector3(int32 DataIndex, const struct FVector& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCustomPrimitiveDataVector3");

	Params::UPrimitiveComponent_SetCustomPrimitiveDataVector3_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCustomPrimitiveDataVector2
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector2D                   Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCustomPrimitiveDataVector2(int32 DataIndex, const struct FVector2D& Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCustomPrimitiveDataVector2");

	Params::UPrimitiveComponent_SetCustomPrimitiveDataVector2_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCustomPrimitiveDataFloat
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              DataIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCustomPrimitiveDataFloat(int32 DataIndex, float Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCustomPrimitiveDataFloat");

	Params::UPrimitiveComponent_SetCustomPrimitiveDataFloat_Params Parms{};

	Parms.DataIndex = DataIndex;
	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCustomDepthStencilWriteMask
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class ERendererStencilMask    WriteMaskBit                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCustomDepthStencilWriteMask(enum class ERendererStencilMask WriteMaskBit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCustomDepthStencilWriteMask");

	Params::UPrimitiveComponent_SetCustomDepthStencilWriteMask_Params Parms{};

	Parms.WriteMaskBit = WriteMaskBit;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCustomDepthStencilValue
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCustomDepthStencilValue(int32 Value)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCustomDepthStencilValue");

	Params::UPrimitiveComponent_SetCustomDepthStencilValue_Params Parms{};

	Parms.Value = Value;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCullDistance
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewCullDistance                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCullDistance(float NewCullDistance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCullDistance");

	Params::UPrimitiveComponent_SetCullDistance_Params Parms{};

	Parms.NewCullDistance = NewCullDistance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetConstraintMode
// (Native, Public, BlueprintCallable)
// Parameters:
// enum class EDOFMode                ConstraintMode                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetConstraintMode(enum class EDOFMode ConstraintMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetConstraintMode");

	Params::UPrimitiveComponent_SetConstraintMode_Params Parms{};

	Parms.ConstraintMode = ConstraintMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCollisionResponseToChannel
// (Native, Public, BlueprintCallable)
// Parameters:
// enum class ECollisionChannel       Channel                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ECollisionResponse      NewResponse                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCollisionResponseToChannel(enum class ECollisionChannel Channel, enum class ECollisionResponse NewResponse)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCollisionResponseToChannel");

	Params::UPrimitiveComponent_SetCollisionResponseToChannel_Params Parms{};

	Parms.Channel = Channel;
	Parms.NewResponse = NewResponse;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCollisionResponseToAllChannels
// (Native, Public, BlueprintCallable)
// Parameters:
// enum class ECollisionResponse      NewResponse                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCollisionResponseToAllChannels(enum class ECollisionResponse NewResponse)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCollisionResponseToAllChannels");

	Params::UPrimitiveComponent_SetCollisionResponseToAllChannels_Params Parms{};

	Parms.NewResponse = NewResponse;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCollisionProfileName
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        InCollisionProfileName                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateOverlaps                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCollisionProfileName(class FName InCollisionProfileName, bool bUpdateOverlaps)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCollisionProfileName");

	Params::UPrimitiveComponent_SetCollisionProfileName_Params Parms{};

	Parms.InCollisionProfileName = InCollisionProfileName;
	Parms.bUpdateOverlaps = bUpdateOverlaps;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCollisionObjectType
// (Native, Public, BlueprintCallable)
// Parameters:
// enum class ECollisionChannel       Channel                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCollisionObjectType(enum class ECollisionChannel Channel)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCollisionObjectType");

	Params::UPrimitiveComponent_SetCollisionObjectType_Params Parms{};

	Parms.Channel = Channel;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCollisionEnabled
// (Native, Public, BlueprintCallable)
// Parameters:
// enum class ECollisionEnabled       NewType                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCollisionEnabled(enum class ECollisionEnabled NewType)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCollisionEnabled");

	Params::UPrimitiveComponent_SetCollisionEnabled_Params Parms{};

	Parms.NewType = NewType;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCenterOfMass
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     CenterOfMassOffset                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCenterOfMass(const struct FVector& CenterOfMassOffset, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCenterOfMass");

	Params::UPrimitiveComponent_SetCenterOfMass_Params Parms{};

	Parms.CenterOfMassOffset = CenterOfMassOffset;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCastShadow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               NewCastShadow                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCastShadow(bool NewCastShadow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCastShadow");

	Params::UPrimitiveComponent_SetCastShadow_Params Parms{};

	Parms.NewCastShadow = NewCastShadow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCastInsetShadow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInCastInsetShadow                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCastInsetShadow(bool bInCastInsetShadow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCastInsetShadow");

	Params::UPrimitiveComponent_SetCastInsetShadow_Params Parms{};

	Parms.bInCastInsetShadow = bInCastInsetShadow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCastHiddenShadow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               NewCastHiddenShadow                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCastHiddenShadow(bool NewCastHiddenShadow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCastHiddenShadow");

	Params::UPrimitiveComponent_SetCastHiddenShadow_Params Parms{};

	Parms.NewCastHiddenShadow = NewCastHiddenShadow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetCastContactShadow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInCastContactShadow                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetCastContactShadow(bool bInCastContactShadow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetCastContactShadow");

	Params::UPrimitiveComponent_SetCastContactShadow_Params Parms{};

	Parms.bInCastContactShadow = bInCastContactShadow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetBoundsScale
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewBoundsScale                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetBoundsScale(float NewBoundsScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetBoundsScale");

	Params::UPrimitiveComponent_SetBoundsScale_Params Parms{};

	Parms.NewBoundsScale = NewBoundsScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetAngularDamping
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              InDamping                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetAngularDamping(float InDamping)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetAngularDamping");

	Params::UPrimitiveComponent_SetAngularDamping_Params Parms{};

	Parms.InDamping = InDamping;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetAllUseCCD
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               InUseCCD                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetAllUseCCD(bool InUseCCD)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetAllUseCCD");

	Params::UPrimitiveComponent_SetAllUseCCD_Params Parms{};

	Parms.InUseCCD = InUseCCD;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetAllPhysicsLinearVelocity
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewVel                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetAllPhysicsLinearVelocity(const struct FVector& NewVel, bool bAddToCurrent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetAllPhysicsLinearVelocity");

	Params::UPrimitiveComponent_SetAllPhysicsLinearVelocity_Params Parms{};

	Parms.NewVel = NewVel;
	Parms.bAddToCurrent = bAddToCurrent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocityInRadians
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewAngVel                                                        (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetAllPhysicsAngularVelocityInRadians(struct FVector& NewAngVel, bool bAddToCurrent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetAllPhysicsAngularVelocityInRadians");

	Params::UPrimitiveComponent_SetAllPhysicsAngularVelocityInRadians_Params Parms{};

	Parms.NewAngVel = NewAngVel;
	Parms.bAddToCurrent = bAddToCurrent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetAllPhysicsAngularVelocityInDegrees
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewAngVel                                                        (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAddToCurrent                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetAllPhysicsAngularVelocityInDegrees(struct FVector& NewAngVel, bool bAddToCurrent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetAllPhysicsAngularVelocityInDegrees");

	Params::UPrimitiveComponent_SetAllPhysicsAngularVelocityInDegrees_Params Parms{};

	Parms.NewAngVel = NewAngVel;
	Parms.bAddToCurrent = bAddToCurrent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.SetAllMassScale
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              InMassScale                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::SetAllMassScale(float InMassScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "SetAllMassScale");

	Params::UPrimitiveComponent_SetAllMassScale_Params Parms{};

	Parms.InMassScale = InMassScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.ScaleByMomentOfInertia
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     InputVector                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UPrimitiveComponent::ScaleByMomentOfInertia(const struct FVector& InputVector, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "ScaleByMomentOfInertia");

	Params::UPrimitiveComponent_ScaleByMomentOfInertia_Params Parms{};

	Parms.InputVector = InputVector;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.PutRigidBodyToSleep
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::PutRigidBodyToSleep(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "PutRigidBodyToSleep");

	Params::UPrimitiveComponent_PutRigidBodyToSleep_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.K2_SphereTraceComponent
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     TraceStart                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     TraceEnd                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              SphereRadius                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bShowTrace                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPersistentShowTrace                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitLocation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitNormal                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  OutHit                                                           (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::K2_SphereTraceComponent(const struct FVector& TraceStart, const struct FVector& TraceEnd, float SphereRadius, bool bTraceComplex, bool bShowTrace, bool bPersistentShowTrace, struct FVector* HitLocation, struct FVector* HitNormal, class FName* BoneName, struct FHitResult* OutHit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "K2_SphereTraceComponent");

	Params::UPrimitiveComponent_K2_SphereTraceComponent_Params Parms{};

	Parms.TraceStart = TraceStart;
	Parms.TraceEnd = TraceEnd;
	Parms.SphereRadius = SphereRadius;
	Parms.bTraceComplex = bTraceComplex;
	Parms.bShowTrace = bShowTrace;
	Parms.bPersistentShowTrace = bPersistentShowTrace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitLocation != nullptr)
		*HitLocation = std::move(Parms.HitLocation);

	if (HitNormal != nullptr)
		*HitNormal = std::move(Parms.HitNormal);

	if (BoneName != nullptr)
		*BoneName = Parms.BoneName;

	if (OutHit != nullptr)
		*OutHit = std::move(Parms.OutHit);

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.K2_SphereOverlapComponent
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     InSphereCentre                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              InSphereRadius                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bShowTrace                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPersistentShowTrace                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitLocation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitNormal                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  OutHit                                                           (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::K2_SphereOverlapComponent(const struct FVector& InSphereCentre, float InSphereRadius, bool bTraceComplex, bool bShowTrace, bool bPersistentShowTrace, struct FVector* HitLocation, struct FVector* HitNormal, class FName* BoneName, struct FHitResult* OutHit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "K2_SphereOverlapComponent");

	Params::UPrimitiveComponent_K2_SphereOverlapComponent_Params Parms{};

	Parms.InSphereCentre = InSphereCentre;
	Parms.InSphereRadius = InSphereRadius;
	Parms.bTraceComplex = bTraceComplex;
	Parms.bShowTrace = bShowTrace;
	Parms.bPersistentShowTrace = bPersistentShowTrace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitLocation != nullptr)
		*HitLocation = std::move(Parms.HitLocation);

	if (HitNormal != nullptr)
		*HitNormal = std::move(Parms.HitNormal);

	if (BoneName != nullptr)
		*BoneName = Parms.BoneName;

	if (OutHit != nullptr)
		*OutHit = std::move(Parms.OutHit);

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.K2_LineTraceComponent
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     TraceStart                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     TraceEnd                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bShowTrace                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPersistentShowTrace                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitLocation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitNormal                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  OutHit                                                           (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::K2_LineTraceComponent(const struct FVector& TraceStart, const struct FVector& TraceEnd, bool bTraceComplex, bool bShowTrace, bool bPersistentShowTrace, struct FVector* HitLocation, struct FVector* HitNormal, class FName* BoneName, struct FHitResult* OutHit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "K2_LineTraceComponent");

	Params::UPrimitiveComponent_K2_LineTraceComponent_Params Parms{};

	Parms.TraceStart = TraceStart;
	Parms.TraceEnd = TraceEnd;
	Parms.bTraceComplex = bTraceComplex;
	Parms.bShowTrace = bShowTrace;
	Parms.bPersistentShowTrace = bPersistentShowTrace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitLocation != nullptr)
		*HitLocation = std::move(Parms.HitLocation);

	if (HitNormal != nullptr)
		*HitNormal = std::move(Parms.HitNormal);

	if (BoneName != nullptr)
		*BoneName = Parms.BoneName;

	if (OutHit != nullptr)
		*OutHit = std::move(Parms.OutHit);

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.K2_IsQueryCollisionEnabled
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::K2_IsQueryCollisionEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "K2_IsQueryCollisionEnabled");

	Params::UPrimitiveComponent_K2_IsQueryCollisionEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.K2_IsPhysicsCollisionEnabled
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::K2_IsPhysicsCollisionEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "K2_IsPhysicsCollisionEnabled");

	Params::UPrimitiveComponent_K2_IsPhysicsCollisionEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.K2_IsCollisionEnabled
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::K2_IsCollisionEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "K2_IsCollisionEnabled");

	Params::UPrimitiveComponent_K2_IsCollisionEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.K2_BoxOverlapComponent
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     InBoxCentre                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FBox                        InBox                                                            (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bShowTrace                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPersistentShowTrace                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitLocation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     HitNormal                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  OutHit                                                           (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::K2_BoxOverlapComponent(const struct FVector& InBoxCentre, const struct FBox& InBox, bool bTraceComplex, bool bShowTrace, bool bPersistentShowTrace, struct FVector* HitLocation, struct FVector* HitNormal, class FName* BoneName, struct FHitResult* OutHit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "K2_BoxOverlapComponent");

	Params::UPrimitiveComponent_K2_BoxOverlapComponent_Params Parms{};

	Parms.InBoxCentre = InBoxCentre;
	Parms.InBox = InBox;
	Parms.bTraceComplex = bTraceComplex;
	Parms.bShowTrace = bShowTrace;
	Parms.bPersistentShowTrace = bPersistentShowTrace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitLocation != nullptr)
		*HitLocation = std::move(Parms.HitLocation);

	if (HitNormal != nullptr)
		*HitNormal = std::move(Parms.HitNormal);

	if (BoneName != nullptr)
		*BoneName = Parms.BoneName;

	if (OutHit != nullptr)
		*OutHit = std::move(Parms.OutHit);

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.IsOverlappingComponent
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UPrimitiveComponent*         OtherComp                                                        (ConstParm, Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::IsOverlappingComponent(class UPrimitiveComponent* OtherComp)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "IsOverlappingComponent");

	Params::UPrimitiveComponent_IsOverlappingComponent_Params Parms{};

	Parms.OtherComp = OtherComp;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.IsOverlappingActor
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      Other                                                            (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::IsOverlappingActor(class AActor* Other)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "IsOverlappingActor");

	Params::UPrimitiveComponent_IsOverlappingActor_Params Parms{};

	Parms.Other = Other;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.IsGravityEnabled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::IsGravityEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "IsGravityEnabled");

	Params::UPrimitiveComponent_IsGravityEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.IsAnyRigidBodyAwake
// (Native, Public, BlueprintCallable, BlueprintPure)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::IsAnyRigidBodyAwake()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "IsAnyRigidBodyAwake");

	Params::UPrimitiveComponent_IsAnyRigidBodyAwake_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.InvalidateLumenSurfaceCache
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void UPrimitiveComponent::InvalidateLumenSurfaceCache()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "InvalidateLumenSurfaceCache");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.IgnoreComponentWhenMoving
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UPrimitiveComponent*         Component                                                        (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bShouldIgnore                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::IgnoreComponentWhenMoving(class UPrimitiveComponent* Component, bool bShouldIgnore)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "IgnoreComponentWhenMoving");

	Params::UPrimitiveComponent_IgnoreComponentWhenMoving_Params Parms{};

	Parms.Component = Component;
	Parms.bShouldIgnore = bShouldIgnore;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.IgnoreActorWhenMoving
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      Actor                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bShouldIgnore                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::IgnoreActorWhenMoving(class AActor* Actor, bool bShouldIgnore)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "IgnoreActorWhenMoving");

	Params::UPrimitiveComponent_IgnoreActorWhenMoving_Params Parms{};

	Parms.Actor = Actor;
	Parms.bShouldIgnore = bShouldIgnore;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.GetWalkableSlopeOverride
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FWalkableSlopeOverride      ReturnValue                                                      (ConstParm, Parm, OutParm, ReturnParm, ReferenceParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FWalkableSlopeOverride UPrimitiveComponent::GetWalkableSlopeOverride()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetWalkableSlopeOverride");

	Params::UPrimitiveComponent_GetWalkableSlopeOverride_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetPhysicsLinearVelocityAtPoint
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Point                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UPrimitiveComponent::GetPhysicsLinearVelocityAtPoint(const struct FVector& Point, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetPhysicsLinearVelocityAtPoint");

	Params::UPrimitiveComponent_GetPhysicsLinearVelocityAtPoint_Params Parms{};

	Parms.Point = Point;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetPhysicsLinearVelocity
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UPrimitiveComponent::GetPhysicsLinearVelocity(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetPhysicsLinearVelocity");

	Params::UPrimitiveComponent_GetPhysicsLinearVelocity_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetPhysicsAngularVelocityInRadians
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UPrimitiveComponent::GetPhysicsAngularVelocityInRadians(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetPhysicsAngularVelocityInRadians");

	Params::UPrimitiveComponent_GetPhysicsAngularVelocityInRadians_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetPhysicsAngularVelocityInDegrees
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UPrimitiveComponent::GetPhysicsAngularVelocityInDegrees(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetPhysicsAngularVelocityInDegrees");

	Params::UPrimitiveComponent_GetPhysicsAngularVelocityInDegrees_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetOverlappingComponents
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class UPrimitiveComponent*> OutOverlappingComponents                                         (Parm, OutParm, ZeroConstructor, ContainsInstancedReference, NativeAccessSpecifierPublic)

void UPrimitiveComponent::GetOverlappingComponents(TArray<class UPrimitiveComponent*>* OutOverlappingComponents)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetOverlappingComponents");

	Params::UPrimitiveComponent_GetOverlappingComponents_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutOverlappingComponents != nullptr)
		*OutOverlappingComponents = std::move(Parms.OutOverlappingComponents);

}


// Function Engine.PrimitiveComponent.GetOverlappingActors
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class AActor*>              OverlappingActors                                                (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// TSubclassOf<class AActor>          ClassFilter                                                      (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::GetOverlappingActors(TArray<class AActor*>* OverlappingActors, TSubclassOf<class AActor> ClassFilter)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetOverlappingActors");

	Params::UPrimitiveComponent_GetOverlappingActors_Params Parms{};

	Parms.ClassFilter = ClassFilter;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OverlappingActors != nullptr)
		*OverlappingActors = std::move(Parms.OverlappingActors);

}


// Function Engine.PrimitiveComponent.GetNumMaterials
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 UPrimitiveComponent::GetNumMaterials()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetNumMaterials");

	Params::UPrimitiveComponent_GetNumMaterials_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetMaterialFromCollisionFaceIndex
// (Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              FaceIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              SectionIndex                                                     (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInterface*          ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UMaterialInterface* UPrimitiveComponent::GetMaterialFromCollisionFaceIndex(int32 FaceIndex, int32* SectionIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetMaterialFromCollisionFaceIndex");

	Params::UPrimitiveComponent_GetMaterialFromCollisionFaceIndex_Params Parms{};

	Parms.FaceIndex = FaceIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SectionIndex != nullptr)
		*SectionIndex = Parms.SectionIndex;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetMaterial
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ElementIndex                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInterface*          ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UMaterialInterface* UPrimitiveComponent::GetMaterial(int32 ElementIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetMaterial");

	Params::UPrimitiveComponent_GetMaterial_Params Parms{};

	Parms.ElementIndex = ElementIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetMassScale
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UPrimitiveComponent::GetMassScale(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetMassScale");

	Params::UPrimitiveComponent_GetMassScale_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetMass
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UPrimitiveComponent::GetMass()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetMass");

	Params::UPrimitiveComponent_GetMass_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetLinearDamping
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UPrimitiveComponent::GetLinearDamping()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetLinearDamping");

	Params::UPrimitiveComponent_GetLinearDamping_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetInertiaTensor
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UPrimitiveComponent::GetInertiaTensor(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetInertiaTensor");

	Params::UPrimitiveComponent_GetInertiaTensor_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetGenerateOverlapEvents
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::GetGenerateOverlapEvents()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetGenerateOverlapEvents");

	Params::UPrimitiveComponent_GetGenerateOverlapEvents_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetCustomPrimitiveDataIndexForVectorParameter
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 UPrimitiveComponent::GetCustomPrimitiveDataIndexForVectorParameter(class FName ParameterName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetCustomPrimitiveDataIndexForVectorParameter");

	Params::UPrimitiveComponent_GetCustomPrimitiveDataIndexForVectorParameter_Params Parms{};

	Parms.ParameterName = ParameterName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetCustomPrimitiveDataIndexForScalarParameter
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 UPrimitiveComponent::GetCustomPrimitiveDataIndexForScalarParameter(class FName ParameterName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetCustomPrimitiveDataIndexForScalarParameter");

	Params::UPrimitiveComponent_GetCustomPrimitiveDataIndexForScalarParameter_Params Parms{};

	Parms.ParameterName = ParameterName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetCollisionResponseToChannel
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ECollisionChannel       Channel                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ECollisionResponse      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class ECollisionResponse UPrimitiveComponent::GetCollisionResponseToChannel(enum class ECollisionChannel Channel)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetCollisionResponseToChannel");

	Params::UPrimitiveComponent_GetCollisionResponseToChannel_Params Parms{};

	Parms.Channel = Channel;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetCollisionProfileName
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName UPrimitiveComponent::GetCollisionProfileName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetCollisionProfileName");

	Params::UPrimitiveComponent_GetCollisionProfileName_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetCollisionObjectType
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ECollisionChannel       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class ECollisionChannel UPrimitiveComponent::GetCollisionObjectType()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetCollisionObjectType");

	Params::UPrimitiveComponent_GetCollisionObjectType_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetCollisionEnabled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ECollisionEnabled       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class ECollisionEnabled UPrimitiveComponent::GetCollisionEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetCollisionEnabled");

	Params::UPrimitiveComponent_GetCollisionEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetClosestPointOnCollision
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     Point                                                            (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     OutPointOnBody                                                   (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UPrimitiveComponent::GetClosestPointOnCollision(struct FVector& Point, struct FVector* OutPointOnBody, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetClosestPointOnCollision");

	Params::UPrimitiveComponent_GetClosestPointOnCollision_Params Parms{};

	Parms.Point = Point;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutPointOnBody != nullptr)
		*OutPointOnBody = std::move(Parms.OutPointOnBody);

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetCenterOfMass
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UPrimitiveComponent::GetCenterOfMass(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetCenterOfMass");

	Params::UPrimitiveComponent_GetCenterOfMass_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetBodyInstanceAsyncPhysicsTickHandle
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bGetWelded                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              Index                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FBodyInstanceAsyncPhysicsTickHandleReturnValue                                                      (Parm, OutParm, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FBodyInstanceAsyncPhysicsTickHandle UPrimitiveComponent::GetBodyInstanceAsyncPhysicsTickHandle(class FName BoneName, bool bGetWelded, int32 Index)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetBodyInstanceAsyncPhysicsTickHandle");

	Params::UPrimitiveComponent_GetBodyInstanceAsyncPhysicsTickHandle_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.bGetWelded = bGetWelded;
	Parms.Index = Index;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.GetAngularDamping
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UPrimitiveComponent::GetAngularDamping()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "GetAngularDamping");

	Params::UPrimitiveComponent_GetAngularDamping_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.CreateDynamicMaterialInstance
// (Native, Public, BlueprintCallable)
// Parameters:
// int32                              ElementIndex                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInterface*          SourceMaterial                                                   (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        OptionalName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInstanceDynamic*    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UMaterialInstanceDynamic* UPrimitiveComponent::CreateDynamicMaterialInstance(int32 ElementIndex, class UMaterialInterface* SourceMaterial, class FName OptionalName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "CreateDynamicMaterialInstance");

	Params::UPrimitiveComponent_CreateDynamicMaterialInstance_Params Parms{};

	Parms.ElementIndex = ElementIndex;
	Parms.SourceMaterial = SourceMaterial;
	Parms.OptionalName = OptionalName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.CreateAndSetMaterialInstanceDynamicFromMaterial
// (Native, Public, BlueprintCallable)
// Parameters:
// int32                              ElementIndex                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInterface*          Parent                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInstanceDynamic*    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UMaterialInstanceDynamic* UPrimitiveComponent::CreateAndSetMaterialInstanceDynamicFromMaterial(int32 ElementIndex, class UMaterialInterface* Parent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "CreateAndSetMaterialInstanceDynamicFromMaterial");

	Params::UPrimitiveComponent_CreateAndSetMaterialInstanceDynamicFromMaterial_Params Parms{};

	Parms.ElementIndex = ElementIndex;
	Parms.Parent = Parent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.CreateAndSetMaterialInstanceDynamic
// (Native, Public, BlueprintCallable)
// Parameters:
// int32                              ElementIndex                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UMaterialInstanceDynamic*    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UMaterialInstanceDynamic* UPrimitiveComponent::CreateAndSetMaterialInstanceDynamic(int32 ElementIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "CreateAndSetMaterialInstanceDynamic");

	Params::UPrimitiveComponent_CreateAndSetMaterialInstanceDynamic_Params Parms{};

	Parms.ElementIndex = ElementIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.CopyArrayOfMoveIgnoreComponents
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// TArray<class UPrimitiveComponent*> ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, ContainsInstancedReference, NativeAccessSpecifierPublic)

TArray<class UPrimitiveComponent*> UPrimitiveComponent::CopyArrayOfMoveIgnoreComponents()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "CopyArrayOfMoveIgnoreComponents");

	Params::UPrimitiveComponent_CopyArrayOfMoveIgnoreComponents_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.CopyArrayOfMoveIgnoreActors
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// TArray<class AActor*>              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NativeAccessSpecifierPublic)

TArray<class AActor*> UPrimitiveComponent::CopyArrayOfMoveIgnoreActors()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "CopyArrayOfMoveIgnoreActors");

	Params::UPrimitiveComponent_CopyArrayOfMoveIgnoreActors_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.ClearMoveIgnoreComponents
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void UPrimitiveComponent::ClearMoveIgnoreComponents()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "ClearMoveIgnoreComponents");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.ClearMoveIgnoreActors
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void UPrimitiveComponent::ClearMoveIgnoreActors()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "ClearMoveIgnoreActors");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.CanCharacterStepUp
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class APawn*                       Pawn                                                             (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UPrimitiveComponent::CanCharacterStepUp(class APawn* Pawn)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "CanCharacterStepUp");

	Params::UPrimitiveComponent_CanCharacterStepUp_Params Parms{};

	Parms.Pawn = Pawn;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PrimitiveComponent.AddVelocityChangeImpulseAtLocation
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Impulse                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Location                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddVelocityChangeImpulseAtLocation(const struct FVector& Impulse, const struct FVector& Location, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddVelocityChangeImpulseAtLocation");

	Params::UPrimitiveComponent_AddVelocityChangeImpulseAtLocation_Params Parms{};

	Parms.Impulse = Impulse;
	Parms.Location = Location;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddTorqueInRadians
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Torque                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAccelChange                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddTorqueInRadians(const struct FVector& Torque, class FName BoneName, bool bAccelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddTorqueInRadians");

	Params::UPrimitiveComponent_AddTorqueInRadians_Params Parms{};

	Parms.Torque = Torque;
	Parms.BoneName = BoneName;
	Parms.bAccelChange = bAccelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddTorqueInDegrees
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Torque                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAccelChange                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddTorqueInDegrees(const struct FVector& Torque, class FName BoneName, bool bAccelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddTorqueInDegrees");

	Params::UPrimitiveComponent_AddTorqueInDegrees_Params Parms{};

	Parms.Torque = Torque;
	Parms.BoneName = BoneName;
	Parms.bAccelChange = bAccelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddRadialImpulse
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Origin                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Radius                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Strength                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ERadialImpulseFalloff   Falloff                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bVelChange                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddRadialImpulse(const struct FVector& Origin, float Radius, float Strength, enum class ERadialImpulseFalloff Falloff, bool bVelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddRadialImpulse");

	Params::UPrimitiveComponent_AddRadialImpulse_Params Parms{};

	Parms.Origin = Origin;
	Parms.Radius = Radius;
	Parms.Strength = Strength;
	Parms.Falloff = Falloff;
	Parms.bVelChange = bVelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddRadialForce
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Origin                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Radius                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Strength                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ERadialImpulseFalloff   Falloff                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAccelChange                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddRadialForce(const struct FVector& Origin, float Radius, float Strength, enum class ERadialImpulseFalloff Falloff, bool bAccelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddRadialForce");

	Params::UPrimitiveComponent_AddRadialForce_Params Parms{};

	Parms.Origin = Origin;
	Parms.Radius = Radius;
	Parms.Strength = Strength;
	Parms.Falloff = Falloff;
	Parms.bAccelChange = bAccelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddImpulseAtLocation
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Impulse                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Location                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddImpulseAtLocation(const struct FVector& Impulse, const struct FVector& Location, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddImpulseAtLocation");

	Params::UPrimitiveComponent_AddImpulseAtLocation_Params Parms{};

	Parms.Impulse = Impulse;
	Parms.Location = Location;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddImpulse
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Impulse                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bVelChange                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddImpulse(const struct FVector& Impulse, class FName BoneName, bool bVelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddImpulse");

	Params::UPrimitiveComponent_AddImpulse_Params Parms{};

	Parms.Impulse = Impulse;
	Parms.BoneName = BoneName;
	Parms.bVelChange = bVelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddForceAtLocationLocal
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Force                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Location                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddForceAtLocationLocal(const struct FVector& Force, const struct FVector& Location, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddForceAtLocationLocal");

	Params::UPrimitiveComponent_AddForceAtLocationLocal_Params Parms{};

	Parms.Force = Force;
	Parms.Location = Location;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddForceAtLocation
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Force                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Location                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddForceAtLocation(const struct FVector& Force, const struct FVector& Location, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddForceAtLocation");

	Params::UPrimitiveComponent_AddForceAtLocation_Params Parms{};

	Parms.Force = Force;
	Parms.Location = Location;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddForce
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Force                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAccelChange                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddForce(const struct FVector& Force, class FName BoneName, bool bAccelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddForce");

	Params::UPrimitiveComponent_AddForce_Params Parms{};

	Parms.Force = Force;
	Parms.BoneName = BoneName;
	Parms.bAccelChange = bAccelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddAngularImpulseInRadians
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Impulse                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bVelChange                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddAngularImpulseInRadians(const struct FVector& Impulse, class FName BoneName, bool bVelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddAngularImpulseInRadians");

	Params::UPrimitiveComponent_AddAngularImpulseInRadians_Params Parms{};

	Parms.Impulse = Impulse;
	Parms.BoneName = BoneName;
	Parms.bVelChange = bVelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PrimitiveComponent.AddAngularImpulseInDegrees
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Impulse                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bVelChange                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UPrimitiveComponent::AddAngularImpulseInDegrees(const struct FVector& Impulse, class FName BoneName, bool bVelChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PrimitiveComponent", "AddAngularImpulseInDegrees");

	Params::UPrimitiveComponent_AddAngularImpulseInDegrees_Params Parms{};

	Parms.Impulse = Impulse;
	Parms.BoneName = BoneName;
	Parms.bVelChange = bVelChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.BlueprintFunctionLibrary
// (None)

class UClass* UBlueprintFunctionLibrary::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("BlueprintFunctionLibrary");

	return Clss;
}


// BlueprintFunctionLibrary Engine.Default__BlueprintFunctionLibrary
// (Public, ClassDefaultObject, ArchetypeObject)

class UBlueprintFunctionLibrary* UBlueprintFunctionLibrary::GetDefaultObj()
{
	static class UBlueprintFunctionLibrary* Default = nullptr;

	if (!Default)
		Default = static_cast<UBlueprintFunctionLibrary*>(UBlueprintFunctionLibrary::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.ShapeComponent
// (SceneComponent, PrimitiveComponent)

class UClass* UShapeComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("ShapeComponent");

	return Clss;
}


// ShapeComponent Engine.Default__ShapeComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class UShapeComponent* UShapeComponent::GetDefaultObj()
{
	static class UShapeComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<UShapeComponent*>(UShapeComponent::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.BoxComponent
// (SceneComponent, PrimitiveComponent)

class UClass* UBoxComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("BoxComponent");

	return Clss;
}


// BoxComponent Engine.Default__BoxComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class UBoxComponent* UBoxComponent::GetDefaultObj()
{
	static class UBoxComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<UBoxComponent*>(UBoxComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.BoxComponent.SetLineThickness
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              Thickness                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UBoxComponent::SetLineThickness(float Thickness)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("BoxComponent", "SetLineThickness");

	Params::UBoxComponent_SetLineThickness_Params Parms{};

	Parms.Thickness = Thickness;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.BoxComponent.SetBoxExtent
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     InBoxExtent                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateOverlaps                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UBoxComponent::SetBoxExtent(const struct FVector& InBoxExtent, bool bUpdateOverlaps)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("BoxComponent", "SetBoxExtent");

	Params::UBoxComponent_SetBoxExtent_Params Parms{};

	Parms.InBoxExtent = InBoxExtent;
	Parms.bUpdateOverlaps = bUpdateOverlaps;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.BoxComponent.GetUnscaledBoxExtent
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UBoxComponent::GetUnscaledBoxExtent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("BoxComponent", "GetUnscaledBoxExtent");

	Params::UBoxComponent_GetUnscaledBoxExtent_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.BoxComponent.GetScaledBoxExtent
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector UBoxComponent::GetScaledBoxExtent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("BoxComponent", "GetScaledBoxExtent");

	Params::UBoxComponent_GetScaledBoxExtent_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.Brush
// (Actor)

class UClass* ABrush::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Brush");

	return Clss;
}


// Brush Engine.Default__Brush
// (Public, ClassDefaultObject, ArchetypeObject)

class ABrush* ABrush::GetDefaultObj()
{
	static class ABrush* Default = nullptr;

	if (!Default)
		Default = static_cast<ABrush*>(ABrush::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.Volume
// (Actor)

class UClass* AVolume::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Volume");

	return Clss;
}


// Volume Engine.Default__Volume
// (Public, ClassDefaultObject, ArchetypeObject)

class AVolume* AVolume::GetDefaultObj()
{
	static class AVolume* Default = nullptr;

	if (!Default)
		Default = static_cast<AVolume*>(AVolume::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.PhysicsVolume
// (Actor)

class UClass* APhysicsVolume::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("PhysicsVolume");

	return Clss;
}


// PhysicsVolume Engine.Default__PhysicsVolume
// (Public, ClassDefaultObject, ArchetypeObject)

class APhysicsVolume* APhysicsVolume::GetDefaultObj()
{
	static class APhysicsVolume* Default = nullptr;

	if (!Default)
		Default = static_cast<APhysicsVolume*>(APhysicsVolume::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.HLODBuilder
// (None)

class UClass* UHLODBuilder::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("HLODBuilder");

	return Clss;
}


// HLODBuilder Engine.Default__HLODBuilder
// (Public, ClassDefaultObject, ArchetypeObject)

class UHLODBuilder* UHLODBuilder::GetDefaultObj()
{
	static class UHLODBuilder* Default = nullptr;

	if (!Default)
		Default = static_cast<UHLODBuilder*>(UHLODBuilder::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.MeshComponent
// (SceneComponent, PrimitiveComponent)

class UClass* UMeshComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("MeshComponent");

	return Clss;
}


// MeshComponent Engine.Default__MeshComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class UMeshComponent* UMeshComponent::GetDefaultObj()
{
	static class UMeshComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<UMeshComponent*>(UMeshComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.MeshComponent.SetVectorParameterValueOnMaterials
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ParameterValue                                                   (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UMeshComponent::SetVectorParameterValueOnMaterials(class FName ParameterName, const struct FVector& ParameterValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "SetVectorParameterValueOnMaterials");

	Params::UMeshComponent_SetVectorParameterValueOnMaterials_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.ParameterValue = ParameterValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.MeshComponent.SetScalarParameterValueOnMaterials
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ParameterValue                                                   (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UMeshComponent::SetScalarParameterValueOnMaterials(class FName ParameterName, float ParameterValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "SetScalarParameterValueOnMaterials");

	Params::UMeshComponent_SetScalarParameterValueOnMaterials_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.ParameterValue = ParameterValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.MeshComponent.SetOverlayMaterialMaxDrawDistance
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              InMaxDrawDistance                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UMeshComponent::SetOverlayMaterialMaxDrawDistance(float InMaxDrawDistance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "SetOverlayMaterialMaxDrawDistance");

	Params::UMeshComponent_SetOverlayMaterialMaxDrawDistance_Params Parms{};

	Parms.InMaxDrawDistance = InMaxDrawDistance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.MeshComponent.SetOverlayMaterial
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UMaterialInterface*          NewOverlayMaterial                                               (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UMeshComponent::SetOverlayMaterial(class UMaterialInterface* NewOverlayMaterial)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "SetOverlayMaterial");

	Params::UMeshComponent_SetOverlayMaterial_Params Parms{};

	Parms.NewOverlayMaterial = NewOverlayMaterial;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.MeshComponent.PrestreamTextures
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Seconds                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPrioritizeCharacterTextures                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              CinematicTextureGroups                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UMeshComponent::PrestreamTextures(float Seconds, bool bPrioritizeCharacterTextures, int32 CinematicTextureGroups)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "PrestreamTextures");

	Params::UMeshComponent_PrestreamTextures_Params Parms{};

	Parms.Seconds = Seconds;
	Parms.bPrioritizeCharacterTextures = bPrioritizeCharacterTextures;
	Parms.CinematicTextureGroups = CinematicTextureGroups;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.MeshComponent.IsMaterialSlotNameValid
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        MaterialSlotName                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UMeshComponent::IsMaterialSlotNameValid(class FName MaterialSlotName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "IsMaterialSlotNameValid");

	Params::UMeshComponent_IsMaterialSlotNameValid_Params Parms{};

	Parms.MaterialSlotName = MaterialSlotName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.MeshComponent.GetOverlayMaterial
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UMaterialInterface*          ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UMaterialInterface* UMeshComponent::GetOverlayMaterial()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "GetOverlayMaterial");

	Params::UMeshComponent_GetOverlayMaterial_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.MeshComponent.GetMaterialSlotNames
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class FName>                ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NativeAccessSpecifierPublic)

TArray<class FName> UMeshComponent::GetMaterialSlotNames()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "GetMaterialSlotNames");

	Params::UMeshComponent_GetMaterialSlotNames_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.MeshComponent.GetMaterials
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class UMaterialInterface*>  ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NativeAccessSpecifierPublic)

TArray<class UMaterialInterface*> UMeshComponent::GetMaterials()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "GetMaterials");

	Params::UMeshComponent_GetMaterials_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.MeshComponent.GetMaterialIndex
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        MaterialSlotName                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 UMeshComponent::GetMaterialIndex(class FName MaterialSlotName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("MeshComponent", "GetMaterialIndex");

	Params::UMeshComponent_GetMaterialIndex_Params Parms{};

	Parms.MaterialSlotName = MaterialSlotName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.SplineComponent
// (SceneComponent, PrimitiveComponent)

class UClass* USplineComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("SplineComponent");

	return Clss;
}


// SplineComponent Engine.Default__SplineComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class USplineComponent* USplineComponent::GetDefaultObj()
{
	static class USplineComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<USplineComponent*>(USplineComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.SplineComponent.UpdateSpline
// (Native, Public, BlueprintCallable)
// Parameters:

void USplineComponent::UpdateSpline()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "UpdateSpline");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetWorldLocationAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InLocation                                                       (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetWorldLocationAtSplinePoint(int32 PointIndex, struct FVector& InLocation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetWorldLocationAtSplinePoint");

	Params::USplineComponent_SetWorldLocationAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.InLocation = InLocation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetUpVectorAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InUpVector                                                       (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetUpVectorAtSplinePoint(int32 PointIndex, struct FVector& InUpVector, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetUpVectorAtSplinePoint");

	Params::USplineComponent_SetUpVectorAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.InUpVector = InUpVector;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetUnselectedSplineSegmentColor
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FLinearColor                SegmentColor                                                     (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetUnselectedSplineSegmentColor(struct FLinearColor& SegmentColor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetUnselectedSplineSegmentColor");

	Params::USplineComponent_SetUnselectedSplineSegmentColor_Params Parms{};

	Parms.SegmentColor = SegmentColor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetTangentsAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InArriveTangent                                                  (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InLeaveTangent                                                   (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetTangentsAtSplinePoint(int32 PointIndex, struct FVector& InArriveTangent, struct FVector& InLeaveTangent, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetTangentsAtSplinePoint");

	Params::USplineComponent_SetTangentsAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.InArriveTangent = InArriveTangent;
	Parms.InLeaveTangent = InLeaveTangent;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetTangentColor
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FLinearColor                TangentColor                                                     (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetTangentColor(struct FLinearColor& TangentColor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetTangentColor");

	Params::USplineComponent_SetTangentColor_Params Parms{};

	Parms.TangentColor = TangentColor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetTangentAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InTangent                                                        (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetTangentAtSplinePoint(int32 PointIndex, struct FVector& InTangent, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetTangentAtSplinePoint");

	Params::USplineComponent_SetTangentAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.InTangent = InTangent;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetSplineWorldPoints
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<struct FVector>             Points                                                           (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void USplineComponent::SetSplineWorldPoints(TArray<struct FVector>& Points)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetSplineWorldPoints");

	Params::USplineComponent_SetSplineWorldPoints_Params Parms{};

	Parms.Points = Points;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetSplinePointType
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplinePointType        Type                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetSplinePointType(int32 PointIndex, enum class ESplinePointType Type, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetSplinePointType");

	Params::USplineComponent_SetSplinePointType_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.Type = Type;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetSplinePoints
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<struct FVector>             Points                                                           (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetSplinePoints(TArray<struct FVector>& Points, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetSplinePoints");

	Params::USplineComponent_SetSplinePoints_Params Parms{};

	Parms.Points = Points;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetSplineLocalPoints
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<struct FVector>             Points                                                           (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void USplineComponent::SetSplineLocalPoints(TArray<struct FVector>& Points)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetSplineLocalPoints");

	Params::USplineComponent_SetSplineLocalPoints_Params Parms{};

	Parms.Points = Points;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetSelectedSplineSegmentColor
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FLinearColor                SegmentColor                                                     (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetSelectedSplineSegmentColor(struct FLinearColor& SegmentColor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetSelectedSplineSegmentColor");

	Params::USplineComponent_SetSelectedSplineSegmentColor_Params Parms{};

	Parms.SegmentColor = SegmentColor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetScaleAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InScaleVector                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetScaleAtSplinePoint(int32 PointIndex, struct FVector& InScaleVector, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetScaleAtSplinePoint");

	Params::USplineComponent_SetScaleAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.InScaleVector = InScaleVector;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetRotationAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    InRotation                                                       (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetRotationAtSplinePoint(int32 PointIndex, struct FRotator& InRotation, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetRotationAtSplinePoint");

	Params::USplineComponent_SetRotationAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.InRotation = InRotation;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetLocationAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InLocation                                                       (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetLocationAtSplinePoint(int32 PointIndex, struct FVector& InLocation, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetLocationAtSplinePoint");

	Params::USplineComponent_SetLocationAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.InLocation = InLocation;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetDrawDebug
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bShow                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetDrawDebug(bool bShow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetDrawDebug");

	Params::USplineComponent_SetDrawDebug_Params Parms{};

	Parms.bShow = bShow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetDefaultUpVector
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     UpVector                                                         (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetDefaultUpVector(struct FVector& UpVector, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetDefaultUpVector");

	Params::USplineComponent_SetDefaultUpVector_Params Parms{};

	Parms.UpVector = UpVector;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetClosedLoopAtPosition
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInClosedLoop                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Key                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetClosedLoopAtPosition(bool bInClosedLoop, float Key, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetClosedLoopAtPosition");

	Params::USplineComponent_SetClosedLoopAtPosition_Params Parms{};

	Parms.bInClosedLoop = bInClosedLoop;
	Parms.Key = Key;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.SetClosedLoop
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInClosedLoop                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::SetClosedLoop(bool bInClosedLoop, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "SetClosedLoop");

	Params::USplineComponent_SetClosedLoop_Params Parms{};

	Parms.bInClosedLoop = bInClosedLoop;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.RemoveSplinePoint
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              Index                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::RemoveSplinePoint(int32 Index, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "RemoveSplinePoint");

	Params::USplineComponent_RemoveSplinePoint_Params Parms{};

	Parms.Index = Index;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.IsClosedLoop
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USplineComponent::IsClosedLoop()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "IsClosedLoop");

	Params::USplineComponent_IsClosedLoop_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldTangentAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetWorldTangentAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldTangentAtDistanceAlongSpline");

	Params::USplineComponent_GetWorldTangentAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldRotationAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USplineComponent::GetWorldRotationAtTime(float Time, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldRotationAtTime");

	Params::USplineComponent_GetWorldRotationAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldRotationAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USplineComponent::GetWorldRotationAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldRotationAtDistanceAlongSpline");

	Params::USplineComponent_GetWorldRotationAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldLocationAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetWorldLocationAtTime(float Time, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldLocationAtTime");

	Params::USplineComponent_GetWorldLocationAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldLocationAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetWorldLocationAtSplinePoint(int32 PointIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldLocationAtSplinePoint");

	Params::USplineComponent_GetWorldLocationAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldLocationAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetWorldLocationAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldLocationAtDistanceAlongSpline");

	Params::USplineComponent_GetWorldLocationAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldDirectionAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetWorldDirectionAtTime(float Time, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldDirectionAtTime");

	Params::USplineComponent_GetWorldDirectionAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetWorldDirectionAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetWorldDirectionAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetWorldDirectionAtDistanceAlongSpline");

	Params::USplineComponent_GetWorldDirectionAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetVectorPropertyAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              Index                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        PropertyName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetVectorPropertyAtSplinePoint(int32 Index, class FName PropertyName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetVectorPropertyAtSplinePoint");

	Params::USplineComponent_GetVectorPropertyAtSplinePoint_Params Parms{};

	Parms.Index = Index;
	Parms.PropertyName = PropertyName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetVectorPropertyAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        PropertyName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetVectorPropertyAtSplineInputKey(float InKey, class FName PropertyName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetVectorPropertyAtSplineInputKey");

	Params::USplineComponent_GetVectorPropertyAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.PropertyName = PropertyName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetUpVectorAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetUpVectorAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetUpVectorAtTime");

	Params::USplineComponent_GetUpVectorAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetUpVectorAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetUpVectorAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetUpVectorAtSplinePoint");

	Params::USplineComponent_GetUpVectorAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetUpVectorAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetUpVectorAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetUpVectorAtSplineInputKey");

	Params::USplineComponent_GetUpVectorAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetUpVectorAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetUpVectorAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetUpVectorAtDistanceAlongSpline");

	Params::USplineComponent_GetUpVectorAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTransformAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseScale                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USplineComponent::GetTransformAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity, bool bUseScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTransformAtTime");

	Params::USplineComponent_GetTransformAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;
	Parms.bUseScale = bUseScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTransformAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseScale                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USplineComponent::GetTransformAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTransformAtSplinePoint");

	Params::USplineComponent_GetTransformAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseScale = bUseScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTransformAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseScale                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USplineComponent::GetTransformAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTransformAtSplineInputKey");

	Params::USplineComponent_GetTransformAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseScale = bUseScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTransformAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseScale                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USplineComponent::GetTransformAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTransformAtDistanceAlongSpline");

	Params::USplineComponent_GetTransformAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseScale = bUseScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTimeAtDistanceAlongSpline
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetTimeAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTimeAtDistanceAlongSpline");

	Params::USplineComponent_GetTimeAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTangentAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetTangentAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTangentAtTime");

	Params::USplineComponent_GetTangentAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTangentAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetTangentAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTangentAtSplinePoint");

	Params::USplineComponent_GetTangentAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTangentAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetTangentAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTangentAtSplineInputKey");

	Params::USplineComponent_GetTangentAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetTangentAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetTangentAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetTangentAtDistanceAlongSpline");

	Params::USplineComponent_GetTangentAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetSplinePointType
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplinePointType        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class ESplinePointType USplineComponent::GetSplinePointType(int32 PointIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetSplinePointType");

	Params::USplineComponent_GetSplinePointType_Params Parms{};

	Parms.PointIndex = PointIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetSplineLength
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetSplineLength()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetSplineLength");

	Params::USplineComponent_GetSplineLength_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetScaleAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetScaleAtTime(float Time, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetScaleAtTime");

	Params::USplineComponent_GetScaleAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetScaleAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetScaleAtSplinePoint(int32 PointIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetScaleAtSplinePoint");

	Params::USplineComponent_GetScaleAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetScaleAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetScaleAtSplineInputKey(float InKey)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetScaleAtSplineInputKey");

	Params::USplineComponent_GetScaleAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetScaleAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetScaleAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetScaleAtDistanceAlongSpline");

	Params::USplineComponent_GetScaleAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRotationAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USplineComponent::GetRotationAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRotationAtTime");

	Params::USplineComponent_GetRotationAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRotationAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USplineComponent::GetRotationAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRotationAtSplinePoint");

	Params::USplineComponent_GetRotationAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRotationAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USplineComponent::GetRotationAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRotationAtSplineInputKey");

	Params::USplineComponent_GetRotationAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRotationAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USplineComponent::GetRotationAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRotationAtDistanceAlongSpline");

	Params::USplineComponent_GetRotationAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRollAtTime
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetRollAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRollAtTime");

	Params::USplineComponent_GetRollAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRollAtSplinePoint
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetRollAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRollAtSplinePoint");

	Params::USplineComponent_GetRollAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRollAtSplineInputKey
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetRollAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRollAtSplineInputKey");

	Params::USplineComponent_GetRollAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRollAtDistanceAlongSpline
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetRollAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRollAtDistanceAlongSpline");

	Params::USplineComponent_GetRollAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRightVectorAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetRightVectorAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRightVectorAtTime");

	Params::USplineComponent_GetRightVectorAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRightVectorAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetRightVectorAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRightVectorAtSplinePoint");

	Params::USplineComponent_GetRightVectorAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRightVectorAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetRightVectorAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRightVectorAtSplineInputKey");

	Params::USplineComponent_GetRightVectorAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetRightVectorAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetRightVectorAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetRightVectorAtDistanceAlongSpline");

	Params::USplineComponent_GetRightVectorAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetNumberOfSplineSegments
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USplineComponent::GetNumberOfSplineSegments()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetNumberOfSplineSegments");

	Params::USplineComponent_GetNumberOfSplineSegments_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetNumberOfSplinePoints
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USplineComponent::GetNumberOfSplinePoints()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetNumberOfSplinePoints");

	Params::USplineComponent_GetNumberOfSplinePoints_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetLocationAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetLocationAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetLocationAtTime");

	Params::USplineComponent_GetLocationAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetLocationAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetLocationAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetLocationAtSplinePoint");

	Params::USplineComponent_GetLocationAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetLocationAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetLocationAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetLocationAtSplineInputKey");

	Params::USplineComponent_GetLocationAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetLocationAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetLocationAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetLocationAtDistanceAlongSpline");

	Params::USplineComponent_GetLocationAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetLocationAndTangentAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Location                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Tangent                                                          (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::GetLocationAndTangentAtSplinePoint(int32 PointIndex, struct FVector* Location, struct FVector* Tangent, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetLocationAndTangentAtSplinePoint");

	Params::USplineComponent_GetLocationAndTangentAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (Location != nullptr)
		*Location = std::move(Parms.Location);

	if (Tangent != nullptr)
		*Tangent = std::move(Parms.Tangent);

}


// Function Engine.SplineComponent.GetLocalLocationAndTangentAtSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     LocalLocation                                                    (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     LocalTangent                                                     (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::GetLocalLocationAndTangentAtSplinePoint(int32 PointIndex, struct FVector* LocalLocation, struct FVector* LocalTangent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetLocalLocationAndTangentAtSplinePoint");

	Params::USplineComponent_GetLocalLocationAndTangentAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (LocalLocation != nullptr)
		*LocalLocation = std::move(Parms.LocalLocation);

	if (LocalTangent != nullptr)
		*LocalTangent = std::move(Parms.LocalTangent);

}


// Function Engine.SplineComponent.GetLeaveTangentAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetLeaveTangentAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetLeaveTangentAtSplinePoint");

	Params::USplineComponent_GetLeaveTangentAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetInputKeyValueAtDistanceAlongSpline
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetInputKeyValueAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetInputKeyValueAtDistanceAlongSpline");

	Params::USplineComponent_GetInputKeyValueAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetInputKeyAtDistanceAlongSpline
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetInputKeyAtDistanceAlongSpline(float Distance)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetInputKeyAtDistanceAlongSpline");

	Params::USplineComponent_GetInputKeyAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetFloatPropertyAtSplinePoint
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              Index                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        PropertyName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetFloatPropertyAtSplinePoint(int32 Index, class FName PropertyName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetFloatPropertyAtSplinePoint");

	Params::USplineComponent_GetFloatPropertyAtSplinePoint_Params Parms{};

	Parms.Index = Index;
	Parms.PropertyName = PropertyName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetFloatPropertyAtSplineInputKey
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        PropertyName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetFloatPropertyAtSplineInputKey(float InKey, class FName PropertyName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetFloatPropertyAtSplineInputKey");

	Params::USplineComponent_GetFloatPropertyAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.PropertyName = PropertyName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetDistanceAlongSplineAtSplinePoint
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetDistanceAlongSplineAtSplinePoint(int32 PointIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetDistanceAlongSplineAtSplinePoint");

	Params::USplineComponent_GetDistanceAlongSplineAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetDistanceAlongSplineAtSplineInputKey
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::GetDistanceAlongSplineAtSplineInputKey(float InKey)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetDistanceAlongSplineAtSplineInputKey");

	Params::USplineComponent_GetDistanceAlongSplineAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetDirectionAtTime
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Time                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseConstantVelocity                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetDirectionAtTime(float Time, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseConstantVelocity)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetDirectionAtTime");

	Params::USplineComponent_GetDirectionAtTime_Params Parms{};

	Parms.Time = Time;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseConstantVelocity = bUseConstantVelocity;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetDirectionAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetDirectionAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetDirectionAtSplinePoint");

	Params::USplineComponent_GetDirectionAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetDirectionAtSplineInputKey
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              InKey                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetDirectionAtSplineInputKey(float InKey, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetDirectionAtSplineInputKey");

	Params::USplineComponent_GetDirectionAtSplineInputKey_Params Parms{};

	Parms.InKey = InKey;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetDirectionAtDistanceAlongSpline
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              Distance                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetDirectionAtDistanceAlongSpline(float Distance, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetDirectionAtDistanceAlongSpline");

	Params::USplineComponent_GetDirectionAtDistanceAlongSpline_Params Parms{};

	Parms.Distance = Distance;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetDefaultUpVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetDefaultUpVector(enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetDefaultUpVector");

	Params::USplineComponent_GetDefaultUpVector_Params Parms{};

	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.GetArriveTangentAtSplinePoint
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              PointIndex                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::GetArriveTangentAtSplinePoint(int32 PointIndex, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "GetArriveTangentAtSplinePoint");

	Params::USplineComponent_GetArriveTangentAtSplinePoint_Params Parms{};

	Parms.PointIndex = PointIndex;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindUpVectorClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::FindUpVectorClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindUpVectorClosestToWorldLocation");

	Params::USplineComponent_FindUpVectorClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindTransformClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseScale                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USplineComponent::FindTransformClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace, bool bUseScale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindTransformClosestToWorldLocation");

	Params::USplineComponent_FindTransformClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUseScale = bUseScale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindTangentClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::FindTangentClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindTangentClosestToWorldLocation");

	Params::USplineComponent_FindTangentClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindScaleClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::FindScaleClosestToWorldLocation(struct FVector& WorldLocation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindScaleClosestToWorldLocation");

	Params::USplineComponent_FindScaleClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindRotationClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator USplineComponent::FindRotationClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindRotationClosestToWorldLocation");

	Params::USplineComponent_FindRotationClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindRollClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::FindRollClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindRollClosestToWorldLocation");

	Params::USplineComponent_FindRollClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindRightVectorClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::FindRightVectorClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindRightVectorClosestToWorldLocation");

	Params::USplineComponent_FindRightVectorClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindLocationClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::FindLocationClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindLocationClosestToWorldLocation");

	Params::USplineComponent_FindLocationClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindInputKeyClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float USplineComponent::FindInputKeyClosestToWorldLocation(struct FVector& WorldLocation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindInputKeyClosestToWorldLocation");

	Params::USplineComponent_FindInputKeyClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.FindDirectionClosestToWorldLocation
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USplineComponent::FindDirectionClosestToWorldLocation(struct FVector& WorldLocation, enum class ESplineCoordinateSpace CoordinateSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "FindDirectionClosestToWorldLocation");

	Params::USplineComponent_FindDirectionClosestToWorldLocation_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.CoordinateSpace = CoordinateSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.DivideSplineIntoPolylineRecursiveWithDistances
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              StartDistanceAlongSpline                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              EndDistanceAlongSpline                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MaxSquareDistanceFromSpline                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FVector>             OutPoints                                                        (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// TArray<double>                     OutDistancesAlongSpline                                          (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USplineComponent::DivideSplineIntoPolylineRecursiveWithDistances(float StartDistanceAlongSpline, float EndDistanceAlongSpline, enum class ESplineCoordinateSpace CoordinateSpace, float MaxSquareDistanceFromSpline, TArray<struct FVector>* OutPoints, TArray<double>* OutDistancesAlongSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "DivideSplineIntoPolylineRecursiveWithDistances");

	Params::USplineComponent_DivideSplineIntoPolylineRecursiveWithDistances_Params Parms{};

	Parms.StartDistanceAlongSpline = StartDistanceAlongSpline;
	Parms.EndDistanceAlongSpline = EndDistanceAlongSpline;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.MaxSquareDistanceFromSpline = MaxSquareDistanceFromSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutPoints != nullptr)
		*OutPoints = std::move(Parms.OutPoints);

	if (OutDistancesAlongSpline != nullptr)
		*OutDistancesAlongSpline = std::move(Parms.OutDistancesAlongSpline);

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.DivideSplineIntoPolylineRecursive
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              StartDistanceAlongSpline                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              EndDistanceAlongSpline                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MaxSquareDistanceFromSpline                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FVector>             OutPoints                                                        (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USplineComponent::DivideSplineIntoPolylineRecursive(float StartDistanceAlongSpline, float EndDistanceAlongSpline, enum class ESplineCoordinateSpace CoordinateSpace, float MaxSquareDistanceFromSpline, TArray<struct FVector>* OutPoints)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "DivideSplineIntoPolylineRecursive");

	Params::USplineComponent_DivideSplineIntoPolylineRecursive_Params Parms{};

	Parms.StartDistanceAlongSpline = StartDistanceAlongSpline;
	Parms.EndDistanceAlongSpline = EndDistanceAlongSpline;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.MaxSquareDistanceFromSpline = MaxSquareDistanceFromSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutPoints != nullptr)
		*OutPoints = std::move(Parms.OutPoints);

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.ConvertSplineToPolyLine
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MaxSquareDistanceFromSpline                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FVector>             OutPoints                                                        (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USplineComponent::ConvertSplineToPolyLine(enum class ESplineCoordinateSpace CoordinateSpace, float MaxSquareDistanceFromSpline, TArray<struct FVector>* OutPoints)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "ConvertSplineToPolyLine");

	Params::USplineComponent_ConvertSplineToPolyLine_Params Parms{};

	Parms.CoordinateSpace = CoordinateSpace;
	Parms.MaxSquareDistanceFromSpline = MaxSquareDistanceFromSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutPoints != nullptr)
		*OutPoints = std::move(Parms.OutPoints);

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.ConvertSplineSegmentToPolyLine
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              SplinePointStartIndex                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MaxSquareDistanceFromSpline                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FVector>             OutPoints                                                        (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USplineComponent::ConvertSplineSegmentToPolyLine(int32 SplinePointStartIndex, enum class ESplineCoordinateSpace CoordinateSpace, float MaxSquareDistanceFromSpline, TArray<struct FVector>* OutPoints)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "ConvertSplineSegmentToPolyLine");

	Params::USplineComponent_ConvertSplineSegmentToPolyLine_Params Parms{};

	Parms.SplinePointStartIndex = SplinePointStartIndex;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.MaxSquareDistanceFromSpline = MaxSquareDistanceFromSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutPoints != nullptr)
		*OutPoints = std::move(Parms.OutPoints);

	return Parms.ReturnValue;

}


// Function Engine.SplineComponent.ClearSplinePoints
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::ClearSplinePoints(bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "ClearSplinePoints");

	Params::USplineComponent_ClearSplinePoints_Params Parms{};

	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.AddSplineWorldPoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Position                                                         (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::AddSplineWorldPoint(struct FVector& Position)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "AddSplineWorldPoint");

	Params::USplineComponent_AddSplineWorldPoint_Params Parms{};

	Parms.Position = Position;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.AddSplinePointAtIndex
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Position                                                         (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              Index                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::AddSplinePointAtIndex(struct FVector& Position, int32 Index, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "AddSplinePointAtIndex");

	Params::USplineComponent_AddSplinePointAtIndex_Params Parms{};

	Parms.Position = Position;
	Parms.Index = Index;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.AddSplinePoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Position                                                         (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ESplineCoordinateSpace  CoordinateSpace                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::AddSplinePoint(struct FVector& Position, enum class ESplineCoordinateSpace CoordinateSpace, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "AddSplinePoint");

	Params::USplineComponent_AddSplinePoint_Params Parms{};

	Parms.Position = Position;
	Parms.CoordinateSpace = CoordinateSpace;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.AddSplineLocalPoint
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     Position                                                         (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::AddSplineLocalPoint(struct FVector& Position)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "AddSplineLocalPoint");

	Params::USplineComponent_AddSplineLocalPoint_Params Parms{};

	Parms.Position = Position;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.AddPoints
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<struct FSplinePoint>        Points                                                           (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::AddPoints(TArray<struct FSplinePoint>& Points, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "AddPoints");

	Params::USplineComponent_AddPoints_Params Parms{};

	Parms.Points = Points;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SplineComponent.AddPoint
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// struct FSplinePoint                Point                                                            (ConstParm, Parm, OutParm, ReferenceParm, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bUpdateSpline                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USplineComponent::AddPoint(struct FSplinePoint& Point, bool bUpdateSpline)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SplineComponent", "AddPoint");

	Params::USplineComponent_AddPoint_Params Parms{};

	Parms.Point = Point;
	Parms.bUpdateSpline = bUpdateSpline;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.SplineMetadata
// (None)

class UClass* USplineMetadata::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("SplineMetadata");

	return Clss;
}


// SplineMetadata Engine.Default__SplineMetadata
// (Public, ClassDefaultObject, ArchetypeObject)

class USplineMetadata* USplineMetadata::GetDefaultObj()
{
	static class USplineMetadata* Default = nullptr;

	if (!Default)
		Default = static_cast<USplineMetadata*>(USplineMetadata::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.WorldSubsystem
// (None)

class UClass* UWorldSubsystem::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("WorldSubsystem");

	return Clss;
}


// WorldSubsystem Engine.Default__WorldSubsystem
// (Public, ClassDefaultObject, ArchetypeObject)

class UWorldSubsystem* UWorldSubsystem::GetDefaultObj()
{
	static class UWorldSubsystem* Default = nullptr;

	if (!Default)
		Default = static_cast<UWorldSubsystem*>(UWorldSubsystem::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.TickableWorldSubsystem
// (None)

class UClass* UTickableWorldSubsystem::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("TickableWorldSubsystem");

	return Clss;
}


// TickableWorldSubsystem Engine.Default__TickableWorldSubsystem
// (Public, ClassDefaultObject, ArchetypeObject)

class UTickableWorldSubsystem* UTickableWorldSubsystem::GetDefaultObj()
{
	static class UTickableWorldSubsystem* Default = nullptr;

	if (!Default)
		Default = static_cast<UTickableWorldSubsystem*>(UTickableWorldSubsystem::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.FXSystemComponent
// (SceneComponent, PrimitiveComponent)

class UClass* UFXSystemComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("FXSystemComponent");

	return Clss;
}


// FXSystemComponent Engine.Default__FXSystemComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class UFXSystemComponent* UFXSystemComponent::GetDefaultObj()
{
	static class UFXSystemComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<UFXSystemComponent*>(UFXSystemComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.FXSystemComponent.SetVectorParameter
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Param                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetVectorParameter(class FName ParameterName, const struct FVector& Param)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetVectorParameter");

	Params::UFXSystemComponent_SetVectorParameter_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Param = Param;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetUseAutoManageAttachment
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bAutoManage                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetUseAutoManageAttachment(bool bAutoManage)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetUseAutoManageAttachment");

	Params::UFXSystemComponent_SetUseAutoManageAttachment_Params Parms{};

	Parms.bAutoManage = bAutoManage;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetIntParameter
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              Param                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetIntParameter(class FName ParameterName, int32 Param)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetIntParameter");

	Params::UFXSystemComponent_SetIntParameter_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Param = Param;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetFloatParameter
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Param                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetFloatParameter(class FName ParameterName, float Param)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetFloatParameter");

	Params::UFXSystemComponent_SetFloatParameter_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Param = Param;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetEmitterEnable
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        EmitterName                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNewEnableState                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetEmitterEnable(class FName EmitterName, bool bNewEnableState)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetEmitterEnable");

	Params::UFXSystemComponent_SetEmitterEnable_Params Parms{};

	Parms.EmitterName = EmitterName;
	Parms.bNewEnableState = bNewEnableState;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetColorParameter
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FLinearColor                Param                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetColorParameter(class FName ParameterName, const struct FLinearColor& Param)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetColorParameter");

	Params::UFXSystemComponent_SetColorParameter_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Param = Param;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetBoolParameter
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               Param                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetBoolParameter(class FName ParameterName, bool Param)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetBoolParameter");

	Params::UFXSystemComponent_SetBoolParameter_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Param = Param;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetAutoAttachmentParameters
// (Native, Public, BlueprintCallable)
// Parameters:
// class USceneComponent*             Parent                                                           (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        SocketName                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         LocationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         RotationRule                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EAttachmentRule         ScaleRule                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetAutoAttachmentParameters(class USceneComponent* Parent, class FName SocketName, enum class EAttachmentRule LocationRule, enum class EAttachmentRule RotationRule, enum class EAttachmentRule ScaleRule)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetAutoAttachmentParameters");

	Params::UFXSystemComponent_SetAutoAttachmentParameters_Params Parms{};

	Parms.Parent = Parent;
	Parms.SocketName = SocketName;
	Parms.LocationRule = LocationRule;
	Parms.RotationRule = RotationRule;
	Parms.ScaleRule = ScaleRule;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.SetActorParameter
// (Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParameterName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      Param                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UFXSystemComponent::SetActorParameter(class FName ParameterName, class AActor* Param)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "SetActorParameter");

	Params::UFXSystemComponent_SetActorParameter_Params Parms{};

	Parms.ParameterName = ParameterName;
	Parms.Param = Param;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.ReleaseToPool
// (Native, Public, BlueprintCallable)
// Parameters:

void UFXSystemComponent::ReleaseToPool()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "ReleaseToPool");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.FXSystemComponent.GetFXSystemAsset
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UFXSystemAsset*              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UFXSystemAsset* UFXSystemComponent::GetFXSystemAsset()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("FXSystemComponent", "GetFXSystemAsset");

	Params::UFXSystemComponent_GetFXSystemAsset_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.BlueprintAsyncActionBase
// (None)

class UClass* UBlueprintAsyncActionBase::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("BlueprintAsyncActionBase");

	return Clss;
}


// BlueprintAsyncActionBase Engine.Default__BlueprintAsyncActionBase
// (Public, ClassDefaultObject, ArchetypeObject)

class UBlueprintAsyncActionBase* UBlueprintAsyncActionBase::GetDefaultObj()
{
	static class UBlueprintAsyncActionBase* Default = nullptr;

	if (!Default)
		Default = static_cast<UBlueprintAsyncActionBase*>(UBlueprintAsyncActionBase::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.BlueprintAsyncActionBase.Activate
// (Native, Public, BlueprintCallable)
// Parameters:

void UBlueprintAsyncActionBase::Activate()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("BlueprintAsyncActionBase", "Activate");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Class Engine.FXSystemAsset
// (None)

class UClass* UFXSystemAsset::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("FXSystemAsset");

	return Clss;
}


// FXSystemAsset Engine.Default__FXSystemAsset
// (Public, ClassDefaultObject, ArchetypeObject)

class UFXSystemAsset* UFXSystemAsset::GetDefaultObj()
{
	static class UFXSystemAsset* Default = nullptr;

	if (!Default)
		Default = static_cast<UFXSystemAsset*>(UFXSystemAsset::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.AnimNotifyState
// (None)

class UClass* UAnimNotifyState::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("AnimNotifyState");

	return Clss;
}


// AnimNotifyState Engine.Default__AnimNotifyState
// (Public, ClassDefaultObject, ArchetypeObject)

class UAnimNotifyState* UAnimNotifyState::GetDefaultObj()
{
	static class UAnimNotifyState* Default = nullptr;

	if (!Default)
		Default = static_cast<UAnimNotifyState*>(UAnimNotifyState::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.AnimNotifyState.Received_NotifyTick
// (Event, Public, HasOutParams, BlueprintEvent, Const)
// Parameters:
// class USkeletalMeshComponent*      MeshComp                                                         (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UAnimSequenceBase*           Animation                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              FrameDeltaTime                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FAnimNotifyEventReference   EventReference                                                   (ConstParm, Parm, OutParm, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UAnimNotifyState::Received_NotifyTick(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, float FrameDeltaTime, struct FAnimNotifyEventReference& EventReference)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotifyState", "Received_NotifyTick");

	Params::UAnimNotifyState_Received_NotifyTick_Params Parms{};

	Parms.MeshComp = MeshComp;
	Parms.Animation = Animation;
	Parms.FrameDeltaTime = FrameDeltaTime;
	Parms.EventReference = EventReference;

	UObject::ProcessEvent(Func, &Parms);

	return Parms.ReturnValue;

}


// Function Engine.AnimNotifyState.Received_NotifyEnd
// (Event, Public, HasOutParams, BlueprintEvent, Const)
// Parameters:
// class USkeletalMeshComponent*      MeshComp                                                         (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UAnimSequenceBase*           Animation                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FAnimNotifyEventReference   EventReference                                                   (ConstParm, Parm, OutParm, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UAnimNotifyState::Received_NotifyEnd(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, struct FAnimNotifyEventReference& EventReference)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotifyState", "Received_NotifyEnd");

	Params::UAnimNotifyState_Received_NotifyEnd_Params Parms{};

	Parms.MeshComp = MeshComp;
	Parms.Animation = Animation;
	Parms.EventReference = EventReference;

	UObject::ProcessEvent(Func, &Parms);

	return Parms.ReturnValue;

}


// Function Engine.AnimNotifyState.Received_NotifyBegin
// (Event, Public, HasOutParams, BlueprintEvent, Const)
// Parameters:
// class USkeletalMeshComponent*      MeshComp                                                         (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UAnimSequenceBase*           Animation                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              TotalDuration                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FAnimNotifyEventReference   EventReference                                                   (ConstParm, Parm, OutParm, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UAnimNotifyState::Received_NotifyBegin(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, float TotalDuration, struct FAnimNotifyEventReference& EventReference)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotifyState", "Received_NotifyBegin");

	Params::UAnimNotifyState_Received_NotifyBegin_Params Parms{};

	Parms.MeshComp = MeshComp;
	Parms.Animation = Animation;
	Parms.TotalDuration = TotalDuration;
	Parms.EventReference = EventReference;

	UObject::ProcessEvent(Func, &Parms);

	return Parms.ReturnValue;

}


// Function Engine.AnimNotifyState.GetNotifyName
// (Native, Event, Public, BlueprintEvent, Const)
// Parameters:
// class FString                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FString UAnimNotifyState::GetNotifyName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotifyState", "GetNotifyName");

	Params::UAnimNotifyState_GetNotifyName_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.AnimNotifyState.GetDefaultTriggerWeightThreshold
// (Native, Event, Public, BlueprintEvent, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UAnimNotifyState::GetDefaultTriggerWeightThreshold()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotifyState", "GetDefaultTriggerWeightThreshold");

	Params::UAnimNotifyState_GetDefaultTriggerWeightThreshold_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.AnimNotify
// (None)

class UClass* UAnimNotify::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("AnimNotify");

	return Clss;
}


// AnimNotify Engine.Default__AnimNotify
// (Public, ClassDefaultObject, ArchetypeObject)

class UAnimNotify* UAnimNotify::GetDefaultObj()
{
	static class UAnimNotify* Default = nullptr;

	if (!Default)
		Default = static_cast<UAnimNotify*>(UAnimNotify::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.AnimNotify.Received_Notify
// (Event, Public, HasOutParams, BlueprintEvent, Const)
// Parameters:
// class USkeletalMeshComponent*      MeshComp                                                         (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UAnimSequenceBase*           Animation                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FAnimNotifyEventReference   EventReference                                                   (ConstParm, Parm, OutParm, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UAnimNotify::Received_Notify(class USkeletalMeshComponent* MeshComp, class UAnimSequenceBase* Animation, struct FAnimNotifyEventReference& EventReference)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotify", "Received_Notify");

	Params::UAnimNotify_Received_Notify_Params Parms{};

	Parms.MeshComp = MeshComp;
	Parms.Animation = Animation;
	Parms.EventReference = EventReference;

	UObject::ProcessEvent(Func, &Parms);

	return Parms.ReturnValue;

}


// Function Engine.AnimNotify.GetNotifyName
// (Native, Event, Public, BlueprintEvent, Const)
// Parameters:
// class FString                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FString UAnimNotify::GetNotifyName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotify", "GetNotifyName");

	Params::UAnimNotify_GetNotifyName_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.AnimNotify.GetDefaultTriggerWeightThreshold
// (Native, Event, Public, BlueprintEvent, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float UAnimNotify::GetDefaultTriggerWeightThreshold()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("AnimNotify", "GetDefaultTriggerWeightThreshold");

	Params::UAnimNotify_GetDefaultTriggerWeightThreshold_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.SkinnedMeshComponent
// (SceneComponent, PrimitiveComponent, SkinnedMeshComponent)

class UClass* USkinnedMeshComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("SkinnedMeshComponent");

	return Clss;
}


// SkinnedMeshComponent Engine.Default__SkinnedMeshComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class USkinnedMeshComponent* USkinnedMeshComponent::GetDefaultObj()
{
	static class USkinnedMeshComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<USkinnedMeshComponent*>(USkinnedMeshComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.SkinnedMeshComponent.UnloadSkinWeightProfile
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        InProfileName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::UnloadSkinWeightProfile(class FName InProfileName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "UnloadSkinWeightProfile");

	Params::USkinnedMeshComponent_UnloadSkinWeightProfile_Params Parms{};

	Parms.InProfileName = InProfileName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.UnHideBoneByName
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::UnHideBoneByName(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "UnHideBoneByName");

	Params::USkinnedMeshComponent_UnHideBoneByName_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.TransformToBoneSpace
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InPosition                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    InRotation                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// struct FVector                     OutPosition                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    OutRotation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::TransformToBoneSpace(class FName BoneName, const struct FVector& InPosition, const struct FRotator& InRotation, struct FVector* OutPosition, struct FRotator* OutRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "TransformToBoneSpace");

	Params::USkinnedMeshComponent_TransformToBoneSpace_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.InPosition = InPosition;
	Parms.InRotation = InRotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutPosition != nullptr)
		*OutPosition = std::move(Parms.OutPosition);

	if (OutRotation != nullptr)
		*OutRotation = std::move(Parms.OutRotation);

}


// Function Engine.SkinnedMeshComponent.TransformFromBoneSpace
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     InPosition                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    InRotation                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// struct FVector                     OutPosition                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    OutRotation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::TransformFromBoneSpace(class FName BoneName, const struct FVector& InPosition, const struct FRotator& InRotation, struct FVector* OutPosition, struct FRotator* OutRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "TransformFromBoneSpace");

	Params::USkinnedMeshComponent_TransformFromBoneSpace_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.InPosition = InPosition;
	Parms.InRotation = InRotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutPosition != nullptr)
		*OutPosition = std::move(Parms.OutPosition);

	if (OutRotation != nullptr)
		*OutRotation = std::move(Parms.OutRotation);

}


// Function Engine.SkinnedMeshComponent.ShowMaterialSection
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              MaterialID                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              SectionIndex                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bShow                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::ShowMaterialSection(int32 MaterialID, int32 SectionIndex, bool bShow, int32 LODIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "ShowMaterialSection");

	Params::USkinnedMeshComponent_ShowMaterialSection_Params Parms{};

	Parms.MaterialID = MaterialID;
	Parms.SectionIndex = SectionIndex;
	Parms.bShow = bShow;
	Parms.LODIndex = LODIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.ShowAllMaterialSections
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::ShowAllMaterialSections(int32 LODIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "ShowAllMaterialSections");

	Params::USkinnedMeshComponent_ShowAllMaterialSections_Params Parms{};

	Parms.LODIndex = LODIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetVertexOffsetUsage
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              Usage                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetVertexOffsetUsage(int32 LODIndex, int32 Usage)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetVertexOffsetUsage");

	Params::USkinnedMeshComponent_SetVertexOffsetUsage_Params Parms{};

	Parms.LODIndex = LODIndex;
	Parms.Usage = Usage;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetVertexColorOverride_LinearColor
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FLinearColor>        VertexColors                                                     (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetVertexColorOverride_LinearColor(int32 LODIndex, TArray<struct FLinearColor>& VertexColors)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetVertexColorOverride_LinearColor");

	Params::USkinnedMeshComponent_SetVertexColorOverride_LinearColor_Params Parms{};

	Parms.LODIndex = LODIndex;
	Parms.VertexColors = VertexColors;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetSkinWeightProfile
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        InProfileName                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USkinnedMeshComponent::SetSkinWeightProfile(class FName InProfileName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetSkinWeightProfile");

	Params::USkinnedMeshComponent_SetSkinWeightProfile_Params Parms{};

	Parms.InProfileName = InProfileName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.SetSkinWeightOverride
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FSkelMeshSkinWeightInfo>SkinWeights                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetSkinWeightOverride(int32 LODIndex, TArray<struct FSkelMeshSkinWeightInfo>& SkinWeights)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetSkinWeightOverride");

	Params::USkinnedMeshComponent_SetSkinWeightOverride_Params Parms{};

	Parms.LODIndex = LODIndex;
	Parms.SkinWeights = SkinWeights;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetSkinnedAssetAndUpdate
// (Native, Public, BlueprintCallable)
// Parameters:
// class USkinnedAsset*               NewMesh                                                          (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bReinitPose                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetSkinnedAssetAndUpdate(class USkinnedAsset* NewMesh, bool bReinitPose)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetSkinnedAssetAndUpdate");

	Params::USkinnedMeshComponent_SetSkinnedAssetAndUpdate_Params Parms{};

	Parms.NewMesh = NewMesh;
	Parms.bReinitPose = bReinitPose;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetRenderStatic
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewValue                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetRenderStatic(bool bNewValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetRenderStatic");

	Params::USkinnedMeshComponent_SetRenderStatic_Params Parms{};

	Parms.bNewValue = bNewValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetPreSkinningOffsets
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FVector>             Offsets                                                          (Parm, ZeroConstructor, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetPreSkinningOffsets(int32 LODIndex, const TArray<struct FVector>& Offsets)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetPreSkinningOffsets");

	Params::USkinnedMeshComponent_SetPreSkinningOffsets_Params Parms{};

	Parms.LODIndex = LODIndex;
	Parms.Offsets = Offsets;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetPostSkinningOffsets
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<struct FVector>             Offsets                                                          (Parm, ZeroConstructor, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetPostSkinningOffsets(int32 LODIndex, const TArray<struct FVector>& Offsets)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetPostSkinningOffsets");

	Params::USkinnedMeshComponent_SetPostSkinningOffsets_Params Parms{};

	Parms.LODIndex = LODIndex;
	Parms.Offsets = Offsets;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetPhysicsAsset
// (Native, Public, BlueprintCallable)
// Parameters:
// class UPhysicsAsset*               NewPhysicsAsset                                                  (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bForceReInit                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetPhysicsAsset(class UPhysicsAsset* NewPhysicsAsset, bool bForceReInit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetPhysicsAsset");

	Params::USkinnedMeshComponent_SetPhysicsAsset_Params Parms{};

	Parms.NewPhysicsAsset = NewPhysicsAsset;
	Parms.bForceReInit = bForceReInit;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetMinLOD
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              InNewMinLOD                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetMinLOD(int32 InNewMinLOD)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetMinLOD");

	Params::USkinnedMeshComponent_SetMinLOD_Params Parms{};

	Parms.InNewMinLOD = InNewMinLOD;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetMeshDeformer
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UMeshDeformer*               InMeshDeformer                                                   (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetMeshDeformer(class UMeshDeformer* InMeshDeformer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetMeshDeformer");

	Params::USkinnedMeshComponent_SetMeshDeformer_Params Parms{};

	Parms.InMeshDeformer = InMeshDeformer;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetLeaderPoseComponent
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USkinnedMeshComponent*       NewLeaderBoneComponent                                           (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bForceUpdate                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bInFollowerShouldTickPose                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetLeaderPoseComponent(class USkinnedMeshComponent* NewLeaderBoneComponent, bool bForceUpdate, bool bInFollowerShouldTickPose)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetLeaderPoseComponent");

	Params::USkinnedMeshComponent_SetLeaderPoseComponent_Params Parms{};

	Parms.NewLeaderBoneComponent = NewLeaderBoneComponent;
	Parms.bForceUpdate = bForceUpdate;
	Parms.bInFollowerShouldTickPose = bInFollowerShouldTickPose;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetForcedLOD
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              InNewForcedLOD                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetForcedLOD(int32 InNewForcedLOD)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetForcedLOD");

	Params::USkinnedMeshComponent_SetForcedLOD_Params Parms{};

	Parms.InNewForcedLOD = InNewForcedLOD;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetCastCapsuleIndirectShadow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewValue                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetCastCapsuleIndirectShadow(bool bNewValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetCastCapsuleIndirectShadow");

	Params::USkinnedMeshComponent_SetCastCapsuleIndirectShadow_Params Parms{};

	Parms.bNewValue = bNewValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetCastCapsuleDirectShadow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewValue                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetCastCapsuleDirectShadow(bool bNewValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetCastCapsuleDirectShadow");

	Params::USkinnedMeshComponent_SetCastCapsuleDirectShadow_Params Parms{};

	Parms.bNewValue = bNewValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.SetCapsuleIndirectShadowMinVisibility
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewValue                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::SetCapsuleIndirectShadowMinVisibility(float NewValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "SetCapsuleIndirectShadowMinVisibility");

	Params::USkinnedMeshComponent_SetCapsuleIndirectShadowMinVisibility_Params Parms{};

	Parms.NewValue = NewValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.IsUsingSkinWeightProfile
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USkinnedMeshComponent::IsUsingSkinWeightProfile()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "IsUsingSkinWeightProfile");

	Params::USkinnedMeshComponent_IsUsingSkinWeightProfile_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.IsMaterialSectionShown
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              MaterialID                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USkinnedMeshComponent::IsMaterialSectionShown(int32 MaterialID, int32 LODIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "IsMaterialSectionShown");

	Params::USkinnedMeshComponent_IsMaterialSectionShown_Params Parms{};

	Parms.MaterialID = MaterialID;
	Parms.LODIndex = LODIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.IsBoneHiddenByName
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USkinnedMeshComponent::IsBoneHiddenByName(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "IsBoneHiddenByName");

	Params::USkinnedMeshComponent_IsBoneHiddenByName_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.HideBoneByName
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EPhysBodyOp             PhysBodyOption                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::HideBoneByName(class FName BoneName, enum class EPhysBodyOp PhysBodyOption)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "HideBoneByName");

	Params::USkinnedMeshComponent_HideBoneByName_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.PhysBodyOption = PhysBodyOption;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.GetVertexOffsetUsage
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USkinnedMeshComponent::GetVertexOffsetUsage(int32 LODIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetVertexOffsetUsage");

	Params::USkinnedMeshComponent_GetVertexOffsetUsage_Params Parms{};

	Parms.LODIndex = LODIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetTwistAndSwingAngleOfDeltaRotationFromRefPose
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              OutTwistAngle                                                    (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              OutSwingAngle                                                    (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USkinnedMeshComponent::GetTwistAndSwingAngleOfDeltaRotationFromRefPose(class FName BoneName, float* OutTwistAngle, float* OutSwingAngle)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetTwistAndSwingAngleOfDeltaRotationFromRefPose");

	Params::USkinnedMeshComponent_GetTwistAndSwingAngleOfDeltaRotationFromRefPose_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutTwistAngle != nullptr)
		*OutTwistAngle = Parms.OutTwistAngle;

	if (OutSwingAngle != nullptr)
		*OutSwingAngle = Parms.OutSwingAngle;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetSocketBoneName
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName USkinnedMeshComponent::GetSocketBoneName(class FName InSocketName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetSocketBoneName");

	Params::USkinnedMeshComponent_GetSocketBoneName_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetSkinnedAsset
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class USkinnedAsset*               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkinnedAsset* USkinnedMeshComponent::GetSkinnedAsset()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetSkinnedAsset");

	Params::USkinnedMeshComponent_GetSkinnedAsset_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetSkeletalMesh_DEPRECATED
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class USkeletalMesh*               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkeletalMesh* USkinnedMeshComponent::GetSkeletalMesh_DEPRECATED()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetSkeletalMesh_DEPRECATED");

	Params::USkinnedMeshComponent_GetSkeletalMesh_DEPRECATED_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetRefPoseTransform
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              BoneIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USkinnedMeshComponent::GetRefPoseTransform(int32 BoneIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetRefPoseTransform");

	Params::USkinnedMeshComponent_GetRefPoseTransform_Params Parms{};

	Parms.BoneIndex = BoneIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetRefPosePosition
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              BoneIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector USkinnedMeshComponent::GetRefPosePosition(int32 BoneIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetRefPosePosition");

	Params::USkinnedMeshComponent_GetRefPosePosition_Params Parms{};

	Parms.BoneIndex = BoneIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetPredictedLODLevel
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USkinnedMeshComponent::GetPredictedLODLevel()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetPredictedLODLevel");

	Params::USkinnedMeshComponent_GetPredictedLODLevel_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetParentBone
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName USkinnedMeshComponent::GetParentBone(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetParentBone");

	Params::USkinnedMeshComponent_GetParentBone_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetNumLODs
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USkinnedMeshComponent::GetNumLODs()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetNumLODs");

	Params::USkinnedMeshComponent_GetNumLODs_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetNumBones
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USkinnedMeshComponent::GetNumBones()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetNumBones");

	Params::USkinnedMeshComponent_GetNumBones_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetForcedLOD
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USkinnedMeshComponent::GetForcedLOD()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetForcedLOD");

	Params::USkinnedMeshComponent_GetForcedLOD_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetDeltaTransformFromRefPose
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BaseName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  ReturnValue                                                      (Parm, OutParm, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTransform USkinnedMeshComponent::GetDeltaTransformFromRefPose(class FName BoneName, class FName BaseName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetDeltaTransformFromRefPose");

	Params::USkinnedMeshComponent_GetDeltaTransformFromRefPose_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.BaseName = BaseName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetCurrentSkinWeightProfileName
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName USkinnedMeshComponent::GetCurrentSkinWeightProfileName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetCurrentSkinWeightProfileName");

	Params::USkinnedMeshComponent_GetCurrentSkinWeightProfileName_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetBoneName
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              BoneIndex                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName USkinnedMeshComponent::GetBoneName(int32 BoneIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetBoneName");

	Params::USkinnedMeshComponent_GetBoneName_Params Parms{};

	Parms.BoneIndex = BoneIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.GetBoneIndex
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USkinnedMeshComponent::GetBoneIndex(class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "GetBoneIndex");

	Params::USkinnedMeshComponent_GetBoneIndex_Params Parms{};

	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.FindClosestBone_K2
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     TestLocation                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     BoneLocation                                                     (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              IgnoreScale                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bRequirePhysicsAsset                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName USkinnedMeshComponent::FindClosestBone_K2(const struct FVector& TestLocation, struct FVector* BoneLocation, float IgnoreScale, bool bRequirePhysicsAsset)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "FindClosestBone_K2");

	Params::USkinnedMeshComponent_FindClosestBone_K2_Params Parms{};

	Parms.TestLocation = TestLocation;
	Parms.IgnoreScale = IgnoreScale;
	Parms.bRequirePhysicsAsset = bRequirePhysicsAsset;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (BoneLocation != nullptr)
		*BoneLocation = std::move(Parms.BoneLocation);

	return Parms.ReturnValue;

}


// Function Engine.SkinnedMeshComponent.ClearVertexColorOverride
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::ClearVertexColorOverride(int32 LODIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "ClearVertexColorOverride");

	Params::USkinnedMeshComponent_ClearVertexColorOverride_Params Parms{};

	Parms.LODIndex = LODIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.ClearSkinWeightProfile
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void USkinnedMeshComponent::ClearSkinWeightProfile()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "ClearSkinWeightProfile");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.ClearSkinWeightOverride
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkinnedMeshComponent::ClearSkinWeightOverride(int32 LODIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "ClearSkinWeightOverride");

	Params::USkinnedMeshComponent_ClearSkinWeightOverride_Params Parms{};

	Parms.LODIndex = LODIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkinnedMeshComponent.BoneIsChildOf
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ParentBoneName                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USkinnedMeshComponent::BoneIsChildOf(class FName BoneName, class FName ParentBoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedMeshComponent", "BoneIsChildOf");

	Params::USkinnedMeshComponent_BoneIsChildOf_Params Parms{};

	Parms.BoneName = BoneName;
	Parms.ParentBoneName = ParentBoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.StreamableRenderAsset
// (None)

class UClass* UStreamableRenderAsset::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("StreamableRenderAsset");

	return Clss;
}


// StreamableRenderAsset Engine.Default__StreamableRenderAsset
// (Public, ClassDefaultObject, ArchetypeObject)

class UStreamableRenderAsset* UStreamableRenderAsset::GetDefaultObj()
{
	static class UStreamableRenderAsset* Default = nullptr;

	if (!Default)
		Default = static_cast<UStreamableRenderAsset*>(UStreamableRenderAsset::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.StreamableRenderAsset.SetForceMipLevelsToBeResident
// (Final, RequiredAPI, Native, Public, BlueprintCallable)
// Parameters:
// float                              Seconds                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              CinematicLODGroupMask                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UStreamableRenderAsset::SetForceMipLevelsToBeResident(float Seconds, int32 CinematicLODGroupMask)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("StreamableRenderAsset", "SetForceMipLevelsToBeResident");

	Params::UStreamableRenderAsset_SetForceMipLevelsToBeResident_Params Parms{};

	Parms.Seconds = Seconds;
	Parms.CinematicLODGroupMask = CinematicLODGroupMask;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.SkinnedAsset
// (None)

class UClass* USkinnedAsset::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("SkinnedAsset");

	return Clss;
}


// SkinnedAsset Engine.Default__SkinnedAsset
// (Public, ClassDefaultObject, ArchetypeObject)

class USkinnedAsset* USkinnedAsset::GetDefaultObj()
{
	static class USkinnedAsset* Default = nullptr;

	if (!Default)
		Default = static_cast<USkinnedAsset*>(USkinnedAsset::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.SkinnedAsset.FindSocketInfo
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  OutTransform                                                     (Parm, OutParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              OutBoneIndex                                                     (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              OutIndex                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class USkeletalMeshSocket*         ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkeletalMeshSocket* USkinnedAsset::FindSocketInfo(class FName InSocketName, struct FTransform* OutTransform, int32* OutBoneIndex, int32* OutIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedAsset", "FindSocketInfo");

	Params::USkinnedAsset_FindSocketInfo_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutTransform != nullptr)
		*OutTransform = std::move(Parms.OutTransform);

	if (OutBoneIndex != nullptr)
		*OutBoneIndex = Parms.OutBoneIndex;

	if (OutIndex != nullptr)
		*OutIndex = Parms.OutIndex;

	return Parms.ReturnValue;

}


// Function Engine.SkinnedAsset.FindSocket
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class USkeletalMeshSocket*         ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkeletalMeshSocket* USkinnedAsset::FindSocket(class FName InSocketName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkinnedAsset", "FindSocket");

	Params::USkinnedAsset_FindSocket_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.SkeletalMesh
// (None)

class UClass* USkeletalMesh::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("SkeletalMesh");

	return Clss;
}


// SkeletalMesh Engine.Default__SkeletalMesh
// (Public, ClassDefaultObject, ArchetypeObject)

class USkeletalMesh* USkeletalMesh::GetDefaultObj()
{
	static class USkeletalMesh* Default = nullptr;

	if (!Default)
		Default = static_cast<USkeletalMesh*>(USkeletalMesh::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.SkeletalMesh.SetSkeleton
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USkeleton*                   InSkeleton                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMesh::SetSkeleton(class USkeleton* InSkeleton)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "SetSkeleton");

	Params::USkeletalMesh_SetSkeleton_Params Parms{};

	Parms.InSkeleton = InSkeleton;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMesh.SetMorphTargets
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<class UMorphTarget*>        InMorphTargets                                                   (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void USkeletalMesh::SetMorphTargets(TArray<class UMorphTarget*>& InMorphTargets)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "SetMorphTargets");

	Params::USkeletalMesh_SetMorphTargets_Params Parms{};

	Parms.InMorphTargets = InMorphTargets;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMesh.SetMinLODForQualityLevels
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TMap<enum class EPerQualityLevels, int32>QualityLevelMinimumLODs                                          (ConstParm, Parm, OutParm, ReferenceParm, NativeAccessSpecifierPublic)
// int32                              Default                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMesh::SetMinLODForQualityLevels(TMap<enum class EPerQualityLevels, int32>& QualityLevelMinimumLODs, int32 Default)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "SetMinLODForQualityLevels");

	Params::USkeletalMesh_SetMinLODForQualityLevels_Params Parms{};

	Parms.QualityLevelMinimumLODs = QualityLevelMinimumLODs;
	Parms.Default = Default;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMesh.SetMeshClothingAssets
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<class UClothingAssetBase*>  InMeshClothingAssets                                             (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void USkeletalMesh::SetMeshClothingAssets(TArray<class UClothingAssetBase*>& InMeshClothingAssets)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "SetMeshClothingAssets");

	Params::USkeletalMesh_SetMeshClothingAssets_Params Parms{};

	Parms.InMeshClothingAssets = InMeshClothingAssets;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMesh.SetMaterials
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<struct FSkeletalMaterial>   InMaterials                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void USkeletalMesh::SetMaterials(TArray<struct FSkeletalMaterial>& InMaterials)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "SetMaterials");

	Params::USkeletalMesh_SetMaterials_Params Parms{};

	Parms.InMaterials = InMaterials;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMesh.SetLODSettings
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USkeletalMeshLODSettings*    InLODSettings                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMesh::SetLODSettings(class USkeletalMeshLODSettings* InLODSettings)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "SetLODSettings");

	Params::USkeletalMesh_SetLODSettings_Params Parms{};

	Parms.InLODSettings = InLODSettings;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMesh.SetDefaultAnimatingRig
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// TSoftObjectPtr<class UObject>      InAnimatingRig                                                   (Parm, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMesh::SetDefaultAnimatingRig(TSoftObjectPtr<class UObject> InAnimatingRig)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "SetDefaultAnimatingRig");

	Params::USkeletalMesh_SetDefaultAnimatingRig_Params Parms{};

	Parms.InAnimatingRig = InAnimatingRig;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMesh.NumSockets
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 USkeletalMesh::NumSockets()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "NumSockets");

	Params::USkeletalMesh_NumSockets_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.K2_GetAllMorphTargetNames
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class FString>              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NativeAccessSpecifierPublic)

TArray<class FString> USkeletalMesh::K2_GetAllMorphTargetNames()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "K2_GetAllMorphTargetNames");

	Params::USkeletalMesh_K2_GetAllMorphTargetNames_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.IsSectionUsingCloth
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              InSectionIndex                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bCheckCorrespondingSections                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool USkeletalMesh::IsSectionUsingCloth(int32 InSectionIndex, bool bCheckCorrespondingSections)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "IsSectionUsingCloth");

	Params::USkeletalMesh_IsSectionUsingCloth_Params Parms{};

	Parms.InSectionIndex = InSectionIndex;
	Parms.bCheckCorrespondingSections = bCheckCorrespondingSections;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetSocketByIndex
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              Index                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class USkeletalMeshSocket*         ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkeletalMeshSocket* USkeletalMesh::GetSocketByIndex(int32 Index)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetSocketByIndex");

	Params::USkeletalMesh_GetSocketByIndex_Params Parms{};

	Parms.Index = Index;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetSkeleton
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class USkeleton*                   ReturnValue                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkeleton* USkeletalMesh::GetSkeleton()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetSkeleton");

	Params::USkeletalMesh_GetSkeleton_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetShadowPhysicsAsset
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UPhysicsAsset*               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UPhysicsAsset* USkeletalMesh::GetShadowPhysicsAsset()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetShadowPhysicsAsset");

	Params::USkeletalMesh_GetShadowPhysicsAsset_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetPhysicsAsset
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UPhysicsAsset*               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UPhysicsAsset* USkeletalMesh::GetPhysicsAsset()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetPhysicsAsset");

	Params::USkeletalMesh_GetPhysicsAsset_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetNodeMappingData
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class UNodeMappingContainer*>ReturnValue                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReturnParm, ReferenceParm, NativeAccessSpecifierPublic)

TArray<class UNodeMappingContainer*> USkeletalMesh::GetNodeMappingData()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetNodeMappingData");

	Params::USkeletalMesh_GetNodeMappingData_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetNodeMappingContainer
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UBlueprint*                  SourceAsset                                                      (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UNodeMappingContainer*       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UNodeMappingContainer* USkeletalMesh::GetNodeMappingContainer(class UBlueprint* SourceAsset)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetNodeMappingContainer");

	Params::USkeletalMesh_GetNodeMappingContainer_Params Parms{};

	Parms.SourceAsset = SourceAsset;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetMorphTargetsPtrConv
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class UMorphTarget*>        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NativeAccessSpecifierPublic)

TArray<class UMorphTarget*> USkeletalMesh::GetMorphTargetsPtrConv()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetMorphTargetsPtrConv");

	Params::USkeletalMesh_GetMorphTargetsPtrConv_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetMinLODForQualityLevels
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TMap<enum class EPerQualityLevels, int32>QualityLevelMinimumLODs                                          (Parm, OutParm, NativeAccessSpecifierPublic)
// int32                              Default                                                          (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMesh::GetMinLODForQualityLevels(TMap<enum class EPerQualityLevels, int32>* QualityLevelMinimumLODs, int32* Default)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetMinLODForQualityLevels");

	Params::USkeletalMesh_GetMinLODForQualityLevels_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (QualityLevelMinimumLODs != nullptr)
		*QualityLevelMinimumLODs = Parms.QualityLevelMinimumLODs;

	if (Default != nullptr)
		*Default = Parms.Default;

}


// Function Engine.SkeletalMesh.GetMeshClothingAssets
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<class UClothingAssetBase*>  ReturnValue                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReturnParm, ReferenceParm, NativeAccessSpecifierPublic)

TArray<class UClothingAssetBase*> USkeletalMesh::GetMeshClothingAssets()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetMeshClothingAssets");

	Params::USkeletalMesh_GetMeshClothingAssets_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetMaterials
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<struct FSkeletalMaterial>   ReturnValue                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReturnParm, ReferenceParm, NativeAccessSpecifierPublic)

TArray<struct FSkeletalMaterial> USkeletalMesh::GetMaterials()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetMaterials");

	Params::USkeletalMesh_GetMaterials_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetLODSettings
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class USkeletalMeshLODSettings*    ReturnValue                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkeletalMeshLODSettings* USkeletalMesh::GetLODSettings()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetLODSettings");

	Params::USkeletalMesh_GetLODSettings_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetImportedBounds
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FBoxSphereBounds            ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FBoxSphereBounds USkeletalMesh::GetImportedBounds()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetImportedBounds");

	Params::USkeletalMesh_GetImportedBounds_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetDefaultAnimatingRig
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TSoftObjectPtr<class UObject>      ReturnValue                                                      (Parm, OutParm, ReturnParm, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

TSoftObjectPtr<class UObject> USkeletalMesh::GetDefaultAnimatingRig()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetDefaultAnimatingRig");

	Params::USkeletalMesh_GetDefaultAnimatingRig_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.GetBounds
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FBoxSphereBounds            ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FBoxSphereBounds USkeletalMesh::GetBounds()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "GetBounds");

	Params::USkeletalMesh_GetBounds_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.SkeletalMesh.FindSocketAndIndex
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        InSocketName                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              OutIndex                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class USkeletalMeshSocket*         ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class USkeletalMeshSocket* USkeletalMesh::FindSocketAndIndex(class FName InSocketName, int32* OutIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMesh", "FindSocketAndIndex");

	Params::USkeletalMesh_FindSocketAndIndex_Params Parms{};

	Parms.InSocketName = InSocketName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutIndex != nullptr)
		*OutIndex = Parms.OutIndex;

	return Parms.ReturnValue;

}


// Class Engine.TimecodeProvider
// (None)

class UClass* UTimecodeProvider::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("TimecodeProvider");

	return Clss;
}


// TimecodeProvider Engine.Default__TimecodeProvider
// (Public, ClassDefaultObject, ArchetypeObject)

class UTimecodeProvider* UTimecodeProvider::GetDefaultObj()
{
	static class UTimecodeProvider* Default = nullptr;

	if (!Default)
		Default = static_cast<UTimecodeProvider*>(UTimecodeProvider::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.TimecodeProvider.GetTimecode
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FTimecode                   ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTimecode UTimecodeProvider::GetTimecode()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "GetTimecode");

	Params::UTimecodeProvider_GetTimecode_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.TimecodeProvider.GetSynchronizationState
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ETimecodeProviderSynchronizationStateReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class ETimecodeProviderSynchronizationState UTimecodeProvider::GetSynchronizationState()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "GetSynchronizationState");

	Params::UTimecodeProvider_GetSynchronizationState_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.TimecodeProvider.GetQualifiedFrameTime
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FQualifiedFrameTime         ReturnValue                                                      (Parm, OutParm, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FQualifiedFrameTime UTimecodeProvider::GetQualifiedFrameTime()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "GetQualifiedFrameTime");

	Params::UTimecodeProvider_GetQualifiedFrameTime_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.TimecodeProvider.GetFrameRate
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FFrameRate                  ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FFrameRate UTimecodeProvider::GetFrameRate()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "GetFrameRate");

	Params::UTimecodeProvider_GetFrameRate_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.TimecodeProvider.GetDelayedTimecode
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FTimecode                   ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FTimecode UTimecodeProvider::GetDelayedTimecode()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "GetDelayedTimecode");

	Params::UTimecodeProvider_GetDelayedTimecode_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.TimecodeProvider.GetDelayedQualifiedFrameTime
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FQualifiedFrameTime         ReturnValue                                                      (Parm, OutParm, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FQualifiedFrameTime UTimecodeProvider::GetDelayedQualifiedFrameTime()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "GetDelayedQualifiedFrameTime");

	Params::UTimecodeProvider_GetDelayedQualifiedFrameTime_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.TimecodeProvider.FetchTimecode
// (Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// struct FQualifiedFrameTime         OutFrameTime                                                     (Parm, OutParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UTimecodeProvider::FetchTimecode(struct FQualifiedFrameTime* OutFrameTime)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "FetchTimecode");

	Params::UTimecodeProvider_FetchTimecode_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutFrameTime != nullptr)
		*OutFrameTime = std::move(Parms.OutFrameTime);

	return Parms.ReturnValue;

}


// Function Engine.TimecodeProvider.FetchAndUpdate
// (Native, Public, BlueprintCallable)
// Parameters:

void UTimecodeProvider::FetchAndUpdate()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("TimecodeProvider", "FetchAndUpdate");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Class Engine.DataAsset
// (None)

class UClass* UDataAsset::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("DataAsset");

	return Clss;
}


// DataAsset Engine.Default__DataAsset
// (Public, ClassDefaultObject, ArchetypeObject)

class UDataAsset* UDataAsset::GetDefaultObj()
{
	static class UDataAsset* Default = nullptr;

	if (!Default)
		Default = static_cast<UDataAsset*>(UDataAsset::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.PrimaryDataAsset
// (None)

class UClass* UPrimaryDataAsset::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("PrimaryDataAsset");

	return Clss;
}


// PrimaryDataAsset Engine.Default__PrimaryDataAsset
// (Public, ClassDefaultObject, ArchetypeObject)

class UPrimaryDataAsset* UPrimaryDataAsset::GetDefaultObj()
{
	static class UPrimaryDataAsset* Default = nullptr;

	if (!Default)
		Default = static_cast<UPrimaryDataAsset*>(UPrimaryDataAsset::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.GameInstance
// (None)

class UClass* UGameInstance::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("GameInstance");

	return Clss;
}


// GameInstance Engine.Default__GameInstance
// (Public, ClassDefaultObject, ArchetypeObject)

class UGameInstance* UGameInstance::GetDefaultObj()
{
	static class UGameInstance* Default = nullptr;

	if (!Default)
		Default = static_cast<UGameInstance*>(UGameInstance::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.GameInstance.ReceiveShutdown
// (Event, Public, BlueprintEvent)
// Parameters:

void UGameInstance::ReceiveShutdown()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameInstance", "ReceiveShutdown");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.GameInstance.ReceiveInit
// (Event, Public, BlueprintEvent)
// Parameters:

void UGameInstance::ReceiveInit()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameInstance", "ReceiveInit");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.GameInstance.HandleTravelError
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class ETravelFailure          FailureType                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UGameInstance::HandleTravelError(enum class ETravelFailure FailureType)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameInstance", "HandleTravelError");

	Params::UGameInstance_HandleTravelError_Params Parms{};

	Parms.FailureType = FailureType;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameInstance.HandleNetworkError
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class ENetworkFailure         FailureType                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bIsServer                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UGameInstance::HandleNetworkError(enum class ENetworkFailure FailureType, bool bIsServer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameInstance", "HandleNetworkError");

	Params::UGameInstance_HandleNetworkError_Params Parms{};

	Parms.FailureType = FailureType;
	Parms.bIsServer = bIsServer;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameInstance.DebugRemovePlayer
// (Exec, Native, Public)
// Parameters:
// int32                              ControllerId                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UGameInstance::DebugRemovePlayer(int32 ControllerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameInstance", "DebugRemovePlayer");

	Params::UGameInstance_DebugRemovePlayer_Params Parms{};

	Parms.ControllerId = ControllerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameInstance.DebugCreatePlayer
// (Exec, Native, Public)
// Parameters:
// int32                              ControllerId                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UGameInstance::DebugCreatePlayer(int32 ControllerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameInstance", "DebugCreatePlayer");

	Params::UGameInstance_DebugCreatePlayer_Params Parms{};

	Parms.ControllerId = ControllerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.GameInstanceSubsystem
// (None)

class UClass* UGameInstanceSubsystem::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("GameInstanceSubsystem");

	return Clss;
}


// GameInstanceSubsystem Engine.Default__GameInstanceSubsystem
// (Public, ClassDefaultObject, ArchetypeObject)

class UGameInstanceSubsystem* UGameInstanceSubsystem::GetDefaultObj()
{
	static class UGameInstanceSubsystem* Default = nullptr;

	if (!Default)
		Default = static_cast<UGameInstanceSubsystem*>(UGameInstanceSubsystem::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.Controller
// (Actor)

class UClass* AController::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Controller");

	return Clss;
}


// Controller Engine.Default__Controller
// (Public, ClassDefaultObject, ArchetypeObject)

class AController* AController::GetDefaultObj()
{
	static class AController* Default = nullptr;

	if (!Default)
		Default = static_cast<AController*>(AController::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.Controller.UnPossess
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void AController::UnPossess()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "UnPossess");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.StopMovement
// (Native, Public, BlueprintCallable)
// Parameters:

void AController::StopMovement()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "StopMovement");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.SetInitialLocationAndRotation
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     NewLocation                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    NewRotation                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void AController::SetInitialLocationAndRotation(struct FVector& NewLocation, struct FRotator& NewRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "SetInitialLocationAndRotation");

	Params::AController_SetInitialLocationAndRotation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.NewRotation = NewRotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.SetIgnoreMoveInput
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewMoveInput                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AController::SetIgnoreMoveInput(bool bNewMoveInput)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "SetIgnoreMoveInput");

	Params::AController_SetIgnoreMoveInput_Params Parms{};

	Parms.bNewMoveInput = bNewMoveInput;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.SetIgnoreLookInput
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewLookInput                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AController::SetIgnoreLookInput(bool bNewLookInput)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "SetIgnoreLookInput");

	Params::AController_SetIgnoreLookInput_Params Parms{};

	Parms.bNewLookInput = bNewLookInput;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.SetControlRotation
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// struct FRotator                    NewRotation                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void AController::SetControlRotation(struct FRotator& NewRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "SetControlRotation");

	Params::AController_SetControlRotation_Params Parms{};

	Parms.NewRotation = NewRotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.ResetIgnoreMoveInput
// (Native, Public, BlueprintCallable)
// Parameters:

void AController::ResetIgnoreMoveInput()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ResetIgnoreMoveInput");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.ResetIgnoreLookInput
// (Native, Public, BlueprintCallable)
// Parameters:

void AController::ResetIgnoreLookInput()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ResetIgnoreLookInput");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.ResetIgnoreInputFlags
// (Native, Public, BlueprintCallable)
// Parameters:

void AController::ResetIgnoreInputFlags()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ResetIgnoreInputFlags");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.ReceiveUnPossess
// (Event, Protected, BlueprintEvent)
// Parameters:
// class APawn*                       UnpossessedPawn                                                  (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AController::ReceiveUnPossess(class APawn* UnpossessedPawn)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ReceiveUnPossess");

	Params::AController_ReceiveUnPossess_Params Parms{};

	Parms.UnpossessedPawn = UnpossessedPawn;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Controller.ReceivePossess
// (Event, Protected, BlueprintEvent)
// Parameters:
// class APawn*                       PossessedPawn                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AController::ReceivePossess(class APawn* PossessedPawn)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ReceivePossess");

	Params::AController_ReceivePossess_Params Parms{};

	Parms.PossessedPawn = PossessedPawn;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Controller.ReceiveInstigatedAnyDamage
// (BlueprintAuthorityOnly, Event, Protected, BlueprintEvent)
// Parameters:
// float                              Damage                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UDamageType*                 DamageType                                                       (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      DamagedActor                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      DamageCauser                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AController::ReceiveInstigatedAnyDamage(float Damage, class UDamageType* DamageType, class AActor* DamagedActor, class AActor* DamageCauser)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ReceiveInstigatedAnyDamage");

	Params::AController_ReceiveInstigatedAnyDamage_Params Parms{};

	Parms.Damage = Damage;
	Parms.DamageType = DamageType;
	Parms.DamagedActor = DamagedActor;
	Parms.DamageCauser = DamageCauser;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Controller.Possess
// (Final, BlueprintAuthorityOnly, Native, Public, BlueprintCallable)
// Parameters:
// class APawn*                       InPawn                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AController::Possess(class APawn* InPawn)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "Possess");

	Params::AController_Possess_Params Parms{};

	Parms.InPawn = InPawn;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.OnRep_PlayerState
// (Native, Public)
// Parameters:

void AController::OnRep_PlayerState()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "OnRep_PlayerState");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.OnRep_Pawn
// (Native, Public)
// Parameters:

void AController::OnRep_Pawn()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "OnRep_Pawn");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.LineOfSightTo
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      Other                                                            (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ViewPoint                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAlternateChecks                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AController::LineOfSightTo(class AActor* Other, const struct FVector& ViewPoint, bool bAlternateChecks)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "LineOfSightTo");

	Params::AController_LineOfSightTo_Params Parms{};

	Parms.Other = Other;
	Parms.ViewPoint = ViewPoint;
	Parms.bAlternateChecks = bAlternateChecks;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.K2_GetPawn
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class APawn*                       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APawn* AController::K2_GetPawn()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "K2_GetPawn");

	Params::AController_K2_GetPawn_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.IsPlayerController
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AController::IsPlayerController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "IsPlayerController");

	Params::AController_IsPlayerController_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.IsMoveInputIgnored
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AController::IsMoveInputIgnored()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "IsMoveInputIgnored");

	Params::AController_IsMoveInputIgnored_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.IsLookInputIgnored
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AController::IsLookInputIgnored()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "IsLookInputIgnored");

	Params::AController_IsLookInputIgnored_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.IsLocalPlayerController
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AController::IsLocalPlayerController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "IsLocalPlayerController");

	Params::AController_IsLocalPlayerController_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.IsLocalController
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AController::IsLocalController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "IsLocalController");

	Params::AController_IsLocalController_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.GetViewTarget
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* AController::GetViewTarget()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "GetViewTarget");

	Params::AController_GetViewTarget_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.GetPlayerViewPoint
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     Location                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    Rotation                                                         (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void AController::GetPlayerViewPoint(struct FVector* Location, struct FRotator* Rotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "GetPlayerViewPoint");

	Params::AController_GetPlayerViewPoint_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (Location != nullptr)
		*Location = std::move(Parms.Location);

	if (Rotation != nullptr)
		*Rotation = std::move(Parms.Rotation);

}


// Function Engine.Controller.GetDesiredRotation
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator AController::GetDesiredRotation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "GetDesiredRotation");

	Params::AController_GetDesiredRotation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.GetControlRotation
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator AController::GetControlRotation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "GetControlRotation");

	Params::AController_GetControlRotation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Controller.ClientSetRotation
// (Net, NetReliable, Native, Event, Public, HasDefaults, NetClient, NetValidate)
// Parameters:
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bResetCamera                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AController::ClientSetRotation(const struct FRotator& NewRotation, bool bResetCamera)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ClientSetRotation");

	Params::AController_ClientSetRotation_Params Parms{};

	Parms.NewRotation = NewRotation;
	Parms.bResetCamera = bResetCamera;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Controller.ClientSetLocation
// (Net, NetReliable, Native, Event, Public, HasDefaults, NetClient, NetValidate)
// Parameters:
// struct FVector                     NewLocation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    NewRotation                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void AController::ClientSetLocation(const struct FVector& NewLocation, const struct FRotator& NewRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Controller", "ClientSetLocation");

	Params::AController_ClientSetLocation_Params Parms{};

	Parms.NewLocation = NewLocation;
	Parms.NewRotation = NewRotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.Pawn
// (Actor, Pawn)

class UClass* APawn::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Pawn");

	return Clss;
}


// Pawn Engine.Default__Pawn
// (Public, ClassDefaultObject, ArchetypeObject)

class APawn* APawn::GetDefaultObj()
{
	static class APawn* Default = nullptr;

	if (!Default)
		Default = static_cast<APawn*>(APawn::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.Pawn.SpawnDefaultController
// (Native, Public, BlueprintCallable)
// Parameters:

void APawn::SpawnDefaultController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "SpawnDefaultController");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.SetCanAffectNavigationGeneration
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewValue                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bForceUpdate                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::SetCanAffectNavigationGeneration(bool bNewValue, bool bForceUpdate)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "SetCanAffectNavigationGeneration");

	Params::APawn_SetCanAffectNavigationGeneration_Params Parms{};

	Parms.bNewValue = bNewValue;
	Parms.bForceUpdate = bForceUpdate;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.ReceiveUnpossessed
// (BlueprintAuthorityOnly, Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 OldController                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::ReceiveUnpossessed(class AController* OldController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "ReceiveUnpossessed");

	Params::APawn_ReceiveUnpossessed_Params Parms{};

	Parms.OldController = OldController;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Pawn.ReceiveRestarted
// (Event, Public, BlueprintEvent)
// Parameters:

void APawn::ReceiveRestarted()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "ReceiveRestarted");



	UObject::ProcessEvent(Func, nullptr);

}


// Function Engine.Pawn.ReceivePossessed
// (BlueprintAuthorityOnly, Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 NewController                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::ReceivePossessed(class AController* NewController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "ReceivePossessed");

	Params::APawn_ReceivePossessed_Params Parms{};

	Parms.NewController = NewController;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Pawn.ReceiveControllerChanged
// (Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 OldController                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AController*                 NewController                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::ReceiveControllerChanged(class AController* OldController, class AController* NewController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "ReceiveControllerChanged");

	Params::APawn_ReceiveControllerChanged_Params Parms{};

	Parms.OldController = OldController;
	Parms.NewController = NewController;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Pawn.PawnMakeNoise
// (Final, BlueprintAuthorityOnly, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// float                              Loudness                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     NoiseLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bUseNoiseMakerLocation                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      NoiseMaker                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::PawnMakeNoise(float Loudness, const struct FVector& NoiseLocation, bool bUseNoiseMakerLocation, class AActor* NoiseMaker)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "PawnMakeNoise");

	Params::APawn_PawnMakeNoise_Params Parms{};

	Parms.Loudness = Loudness;
	Parms.NoiseLocation = NoiseLocation;
	Parms.bUseNoiseMakerLocation = bUseNoiseMakerLocation;
	Parms.NoiseMaker = NoiseMaker;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.OnRep_PlayerState
// (Native, Public)
// Parameters:

void APawn::OnRep_PlayerState()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "OnRep_PlayerState");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.OnRep_Controller
// (Native, Public)
// Parameters:

void APawn::OnRep_Controller()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "OnRep_Controller");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.IsPlayerControlled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APawn::IsPlayerControlled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "IsPlayerControlled");

	Params::APawn_IsPlayerControlled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.IsPawnControlled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APawn::IsPawnControlled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "IsPawnControlled");

	Params::APawn_IsPawnControlled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.IsMoveInputIgnored
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APawn::IsMoveInputIgnored()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "IsMoveInputIgnored");

	Params::APawn_IsMoveInputIgnored_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.IsLocallyViewed
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APawn::IsLocallyViewed()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "IsLocallyViewed");

	Params::APawn_IsLocallyViewed_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.IsLocallyControlled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APawn::IsLocallyControlled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "IsLocallyControlled");

	Params::APawn_IsLocallyControlled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.IsControlled
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APawn::IsControlled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "IsControlled");

	Params::APawn_IsControlled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.IsBotControlled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APawn::IsBotControlled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "IsBotControlled");

	Params::APawn_IsBotControlled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetPendingMovementInputVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector APawn::GetPendingMovementInputVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetPendingMovementInputVector");

	Params::APawn_GetPendingMovementInputVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetOverrideInputComponentClass
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TSubclassOf<class UInputComponent> ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

TSubclassOf<class UInputComponent> APawn::GetOverrideInputComponentClass()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetOverrideInputComponentClass");

	Params::APawn_GetOverrideInputComponentClass_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetNavAgentLocation
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector APawn::GetNavAgentLocation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetNavAgentLocation");

	Params::APawn_GetNavAgentLocation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetMovementComponent
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UPawnMovementComponent*      ReturnValue                                                      (ExportObject, Parm, OutParm, ZeroConstructor, ReturnParm, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UPawnMovementComponent* APawn::GetMovementComponent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetMovementComponent");

	Params::APawn_GetMovementComponent_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetMovementBaseActor
// (Final, Native, Static, Public, BlueprintCallable, BlueprintPure)
// Parameters:
// class APawn*                       Pawn                                                             (ConstParm, Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* APawn::GetMovementBaseActor(class APawn* Pawn)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetMovementBaseActor");

	Params::APawn_GetMovementBaseActor_Params Parms{};

	Parms.Pawn = Pawn;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetLocalViewingPlayerController
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class APlayerController*           ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APlayerController* APawn::GetLocalViewingPlayerController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetLocalViewingPlayerController");

	Params::APawn_GetLocalViewingPlayerController_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetLastMovementInputVector
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector APawn::GetLastMovementInputVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetLastMovementInputVector");

	Params::APawn_GetLastMovementInputVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetControlRotation
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator APawn::GetControlRotation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetControlRotation");

	Params::APawn_GetControlRotation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetController
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AController*                 ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AController* APawn::GetController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetController");

	Params::APawn_GetController_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.GetBaseAimRotation
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator APawn::GetBaseAimRotation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "GetBaseAimRotation");

	Params::APawn_GetBaseAimRotation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.DetachFromControllerPendingDestroy
// (Native, Public, BlueprintCallable)
// Parameters:

void APawn::DetachFromControllerPendingDestroy()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "DetachFromControllerPendingDestroy");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.ConsumeMovementInputVector
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector APawn::ConsumeMovementInputVector()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "ConsumeMovementInputVector");

	Params::APawn_ConsumeMovementInputVector_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Pawn.AddMovementInput
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     WorldDirection                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ScaleValue                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bForce                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::AddMovementInput(const struct FVector& WorldDirection, float ScaleValue, bool bForce)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "AddMovementInput");

	Params::APawn_AddMovementInput_Params Parms{};

	Parms.WorldDirection = WorldDirection;
	Parms.ScaleValue = ScaleValue;
	Parms.bForce = bForce;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.AddControllerYawInput
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Val                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::AddControllerYawInput(float Val)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "AddControllerYawInput");

	Params::APawn_AddControllerYawInput_Params Parms{};

	Parms.Val = Val;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.AddControllerRollInput
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Val                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::AddControllerRollInput(float Val)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "AddControllerRollInput");

	Params::APawn_AddControllerRollInput_Params Parms{};

	Parms.Val = Val;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Pawn.AddControllerPitchInput
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Val                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APawn::AddControllerPitchInput(float Val)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Pawn", "AddControllerPitchInput");

	Params::APawn_AddControllerPitchInput_Params Parms{};

	Parms.Val = Val;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.Character
// (Actor, Pawn)

class UClass* ACharacter::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Character");

	return Clss;
}


// Character Engine.Default__Character
// (Public, ClassDefaultObject, ArchetypeObject)

class ACharacter* ACharacter::GetDefaultObj()
{
	static class ACharacter* Default = nullptr;

	if (!Default)
		Default = static_cast<ACharacter*>(ACharacter::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.Character.UnCrouch
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bClientSimulation                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::UnCrouch(bool bClientSimulation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "UnCrouch");

	Params::ACharacter_UnCrouch_Params Parms{};

	Parms.bClientSimulation = bClientSimulation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.StopJumping
// (Native, Public, BlueprintCallable)
// Parameters:

void ACharacter::StopJumping()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "StopJumping");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.StopAnimMontage
// (Native, Public, BlueprintCallable)
// Parameters:
// class UAnimMontage*                AnimMontage                                                      (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::StopAnimMontage(class UAnimMontage* AnimMontage)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "StopAnimMontage");

	Params::ACharacter_StopAnimMontage_Params Parms{};

	Parms.AnimMontage = AnimMontage;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ServerMovePacked
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FCharacterServerMovePackedBitsPackedBits                                                       (ConstParm, Parm, ReferenceParm, NativeAccessSpecifierPublic)

void ACharacter::ServerMovePacked(struct FCharacterServerMovePackedBits& PackedBits)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ServerMovePacked");

	Params::ACharacter_ServerMovePacked_Params Parms{};

	Parms.PackedBits = PackedBits;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ServerMoveOld
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// float                              OldTimeStamp                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       OldAccel                                                         (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              OldMoveFlags                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ServerMoveOld(float OldTimeStamp, const struct FVector_NetQuantize10& OldAccel, uint8 OldMoveFlags)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ServerMoveOld");

	Params::ACharacter_ServerMoveOld_Params Parms{};

	Parms.OldTimeStamp = OldTimeStamp;
	Parms.OldAccel = OldAccel;
	Parms.OldMoveFlags = OldMoveFlags;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ServerMoveNoBase
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel                                                          (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize100      ClientLoc                                                        (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              CompressedMoveFlags                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientRoll                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ServerMoveNoBase(float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, uint8 CompressedMoveFlags, uint8 ClientRoll, uint32 View, uint8 ClientMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ServerMoveNoBase");

	Params::ACharacter_ServerMoveNoBase_Params Parms{};

	Parms.Timestamp = Timestamp;
	Parms.InAccel = InAccel;
	Parms.ClientLoc = ClientLoc;
	Parms.CompressedMoveFlags = CompressedMoveFlags;
	Parms.ClientRoll = ClientRoll;
	Parms.View = View;
	Parms.ClientMovementMode = ClientMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ServerMoveDualNoBase
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// float                              TimeStamp0                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel0                                                         (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              PendingFlags                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View0                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel                                                          (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize100      ClientLoc                                                        (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              NewFlags                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientRoll                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ServerMoveDualNoBase(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, uint8 PendingFlags, uint32 View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, uint8 NewFlags, uint8 ClientRoll, uint32 View, uint8 ClientMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ServerMoveDualNoBase");

	Params::ACharacter_ServerMoveDualNoBase_Params Parms{};

	Parms.TimeStamp0 = TimeStamp0;
	Parms.InAccel0 = InAccel0;
	Parms.PendingFlags = PendingFlags;
	Parms.View0 = View0;
	Parms.Timestamp = Timestamp;
	Parms.InAccel = InAccel;
	Parms.ClientLoc = ClientLoc;
	Parms.NewFlags = NewFlags;
	Parms.ClientRoll = ClientRoll;
	Parms.View = View;
	Parms.ClientMovementMode = ClientMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ServerMoveDualHybridRootMotion
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// float                              TimeStamp0                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel0                                                         (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              PendingFlags                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View0                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel                                                          (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize100      ClientLoc                                                        (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              NewFlags                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientRoll                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         ClientMovementBase                                               (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ClientBaseBoneName                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ServerMoveDualHybridRootMotion(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, uint8 PendingFlags, uint32 View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, uint8 NewFlags, uint8 ClientRoll, uint32 View, class UPrimitiveComponent* ClientMovementBase, class FName ClientBaseBoneName, uint8 ClientMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ServerMoveDualHybridRootMotion");

	Params::ACharacter_ServerMoveDualHybridRootMotion_Params Parms{};

	Parms.TimeStamp0 = TimeStamp0;
	Parms.InAccel0 = InAccel0;
	Parms.PendingFlags = PendingFlags;
	Parms.View0 = View0;
	Parms.Timestamp = Timestamp;
	Parms.InAccel = InAccel;
	Parms.ClientLoc = ClientLoc;
	Parms.NewFlags = NewFlags;
	Parms.ClientRoll = ClientRoll;
	Parms.View = View;
	Parms.ClientMovementBase = ClientMovementBase;
	Parms.ClientBaseBoneName = ClientBaseBoneName;
	Parms.ClientMovementMode = ClientMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ServerMoveDual
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// float                              TimeStamp0                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel0                                                         (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              PendingFlags                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View0                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel                                                          (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize100      ClientLoc                                                        (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              NewFlags                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientRoll                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         ClientMovementBase                                               (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ClientBaseBoneName                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ServerMoveDual(float TimeStamp0, const struct FVector_NetQuantize10& InAccel0, uint8 PendingFlags, uint32 View0, float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, uint8 NewFlags, uint8 ClientRoll, uint32 View, class UPrimitiveComponent* ClientMovementBase, class FName ClientBaseBoneName, uint8 ClientMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ServerMoveDual");

	Params::ACharacter_ServerMoveDual_Params Parms{};

	Parms.TimeStamp0 = TimeStamp0;
	Parms.InAccel0 = InAccel0;
	Parms.PendingFlags = PendingFlags;
	Parms.View0 = View0;
	Parms.Timestamp = Timestamp;
	Parms.InAccel = InAccel;
	Parms.ClientLoc = ClientLoc;
	Parms.NewFlags = NewFlags;
	Parms.ClientRoll = ClientRoll;
	Parms.View = View;
	Parms.ClientMovementBase = ClientMovementBase;
	Parms.ClientBaseBoneName = ClientBaseBoneName;
	Parms.ClientMovementMode = ClientMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ServerMove
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize10       InAccel                                                          (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantize100      ClientLoc                                                        (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              CompressedMoveFlags                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientRoll                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint32                             View                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         ClientMovementBase                                               (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ClientBaseBoneName                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ClientMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ServerMove(float Timestamp, const struct FVector_NetQuantize10& InAccel, const struct FVector_NetQuantize100& ClientLoc, uint8 CompressedMoveFlags, uint8 ClientRoll, uint32 View, class UPrimitiveComponent* ClientMovementBase, class FName ClientBaseBoneName, uint8 ClientMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ServerMove");

	Params::ACharacter_ServerMove_Params Parms{};

	Parms.Timestamp = Timestamp;
	Parms.InAccel = InAccel;
	Parms.ClientLoc = ClientLoc;
	Parms.CompressedMoveFlags = CompressedMoveFlags;
	Parms.ClientRoll = ClientRoll;
	Parms.View = View;
	Parms.ClientMovementBase = ClientMovementBase;
	Parms.ClientBaseBoneName = ClientBaseBoneName;
	Parms.ClientMovementMode = ClientMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.RootMotionDebugClientPrintOnScreen
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FString                      InString                                                         (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::RootMotionDebugClientPrintOnScreen(const class FString& InString)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "RootMotionDebugClientPrintOnScreen");

	Params::ACharacter_RootMotionDebugClientPrintOnScreen_Params Parms{};

	Parms.InString = InString;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.PlayAnimMontage
// (Native, Public, BlueprintCallable)
// Parameters:
// class UAnimMontage*                AnimMontage                                                      (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              InPlayRate                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        StartSectionName                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float ACharacter::PlayAnimMontage(class UAnimMontage* AnimMontage, float InPlayRate, class FName StartSectionName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "PlayAnimMontage");

	Params::ACharacter_PlayAnimMontage_Params Parms{};

	Parms.AnimMontage = AnimMontage;
	Parms.InPlayRate = InPlayRate;
	Parms.StartSectionName = StartSectionName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.OnWalkingOffLedge
// (Native, Event, Public, HasOutParams, HasDefaults, BlueprintEvent)
// Parameters:
// struct FVector                     PreviousFloorImpactNormal                                        (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     PreviousFloorContactNormal                                       (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     PreviousLocation                                                 (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              TimeDelta                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::OnWalkingOffLedge(struct FVector& PreviousFloorImpactNormal, struct FVector& PreviousFloorContactNormal, struct FVector& PreviousLocation, float TimeDelta)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnWalkingOffLedge");

	Params::ACharacter_OnWalkingOffLedge_Params Parms{};

	Parms.PreviousFloorImpactNormal = PreviousFloorImpactNormal;
	Parms.PreviousFloorContactNormal = PreviousFloorContactNormal;
	Parms.PreviousLocation = PreviousLocation;
	Parms.TimeDelta = TimeDelta;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.OnRep_RootMotion
// (Final, Native, Public)
// Parameters:

void ACharacter::OnRep_RootMotion()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnRep_RootMotion");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.OnRep_ReplicatedBasedMovement
// (Native, Public)
// Parameters:

void ACharacter::OnRep_ReplicatedBasedMovement()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnRep_ReplicatedBasedMovement");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.OnRep_ReplayLastTransformUpdateTimeStamp
// (Final, Native, Public)
// Parameters:

void ACharacter::OnRep_ReplayLastTransformUpdateTimeStamp()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnRep_ReplayLastTransformUpdateTimeStamp");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.OnRep_IsCrouched
// (Native, Public)
// Parameters:

void ACharacter::OnRep_IsCrouched()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnRep_IsCrouched");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.OnLaunched
// (Event, Public, HasDefaults, BlueprintEvent)
// Parameters:
// struct FVector                     LaunchVelocity                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bXYOverride                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bZOverride                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::OnLaunched(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnLaunched");

	Params::ACharacter_OnLaunched_Params Parms{};

	Parms.LaunchVelocity = LaunchVelocity;
	Parms.bXYOverride = bXYOverride;
	Parms.bZOverride = bZOverride;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Character.OnLanded
// (Event, Public, HasOutParams, BlueprintEvent)
// Parameters:
// struct FHitResult                  Hit                                                              (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)

void ACharacter::OnLanded(struct FHitResult& Hit)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnLanded");

	Params::ACharacter_OnLanded_Params Parms{};

	Parms.Hit = Hit;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Character.OnJumped
// (Native, Event, Public, BlueprintEvent)
// Parameters:

void ACharacter::OnJumped()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "OnJumped");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.LaunchCharacter
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     LaunchVelocity                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bXYOverride                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bZOverride                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::LaunchCharacter(const struct FVector& LaunchVelocity, bool bXYOverride, bool bZOverride)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "LaunchCharacter");

	Params::ACharacter_LaunchCharacter_Params Parms{};

	Parms.LaunchVelocity = LaunchVelocity;
	Parms.bXYOverride = bXYOverride;
	Parms.bZOverride = bZOverride;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.K2_UpdateCustomMovement
// (Event, Public, BlueprintEvent)
// Parameters:
// float                              DeltaTime                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::K2_UpdateCustomMovement(float DeltaTime)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "K2_UpdateCustomMovement");

	Params::ACharacter_K2_UpdateCustomMovement_Params Parms{};

	Parms.DeltaTime = DeltaTime;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Character.K2_OnStartCrouch
// (Event, Public, BlueprintEvent)
// Parameters:
// float                              HalfHeightAdjust                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ScaledHalfHeightAdjust                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::K2_OnStartCrouch(float HalfHeightAdjust, float ScaledHalfHeightAdjust)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "K2_OnStartCrouch");

	Params::ACharacter_K2_OnStartCrouch_Params Parms{};

	Parms.HalfHeightAdjust = HalfHeightAdjust;
	Parms.ScaledHalfHeightAdjust = ScaledHalfHeightAdjust;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Character.K2_OnMovementModeChanged
// (Event, Public, BlueprintEvent)
// Parameters:
// enum class EMovementMode           PrevMovementMode                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EMovementMode           NewMovementMode                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              PrevCustomMode                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              NewCustomMode                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::K2_OnMovementModeChanged(enum class EMovementMode PrevMovementMode, enum class EMovementMode NewMovementMode, uint8 PrevCustomMode, uint8 NewCustomMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "K2_OnMovementModeChanged");

	Params::ACharacter_K2_OnMovementModeChanged_Params Parms{};

	Parms.PrevMovementMode = PrevMovementMode;
	Parms.NewMovementMode = NewMovementMode;
	Parms.PrevCustomMode = PrevCustomMode;
	Parms.NewCustomMode = NewCustomMode;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Character.K2_OnEndCrouch
// (Event, Public, BlueprintEvent)
// Parameters:
// float                              HalfHeightAdjust                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ScaledHalfHeightAdjust                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::K2_OnEndCrouch(float HalfHeightAdjust, float ScaledHalfHeightAdjust)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "K2_OnEndCrouch");

	Params::ACharacter_K2_OnEndCrouch_Params Parms{};

	Parms.HalfHeightAdjust = HalfHeightAdjust;
	Parms.ScaledHalfHeightAdjust = ScaledHalfHeightAdjust;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.Character.Jump
// (Native, Public, BlueprintCallable)
// Parameters:

void ACharacter::Jump()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "Jump");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.IsPlayingRootMotion
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool ACharacter::IsPlayingRootMotion()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "IsPlayingRootMotion");

	Params::ACharacter_IsPlayingRootMotion_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.IsPlayingNetworkedRootMotionMontage
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool ACharacter::IsPlayingNetworkedRootMotionMontage()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "IsPlayingNetworkedRootMotionMontage");

	Params::ACharacter_IsPlayingNetworkedRootMotionMontage_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.IsJumpProvidingForce
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool ACharacter::IsJumpProvidingForce()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "IsJumpProvidingForce");

	Params::ACharacter_IsJumpProvidingForce_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.HasAnyRootMotion
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool ACharacter::HasAnyRootMotion()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "HasAnyRootMotion");

	Params::ACharacter_HasAnyRootMotion_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.GetCurrentMontage
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UAnimMontage*                ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UAnimMontage* ACharacter::GetCurrentMontage()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "GetCurrentMontage");

	Params::ACharacter_GetCurrentMontage_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.GetBaseTranslationOffset
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector ACharacter::GetBaseTranslationOffset()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "GetBaseTranslationOffset");

	Params::ACharacter_GetBaseTranslationOffset_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.GetBaseRotationOffsetRotator
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FRotator                    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

struct FRotator ACharacter::GetBaseRotationOffsetRotator()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "GetBaseRotationOffsetRotator");

	Params::ACharacter_GetBaseRotationOffsetRotator_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.GetAnimRootMotionTranslationScale
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float ACharacter::GetAnimRootMotionTranslationScale()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "GetAnimRootMotionTranslationScale");

	Params::ACharacter_GetAnimRootMotionTranslationScale_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.Crouch
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bClientSimulation                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::Crouch(bool bClientSimulation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "Crouch");

	Params::ACharacter_Crouch_Params Parms{};

	Parms.bClientSimulation = bClientSimulation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientVeryShortAdjustPosition
// (Net, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     NewLoc                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         NewBase                                                          (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        NewBaseBoneName                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bHasBase                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bBaseRelativePosition                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ServerMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ClientVeryShortAdjustPosition(float Timestamp, const struct FVector& NewLoc, class UPrimitiveComponent* NewBase, class FName NewBaseBoneName, bool bHasBase, bool bBaseRelativePosition, uint8 ServerMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientVeryShortAdjustPosition");

	Params::ACharacter_ClientVeryShortAdjustPosition_Params Parms{};

	Parms.Timestamp = Timestamp;
	Parms.NewLoc = NewLoc;
	Parms.NewBase = NewBase;
	Parms.NewBaseBoneName = NewBaseBoneName;
	Parms.bHasBase = bHasBase;
	Parms.bBaseRelativePosition = bBaseRelativePosition;
	Parms.ServerMovementMode = ServerMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientMoveResponsePacked
// (Net, Native, Event, Public, NetClient, NetValidate)
// Parameters:
// struct FCharacterMoveResponsePackedBitsPackedBits                                                       (ConstParm, Parm, ReferenceParm, NativeAccessSpecifierPublic)

void ACharacter::ClientMoveResponsePacked(struct FCharacterMoveResponsePackedBits& PackedBits)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientMoveResponsePacked");

	Params::ACharacter_ClientMoveResponsePacked_Params Parms{};

	Parms.PackedBits = PackedBits;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientCheatWalk
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void ACharacter::ClientCheatWalk()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientCheatWalk");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientCheatGhost
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void ACharacter::ClientCheatGhost()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientCheatGhost");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientCheatFly
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void ACharacter::ClientCheatFly()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientCheatFly");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientAdjustRootMotionSourcePosition
// (Net, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRootMotionSourceGroup      ServerRootMotion                                                 (Parm, NativeAccessSpecifierPublic)
// bool                               bHasAnimRootMotion                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ServerMontageTrackPosition                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ServerLoc                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantizeNormal   ServerRotation                                                   (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ServerVelZ                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         ServerBase                                                       (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ServerBoneName                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bHasBase                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bBaseRelativePosition                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ServerMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ClientAdjustRootMotionSourcePosition(float Timestamp, const struct FRootMotionSourceGroup& ServerRootMotion, bool bHasAnimRootMotion, float ServerMontageTrackPosition, const struct FVector& ServerLoc, const struct FVector_NetQuantizeNormal& ServerRotation, float ServerVelZ, class UPrimitiveComponent* ServerBase, class FName ServerBoneName, bool bHasBase, bool bBaseRelativePosition, uint8 ServerMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientAdjustRootMotionSourcePosition");

	Params::ACharacter_ClientAdjustRootMotionSourcePosition_Params Parms{};

	Parms.Timestamp = Timestamp;
	Parms.ServerRootMotion = ServerRootMotion;
	Parms.bHasAnimRootMotion = bHasAnimRootMotion;
	Parms.ServerMontageTrackPosition = ServerMontageTrackPosition;
	Parms.ServerLoc = ServerLoc;
	Parms.ServerRotation = ServerRotation;
	Parms.ServerVelZ = ServerVelZ;
	Parms.ServerBase = ServerBase;
	Parms.ServerBoneName = ServerBoneName;
	Parms.bHasBase = bHasBase;
	Parms.bBaseRelativePosition = bBaseRelativePosition;
	Parms.ServerMovementMode = ServerMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientAdjustRootMotionPosition
// (Net, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ServerMontageTrackPosition                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ServerLoc                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector_NetQuantizeNormal   ServerRotation                                                   (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ServerVelZ                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         ServerBase                                                       (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ServerBoneName                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bHasBase                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bBaseRelativePosition                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ServerMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ClientAdjustRootMotionPosition(float Timestamp, float ServerMontageTrackPosition, const struct FVector& ServerLoc, const struct FVector_NetQuantizeNormal& ServerRotation, float ServerVelZ, class UPrimitiveComponent* ServerBase, class FName ServerBoneName, bool bHasBase, bool bBaseRelativePosition, uint8 ServerMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientAdjustRootMotionPosition");

	Params::ACharacter_ClientAdjustRootMotionPosition_Params Parms{};

	Parms.Timestamp = Timestamp;
	Parms.ServerMontageTrackPosition = ServerMontageTrackPosition;
	Parms.ServerLoc = ServerLoc;
	Parms.ServerRotation = ServerRotation;
	Parms.ServerVelZ = ServerVelZ;
	Parms.ServerBase = ServerBase;
	Parms.ServerBoneName = ServerBoneName;
	Parms.bHasBase = bHasBase;
	Parms.bBaseRelativePosition = bBaseRelativePosition;
	Parms.ServerMovementMode = ServerMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientAdjustPosition
// (Net, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     NewLoc                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     NewVel                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UPrimitiveComponent*         NewBase                                                          (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        NewBaseBoneName                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bHasBase                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bBaseRelativePosition                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// uint8                              ServerMovementMode                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ClientAdjustPosition(float Timestamp, const struct FVector& NewLoc, const struct FVector& NewVel, class UPrimitiveComponent* NewBase, class FName NewBaseBoneName, bool bHasBase, bool bBaseRelativePosition, uint8 ServerMovementMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientAdjustPosition");

	Params::ACharacter_ClientAdjustPosition_Params Parms{};

	Parms.Timestamp = Timestamp;
	Parms.NewLoc = NewLoc;
	Parms.NewVel = NewVel;
	Parms.NewBase = NewBase;
	Parms.NewBaseBoneName = NewBaseBoneName;
	Parms.bHasBase = bHasBase;
	Parms.bBaseRelativePosition = bBaseRelativePosition;
	Parms.ServerMovementMode = ServerMovementMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.ClientAckGoodMove
// (Net, Native, Event, Public, NetClient)
// Parameters:
// float                              Timestamp                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void ACharacter::ClientAckGoodMove(float Timestamp)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "ClientAckGoodMove");

	Params::ACharacter_ClientAckGoodMove_Params Parms{};

	Parms.Timestamp = Timestamp;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.Character.CanJumpInternal
// (Native, Event, Protected, BlueprintEvent, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool ACharacter::CanJumpInternal()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "CanJumpInternal");

	Params::ACharacter_CanJumpInternal_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.CanJump
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool ACharacter::CanJump()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "CanJump");

	Params::ACharacter_CanJump_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.CanCrouch
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool ACharacter::CanCrouch()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "CanCrouch");

	Params::ACharacter_CanCrouch_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.Character.CacheInitialMeshOffset
// (Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FVector                     MeshRelativeLocation                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    MeshRelativeRotation                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void ACharacter::CacheInitialMeshOffset(const struct FVector& MeshRelativeLocation, const struct FRotator& MeshRelativeRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("Character", "CacheInitialMeshOffset");

	Params::ACharacter_CacheInitialMeshOffset_Params Parms{};

	Parms.MeshRelativeLocation = MeshRelativeLocation;
	Parms.MeshRelativeRotation = MeshRelativeRotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.Info
// (Actor)

class UClass* AInfo::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Info");

	return Clss;
}


// Info Engine.Default__Info
// (Public, ClassDefaultObject, ArchetypeObject)

class AInfo* AInfo::GetDefaultObj()
{
	static class AInfo* Default = nullptr;

	if (!Default)
		Default = static_cast<AInfo*>(AInfo::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.GameModeBase
// (Actor)

class UClass* AGameModeBase::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("GameModeBase");

	return Clss;
}


// GameModeBase Engine.Default__GameModeBase
// (Public, ClassDefaultObject, ArchetypeObject)

class AGameModeBase* AGameModeBase::GetDefaultObj()
{
	static class AGameModeBase* Default = nullptr;

	if (!Default)
		Default = static_cast<AGameModeBase*>(AGameModeBase::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.GameModeBase.StartPlay
// (Native, Public, BlueprintCallable)
// Parameters:

void AGameModeBase::StartPlay()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "StartPlay");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.SpawnDefaultPawnFor
// (Native, Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      StartSpot                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class APawn*                       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APawn* AGameModeBase::SpawnDefaultPawnFor(class AController* NewPlayer, class AActor* StartSpot)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "SpawnDefaultPawnFor");

	Params::AGameModeBase_SpawnDefaultPawnFor_Params Parms{};

	Parms.NewPlayer = NewPlayer;
	Parms.StartSpot = StartSpot;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.SpawnDefaultPawnAtTransform
// (Native, Event, Public, HasOutParams, HasDefaults, BlueprintEvent)
// Parameters:
// class AController*                 NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  SpawnTransform                                                   (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class APawn*                       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APawn* AGameModeBase::SpawnDefaultPawnAtTransform(class AController* NewPlayer, struct FTransform& SpawnTransform)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "SpawnDefaultPawnAtTransform");

	Params::AGameModeBase_SpawnDefaultPawnAtTransform_Params Parms{};

	Parms.NewPlayer = NewPlayer;
	Parms.SpawnTransform = SpawnTransform;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.ShouldReset
// (Native, Event, Public, BlueprintEvent)
// Parameters:
// class AActor*                      ActorToReset                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameModeBase::ShouldReset(class AActor* ActorToReset)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "ShouldReset");

	Params::AGameModeBase_ShouldReset_Params Parms{};

	Parms.ActorToReset = ActorToReset;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.ReturnToMainMenuHost
// (Native, Public, BlueprintCallable)
// Parameters:

void AGameModeBase::ReturnToMainMenuHost()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "ReturnToMainMenuHost");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.RestartPlayerAtTransform
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable)
// Parameters:
// class AController*                 NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FTransform                  SpawnTransform                                                   (ConstParm, Parm, OutParm, ReferenceParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::RestartPlayerAtTransform(class AController* NewPlayer, struct FTransform& SpawnTransform)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "RestartPlayerAtTransform");

	Params::AGameModeBase_RestartPlayerAtTransform_Params Parms{};

	Parms.NewPlayer = NewPlayer;
	Parms.SpawnTransform = SpawnTransform;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.RestartPlayerAtPlayerStart
// (Native, Public, BlueprintCallable)
// Parameters:
// class AController*                 NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      StartSpot                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::RestartPlayerAtPlayerStart(class AController* NewPlayer, class AActor* StartSpot)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "RestartPlayerAtPlayerStart");

	Params::AGameModeBase_RestartPlayerAtPlayerStart_Params Parms{};

	Parms.NewPlayer = NewPlayer;
	Parms.StartSpot = StartSpot;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.RestartPlayer
// (Native, Public, BlueprintCallable)
// Parameters:
// class AController*                 NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::RestartPlayer(class AController* NewPlayer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "RestartPlayer");

	Params::AGameModeBase_RestartPlayer_Params Parms{};

	Parms.NewPlayer = NewPlayer;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.ResetLevel
// (Native, Public, BlueprintCallable)
// Parameters:

void AGameModeBase::ResetLevel()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "ResetLevel");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.PlayerCanRestart
// (Native, Event, Public, BlueprintCallable, BlueprintEvent)
// Parameters:
// class APlayerController*           Player                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameModeBase::PlayerCanRestart(class APlayerController* Player)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "PlayerCanRestart");

	Params::AGameModeBase_PlayerCanRestart_Params Parms{};

	Parms.Player = Player;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.MustSpectate
// (Native, Event, Public, BlueprintEvent, Const)
// Parameters:
// class APlayerController*           NewPlayerController                                              (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameModeBase::MustSpectate(class APlayerController* NewPlayerController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "MustSpectate");

	Params::AGameModeBase_MustSpectate_Params Parms{};

	Parms.NewPlayerController = NewPlayerController;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.K2_PostLogin
// (Event, Public, BlueprintEvent)
// Parameters:
// class APlayerController*           NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::K2_PostLogin(class APlayerController* NewPlayer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "K2_PostLogin");

	Params::AGameModeBase_K2_PostLogin_Params Parms{};

	Parms.NewPlayer = NewPlayer;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameModeBase.K2_OnSwapPlayerControllers
// (Event, Protected, BlueprintEvent)
// Parameters:
// class APlayerController*           OldPC                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class APlayerController*           NewPC                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::K2_OnSwapPlayerControllers(class APlayerController* OldPC, class APlayerController* NewPC)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "K2_OnSwapPlayerControllers");

	Params::AGameModeBase_K2_OnSwapPlayerControllers_Params Parms{};

	Parms.OldPC = OldPC;
	Parms.NewPC = NewPC;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameModeBase.K2_OnRestartPlayer
// (Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::K2_OnRestartPlayer(class AController* NewPlayer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "K2_OnRestartPlayer");

	Params::AGameModeBase_K2_OnRestartPlayer_Params Parms{};

	Parms.NewPlayer = NewPlayer;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameModeBase.K2_OnLogout
// (Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 ExitingController                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::K2_OnLogout(class AController* ExitingController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "K2_OnLogout");

	Params::AGameModeBase_K2_OnLogout_Params Parms{};

	Parms.ExitingController = ExitingController;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameModeBase.K2_OnChangeName
// (Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 Other                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FString                      NewName                                                          (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNameChange                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::K2_OnChangeName(class AController* Other, const class FString& NewName, bool bNameChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "K2_OnChangeName");

	Params::AGameModeBase_K2_OnChangeName_Params Parms{};

	Parms.Other = Other;
	Parms.NewName = NewName;
	Parms.bNameChange = bNameChange;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameModeBase.K2_FindPlayerStart
// (Final, Native, Public, BlueprintCallable, BlueprintPure)
// Parameters:
// class AController*                 Player                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FString                      IncomingName                                                     (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* AGameModeBase::K2_FindPlayerStart(class AController* Player, const class FString& IncomingName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "K2_FindPlayerStart");

	Params::AGameModeBase_K2_FindPlayerStart_Params Parms{};

	Parms.Player = Player;
	Parms.IncomingName = IncomingName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.InitStartSpot
// (Native, Event, Public, BlueprintEvent)
// Parameters:
// class AActor*                      StartSpot                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AController*                 NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::InitStartSpot(class AActor* StartSpot, class AController* NewPlayer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "InitStartSpot");

	Params::AGameModeBase_InitStartSpot_Params Parms{};

	Parms.StartSpot = StartSpot;
	Parms.NewPlayer = NewPlayer;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.InitializeHUDForPlayer
// (Native, Event, Protected, BlueprintEvent)
// Parameters:
// class APlayerController*           NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::InitializeHUDForPlayer(class APlayerController* NewPlayer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "InitializeHUDForPlayer");

	Params::AGameModeBase_InitializeHUDForPlayer_Params Parms{};

	Parms.NewPlayer = NewPlayer;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.HasMatchStarted
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameModeBase::HasMatchStarted()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "HasMatchStarted");

	Params::AGameModeBase_HasMatchStarted_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.HasMatchEnded
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameModeBase::HasMatchEnded()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "HasMatchEnded");

	Params::AGameModeBase_HasMatchEnded_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.HandleStartingNewPlayer
// (Native, Event, Public, BlueprintEvent)
// Parameters:
// class APlayerController*           NewPlayer                                                        (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::HandleStartingNewPlayer(class APlayerController* NewPlayer)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "HandleStartingNewPlayer");

	Params::AGameModeBase_HandleStartingNewPlayer_Params Parms{};

	Parms.NewPlayer = NewPlayer;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.GetNumSpectators
// (Native, Public, BlueprintCallable)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 AGameModeBase::GetNumSpectators()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "GetNumSpectators");

	Params::AGameModeBase_GetNumSpectators_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.GetNumPlayers
// (Native, Public, BlueprintCallable)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 AGameModeBase::GetNumPlayers()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "GetNumPlayers");

	Params::AGameModeBase_GetNumPlayers_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.GetDefaultPawnClassForController
// (Native, Event, Public, BlueprintCallable, BlueprintEvent)
// Parameters:
// class AController*                 InController                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UClass*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UClass* AGameModeBase::GetDefaultPawnClassForController(class AController* InController)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "GetDefaultPawnClassForController");

	Params::AGameModeBase_GetDefaultPawnClassForController_Params Parms{};

	Parms.InController = InController;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.FindPlayerStart
// (Native, Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 Player                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FString                      IncomingName                                                     (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* AGameModeBase::FindPlayerStart(class AController* Player, const class FString& IncomingName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "FindPlayerStart");

	Params::AGameModeBase_FindPlayerStart_Params Parms{};

	Parms.Player = Player;
	Parms.IncomingName = IncomingName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.ChoosePlayerStart
// (Native, Event, Public, BlueprintEvent)
// Parameters:
// class AController*                 Player                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* AGameModeBase::ChoosePlayerStart(class AController* Player)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "ChoosePlayerStart");

	Params::AGameModeBase_ChoosePlayerStart_Params Parms{};

	Parms.Player = Player;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameModeBase.ChangeName
// (Native, Public, BlueprintCallable)
// Parameters:
// class AController*                 Controller                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FString                      NewName                                                          (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNameChange                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameModeBase::ChangeName(class AController* Controller, const class FString& NewName, bool bNameChange)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "ChangeName");

	Params::AGameModeBase_ChangeName_Params Parms{};

	Parms.Controller = Controller;
	Parms.NewName = NewName;
	Parms.bNameChange = bNameChange;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameModeBase.CanSpectate
// (Native, Event, Public, BlueprintEvent)
// Parameters:
// class APlayerController*           Viewer                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class APlayerState*                ViewTarget                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameModeBase::CanSpectate(class APlayerController* Viewer, class APlayerState* ViewTarget)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameModeBase", "CanSpectate");

	Params::AGameModeBase_CanSpectate_Params Parms{};

	Parms.Viewer = Viewer;
	Parms.ViewTarget = ViewTarget;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.GameMode
// (Actor)

class UClass* AGameMode::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("GameMode");

	return Clss;
}


// GameMode Engine.Default__GameMode
// (Public, ClassDefaultObject, ArchetypeObject)

class AGameMode* AGameMode::GetDefaultObj()
{
	static class AGameMode* Default = nullptr;

	if (!Default)
		Default = static_cast<AGameMode*>(AGameMode::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.GameMode.StartMatch
// (Native, Public, BlueprintCallable)
// Parameters:

void AGameMode::StartMatch()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "StartMatch");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameMode.Say
// (Exec, Native, Public, BlueprintCallable)
// Parameters:
// class FString                      Msg                                                              (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameMode::Say(const class FString& Msg)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "Say");

	Params::AGameMode_Say_Params Parms{};

	Parms.Msg = Msg;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameMode.RestartGame
// (Native, Public, BlueprintCallable)
// Parameters:

void AGameMode::RestartGame()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "RestartGame");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameMode.ReadyToStartMatch
// (Native, Event, Protected, BlueprintEvent)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameMode::ReadyToStartMatch()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "ReadyToStartMatch");

	Params::AGameMode_ReadyToStartMatch_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameMode.ReadyToEndMatch
// (Native, Event, Protected, BlueprintEvent)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameMode::ReadyToEndMatch()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "ReadyToEndMatch");

	Params::AGameMode_ReadyToEndMatch_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameMode.K2_OnSetMatchState
// (Event, Protected, BlueprintEvent)
// Parameters:
// class FName                        NewState                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void AGameMode::K2_OnSetMatchState(class FName NewState)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "K2_OnSetMatchState");

	Params::AGameMode_K2_OnSetMatchState_Params Parms{};

	Parms.NewState = NewState;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.GameMode.IsMatchInProgress
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameMode::IsMatchInProgress()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "IsMatchInProgress");

	Params::AGameMode_IsMatchInProgress_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameMode.GetMatchState
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FName                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FName AGameMode::GetMatchState()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "GetMatchState");

	Params::AGameMode_GetMatchState_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameMode.EndMatch
// (Native, Public, BlueprintCallable)
// Parameters:

void AGameMode::EndMatch()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "EndMatch");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameMode.AbortMatch
// (Native, Public, BlueprintCallable)
// Parameters:

void AGameMode::AbortMatch()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameMode", "AbortMatch");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Class Engine.GameStateBase
// (Actor)

class UClass* AGameStateBase::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("GameStateBase");

	return Clss;
}


// GameStateBase Engine.Default__GameStateBase
// (Public, ClassDefaultObject, ArchetypeObject)

class AGameStateBase* AGameStateBase::GetDefaultObj()
{
	static class AGameStateBase* Default = nullptr;

	if (!Default)
		Default = static_cast<AGameStateBase*>(AGameStateBase::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.GameStateBase.OnRep_SpectatorClass
// (Native, Protected)
// Parameters:

void AGameStateBase::OnRep_SpectatorClass()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "OnRep_SpectatorClass");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameStateBase.OnRep_ReplicatedWorldTimeSeconds
// (Native, Protected)
// Parameters:

void AGameStateBase::OnRep_ReplicatedWorldTimeSeconds()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "OnRep_ReplicatedWorldTimeSeconds");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameStateBase.OnRep_ReplicatedHasBegunPlay
// (Native, Protected)
// Parameters:

void AGameStateBase::OnRep_ReplicatedHasBegunPlay()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "OnRep_ReplicatedHasBegunPlay");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameStateBase.OnRep_GameModeClass
// (Native, Protected)
// Parameters:

void AGameStateBase::OnRep_GameModeClass()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "OnRep_GameModeClass");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameStateBase.HasMatchStarted
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameStateBase::HasMatchStarted()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "HasMatchStarted");

	Params::AGameStateBase_HasMatchStarted_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameStateBase.HasMatchEnded
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameStateBase::HasMatchEnded()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "HasMatchEnded");

	Params::AGameStateBase_HasMatchEnded_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameStateBase.HasBegunPlay
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool AGameStateBase::HasBegunPlay()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "HasBegunPlay");

	Params::AGameStateBase_HasBegunPlay_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameStateBase.GetServerWorldTimeSeconds
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AGameStateBase::GetServerWorldTimeSeconds()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "GetServerWorldTimeSeconds");

	Params::AGameStateBase_GetServerWorldTimeSeconds_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameStateBase.GetPlayerStartTime
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AController*                 Controller                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AGameStateBase::GetPlayerStartTime(class AController* Controller)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "GetPlayerStartTime");

	Params::AGameStateBase_GetPlayerStartTime_Params Parms{};

	Parms.Controller = Controller;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.GameStateBase.GetPlayerRespawnDelay
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AController*                 Controller                                                       (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float AGameStateBase::GetPlayerRespawnDelay(class AController* Controller)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameStateBase", "GetPlayerRespawnDelay");

	Params::AGameStateBase_GetPlayerRespawnDelay_Params Parms{};

	Parms.Controller = Controller;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.GameState
// (Actor)

class UClass* AGameState::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("GameState");

	return Clss;
}


// GameState Engine.Default__GameState
// (Public, ClassDefaultObject, ArchetypeObject)

class AGameState* AGameState::GetDefaultObj()
{
	static class AGameState* Default = nullptr;

	if (!Default)
		Default = static_cast<AGameState*>(AGameState::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.GameState.OnRep_MatchState
// (Native, Public)
// Parameters:

void AGameState::OnRep_MatchState()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameState", "OnRep_MatchState");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameState.OnRep_ElapsedTime
// (Native, Public)
// Parameters:

void AGameState::OnRep_ElapsedTime()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameState", "OnRep_ElapsedTime");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Class Engine.PlayerController
// (Actor, PlayerController)

class UClass* APlayerController::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("PlayerController");

	return Clss;
}


// PlayerController Engine.Default__PlayerController
// (Public, ClassDefaultObject, ArchetypeObject)

class APlayerController* APlayerController::GetDefaultObj()
{
	static class APlayerController* Default = nullptr;

	if (!Default)
		Default = static_cast<APlayerController*>(APlayerController::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.PlayerController.WasInputKeyJustReleased
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        Key                                                              (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::WasInputKeyJustReleased(const struct FKey& Key)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "WasInputKeyJustReleased");

	Params::APlayerController_WasInputKeyJustReleased_Params Parms{};

	Parms.Key = Key;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.WasInputKeyJustPressed
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        Key                                                              (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::WasInputKeyJustPressed(const struct FKey& Key)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "WasInputKeyJustPressed");

	Params::APlayerController_WasInputKeyJustPressed_Params Parms{};

	Parms.Key = Key;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.ToggleSpeaking
// (Exec, Native, Public)
// Parameters:
// bool                               bInSpeaking                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ToggleSpeaking(bool bInSpeaking)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ToggleSpeaking");

	Params::APlayerController_ToggleSpeaking_Params Parms{};

	Parms.bInSpeaking = bInSpeaking;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.TestServerLevelVisibilityChange
// (Final, Exec, Native, Private)
// Parameters:
// class FName                        PackageName                                                      (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        Filename                                                         (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::TestServerLevelVisibilityChange(class FName PackageName, class FName Filename)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "TestServerLevelVisibilityChange");

	Params::APlayerController_TestServerLevelVisibilityChange_Params Parms{};

	Parms.PackageName = PackageName;
	Parms.Filename = Filename;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SwitchLevel
// (Exec, Native, Public)
// Parameters:
// class FString                      URL                                                              (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SwitchLevel(const class FString& URL)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SwitchLevel");

	Params::APlayerController_SwitchLevel_Params Parms{};

	Parms.URL = URL;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.StreamingSourceShouldBlockOnSlowStreaming
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::StreamingSourceShouldBlockOnSlowStreaming()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "StreamingSourceShouldBlockOnSlowStreaming");

	Params::APlayerController_StreamingSourceShouldBlockOnSlowStreaming_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.StreamingSourceShouldActivate
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::StreamingSourceShouldActivate()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "StreamingSourceShouldActivate");

	Params::APlayerController_StreamingSourceShouldActivate_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.StopHapticEffect
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class EControllerHand         Hand                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::StopHapticEffect(enum class EControllerHand Hand)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "StopHapticEffect");

	Params::APlayerController_StopHapticEffect_Params Parms{};

	Parms.Hand = Hand;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.StartFire
// (Exec, Native, Public)
// Parameters:
// uint8                              FireModeNum                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::StartFire(uint8 FireModeNum)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "StartFire");

	Params::APlayerController_StartFire_Params Parms{};

	Parms.FireModeNum = FireModeNum;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetVirtualJoystickVisibility
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bVisible                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetVirtualJoystickVisibility(bool bVisible)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetVirtualJoystickVisibility");

	Params::APlayerController_SetVirtualJoystickVisibility_Params Parms{};

	Parms.bVisible = bVisible;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetViewTargetWithBlend
// (Native, Public, BlueprintCallable)
// Parameters:
// class AActor*                      NewViewTarget                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              BlendTime                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EViewTargetBlendFunctionBlendFunc                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              BlendExp                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bLockOutgoing                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetViewTargetWithBlend(class AActor* NewViewTarget, float BlendTime, enum class EViewTargetBlendFunction BlendFunc, float BlendExp, bool bLockOutgoing)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetViewTargetWithBlend");

	Params::APlayerController_SetViewTargetWithBlend_Params Parms{};

	Parms.NewViewTarget = NewViewTarget;
	Parms.BlendTime = BlendTime;
	Parms.BlendFunc = BlendFunc;
	Parms.BlendExp = BlendExp;
	Parms.bLockOutgoing = bLockOutgoing;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetName
// (Exec, Native, Public)
// Parameters:
// class FString                      S                                                                (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetName(const class FString& S)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetName");

	Params::APlayerController_SetName_Params Parms{};

	Parms.S = S;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetMouseLocation
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// int32                              X                                                                (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              Y                                                                (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetMouseLocation(int32 X, int32 Y)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetMouseLocation");

	Params::APlayerController_SetMouseLocation_Params Parms{};

	Parms.X = X;
	Parms.Y = Y;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetMouseCursorWidget
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class EMouseCursor            Cursor                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UUserWidget*                 CursorWidget                                                     (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetMouseCursorWidget(enum class EMouseCursor Cursor, class UUserWidget* CursorWidget)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetMouseCursorWidget");

	Params::APlayerController_SetMouseCursorWidget_Params Parms{};

	Parms.Cursor = Cursor;
	Parms.CursorWidget = CursorWidget;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetMotionControlsEnabled
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bEnabled                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetMotionControlsEnabled(bool bEnabled)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetMotionControlsEnabled");

	Params::APlayerController_SetMotionControlsEnabled_Params Parms{};

	Parms.bEnabled = bEnabled;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetHapticsByValue
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              Frequency                                                        (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Amplitude                                                        (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EControllerHand         Hand                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetHapticsByValue(float Frequency, float Amplitude, enum class EControllerHand Hand)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetHapticsByValue");

	Params::APlayerController_SetHapticsByValue_Params Parms{};

	Parms.Frequency = Frequency;
	Parms.Amplitude = Amplitude;
	Parms.Hand = Hand;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetDisableHaptics
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewDisabled                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetDisableHaptics(bool bNewDisabled)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetDisableHaptics");

	Params::APlayerController_SetDisableHaptics_Params Parms{};

	Parms.bNewDisabled = bNewDisabled;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetDeprecatedInputYawScale
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewValue                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetDeprecatedInputYawScale(float NewValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetDeprecatedInputYawScale");

	Params::APlayerController_SetDeprecatedInputYawScale_Params Parms{};

	Parms.NewValue = NewValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetDeprecatedInputRollScale
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewValue                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetDeprecatedInputRollScale(float NewValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetDeprecatedInputRollScale");

	Params::APlayerController_SetDeprecatedInputRollScale_Params Parms{};

	Parms.NewValue = NewValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetDeprecatedInputPitchScale
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              NewValue                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetDeprecatedInputPitchScale(float NewValue)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetDeprecatedInputPitchScale");

	Params::APlayerController_SetDeprecatedInputPitchScale_Params Parms{};

	Parms.NewValue = NewValue;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetControllerLightColor
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// struct FColor                      Color                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetControllerLightColor(const struct FColor& Color)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetControllerLightColor");

	Params::APlayerController_SetControllerLightColor_Params Parms{};

	Parms.Color = Color;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetCinematicMode
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInCinematicMode                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bHidePlayer                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsHUD                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsMovement                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsTurning                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetCinematicMode(bool bInCinematicMode, bool bHidePlayer, bool bAffectsHUD, bool bAffectsMovement, bool bAffectsTurning)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetCinematicMode");

	Params::APlayerController_SetCinematicMode_Params Parms{};

	Parms.bInCinematicMode = bInCinematicMode;
	Parms.bHidePlayer = bHidePlayer;
	Parms.bAffectsHUD = bAffectsHUD;
	Parms.bAffectsMovement = bAffectsMovement;
	Parms.bAffectsTurning = bAffectsTurning;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetAudioListenerOverride
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class USceneComponent*             AttachToComponent                                                (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Location                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    Rotation                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::SetAudioListenerOverride(class USceneComponent* AttachToComponent, const struct FVector& Location, const struct FRotator& Rotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetAudioListenerOverride");

	Params::APlayerController_SetAudioListenerOverride_Params Parms{};

	Parms.AttachToComponent = AttachToComponent;
	Parms.Location = Location;
	Parms.Rotation = Rotation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SetAudioListenerAttenuationOverride
// (Final, Native, Public, HasDefaults, BlueprintCallable)
// Parameters:
// class USceneComponent*             AttachToComponent                                                (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     AttenuationLocationOVerride                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SetAudioListenerAttenuationOverride(class USceneComponent* AttachToComponent, const struct FVector& AttenuationLocationOVerride)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SetAudioListenerAttenuationOverride");

	Params::APlayerController_SetAudioListenerAttenuationOverride_Params Parms{};

	Parms.AttachToComponent = AttachToComponent;
	Parms.AttenuationLocationOVerride = AttenuationLocationOVerride;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerViewSelf
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FViewTargetTransitionParams TransitionParams                                                 (Parm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ServerViewSelf(const struct FViewTargetTransitionParams& TransitionParams)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerViewSelf");

	Params::APlayerController_ServerViewSelf_Params Parms{};

	Parms.TransitionParams = TransitionParams;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerViewPrevPlayer
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerViewPrevPlayer()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerViewPrevPlayer");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerViewNextPlayer
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerViewNextPlayer()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerViewNextPlayer");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerVerifyViewTarget
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerVerifyViewTarget()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerVerifyViewTarget");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerUpdateMultipleLevelsVisibility
// (Final, Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// TArray<struct FUpdateLevelVisibilityLevelInfo>LevelVisibilities                                                (ConstParm, Parm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void APlayerController::ServerUpdateMultipleLevelsVisibility(TArray<struct FUpdateLevelVisibilityLevelInfo>& LevelVisibilities)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerUpdateMultipleLevelsVisibility");

	Params::APlayerController_ServerUpdateMultipleLevelsVisibility_Params Parms{};

	Parms.LevelVisibilities = LevelVisibilities;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerUpdateLevelVisibility
// (Final, Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FUpdateLevelVisibilityLevelInfoLevelVisibility                                                  (ConstParm, Parm, ReferenceParm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ServerUpdateLevelVisibility(struct FUpdateLevelVisibilityLevelInfo& LevelVisibility)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerUpdateLevelVisibility");

	Params::APlayerController_ServerUpdateLevelVisibility_Params Parms{};

	Parms.LevelVisibility = LevelVisibility;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerUpdateCamera
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FVector_NetQuantize         CamLoc                                                           (Parm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              CamPitchAndYaw                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerUpdateCamera(const struct FVector_NetQuantize& CamLoc, int32 CamPitchAndYaw)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerUpdateCamera");

	Params::APlayerController_ServerUpdateCamera_Params Parms{};

	Parms.CamLoc = CamLoc;
	Parms.CamPitchAndYaw = CamPitchAndYaw;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerUnmutePlayer
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FUniqueNetIdRepl            PlayerId                                                         (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerUnmutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerUnmutePlayer");

	Params::APlayerController_ServerUnmutePlayer_Params Parms{};

	Parms.PlayerId = PlayerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerUnblockPlayer
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FUniqueNetIdRepl            PlayerId                                                         (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerUnblockPlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerUnblockPlayer");

	Params::APlayerController_ServerUnblockPlayer_Params Parms{};

	Parms.PlayerId = PlayerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerToggleAILogging
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerToggleAILogging()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerToggleAILogging");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerShortTimeout
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerShortTimeout()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerShortTimeout");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerSetSpectatorWaiting
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// bool                               bWaiting                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerSetSpectatorWaiting(bool bWaiting)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerSetSpectatorWaiting");

	Params::APlayerController_ServerSetSpectatorWaiting_Params Parms{};

	Parms.bWaiting = bWaiting;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerSetSpectatorLocation
// (Net, Native, Event, Public, NetServer, HasDefaults, NetValidate)
// Parameters:
// struct FVector                     NewLoc                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    NewRot                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ServerSetSpectatorLocation(const struct FVector& NewLoc, const struct FRotator& NewRot)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerSetSpectatorLocation");

	Params::APlayerController_ServerSetSpectatorLocation_Params Parms{};

	Parms.NewLoc = NewLoc;
	Parms.NewRot = NewRot;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerSendLatestAsyncPhysicsTimestamp
// (Final, Net, Native, Event, Private, NetServer)
// Parameters:
// struct FAsyncPhysicsTimestamp      Timestamp                                                        (Parm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ServerSendLatestAsyncPhysicsTimestamp(const struct FAsyncPhysicsTimestamp& Timestamp)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerSendLatestAsyncPhysicsTimestamp");

	Params::APlayerController_ServerSendLatestAsyncPhysicsTimestamp_Params Parms{};

	Parms.Timestamp = Timestamp;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerRestartPlayer
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerRestartPlayer()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerRestartPlayer");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerRecvClientInputFrame
// (Net, Native, Event, Public, NetServer)
// Parameters:
// int32                              RecvClientInputFrame                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<uint8>                      Data                                                             (ConstParm, Parm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void APlayerController::ServerRecvClientInputFrame(int32 RecvClientInputFrame, TArray<uint8>& Data)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerRecvClientInputFrame");

	Params::APlayerController_ServerRecvClientInputFrame_Params Parms{};

	Parms.RecvClientInputFrame = RecvClientInputFrame;
	Parms.Data = Data;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerPause
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerPause()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerPause");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerNotifyLoadedWorld
// (Final, Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// class FName                        WorldPackageName                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerNotifyLoadedWorld(class FName WorldPackageName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerNotifyLoadedWorld");

	Params::APlayerController_ServerNotifyLoadedWorld_Params Parms{};

	Parms.WorldPackageName = WorldPackageName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerMutePlayer
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FUniqueNetIdRepl            PlayerId                                                         (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerMutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerMutePlayer");

	Params::APlayerController_ServerMutePlayer_Params Parms{};

	Parms.PlayerId = PlayerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerExecRPC
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// class FString                      Msg                                                              (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerExecRPC(const class FString& Msg)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerExecRPC");

	Params::APlayerController_ServerExecRPC_Params Parms{};

	Parms.Msg = Msg;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerExec
// (Final, Exec, Native, Public)
// Parameters:
// class FString                      Msg                                                              (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerExec(const class FString& Msg)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerExec");

	Params::APlayerController_ServerExec_Params Parms{};

	Parms.Msg = Msg;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerCheckClientPossessionReliable
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerCheckClientPossessionReliable()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerCheckClientPossessionReliable");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerCheckClientPossession
// (Net, Native, Event, Public, NetServer, NetValidate)
// Parameters:

void APlayerController::ServerCheckClientPossession()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerCheckClientPossession");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerChangeName
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// class FString                      S                                                                (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerChangeName(const class FString& S)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerChangeName");

	Params::APlayerController_ServerChangeName_Params Parms{};

	Parms.S = S;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerCamera
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// class FName                        NewMode                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerCamera(class FName NewMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerCamera");

	Params::APlayerController_ServerCamera_Params Parms{};

	Parms.NewMode = NewMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerBlockPlayer
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// struct FUniqueNetIdRepl            PlayerId                                                         (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerBlockPlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerBlockPlayer");

	Params::APlayerController_ServerBlockPlayer_Params Parms{};

	Parms.PlayerId = PlayerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ServerAcknowledgePossession
// (Net, NetReliable, Native, Event, Public, NetServer, NetValidate)
// Parameters:
// class APawn*                       P                                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ServerAcknowledgePossession(class APawn* P)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ServerAcknowledgePossession");

	Params::APlayerController_ServerAcknowledgePossession_Params Parms{};

	Parms.P = P;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.SendToConsole
// (Exec, Native, Public)
// Parameters:
// class FString                      Command                                                          (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::SendToConsole(const class FString& Command)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "SendToConsole");

	Params::APlayerController_SendToConsole_Params Parms{};

	Parms.Command = Command;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.RestartLevel
// (Exec, Native, Public)
// Parameters:

void APlayerController::RestartLevel()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "RestartLevel");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ResetControllerLightColor
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void APlayerController::ResetControllerLightColor()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ResetControllerLightColor");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ProjectWorldLocationToScreen
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector2D                   ScreenLocation                                                   (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPlayerViewportRelative                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::ProjectWorldLocationToScreen(const struct FVector& WorldLocation, struct FVector2D* ScreenLocation, bool bPlayerViewportRelative)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ProjectWorldLocationToScreen");

	Params::APlayerController_ProjectWorldLocationToScreen_Params Parms{};

	Parms.WorldLocation = WorldLocation;
	Parms.bPlayerViewportRelative = bPlayerViewportRelative;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (ScreenLocation != nullptr)
		*ScreenLocation = std::move(Parms.ScreenLocation);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.PlayHapticEffect
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UHapticFeedbackEffect_Base*  HapticEffect                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EControllerHand         Hand                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Scale                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bLoop                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::PlayHapticEffect(class UHapticFeedbackEffect_Base* HapticEffect, enum class EControllerHand Hand, float Scale, bool bLoop)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "PlayHapticEffect");

	Params::APlayerController_PlayHapticEffect_Params Parms{};

	Parms.HapticEffect = HapticEffect;
	Parms.Hand = Hand;
	Parms.Scale = Scale;
	Parms.bLoop = bLoop;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.PlayDynamicForceFeedback
// (Final, Native, Private, BlueprintCallable)
// Parameters:
// float                              Intensity                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Duration                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsLeftLarge                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsLeftSmall                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsRightLarge                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsRightSmall                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class EDynamicForceFeedbackActionAction                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FLatentActionInfo           LatentInfo                                                       (Parm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::PlayDynamicForceFeedback(float Intensity, float Duration, bool bAffectsLeftLarge, bool bAffectsLeftSmall, bool bAffectsRightLarge, bool bAffectsRightSmall, enum class EDynamicForceFeedbackAction Action, const struct FLatentActionInfo& LatentInfo)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "PlayDynamicForceFeedback");

	Params::APlayerController_PlayDynamicForceFeedback_Params Parms{};

	Parms.Intensity = Intensity;
	Parms.Duration = Duration;
	Parms.bAffectsLeftLarge = bAffectsLeftLarge;
	Parms.bAffectsLeftSmall = bAffectsLeftSmall;
	Parms.bAffectsRightLarge = bAffectsRightLarge;
	Parms.bAffectsRightSmall = bAffectsRightSmall;
	Parms.Action = Action;
	Parms.LatentInfo = LatentInfo;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.Pause
// (Exec, Native, Public)
// Parameters:

void APlayerController::Pause()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "Pause");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.OnServerStartedVisualLogger
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// bool                               bIsLogging                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::OnServerStartedVisualLogger(bool bIsLogging)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "OnServerStartedVisualLogger");

	Params::APlayerController_OnServerStartedVisualLogger_Params Parms{};

	Parms.bIsLogging = bIsLogging;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.OnRep_AsyncPhysicsDataComponent
// (Final, Native, Private)
// Parameters:

void APlayerController::OnRep_AsyncPhysicsDataComponent()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "OnRep_AsyncPhysicsDataComponent");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.LocalTravel
// (Exec, Native, Public)
// Parameters:
// class FString                      URL                                                              (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::LocalTravel(const class FString& URL)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "LocalTravel");

	Params::APlayerController_LocalTravel_Params Parms{};

	Parms.URL = URL;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.K2_ClientPlayForceFeedback
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UForceFeedbackEffect*        ForceFeedbackEffect                                              (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        Tag                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bLooping                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bIgnoreTimeDilation                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bPlayWhilePaused                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, AdvancedDisplay, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::K2_ClientPlayForceFeedback(class UForceFeedbackEffect* ForceFeedbackEffect, class FName Tag, bool bLooping, bool bIgnoreTimeDilation, bool bPlayWhilePaused)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "K2_ClientPlayForceFeedback");

	Params::APlayerController_K2_ClientPlayForceFeedback_Params Parms{};

	Parms.ForceFeedbackEffect = ForceFeedbackEffect;
	Parms.Tag = Tag;
	Parms.bLooping = bLooping;
	Parms.bIgnoreTimeDilation = bIgnoreTimeDilation;
	Parms.bPlayWhilePaused = bPlayWhilePaused;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.IsStreamingSourceEnabled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::IsStreamingSourceEnabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "IsStreamingSourceEnabled");

	Params::APlayerController_IsStreamingSourceEnabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.IsInputKeyDown
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        Key                                                              (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::IsInputKeyDown(const struct FKey& Key)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "IsInputKeyDown");

	Params::APlayerController_IsInputKeyDown_Params Parms{};

	Parms.Key = Key;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetViewportSize
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              SizeX                                                            (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              SizeY                                                            (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::GetViewportSize(int32* SizeX, int32* SizeY)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetViewportSize");

	Params::APlayerController_GetViewportSize_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (SizeX != nullptr)
		*SizeX = Parms.SizeX;

	if (SizeY != nullptr)
		*SizeY = Parms.SizeY;

}


// Function Engine.PlayerController.GetStreamingSourceShapes
// (Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<struct FStreamingSourceShape>OutShapes                                                        (Parm, OutParm, ZeroConstructor, NativeAccessSpecifierPublic)

void APlayerController::GetStreamingSourceShapes(TArray<struct FStreamingSourceShape>* OutShapes)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetStreamingSourceShapes");

	Params::APlayerController_GetStreamingSourceShapes_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutShapes != nullptr)
		*OutShapes = std::move(Parms.OutShapes);

}


// Function Engine.PlayerController.GetStreamingSourcePriority
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class EStreamingSourcePriorityReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

enum class EStreamingSourcePriority APlayerController::GetStreamingSourcePriority()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetStreamingSourcePriority");

	Params::APlayerController_GetStreamingSourcePriority_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetStreamingSourceLocationAndRotation
// (Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     OutLocation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    OutRotation                                                      (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::GetStreamingSourceLocationAndRotation(struct FVector* OutLocation, struct FRotator* OutRotation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetStreamingSourceLocationAndRotation");

	Params::APlayerController_GetStreamingSourceLocationAndRotation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (OutLocation != nullptr)
		*OutLocation = std::move(Parms.OutLocation);

	if (OutRotation != nullptr)
		*OutRotation = std::move(Parms.OutRotation);

}


// Function Engine.PlayerController.GetSpectatorPawn
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class ASpectatorPawn*              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class ASpectatorPawn* APlayerController::GetSpectatorPawn()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetSpectatorPawn");

	Params::APlayerController_GetSpectatorPawn_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetPlatformUserId
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FPlatformUserId             ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FPlatformUserId APlayerController::GetPlatformUserId()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetPlatformUserId");

	Params::APlayerController_GetPlatformUserId_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetOverridePlayerInputClass
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TSubclassOf<class UPlayerInput>    ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

TSubclassOf<class UPlayerInput> APlayerController::GetOverridePlayerInputClass()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetOverridePlayerInputClass");

	Params::APlayerController_GetOverridePlayerInputClass_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetMousePosition
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              LocationX                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              LocationY                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::GetMousePosition(float* LocationX, float* LocationY)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetMousePosition");

	Params::APlayerController_GetMousePosition_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (LocationX != nullptr)
		*LocationX = Parms.LocationX;

	if (LocationY != nullptr)
		*LocationY = Parms.LocationY;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetInputVectorKeyState
// (Final, Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        Key                                                              (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector APlayerController::GetInputVectorKeyState(const struct FKey& Key)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetInputVectorKeyState");

	Params::APlayerController_GetInputVectorKeyState_Params Parms{};

	Parms.Key = Key;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetInputTouchState
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              LocationX                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              LocationY                                                        (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bIsCurrentlyPressed                                              (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::GetInputTouchState(enum class ETouchIndex FingerIndex, float* LocationX, float* LocationY, bool* bIsCurrentlyPressed)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetInputTouchState");

	Params::APlayerController_GetInputTouchState_Params Parms{};

	Parms.FingerIndex = FingerIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (LocationX != nullptr)
		*LocationX = Parms.LocationX;

	if (LocationY != nullptr)
		*LocationY = Parms.LocationY;

	if (bIsCurrentlyPressed != nullptr)
		*bIsCurrentlyPressed = Parms.bIsCurrentlyPressed;

}


// Function Engine.PlayerController.GetInputMouseDelta
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              DeltaX                                                           (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              DeltaY                                                           (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::GetInputMouseDelta(float* DeltaX, float* DeltaY)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetInputMouseDelta");

	Params::APlayerController_GetInputMouseDelta_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (DeltaX != nullptr)
		*DeltaX = Parms.DeltaX;

	if (DeltaY != nullptr)
		*DeltaY = Parms.DeltaY;

}


// Function Engine.PlayerController.GetInputMotionState
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     Tilt                                                             (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     RotationRate                                                     (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Gravity                                                          (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Acceleration                                                     (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::GetInputMotionState(struct FVector* Tilt, struct FVector* RotationRate, struct FVector* Gravity, struct FVector* Acceleration)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetInputMotionState");

	Params::APlayerController_GetInputMotionState_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (Tilt != nullptr)
		*Tilt = std::move(Parms.Tilt);

	if (RotationRate != nullptr)
		*RotationRate = std::move(Parms.RotationRate);

	if (Gravity != nullptr)
		*Gravity = std::move(Parms.Gravity);

	if (Acceleration != nullptr)
		*Acceleration = std::move(Parms.Acceleration);

}


// Function Engine.PlayerController.GetInputKeyTimeDown
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        Key                                                              (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float APlayerController::GetInputKeyTimeDown(const struct FKey& Key)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetInputKeyTimeDown");

	Params::APlayerController_GetInputKeyTimeDown_Params Parms{};

	Parms.Key = Key;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetInputAnalogStickState
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class EControllerAnalogStick  WhichStick                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              StickX                                                           (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              StickY                                                           (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::GetInputAnalogStickState(enum class EControllerAnalogStick WhichStick, float* StickX, float* StickY)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetInputAnalogStickState");

	Params::APlayerController_GetInputAnalogStickState_Params Parms{};

	Parms.WhichStick = WhichStick;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (StickX != nullptr)
		*StickX = Parms.StickX;

	if (StickY != nullptr)
		*StickY = Parms.StickY;

}


// Function Engine.PlayerController.GetInputAnalogKeyState
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FKey                        Key                                                              (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float APlayerController::GetInputAnalogKeyState(const struct FKey& Key)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetInputAnalogKeyState");

	Params::APlayerController_GetInputAnalogKeyState_Params Parms{};

	Parms.Key = Key;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetHUD
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AHUD*                        ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AHUD* APlayerController::GetHUD()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetHUD");

	Params::APlayerController_GetHUD_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetHitResultUnderFingerForObjects
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// TArray<enum class EObjectTypeQuery>ObjectTypes                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitResult                                                        (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::GetHitResultUnderFingerForObjects(enum class ETouchIndex FingerIndex, TArray<enum class EObjectTypeQuery>& ObjectTypes, bool bTraceComplex, struct FHitResult* HitResult)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetHitResultUnderFingerForObjects");

	Params::APlayerController_GetHitResultUnderFingerForObjects_Params Parms{};

	Parms.FingerIndex = FingerIndex;
	Parms.ObjectTypes = ObjectTypes;
	Parms.bTraceComplex = bTraceComplex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitResult != nullptr)
		*HitResult = std::move(Parms.HitResult);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetHitResultUnderFingerByChannel
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ETraceTypeQuery         TraceChannel                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitResult                                                        (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::GetHitResultUnderFingerByChannel(enum class ETouchIndex FingerIndex, enum class ETraceTypeQuery TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetHitResultUnderFingerByChannel");

	Params::APlayerController_GetHitResultUnderFingerByChannel_Params Parms{};

	Parms.FingerIndex = FingerIndex;
	Parms.TraceChannel = TraceChannel;
	Parms.bTraceComplex = bTraceComplex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitResult != nullptr)
		*HitResult = std::move(Parms.HitResult);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetHitResultUnderFinger
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ETouchIndex             FingerIndex                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ECollisionChannel       TraceChannel                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitResult                                                        (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::GetHitResultUnderFinger(enum class ETouchIndex FingerIndex, enum class ECollisionChannel TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetHitResultUnderFinger");

	Params::APlayerController_GetHitResultUnderFinger_Params Parms{};

	Parms.FingerIndex = FingerIndex;
	Parms.TraceChannel = TraceChannel;
	Parms.bTraceComplex = bTraceComplex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitResult != nullptr)
		*HitResult = std::move(Parms.HitResult);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetHitResultUnderCursorForObjects
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// TArray<enum class EObjectTypeQuery>ObjectTypes                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitResult                                                        (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::GetHitResultUnderCursorForObjects(TArray<enum class EObjectTypeQuery>& ObjectTypes, bool bTraceComplex, struct FHitResult* HitResult)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetHitResultUnderCursorForObjects");

	Params::APlayerController_GetHitResultUnderCursorForObjects_Params Parms{};

	Parms.ObjectTypes = ObjectTypes;
	Parms.bTraceComplex = bTraceComplex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitResult != nullptr)
		*HitResult = std::move(Parms.HitResult);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetHitResultUnderCursorByChannel
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ETraceTypeQuery         TraceChannel                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitResult                                                        (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::GetHitResultUnderCursorByChannel(enum class ETraceTypeQuery TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetHitResultUnderCursorByChannel");

	Params::APlayerController_GetHitResultUnderCursorByChannel_Params Parms{};

	Parms.TraceChannel = TraceChannel;
	Parms.bTraceComplex = bTraceComplex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitResult != nullptr)
		*HitResult = std::move(Parms.HitResult);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetHitResultUnderCursor
// (Final, Native, Public, HasOutParams, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// enum class ECollisionChannel       TraceChannel                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bTraceComplex                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FHitResult                  HitResult                                                        (Parm, OutParm, IsPlainOldData, NoDestructor, ContainsInstancedReference, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::GetHitResultUnderCursor(enum class ECollisionChannel TraceChannel, bool bTraceComplex, struct FHitResult* HitResult)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetHitResultUnderCursor");

	Params::APlayerController_GetHitResultUnderCursor_Params Parms{};

	Parms.TraceChannel = TraceChannel;
	Parms.bTraceComplex = bTraceComplex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (HitResult != nullptr)
		*HitResult = std::move(Parms.HitResult);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetFocalLocation
// (Native, Public, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FVector APlayerController::GetFocalLocation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetFocalLocation");

	Params::APlayerController_GetFocalLocation_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetDeprecatedInputYawScale
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float APlayerController::GetDeprecatedInputYawScale()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetDeprecatedInputYawScale");

	Params::APlayerController_GetDeprecatedInputYawScale_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetDeprecatedInputRollScale
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float APlayerController::GetDeprecatedInputRollScale()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetDeprecatedInputRollScale");

	Params::APlayerController_GetDeprecatedInputRollScale_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetDeprecatedInputPitchScale
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float APlayerController::GetDeprecatedInputPitchScale()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetDeprecatedInputPitchScale");

	Params::APlayerController_GetDeprecatedInputPitchScale_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetAsyncPhysicsDataToWrite
// (Final, Native, Protected, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UAsyncPhysicsData*           ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UAsyncPhysicsData* APlayerController::GetAsyncPhysicsDataToWrite()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetAsyncPhysicsDataToWrite");

	Params::APlayerController_GetAsyncPhysicsDataToWrite_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.GetAsyncPhysicsDataToConsume
// (Final, Native, Protected, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class UAsyncPhysicsData*           ReturnValue                                                      (ConstParm, Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class UAsyncPhysicsData* APlayerController::GetAsyncPhysicsDataToConsume()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "GetAsyncPhysicsDataToConsume");

	Params::APlayerController_GetAsyncPhysicsDataToConsume_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.FOV
// (Exec, Native, Public)
// Parameters:
// float                              NewFOV                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::FOV(float NewFOV)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "FOV");

	Params::APlayerController_FOV_Params Parms{};

	Parms.NewFOV = NewFOV;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.EnableCheats
// (Exec, Native, Public)
// Parameters:

void APlayerController::EnableCheats()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "EnableCheats");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.DeprojectScreenPositionToWorld
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ScreenX                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ScreenY                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     WorldLocation                                                    (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     WorldDirection                                                   (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::DeprojectScreenPositionToWorld(float ScreenX, float ScreenY, struct FVector* WorldLocation, struct FVector* WorldDirection)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "DeprojectScreenPositionToWorld");

	Params::APlayerController_DeprojectScreenPositionToWorld_Params Parms{};

	Parms.ScreenX = ScreenX;
	Parms.ScreenY = ScreenY;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (WorldLocation != nullptr)
		*WorldLocation = std::move(Parms.WorldLocation);

	if (WorldDirection != nullptr)
		*WorldDirection = std::move(Parms.WorldDirection);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.DeprojectMousePositionToWorld
// (Final, Native, Public, HasOutParams, HasDefaults, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FVector                     WorldLocation                                                    (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     WorldDirection                                                   (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::DeprojectMousePositionToWorld(struct FVector* WorldLocation, struct FVector* WorldDirection)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "DeprojectMousePositionToWorld");

	Params::APlayerController_DeprojectMousePositionToWorld_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	if (WorldLocation != nullptr)
		*WorldLocation = std::move(Parms.WorldLocation);

	if (WorldDirection != nullptr)
		*WorldDirection = std::move(Parms.WorldDirection);

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.ConsoleKey
// (Exec, Native, Public)
// Parameters:
// struct FKey                        Key                                                              (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ConsoleKey(const struct FKey& Key)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ConsoleKey");

	Params::APlayerController_ConsoleKey_Params Parms{};

	Parms.Key = Key;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientWasKicked
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FText                        KickReason                                                       (ConstParm, Parm, ReferenceParm, NativeAccessSpecifierPublic)

void APlayerController::ClientWasKicked(class FText& KickReason)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientWasKicked");

	Params::APlayerController_ClientWasKicked_Params Parms{};

	Parms.KickReason = KickReason;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientVoiceHandshakeComplete
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientVoiceHandshakeComplete()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientVoiceHandshakeComplete");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientUpdateMultipleLevelsStreamingStatus
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// TArray<struct FUpdateLevelStreamingLevelStatus>LevelStatuses                                                    (ConstParm, Parm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void APlayerController::ClientUpdateMultipleLevelsStreamingStatus(TArray<struct FUpdateLevelStreamingLevelStatus>& LevelStatuses)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientUpdateMultipleLevelsStreamingStatus");

	Params::APlayerController_ClientUpdateMultipleLevelsStreamingStatus_Params Parms{};

	Parms.LevelStatuses = LevelStatuses;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientUpdateLevelStreamingStatus
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FName                        PackageName                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNewShouldBeLoaded                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNewShouldBeVisible                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bNewShouldBlockOnLoad                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              LODIndex                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FNetLevelVisibilityTransactionIdTransactionId                                                    (Parm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ClientUpdateLevelStreamingStatus(class FName PackageName, bool bNewShouldBeLoaded, bool bNewShouldBeVisible, bool bNewShouldBlockOnLoad, int32 LODIndex, const struct FNetLevelVisibilityTransactionId& TransactionId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientUpdateLevelStreamingStatus");

	Params::APlayerController_ClientUpdateLevelStreamingStatus_Params Parms{};

	Parms.PackageName = PackageName;
	Parms.bNewShouldBeLoaded = bNewShouldBeLoaded;
	Parms.bNewShouldBeVisible = bNewShouldBeVisible;
	Parms.bNewShouldBlockOnLoad = bNewShouldBlockOnLoad;
	Parms.LODIndex = LODIndex;
	Parms.TransactionId = TransactionId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientUnmutePlayers
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// TArray<struct FUniqueNetIdRepl>    PlayerIds                                                        (ConstParm, Parm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)

void APlayerController::ClientUnmutePlayers(TArray<struct FUniqueNetIdRepl>& PlayerIds)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientUnmutePlayers");

	Params::APlayerController_ClientUnmutePlayers_Params Parms{};

	Parms.PlayerIds = PlayerIds;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientUnmutePlayer
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// struct FUniqueNetIdRepl            PlayerId                                                         (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientUnmutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientUnmutePlayer");

	Params::APlayerController_ClientUnmutePlayer_Params Parms{};

	Parms.PlayerId = PlayerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientTravelInternal
// (Net, NetReliable, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// class FString                      URL                                                              (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ETravelType             TravelType                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSeamless                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FGuid                       MapPackageGuid                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientTravelInternal(const class FString& URL, enum class ETravelType TravelType, bool bSeamless, const struct FGuid& MapPackageGuid)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientTravelInternal");

	Params::APlayerController_ClientTravelInternal_Params Parms{};

	Parms.URL = URL;
	Parms.TravelType = TravelType;
	Parms.bSeamless = bSeamless;
	Parms.MapPackageGuid = MapPackageGuid;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientTravel
// (Final, Native, Public, HasDefaults)
// Parameters:
// class FString                      URL                                                              (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ETravelType             TravelType                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSeamless                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FGuid                       MapPackageGuid                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientTravel(const class FString& URL, enum class ETravelType TravelType, bool bSeamless, const struct FGuid& MapPackageGuid)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientTravel");

	Params::APlayerController_ClientTravel_Params Parms{};

	Parms.URL = URL;
	Parms.TravelType = TravelType;
	Parms.bSeamless = bSeamless;
	Parms.MapPackageGuid = MapPackageGuid;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientTeamMessage
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class APlayerState*                SenderPlayerState                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FString                      S                                                                (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        Type                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MsgLifeTime                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientTeamMessage(class APlayerState* SenderPlayerState, const class FString& S, class FName Type, float MsgLifeTime)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientTeamMessage");

	Params::APlayerController_ClientTeamMessage_Params Parms{};

	Parms.SenderPlayerState = SenderPlayerState;
	Parms.S = S;
	Parms.Type = Type;
	Parms.MsgLifeTime = MsgLifeTime;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientStopForceFeedback
// (Net, NetReliable, Native, Event, Public, NetClient, BlueprintCallable)
// Parameters:
// class UForceFeedbackEffect*        ForceFeedbackEffect                                              (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        Tag                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientStopForceFeedback(class UForceFeedbackEffect* ForceFeedbackEffect, class FName Tag)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientStopForceFeedback");

	Params::APlayerController_ClientStopForceFeedback_Params Parms{};

	Parms.ForceFeedbackEffect = ForceFeedbackEffect;
	Parms.Tag = Tag;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientStopCameraShakesFromSource
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UCameraShakeSourceComponent* SourceComponent                                                  (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bImmediately                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientStopCameraShakesFromSource(class UCameraShakeSourceComponent* SourceComponent, bool bImmediately)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientStopCameraShakesFromSource");

	Params::APlayerController_ClientStopCameraShakesFromSource_Params Parms{};

	Parms.SourceComponent = SourceComponent;
	Parms.bImmediately = bImmediately;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientStopCameraShake
// (Net, NetReliable, Native, Event, Public, NetClient, BlueprintCallable)
// Parameters:
// TSubclassOf<class UCameraShakeBase>Shake                                                            (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bImmediately                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientStopCameraShake(TSubclassOf<class UCameraShakeBase> Shake, bool bImmediately)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientStopCameraShake");

	Params::APlayerController_ClientStopCameraShake_Params Parms{};

	Parms.Shake = Shake;
	Parms.bImmediately = bImmediately;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientStartOnlineSession
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientStartOnlineSession()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientStartOnlineSession");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientStartCameraShakeFromSource
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// TSubclassOf<class UCameraShakeBase>Shake                                                            (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UCameraShakeSourceComponent* SourceComponent                                                  (Parm, ZeroConstructor, InstancedReference, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientStartCameraShakeFromSource(TSubclassOf<class UCameraShakeBase> Shake, class UCameraShakeSourceComponent* SourceComponent)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientStartCameraShakeFromSource");

	Params::APlayerController_ClientStartCameraShakeFromSource_Params Parms{};

	Parms.Shake = Shake;
	Parms.SourceComponent = SourceComponent;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientStartCameraShake
// (Net, Native, Event, Public, HasDefaults, NetClient, BlueprintCallable)
// Parameters:
// TSubclassOf<class UCameraShakeBase>Shake                                                            (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Scale                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// enum class ECameraShakePlaySpace   PlaySpace                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    UserPlaySpaceRot                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ClientStartCameraShake(TSubclassOf<class UCameraShakeBase> Shake, float Scale, enum class ECameraShakePlaySpace PlaySpace, const struct FRotator& UserPlaySpaceRot)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientStartCameraShake");

	Params::APlayerController_ClientStartCameraShake_Params Parms{};

	Parms.Shake = Shake;
	Parms.Scale = Scale;
	Parms.PlaySpace = PlaySpace;
	Parms.UserPlaySpaceRot = UserPlaySpaceRot;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSpawnGenericCameraLensEffect
// (Net, Native, Event, Public, NetClient, BlueprintCallable)
// Parameters:
// TSubclassOf<class AActor>          LensEffectEmitterClass                                           (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSpawnGenericCameraLensEffect(TSubclassOf<class AActor> LensEffectEmitterClass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSpawnGenericCameraLensEffect");

	Params::APlayerController_ClientSpawnGenericCameraLensEffect_Params Parms{};

	Parms.LensEffectEmitterClass = LensEffectEmitterClass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSpawnCameraLensEffect
// (Net, Native, Event, Public, NetClient)
// Parameters:
// TSubclassOf<class AEmitterCameraLensEffectBase>LensEffectEmitterClass                                           (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSpawnCameraLensEffect(TSubclassOf<class AEmitterCameraLensEffectBase> LensEffectEmitterClass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSpawnCameraLensEffect");

	Params::APlayerController_ClientSpawnCameraLensEffect_Params Parms{};

	Parms.LensEffectEmitterClass = LensEffectEmitterClass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetViewTarget
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class AActor*                      A                                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FViewTargetTransitionParams TransitionParams                                                 (Parm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ClientSetViewTarget(class AActor* A, const struct FViewTargetTransitionParams& TransitionParams)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetViewTarget");

	Params::APlayerController_ClientSetViewTarget_Params Parms{};

	Parms.A = A;
	Parms.TransitionParams = TransitionParams;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetSpectatorWaiting
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// bool                               bWaiting                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSetSpectatorWaiting(bool bWaiting)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetSpectatorWaiting");

	Params::APlayerController_ClientSetSpectatorWaiting_Params Parms{};

	Parms.bWaiting = bWaiting;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetHUD
// (Net, NetReliable, Native, Event, Public, NetClient, BlueprintCallable)
// Parameters:
// TSubclassOf<class AHUD>            NewHUDClass                                                      (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSetHUD(TSubclassOf<class AHUD> NewHUDClass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetHUD");

	Params::APlayerController_ClientSetHUD_Params Parms{};

	Parms.NewHUDClass = NewHUDClass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetForceMipLevelsToBeResident
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class UMaterialInterface*          Material                                                         (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ForceDuration                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              CinematicTextureGroups                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSetForceMipLevelsToBeResident(class UMaterialInterface* Material, float ForceDuration, int32 CinematicTextureGroups)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetForceMipLevelsToBeResident");

	Params::APlayerController_ClientSetForceMipLevelsToBeResident_Params Parms{};

	Parms.Material = Material;
	Parms.ForceDuration = ForceDuration;
	Parms.CinematicTextureGroups = CinematicTextureGroups;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetCinematicMode
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// bool                               bInCinematicMode                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsMovement                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsTurning                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bAffectsHUD                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSetCinematicMode(bool bInCinematicMode, bool bAffectsMovement, bool bAffectsTurning, bool bAffectsHUD)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetCinematicMode");

	Params::APlayerController_ClientSetCinematicMode_Params Parms{};

	Parms.bInCinematicMode = bInCinematicMode;
	Parms.bAffectsMovement = bAffectsMovement;
	Parms.bAffectsTurning = bAffectsTurning;
	Parms.bAffectsHUD = bAffectsHUD;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetCameraMode
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FName                        NewCamMode                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSetCameraMode(class FName NewCamMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetCameraMode");

	Params::APlayerController_ClientSetCameraMode_Params Parms{};

	Parms.NewCamMode = NewCamMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetCameraFade
// (Net, NetReliable, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// bool                               bEnableFading                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FColor                      FadeColor                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector2D                   FadeAlpha                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              FadeTime                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bFadeAudio                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bHoldWhenFinished                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientSetCameraFade(bool bEnableFading, const struct FColor& FadeColor, const struct FVector2D& FadeAlpha, float FadeTime, bool bFadeAudio, bool bHoldWhenFinished)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetCameraFade");

	Params::APlayerController_ClientSetCameraFade_Params Parms{};

	Parms.bEnableFading = bEnableFading;
	Parms.FadeColor = FadeColor;
	Parms.FadeAlpha = FadeAlpha;
	Parms.FadeTime = FadeTime;
	Parms.bFadeAudio = bFadeAudio;
	Parms.bHoldWhenFinished = bHoldWhenFinished;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientSetBlockOnAsyncLoading
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientSetBlockOnAsyncLoading()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientSetBlockOnAsyncLoading");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientReturnToMainMenuWithTextReason
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FText                        ReturnReason                                                     (ConstParm, Parm, ReferenceParm, NativeAccessSpecifierPublic)

void APlayerController::ClientReturnToMainMenuWithTextReason(class FText& ReturnReason)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientReturnToMainMenuWithTextReason");

	Params::APlayerController_ClientReturnToMainMenuWithTextReason_Params Parms{};

	Parms.ReturnReason = ReturnReason;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientReturnToMainMenu
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FString                      ReturnReason                                                     (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientReturnToMainMenu(const class FString& ReturnReason)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientReturnToMainMenu");

	Params::APlayerController_ClientReturnToMainMenu_Params Parms{};

	Parms.ReturnReason = ReturnReason;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientRetryClientRestart
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class APawn*                       NewPawn                                                          (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientRetryClientRestart(class APawn* NewPawn)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientRetryClientRestart");

	Params::APlayerController_ClientRetryClientRestart_Params Parms{};

	Parms.NewPawn = NewPawn;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientRestart
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class APawn*                       NewPawn                                                          (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientRestart(class APawn* NewPawn)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientRestart");

	Params::APlayerController_ClientRestart_Params Parms{};

	Parms.NewPawn = NewPawn;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientReset
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientReset()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientReset");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientRepObjRef
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class UObject*                     Object                                                           (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientRepObjRef(class UObject* Object)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientRepObjRef");

	Params::APlayerController_ClientRepObjRef_Params Parms{};

	Parms.Object = Object;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientRecvServerAckFrameDebug
// (Net, Native, Event, Public, NetClient)
// Parameters:
// uint8                              NumBuffered                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              TargetNumBufferedCmds                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientRecvServerAckFrameDebug(uint8 NumBuffered, float TargetNumBufferedCmds)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientRecvServerAckFrameDebug");

	Params::APlayerController_ClientRecvServerAckFrameDebug_Params Parms{};

	Parms.NumBuffered = NumBuffered;
	Parms.TargetNumBufferedCmds = TargetNumBufferedCmds;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientRecvServerAckFrame
// (Net, Native, Event, Public, NetClient)
// Parameters:
// int32                              LastProcessedInputFrame                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              RecvServerFrameNumber                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int8                               TimeDilation                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientRecvServerAckFrame(int32 LastProcessedInputFrame, int32 RecvServerFrameNumber, int8 TimeDilation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientRecvServerAckFrame");

	Params::APlayerController_ClientRecvServerAckFrame_Params Parms{};

	Parms.LastProcessedInputFrame = LastProcessedInputFrame;
	Parms.RecvServerFrameNumber = RecvServerFrameNumber;
	Parms.TimeDilation = TimeDilation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientReceiveLocalizedMessage
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// TSubclassOf<class ULocalMessage>   Message                                                          (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              SWITCH                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class APlayerState*                RelatedPlayerState_1                                             (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class APlayerState*                RelatedPlayerState_2                                             (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class UObject*                     OptionalObject                                                   (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientReceiveLocalizedMessage(TSubclassOf<class ULocalMessage> Message, int32 SWITCH, class APlayerState* RelatedPlayerState_1, class APlayerState* RelatedPlayerState_2, class UObject* OptionalObject)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientReceiveLocalizedMessage");

	Params::APlayerController_ClientReceiveLocalizedMessage_Params Parms{};

	Parms.Message = Message;
	Parms.SWITCH = SWITCH;
	Parms.RelatedPlayerState_1 = RelatedPlayerState_1;
	Parms.RelatedPlayerState_2 = RelatedPlayerState_2;
	Parms.OptionalObject = OptionalObject;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientPrestreamTextures
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class AActor*                      ForcedActor                                                      (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              ForceDuration                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bEnableStreaming                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              CinematicTextureGroups                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientPrestreamTextures(class AActor* ForcedActor, float ForceDuration, bool bEnableStreaming, int32 CinematicTextureGroups)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientPrestreamTextures");

	Params::APlayerController_ClientPrestreamTextures_Params Parms{};

	Parms.ForcedActor = ForcedActor;
	Parms.ForceDuration = ForceDuration;
	Parms.bEnableStreaming = bEnableStreaming;
	Parms.CinematicTextureGroups = CinematicTextureGroups;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientPrepareMapChange
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FName                        LevelName                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bFirst                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bLast                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientPrepareMapChange(class FName LevelName, bool bFirst, bool bLast)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientPrepareMapChange");

	Params::APlayerController_ClientPrepareMapChange_Params Parms{};

	Parms.LevelName = LevelName;
	Parms.bFirst = bFirst;
	Parms.bLast = bLast;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientPlaySoundAtLocation
// (Net, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// class USoundBase*                  Sound                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     Location                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              VolumeMultiplier                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              PitchMultiplier                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientPlaySoundAtLocation(class USoundBase* Sound, const struct FVector& Location, float VolumeMultiplier, float PitchMultiplier)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientPlaySoundAtLocation");

	Params::APlayerController_ClientPlaySoundAtLocation_Params Parms{};

	Parms.Sound = Sound;
	Parms.Location = Location;
	Parms.VolumeMultiplier = VolumeMultiplier;
	Parms.PitchMultiplier = PitchMultiplier;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientPlaySound
// (Net, Native, Event, Public, NetClient)
// Parameters:
// class USoundBase*                  Sound                                                            (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              VolumeMultiplier                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              PitchMultiplier                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientPlaySound(class USoundBase* Sound, float VolumeMultiplier, float PitchMultiplier)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientPlaySound");

	Params::APlayerController_ClientPlaySound_Params Parms{};

	Parms.Sound = Sound;
	Parms.VolumeMultiplier = VolumeMultiplier;
	Parms.PitchMultiplier = PitchMultiplier;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientPlayForceFeedback_Internal
// (Final, Net, Native, Event, Private, NetClient)
// Parameters:
// class UForceFeedbackEffect*        ForceFeedbackEffect                                              (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FForceFeedbackParameters    Params                                                           (Parm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ClientPlayForceFeedback_Internal(class UForceFeedbackEffect* ForceFeedbackEffect, const struct FForceFeedbackParameters& Params)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientPlayForceFeedback_Internal");

	Params::APlayerController_ClientPlayForceFeedback_Internal_Params Parms{};

	Parms.ForceFeedbackEffect = ForceFeedbackEffect;
	Parms.Params = Params;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientMutePlayer
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// struct FUniqueNetIdRepl            PlayerId                                                         (Parm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientMutePlayer(const struct FUniqueNetIdRepl& PlayerId)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientMutePlayer");

	Params::APlayerController_ClientMutePlayer_Params Parms{};

	Parms.PlayerId = PlayerId;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientMessage
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FString                      S                                                                (Parm, ZeroConstructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        Type                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              MsgLifeTime                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientMessage(const class FString& S, class FName Type, float MsgLifeTime)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientMessage");

	Params::APlayerController_ClientMessage_Params Parms{};

	Parms.S = S;
	Parms.Type = Type;
	Parms.MsgLifeTime = MsgLifeTime;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientIgnoreMoveInput
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// bool                               bIgnore                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientIgnoreMoveInput(bool bIgnore)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientIgnoreMoveInput");

	Params::APlayerController_ClientIgnoreMoveInput_Params Parms{};

	Parms.bIgnore = bIgnore;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientIgnoreLookInput
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// bool                               bIgnore                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientIgnoreLookInput(bool bIgnore)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientIgnoreLookInput");

	Params::APlayerController_ClientIgnoreLookInput_Params Parms{};

	Parms.bIgnore = bIgnore;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientGotoState
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FName                        NewState                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientGotoState(class FName NewState)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientGotoState");

	Params::APlayerController_ClientGotoState_Params Parms{};

	Parms.NewState = NewState;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientGameEnded
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class AActor*                      EndGameFocus                                                     (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bIsWinner                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientGameEnded(class AActor* EndGameFocus, bool bIsWinner)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientGameEnded");

	Params::APlayerController_ClientGameEnded_Params Parms{};

	Parms.EndGameFocus = EndGameFocus;
	Parms.bIsWinner = bIsWinner;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientForceGarbageCollection
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientForceGarbageCollection()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientForceGarbageCollection");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientFlushLevelStreaming
// (Final, Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientFlushLevelStreaming()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientFlushLevelStreaming");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientEndOnlineSession
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientEndOnlineSession()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientEndOnlineSession");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientEnableNetworkVoice
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// bool                               bEnable                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientEnableNetworkVoice(bool bEnable)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientEnableNetworkVoice");

	Params::APlayerController_ClientEnableNetworkVoice_Params Parms{};

	Parms.bEnable = bEnable;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientCorrectionAsyncPhysicsTimestamp
// (Final, Net, Native, Event, Private, NetClient)
// Parameters:
// struct FAsyncPhysicsTimestamp      Timestamp                                                        (Parm, NoDestructor, NativeAccessSpecifierPublic)

void APlayerController::ClientCorrectionAsyncPhysicsTimestamp(const struct FAsyncPhysicsTimestamp& Timestamp)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientCorrectionAsyncPhysicsTimestamp");

	Params::APlayerController_ClientCorrectionAsyncPhysicsTimestamp_Params Parms{};

	Parms.Timestamp = Timestamp;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientCommitMapChange
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientCommitMapChange()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientCommitMapChange");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientClearCameraLensEffects
// (Net, NetReliable, Native, Event, Public, NetClient, BlueprintCallable)
// Parameters:

void APlayerController::ClientClearCameraLensEffects()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientClearCameraLensEffects");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientCapBandwidth
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// int32                              Cap                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientCapBandwidth(int32 Cap)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientCapBandwidth");

	Params::APlayerController_ClientCapBandwidth_Params Parms{};

	Parms.Cap = Cap;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientCancelPendingMapChange
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:

void APlayerController::ClientCancelPendingMapChange()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientCancelPendingMapChange");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientAddTextureStreamingLoc
// (Final, Net, NetReliable, Native, Event, Public, HasDefaults, NetClient)
// Parameters:
// struct FVector                     InLoc                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Duration                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bOverrideLocation                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientAddTextureStreamingLoc(const struct FVector& InLoc, float Duration, bool bOverrideLocation)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientAddTextureStreamingLoc");

	Params::APlayerController_ClientAddTextureStreamingLoc_Params Parms{};

	Parms.InLoc = InLoc;
	Parms.Duration = Duration;
	Parms.bOverrideLocation = bOverrideLocation;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientAckUpdateLevelVisibility
// (Net, NetReliable, Native, Event, Public, NetClient)
// Parameters:
// class FName                        PackageName                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FNetLevelVisibilityTransactionIdTransactionId                                                    (Parm, NoDestructor, NativeAccessSpecifierPublic)
// bool                               bClientAckCanMakeVisible                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientAckUpdateLevelVisibility(class FName PackageName, const struct FNetLevelVisibilityTransactionId& TransactionId, bool bClientAckCanMakeVisible)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientAckUpdateLevelVisibility");

	Params::APlayerController_ClientAckUpdateLevelVisibility_Params Parms{};

	Parms.PackageName = PackageName;
	Parms.TransactionId = TransactionId;
	Parms.bClientAckCanMakeVisible = bClientAckCanMakeVisible;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClientAckTimeDilation
// (Final, Net, Native, Event, Private, NetClient)
// Parameters:
// float                              TimeDilation                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// int32                              ServerStep                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ClientAckTimeDilation(float TimeDilation, int32 ServerStep)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClientAckTimeDilation");

	Params::APlayerController_ClientAckTimeDilation_Params Parms{};

	Parms.TimeDilation = TimeDilation;
	Parms.ServerStep = ServerStep;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClearAudioListenerOverride
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void APlayerController::ClearAudioListenerOverride()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClearAudioListenerOverride");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ClearAudioListenerAttenuationOverride
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void APlayerController::ClearAudioListenerAttenuationOverride()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ClearAudioListenerAttenuationOverride");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.CanRestartPlayer
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerController::CanRestartPlayer()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "CanRestartPlayer");

	Params::APlayerController_CanRestartPlayer_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerController.Camera
// (Exec, Native, Public)
// Parameters:
// class FName                        NewMode                                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::Camera(class FName NewMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "Camera");

	Params::APlayerController_Camera_Params Parms{};

	Parms.NewMode = NewMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.AddYawInput
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Val                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::AddYawInput(float Val)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "AddYawInput");

	Params::APlayerController_AddYawInput_Params Parms{};

	Parms.Val = Val;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.AddRollInput
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Val                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::AddRollInput(float Val)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "AddRollInput");

	Params::APlayerController_AddRollInput_Params Parms{};

	Parms.Val = Val;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.AddPitchInput
// (Native, Public, BlueprintCallable)
// Parameters:
// float                              Val                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::AddPitchInput(float Val)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "AddPitchInput");

	Params::APlayerController_AddPitchInput_Params Parms{};

	Parms.Val = Val;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerController.ActivateTouchInterface
// (Native, Public, BlueprintCallable)
// Parameters:
// class UTouchInterface*             NewTouchInterface                                                (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerController::ActivateTouchInterface(class UTouchInterface* NewTouchInterface)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerController", "ActivateTouchInterface");

	Params::APlayerController_ActivateTouchInterface_Params Parms{};

	Parms.NewTouchInterface = NewTouchInterface;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.PlayerState
// (Actor)

class UClass* APlayerState::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("PlayerState");

	return Clss;
}


// PlayerState Engine.Default__PlayerState
// (Public, ClassDefaultObject, ArchetypeObject)

class APlayerState* APlayerState::GetDefaultObj()
{
	static class APlayerState* Default = nullptr;

	if (!Default)
		Default = static_cast<APlayerState*>(APlayerState::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.PlayerState.ReceiveOverrideWith
// (Event, Protected, BlueprintEvent)
// Parameters:
// class APlayerState*                OldPlayerState                                                   (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerState::ReceiveOverrideWith(class APlayerState* OldPlayerState)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "ReceiveOverrideWith");

	Params::APlayerState_ReceiveOverrideWith_Params Parms{};

	Parms.OldPlayerState = OldPlayerState;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.PlayerState.ReceiveCopyProperties
// (Event, Protected, BlueprintEvent)
// Parameters:
// class APlayerState*                NewPlayerState                                                   (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerState::ReceiveCopyProperties(class APlayerState* NewPlayerState)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "ReceiveCopyProperties");

	Params::APlayerState_ReceiveCopyProperties_Params Parms{};

	Parms.NewPlayerState = NewPlayerState;

	UObject::ProcessEvent(Func, &Parms);

}


// Function Engine.PlayerState.OnRep_UniqueId
// (Native, Public)
// Parameters:

void APlayerState::OnRep_UniqueId()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "OnRep_UniqueId");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerState.OnRep_Score
// (Native, Public)
// Parameters:

void APlayerState::OnRep_Score()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "OnRep_Score");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerState.OnRep_PlayerName
// (Native, Public)
// Parameters:

void APlayerState::OnRep_PlayerName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "OnRep_PlayerName");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerState.OnRep_PlayerId
// (Native, Public)
// Parameters:

void APlayerState::OnRep_PlayerId()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "OnRep_PlayerId");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerState.OnRep_bIsInactive
// (Native, Public)
// Parameters:

void APlayerState::OnRep_bIsInactive()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "OnRep_bIsInactive");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerState.OnPawnPrivateDestroyed
// (Final, Native, Private)
// Parameters:
// class AActor*                      InActor                                                          (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void APlayerState::OnPawnPrivateDestroyed(class AActor* InActor)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "OnPawnPrivateDestroyed");

	Params::APlayerState_OnPawnPrivateDestroyed_Params Parms{};

	Parms.InActor = InActor;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.PlayerState.IsSpectator
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerState::IsSpectator()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "IsSpectator");

	Params::APlayerState_IsSpectator_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.IsOnlyASpectator
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerState::IsOnlyASpectator()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "IsOnlyASpectator");

	Params::APlayerState_IsOnlyASpectator_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.IsABot
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool APlayerState::IsABot()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "IsABot");

	Params::APlayerState_IsABot_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.GetScore
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float APlayerState::GetScore()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "GetScore");

	Params::APlayerState_GetScore_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.GetPlayerName
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class FString                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class FString APlayerState::GetPlayerName()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "GetPlayerName");

	Params::APlayerState_GetPlayerName_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.GetPlayerId
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// int32                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

int32 APlayerState::GetPlayerId()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "GetPlayerId");

	Params::APlayerState_GetPlayerId_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.GetPlayerController
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class APlayerController*           ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APlayerController* APlayerState::GetPlayerController()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "GetPlayerController");

	Params::APlayerState_GetPlayerController_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.GetPingInMilliseconds
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// float                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

float APlayerState::GetPingInMilliseconds()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "GetPingInMilliseconds");

	Params::APlayerState_GetPingInMilliseconds_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.GetPawn
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class APawn*                       ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class APawn* APlayerState::GetPawn()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "GetPawn");

	Params::APlayerState_GetPawn_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.GetCompressedPing
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// uint8                              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

uint8 APlayerState::GetCompressedPing()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "GetCompressedPing");

	Params::APlayerState_GetCompressedPing_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.PlayerState.BP_GetUniqueId
// (Final, Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// struct FUniqueNetIdRepl            ReturnValue                                                      (Parm, OutParm, ReturnParm, HasGetValueTypeHash, NativeAccessSpecifierPublic)

struct FUniqueNetIdRepl APlayerState::BP_GetUniqueId()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("PlayerState", "BP_GetUniqueId");

	Params::APlayerState_BP_GetUniqueId_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Class Engine.Engine
// (None)

class UClass* UEngine::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Engine");

	return Clss;
}


// Engine Engine.Default__Engine
// (Public, ClassDefaultObject, ArchetypeObject)

class UEngine* UEngine::GetDefaultObj()
{
	static class UEngine* Default = nullptr;

	if (!Default)
		Default = static_cast<UEngine*>(UEngine::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.ScriptViewportClient
// (None)

class UClass* UScriptViewportClient::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("ScriptViewportClient");

	return Clss;
}


// ScriptViewportClient Engine.Default__ScriptViewportClient
// (Public, ClassDefaultObject, ArchetypeObject)

class UScriptViewportClient* UScriptViewportClient::GetDefaultObj()
{
	static class UScriptViewportClient* Default = nullptr;

	if (!Default)
		Default = static_cast<UScriptViewportClient*>(UScriptViewportClient::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.GameViewportClient
// (None)

class UClass* UGameViewportClient::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("GameViewportClient");

	return Clss;
}


// GameViewportClient Engine.Default__GameViewportClient
// (Public, ClassDefaultObject, ArchetypeObject)

class UGameViewportClient* UGameViewportClient::GetDefaultObj()
{
	static class UGameViewportClient* Default = nullptr;

	if (!Default)
		Default = static_cast<UGameViewportClient*>(UGameViewportClient::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.GameViewportClient.SSSwapControllers
// (Exec, Native, Public)
// Parameters:

void UGameViewportClient::SSSwapControllers()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameViewportClient", "SSSwapControllers");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameViewportClient.ShowTitleSafeArea
// (Exec, Native, Public)
// Parameters:

void UGameViewportClient::ShowTitleSafeArea()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameViewportClient", "ShowTitleSafeArea");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.GameViewportClient.SetConsoleTarget
// (Exec, Native, Public)
// Parameters:
// int32                              PlayerIndex                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UGameViewportClient::SetConsoleTarget(int32 PlayerIndex)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("GameViewportClient", "SetConsoleTarget");

	Params::UGameViewportClient_SetConsoleTarget_Params Parms{};

	Parms.PlayerIndex = PlayerIndex;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Class Engine.Player
// (None)

class UClass* UPlayer::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("Player");

	return Clss;
}


// Player Engine.Default__Player
// (Public, ClassDefaultObject, ArchetypeObject)

class UPlayer* UPlayer::GetDefaultObj()
{
	static class UPlayer* Default = nullptr;

	if (!Default)
		Default = static_cast<UPlayer*>(UPlayer::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.LocalPlayer
// (None)

class UClass* ULocalPlayer::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("LocalPlayer");

	return Clss;
}


// LocalPlayer Engine.Default__LocalPlayer
// (Public, ClassDefaultObject, ArchetypeObject)

class ULocalPlayer* ULocalPlayer::GetDefaultObj()
{
	static class ULocalPlayer* Default = nullptr;

	if (!Default)
		Default = static_cast<ULocalPlayer*>(ULocalPlayer::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.LocalPlayerSubsystem
// (None)

class UClass* ULocalPlayerSubsystem::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("LocalPlayerSubsystem");

	return Clss;
}


// LocalPlayerSubsystem Engine.Default__LocalPlayerSubsystem
// (Public, ClassDefaultObject, ArchetypeObject)

class ULocalPlayerSubsystem* ULocalPlayerSubsystem::GetDefaultObj()
{
	static class ULocalPlayerSubsystem* Default = nullptr;

	if (!Default)
		Default = static_cast<ULocalPlayerSubsystem*>(ULocalPlayerSubsystem::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.DataTable
// (None)

class UClass* UDataTable::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("DataTable");

	return Clss;
}


// DataTable Engine.Default__DataTable
// (Public, ClassDefaultObject, ArchetypeObject)

class UDataTable* UDataTable::GetDefaultObj()
{
	static class UDataTable* Default = nullptr;

	if (!Default)
		Default = static_cast<UDataTable*>(UDataTable::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.CancellableAsyncAction
// (None)

class UClass* UCancellableAsyncAction::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("CancellableAsyncAction");

	return Clss;
}


// CancellableAsyncAction Engine.Default__CancellableAsyncAction
// (Public, ClassDefaultObject, ArchetypeObject)

class UCancellableAsyncAction* UCancellableAsyncAction::GetDefaultObj()
{
	static class UCancellableAsyncAction* Default = nullptr;

	if (!Default)
		Default = static_cast<UCancellableAsyncAction*>(UCancellableAsyncAction::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.CancellableAsyncAction.IsActive
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UCancellableAsyncAction::IsActive()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CancellableAsyncAction", "IsActive");

	Params::UCancellableAsyncAction_IsActive_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.CancellableAsyncAction.Cancel
// (Native, Public, BlueprintCallable)
// Parameters:

void UCancellableAsyncAction::Cancel()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CancellableAsyncAction", "Cancel");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Class Engine.OnlineBlueprintCallProxyBase
// (None)

class UClass* UOnlineBlueprintCallProxyBase::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("OnlineBlueprintCallProxyBase");

	return Clss;
}


// OnlineBlueprintCallProxyBase Engine.Default__OnlineBlueprintCallProxyBase
// (Public, ClassDefaultObject, ArchetypeObject, StrongRefOnFrame)

class UOnlineBlueprintCallProxyBase* UOnlineBlueprintCallProxyBase::GetDefaultObj()
{
	static class UOnlineBlueprintCallProxyBase* Default = nullptr;

	if (!Default)
		Default = static_cast<UOnlineBlueprintCallProxyBase*>(UOnlineBlueprintCallProxyBase::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.NetConnection
// (None)

class UClass* UNetConnection::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("NetConnection");

	return Clss;
}


// NetConnection Engine.Default__NetConnection
// (Public, ClassDefaultObject, ArchetypeObject)

class UNetConnection* UNetConnection::GetDefaultObj()
{
	static class UNetConnection* Default = nullptr;

	if (!Default)
		Default = static_cast<UNetConnection*>(UNetConnection::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.NetDriver
// (None)

class UClass* UNetDriver::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("NetDriver");

	return Clss;
}


// NetDriver Engine.Default__NetDriver
// (Public, ClassDefaultObject, ArchetypeObject)

class UNetDriver* UNetDriver::GetDefaultObj()
{
	static class UNetDriver* Default = nullptr;

	if (!Default)
		Default = static_cast<UNetDriver*>(UNetDriver::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.OnlineEngineInterface
// (None)

class UClass* UOnlineEngineInterface::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("OnlineEngineInterface");

	return Clss;
}


// OnlineEngineInterface Engine.Default__OnlineEngineInterface
// (Public, ClassDefaultObject, ArchetypeObject)

class UOnlineEngineInterface* UOnlineEngineInterface::GetDefaultObj()
{
	static class UOnlineEngineInterface* Default = nullptr;

	if (!Default)
		Default = static_cast<UOnlineEngineInterface*>(UOnlineEngineInterface::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.OnlineSession
// (None)

class UClass* UOnlineSession::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("OnlineSession");

	return Clss;
}


// OnlineSession Engine.Default__OnlineSession
// (Public, ClassDefaultObject, ArchetypeObject)

class UOnlineSession* UOnlineSession::GetDefaultObj()
{
	static class UOnlineSession* Default = nullptr;

	if (!Default)
		Default = static_cast<UOnlineSession*>(UOnlineSession::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.RuntimeOptionsBase
// (None)

class UClass* URuntimeOptionsBase::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("RuntimeOptionsBase");

	return Clss;
}


// RuntimeOptionsBase Engine.Default__RuntimeOptionsBase
// (Public, ClassDefaultObject, ArchetypeObject)

class URuntimeOptionsBase* URuntimeOptionsBase::GetDefaultObj()
{
	static class URuntimeOptionsBase* Default = nullptr;

	if (!Default)
		Default = static_cast<URuntimeOptionsBase*>(URuntimeOptionsBase::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.CameraModifier
// (None)

class UClass* UCameraModifier::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("CameraModifier");

	return Clss;
}


// CameraModifier Engine.Default__CameraModifier
// (Public, ClassDefaultObject, ArchetypeObject)

class UCameraModifier* UCameraModifier::GetDefaultObj()
{
	static class UCameraModifier* Default = nullptr;

	if (!Default)
		Default = static_cast<UCameraModifier*>(UCameraModifier::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.CameraModifier.OnCameraOwnerDestroyed
// (Final, Native, Protected)
// Parameters:
// class AActor*                      InOwner                                                          (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UCameraModifier::OnCameraOwnerDestroyed(class AActor* InOwner)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CameraModifier", "OnCameraOwnerDestroyed");

	Params::UCameraModifier_OnCameraOwnerDestroyed_Params Parms{};

	Parms.InOwner = InOwner;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.CameraModifier.IsDisabled
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// bool                               ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

bool UCameraModifier::IsDisabled()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CameraModifier", "IsDisabled");

	Params::UCameraModifier_IsDisabled_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.CameraModifier.GetViewTarget
// (Native, Public, BlueprintCallable, BlueprintPure, Const)
// Parameters:
// class AActor*                      ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AActor* UCameraModifier::GetViewTarget()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CameraModifier", "GetViewTarget");

	Params::UCameraModifier_GetViewTarget_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.CameraModifier.EnableModifier
// (Native, Public, BlueprintCallable)
// Parameters:

void UCameraModifier::EnableModifier()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CameraModifier", "EnableModifier");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.CameraModifier.DisableModifier
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bImmediate                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UCameraModifier::DisableModifier(bool bImmediate)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CameraModifier", "DisableModifier");

	Params::UCameraModifier_DisableModifier_Params Parms{};

	Parms.bImmediate = bImmediate;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.CameraModifier.BlueprintModifyPostProcess
// (BlueprintCosmetic, Event, Public, HasOutParams, BlueprintEvent)
// Parameters:
// float                              DeltaTime                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              PostProcessBlendWeight                                           (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FPostProcessSettings        PostProcessSettings                                              (Parm, OutParm, NativeAccessSpecifierPublic)

void UCameraModifier::BlueprintModifyPostProcess(float DeltaTime, float* PostProcessBlendWeight, struct FPostProcessSettings* PostProcessSettings)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CameraModifier", "BlueprintModifyPostProcess");

	Params::UCameraModifier_BlueprintModifyPostProcess_Params Parms{};

	Parms.DeltaTime = DeltaTime;

	UObject::ProcessEvent(Func, &Parms);

	if (PostProcessBlendWeight != nullptr)
		*PostProcessBlendWeight = Parms.PostProcessBlendWeight;

	if (PostProcessSettings != nullptr)
		*PostProcessSettings = std::move(Parms.PostProcessSettings);

}


// Function Engine.CameraModifier.BlueprintModifyCamera
// (BlueprintCosmetic, Event, Public, HasOutParams, HasDefaults, BlueprintEvent)
// Parameters:
// float                              DeltaTime                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     ViewLocation                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    ViewRotation                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// float                              FOV                                                              (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FVector                     NewViewLocation                                                  (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// struct FRotator                    NewViewRotation                                                  (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, NativeAccessSpecifierPublic)
// float                              NewFOV                                                           (Parm, OutParm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void UCameraModifier::BlueprintModifyCamera(float DeltaTime, const struct FVector& ViewLocation, const struct FRotator& ViewRotation, float FOV, struct FVector* NewViewLocation, struct FRotator* NewViewRotation, float* NewFOV)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("CameraModifier", "BlueprintModifyCamera");

	Params::UCameraModifier_BlueprintModifyCamera_Params Parms{};

	Parms.DeltaTime = DeltaTime;
	Parms.ViewLocation = ViewLocation;
	Parms.ViewRotation = ViewRotation;
	Parms.FOV = FOV;

	UObject::ProcessEvent(Func, &Parms);

	if (NewViewLocation != nullptr)
		*NewViewLocation = std::move(Parms.NewViewLocation);

	if (NewViewRotation != nullptr)
		*NewViewRotation = std::move(Parms.NewViewRotation);

	if (NewFOV != nullptr)
		*NewFOV = Parms.NewFOV;

}


// Class Engine.EngineCustomTimeStep
// (None)

class UClass* UEngineCustomTimeStep::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("EngineCustomTimeStep");

	return Clss;
}


// EngineCustomTimeStep Engine.Default__EngineCustomTimeStep
// (Public, ClassDefaultObject, ArchetypeObject)

class UEngineCustomTimeStep* UEngineCustomTimeStep::GetDefaultObj()
{
	static class UEngineCustomTimeStep* Default = nullptr;

	if (!Default)
		Default = static_cast<UEngineCustomTimeStep*>(UEngineCustomTimeStep::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.ReplicationDriver
// (None)

class UClass* UReplicationDriver::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("ReplicationDriver");

	return Clss;
}


// ReplicationDriver Engine.Default__ReplicationDriver
// (Public, ClassDefaultObject, ArchetypeObject)

class UReplicationDriver* UReplicationDriver::GetDefaultObj()
{
	static class UReplicationDriver* Default = nullptr;

	if (!Default)
		Default = static_cast<UReplicationDriver*>(UReplicationDriver::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.ReplicationConnectionDriver
// (None)

class UClass* UReplicationConnectionDriver::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("ReplicationConnectionDriver");

	return Clss;
}


// ReplicationConnectionDriver Engine.Default__ReplicationConnectionDriver
// (Public, ClassDefaultObject, ArchetypeObject)

class UReplicationConnectionDriver* UReplicationConnectionDriver::GetDefaultObj()
{
	static class UReplicationConnectionDriver* Default = nullptr;

	if (!Default)
		Default = static_cast<UReplicationConnectionDriver*>(UReplicationConnectionDriver::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.World
// (None)

class UClass* UWorld::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("World");

	return Clss;
}


// World Engine.Default__World
// (Public, ClassDefaultObject, ArchetypeObject)

class UWorld* UWorld::GetDefaultObj()
{
	static class UWorld* Default = nullptr;

	if (!Default)
		Default = static_cast<UWorld*>(UWorld::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.World.K2_GetWorldSettings
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class AWorldSettings*              ReturnValue                                                      (Parm, OutParm, ZeroConstructor, ReturnParm, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

class AWorldSettings* UWorld::K2_GetWorldSettings()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("World", "K2_GetWorldSettings");

	Params::UWorld_K2_GetWorldSettings_Params Parms{};


	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

	return Parms.ReturnValue;

}


// Function Engine.World.HandleTimelineScrubbed
// (Final, Native, Public)
// Parameters:

void UWorld::HandleTimelineScrubbed()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("World", "HandleTimelineScrubbed");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Class Engine.MaterialExpression
// (None)

class UClass* UMaterialExpression::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("MaterialExpression");

	return Clss;
}


// MaterialExpression Engine.Default__MaterialExpression
// (Public, ClassDefaultObject, ArchetypeObject)

class UMaterialExpression* UMaterialExpression::GetDefaultObj()
{
	static class UMaterialExpression* Default = nullptr;

	if (!Default)
		Default = static_cast<UMaterialExpression*>(UMaterialExpression::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.MaterialExpressionTextureBase
// (None)

class UClass* UMaterialExpressionTextureBase::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("MaterialExpressionTextureBase");

	return Clss;
}


// MaterialExpressionTextureBase Engine.Default__MaterialExpressionTextureBase
// (Public, ClassDefaultObject, ArchetypeObject)

class UMaterialExpressionTextureBase* UMaterialExpressionTextureBase::GetDefaultObj()
{
	static class UMaterialExpressionTextureBase* Default = nullptr;

	if (!Default)
		Default = static_cast<UMaterialExpressionTextureBase*>(UMaterialExpressionTextureBase::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.MaterialExpressionTextureSample
// (None)

class UClass* UMaterialExpressionTextureSample::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("MaterialExpressionTextureSample");

	return Clss;
}


// MaterialExpressionTextureSample Engine.Default__MaterialExpressionTextureSample
// (Public, ClassDefaultObject, ArchetypeObject)

class UMaterialExpressionTextureSample* UMaterialExpressionTextureSample::GetDefaultObj()
{
	static class UMaterialExpressionTextureSample* Default = nullptr;

	if (!Default)
		Default = static_cast<UMaterialExpressionTextureSample*>(UMaterialExpressionTextureSample::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.MaterialExpressionTextureSampleParameter
// (None)

class UClass* UMaterialExpressionTextureSampleParameter::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("MaterialExpressionTextureSampleParameter");

	return Clss;
}


// MaterialExpressionTextureSampleParameter Engine.Default__MaterialExpressionTextureSampleParameter
// (Public, ClassDefaultObject, ArchetypeObject)

class UMaterialExpressionTextureSampleParameter* UMaterialExpressionTextureSampleParameter::GetDefaultObj()
{
	static class UMaterialExpressionTextureSampleParameter* Default = nullptr;

	if (!Default)
		Default = static_cast<UMaterialExpressionTextureSampleParameter*>(UMaterialExpressionTextureSampleParameter::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.MaterialExpressionTextureSampleParameter2D
// (None)

class UClass* UMaterialExpressionTextureSampleParameter2D::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("MaterialExpressionTextureSampleParameter2D");

	return Clss;
}


// MaterialExpressionTextureSampleParameter2D Engine.Default__MaterialExpressionTextureSampleParameter2D
// (Public, ClassDefaultObject, ArchetypeObject)

class UMaterialExpressionTextureSampleParameter2D* UMaterialExpressionTextureSampleParameter2D::GetDefaultObj()
{
	static class UMaterialExpressionTextureSampleParameter2D* Default = nullptr;

	if (!Default)
		Default = static_cast<UMaterialExpressionTextureSampleParameter2D*>(UMaterialExpressionTextureSampleParameter2D::StaticClass()->DefaultObject);

	return Default;
}


// Class Engine.SkeletalMeshComponent
// (SceneComponent, PrimitiveComponent, SkinnedMeshComponent, SkeletalMeshComponent)

class UClass* USkeletalMeshComponent::StaticClass()
{
	static class UClass* Clss = nullptr;

	if (!Clss)
		Clss = UObject::FindClassFast("SkeletalMeshComponent");

	return Clss;
}


// SkeletalMeshComponent Engine.Default__SkeletalMeshComponent
// (Public, ClassDefaultObject, ArchetypeObject)

class USkeletalMeshComponent* USkeletalMeshComponent::GetDefaultObj()
{
	static class USkeletalMeshComponent* Default = nullptr;

	if (!Default)
		Default = static_cast<USkeletalMeshComponent*>(USkeletalMeshComponent::StaticClass()->DefaultObject);

	return Default;
}


// Function Engine.SkeletalMeshComponent.UnlinkAnimClassLayers
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// TSubclassOf<class UAnimInstance>   InClass                                                          (Parm, ZeroConstructor, NoDestructor, UObjectWrapper, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::UnlinkAnimClassLayers(TSubclassOf<class UAnimInstance> InClass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "UnlinkAnimClassLayers");

	Params::USkeletalMeshComponent_UnlinkAnimClassLayers_Params Parms{};

	Parms.InClass = InClass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.UnbindClothFromLeaderPoseComponent
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bRestoreSimulationSpace                                          (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::UnbindClothFromLeaderPoseComponent(bool bRestoreSimulationSpace)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "UnbindClothFromLeaderPoseComponent");

	Params::USkeletalMeshComponent_UnbindClothFromLeaderPoseComponent_Params Parms{};

	Parms.bRestoreSimulationSpace = bRestoreSimulationSpace;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.ToggleDisablePostProcessBlueprint
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void USkeletalMeshComponent::ToggleDisablePostProcessBlueprint()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "ToggleDisablePostProcessBlueprint");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.TermBodiesBelow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ParentBoneName                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::TermBodiesBelow(class FName ParentBoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "TermBodiesBelow");

	Params::USkeletalMeshComponent_TermBodiesBelow_Params Parms{};

	Parms.ParentBoneName = ParentBoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SuspendClothingSimulation
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void USkeletalMeshComponent::SuspendClothingSimulation()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SuspendClothingSimulation");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.Stop
// (Final, Native, Public, BlueprintCallable)
// Parameters:

void USkeletalMeshComponent::Stop()
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "Stop");



	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, nullptr);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SnapshotPose
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// struct FPoseSnapshot               Snapshot                                                         (Parm, OutParm, ReferenceParm, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SnapshotPose(struct FPoseSnapshot& Snapshot)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SnapshotPose");

	Params::USkeletalMeshComponent_SnapshotPose_Params Parms{};

	Parms.Snapshot = Snapshot;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetUpdateClothInEditor
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               NewUpdateState                                                   (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetUpdateClothInEditor(bool NewUpdateState)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetUpdateClothInEditor");

	Params::USkeletalMeshComponent_SetUpdateClothInEditor_Params Parms{};

	Parms.NewUpdateState = NewUpdateState;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetUpdateAnimationInEditor
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               NewUpdateState                                                   (ConstParm, Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetUpdateAnimationInEditor(bool NewUpdateState)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetUpdateAnimationInEditor");

	Params::USkeletalMeshComponent_SetUpdateAnimationInEditor_Params Parms{};

	Parms.NewUpdateState = NewUpdateState;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetTeleportRotationThreshold
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              Threshold                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetTeleportRotationThreshold(float Threshold)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetTeleportRotationThreshold");

	Params::USkeletalMeshComponent_SetTeleportRotationThreshold_Params Parms{};

	Parms.Threshold = Threshold;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetTeleportDistanceThreshold
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              Threshold                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetTeleportDistanceThreshold(float Threshold)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetTeleportDistanceThreshold");

	Params::USkeletalMeshComponent_SetTeleportDistanceThreshold_Params Parms{};

	Parms.Threshold = Threshold;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetSkeletalMeshAsset
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class USkeletalMesh*               NewMesh                                                          (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetSkeletalMeshAsset(class USkeletalMesh* NewMesh)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetSkeletalMeshAsset");

	Params::USkeletalMeshComponent_SetSkeletalMeshAsset_Params Parms{};

	Parms.NewMesh = NewMesh;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetPosition
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              InPos                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bFireNotifies                                                    (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetPosition(float InPos, bool bFireNotifies)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetPosition");

	Params::USkeletalMeshComponent_SetPosition_Params Parms{};

	Parms.InPos = InPos;
	Parms.bFireNotifies = bFireNotifies;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetPlayRate
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              Rate                                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetPlayRate(float Rate)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetPlayRate");

	Params::USkeletalMeshComponent_SetPlayRate_Params Parms{};

	Parms.Rate = Rate;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetPhysicsBlendWeight
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              PhysicsBlendWeight                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetPhysicsBlendWeight(float PhysicsBlendWeight)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetPhysicsBlendWeight");

	Params::USkeletalMeshComponent_SetPhysicsBlendWeight_Params Parms{};

	Parms.PhysicsBlendWeight = PhysicsBlendWeight;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetNotifyRigidBodyCollisionBelow
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewNotifyRigidBodyCollision                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bIncludeSelf                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetNotifyRigidBodyCollisionBelow(bool bNewNotifyRigidBodyCollision, class FName BoneName, bool bIncludeSelf)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetNotifyRigidBodyCollisionBelow");

	Params::USkeletalMeshComponent_SetNotifyRigidBodyCollisionBelow_Params Parms{};

	Parms.bNewNotifyRigidBodyCollision = bNewNotifyRigidBodyCollision;
	Parms.BoneName = BoneName;
	Parms.bIncludeSelf = bIncludeSelf;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetMorphTarget
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        MorphTargetName                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Value                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bRemoveZeroWeight                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetMorphTarget(class FName MorphTargetName, float Value, bool bRemoveZeroWeight)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetMorphTarget");

	Params::USkeletalMeshComponent_SetMorphTarget_Params Parms{};

	Parms.MorphTargetName = MorphTargetName;
	Parms.Value = Value;
	Parms.bRemoveZeroWeight = bRemoveZeroWeight;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetEnablePhysicsBlending
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewBlendPhysics                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetEnablePhysicsBlending(bool bNewBlendPhysics)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetEnablePhysicsBlending");

	Params::USkeletalMeshComponent_SetEnablePhysicsBlending_Params Parms{};

	Parms.bNewBlendPhysics = bNewBlendPhysics;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetEnableGravityOnAllBodiesBelow
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bEnableGravity                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bIncludeSelf                                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetEnableGravityOnAllBodiesBelow(bool bEnableGravity, class FName BoneName, bool bIncludeSelf)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetEnableGravityOnAllBodiesBelow");

	Params::USkeletalMeshComponent_SetEnableGravityOnAllBodiesBelow_Params Parms{};

	Parms.bEnableGravity = bEnableGravity;
	Parms.BoneName = BoneName;
	Parms.bIncludeSelf = bIncludeSelf;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetEnableBodyGravity
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bEnableGravity                                                   (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetEnableBodyGravity(bool bEnableGravity, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetEnableBodyGravity");

	Params::USkeletalMeshComponent_SetEnableBodyGravity_Params Parms{};

	Parms.bEnableGravity = bEnableGravity;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetDisablePostProcessBlueprint
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInDisablePostProcess                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetDisablePostProcessBlueprint(bool bInDisablePostProcess)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetDisablePostProcessBlueprint");

	Params::USkeletalMeshComponent_SetDisablePostProcessBlueprint_Params Parms{};

	Parms.bInDisablePostProcess = bInDisablePostProcess;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetDisableAnimCurves
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInDisableAnimCurves                                             (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetDisableAnimCurves(bool bInDisableAnimCurves)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetDisableAnimCurves");

	Params::USkeletalMeshComponent_SetDisableAnimCurves_Params Parms{};

	Parms.bInDisableAnimCurves = bInDisableAnimCurves;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetConstraintProfileForAll
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        ProfileName                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bDefaultIfNotFound                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetConstraintProfileForAll(class FName ProfileName, bool bDefaultIfNotFound)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetConstraintProfileForAll");

	Params::USkeletalMeshComponent_SetConstraintProfileForAll_Params Parms{};

	Parms.ProfileName = ProfileName;
	Parms.bDefaultIfNotFound = bDefaultIfNotFound;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetConstraintProfile
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        JointName                                                        (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        ProfileName                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bDefaultIfNotFound                                               (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetConstraintProfile(class FName JointName, class FName ProfileName, bool bDefaultIfNotFound)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetConstraintProfile");

	Params::USkeletalMeshComponent_SetConstraintProfile_Params Parms{};

	Parms.JointName = JointName;
	Parms.ProfileName = ProfileName;
	Parms.bDefaultIfNotFound = bDefaultIfNotFound;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetClothMaxDistanceScale
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              Scale                                                            (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetClothMaxDistanceScale(float Scale)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetClothMaxDistanceScale");

	Params::USkeletalMeshComponent_SetClothMaxDistanceScale_Params Parms{};

	Parms.Scale = Scale;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetBodyNotifyRigidBodyCollision
// (Native, Public, BlueprintCallable)
// Parameters:
// bool                               bNewNotifyRigidBodyCollision                                     (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// class FName                        BoneName                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetBodyNotifyRigidBodyCollision(bool bNewNotifyRigidBodyCollision, class FName BoneName)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetBodyNotifyRigidBodyCollision");

	Params::USkeletalMeshComponent_SetBodyNotifyRigidBodyCollision_Params Parms{};

	Parms.bNewNotifyRigidBodyCollision = bNewNotifyRigidBodyCollision;
	Parms.BoneName = BoneName;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAnimClass
// (Native, Public, BlueprintCallable)
// Parameters:
// class UClass*                      NewClass                                                         (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAnimClass(class UClass* NewClass)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAnimClass");

	Params::USkeletalMeshComponent_SetAnimClass_Params Parms{};

	Parms.NewClass = NewClass;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAnimationMode
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// enum class EAnimationMode          InAnimationMode                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAnimationMode(enum class EAnimationMode InAnimationMode)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAnimationMode");

	Params::USkeletalMeshComponent_SetAnimationMode_Params Parms{};

	Parms.InAnimationMode = InAnimationMode;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAnimation
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class UAnimationAsset*             NewAnimToPlay                                                    (Parm, ZeroConstructor, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAnimation(class UAnimationAsset* NewAnimToPlay)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAnimation");

	Params::USkeletalMeshComponent_SetAnimation_Params Parms{};

	Parms.NewAnimToPlay = NewAnimToPlay;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAngularLimits
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// class FName                        InBoneName                                                       (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Swing1LimitAngle                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              TwistLimitAngle                                                  (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              Swing2LimitAngle                                                 (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAngularLimits(class FName InBoneName, float Swing1LimitAngle, float TwistLimitAngle, float Swing2LimitAngle)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAngularLimits");

	Params::USkeletalMeshComponent_SetAngularLimits_Params Parms{};

	Parms.InBoneName = InBoneName;
	Parms.Swing1LimitAngle = Swing1LimitAngle;
	Parms.TwistLimitAngle = TwistLimitAngle;
	Parms.Swing2LimitAngle = Swing2LimitAngle;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAllowRigidBodyAnimNode
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInAllow                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bReinitAnim                                                      (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAllowRigidBodyAnimNode(bool bInAllow, bool bReinitAnim)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAllowRigidBodyAnimNode");

	Params::USkeletalMeshComponent_SetAllowRigidBodyAnimNode_Params Parms{};

	Parms.bInAllow = bInAllow;
	Parms.bReinitAnim = bReinitAnim;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAllowedAnimCurvesEvaluation
// (Final, Native, Public, HasOutParams, BlueprintCallable)
// Parameters:
// TArray<class FName>                List                                                             (ConstParm, Parm, OutParm, ZeroConstructor, ReferenceParm, NativeAccessSpecifierPublic)
// bool                               bAllow                                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAllowedAnimCurvesEvaluation(TArray<class FName>& List, bool bAllow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAllowedAnimCurvesEvaluation");

	Params::USkeletalMeshComponent_SetAllowedAnimCurvesEvaluation_Params Parms{};

	Parms.List = List;
	Parms.bAllow = bAllow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAllowClothActors
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInAllow                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAllowClothActors(bool bInAllow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAllowClothActors");

	Params::USkeletalMeshComponent_SetAllowClothActors_Params Parms{};

	Parms.bInAllow = bInAllow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAllowAnimCurveEvaluation
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bInAllow                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAllowAnimCurveEvaluation(bool bInAllow)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAllowAnimCurveEvaluation");

	Params::USkeletalMeshComponent_SetAllowAnimCurveEvaluation_Params Parms{};

	Parms.bInAllow = bInAllow;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAllMotorsAngularVelocityDrive
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bEnableSwingDrive                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bEnableTwistDrive                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSkipCustomPhysicsType                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAllMotorsAngularVelocityDrive(bool bEnableSwingDrive, bool bEnableTwistDrive, bool bSkipCustomPhysicsType)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAllMotorsAngularVelocityDrive");

	Params::USkeletalMeshComponent_SetAllMotorsAngularVelocityDrive_Params Parms{};

	Parms.bEnableSwingDrive = bEnableSwingDrive;
	Parms.bEnableTwistDrive = bEnableTwistDrive;
	Parms.bSkipCustomPhysicsType = bSkipCustomPhysicsType;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAllMotorsAngularPositionDrive
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// bool                               bEnableSwingDrive                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bEnableTwistDrive                                                (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// bool                               bSkipCustomPhysicsType                                           (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)

void USkeletalMeshComponent::SetAllMotorsAngularPositionDrive(bool bEnableSwingDrive, bool bEnableTwistDrive, bool bSkipCustomPhysicsType)
{
	static class UFunction* Func = nullptr;

	if (!Func)
		Func = Class->GetFunction("SkeletalMeshComponent", "SetAllMotorsAngularPositionDrive");

	Params::USkeletalMeshComponent_SetAllMotorsAngularPositionDrive_Params Parms{};

	Parms.bEnableSwingDrive = bEnableSwingDrive;
	Parms.bEnableTwistDrive = bEnableTwistDrive;
	Parms.bSkipCustomPhysicsType = bSkipCustomPhysicsType;

	auto Flgs = Func->FunctionFlags;
	Func->FunctionFlags |= 0x400;

	UObject::ProcessEvent(Func, &Parms);


	Func->FunctionFlags = Flgs;

}


// Function Engine.SkeletalMeshComponent.SetAllMotorsAngularDriveParams
// (Final, Native, Public, BlueprintCallable)
// Parameters:
// float                              InSpring                                                         (Parm, ZeroConstructor, IsPlainOldData, NoDestructor, HasGetValueTypeHash, NativeAccessSpecifierPublic)
// float                              InDamping                                              