### What is the purpose of the `alt` attribute on images?

#### Answer

The `alt` attribute provides alternative information for an image if a user cannot view it. The `alt` attribute should be used to describe any images except those which only serve a decorative purpose, in which case it should be left empty.

#### Good to hear

* Decorative images should have an empty `alt` attribute.
* Web crawlers use `alt` tags to understand image content, so they are considered important for Search Engine Optimization (SEO).
* Put the `.` at the end of `alt` tag to improve accessibility.

##### Additional links

* [A good basis for accessibility](https://developer.mozilla.org/en-US/docs/Learn/Accessibility/HTML)

<!-- tags: (html) -->

<!-- expertise: (0) -->
