### What are some of the tools available to test the accessibility of a website or web application?

#### Answer

There are multiple tools that can help you to find for accessibility issues in your website or application.

Check for issues in your website:

* Lighthouse from Google, it provides an option for accessibility testing, it will check for the compliance of different accessibility standards and give you an score with details on the different issues
* Axe Coconut from DequeLabs, it is a Chrome extension that adds a tab in the Developer tools, it will check for accessibility issues and it will classify them by severity and suggest possible solutions

Check for issues in your code:
* Jest Axe, you can add unit tests for accessibility
* React Axe, test your React application with the axe-core accessibility testing library. Results will show in the Chrome DevTools console.
* eslint-plugin-jsx-a11y, pairing this plugin with an editor lint plugin, you can bake accessibility standards into your application in real-time.

Check for individual issues:
* Color Contrast checkers
* Use a screen reader
* Use only keyboard to navigate your site

#### Good to hear

* None of the tools will replace manual testing
* Mention of different ways to test accessibility

##### Additional links

* [Jest Axe](https://github.com/nickcolley/jest-axe)
* [eslint-plugin-jsx-a11y](https://www.w3.org/TR/wai-aria/)
* [React axe](https://github.com/dequelabs/react-axe)
* [Accessibility Checklist](http://romeo.elsevier.com/accessibility_checklist/)

<!-- tags: (accessibility) -->

<!-- expertise: (1) -->
