<!--
repository: https://github.com/Cecilapp/PHPoole/edit/master/docs/
file: 5.Library.md
alias: documentation/5-library
description: "You can use the Cecil PHP library: PHPoole."
-->

# Library

You can use the Cecil PHP library: [PHPoole](https://github.com/Cecilapp/PHPoole).

## Installation

```bash
composer require cecil/phpoole
```

## Usage

```php
PHPoole::create(
    [
        'site' => [
            'title'   => "My website",
            'baseurl' => 'http://localhost:8000/',
        ],
    ]
)->build();
```

The main param of the `create` method should be a PHP array or a [`PHPoole\Config`](https://github.com/Cecilapp/PHPoole/blob/master/src/Config.php) instance.

### Change _source_ directory

```php
PHPoole::create()
    ->setSourceDir(__DIR__.'/source')
    ->build();
```

### Change _destination_ directory

```php
PHPoole::create()
    ->setDestinationDir(__DIR__.'/destination')
    ->build();
```

### Example

```php
<?php
date_default_timezone_set('Europe/Paris');
require_once 'vendor/autoload.php';
use PHPoole\Builder;

PHPoole::create(
    [
        'site' => [
            'title'   => "My website",
            'baseurl' => 'http://localhost:8000/',
        ],
    ]
)->build(); // Run the builder

// Run a local server
exec('php -S localhost:8000 -t _site');
```
