﻿namespace Catel.Tests
{
    using System;
    using System.Runtime.InteropServices;

    public static class GCHelper
    {
        [DllImport("kernel32.dll", EntryPoint = "SetProcessWorkingSetSize", ExactSpelling = true, CharSet = CharSet.Auto, SetLastError = true)]
        private static extern int SetProcessWorkingSetSize(IntPtr process, int minimumWorkingSetSize, int maximumWorkingSetSize);

        public static void CollectAndFreeMemory()
        {
            GC.Collect();
            GC.WaitForPendingFinalizers();

            //GC.WaitForFullGCComplete();

            SetProcessWorkingSetSize(System.Diagnostics.Process.GetCurrentProcess().Handle, -1, -1);
        }
    }
}
