﻿namespace Catel.Runtime.Serialization
{
    /// <summary>
    /// Allows modifications for a specific model for every supported serializer.
    /// </summary>
    /// <typeparam name="TModel">The type of the model.</typeparam>
    public abstract class SerializerModifierBase<TModel> : SerializerModifierBase
    {
        /// <summary>
        /// Called when the object is about to be serialized.
        /// </summary>
        /// <param name="context">The context.</param>
        /// <param name="model">The model.</param>
        public virtual void OnSerializing(ISerializationContext context, TModel model)
        {
            
        }

        /// <summary>
        /// Called when the object is serialized.
        /// </summary>
        /// <param name="context">The context.</param>
        /// <param name="model">The model.</param>
        public virtual void OnSerialized(ISerializationContext context, TModel model)
        {

        }

        /// <summary>
        /// Called when the object is about to be deserialized.
        /// </summary>
        /// <param name="context">The context.</param>
        /// <param name="model">The model.</param>
        public virtual void OnDeserializing(ISerializationContext context, TModel model)
        {

        }

        /// <summary>
        /// Called when the object is deserialized.
        /// </summary>
        /// <param name="context">The context.</param>
        /// <param name="model">The model.</param>
        public virtual void OnDeserialized(ISerializationContext context, TModel model)
        {

        }
    }
}
