﻿namespace Catel.Runtime.Serialization
{
    using System;
    using System.Runtime.Serialization;
    using System.Xml.Serialization;

    /// <summary>
    /// Serializable key value pair.
    /// </summary>
    [Serializable]
    public class SerializableKeyValuePair : System.Runtime.Serialization.ISerializable
    {
        /// <summary>
        /// Gets or sets the key.
        /// </summary>
        /// <value>The key.</value>
        public object? Key { get; set; }

        /// <summary>
        /// Gets or sets the type of the key.
        /// </summary>
        /// <value>The type of the key.</value>
        [ExcludeFromSerialization]
        [XmlIgnore]
        public Type? KeyType { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        /// <value>The value.</value>
        public object? Value { get; set; }

        /// <summary>
        /// Gets or sets the type of the value.
        /// </summary>
        /// <value>The type of the value.</value>
        [ExcludeFromSerialization]
        [XmlIgnore]
        public Type? ValueType { get; set; }

        public SerializableKeyValuePair()
        {

        }

        public SerializableKeyValuePair(SerializationInfo info, StreamingContext context)
        {
            Key = info.GetValue("Key", typeof(object));
            Value = info.GetValue("Value", typeof(object));
        }

        /// <summary>
        /// Populates a <see cref="T:System.Runtime.Serialization.SerializationInfo"/> with the data needed to serialize the target object.
        /// </summary>
        /// <param name="info">The <see cref="T:System.Runtime.Serialization.SerializationInfo"/> to populate with data.</param>
        /// <param name="context">The destination (see <see cref="T:System.Runtime.Serialization.StreamingContext"/>) for this serialization.</param>
        /// <exception cref="T:System.Security.SecurityException">
        /// The caller does not have the required permission.
        /// </exception>
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("Key", Key);
            info.AddValue("Value", Value);
        }
    }
}
