﻿
#nullable enable

//------------------------------------------------------------------------------ 
// <auto-generated> 
// This code was generated by a tool. 
// 
// Changes to this file may cause incorrect behavior and will be lost if 
// the code is regenerated. 
// </auto-generated> 
//------------------------------------------------------------------------------


namespace Catel.Data
{
    using Catel.Logging;
    using Catel.Reflection;
    using System;
    using System.ComponentModel;
    using System.Linq;
    using System.Reflection;

    public partial class ModelBase
    {
        /// <summary>
        /// Registers a property that will be automatically handled by this object.
        /// </summary>
        /// <param name="name">Name of the property.</param>
        /// <param name="type">Type of the property.</param>
        /// <param name="defaultValue">Default value of the property.</param>
        /// <param name="propertyChangedEventHandler">The property changed event handler.</param>
        /// <param name="includeInSerialization">if set to <c>true</c>, the property should be included in the serialization.</param>
        /// <param name="includeInBackup">if set to <c>true</c>, the property should be included in the backup when handling IEditableObject.</param>
        /// <param name="isModelBaseProperty">if set to <c>true</c>, the property is declared by the <see cref="ModelBase"/>.</param>
        /// <returns>
        /// <see cref="PropertyData"/> containing the property information.
        /// </returns>
        /// <exception cref="ArgumentException">The <paramref name="name"/> is <c>null</c> or whitespace.</exception>
        public static IPropertyData RegisterPropertyNonGeneric(string name, Type type, object? defaultValue = null,
            EventHandler<PropertyChangedEventArgs>? propertyChangedEventHandler = null, bool includeInSerialization = true,
            bool includeInBackup = true, bool isModelBaseProperty = false)
        {
            return RegisterPropertyNonGeneric(name, type, () => defaultValue, propertyChangedEventHandler, includeInSerialization, includeInBackup, isModelBaseProperty);
        }

        /// <summary>
        /// Registers a property that will be automatically handled by this object.
        /// </summary>
        /// <param name="name">Name of the property.</param>
        /// <param name="type">Type of the property.</param>
        /// <param name="createDefaultValue">Default value of the property.</param>
        /// <param name="propertyChangedEventHandler">The property changed event handler.</param>
        /// <param name="includeInSerialization">if set to <c>true</c>, the property should be included in the serialization.</param>
        /// <param name="includeInBackup">if set to <c>true</c>, the property should be included in the backup when handling IEditableObject.</param>
        /// <param name="isModelBaseProperty">if set to <c>true</c>, the property is declared by the <see cref="ModelBase"/>.</param>
        /// <returns>
        /// <see cref="PropertyData"/> containing the property information.
        /// </returns>
        /// <exception cref="ArgumentException">The <paramref name="name"/> is <c>null</c> or whitespace.</exception>
        public static IPropertyData RegisterPropertyNonGeneric(string name, Type type, Func<object?>? createDefaultValue,
            EventHandler<PropertyChangedEventArgs>? propertyChangedEventHandler = null, bool includeInSerialization = true,
            bool includeInBackup = true, bool isModelBaseProperty = false)
        {
            if (type == typeof(Boolean))
            {
                Func<Boolean>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Boolean>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Boolean typedValue)
                        {
                            return typedValue;
                        }

                        return default(Boolean);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Boolean>(() => 
                    {
                        return default(Boolean);
                    });
                }

                return RegisterProperty<Boolean>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Char))
            {
                Func<Char>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Char>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Char typedValue)
                        {
                            return typedValue;
                        }

                        return default(Char);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Char>(() => 
                    {
                        return default(Char);
                    });
                }

                return RegisterProperty<Char>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(SByte))
            {
                Func<SByte>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<SByte>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is SByte typedValue)
                        {
                            return typedValue;
                        }

                        return default(SByte);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<SByte>(() => 
                    {
                        return default(SByte);
                    });
                }

                return RegisterProperty<SByte>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Byte))
            {
                Func<Byte>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Byte>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Byte typedValue)
                        {
                            return typedValue;
                        }

                        return default(Byte);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Byte>(() => 
                    {
                        return default(Byte);
                    });
                }

                return RegisterProperty<Byte>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Int16))
            {
                Func<Int16>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Int16>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Int16 typedValue)
                        {
                            return typedValue;
                        }

                        return default(Int16);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Int16>(() => 
                    {
                        return default(Int16);
                    });
                }

                return RegisterProperty<Int16>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(UInt16))
            {
                Func<UInt16>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<UInt16>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is UInt16 typedValue)
                        {
                            return typedValue;
                        }

                        return default(UInt16);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<UInt16>(() => 
                    {
                        return default(UInt16);
                    });
                }

                return RegisterProperty<UInt16>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Int32))
            {
                Func<Int32>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Int32>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Int32 typedValue)
                        {
                            return typedValue;
                        }

                        return default(Int32);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Int32>(() => 
                    {
                        return default(Int32);
                    });
                }

                return RegisterProperty<Int32>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(UInt32))
            {
                Func<UInt32>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<UInt32>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is UInt32 typedValue)
                        {
                            return typedValue;
                        }

                        return default(UInt32);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<UInt32>(() => 
                    {
                        return default(UInt32);
                    });
                }

                return RegisterProperty<UInt32>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Int64))
            {
                Func<Int64>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Int64>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Int64 typedValue)
                        {
                            return typedValue;
                        }

                        return default(Int64);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Int64>(() => 
                    {
                        return default(Int64);
                    });
                }

                return RegisterProperty<Int64>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(UInt64))
            {
                Func<UInt64>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<UInt64>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is UInt64 typedValue)
                        {
                            return typedValue;
                        }

                        return default(UInt64);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<UInt64>(() => 
                    {
                        return default(UInt64);
                    });
                }

                return RegisterProperty<UInt64>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Single))
            {
                Func<Single>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Single>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Single typedValue)
                        {
                            return typedValue;
                        }

                        return default(Single);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Single>(() => 
                    {
                        return default(Single);
                    });
                }

                return RegisterProperty<Single>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Double))
            {
                Func<Double>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Double>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Double typedValue)
                        {
                            return typedValue;
                        }

                        return default(Double);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Double>(() => 
                    {
                        return default(Double);
                    });
                }

                return RegisterProperty<Double>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(Decimal))
            {
                Func<Decimal>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<Decimal>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is Decimal typedValue)
                        {
                            return typedValue;
                        }

                        return default(Decimal);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<Decimal>(() => 
                    {
                        return default(Decimal);
                    });
                }

                return RegisterProperty<Decimal>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(DateTime))
            {
                Func<DateTime>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<DateTime>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is DateTime typedValue)
                        {
                            return typedValue;
                        }

                        return default(DateTime);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<DateTime>(() => 
                    {
                        return default(DateTime);
                    });
                }

                return RegisterProperty<DateTime>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            if (type == typeof(String))
            {
                Func<string?>? createTypedDefaultValue = null;

                if (createDefaultValue is Func<object?> func)
                {
                    createTypedDefaultValue = new Func<string?>(() => 
                    {
                        var finalDefaultValue = createDefaultValue();
                        if (finalDefaultValue is string typedValue)
                        {
                            return typedValue;
                        }

                        return default(string);
                    });
                }
                else
                {
                    // Just return the default
                    createTypedDefaultValue = new Func<string?>(() => 
                    {
                        return default(string);
                    });
                }

                return RegisterProperty<string?>(name, createTypedDefaultValue, propertyChangedEventHandler,
                    includeInSerialization, includeInBackup, isModelBaseProperty);
            }

            // Backwards compatibility, slow but required. Uses this method:

            // private static IPropertyData RegisterProperty<TValue>(string name, Func<TValue>? createDefaultValue = null,
            //    EventHandler<PropertyChangedEventArgs>? propertyChangedEventHandler = null, bool includeInSerialization = true,
            //    bool includeInBackup = true, bool isModelBaseProperty = false)

            MethodInfo? registerPropertyMethod = null;

            foreach (var methodInfo in typeof(ModelBase).GetMethodsEx(BindingFlagsHelper.GetFinalBindingFlags(true, true, true)))
            {
                if (!methodInfo.IsGenericMethod)
                {
                    continue;
                }

                if (methodInfo.Name != nameof(RegisterProperty))
                {
                    continue;
                }

                var parameters = methodInfo.GetParameters();
                if (parameters.Length != 6)
                {
                    continue;
                }

                var parameterInfo = parameters[1];
                if (parameterInfo.ParameterType != typeof(Func<object?>))
                {
                    continue;
                }

                registerPropertyMethod = methodInfo;
                break;
            }

            if (registerPropertyMethod is null)
            {
                throw Log.ErrorAndCreateException<CatelException>("No valid register property method found on model class");
            }

            var finalMethod = registerPropertyMethod.MakeGenericMethod(type);
            var propertyData = (IPropertyData?)finalMethod.Invoke(null, new object?[] { name, createDefaultValue, propertyChangedEventHandler, includeInSerialization, includeInBackup, isModelBaseProperty });
            if (propertyData is null)
            {
                throw Log.ErrorAndCreateException<CatelException>($"Failed to register property '{type.Name}.{name}'");
            }

            return propertyData;
        }

        protected void SetDefaultValueToPropertyBag(IPropertyData propertyData)
        {
            if (propertyData.Type == typeof(Boolean))
            {
                SetValueToPropertyBag<Boolean>(propertyData.Name, propertyData.GetDefaultValue<Boolean>());
                return;
            }

            if (propertyData.Type == typeof(Char))
            {
                SetValueToPropertyBag<Char>(propertyData.Name, propertyData.GetDefaultValue<Char>());
                return;
            }

            if (propertyData.Type == typeof(SByte))
            {
                SetValueToPropertyBag<SByte>(propertyData.Name, propertyData.GetDefaultValue<SByte>());
                return;
            }

            if (propertyData.Type == typeof(Byte))
            {
                SetValueToPropertyBag<Byte>(propertyData.Name, propertyData.GetDefaultValue<Byte>());
                return;
            }

            if (propertyData.Type == typeof(Int16))
            {
                SetValueToPropertyBag<Int16>(propertyData.Name, propertyData.GetDefaultValue<Int16>());
                return;
            }

            if (propertyData.Type == typeof(UInt16))
            {
                SetValueToPropertyBag<UInt16>(propertyData.Name, propertyData.GetDefaultValue<UInt16>());
                return;
            }

            if (propertyData.Type == typeof(Int32))
            {
                SetValueToPropertyBag<Int32>(propertyData.Name, propertyData.GetDefaultValue<Int32>());
                return;
            }

            if (propertyData.Type == typeof(UInt32))
            {
                SetValueToPropertyBag<UInt32>(propertyData.Name, propertyData.GetDefaultValue<UInt32>());
                return;
            }

            if (propertyData.Type == typeof(Int64))
            {
                SetValueToPropertyBag<Int64>(propertyData.Name, propertyData.GetDefaultValue<Int64>());
                return;
            }

            if (propertyData.Type == typeof(UInt64))
            {
                SetValueToPropertyBag<UInt64>(propertyData.Name, propertyData.GetDefaultValue<UInt64>());
                return;
            }

            if (propertyData.Type == typeof(Single))
            {
                SetValueToPropertyBag<Single>(propertyData.Name, propertyData.GetDefaultValue<Single>());
                return;
            }

            if (propertyData.Type == typeof(Double))
            {
                SetValueToPropertyBag<Double>(propertyData.Name, propertyData.GetDefaultValue<Double>());
                return;
            }

            if (propertyData.Type == typeof(Decimal))
            {
                SetValueToPropertyBag<Decimal>(propertyData.Name, propertyData.GetDefaultValue<Decimal>());
                return;
            }

            if (propertyData.Type == typeof(DateTime))
            {
                SetValueToPropertyBag<DateTime>(propertyData.Name, propertyData.GetDefaultValue<DateTime>());
                return;
            }

            if (propertyData.Type == typeof(String))
            {
                SetValueToPropertyBag<String>(propertyData.Name, propertyData.GetDefaultValue<String>());
                return;
            }

            // Fallback to object / class instance (already boxed)
            SetValueToPropertyBag<object>(propertyData.Name, propertyData.GetDefaultValue<object>());
        }
    }
}
