# Awesome WPF [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

A collection of awesome WPF resources, libraries and UI controls.

Inspired by [awesome](https://github.com/sindresorhus/awesome), [awesome-dotnet](https://github.com/quozd/awesome-dotnet),  [awesome-dotnet-core](https://github.com/thangchung/awesome-dotnet-core).

## Contents

* [General](#general)
* [UI Controls](#ui-controls)
* [Fonts](#fonts)
* [Themes](#themes)
* [Libraries](#libraries)
* [Utilities](#utilities)
* [Courses](#courses)
* [Tutorials (Video)](#tutorials-video)
* [Books](#books)
* [Sample Apps](#sample-apps)


## General 

* [Windows Presentation Foundation](https://docs.microsoft.com/en-us/dotnet/framework/wpf/) - Windows Presentation Foundation | Microsoft Docs.
* [Windows Presentation Foundation (WPF) | Github](https://github.com/dotnet/wpf) - Windows Presentation Foundation Github Repository | WPF is a .NET Core UI framework for building Windows desktop applications.
* [How to upgrade a WPF desktop app to .NET 8](https://learn.microsoft.com/en-us/dotnet/desktop/wpf/migration/?view=netdesktop-8.0) This article describes how to upgrade a Windows Presentation Foundation (WPF) desktop app to .NET 8. 
* [WPF-Samples](https://github.com/microsoft/WPF-Samples) - Microsoft Repository for WPF related samples.
* [WPF Tutorial.net](https://www.wpftutorial.net/) - The tutorials will show you how to create the next generation user experience.
* [The complete WPF tutorial](https://www.wpf-tutorial.com/) - WPF tutorial, currently consisting of 125 articles.
* [Xamarin Forms WPF - Preview](https://docs.microsoft.com/en-us/xamarin/xamarin-forms/platform/other/wpf) - Xamarin.Forms now has preview support for the Windows Presentation Foundation (WPF). 

## UI Controls

### Control Suites

* [Actipro WPF Controls](https://www.actiprosoftware.com/products/controls/wpf) - (PAID, COMMERCIAL) A vast toolkit of professional UI controls, including docking windows, ribbons, editors, propertygrid, code editing, charts, gauges, wizards, themes, and much more.
* [Adonis-UI](https://github.com/benruehl/adonis-ui) - (FREE, OPEN SOURCE) Lightweight UI toolkit for WPF applications offering classic but enhanced windows visuals.
* [ComponentOne Studio WPF](https://www.grapecity.com/componentone/wpf-ui-controls) - (PAID, COMMERCIAL) ComponentOne Studio WPF Edition is a collection of easy to use WPF components currently including grids, charting, reporting and scheduling controls.
* [ControlzEx](https://github.com/ControlzEx/ControlzEx) - (FREE, OPEN SOURCE) Shared Controlz for WPF.
* [DevExpress WPF UI Library](https://www.devexpress.com/products/net/controls/wpf/) - (PAID, COMMERCIAL) With over 120 UI controls and tools, the DevExpress WPF UI Library will help you deliver high-performance line of business applications that meet and exceed the needs of your enterprise.
* [Extended WPF Toolkit](https://github.com/xceedsoftware/wpftoolkit) - (FREE FOR NON COMMERCIAL USE, OPEN SOURCE) WPF controls, components and utilities for creating next generation Windows applications.
* [HandyControl](https://github.com/handyOrg/HandyControl) - (FREE, OPEN SOURCE) Contains some simple and commonly used WPF controls.
* [Mahapps.Metro](https://mahapps.com/) - (FREE, OPEN SOURCE) A framework that allows developers to cobble together a better UI for their own WPF applications with minimal effort.
* [Material Design Extensions](https://github.com/spiegelp/MaterialDesignExtensions) - (FREE, OPEN SOURCE) Material Design Extensions is based on Material Design in XAML Toolkit to provide additional controls and features for WPF apps.
* [Material Design In XAML Toolkit](http://materialdesigninxaml.net/) - (FREE, OPEN SOURCE) Material Design UI libraries, styles and additional controls.
* [Modern UI for WPF (MUI)](https://github.com/firstfloorsoftware/mui) - (FREE, OPEN SOURCE) A set of controls and styles converting your WPF application into a great looking Modern UI app. 
* [ModernWPF UI Library](https://github.com/Kinnara/ModernWpf) - (FREE, OPEN SOURCE) Modern styles and controls for your WPF applications.
* [Nevron UI for Win/Mac](https://www.nevron.com/products-open-vision-wpf-ui-controls-overview.aspx) - (FREE) Nevron User Interface Components for WPF | NOV User Interface for .NET. 
* [Ookii Dialogs WPF](https://github.com/ookii-dialogs/ookii-dialogs-wpf) - (FREE, OPEN SOURCE) A set of dialogs for your WPF applications. Included are classes for task dialogs, credential dialog, progress dialog, and common file dialogs.
* [Syncfusion WPF controls](https://www.syncfusion.com/wpf-controls) - (PAID, COMMERCIAL) The Syncfusion WPF controls is a package of over 100 modern WPF UI controls for building beautiful, high performance line-of-business WPF applications.
* [Telerik UI for WPF](https://www.telerik.com/products/wpf/overview.aspx) - (PAID, COMMERCIAL) Telerik UI for WPF | Build beautiful and high-performance WPF business applications fast.
* [Ultimate UI for WPF](https://www.infragistics.com/products/wpf) - (PAID, COMMERCIAL) A complete library of 100+ WPF controls, including lightning-fast grids and charts, and dynamic data visualizations. All .NET 5 compatible.
* [WPFSpark](https://github.com/ratishphilip/wpfspark) - (FREE, OPEN SOURCE) A rich UserControl library to enhance the look and feel of WPF applications. 
* [WPF UI](https://github.com/lepoco/wpfui) - (FREE, OPEN SOURCE) Modern styles and controls for WPF application inspired by the modern Microsoft Fluent Design System. A simple way to make your application written in WPF keep up with modern design trends. Design of the interface, choice of colors and the appearance of the controls were inspired by projects made by Microsoft for Windows 11.

### Individual Controls

* [AvalonEdit](https://github.com/icsharpcode/AvalonEdit) - (FREE, OPEN SOURCE) AvalonEdit is the name of the WPF-based text editor in SharpDevelop 4.x.
* [CefSharp](https://github.com/cefsharp/cefsharp) - (FREE, OPEN SOURCE) .NET (WPF and Windows Forms) bindings for the Chromium Embedded Framework.
* [ColorPickerWPF](https://github.com/drogoganor/ColorPickerWPF) - (FREE, OPEN SOURCE) A simple WPF color picker control for .NET 4.5.2 licensed under MIT. Contains two color gradient images to sample from, and custom palette support.
* [ConsoleControl](https://github.com/dwmkerr/consolecontrol) - (FREE, OPEN SOURCE) ConsoleControl is a C# class library that lets you embed a console in a WinForms or WPF application.
* [Dragablz](https://github.com/ButchersBoy/Dragablz) - (FREE, OPEN SOURCE) Tearable tab control for WPF, which includes docking, tool windows and MDI.
* [Emoji.Wpf](https://github.com/samhocevar/emoji.wpf) - (FREE, OPEN SOURCE) Emoji.Wpf is an implementation of color Emoji rendering for WPF.
* [ffmediaelement](https://github.com/unosquare/ffmediaelement) - (FREE, OPEN SOURCE) FME: The Advanced WPF MediaElement (based on FFmpeg)
* [Fluent.Ribbon](https://github.com/fluentribbon/Fluent.Ribbon) - (FREE, OPEN SOURCE) Fluent.Ribbon is a library that implements an Office-like user interface for the Windows Presentation Foundation (WPF).
* [Gu.Wpf.Geometry](https://github.com/GuOrg/Gu.Wpf.Geometry) - (FREE, OPEN SOURCE) Small library with WPF geometries and shaders.
* [Gu.Wpf.FlipView](https://github.com/GuOrg/Gu.Wpf.FlipView) - (FREE, OPEN SOURCE) A flipview for WPF, handles touch & mouse swipe.
* [Hardcodet NotifyIcon for WPF](https://github.com/hardcodet/wpf-notifyicon) - (FREE, OPEN SOURCE) This is an implementation of a NotifyIcon (aka system tray icon or taskbar icon) for the WPF platform.
* [Interactive Data Display for WPF](https://github.com/microsoft/InteractiveDataDisplay.WPF) - (FREE, OPEN SOURCE) Interactive Data Display for WPF is a set of controls for adding interactive visualization of dynamic data to your application.
* [LightningChart .NET](https://lightningchart.com/net-charts/) - (PAID, COMMERCIAL) High-performance WPF, WinForms & UWP Charts & Graphs.
* [LiveCharts2](https://livecharts.dev/) - (FREE, OPEN SOURCE) Simple, flexible, interactive & powerful charts, maps and gauges for .Net.
* [LoadingIndicators.WPF](https://github.com/zeluisping/LoadingIndicators.WPF) - (FREE, OPEN SOURCE) LoadingIndicators.WPF is a collection of 8 animated loading indicators for WPF compatible with MahApps.Metro.
* [Mapsui](https://mapsui.com) - (FREE, OPEN SOURCE) Mapsui is a .NET Map component for WPF, UWP and Xamarin Android and iOS.
* [mpv.net](https://github.com/stax76/mpv.net) - (FREE, OPEN SOURCE) mpv.net is a modern media player for Windows that works just like mpv.
* [NOV Chart for Wpf](https://www.nevron.com/products-open-vision-nov-chart-control-overview) - (PAID, COMMERCIAL) Charting component for WPF. Features a complete set of charting types, advanced axes and blazing fast performance.
* [NOV Diagram for Wpf](https://www.nevron.com/products-open-vision-nov-diagram-control-overview) - (PAID, COMMERCIAL) Diagramming Framework for WPF. Integrate Microsoft Visio-like functionality in your .NET application.
* [NOV Rich Text Editor for Wpf](https://www.nevron.com/products-open-vision-nov-rich-text-editor-control-overview) - (PAID, COMMERCIAL) An advanced solution for any application that needs solid rich text processing, visualization, or document editing capabilities.
* [Notifications.Wpf](https://github.com/Federerer/Notifications.Wpf) - (FREE, OPEN SOURCE) WPF toast notifications.
* [OxyPlot](https://oxyplot.github.io/) - (FREE, OPEN SOURCE) OxyPlot is a cross-platform plotting library for .NET.
* [PropertyTools](https://github.com/PropertyTools/PropertyTools) - (FREE, OPEN SOURCE) Custom controls for WPF: PropertyGrid, DataGrid, multi-select TreeView, ColorPicker and more.
* [ReoGrid](https://reogrid.net) - (FREE, OPEN SOURCE) Fast and powerful .NET spreadsheet component, support data format, freeze, outline, formula calculation, chart, script execution and etc.
* [SciChart for WPF](https://www.scichart.com/wpf-chart-features/) - (PAID, COMMERCIAL) Realtime, High Performance WPF Chart Library. ~50 2D & 3D WPF Chart Types and Extensive API.
* [Toggle Switch Control Library](https://github.com/ejensen/toggle-switch-control) - (FREE, OPEN SOURCE) The Toggle Switch Control Library creates highly customizable toggle switch controls for WPF and Silverlight apps.
* [WPF AutoComplete TextBox](https://github.com/quicoli/WPF-AutoComplete-TextBox) - (FREE, OPEN SOURCE) An autocomplete TextBox for WPF.
* [WPFCustomMessageBox](https://github.com/evanwon/WPFCustomMessageBox) - (FREE, OPEN SOURCE) WPFCustomMessageBox is a WPF clone of the native Windows/.NET MessageBox with extra features like custom button text.
* [wpfchrometabs](https://github.com/realistschuckle/wpfchrometabs) - (FREE, OPEN SOURCE) A WPF custom tab control built from the ground up to mimic the user experience found in Google's Chrome browser.
* [WpfHexEditorControl](https://github.com/abbaye/WpfHexEditorControl) - (FREE, OPEN SOURCE) Wpf Hexeditor is a fast and fully customisable user control for editing file or stream as hexadecimal. Can be used in Wpf or WinForm application.
* [WPFToastNotification](https://github.com/muhammad-magdy/WPFToastNotification) - (FREE, OPEN SOURCE) Fancy toast notification for WPF applications easy to use and support MVVM pattern.
* [Wpf.Notifications](https://github.com/Enterwell/Wpf.Notifications) - (FREE, OPEN SOURCE) WPF notifications UI controls (as seen in VS Code).
* [WPF-MediaKit](https://github.com/Sascha-L/WPF-MediaKit) - (FREE, OPEN SOURCE) A library to quickly build DirectShow media player controls in WPF. The kit comes with a video player.MediaUriElement (a WPF MediaElement replacement), a VideoCaptureElement for web cams and a DVDPlayerElement.
* [Xaml-Math](https://github.com/ForNeVeR/xaml-math) - (FREE, OPEN SOURCE) XAML-Math is a collection of .NET libraries for rendering mathematical formulae using the LaTeX typesetting style, for the WPF and Avalonia XAML-based frameworks.

## Fonts

* [FontAwesome5](https://github.com/MartinTopfstedt/FontAwesome5) - (FREE, OPEN SOURCE) WPF (.Net and .Net Core) and UWP/WinUI controls for the iconic SVG, font, and CSS toolkit Font Awesome 5. Current Version: v5.15.4
* [FontAwesome6](https://github.com/MartinTopfstedt/FontAwesome6) - (FREE, OPEN SOURCE) WPF (.Net and .Net Core), UWP and WinUI controls for the web's most popular icon set and toolkit. Current Version: 6.2.0
* [FontAwesome.Sharp](https://github.com/awesome-inc/FontAwesome.Sharp) - (FREE, OPEN SOURCE) A library for embbeding Font Awesome icons in WPF & Windows Forms applications via NuGet. Inspired by ioachim/fontawesome.wpf (BitBucket) and Using Font Icons (CodeProject).
* [Font-Awesome-WPF 4.7](https://github.com/charri/Font-Awesome-WPF/blob/master/README-WPF.md) - (FREE, OPEN SOURCE) WPF controls for the iconic font and CSS toolkit Font Awesome. Current Version: v4.7.0
* [wpf.fontawesome5](https://github.com/SubEthaSensOMatic/wpf.fontawesome5) - (FREE, OPEN SOURCE) With wpf.fontawesome5 you can use the popular icon library FontAwesome 5.12.0 within your WPF applications.

## Themes

* [Mahapps.Metro](https://mahapps.com/) - (FREE, OPEN SOURCE) A framework that allows developers to cobble together a better UI for their own WPF applications with minimal effort.
* [Material Design In XAML Toolkit](http://materialdesigninxaml.net/) - (FREE, OPEN SOURCE) Material Design UI libraries, styles and additional controls.
* [ModernWPF UI Library](https://github.com/Kinnara/ModernWpf) - (FREE, OPEN SOURCE) Modern styles and controls for your WPF applications.
* [Wpf Office Theme](https://github.com/TanyaPristupova/WpfOfficeTheme) - (FREE, OPEN SOURCE) WPF theme influenced by minimalistic MS Office style.

## Libraries

* [Caliburn.Micro](https://github.com/Caliburn-Micro/Caliburn.Micro) - (FREE, OPEN SOURCE) A small, yet powerful framework, designed for building applications across all XAML platforms. Its strong support for MV* patterns will enable you to build your solution quickly, without the need to sacrifice code quality or testability.
* [DeftSharp.Windows.Input](https://github.com/Empiree/DeftSharp.Windows.Input) - (FREE, OPEN SOURCE) A simple keyboard/mouse event handler for WPF applications.
* [Elmish.WPF](https://github.com/elmish/Elmish.WPF) - (FREE, OPEN SOURCE) The good parts of MVVM (the data bindings) with the simplicity and robustness of an MVU architecture for the rest of your app. Never write a ViewModel class again!
* [FluentWPF](https://github.com/sourcechord/FluentWPF) - (FREE, OPEN SOURCE) Fluent Design System for WPF.
* [GongSolutions.WPF.DragDrop](https://github.com/punker76/gong-wpf-dragdrop) - (FREE, OPEN SOURCE) An easy to use drag'n'drop framework for WPF.
* [Gu.Localization](https://github.com/GuOrg/Gu.Localization) - (FREE, OPEN SOURCE) Localization for WPF using ResourceManager.
* [MVVM Light Toolkit](http://www.mvvmlight.net/) - (FREE, OPEN SOURCE) The main purpose of the toolkit is to accelerate the creation and development of MVVM applications in Xamarin.Android, Xamarin.iOS, Xamarin.Forms, Windows 10 UWP, Windows Presentation Foundation (WPF), Silverlight, Windows Phone.
* [MvvmCross](https://github.com/MvvmCross/MvvmCross) - (FREE, OPEN SOURCE) The .NET MVVM framework for cross-platform solutions, including Xamarin.iOS, Xamarin.Android, Windows and Mac.
* [Prism](https://github.com/PrismLibrary/Prism) - (FREE, OPEN SOURCE) Prism is a framework for building loosely coupled, maintainable, and testable XAML applications in WPF, and Xamarin Forms.
* [ReactiveUI](https://reactiveui.net/) - (FREE, OPEN SOURCE) An advanced, composable, functional reactive model-view-viewmodel framework for all .NET platforms!
* [Serilog.Sinks.RichTextBox.Wpf](https://github.com/augustoproiete/serilog-sinks-richtextbox) - (FREE, OPEN SOURCE) A Serilog sink that writes log events to any WPF RichTextBox control with coloring and custom theme support.
* [UpbeatUI](https://github.com/pulselyre/UpbeatUI) - (FREE, OPEN SOURCE) A lightweight MVVM framework for quickly developing mobile-style applications for Windows.
* [WPF Animated GIF](https://github.com/XamlAnimatedGif/WpfAnimatedGif) - (FREE, OPEN SOURCE) A simple library to display animated GIF images in WPF, usable in XAML or in code.
* [WPFTabTip](https://github.com/maximcus/WPFTabTip) - (FREE, OPEN SOURCE) Simple TabTip / Virtual Keyboard integration for WPF apps on Win 8.1 and Win 10.
* [Xamarin.Forms.Platform.WPF](https://www.nuget.org/packages/Xamarin.Forms.Platform.WPF/) - (FREE, OPEN SOURCE) Xamarin Forms Renderer to build native UIs for WPF.

## Utilities

* [Snoop](https://github.com/snoopwpf/snoopwpf) - (FREE, OPEN SOURCE) Snoop is the open source WPF spying utility. It allows you to spy/browse the visual tree of a running application.
* [XAML Viewer](https://github.com/huangjia2107/XamlViewer) - (FREE, OPEN SOURCE) XAML Viewer is a lightweight XAML editor.

## Courses

* [Advanced Reusable Styles and Themes in WPF](https://www.pluralsight.com/courses/wpf-advanced-reusable-styles-themes) - (PAID, PLURALSIGHT) Take your WPF XAML skills to the next level by learning how to make modern reusable styles and themes with runtime theme switching. If you've ever wanted to implement light and dark themes in your apps, then this course will show you how.
* [Windows Presentation Foundation Masterclass](https://www.udemy.com/course/windows-presentation-foundation-masterclass/) - (PAID, UDEMY) Leverage WPF with C# and XAML to build real world skills with Azure, REST, MVVM and Machine Learning.
* [WPF Data Binding in Depth](https://www.pluralsight.com/courses/wpf-data-binding-in-depth) - (PAID, PLURALSIGHT) Data binding is one of the most powerful and important capabilities in WPF applications for building data-driven, loosely coupled, maintainable applications. In this course you will learn how to use the end-to-end capabilities of data binding in WPF including both the most common features as well as more advanced capabilities.
* [WPF MVVM in Depth](https://www.pluralsight.com/courses/wpf-mvvm-in-depth) - (PAID, PLURALSIGHT) This course provides end-to-end coverage of what you need to know to effectively apply the MVVM pattern to WPF applications.
* [WPF Productivity Playbook](https://www.pluralsight.com/courses/wpf-productivity-playbook) - (PAID, PLURALSIGHT) This course contains a collection of tips, tricks, and techniques that will help you become a more productive and confident WPF developer, able to leverage the full power of the platform.
* [WPF & XAML: Build 10 WPF applications (C#) in 2020](https://www.udemy.com/course/wpf-xaml-c-sharp/) - (PAID, UDEMY) Learn XAML and WPF development on 10 projects. WPF/C# programming even for beginners

## Tutorials (Video)

* [WPF UI Programming (C#) By AngelSix](https://www.youtube.com/playlist?list=PLrW43fNmjaQVYF4zgsD0oL9Iv6u23PI6M) - (FREE) WPF UI Programming (C#) Youtube Series contaning 45 videos related to WPF.

## Books

* [Mastering Windows Presentation Foundation: Build responsive UIs for desktop applications with WPF](https://www.amazon.com/dp/B085G7BHS8/) - (2nd Edition) by Sheridan Yuen
* [Pro WPF 4.5 in C#: Windows Presentation Foundation in .NET 4.5 ](https://www.amazon.com/dp/1430243651/) - (4th Edition) by Matthew MacDonald.
* [Programming WPF](https://www.amazon.com/dp/0596510373/) - (2nd Edition) by Chris Sells.
* [Windows Presentation Foundation Development Cookbook: 100 recipes to build rich desktop client applications on Windows](https://www.amazon.com/dp/1788399803) - (1st Edition) by Kunal Chowdhury
* [WPF 4.5 Unleashed](https://www.amazon.com/dp/0672336979/) - (1st Edition) by Adam Nathan. 

## Sample Apps

* [SimpleTrader](https://github.com/SingletonSean/SimpleTrader) - A full stack WPF MVVM trading application.
* [The World's Simplest C# WPF MVVM Example](https://github.com/MarkWithall/worlds-simplest-csharp-wpf-mvvm-example) - A simple MVVM example using WPF and C# 9.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

## Credits and sources

[Top 10 WPF Libraries in 2017](https://nugetmusthaves.com/article/top-wpf-libraries)
[6 Best WPF & XAML Courses & Tutorials](https://digitaldefynd.com/best-wpf-xaml-courses/)
