package com.zbkj.common.constants;

/**
 * 通知常量类
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2022 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
public class NotifyConstants {

    /** 支付成功标记*/
    public static final String PAY_SUCCESS_MARK = "paySuccess";
    /** 发货标记 */
    public static final String DELIVER_GOODS_MARK = "deliverGoods";
    /** 收货标记 */
    public static final String RECEIPT_GOODS_MARK = "receiptGoods";
    /** 改价标记 */
    public static final String MODIFY_ORDER_PRICE_MARK = "modifyOrderPrice";
    /** 拼团成功标记 */
    public static final String GROUP_SUCCESS_MARK = "groupSuccess";
    /** 砍价成功标记 */
    public static final String BARGAINING_SUCCESS_MARK = "bargainingSuccess";
    /** 订单配送标记 */
    public static final String FULFILLMENT_ORDER_MARK = "fulfillmentOrder";
    /** 充值成功标记 */
    public static final String RECHARGE_SUCCESS_MARK = "rechargeSuccess";

    /** 支付成功(管理员短信)标记 */
    public static final String PAY_SUCCESS_ADMIN_MARK = "adminPaySuccess";
    /** 收货(管理员)标记 */
    public static final String RECEIPT_GOODS_ADMIN_MARK = "adminReceiptGoods";
    /** 用户下单(管理员)标记 */
    public static final String PLACE_AN_ORDER_ADMIN_MARK = "adminPlaceAnOrder";
    /** 用户发起退款(管理员)标记 */
    public static final String APPLY_ORDER_REFUND_ADMIN_MARK = "adminApplyOrderRefund";
}
