#include <CGAL/draw_polygon_2.h>
#include <CGAL/draw_straight_skeleton_2.h>

#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>
#include <CGAL/Exact_predicates_exact_constructions_kernel.h>
#include <CGAL/Exact_predicates_exact_constructions_kernel_with_sqrt.h>

#include <CGAL/Polygon_2.h>
#include <CGAL/create_offset_polygons_from_polygon_with_holes_2.h>
#include <CGAL/create_straight_skeleton_from_polygon_with_holes_2.h>
#include <CGAL/Cartesian_converter.h>

#include <algorithm>
#include <iostream>
#include <vector>

typedef CGAL::Exact_predicates_exact_constructions_kernel E_Kernel;
typedef E_Kernel::FT E_FT;
typedef E_Kernel::Point_2 E_Point_2;
typedef CGAL::Polygon_2<E_Kernel> E_Polygon_2;

// #define CGAL_SLS_TEST_USE_EPECK_WITH_SQRT
#ifdef CGAL_SLS_TEST_USE_EPECK_WITH_SQRT
typedef CGAL::Exact_predicates_exact_constructions_kernel_with_sqrt I_Kernel;
#else
typedef CGAL::Exact_predicates_inexact_constructions_kernel I_Kernel;
#endif

typedef I_Kernel::FT I_FT;
typedef I_Kernel::Point_2 I_Point_2;
typedef CGAL::Polygon_2<I_Kernel> I_Polygon_2;

typedef CGAL::Cartesian_converter<I_Kernel, E_Kernel> I_to_E;
typedef CGAL::Cartesian_converter<E_Kernel, I_Kernel> E_to_I;

std::vector<std::string> full_x =
{
  "-2666995819864364496385094148155434227908259780079932748074110866156930515683851113756162787171633877717527689766620415031995518420359/2840043548397733015308466358920340100743790923104620697195314113621014877608510691700236767296837484656886151828606107388481634304000",
  "-88606935781910803887879955306724168363200026472808872652936856017418321266003837805443956736413656835687235718184440350138659963749945160154337100502074351199778713/118187005146388281994833749153177010587470850858370366203041800437723868399314854852272073419529555810802334260872787574655105056313082178412319224741155146039296000",
  "-683807329773754742402238990390664245963019095257716463868828411885646472389723950367330213908658643261750633223449390911139195493139149552752452581305522719308206629764720986676835055278834860227/1219501833534826512156189899522745851056762505238237844793541530486477195860153847788936291329040487731471538005744857451237639030497700177072091207351047168144013337768575208923423665333207040000",
  "-927980186637407159387499597713806133505311561965321042280708924202500092745974411150266640165768630077795375555889600317003171658332724734928931486901560942742361073508155396482491748098840746078269057249294364265169003724787/2493786904617891018431905530609792338290378081426110795760089027461433464583473611166752967673141708430380219089589647716310872808861747107608209535684277260446467920135856071873231645535731672813563241445159789480760049664000",
  "-7737303849359365719949529775317927253288289068052688399726635484530251653605947637622036691610216977922796876900653357257053402723661009615556178624905196650222203947093073115096428303029209026621000608829122746306690130104354877948842048906027326605049569/42070514913242023776351755101930381147895911894175842626693933345983408720750911343842842887529593420503482842072734447218759729444850413329392488295317698112822614237156050010636024590666573777774099376450660959184045417761009186633759817849646224506880000",
  "143408900964794736935622438881182406732392085080928877027222998729586106742901086846347655736574357615561003955697290124433871557266317303559449023087391851355815588389580279219662062296592484108621794080032522640750201936073607284087108778821736702140865908852366183961467546264594707/37160905664900772091197684903055671695129665163310014518831671164416094452459537550999341154465478132985535391000162492290941958352050227054755827054223077527298209918781502685314789179945973775892420615897191645374886879234057905988005406773553776719055762461615463035753133716275200000",
  "140527080667371855959330513044612851690801287218346766337027096055727352918560822509077184261106318903861664397623708876990054103407463536495024967818011093969048217915185274224936788351417191678566023507274723137493150121015465636170359758373902348283322536707577536735057467084917247201737466493399809804198155360203/735088764484871372301521827404383754332883083374196459954276631271560310404358988682993749212036680683181283886818295817099678249012879903005947594517907380393112061742694112490379836290380715174326688655427607889739476585922796422564725101988549733221258999074070663055481960783820855976556302113108899119130214400000",
  "1808261373172535188083218135679124459725733151539102783095346671885241538166114515176750423848082161135103543320423701583656377456153362703633875325171848657431677462914965006481873217027208732357123749095663644499193347889625501994151177044317116070351468209371946296753791687375859108482732289504904407893671018396816697001836982244608518439915523/4783886578963871751133012016912487087687710339556391102969687736085620617202941872763258515488655493689096412933865281915619896709142836080843991359780953565787048222767706463718708507419660407077535584523370752429005652964537974324535836611591469752364964980062694456144796890229047291539353280916076452683870021789591848014699718166990081228800000",
  "19486278567579019023038597171737130562583021301284338208586606428174530524397473973052121733942813210922079123143745778575675948065759440245508185263059692253411020014919192802637168247603915762715409207148785394673827931022577274296503132881332389662719638248839052165765655198462190704336874129198263077961643160260780234751943843840033476842383069639115920598508632003223626441/34532604541767506426798295051892911666238375908789689760419241886060979170251090432771179105225854613059489995191958361443114714741047501660384539563579390409352858346676549151432793690502434644895269343547486993590647393997733355054164060410082951452818446862487477675999422516825361692267557204614369667022153078159848317057879246234971202610863702479790220261372742074368000000",
  "982093196336934075756370082532239502098561557803329124528734287139633275711343732969174892108664925702555856697854079737109269830315963135649533460006921614952480548847709929432039324884265682894331167492696482166722522242415993320218826940798122491054990168515750407456868124481948625413562173993588658828159058981212795298912714771502423299242403325128438667316704458200911346975063136570341562359970338413419/1309412466598892778811284233765000482708383340659918714333774572040312523237268791933828289546543590725836784846654337196733829423584460555827371102702359379244809098619766139259163207990849655991825659253745227794629645286937257326098742395165114535415888636318549398520548326230344836205854509275138547515811514287059864386099835404817502448039104799968278239562672524720223070342378804729356505243975680000000",
  "200368630985532939885378485157312905263132645655286403461336243981309842325927789707700865862071878298922103393196757402272704940498073847168552910733901474960987427173157275357749627465881225032135098598093058441135929020357790334441697541822943848818870626049477592915204091445510429282949724355330220244588394963911731408742862259281095974559118630584824812613901643405977595064348995517710420869629255230740892529119048856733721305708937/214258194897492903824435653486856099325806368367492365868098373842070834833713262965911356917253466719103028187722257278964135006003935445128044189236939543934681349364014160186978905624783889852577018444769477450666096900647938378787808518067353398919893329460852279101433784690303417314443687921453631645317651885295994393219483883634721915846649632804009035214096400580805194355274400910654202673895667350443046395486853664446873600000000",
  "62679132261989259254257520334333095080437458937711703424078506681010002787394431045284297701918454487725961624290004482706570039718911346960373609495912083212400336124802282672410572173683775901644383153711208523102538603787156069112117186072814389506320881957410546208772253027027111846338986566557821424447513283242266786804464263478545215300339224679231897052769355446237233824135670749910705029813982258505305599458721929719382593747036001713741780637363159276902153487/55978811093549983563293167367018342658053822064702177745120953845684660138297164382006657972958885434019582571924671297649771057315892709024650954775005758416248649520964582715417373032138701311516495130557703830571329469442607424023047939412519283706067807190193008830905591793740343539080018458297808530452719630605066255629183573853216654801678044950739609506964789876895736263634238579399791535740132422775412178576969489653661296920226628423525440189200596992000000000",
  "22847007806116749737086245463376476973933499642464189008127156846274690470216468226143376924311655622763073367596186893542715449332297549975714770204378297019963430820881099392887219220943396867367974822928481778379830825648961992087011608283454752245114077905547038611515253686431799324707016176749811907480479771844143300343514192320918454688557452630911579166682005527632752239506039482708578347043437569857989950937423969674544251166277686152561006610218483505521160238415155340651628244160909389353/17526781151544324253452350144494092489949269024790428400834275560823919337742002130039683832230957474854548560160183904752960524646235959908940817967150753772774014666381560483211482577884974749473603153392101718719650988598437512533356975205715728421725590222997468341058421241090486927225942162687523914347843415600332924237958949949779654195960156503962531597503003957430908858130604230780266619583871255478215683402424277333573496406831497800509983903960379008362032773074417757717638466764800000000",
  "470410675948223304833992361225205471707210420584749729937280386240276388163171693585725946481071182196318815670188940240778541968697741147253576053195519335002268834264930595105741573128511591941854022014581295329501435327297917470940736155629621256579138484594669486620357722661675992920311617791224107777300929017323483536109060656892911314018553695172159113158940936410977431009999468770318883143410223786251468312627639412651447383083294870283862872249482342432475861733095767018715488316916179619665312731140702004451648396176969/316413300919428455164376910119230201869353486036450396228295692978088352768099890731527411509364835474581259918500618579644692659865415737992720867069561276448766449252630939989781743285438615564328820315769605202626375705662720561852271598313116071274685871645726401603942087778107222605568525751401807566629636397698506712316866176393564250462252951529222208313195285166195583852045644874974570975240700899022779513976897286927946272285699211653193640569316988783282356423828813955869096075468763811102048415240169573643714560000000",
  "13636885105146605514080470180142616258781009694068644549362441799744349311535292587208490366154346634918229740114631450565996469566935216402210247439009550269601965230893767968199953796773311273891074178373959189869132756493068814095774818830392657164922220512103380179232238756833164077542808772606084985741154685740150073342011292422375028393823591233214252611841174111456487510305288204726516323185540546308821165849320771964887377634224583638708005468330208914300520692132536565820786884370815776223398176951348000732106061381673394464370702406461250489744248503406773419264726858779076058030746543551551068414131930185234232642079781185032692095163132492527795135253210268341377319013984314735671635901849368357710063543920449917003555467428690610406349399246193586009240817788731498209599453001838974000984203892901871125016630435461476487335283657792099222996036178772716399934407650384690141314244014309369757371211053883950708944566283771566690693779963675990730168132690035642204354386370469769921098466689538917722032780835252799095883529306063686014407221032167248609019071563029760891609206257414896297966915910110228020659600695778977301267518220746829858931418115148353/8335959928619162303106964504021962102000066710841324530508944262828505306964357019081926224373684385701061727898692391499179581653428091546161915707281660363791460892256900905288033443579939014944265875969220361494279409291420848706233473922404645600703213073416326273371046727217227001301800631588868004813359281534237115103722014635149141654687953490856094153695771349171663274412552579340649981107391081811127341068171680790044536545809317084551557738763806293777414536767667506324728709287100843605106836749405499471450310646605009252775264938192579715578614308398278454362886211907131707884410622483088923421506260880911907721969722134010436202941704219145979859539133810935435232581739695776085423489250024457363068813329692360190529816977961690816825806487237704439062037652208849997684329094497534599418647269541098144880945556359887972931445234766943200269420603949096619180791595730647352192580860599638569436506081585584288074135577454526513848084022718926644610841250540608419265296249020871051398061189992889261006742448704594117461278681103193347486174262711833774722392399944755714711231111290150924587003850616317629606216486527363316192713917574756377464668160000000",
  "15384546872187457494228291249984048404564075215507590534451132166307412247725663036141057099019414036573/9363038015218618105836393782412084832001577994317608682411829155714326787471824257115429502109037363200",
  "12764889944721166123616325822789560886560886055701482693611406566419952420612321810366272093608447281357606123208076369924956453153955679944901238144350061370299064442492108208250074693981325195482075148922352559495881361689056378517280787980438972207041813704990432338660536573381445829726110725680420105943930877483180775626132146249778551828003085198741196911761537715317327135103350100568157368759164189018022293025088063639969723645422788381329709084713610016828953641715843483338835363868890975546821915798544357282447554418769934678986611814189447566157229046809447919720744053959317273263204659676865565101478291521643611489722156882029831616714929889868481449006011953180521068580333084016657983493075944860117636308007856770472539791141764990444280002276372090773596985139259620697510892892030324400812498271502249280113563356304138298361910094563835733780812488527980086557190370321204938187118739061604056529347/7574937886195169326872564878215603885485674673927346886309460843254552455362592057779464630876346775354463971867596660408540985264927251352466657923763446247448218424519276825826681681169930324741610302733607231985274395147505147613792358726990993618818283527000938398082184449082008731703171096639534674389929933254102721615868328869206313799560308604987781846505426223096421921537383244944765832272238154957223559199976177370253681630996215812353374413853417553089890819048085416883532214540841484308602571146517411691029214332637897963825500763478117359721492513964351954314293173848883661493400999390007080746676256584900733295739280934307938648032081795919993502638702673385497831262556818604857729582348964367282849634166434466199665805056269365569266553874498271024662323447622198444148666750709016307898408225546231299916842492340403627554773107420868572058083552671560780055415423668282834557236459945852928000000",
  "189284574947608002888220985910477191605978678984687276684839904673677093730251263062503921615211137754977501395861486103147290308559440752090032255085301768958706829069997881338820517726919609268794852925452982218933191198822426938460717919500206516444473404032868603192452474453277987842891336236501673352890645754676469083382678647968168265458531042897857955553039090751593535861/115489674152213595129165851367653320409557862379148418269053310115575100439935045575990107536664075793106520539955327682660816927177831154424231188414797620125741841554885867596191134835229628300686619035858663351810988410170362357290050086471532562537517712510416744093047793353623267281862371290925853493415789573523423211120733853460572700914517212978356596052982239330304000000",
  "47988180376078574232150742582309865776677188909320619675575531622651453289856331603374536623449444198593807701182249780726378391629431582991477064966957704486843135959465106420482060701995606038650873233935187070373056478939240147864323320524155342721561947547788488931086904356957540897141480502226561496405183319984789442374281548544754463632591/32944504379613426369814280946743032823373053263527641070282668240993328736180134410691738480438288641525266109077256325089286581746261930082377450622319636999137261373207148485691318550189264177957322503802043576526950039951571536631754853992819968025408830755246183923198273888051631038945150753254521184014387998929435582697614400496336896000000",
  "2258642513266262923069075403301497806892827131227997173328213498720789290838385838024526390690806317793666566308973516585596596186663437545772197775288878843850623234731908639126562345474887147944031921390455717696549745730923199615029362834087391188488257800281853592891286792415871082776986477468280406505428646127247/1773469252213053050037545926454393808228454413775567282042208481182378203430396220863745805066855567103569945683118496061930989713770896440433457426901526411108409360941241961459413253987601938442037152618894854029420912342371565830329327712149815645710183573910902227128163160284205142876381026990615862945251328000000",
  "157818606678748713933812712783753531990044427958828098520915869372564109766154151037165920743793982530482493897055265547288277130493719226676139400499886579131245775723624712132285481107480531436714642336081982446911593163173801209666131116966063565547865714750091988768696986932511781/144811186295288036164616640230943715697327897609539125093108459428604854544697164214318810267359803756217647053116033941500309561523665795102700144475061124379332985531408725484012357979908010053806307431613979634843496662810909798780100011814608056593039741683299896270839925964800000",
  "244291905648127585797283486210313099798530153531675955520847610561862795910220271495543490748480184207559875843760634115845350917731581633963811072940521769925607732973220494524602749245665064119276807004648042365172551325055696321601061521345554612987909737/269808721288902347799057981402517222068921829295597756149349353367984197054027040645370925047794883291096620245824197154141750645771380579878525504292042989499739883885356221328495395915416958853166678540733887394748641436610857261072130424269287142195200000",
  "5125641962467215207314232258111443620849531377673371332867025791679834724379415264639001673331420159152939762956693786894767295672892346169124617663018975753822510955149986877580866896979499042542782679566643704432097285614977/7114813634689880512740215711655365272369373311621158378891512432945243413169351852967203589077217847152061433721470259945226988109061446194428496188484402044041000169206824530729164750792828174634474279532847971741938483200000",
  "131733712811600247115183312696835489853908775071338056824930207680195475728425968291499286115637497701683109058552340205481973861677132775522891110894089623687348713659517865017478432135096385657/246307429967357123075722007508518595196240323195608135775158015481929312423826059314867777933842260745745282234820436594771480727389171738069530642037333275326597652062592496269811455581224960000",
  "52752402986040693634661689043723222312657639375734740618462947259403188689183235725058332139921573691249007670044736238369126461917321417832667808333531239835934377/151279162819771200818599952353450668086479092238329211617193107511670820547288389342634813420403894222496513440794634970813851708533450990503358385500231103938560000",
  "1100592594757427975145641474606222662027118618383024959548697424678413059441086675760922733876682068517643554590876713028003920063061/6790643437362829385751033817435969258224232481012930258811650782359648255919398169340521540325901514038094105524585215732316372992000",
  "-3715304255613755399866501449706388516728584653976114236260831959775372304445633510588521422766224548879303850242852900601068045281294090837008543361912949800526167/151279162819771200818599952353450668086479092238329211617193107511670820547288389342634813420403894222496513440794634970813851708533450990503358385500231103938560000",
  "-642055860452024728502107349414091100891013139534780796705571486422889281892155484165339538428209364825651788924902644607403453669944064412112213015039586752817111942871383297275730754901370262369/3033346348053095194370882865211295079864257327728972985546549936849820579875312259714629104170113654268058734093493234969916086795344519842284197947990668129347020164736422261665577134949662720000",
  "-7017576666918552051258155437567793094224177945927000661108997167899317487122230613728713365916922511370751813693404022169341853867011991819995692767251353874410582919951079096440509392119739284914996083552268565886085238013609/17578458645328609993113440668249938862614115424117958282728953030285032687462213872022359315447028964572051046240757668366744325068016121524114410677610753941596807035222654116597822447019263034932343042217304011166701322240000",
  "-370226047842914883213175541175182736284642252253753499342580566848123841978538314494158129071217901736036883629419186758137216878881940581780005808321518710908294147025029203797739628814838413359660825870421345025858036201840148745299588521647460778100701117/630518773445900613322835097384179411002372980193504981393502499834952648383354557603559589497343982771142663593203089791691751559419264698970664472104940968628411906253699955210349235371432215685952021059990675181663554587631970726895461591551657734307840000",
  "-3372781449573326773147038336291505800146786820295009850726326238778580502589409024327557843158712567492142106528866103248340403186831455371694815883130399606872164136041126080311551331576460741442539257893422429771238574588269828561020918932688355854625348828192325923779152397098690844253/4349021738682301863839431076538780404938375551402949148506593476103816984291231671483305415829736269363386593078475297799991855695046936759930764239793420167005107205949932294335983100313703271763766211727626299837431564148170529620207393320566271711410791232514263823435595756118999040000",
  "-326248045702762718898988646344073515603086090346784153976075155024036090225092717180737221975010443497727289186206731546765372205468220995368956519196961870103107547011032915073890956151237396978084645557821044418294814163772046878760326033641641746664356242740900849289356034134248731246237956989101528115438147416911705207562117292499224357097223829082505772287570188775540268593269339566076681252592258603780112726523117525372657762616449054150051860721251911938297922706733139151652410904227889420613884722475143323626043205096133990814063607287926400474458449079798544184457386595030210802643181269252423881231413091994519064412920806301210322931440769332544609868968519156319117799486248157382671564924961998326857737565490089928781/365409476166273219984377127600273800964087412507563009432398683802913863946859720615756763438784610003795111680747011652316577102917679115812357717314461162825721215155526024341559367938543647166712294230052064820219047698579710071432683866950070073011655085018018784624989798887201688860956677953881048746244373811581505360338607871379430294308527990431394376057905029117275489906277229559861383361995678087857002961357650899862083870364513215226180424774988894331672958818622915326205659399003172808457926442274433557281842957093494721313440148138700153826139524300000222381125960686036511643252048186703237830255179166402744587442056241862711333142136921700042798354384235743812240143670523396618857966640954173695062432719889760256000"
};

std::vector<std::string> full_y =
{
  "1483976480056014541538821201406681621558487166800765725491576420703093881668778615359286099336623295992986638774708913529599271022403/568008709679546603061693271784068020148758184620924139439062822724202975521702138340047353459367496931377230365721221477696326860800",
  "301164394310056644361817898673770890835551397468574458264821379618024451312653931351139308962541790827012158271393561027327328008918613603011499001853036245781530577/118187005146388281994833749153177010587470850858370366203041800437723868399314854852272073419529555810802334260872787574655105056313082178412319224741155146039296000",
  "121109366771052000553604696453926082014331443623651075675114833036684028713934449697765569293141272814390843745719645908884831961738914437946752084882795423932581892871352301280458920046980313187/48780073341393060486247595980909834042270500209529513791741661219459087834406153911557451653161619509258861520229794298049505561219908007082883648294041886725760533510743008356936946613328281600",
  "30127846453712378047049360964148485707575827021754513068653904177188228752712570951507333280870059415167735370142551856939036044533626466917038946523954350750109301620717999399258166982768625285259666641387859503297301277895879/12468934523089455092159527653048961691451890407130553978800445137307167322917368055833764838365708542151901095447948238581554364044308735538041047678421386302232339600679280359366158227678658364067816207225798947403800248320000",
  "12887640830722286059220971259868482860113522886019485063843293432319228651383452226136704628417389131406344631348587276331837827646641746524128603290991170082504164800241229995483323498489462373100326985233407610099021215570076174019210288064190256735449517/5487458466944611796915446317643093193203814594892501212177469566867401137489249305718631680982120880935236892444269710506794747318893532173399020212432743232107297509194267392691655381391292231883578179537042733806614619707957719995707802328214724935680000",
  "84715814742397889204381182379953510260987537826291358960180458556470084384899705516089699369044343002398957720191710977400887769820694729723572396684167563839311655481888074749374027186424677403053372115896210838588948419650652951977723287164834292492026228007023088236210770360022225029/37160905664900772091197684903055671695129665163310014518831671164416094452459537550999341154465478132985535391000162492290941958352050227054755827054223077527298209918781502685314789179945973775892420615897191645374886879234057905988005406773553776719055762461615463035753133716275200000",
  "1624251206558366695357600045248497487679930019231984482361189177632149822628383955789675613892631042715584289365753869483117459559424270085807614307314478289882861241496813299358281383160021497857032761991947342357305929034444785578149630503868865898496602134150243410727242986549935370196858502209486709985144790450061/735088764484871372301521827404383754332883083374196459954276631271560310404358988682993749212036680683181283886818295817099678249012879903005947594517907380393112061742694112490379836290380715174326688655427607889739476585922796422564725101988549733221258999074070663055481960783820855976556302113108899119130214400000",
  "30686660234100750124254768766900340387708752873367361106171689202539024147196450805566741115001412136521805555537957226585004642257972118601861160039093993283701175532417150192709787716121667515359271644721355803418254563200185352218044868181383165276276246397023754142392460981722148641971669898461704390066687061118685637399741587957513908422726463/14351659736891615253399036050737461263063131018669173308909063208256861851608825618289775546465966481067289238801595845746859690127428508242531974079342860697361144668303119391156125522258981221232606753570112257287016958893613922973607509834774409257094894940188083368434390670687141874618059842748229358051610065368775544044099154500970243686400000",
  "71324965664585306432944689109629621912365029813250142422584058122515177922402149552365917726730469424415732411460273543855108685606106921386296404758165735200841555385615327818350268291036405219860401604517056450652692484250068542407353492868275999070450189554562253220667395769020350009831446988150145616858027829776198381686310141677429389847565291108193231534975988468215314047/34532604541767506426798295051892911666238375908789689760419241886060979170251090432771179105225854613059489995191958361443114714741047501660384539563579390409352858346676549151432793690502434644895269343547486993590647393997733355054164060410082951452818446862487477675999422516825361692267557204614369667022153078159848317057879246234971202610863702479790220261372742074368000000",
  "2607394576726494247712002483985785709970526027247793435265686678780965817847447416076285903325774507793654098765229075311007991875780787141594289307594949981175456616568186619203573604843868925933825097879411092611835788062122130115577803273785031621052579980442144887782664646730257935051259871125304923964052061640828495207422977548743320273863693348685047167369768000848667998887199081652437500510874276591853/1309412466598892778811284233765000482708383340659918714333774572040312523237268791933828289546543590725836784846654337196733829423584460555827371102702359379244809098619766139259163207990849655991825659253745227794629645286937257326098742395165114535415888636318549398520548326230344836205854509275138547515811514287059864386099835404817502448039104799968278239562672524720223070342378804729356505243975680000000",
  "23395146919025277599339983096994108250592955384444614093152024779256027130364846715166119785191116656914465330734311697180238971433955968757304451877485677689294458738170543282995897402906624334947935836420442696862378388595442516282953041333436181645659799054158950739268859562817917271099505653977340863769452956169010179704021224303677789995975176627706518868007245333849112814387408874113449689330662177119470909120928539861881653830047623/12212717109157095517992832248750797661570962996947064854481607308998037585521655989056947344283447602988872606700168664900955695342224320372298518786505554004276836913748807130657797620612681721596890051351860214687967523336932487590905085529839143738433919779268579908781725727347294786923290211522857003783106157461871680413510581367179149203259029069828515007203494833105896078250640851907289552412053038975253644542750658873471795200000000",
  "9356028604996760556404582173360934412741545922928721968931693375479110806440650836102590411415204892197162043947371558025364490055247410410591808496472242365562814384295802417673294519258715158561586013336470583356145408188577252715971344706490432102690123069891133057148159683720743302098222026820383388375870548569566164871930886445014158917537511189259125599664155588100660400235454125273181399544616553124313490637337503759956280153050633062603630422050319852989175259/5088982826686362142117560669728940241641256551336561613192813985971332739845196762000605270268989584910871142902242845240888277937808428093150086797727796219658968138269507519583397548376245573774226830050700348233757224494782493093004358128410843973278891562744818984627781072158213049007274405299800775495701784600460568693562143077565150436516185904612691773360435443354157842148567143581799230521830220252310198052451771786696481538202420765775040017200054272000000000",
  "101341206019917056660213760959791896499508991356986728173300732205764805733046888953581972075130184829876331488360137210688932919366308593490538710973370034898628199226540645844669580475876706242454398148849658927857983303110870042389115989493008748280970066340721014173856537906654037386957454540886532979432319868198235072531630887601179605750041580022276788380272914452105432052100780435626063485657984312474442105805507721976532259756754752579677891306978303548084719792787185953559494352429922195631/57587995212217065404200579046194875324119026795739979031312619699850020681152292712987532591616003131664945269097747115616870295266203868272234116177781048110543191046682270159123442755907774176841838932574048504364567533966294684038172918533065964814241225018420253120620526935011599903742381391687578575714342651258236751067579406977847435215297657084448318106081298717272986248143413901135161750061291267999851531179394054096027202479589207058818518541584102456046679111530229775357954962227200000000",
  "4782487653938914097337736938502897438848854806963000952203404171337688429844970422814440175097385234369326129849554558058954877325642498094564808327500114569844909958828834859064921287929129191356274736241526942258401154389767584941512113863473414305149040783733813936018228016986587093607259237871392726080171148404514662853767501905734737462977355722902187590620051041002631651310240570541440734927028658335366247699374152336532276094195558046420753559426616525048049670769996369574230288340193919655579695607967846955199873014529783/2847719708274856096479392191073071816824181374328053566054661236802795174912899016583746703584283519271231339266505567216802233938788741641934487803626051488038898043273678459908035689568947540078959382841926446823637381350964485056670444384818044641472172844811537614435478790002965003450116731762616268099666727579286560410851795587542078254160276563762999874818757566495760254668410803874771138777166308091205015625792075582351516450571292904878742765123852899049541207814459325602821864679218874299918435737161526162793431040000000",
  "13440035601065598852848017744847767784299241776812967560674006180594512858647089122650290220556834348510694314336387858294826971236622106716747070244814550265472660283096854076852326462678923566978909461499949155960399226268186658696876871598429306251572616959229017994925041919016865666316150580505209634881598641791794571375223046089262095152969627058148993341867786919075021136144781781408050545675197970042890104958445245590699453005593095315329595116670206564801898630830475807358902421305499207977980263557442703742938665506356693279967224626625763299189924998106844581457725442306473544098343491161586651571191689718146169237519770613820859598431405879413147366560701810864382808502321537006805160487269464063697307227853818890586738408535602137832357869190984192032624235254088956843650338528513045415750252177305980482408721165468740937823906835451877934953878447116864295193185938164604799543662201737740326320830173390542779503929316588185396745068667587167580008641678263867734518214226506187376377049724931695799418352849227835788021639625282273761891769404537022940804569187856211373909991568358917183881259644743845111795482768456510130158019997444354307455147280596539/8335959928619162303106964504021962102000066710841324530508944262828505306964357019081926224373684385701061727898692391499179581653428091546161915707281660363791460892256900905288033443579939014944265875969220361494279409291420848706233473922404645600703213073416326273371046727217227001301800631588868004813359281534237115103722014635149141654687953490856094153695771349171663274412552579340649981107391081811127341068171680790044536545809317084551557738763806293777414536767667506324728709287100843605106836749405499471450310646605009252775264938192579715578614308398278454362886211907131707884410622483088923421506260880911907721969722134010436202941704219145979859539133810935435232581739695776085423489250024457363068813329692360190529816977961690816825806487237704439062037652208849997684329094497534599418647269541098144880945556359887972931445234766943200269420603949096619180791595730647352192580860599638569436506081585584288074135577454526513848084022718926644610841250540608419265296249020871051398061189992889261006742448704594117461278681103193347486174262711833774722392399944755714711231111290150924587003850616317629606216486527363316192713917574756377464668160000000",
  "15245742165584494863864020917746385452001935060904165098089690271809196003888176714123820585936999520199/9363038015218618105836393782412084832001577994317608682411829155714326787471824257115429502109037363200",
  "22330794847445844797388972138188300568540478119759156960903768341097035432956370633411981365410792428634333776397719753690234348805880365590401000549535067344651102524798935438350775768083372968786910010760047856362351798808938453206194153484812056439307246273443586389254613244673564749885559484568900993590831307248275900782892175604722347021323981474598476258587685347213942999227032928664465544593341195850831122265201870312953043781753304854988116462894705595818216500385877131916907820746898338189534595273648272187236533623480015737333138707862159869627055516368232274115906496412025989551808588790936728514560615625882135911725050373112047707247571593468607378844974938188811160793586779053972753889031064209906662323359352390204574605624536095431038202713556347298200761202059793144141143447163652574314286860174754329600820001769130916096297428331347132920881940044140876764034465303863126586839360688859786618381/12985607804906004560352968362655320946546870869589737519387647159864947066335872099050510795788023043464795380344451417843213117597018145175657127869308764995625517299175903129988597167719880556699903376114755254831898963110008824480786900674841703346545628903430180110998030484140586397205436165667773727525594171292747522770059992347210823656389100465693340308295016382451009008349799848476741426752408265640954672914244875491863454224564941392605784709463001519582669975511003571800340939212871115957604407679744134327478653141664967937986572737391058330951130023938889064538788298026657705417258856097154995565730725574115542792695910173099323396626425935862846004523490297232281996450097403322613250712598224629627742229999601942056569951525033198118742663784854178899421125910209483047112000144072599384968699815222110799857444272583549075808182469864346123528143233151247051523569297717056287812405359907176448000000",
  "150799373971888413163800431060980619657880893559600258686815236403219440074477380072147983460041384742655129554961345252203357491192457305678761432647129735754807107901195854289249297168724096715603164499030987589888251015629686277952264567029064979723596976410054441992567056343155292924753495329173309422610169125147258207034142426553750329749963714646746205997982102219809274231/86617255614160196346874388525739990307168396784361313701789982586681325329951284181992580652498056844829890404966495761995612695383373365818173391311098215094306381166164400697143351126422221225514964276893997513858241307627771767967537564853649421903138284382812558069785845015217450461396778468194390120061842180142567408340550390095429525685887909733767447039736679497728000000",
  "29056549528609811833697219368214975171968911410191539650308317597870387814771871206357256220315017056754022575538991869211985758762269800954778695013825027936474953854923644230417259514989050061041354759304577642562063308087061337022355091284841479110810509751318944336488900594692801082320862140596855684213401700943581736131408333659678326772799/15937438807020780938643921626833480164553847195667592595688693402298720719775454633743730628523717557101508604715945429994492534675951388254137143320537746470361856963012549105090930077851299878297535886579560041891284272573974542071855432613409659856447778514713251313495268861427574755853335916347154728630337051430149031889430343097253888000000",
  "844042215999660731188697258258458224913690073753869892734539830080004384333640971229369958182420018593062878613425976433365755805753297822941077258160466710559664983154223043894502461052902139031498685299258664227839776962750972005942535623377843727250438700835499822229987061754641306377573216151790292971429076238119/443367313053263262509386481613598452057113603443891820510552120295594550857599055215936451266713891775892486420779624015482747428442724110108364356725381602777102340235310490364853313496900484610509288154723713507355228085592891457582331928037453911427545893477725556782040790071051285719095256747653965736312832000000",
  "27409120797723337040425335210617006666014469419812325228384799303331319380698390178714797903926685112712504168308104740353549684833338984520933301424870846328514285758904416187195314545227139977969948094871666998767964412750026992618050600975818151220954035081957861496054501252795923323/13824296463118032881000724262046876859248481082510645763352818287595027721356268569459792137309026980013206091892112811629654552069741381082482767363637085195212752511623411543527322602867646816922294991596577412997738092131912924719257404699301690545471258197123593668998397217996800000",
  "138959752820519009434995093896555749008253814205319029493836108111923518145560849869701219636852503125188685132030717245229882062934106238724845465437311063109550584689985639396557603220753549654165303405213121295446302557865015220711940741519491222215079569/67452180322225586949764495350629305517230457323899439037337338341996049263506760161342731261948720822774155061456049288535437661442845144969631376073010747374934970971339055332123848978854239713291669635183471848687160359152714315268032606067321785548800000",
  "345407463646602845904594448676776256646664673075746088771749997355480546884691336564897745004488961844969557629484494312502019922167506721029237599033734861814821435487365054857316828656595930258320963703199714703503817318107/161700309879315466198641266173985574372031211627753599520261646203300986662939814840163717933573132889819578039124324089664249729751396504418829458829190955546386367481973284789299198881655185787147142716655635721407692800000",
  "16335006820059194040489398001518298602290354281540412424577140203958781142567844731873570614871821006718570088386942396253552651080955944897842266156364879089198624465212709378873318305298585819/7389222899020713692271660225255557855887209695868244073254740464457879372714781779446033338015267822372358467044613097843144421821675152142085919261119998259797929561877774888094343667436748800",
  "9597176889500740077594617164305360580866449628967899866176602112894542441437562212152440478372717488437394923365955132242042881457162979423923604345418955390555273/4202198967215866689405554232040296335735530339953589211588697430879745015202455259517633706122330395069347595577628749189273658570373638625093288486117530664960000",
  "7198624665504149657250794278556737399846367225488634259622921446508383870043966336423760843844225487431682982525410643426132279381569/3055789546813273223587965217846186166200904616455818616465242852061841715163729176203234693146655681317142347486063347079542367846400",
  "30604025219112690073886103264688838795026655204412137548197248917484063092107954435981298130567277288187511926909369965498418278509187196424370450782204616145157531/12606596901647600068216662696120889007206591019860767634766092292639235045607365778552901118366991185208042786732886247567820975711120915875279865458352591994880000",
  "1894527831184417839378056821257055353472302650834937455815530384810719018309831565538833463663255005630695677027768372926535599763538463931956509965375033109667984089527593199501872609943009121207/758336587013273798592720716302823769966064331932243246386637484212455144968828064928657276042528413567014683523373308742479021698836129960571049486997667032336755041184105565416394283737415680000",
  "26329797756840490169044927636631953391183069335052283044403738577627158455558638737955308018066052765827508027662546335814747026888558441993977988844809877728598986994169448099969066809652522253101021299745948082675366445723843/10254100876441689162649507056479131003191567330735475664925222600999602401019624758679709600677433562667029776973775306547267522956342737555733406228606273132598137437213214901348729760761236770377200107960094006513909104640000",
  "415523229940468027626607101233747635400792218706270103652437375420382568267011003671564581711560221993648900610758675936780722310343448062139205355459522491887985136336916606367880567184526167536015516438138264637478417596585128430653296699208391531669078011/157629693361475153330708774346044852750593245048376245348375624958738162095838639400889897374335995692785665898300772447922937889854816174742666118026235242157102976563424988802587308842858053921488005264997668795415888646907992681723865397887914433576960000",
  "1259664315106314001036299780768023775570616710263050607938155157907464700575884450663102629593144898212172637233888954190355100045969599838964585312007283638848069488537173680700700070958508350974883293723553741587680849078542021916703420233038307912419408913336644401908675452186130808871/465966614858818056839939043914869329100540237650315980197135015296837534031203393373211294553186028860362849258408067621427698824469314652849724739977866446464832914923207031535998189319325350546117808399388532125439096158732556745022220712917814826222584774912242552510956688155607040000",
  "30389989540782110473728368050411374004243546950498015672047447812803467121256072555535515206724150663447848525329584897663494658714072084450000107051376363228978910165903680034560249671271183078564398465823808862174829626602313047918535338173571189199866854086024041290216043222967075370554943273699854284994451825104618058549658575885359038795601485461944836824766538133922906091528657345111794924752045906921638768210632413666299415149614999326139594859450382083547541673128448932409041691827446243108750640934605945368256919813424762222040778893253981881370638388841247676488965131625307567265935828645861603063324797349538508067585211513158790642061476896878599852740888495853896189177403777086512656320645349274359329088652547797849/11073014429281006666193246290917387908002648863865545740375717690997389816571506685325962528448018484963488232749909444009593245542959973206435082342862459479567309550167455283077556604198292338385221037274304994552092354502415456710081329301517274939747123788424811655302721178400051177604747816784274204431647691260045616979957814284225160433591757285799829577512273609614408785038703926056405556424111457207787968525989421207941935465591309552308497720454208919141604812685542888672898769666762812377512922493164653250964938093742264282225459034506065267458773463636370375185635172304136716462183278384946600916823611103113472346728977026142767670973846112122509041041946537691280004353652224139965392928513762839244316143026962432000"
};

std::vector<std::string> min_x =
{
  "52752402986040693634661689043723222312657639375734740618462947259403188689183235725058332139921573691249007670044736238369126461917321417832667808333531239835934377/151279162819771200818599952353450668086479092238329211617193107511670820547288389342634813420403894222496513440794634970813851708533450990503358385500231103938560000",
  "1100592594757427975145641474606222662027118618383024959548697424678413059441086675760922733876682068517643554590876713028003920063061/6790643437362829385751033817435969258224232481012930258811650782359648255919398169340521540325901514038094105524585215732316372992000",
  "-3715304255613755399866501449706388516728584653976114236260831959775372304445633510588521422766224548879303850242852900601068045281294090837008543361912949800526167/151279162819771200818599952353450668086479092238329211617193107511670820547288389342634813420403894222496513440794634970813851708533450990503358385500231103938560000",
  "-642055860452024728502107349414091100891013139534780796705571486422889281892155484165339538428209364825651788924902644607403453669944064412112213015039586752817111942871383297275730754901370262369/3033346348053095194370882865211295079864257327728972985546549936849820579875312259714629104170113654268058734093493234969916086795344519842284197947990668129347020164736422261665577134949662720000",
  "-7017576666918552051258155437567793094224177945927000661108997167899317487122230613728713365916922511370751813693404022169341853867011991819995692767251353874410582919951079096440509392119739284914996083552268565886085238013609/17578458645328609993113440668249938862614115424117958282728953030285032687462213872022359315447028964572051046240757668366744325068016121524114410677610753941596807035222654116597822447019263034932343042217304011166701322240000",
  "-370226047842914883213175541175182736284642252253753499342580566848123841978538314494158129071217901736036883629419186758137216878881940581780005808321518710908294147025029203797739628814838413359660825870421345025858036201840148745299588521647460778100701117/630518773445900613322835097384179411002372980193504981393502499834952648383354557603559589497343982771142663593203089791691751559419264698970664472104940968628411906253699955210349235371432215685952021059990675181663554587631970726895461591551657734307840000",
  "-3372781449573326773147038336291505800146786820295009850726326238778580502589409024327557843158712567492142106528866103248340403186831455371694815883130399606872164136041126080311551331576460741442539257893422429771238574588269828561020918932688355854625348828192325923779152397098690844253/4349021738682301863839431076538780404938375551402949148506593476103816984291231671483305415829736269363386593078475297799991855695046936759930764239793420167005107205949932294335983100313703271763766211727626299837431564148170529620207393320566271711410791232514263823435595756118999040000",
  "-326248045702762718898988646344073515603086090346784153976075155024036090225092717180737221975010443497727289186206731546765372205468220995368956519196961870103107547011032915073890956151237396978084645557821044418294814163772046878760326033641641746664356242740900849289356034134248731246237956989101528115438147416911705207562117292499224357097223829082505772287570188775540268593269339566076681252592258603780112726523117525372657762616449054150051860721251911938297922706733139151652410904227889420613884722475143323626043205096133990814063607287926400474458449079798544184457386595030210802643181269252423881231413091994519064412920806301210322931440769332544609868968519156319117799486248157382671564924961998326857737565490089928781/365409476166273219984377127600273800964087412507563009432398683802913863946859720615756763438784610003795111680747011652316577102917679115812357717314461162825721215155526024341559367938543647166712294230052064820219047698579710071432683866950070073011655085018018784624989798887201688860956677953881048746244373811581505360338607871379430294308527990431394376057905029117275489906277229559861383361995678087857002961357650899862083870364513215226180424774988894331672958818622915326205659399003172808457926442274433557281842957093494721313440148138700153826139524300000222381125960686036511643252048186703237830255179166402744587442056241862711333142136921700042798354384235743812240143670523396618857966640954173695062432719889760256000"
};

std::vector<std::string> min_y =
{
  "9597176889500740077594617164305360580866449628967899866176602112894542441437562212152440478372717488437394923365955132242042881457162979423923604345418955390555273/4202198967215866689405554232040296335735530339953589211588697430879745015202455259517633706122330395069347595577628749189273658570373638625093288486117530664960000",
  "7198624665504149657250794278556737399846367225488634259622921446508383870043966336423760843844225487431682982525410643426132279381569/3055789546813273223587965217846186166200904616455818616465242852061841715163729176203234693146655681317142347486063347079542367846400",
  "30604025219112690073886103264688838795026655204412137548197248917484063092107954435981298130567277288187511926909369965498418278509187196424370450782204616145157531/12606596901647600068216662696120889007206591019860767634766092292639235045607365778552901118366991185208042786732886247567820975711120915875279865458352591994880000",
  "1894527831184417839378056821257055353472302650834937455815530384810719018309831565538833463663255005630695677027768372926535599763538463931956509965375033109667984089527593199501872609943009121207/758336587013273798592720716302823769966064331932243246386637484212455144968828064928657276042528413567014683523373308742479021698836129960571049486997667032336755041184105565416394283737415680000",
  "26329797756840490169044927636631953391183069335052283044403738577627158455558638737955308018066052765827508027662546335814747026888558441993977988844809877728598986994169448099969066809652522253101021299745948082675366445723843/10254100876441689162649507056479131003191567330735475664925222600999602401019624758679709600677433562667029776973775306547267522956342737555733406228606273132598137437213214901348729760761236770377200107960094006513909104640000",
  "415523229940468027626607101233747635400792218706270103652437375420382568267011003671564581711560221993648900610758675936780722310343448062139205355459522491887985136336916606367880567184526167536015516438138264637478417596585128430653296699208391531669078011/157629693361475153330708774346044852750593245048376245348375624958738162095838639400889897374335995692785665898300772447922937889854816174742666118026235242157102976563424988802587308842858053921488005264997668795415888646907992681723865397887914433576960000",
  "1259664315106314001036299780768023775570616710263050607938155157907464700575884450663102629593144898212172637233888954190355100045969599838964585312007283638848069488537173680700700070958508350974883293723553741587680849078542021916703420233038307912419408913336644401908675452186130808871/465966614858818056839939043914869329100540237650315980197135015296837534031203393373211294553186028860362849258408067621427698824469314652849724739977866446464832914923207031535998189319325350546117808399388532125439096158732556745022220712917814826222584774912242552510956688155607040000",
  "30389989540782110473728368050411374004243546950498015672047447812803467121256072555535515206724150663447848525329584897663494658714072084450000107051376363228978910165903680034560249671271183078564398465823808862174829626602313047918535338173571189199866854086024041290216043222967075370554943273699854284994451825104618058549658575885359038795601485461944836824766538133922906091528657345111794924752045906921638768210632413666299415149614999326139594859450382083547541673128448932409041691827446243108750640934605945368256919813424762222040778893253981881370638388841247676488965131625307567265935828645861603063324797349538508067585211513158790642061476896878599852740888495853896189177403777086512656320645349274359329088652547797849/11073014429281006666193246290917387908002648863865545740375717690997389816571506685325962528448018484963488232749909444009593245542959973206435082342862459479567309550167455283077556604198292338385221037274304994552092354502415456710081329301517274939747123788424811655302721178400051177604747816784274204431647691260045616979957814284225160433591757285799829577512273609614408785038703926056405556424111457207787968525989421207941935465591309552308497720454208919141604812685542888672898769666762812377512922493164653250964938093742264282225459034506065267458773463636370375185635172304136716462183278384946600916823611103113472346728977026142767670973846112122509041041946537691280004353652224139965392928513762839244316143026962432000"
};

std::vector<std::string> extra_min_x =
{
  "52752402986040693634661689043723222312657639375734740618462947259403188689183235725058332139921573691249007670044736238369126461917321417832667808333531239835934377/151279162819771200818599952353450668086479092238329211617193107511670820547288389342634813420403894222496513440794634970813851708533450990503358385500231103938560000",
  "1100592594757427975145641474606222662027118618383024959548697424678413059441086675760922733876682068517643554590876713028003920063061/6790643437362829385751033817435969258224232481012930258811650782359648255919398169340521540325901514038094105524585215732316372992000",
  "-3715304255613755399866501449706388516728584653976114236260831959775372304445633510588521422766224548879303850242852900601068045281294090837008543361912949800526167/151279162819771200818599952353450668086479092238329211617193107511670820547288389342634813420403894222496513440794634970813851708533450990503358385500231103938560000",
  "-642055860452024728502107349414091100891013139534780796705571486422889281892155484165339538428209364825651788924902644607403453669944064412112213015039586752817111942871383297275730754901370262369/3033346348053095194370882865211295079864257327728972985546549936849820579875312259714629104170113654268058734093493234969916086795344519842284197947990668129347020164736422261665577134949662720000",
  "-326248045702762718898988646344073515603086090346784153976075155024036090225092717180737221975010443497727289186206731546765372205468220995368956519196961870103107547011032915073890956151237396978084645557821044418294814163772046878760326033641641746664356242740900849289356034134248731246237956989101528115438147416911705207562117292499224357097223829082505772287570188775540268593269339566076681252592258603780112726523117525372657762616449054150051860721251911938297922706733139151652410904227889420613884722475143323626043205096133990814063607287926400474458449079798544184457386595030210802643181269252423881231413091994519064412920806301210322931440769332544609868968519156319117799486248157382671564924961998326857737565490089928781/365409476166273219984377127600273800964087412507563009432398683802913863946859720615756763438784610003795111680747011652316577102917679115812357717314461162825721215155526024341559367938543647166712294230052064820219047698579710071432683866950070073011655085018018784624989798887201688860956677953881048746244373811581505360338607871379430294308527990431394376057905029117275489906277229559861383361995678087857002961357650899862083870364513215226180424774988894331672958818622915326205659399003172808457926442274433557281842957093494721313440148138700153826139524300000222381125960686036511643252048186703237830255179166402744587442056241862711333142136921700042798354384235743812240143670523396618857966640954173695062432719889760256000"
};

std::vector<std::string> extra_min_y =
{
  "9597176889500740077594617164305360580866449628967899866176602112894542441437562212152440478372717488437394923365955132242042881457162979423923604345418955390555273/4202198967215866689405554232040296335735530339953589211588697430879745015202455259517633706122330395069347595577628749189273658570373638625093288486117530664960000",
  "7198624665504149657250794278556737399846367225488634259622921446508383870043966336423760843844225487431682982525410643426132279381569/3055789546813273223587965217846186166200904616455818616465242852061841715163729176203234693146655681317142347486063347079542367846400",
  "30604025219112690073886103264688838795026655204412137548197248917484063092107954435981298130567277288187511926909369965498418278509187196424370450782204616145157531/12606596901647600068216662696120889007206591019860767634766092292639235045607365778552901118366991185208042786732886247567820975711120915875279865458352591994880000",
  "1894527831184417839378056821257055353472302650834937455815530384810719018309831565538833463663255005630695677027768372926535599763538463931956509965375033109667984089527593199501872609943009121207/758336587013273798592720716302823769966064331932243246386637484212455144968828064928657276042528413567014683523373308742479021698836129960571049486997667032336755041184105565416394283737415680000",
  "30389989540782110473728368050411374004243546950498015672047447812803467121256072555535515206724150663447848525329584897663494658714072084450000107051376363228978910165903680034560249671271183078564398465823808862174829626602313047918535338173571189199866854086024041290216043222967075370554943273699854284994451825104618058549658575885359038795601485461944836824766538133922906091528657345111794924752045906921638768210632413666299415149614999326139594859450382083547541673128448932409041691827446243108750640934605945368256919813424762222040778893253981881370638388841247676488965131625307567265935828645861603063324797349538508067585211513158790642061476896878599852740888495853896189177403777086512656320645349274359329088652547797849/11073014429281006666193246290917387908002648863865545740375717690997389816571506685325962528448018484963488232749909444009593245542959973206435082342862459479567309550167455283077556604198292338385221037274304994552092354502415456710081329301517274939747123788424811655302721178400051177604747816784274204431647691260045616979957814284225160433591757285799829577512273609614408785038703926056405556424111457207787968525989421207941935465591309552308497720454208919141604812685542888672898769666762812377512922493164653250964938093742264282225459034506065267458773463636370375185635172304136716462183278384946600916823611103113472346728977026142767670973846112122509041041946537691280004353652224139965392928513762839244316143026962432000"
};

#ifndef CGAL_SLS_TEST_USE_EPECK_WITH_SQRT
I_Polygon_2 exact_to_inexact_poly(const E_Polygon_2& poly)
{
  E_to_I converter;

  std::vector<I_Point_2> boundary;
  std::transform(poly.vertices_begin(), poly.vertices_end(),
                 std::back_inserter(boundary),
                 [&](const E_Point_2& p) { return converter(p); });

  return I_Polygon_2(boundary.begin(), boundary.end());
}
#endif

void test(const std::vector<std::string>& x,
          const std::vector<std::string>& y)
{
#ifdef CGAL_SLS_TEST_USE_EPECK_WITH_SQRT
  std::vector<I_Point_2> poly_vec;
  for (size_t i = 0; i < x.size(); ++i)
    poly_vec.emplace_back(I_FT(x[i]), I_FT(y[i]));

  I_Polygon_2 ipoly (poly_vec.begin(), poly_vec.end());
#else
  std::vector<E_Point_2> poly_vec;
  for (size_t i = 0; i < x.size(); ++i)
    poly_vec.emplace_back(E_FT(E_FT::ET(x[i])), E_FT(E_FT::ET(y[i])));

  E_Polygon_2 poly(poly_vec.begin(), poly_vec.end());
  I_Polygon_2 ipoly = exact_to_inexact_poly(poly);
#endif

  CGAL::draw(ipoly);

  std::shared_ptr< CGAL::Straight_skeleton_2<I_Kernel> > skeleton = CGAL::create_interior_straight_skeleton_2(ipoly, I_Kernel());

  if(!skeleton)
  {
    std::cerr << "bad skeleton!" << std::endl;
    assert(false);
    return;
  }

  CGAL::draw(*skeleton);
}

int main()
{
  test(full_x, full_y);
  test(min_x, min_y);
  test(extra_min_x, extra_min_y);

  std::cout << "Done" << std::endl;
  return EXIT_SUCCESS;
}
