export function omit<T extends object>(
  obj: T,
  ...values: (keyof T)[]
): Partial<T> {
  const newObject = Object.assign({}, obj);
  for (const key of values) {
    delete (newObject as any)[key];
  }
  return newObject;
}
