type Global = typeof global | typeof window | typeof self | typeof globalThis;

export function getGlobalThis(): Global {
  if (typeof globalThis !== 'undefined') {
    return globalThis;
  }
  if (typeof window !== 'undefined') {
    return window;
  }
  if (typeof global !== 'undefined') {
    return global;
  }
  if (typeof self !== 'undefined') {
    return self;
  }
  return globalThis;
}
