## NOTE

At the moment, we are investigating some performance issues in our gen2 React SDK that prevent us from recommending it over the gen1 React SDK for all customer use-cases. Our team is actively working on these issues, and once they are resolved our recommendation will be to use the gen2 React SDK.

# Builder.io React SDK v2

This is the React v2 SDK, `@builder.io/sdk-react`. It is a complete rewrite of the React SDK, and has the following benefits:

- zero client-side dependencies
- far smaller bundle size (25kb)

NOTE: if you are using the SDK in a webapp that gets deployed on a serverless environment (like Next or Hydrogen), you might need to import the SDK from `@builder.io/sdk-react/edge`. This is a special import that handles edge cases surrounding serverless environments.

## API Reference

To use the SDK, you need to:

- fetch the builder data using `fetchOneEntry`: you can see how to use it here https://www.builder.io/c/docs/content-api, and how it differs from the React V1 SDK's `builder.get()` function.

- pass that data to the `Content` component. Here is a simplified example showing how you would use both:

```tsx
import { Content, fetchOneEntry, isPreviewing } from '@builder.io/sdk-react';
import { useEffect, useState } from 'react';

const BUILDER_PUBLIC_API_KEY = 'YOUR API KEY';

function App() {
  const [content, setContent] = useState(undefined);

  useEffect(() => {
    fetchOneEntry({
      model: 'page',
      apiKey: BUILDER_PUBLIC_API_KEY,
      userAttributes: {
        urlPath: window.location.pathname || '/',
      },
    }).then((content) => {
      setContent(content);
    });
  }, []);

  const shouldRenderBuilderContent = content || isPreviewing();

  return shouldRenderBuilderContent ? (
    <Content content={content} model="page" apiKey={BUILDER_PUBLIC_API_KEY} />
  ) : (
    <div>Content Not Found</div>
  );
}
```

Look at the [examples](#examples) for more information.

## Mitosis

This SDK is generated by [Mitosis](https://github.com/BuilderIO/mitosis). To see the Mitosis source-code, go [here](../../).

## Feature Support

To check the status of the SDK, look at [these tables](../../README.md#feature-implementation).

## Getting Started

```
npm install @builder.io/sdk-react
```

## Examples

- [React + Vite](../../../../examples/react-v2/)
- [Next.js App Router](../../../../examples/nextjs-app-dir-v2/)
- [Next.js Pages Router](../../../../examples/nextjs-pages-dir-v2/)

## Fetch

This Package uses fetch. See [these docs](https://github.com/BuilderIO/this-package-uses-fetch/blob/main/README.md) for more information.
