# Builder.io Angular SDK

This is Builder's Gen2 Angular SDK.

## Getting Started

```bash
npm install @builder.io/sdk-angular
```

To use the SDK, you need to:

- fetch the builder data using `fetchOneEntry`: you can see how to use it here https://www.builder.io/c/docs/content-api.
- pass that data to the `Content` component. Here is a simplified example showing how you would use both:

```ts
import { Component } from '@angular/core';
import { fetchOneEntry, type BuilderContent } from '@builder.io/sdk-angular';

@Component({
  selector: 'app-catchall',
  template: `
    <ng-container *ngIf="content; else notFound">
      <builder-content [model]="model" [content]="content" [apiKey]="apiKey"></builder-content>
    </ng-container>

    <ng-template #notFound>
      <div>404 - Content not found</div>
    </ng-template>
  `,
})
export class CatchAllComponent {
  apiKey = 'YOUR_API_KEY';
  model = 'page';
  content: BuilderContent | null = null;

  async ngOnInit() {
    const urlPath = window.location.pathname || '';

    const content = await fetchOneEntry({
      apiKey: this.apiKey,
      model: this.model,
      userAttributes: {
        urlPath,
      },
    });

    if (!content) {
      return;
    }

    this.content = content;
  }
}
```

## Mitosis

This SDK is generated by [Mitosis](https://github.com/BuilderIO/mitosis). To see the Mitosis source-code, go [here](../../).

## Feature Support

To check the status of the SDK, look at [these tables](../../README.md#feature-implementation).

## Fetch

This Package uses fetch. See [these docs](https://github.com/BuilderIO/this-package-uses-fetch/blob/main/README.md) for more information.

## Version Support

This SDK supports Angular version `>=16.2.12`.
