import { expect } from '@playwright/test';
import { excludeTestFor, test } from '../helpers/index.js';

test.describe('XSS Exploit', () => {
  test('attempts XSS exploit through postMessage', async ({ page, context, sdk }) => {
    // doesn't work for these as they are SSR frameworks without a hydration step.
    // therefore jsCode blocks are not run on the client at all
    test.skip(excludeTestFor(['qwik', 'rsc'], sdk));

    // Create a promise that will resolve when a new page is created
    const newPagePromise = context.waitForEvent('page');

    // Navigate to the exploit page and get the current URL
    await page.goto('/xss-exploit');

    // Wait for the new page to open
    const newPage = await newPagePromise;

    // Wait for timeout to ensure exploit had time to execute
    await newPage.waitForTimeout(4000);

    const textContent = await newPage.textContent('body');

    // Verify no exploit text was shown
    expect(textContent).not.toBe('Exploit attempted');
    await newPage.close();
  });
});
