import { expect } from '@playwright/test';
import { test, checkIsGen1React, checkIsRN } from '../helpers/index.js';

test.describe('Hover animations', () => {
  test('Button should change color when hovered', async ({ page, sdk }) => {
    test.fail(checkIsRN(sdk), 'hover animation is not handled in react native SDK');
    await page.goto('/hover-animation');

    const button = checkIsGen1React(sdk) ? page.locator('span') : page.locator('button');

    await expect(button).toHaveCSS('background-color', 'rgb(0, 0, 0)');

    await button.hover();
    await page.waitForTimeout(1000);

    await expect(button).toHaveCSS('background-color', 'rgb(149, 79, 79)');
  });
});
