package com.example.myapplication

import android.content.ContentValues.TAG
import android.util.Log
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.layout.boundsInRoot
import androidx.compose.ui.layout.onGloballyPositioned
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import kotlinx.serialization.json.JsonElement

fun dpToPixel(dp: Dp): Int {
    return dp.value.toInt() / 2
}

@Composable
fun RenderBlock(block: BuilderBlock) {
    // TODO: only fillMaxWidth if should
    Box(
        Modifier
            .padding(
                getStyleInt(block, "marginLeft").dp,
                getStyleInt(block, "marginTop").dp,
                getStyleInt(block, "marginRight").dp,
                getStyleInt(block, "marginBottom").dp
            )
            .background(getStyleColor(block, "backgroundColor", Color.Transparent))
            .fillMaxWidth()
            .padding(
                getStyleInt(block, "paddingLeft").dp,
                getStyleInt(block, "paddingTop").dp,
                getStyleInt(block, "paddingRight").dp,
                getStyleInt(block, "paddingBottom").dp
            )
    ) {
        val name = block.component?.name

        if (name != null) {
            val factory = components.get(name)
            if (factory != null) {
                var options = block.component.options ?: emptyMap()
                factory(options as Map<String, JsonElement>, block)
            }
        } else if (block.children != null) {
            Column {
                block.children.forEach { child ->
                    RenderBlock(child)
                }
            }
        }
    }
}

typealias ComponentFactory =  @Composable (Map<String, JsonElement>, BuilderBlock) -> Unit
val components = mutableMapOf<String, ComponentFactory>()

fun registerComponent(options: ComponentOptions, component: ComponentFactory) {
    _registerComponent(options, component)
}

fun _registerComponent(options: ComponentOptions, component: ComponentFactory) {
    components[options.name] = component
}

data class ComponentOptions(val name: String, val inputs: ArrayList<ComponentInput>? = null)

data class ComponentInput(
    val type: String,
    val name: String,
    val defaultValue: Any
)