export const getLocaleFromPathname = (pathname) =>
	`${pathname.match(/[^/]+?(?=\/|$)/)}`.toLowerCase();

export const defaultLocale = 'en';
// Match this with the locales defined in your builder space
export const supportedLocales = ['en', 'fr', 'de'];
export const routeRegex = new RegExp(/^\/[^.]*([?#].*)?$/);

// checks if a string is a route request (i.e not an asset request like /image.png) https://regexr.com/73ccb
export const isRoute = (pathname) => routeRegex.test(pathname);
