import { getLocaleFromPathname, defaultLocale, supportedLocales, isRoute } from './utils';

/** @type {import('@sveltejs/kit').Handle} */
export const handle = async ({ event, resolve }) => {
	const { url, request } = event;
	const { pathname } = url;

	// If this request is a route request
	if (isRoute(pathname)) {
		// Try to get locale from `pathname`.
		let locale = supportedLocales.find(
			(l) => `${l}`.toLowerCase() === getLocaleFromPathname(pathname)
		);

		// If route locale is not supported
		if (!locale) {
			// Get user preferred locale
			locale = `${`${request.headers.get('accept-language')}`.match(
				/[a-zA-Z]+?(?=-|_|,|;)/
			)}`.toLowerCase();

			// Set default locale if user preferred locale does not match
			if (!supportedLocales.includes(locale)) locale = defaultLocale;
			// 301 redirect
			return new Response(undefined, {
				headers: { location: `/${locale}${pathname}${event.url.search}` },
				status: 301
			});
		}

		// Add html `lang` attribute
		return resolve(event, {
			transformPageChunk: ({ html }) => html.replace(/<html.*>/, `<html lang="${locale}">`)
		});
	}

	return resolve(event);
};
