import { observable, reaction } from 'mobx'

const advancedModeLocalStorageKey = 'advancedMode'

export const settings = observable({
  advancedMode: localStorage.getItem(advancedModeLocalStorageKey) === 'true',
})

reaction(
  () => settings.advancedMode,
  (value) => {
    localStorage.setItem(advancedModeLocalStorageKey, String(value))
  }
)
