<h2 align="center">Contributing</h2>
<p align="center"><img src="./image-assets/logo.svg" width="250"><p>
<p align="center">
        <img alt="Script" src="https://img.shields.io/badge/Shell_Script-121011?style=for-the-badge&logo=gnu-bash&logoColor=white">
        <img alt="License" src="https://img.shields.io/badge/MIT-LICENSE-1976D2?style=for-the-badge">
        <img alt="Version" src="https://img.shields.io/badge/v-1.11.11-D8DEE9?style=for-the-badge">
</p>

Thank you for considering contributing to this project. We welcome contributions from everyone. By participating in this
project, you agree to abide by our code of conduct.

The following is a set of guidelines for contributing to HAL 2023 CLI. These are mostly guidelines, not rules. Use
your best judgment, and feel free to propose changes to this document in a pull request.

### Getting Started

- Make sure you have a GitHub account.
- Fork the repository on GitHub.
- Review the README to get an overview of the project.
- Clone the forked repository to your local machine using `git clone https://github.com/Brutuski/hal2023-cli.git`.
- If your changes don't correspond to any present issues listed, please create a new issue first.
- Create a new branch with a self-explanatory name for your changes: `git checkout -b my-branch-name`.
- Make your changes, test them and commit them to your branch.
- Push your changes to your forked repository: `git push origin branch-name`.
- Submit a pull request to the original repository. Include any screenshots etc.

### Issues and Pull Requests

If you find a bug or have an idea for a new feature, please open an issue in
the [GitHub issue tracker](https://github.com/Brutuski/hal2023-cli/issues).

If you want to contribute a fix or a new feature,
- If you are contributing a new feature, please open a new issue for it first.
- Fork the repository, create a new branch with a self-explanatory name
- Submit a pull request. 
  - Be sure to explain the problem you're solving, how you're solving it,
    and include any relevant tests and screenshots.
  - Link the issue you are solving.

### Coding Standards

We follow the [Google Style Guide for Bash](https://google.github.io/styleguide/shellguide.html#s7-naming-conventions).
Please make sure your code follows these guidelines before submitting a pull request.
Leave comments as necessary.

### Commit Messages

Please ensure that your commit messages are clear and concise. Use the present tense and a short summary of what was
changed. For example

`git commit -m "v 1.xx.x" -m "Added lorem + Fixed Ipsum + Updated README`

### Tests

Please include tests for any new features or bug fixes. Tests should cover as much of the codebase as possible and
ensure that everything works as expected.

### Thank You

Thank you for contributing to this project. Your time and effort is greatly appreciated.