<div align="center">
  
# Awesome JAMstack

![](https://repository-images.githubusercontent.com/208843661/aa3deb80-6311-11ea-9d41-b2cdbbde72a9)

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Made in Nigeria](https://img.shields.io/badge/Made%20in-Nigeria-008751.svg?style=flat-square)](https://github.com/BolajiAyodeji/awesome-technical-writing)

*This list is inspired by the [awesome](https://github.com/sindresorhus/awesome) list and [awesome-technical-writing](https://github.com/BolajiAyodeji/awesome-technical-writing) lists*

</div>

---

> [!TIP]
> [JAMstack](https://jamstack.org) is a Modern web development architecture based on client-side JavaScript, reusable APIs, and prebuilt Markup. The JAMstack is not about specific technologies. It’s a new way of building websites and apps that delivers better performance, higher security, lower cost of scaling, and a better developer experience.

---

## Table of Contents

- [Official Resources](#official-resources)
- [Community](#community)
- [Useful Tools](#useful-tools)
- [Articles](#articles)
- [Speaker Decks](#speaker-decks)
- [Books](#books)
- [Videos](#videos)
- [Examples](#examples)

## Official Resources

* [Official Website](https://jamstack.org/)
* [JAMstack Radio](https://www.netlify.com/tags/podcast/)
* [JAMstack Boilerplates](https://templates.netlify.com/)
* [Netlify Blog](https://www.netlify.com/blog/)
* [What is the JAMstack?](https://jamstack.org/#what)
* [Why the JAMstack?](https://jamstack.org/#why)
* [How do I get started?](https://jamstack.org/#how)
* [JAMstack best practices](https://jamstack.org/best-practices/)
* [JAMstack resources](https://jamstack.org/resources/)

## Community

* [Jamstack Community](https://jamstack.org/community)
* [Jamstack Discord Community](https://discord.gg/jamstack)
* [Jamstack Conf](https://jamstackconf.com)
* [Jamstack Conf on Twitter](https://twitter.com/jamstackconf)
* [Jamstack_dev at Reddit](https://www.reddit.com/r/JAMstack_dev/)
* [Jamstack at Linkedin](https://www.linkedin.com/groups/8722827/)
* [GitHub](https://github.com/jamstack)
* [YouTube](https://www.youtube.com/channel/UC8bRyfU7ycLXnEBfvdorpUg)

## Useful Tools

* [StaticGen](https://www.staticgen.com/) - A List of Static Site Generators for JAMstack Sites
* [Headless CMS](https://headlesscms.org/) - A List of Content Management Systems for JAMstack Sites
* [Netlify](https://www.netlify.com/) - Everything you need to build fast, modern websites from local development
to global deployment.
* [StaticKit](https://statickit.com/) - Form Hosting for JAMstack Sites
* [Zeit](https://zeit.co/) - The easiest way to deploy websites 
* [Disqus](https://disqus.com/) - Blog comment hosting service for your JAMstack sites
* [Netlify Forms](https://www.netlify.com/products/forms/) - Manage forms and submissions without any server-side code or JavaScript.
* [Stackbit](https://www.stackbit.com/) - Create a CMS-connected JAMstack site deployed to Netlify in minutes.
* [JAMstackThemes.dev](https://jamstackthemes.dev/) - A list of themes for JAMstack sites for most popular static site generators.
* [JAMstack CMS](https://github.com/jamstack-cms/jamstack-cms) - JAMstack CMS gives you the ability to deploy a full stack serverless website in just a few minutes.
* [Commerce Layer](https://commercelayer.io) - Headless commerce platform and order management system that lets you add global shopping capabilities to any website, mobile app, chatbot, or IoT device, with ease.
* [Plasmic](https://www.plasmic.app/) - Powerful design tool for building your React components and Jamstack websites visually.
* [Snipcart](https://snipcart.com) - Shopping cart you can simply add to any of your favorite website stack.

## Articles

 * [Introducing JAMstack: The Modern Web Architecture](https://www.blog.bolajiayodeji.com/introducing-jamstack-the-modern-web-architecture/)
 * [JAMstack Fundamentals: What, What And How](https://www.smashingmagazine.com/2019/06/jamstack-fundamentals-what-what-how/)
 * [What is JAMstack and why you should try it](https://www.giftegwuenu.com/what-is-ja-mstack-and-why-you-should-try-it)
 * [Static Websites + JAMstack = <3](https://julian.is/article/static-websites-and-jamstack/)
 * [How to Build a JAMstack Website](https://cosmicjs.com/blog/how-to-build-a-jamstack-website)
 * [Useful APIs to know when building a JAMstack app](https://blog.logrocket.com/jamstack-app-apis/)
 * [Go static: 5 reasons to try JAMstack on your next project](https://builtvisible.com/go-static-try-jamstack/)
 * [JAMstack for Clients: On Benefits & Static Site CMS](https://snipcart.com/blog/jamstack-clients-static-site-cms)
 * [A JAMstack-ready CMS](https://www.contentful.com/r/knowledgebase/jamstack-cms/)
 * [Building JAMStack powered react-static sites using GraphQL on Postgres](https://hashnode.com/post/building-jamstack-powered-react-static-sites-using-graphql-on-postgres-cjs1unp39001fjps2z5ux0k9g)
 * [Isomorphic Rendering on the JAMstack](https://www.hawksworx.com/blog/isomorphic-rendering-on-the-jam-stack/)
 * [Dynamic product management in a static e-commerce workflow](https://www.contentful.com/blog/2016/02/10/snipcart-middleman-contentful)
 * [Secure and Scalable: An Introduction to JAMstack](https://scotch.io/tutorials/secure-and-scalable-an-introduction-to-jamstack)
 * [New to JAMstack? Everything You Need to Know to Get Started](https://snipcart.com/blog/jamstack)
 * [Zero to HTTP/2 with AWS and Hugo](https://habd.as/zero-to-http-2-aws-hugo/)
 * [Getting Started With Hugo and Deploying to Netlify](https://www.blog.bolajiayodeji.com/getting-started-with-hugo-and-deploying-to-netlify/)
 * [What is the JAMstack?](https://flaviocopes.com/jamstack/)
 * [A JAMstack-ready CMS](https://www.contentful.com/r/knowledgebase/jamstack-cms/)
 * [JAMstack Basics: How to Create a Gatsby Starter with Contentful and Deploy to Netlify](https://itnext.io/jamstack-basics-how-to-create-a-gatsby-starter-with-contentful-and-deploy-to-netlify-846354cc74bc)
 * [The Promise of JAMStack](https://blog.strapi.io/jamstack/)
 * [JAMstack vs Isomorphic Server Side Rendering](https://www.netlify.com/blog/2017/06/06/jamstack-vs-isomorphic-server-side-rendering/)
 * [New to JAMstack? How to make a site from A to Z](https://www.netlify.com/blog/2016/11/15/new-to-jamstack-how-to-make-a-site-from-a-to-z/)
 * [From WordPress to JAMstack: How to make your website 10x faster](https://hackernoon.com/from-wordpress-to-jamstack-how-to-make-your-website-10x-faster-e363abc46e2d)
 * [JAMstack: The What, The Why and The How](https://scotch.io/tutorials/jamstack-the-what-the-why-and-the-how)
 * [Adopting the JAMStack: Building CMS-backed static websites with Vue or React](https://www.codegram.com/blog/a-jamstack-journey-headless-content-management-with-vue-react/)
 * [Build a JAMstack Personal Blog with Headless Ghost 2.0 CMS & Gatsby](https://josebrowne.com/tutorial-static-blog-using-headless-ghost-2-0-gatsby-netlify/)
 * [How to Build a JAMstack Website using Vue.js, Nuxt.js and Cosmic JS](https://cosmicjs.com/articles/how-to-build-a-jamstack-website-using-vuejs-nuxtjs-and-cosmic-js-jws3mpy1)
 * [A Ghost Demo: How to Go Headless with Ghost CMS [Tutorial]](https://hashnode.com/post/a-ghost-demo-how-to-go-headless-with-ghost-cms-tutorial-cjy4fxmmr0001rts1pyp2ch2s)
 * [Next.js E-Commerce Tutorial: Quick Shopping Cart Integration](https://hashnode.com/post/nextjs-e-commerce-tutorial-quick-shopping-cart-integration-cjy074x9l0017zxs17tn6yp4d)
 * [How to Build a Blog using React Static and Cosmic JS](https://sumitkharche.hashnode.dev/how-to-build-a-blog-using-react-static-and-cosmic-js-cjxewj3xa000kjms1c9s0qaae)
 * [How to build a Static Serverless Blog for Free😇](https://sujaykundu.hashnode.dev/how-to-build-a-static-serverless-blog-for-free-cjwgqd96u001ezws1v8linwdk)
 * [JAMStack vs serverless web apps](https://fettblog.eu/jamstack-vs-serverless-web-apps/)
 * [JAMstack? More like SHAMstack.](https://css-tricks.com/jamstack-more-like-shamstack/)
 * [Static File Hosting Doesn’t Have To Be So… Static](https://css-tricks.com/static-file-hosting-doesnt-have-to-be-so-static/)
 * [Modern Jamstack Hosting and Deployment Solutions](https://bejamas.io/blog/jamstack-hosting-deployment/)
 * [Static First: Pre-Generated JAMstack Sites with Serverless Rendering as a Fallback](https://css-tricks.com/static-first-pre-generated-jamstack-sites-with-serverless-rendering-as-a-fallback/)
 * [Hey, let’s create a functional calendar app with the JAMstack](https://css-tricks.com/hey-lets-create-a-functional-calendar-app-with-the-jamstack/)
 * [What Is JAMstack](https://buttercms.com/blog/what-is-jamstack)
 * [Building a JAMstack Blog: Gatsby and ButterCMS on Netlify](https://buttercms.com/blog/building-a-jamstack-blog-gatsby-and-buttercms-on-netlify)
 * [Making Sense of Jamstack & Serverless Architecture](https://snipcart.com/blog/jamstack-serverless-backend)
 * [Jamstack Ecosystem](https://bejamas.io/blog/jamstack-ecosystem/)
 
## Speaker Decks

* [Rise of the JAMstack](https://speakerdeck.com/biilmann/rise-of-the-jamstack)
* [Harnessing the power of the JAMstack with a Headless CMS](https://slides.com/bolajiayodeji/jamstack-headless-cms#/)
* [Introducing JAMstack - What we talk about when we talk about modern web tools](https://slides.com/khriztianmoreno/jamstack#/)
* [The JAMstack in 2019: Why (and How) to Get Started](https://slides.com/khriztianmoreno/the-jamstack-in-2019-why-and-how-to-get-started#/)
* [Breaking Down Best Practices for JAMstack](https://noti.st/jemimaabu/gNF5op/breaking-down-best-practices-for-jamstack)
* [Is your JAMstack app really JAMstack?](https://slides.com/obinnaekwuno/deck#/)
* [React and the JAMstack - Reactathon Fundamentals 2018](https://speakerdeck.com/biilmann/react-and-the-jamstack-reactathon-fundamentals-2018)
* [The Sweetness of the JAMstack](https://speakerdeck.com/kristinbaumann/the-sweetness-of-the-jamstack)
* [JAMstack Cheatsheet](https://speakerdeck.com/peduarte/jamstack-cheatsheet)
* [Developing with WordPress, the JAMstack way](https://speakerdeck.com/emaildano/developing-with-wordpress-the-jamstack-way)
* [Lightning Talk - JAMStack](https://speakerdeck.com/unicodeveloper/lightning-talk-jamstack)
* [New Stack Lunch Presentation](https://speakerdeck.com/biilmann/new-stack-lunch-presentation)
* [The JAMstack - Smashing Conf Freiburg 2017](https://speakerdeck.com/biilmann/the-jamstack-smashing-conf-freiburg-2017)
* [What the JAMstack?](https://speakerdeck.com/frontendne/what-the-jamstack)

## Books

* [Modern Web Development on the JAMstack](https://www.netlify.com/oreilly-jamstack/) - New Techniques for Ultra Fast Sites and Web Applications by Mathias Biilmann & Phil Hawksworth

## Videos

* [Free, educational video courses about various JAMstack projects and technologies](https://jamstack.training)
* [Rise of the JAMstack - Mathias Biillman](https://www.youtube.com/watch?v=uWTMEDEPw8c)
* [The Rise of the JAMstack CMS — Matt Biilmann](https://www.youtube.com/watch?v=IbNvjNtL1Oo)
* [The New Front-end Stack. Javascript, APIs and Markup - Mathias Biillman](https://vimeo.com/163522126)
* [Frontend for a server-less stack - Brian Douglas](https://www.youtube.com/watch?v=XpveOehxvoM)
* [The State of the JAMstack Nation - Sarah Drasner](https://www.youtube.com/watch?v=COAVmST41Q0)
* [Easy Isomorphic Rendering on the JAMstack - Phil Hawksworth](https://www.youtube.com/watch?v=lRg99MH6rhw)
* [Performant web animations — Emily Hayman](https://www.youtube.com/watch?v=vL4Hwp0z9YQ)
* [Why static types in Javascript? — Preethi Kasireddy](https://www.youtube.com/watch?v=E5y2dozTkZU)
* [A Modern Web Landscape — Matt Biilmann, Frances Berriman, and Wilson Miner](https://www.youtube.com/watch?v=8n5D4SDqIck)
* [You need an API: Now what? — Erin McKean](https://www.youtube.com/watch?v=uWOWTwJA4rc)
* [Using Elm to Prototype and Build Web Applications  – David Calavera](https://www.youtube.com/watch?v=Lmg9v2U6-y4)
* [GraphQL: The Mental Model — Dhaivat Pandya](https://www.youtube.com/watch?v=zWhVAN4Tg6M)
* [JWT FTW WTF? – Matt Biilmann](https://www.youtube.com/watch?v=4wOfjF1_j_0)
* [Jammin' with Markdown — David Wells](https://www.youtube.com/watch?v=LcgPRe7rLT4)
* [JAMstack for clients — Brian Douglas](https://www.youtube.com/watch?v=22XKtBjbEvU)
* [What is the JAMStack?](https://www.youtube.com/watch?v=Y8PXMbr0Kqo)
* [JAMstack Tutorial - Full site using Netlify & Hugo](https://www.youtube.com/watch?v=NSts93C9UeE)
* [Jamstack Getting Started Video](https://www.youtube.com/watch?v=3GdI04dLxyQ)
* [How We Talk About the JAMstack - Matt Biilmann](https://www.youtube.com/watch?v=VzQ0d8-nMhw)
* [The All Powerful Front End Developer - Chris Coyier](https://www.youtube.com/watch?v=grSxHfGoaeg)
* [How freeCodeCamp Serves Millions of Learners Using the JAMstack](https://www.youtube.com/watch?v=e5H7CI3yqPY)
* [My Honest Experience from Start to End with the Jamstack... Umm!?](https://www.youtube.com/watch?v=uFXGJ8hVvaU)
* [Jam Stack: The New Kid on the Block - JS Monthly - March 2019](https://www.youtube.com/watch?v=PzXpCNBcofw)
* [Build Modern JAMstack Websites in Minutes - Ben Edwards](https://www.youtube.com/watch?v=AHZjqYFfzyk)
* [What is the JAMstack? - Phil Hawksworth](https://www.youtube.com/watch?v=Opye_qcRdUo)
* [JAMstack Course - Build websites that are simpler, faster, and more secure](https://www.youtube.com/watch?v=A_l0qrPUJds)

## Examples

* [derrickreimer.com](https://derrickreimer.com) - A JAMstack site build with Jekyll and deployed on Netlify. ([source](https://github.com/derrickreimer/site))
* [ecommerce-netlify.netlify.com](https://ecommerce-netlify.netlify.com) - A JAMstack Ecommerce Site built with Nuxt and Netlify Functions. ([source](https://github.com/sdras/ecommerce-netlify))
* [bolajiayodeji.com](https://bolajiayodeji.com) - A JAMstack site built with Nextjs and deployed on Firebase. ([source](https://github.com/BolajiAyodeji/bolajiayodeji.com))

## Contributing

Found an awesome resource, article, blog, video, speaker deck etc.? Please send me a pull request and follow the [contributors guidelines](/CONTRIBUTING.md).

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://bolajiayodeji.com"><img src="https://avatars2.githubusercontent.com/u/30334776?v=4?s=100" width="100px;" alt="Bolaji Ayodeji"/><br /><sub><b>Bolaji Ayodeji</b></sub></a><br /><a href="#content-BolajiAyodeji" title="Content">🖋</a> <a href="#blog-BolajiAyodeji" title="Blogposts">📝</a> <a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=BolajiAyodeji" title="Documentation">📖</a> <a href="#tool-BolajiAyodeji" title="Tools">🔧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.derrickreimer.com"><img src="https://avatars2.githubusercontent.com/u/341387?v=4?s=100" width="100px;" alt="Derrick Reimer"/><br /><sub><b>Derrick Reimer</b></sub></a><br /><a href="#tool-derrickreimer" title="Tools">🔧</a> <a href="#blog-derrickreimer" title="Blogposts">📝</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://ivanbila.github.io/"><img src="https://avatars0.githubusercontent.com/u/13482373?v=4?s=100" width="100px;" alt="Ivan Bila"/><br /><sub><b>Ivan Bila</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=IvanBila" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://remotesynthesis.com"><img src="https://avatars1.githubusercontent.com/u/216712?v=4?s=100" width="100px;" alt="Brian Rinaldi"/><br /><sub><b>Brian Rinaldi</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=remotesynth" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/derekcoleman"><img src="https://avatars1.githubusercontent.com/u/1326001?v=4?s=100" width="100px;" alt="Derek Coleman"/><br /><sub><b>Derek Coleman</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=derekcoleman" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.fullstacktraining.com"><img src="https://avatars1.githubusercontent.com/u/2042718?v=4?s=100" width="100px;" alt="Tamas Piros"/><br /><sub><b>Tamas Piros</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=tpiros" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://genesisgabiola.now.sh/"><img src="https://avatars0.githubusercontent.com/u/8042418?v=4?s=100" width="100px;" alt="Genesis Gabiola"/><br /><sub><b>Genesis Gabiola</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=genesisgabiola" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://peterthaleikis.com"><img src="https://avatars0.githubusercontent.com/u/8433587?v=4?s=100" width="100px;" alt="Peter Thaleikis"/><br /><sub><b>Peter Thaleikis</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=spekulatius" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/CookieDuster"><img src="https://avatars.githubusercontent.com/u/51830273?v=4?s=100" width="100px;" alt="CookieDuster"/><br /><sub><b>CookieDuster</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=CookieDuster" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ludovic-armand"><img src="https://avatars.githubusercontent.com/u/77077373?v=4?s=100" width="100px;" alt="Ludovic Armand"/><br /><sub><b>Ludovic Armand</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=ludovic-armand" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.dsolemorera.com/"><img src="https://avatars.githubusercontent.com/u/3201518?v=4?s=100" width="100px;" alt="Dani"/><br /><sub><b>Dani</b></sub></a><br /><a href="https://github.com/BolajiAyodeji/awesome-jamstack/commits?author=dsolemorera" title="Documentation">📖</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

---

**Check out my [blog](https://blog.bolajiayodeji.com), [newsletter](https://bawd.bolajiayodeji.com), or say *hi* on [Twitter](https://twitter.com/iambolajiayo).**

## License

[Awesome Jamstack](https://github.com/BolajiAyodeji/awesome-jamstack) © 2019 by [Bolaji Ayodeji](https://bolajiayodeji.com) is licensed under the [Creative Commons Attribution-ShareAlike 4.0 International](https://creativecommons.org/licenses/by-sa/4.0) license.

<p xmlns:cc="http://creativecommons.org/ns#" xmlns:dct="http://purl.org/dc/terms/"><a href="https://creativecommons.org/licenses/by-sa/4.0/?ref=chooser-v1" target="_blank" rel="license noopener noreferrer" style="display:inline-block;"><img style="height:22px!important;margin-left:3px;vertical-align:text-bottom;" src="https://mirrors.creativecommons.org/presskit/icons/cc.svg?ref=chooser-v1" alt=""><img style="height:22px!important;margin-left:3px;vertical-align:text-bottom;" src="https://mirrors.creativecommons.org/presskit/icons/by.svg?ref=chooser-v1" alt=""><img style="height:22px!important;margin-left:3px;vertical-align:text-bottom;" src="https://mirrors.creativecommons.org/presskit/icons/sa.svg?ref=chooser-v1" alt=""></a></p>
