# Contribution Guidelines

You'll need to have some basic experience with Git, Markdown and GitHub

> Check out the following tutorials:
  * [Mastering Markdown](https://guides.github.com/features/mastering-markdown/)
  * [Markdown Tutorial](https://www.markdowntutorial.com/)
  * [Introduction to git](https://www.freecodecamp.org/news/what-is-git-and-how-to-use-it-c341b049ae61/)  
  * [Introduction to GitHub](https://product.hubspot.com/blog/git-and-github-tutorial-for-beginners)
  * [Popular git commands and how to use them](https://rogerdudler.github.io/git-guide/)
  * [Git commands in depth](https://medium.com/@george.seif94/a-full-tutorial-on-how-to-use-github-88466bac7d42)

Ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one to avoid duplicates.
- Make an individual pull request for each suggestion.
- Use [title-casing](https://titlecaseconverter.com/) (AP style).
- Use the following format: `[Title Case Name](link) - Description.`
  > :information_source: [Articles](https://github.com/BolajiAyodeji/awesome-jamstack#articles) should use the `[Title Case Name](link)` format.
- Keep descriptions short and simple, but descriptive.
- Start the description with a capital and end with a full stop/period.
  > :information_source: You can use an emoji, only before the Title-Cased Description.
- When adding to the `Examples` category, please add a link to the source code (if available)
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- New categories or improvements to the existing `table of contents` are welcome.
- Pull requests should have a useful title and description.
- The body of your commit message should contain a link to the resource.

Thank you for your suggestion!
