# Tree

## 1. 基本功用

tree是linux系统下十分常用的一个小工具

其基本作用是用于以树状图的方式显示指定目录下存在的各级子目录和子文件

只使用linux内建的ls指令虽然能够获取任意目录下子目录和子文件的信息，但是却不能够展示完整地展示多层次的目录、文件及之间的关系

在阅览较为复杂的工程时，tree的功能就显得非常重要，能够帮助我们对整个工程各部分的文件的关系有直观清晰的认识

## 2. 安装方法

1. 确认系统的Linux版本

    (1)请先确认所在的linux系统的版本是RedHat系列（包括RedHat,CentOS等）还是Debian系列（包括Debian,Ubuntu等）

    (2)如果不是很清楚，请打开系统命令行输入指令'lsb\_release -a'，根据打印出的信息进行确认。确认完之后前往下一步

2. 输入指令安装tree

    (1)如果是RedHat系列，请输入'sudo yum install tree';如果是Debian系列，请输入'sudo apt-get install tree'

    (2)输入之后按下回车键，前往下一步。（如果不关心安装细节，可以在以上指令中加入'-y'参数，不需要重复确认地进行安装)

3. 进行安装

    (1)由于调用了root权限，请按照提示输入密码并按回车键确认，之后根据软件安装中的提示输入y/n完成安装

## 3. 使用方法（基本参数和基本指令）

tree的使用只需要按以下格式输入指令即可：

```bash
tree [参数] [目录]
```

> 注意：其中目录如果不输入的话默认为当前所在的工作目录,即'.'

tree的常用参数如下：

> -a  树状图中显示目录下的所有子文件和子目录（包括隐藏文件）
>
> -C  树状图中根据不同的类型为子文件和子目录添加不同颜色
>
> -d  树状图中只显示子目录，不显示子文件
>
> -D  树状图中列出文件或目录的更改时间
>
> -f  在每个文件或目录之前，显示完整的相对路径名称
>
> -F  在执行文件，目录，Socket文件，软链接，命名管道之前，加上不同的符号以区分
>
> -g  列出文件或目录的所属群组名称，没有对应的名称时，则显示GID
>
> -i  在排列文件或目录时全部顶格排列，用于一定格式的输出
>
> -I pattern  不显示与pattern匹配的文件，pattern为通配符
>
> -l  对于指向目录的软链接，当作子目录处理，自动回避造成回环的软链接
>
> -n  树状图中不为子文件和子目录上色，会被'-C'覆盖
>
> -N  树状图中目录和文件名字中的不可见字符以转义八进制数显示
>
> -p  树状图中显示文件类型和文件权限
>
> -P pattern   只显示与pattern匹配的文件，pattern为通配符
>
> -q  树状图中目录和文件名字中的不可见字符以'?'显示
>
> -s  树状图中显示文件和目录的大小
>
> -t  以更改时间而不是文件名称来排序文件
>
> -u  列出文件或目录的拥有者名称，没有对应的名称时，则显示UID
>
> -x  将范围局限在现行的文件系统中，若指定目录下的某些子目录，其存放于另一个文件系统上，则将该子目录予以排除在寻找范围外

## 4. 常见使用方式和注意事项

tree最常用的方式就是进入需要查看的工程的顶层目录，然后直接在命令行中输入tree，效果如下：

```console
$ tree
.
└── A
    ├── AA.txt
    ├── AB.txt
    ├── AC.txt
    ├── AD
    │   ├── ADA.py
    │   ├── ADB.json
    │   ├── ADC
    │   │   ├── ADCA.txt
    │   │   └── ADCB.md
    │   ├── ADD
    │   │   ├── ADDA.md
    │   │   └── ADDB.md
    │   └── ADE.py
    └── AE
        ├── AEA.py
        ├── AEB.txt
        ├── AEC.py
        └── AED.py

5 directories, 14 files
```

tree命令带参数执行可以实现更多方便的功能，例如确定各文件的大小（结果单位为字节）：

```console
$ tree -s
.
└── [       4906]  A
    ├── [       1141]  AA.txt
    ├── [       1120]  AB.txt
    ├── [       3100]  AC.txt
    ├── [       4096]  AD
    │   ├── [        740]  ADA.py
    │   ├── [        345]  ADB.json
    │   ├── [       4096]  ADC
    │   │   ├── [        140]  ADCA.txt
    │   │   └── [       1250]  ADCB.md
    │   ├── [       4906]  ADD
    │   │   ├── [       1675]  ADDA.md
    │   │   └── [       2556]  ADDB.md
    │   └── [        841]  ADE.py
    └── [       4096]  AE
        ├── [        991]  AEA.py
        ├── [        341]  AEB.txt
        ├── [        563]  AEC.py
        └── [        644]  AED.py

5 directories, 14 files
```

混合运用参数能获得更好的效果，例如观察所有txt文件的关系并确定各自的大小：

```console
$ tree -s -P '*.txt'
.
└── [       4906]  A
    ├── [       1141]  AA.txt
    ├── [       1120]  AB.txt
    ├── [       3100]  AC.txt
    ├── [       4096]  AD
    │   ├── [       4096]  ADC
    │   │   ├── [        140]  ADCA.txt
    │   ├── [       4906]  ADD
    └── [       4096]  AE
        └── [        341]  AEB.txt

5 directories, 5 files
```
