# whereis

## 1. 命令格式

whereis [-bmsu] [BMS 目录名 -f ] 文件名

## 2. 基本功能

用于查看可执行文件、帮助文件和源代码文件的位置。whereis命令只能用于程序名的搜索，而且只搜索二进制文件（参数-b）、man说明文件（参数-m）和源代码文件（参数-s）。如果省略参数，则返回所有信息。

## 3. 常用参数

-b   定位可执行文件。

-m   定位帮助文件。

-s   定位源代码文件。

-u   搜索默认路径下除可执行文件、源代码文件、帮助文件以外的其它文件。

-B   指定搜索可执行文件的路径。

-M   指定搜索帮助文件的路径。

-S   指定搜索源代码文件的路径。

## 4. 注意事项

因为linux系统会将系统内的所有文件都记录在一个数据库文件中，当使用whereis命令时，会从数据库中查找数据。这一点与locate命令相似，但与遍历硬盘查找文件的find命令原理不同，后者的效率明显低于前两者。
但上述数据库文件并不是实时更新，默认情况下时一星期更新一次。因此，我们在用whereis查找文件时，有时会找到已经被删除的数据，或者刚刚建立文件却无法查找到，这是因为数据库文件没有被更新。

## 5. 常用形式

用`whereis`命令查看bash命令相关文件的位置

```console
whereis bash
```

用`whereis`命令查看bash命令的帮助文件

```console
whereis -m bash
```
