# more

## 1. 命令格式

more [-dlfpcsu ] [-num ] [+/ pattern] [+ linenum] [file ... ]

## 2. 基本功能

逐页查看文件中的内容，并且可以跳转行及搜寻字符串。

## 3. 常用参数

+n      从笫n行开始显示

-n       定义屏幕大小为n行

+/pattern 在每个档案显示前搜寻该字串（pattern），然后从该字串前两行之后开始显示  

-c       从顶部清屏，然后显示

-d       提示“Press space to continue，’q’ to quit（按空格键继续，按q键退出）”，禁用响铃功能

-l        忽略Ctrl+l（换页）字符

-p       通过清除窗口而不是滚屏来对文件进行换页，与-c选项相似

-s       把连续的多个空行显示为一行

-u       把文件内容中的下画线去掉

## 4. 注意事项

more命令，功能类似cat命令，cat命令是整个文件的内容从上到下显示在屏幕上。more命令会以分页的显示方便使用者逐页阅读，而且还有搜寻字串的功能 。more命令从前向后读取文件，与less相比少了向前浏览和向前搜索字段的功能。

常用操作：

> Enter    向下n行，需要定义。默认为1行
>
> Ctrl+F   向下滚动一屏
>
> 空格键  向下滚动一屏
>
> Ctrl+B  返回上一屏
>
> =       输出当前行的行号
>
> ：f     输出文件名和当前行的行号
>
> V      调用vi编辑器
>
> !命令   调用Shell，并执行命令
>
> q       退出more

列出一个目录下的文件，由于内容太多，可以结合管道`|`用more来分页显示`ls -l  | more -5`

## 5. 常用形式

使用`more`指令逐页显示file_1文件内容

```console
more -s file_1
```

使用`more`指令从第5行开始显示file_1文件内容

```console
more +5 file_1
```
