# find

## 1. 命令格式

find pathname -options [-print -exec -ok ...]

## 2. 基本功能

find命令用来在指定目录下查找文件

## 3. 常用参数

pathname: find命令所查找的目录路径。例如用.来表示当前目录，用/来表示系统根目录。

-print： find命令将匹配的文件输出到标准输出。

-exec： find命令对匹配的文件执行该参数所给出的shell命令。相应命令的形式为'command' {  } \;，注意{   }和\；之间的空格。

-ok： 和-exec的作用相同，只不过以一种更为安全的模式来执行该参数所给出的shell命令，在执行每一个命令之前，都会给出提示，让用户来确定是否执行。

-name   按照文件名查找文件。

-perm   按照文件权限来查找文件。

-prune  使用这一选项可以使find命令不在当前指定的目录中查找，如果同时使用-depth选项，那么-prune将被find命令忽略。

-user   按照文件属主来查找文件。

-group  按照文件所属的组来查找文件。

-mtime -n +n  按照文件的更改时间来查找文件， - n表示文件更改时间距现在n天以内，+ n表示文件更改时间距现在n天以前。find命令还有-atime和-ctime 选项，但它们都和-m time选项。

-nogroup  查找无有效所属组的文件，即该文件所属的组在/etc/groups中不存在。

-nouser   查找无有效属主的文件，即该文件的属主在/etc/passwd中不存在。

-newer file1 ! file2  查找更改时间比文件file1新但比文件file2旧的文件。

-type  查找某一类型的文件，诸如：

> b - 块设备文件。
>
> d - 目录。
>
> c - 字符设备文件。
>
> p - 管道文件。
>
> l - 符号链接文件。
>
> f - 普通文件。

-size n：[c] 查找文件长度为n块的文件，带有c时表示文件长度以字节计。-depth：在查找文件时，首先查找当前目录中的文件，然后再在其子目录中查找。

-fstype：查找位于某一类型文件系统中的文件，这些文件系统类型通常可以在配置文件/etc/fstab中找到，该配置文件中包含了本系统中有关文件系统的信息。

-mount：在查找文件时不跨越文件系统mount点。

-follow：如果find命令遇到符号链接文件，就跟踪至链接所指向的文件。

-cpio：对匹配的文件使用cpio命令，将这些文件备份到磁带设备中。

另外,下面三个的区别:

-amin n   查找系统中最后N分钟访问的文件

-atime n  查找系统中最后n*24小时访问的文件

-cmin n   查找系统中最后N分钟被改变文件状态的文件

-ctime n  查找系统中最后n*24小时被改变文件状态的文件

-mmin n   查找系统中最后N分钟被改变文件数据的文件

-mtime n  查找系统中最后n*24小时被改变文件数据的文件

## 4. 注意事项

Linux下find命令在目录结构中搜索文件，并执行指定的操作。Linux下find命令提供了相当多的查找条件，功能很强大。由于find具有强大的功能，所以它的选项也很多，其中大部分选项都值得我们花时间来了解一下。即使系统中含有网络文件系统( NFS)，find命令在该文件系统中同样有效，只你具有相应的权限。 在运行一个非常消耗资源的find命令时，很多人都倾向于把它放在后台执行，因为遍历一个大的文件系统可能会花费很长的时间(这里是指30G字节以上的文件系统)

-exec 参数非常有用，后面跟的是command命令，它的终止是以;为结束标志的，所以这句命令后面的分号是不可缺少的，考虑到各个系统中分号会有不同的意义，所以前面加反斜杠。{}花括号代表前面find查找出来的文件名。

xargs 在使用 find命令的-exec选项处理匹配到的文件时， find命令将所有匹配到的文件一起传递给exec执行。但有些系统对能够传递给exec的命令长度有限制，这样在find命令运行几分钟之后，就会出现溢出错误。错误信息通常是“参数列太长”或“参数列溢出”。这就是xargs命令的用处所在，特别是与find命令一起使用。find命令把匹配到的文件传递给xargs命令，而xargs命令每次只获取一部分文件而不是全部，不像-exec选项那样。这样它可以先处理最先获取的一部分文件，然后是下一批，并如此继续下去。在有些系统中，使用-exec选项会为处理每一个匹配到的文件而发起一个相应的进程，并非将匹配到的文件全部作为参数一次执行；这样在有些情况下就会出现进程过多，系统性能下降的问题，因而效率不高； 而使用xargs命令则只有一个进程。另外，在使用xargs命令时，究竟是一次获取所有的参数，还是分批取得参数，以及每一次获取参数的数目都会根据该命令的选项及系统内核中相应的可调参数来确定。

find命令还有很多实用内容，可以再加查询。

## 5. 常用形式

将当前目录以及子目录下所有拓展名为.c的文件列出：

```bash
find . -name "*.c"
```

将当前目录以及子目录下所有最近20天内更新过的文件列出：

```bash
find . -ctime 20
```

查找当前目录中文件属主具有读写权限，并且文件所属组的用户和其他用户具有读权限的文件：

```bash
find . -type f -perm 644 -exec ls -l {} \
```

查找系统中所有文件长度为0的普通文件并列出完整路径：

```bash
find / -type f -size 0 -exec ls -l {} \
```
