# chmod

## 1. 命令格式

chmod [-cfvR] [--help] [--version] mode file

## 2. 基本功能

Linux/Unix的文件调用权限分为三级: 文件拥有者、群组、其他。chmod修改文件的调用权限

## 3. 常用参数

> 必要参数

```text
-c 当发生改变时，报告处理信息

-f 错误信息不输出

-R 处理指定目录以及其子目录下的所有文件

-v 运行时显示详细处理信息
```

> 选择参数

```text
--reference=<目录或者文件> 设置成具有指定目录或者文件具有相同的权限

--version 显示版本信息

<权限范围>+<权限设置> 使权限范围内的目录或者文件具有指定的权限

<权限范围>-<权限设置> 删除权限范围的目录或者文件的指定权限

<权限范围>=<权限设置> 设置权限范围内的目录或者文件的权限为指定的值
```

> 权限范围

```text
u ：目录或者文件的当前的用户

g ：目录或者文件的当前的群组

o ：除了目录或者文件的当前用户或群组之外的用户或者群组

a ：所有的用户及群组
```

> 权限代号

```text
r ：读权限，用数字4表示

w ：写权限，用数字2表示

x ：执行权限，用数字1表示

- ：删除权限，用数字0表示
```

s ：特殊权限

## 4. 注意事项

+表示在现有权限基础上增加权限，-表示现有权限基础上移除权限，=表示将权限设置成后面的值。

## 5. 常用形式

将file.txt设为所有人可读：

```bash
chmod ugo+r file.txt
# or
chmod a+r file.txt
```

删除所有用户的可执行权限:

```bash
chmod a-x log2012.log
```

撤销原来所有的权限，然后使拥有者具有可读权限:

```bash
chmod u=r log2012.log
```

将file.txt设为该文件拥有者和同一群组的用户可写入，其他人不可写入：

```bash
chmod ug+w,o-w file.txt
```

将当前目录下的文件与目录设置为任何人可读取：

```bash
chmod -R a+r *
```

此外chmod也可以用数字来表示权限，语法为`chmod abc file`，其中a,b,c各为一个数字，分别表示User,Group,Other的权限，r=4,w=2,x=1

```text
若要rwx属性则4+2+1=7    (二进制为111)
若要rw-属性则4+2=6      (二进制为110)
若要r-x属性则4+1=5      (二进制为101)
```

例如，以下两条命令的效果相同：

```bash
chmod 771 file
chmod ug=rwx,o=x file
```
