/*
 * This file is part of Arc3D.
 *
 * Copyright (C) 2022-2024 BloCamLimb <pocamelards@gmail.com>
 *
 * Arc3D is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Arc3D is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Arc3D. If not, see <https://www.gnu.org/licenses/>.
 */

package icyllis.arc3d.compiler.lex;

/**
 * Most are machine generated, see {@link LexerGenerator}.
 */
public class Lexer {

    public record PackedEntry(int values, byte[] data) {
    }

    public static final byte[] MAPPINGS = {
            1, 2, 1, 1, 2, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 1, 4, 5, 6,
            3, 7, 8, 3, 9, 10, 11, 12, 13,
            14, 15, 16, 17, 18, 19, 20, 21, 18,
            18, 18, 22, 22, 23, 24, 25, 26, 27,
            28, 3, 29, 29, 29, 30, 31, 32, 33,
            33, 33, 33, 33, 33, 33, 33, 33, 33,
            33, 34, 35, 33, 36, 33, 33, 37, 33,
            33, 38, 39, 40, 41, 42, 3, 43, 44,
            45, 46, 47, 48, 49, 50, 51, 33, 52,
            53, 54, 55, 56, 57, 33, 58, 59, 60,
            61, 62, 63, 64, 65, 66, 67, 68, 69,
            70
    };
    public static final short[][] FULL = {
            {
                    0, 2, 4, 5, 6, 8, 11, 12, 14,
                    17, 18, 19, 21, 24, 25, 28, 34, 40,
                    57, 57, 57, 57, 57, 59, 60, 61, 65,
                    67, 71, 72, 72, 72, 72, 72, 72, 72,
                    72, 72, 74, 5, 75, 76, 79, 85, 107,
                    117, 142, 162, 174, 193, 196, 203, 72, 243,
                    252, 258, 284, 289, 308, 330, 391, 408, 425,
                    438, 72, 72, 72, 459, 460, 463, 464
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 41, 0, 49,
                    49, 49, 49, 49, 50, 0, 0, 0, 0,
                    0, 0, 0, 0, 51, 0, 0, 0, 0,
                    54, 55, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 51, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 54, 0,
                    0, 55, 0, 0, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 41, 0, 49,
                    49, 49, 49, 49, 50, 0, 0, 0, 0,
                    0, 0, 0, 0, 51, 0, 0, 0, 0,
                    54, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 51, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 54, 0,
                    0, 0, 0, 0, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 41, 0, 58,
                    58, 58, 58, 58, 58, 0, 0, 0, 0,
                    0, 0, 0, 0, 51, 0, 0, 0, 0,
                    54, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 51, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 54, 0,
                    0, 0, 0, 0, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    86, 73, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 73, 73, 73, 91, 92, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 118, 73,
                    73, 73, 73, 73, 73, 73, 73, 73, 121,
                    73, 73, 124, 73, 73, 73, 73, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 73, 73, 73, 125, 73, 73, 73,
                    131, 134, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 143, 73, 73, 73, 149, 73, 73,
                    73, 73, 155, 73, 73, 73, 73, 73, 159,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 73, 73, 73, 73, 73, 73, 163,
                    73, 166, 73, 73, 73, 73, 73, 73, 73,
                    73, 168, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 175, 73,
                    73, 73, 73, 73, 73, 73, 179, 73, 185,
                    73, 73, 188, 73, 73, 73, 73, 73, 190,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 73, 204, 73, 73, 205, 73, 73,
                    206, 215, 73, 73, 73, 231, 237, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 73, 73, 73, 73, 73, 73, 216,
                    73, 73, 220, 223, 73, 73, 225, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 290, 73,
                    73, 73, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 73, 73, 297, 73, 73, 304, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 310, 73,
                    73, 73, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 73, 73, 73, 316, 326, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 331, 73,
                    73, 73, 73, 73, 73, 353, 357, 73, 73,
                    361, 73, 73, 73, 73, 73, 366, 374, 73,
                    386, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 392, 73, 73, 398, 73, 73, 73,
                    73, 73, 73, 73, 400, 73, 73, 73, 73,
                    73, 73, 403, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 73, 73, 73, 73, 205, 73, 73,
                    73, 409, 73, 73, 73, 421, 237, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            },
            {
                    0, 0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0, 73,
                    73, 73, 73, 73, 73, 0, 0, 0, 0,
                    0, 0, 73, 73, 73, 73, 73, 73, 73,
                    73, 73, 0, 0, 0, 0, 73, 73, 73,
                    73, 73, 73, 73, 73, 439, 73, 73, 73,
                    73, 73, 443, 73, 451, 73, 73, 73, 73,
                    73, 73, 73, 73, 0, 0, 0, 0
            }
    };
    public static final PackedEntry[] PACKED = {
            new PackedEntry(0,
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(3,
                    new byte[]{
                            -13, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(4,
                    new byte[]{
                            -49, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(7,
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(10 | (9 << 9),
                    new byte[]{
                            119, 81, 85, 85,
                            85, 85, 85, 85,
                            85, -43, 85, 85,
                            85, 85, 85, 85,
                            85, 21
                    }),
            new PackedEntry(13,
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(16 | (15 << 9),
                    new byte[]{
                            -1, -1, -3, -1,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(20,
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(23 | (22 << 9),
                    new byte[]{
                            -1, -1, -1, -3,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(27 | (26 << 9),
                    new byte[]{
                            -1, -1, -1, -33,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(29,
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(33 | (30 << 9) | (29 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, 127,
                            -4, -1, -1, 127,
                            -4, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(32 | (31 << 9),
                    new byte[]{
                            -1, -1, -1, -35,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(32,
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(33 | (32 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, -1,
                            -4, -1, -1, -1,
                            -4, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(39 | (38 << 9) | (35 << 18),
                    new byte[]{
                            -1, -1, -65, -1,
                            -3, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(36 | (35 << 9),
                    new byte[]{
                            87, 85, 21, 85,
                            85, 85, 85, 85,
                            85, 85, 85, 85,
                            85, 85, 85, 85,
                            85, 21
                    }),
            new PackedEntry(37 | (36 << 9) | (35 << 18),
                    new byte[]{
                            -85, -86, 106, -86,
                            -88, -86, -86, -86,
                            -86, -86, -86, -86,
                            -86, -86, -86, -86,
                            -86, 42
                    }),
            new PackedEntry(38,
                    new byte[]{
                            51, 0, 0, 0,
                            0, 0, 0, 0,
                            0, 0, 0, 0,
                            0, 0, 0, 0,
                            0, 0
                    }),
            new PackedEntry(46 | (42 << 9) | (33 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 63,
                            -2, -1, -1, 63,
                            -2, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(43 | (42 << 9) | (33 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 63,
                            -2, -1, -1, 63,
                            -2, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(45 | (44 << 9),
                    new byte[]{
                            -1, -1, -1, -35,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(45,
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(45 | (33 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -3, -1, -1, -1,
                            -3, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(48 | (47 << 9),
                    new byte[]{
                            -1, -1, -1, -35,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(48,
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(48 | (33 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -3, -1, -1, -1,
                            -3, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(51 | (50 << 9) | (41 << 18),
                    new byte[]{
                            -1, -1, -1, -65,
                            87, -43, -1, 63,
                            -1, -1, -1, 63,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(53 | (52 << 9),
                    new byte[]{
                            -1, -1, -1, -35,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(53,
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(53 | (33 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, -1,
                            -3, -1, -1, -1,
                            -3, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(56,
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, 3,
                            -4, -1, 63, 0,
                            -4, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(56 | (54 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, 3,
                            -4, -3, 63, 0,
                            -4, -1, -1, -9,
                            -1, 63
                    }),
            new PackedEntry(64 | (62 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -57, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(63,
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(66,
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(69 | (68 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, 31, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(70,
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -49, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(73,
                    new byte[]{
                            -1, -1, -1, -1,
                            3, -64, -1, 3,
                            0, -16, 15, 0,
                            0, 0, 0, 0,
                            -64, 63
                    }),
            new PackedEntry(78 | (77 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -33, -1,
                            -1, -1, -13, -1,
                            -1, -1, -1, -1,
                            -1, 63
                    }),
            new PackedEntry(80 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 79, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(81 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(82 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(83 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(84 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(87 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(88 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(89 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 69,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(101 | (93 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -86, -86, -87, -88,
                            -22, 63
                    }),
            new PackedEntry(94 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(95 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(96 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(97 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 79, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(98 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(99 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(100 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(102 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(103 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(104 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 84,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(105 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(106 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(112 | (108 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -86, -86, -102, -94,
                            -22, 63
                    }),
            new PackedEntry(109 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(110 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(111 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 84, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(113 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            84, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(114 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            84, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(115 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(116 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(119 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(120 | (90 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, 42,
                            -86, -86, -86, -87,
                            -22, 63
                    }),
            new PackedEntry(122 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(123 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(126 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(127 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(128 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(129 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(130 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(132 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(133 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(137 | (135 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -86, -86, 106, -88,
                            -22, 63
                    }),
            new PackedEntry(136 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(138 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(139 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(140 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(141 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(144 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            84, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(145 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(146 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(147 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(148 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(150 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(151 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(152 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(153 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(154 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 69,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(156 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(157 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 84,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(158 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(160 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(161 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            23, -48, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(164 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(165 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(167 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(169 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(170 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(171 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(172 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(173 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(176 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(177 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(178 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(183 | (180 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -86, -90, -86, -86,
                            -24, 63
                    }),
            new PackedEntry(181 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(182 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(184 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 69,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(186 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(187 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(189 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(191 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(192 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(194 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(195 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(200 | (197 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            106, -86, -86, -118,
                            -22, 63
                    }),
            new PackedEntry(198 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            81, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(199 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            69, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(201 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(202 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(206 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(207 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(208 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            81, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(209 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(210 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            23, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(211 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 71,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(212 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            69, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(213 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(214 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(217 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(218 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(219 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(221 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(222 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(224 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(226 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(227 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(228 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            84, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(229 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(230 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(232 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(233 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(234 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(235 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(236 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(209 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(238 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(239 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -44, 63
                    }),
            new PackedEntry(240 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(241 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(242 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(249 | (244 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, 111, -86,
                            -86, -86, -88, -86,
                            -22, 63
                    }),
            new PackedEntry(245 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -47, 63
                    }),
            new PackedEntry(246 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(247 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(248 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(251 | (250 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -86, 106, -86, 42,
                            -22, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            81, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(253 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(254 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 69,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(255 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(256 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(257 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(266 | (259 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, 111, -86,
                            -86, -86, -88, -86,
                            -22, 63
                    }),
            new PackedEntry(260 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(261 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(262 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(263 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(264 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(265 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(273 | (267 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            106, -86, -94, -86,
                            -22, 63
                    }),
            new PackedEntry(268 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(269 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(270 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(271 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(272 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(274 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(275 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(276 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(277 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(278 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(279 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(280 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(281 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(282 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 69,
                            -43, 63
                    }),
            new PackedEntry(283 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(285 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(286 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(287 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(288 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(291 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(292 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(293 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(294 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(295 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(296 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(298 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(299 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(300 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(301 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 21, 85,
                            -43, 63
                    }),
            new PackedEntry(302 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(303 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(305 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 84,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(306 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(307 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(309 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(311 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 69,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(312 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(313 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(314 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(315 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -47, 63
                    }),
            new PackedEntry(321 | (317 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -86, -86, -87, -88,
                            -22, 63
                    }),
            new PackedEntry(318 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(319 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(320 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(322 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(323 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(324 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(325 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(327 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(328 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(329 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(332 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(333 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(334 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(335 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(336 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(348 | (337 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            107, -24, -1, -85,
                            -86, -6, -81, -86,
                            -86, -86, -86, -86,
                            -22, 63
                    }),
            new PackedEntry(338 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 71,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(339 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            69, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(340 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(341 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(342 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(343 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            21, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(344 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            69, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(345 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(346 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 69,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(347 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 21,
                            -43, 63
                    }),
            new PackedEntry(349 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 71,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(350 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            69, -11, 95, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(351 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(352 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(354 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(355 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(356 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(358 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -59, 63
                    }),
            new PackedEntry(359 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(360 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(90 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            84, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(362 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(363 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(364 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(365 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            69, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(370 | (367 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, 111, -86,
                            -86, -86, -118, -86,
                            -22, 63
                    }),
            new PackedEntry(368 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(369 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(371 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(372 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(373 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(383 | (375 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -87,
                            -86, -86, -94, -86,
                            -22, 63
                    }),
            new PackedEntry(376 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(377 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(378 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(379 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(380 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(381 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(382 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(384 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(385 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(387 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(388 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(389 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 81,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(390 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            69, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(393 | (239 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -86, -118, -86, -86,
                            -23, 63
                    }),
            new PackedEntry(394 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(395 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(396 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(397 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(399 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(401 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(402 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(404 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(405 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(406 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 69,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(407 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(416 | (410 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            106, -86, 42, -86,
                            -22, 63
                    }),
            new PackedEntry(415 | (411 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, -81, -86,
                            -87, -86, -88, -86,
                            -22, 63
                    }),
            new PackedEntry(412 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(413 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(414 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 69, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(417 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(418 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            81, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(419 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(420 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(422 | (232 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, 111, -86,
                            42, -86, -86, -86,
                            -22, 63
                    }),
            new PackedEntry(423 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(424 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            81, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(431 | (426 << 9) | (73 << 18),
                    new byte[]{
                            -1, -1, -1, -1,
                            -85, -22, -1, -85,
                            -86, -6, 111, -86,
                            -86, -86, -88, -86,
                            -22, 63
                    }),
            new PackedEntry(427 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(428 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -47, 63
                    }),
            new PackedEntry(429 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(430 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(432 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(433 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 31, 85,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(434 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(435 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(436 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(437 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(440 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(441 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(442 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(444 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(445 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 84, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(446 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            81, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(447 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 69, 85,
                            -43, 63
                    }),
            new PackedEntry(448 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(449 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 81,
                            -43, 63
                    }),
            new PackedEntry(450 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 81, 85,
                            -43, 63
                    }),
            new PackedEntry(452 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            21, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(453 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 84,
                            -43, 63
                    }),
            new PackedEntry(454 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 21,
                            85, 85, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(455 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 84, 85,
                            -43, 63
                    }),
            new PackedEntry(456 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 21, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(457 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 81, 85, 85,
                            -43, 63
                    }),
            new PackedEntry(458 | (73 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            87, -43, -1, 87,
                            85, -11, 95, 85,
                            85, 85, 85, 85,
                            -47, 63
                    }),
            new PackedEntry(462 | (461 << 9),
                    new byte[]{
                            -1, -1, -1, -1,
                            -1, -1, -33, -1,
                            -1, -1, -1, -1,
                            -1, -1, -1, -1,
                            -1, 60
                    })
    };
    public static final short[] INDICES = {
            0, -1, 1, 1, 2, 0, 3, 0, 4,
            4, 0, 0, 5, 0, 6, 0, 0, 0,
            0, 7, 0, 8, 0, 0, 0, 9, 0,
            0, 10, 11, 12, 13, 14, 0, 15, 16,
            17, 0, 18, 0, -2, 19, 20, 21, 22,
            23, 24, 25, 26, -3, 27, 28, 29, 30,
            0, 31, 32, -4, -4, 0, 0, 33, 34,
            0, 0, 35, 0, 36, 0, 37, 0, 0,
            38, 38, 0, 0, 39, 0, 0, 40, 41,
            42, 43, 44, 38, -5, 45, 46, 47, 48,
            38, 49, 50, 51, 52, 53, 54, 55, 56,
            57, 58, 59, 60, 61, 62, 63, 48, 64,
            65, 66, 67, 38, 68, 69, 70, 71, 38,
            -6, 72, 73, 38, 74, 75, 76, -7, 77,
            78, 79, 80, 81, 38, 82, 83, 84, 85,
            86, 38, 87, 88, 89, 90, 38, -8, 91,
            92, 93, 94, 95, 38, 96, 97, 98, 99,
            100, 38, 101, 102, 103, 48, 104, 105, 106,
            -9, 107, 108, 38, 109, 49, 110, 111, 112,
            113, 114, 115, -10, 116, 117, 118, 38, 119,
            120, 121, 122, 123, 124, 125, 126, 38, 127,
            38, 128, 129, 106, 130, 131, 132, 133, 134,
            135, 136, 137, 138, 106, -11, 38, 139, 140,
            141, 142, 143, 144, 145, 146, 147, 58, -12,
            148, 149, 150, 38, 151, 152, 38, 153, 58,
            154, 155, 156, 157, 158, 48, 159, 160, 161,
            162, 163, 164, 165, 166, 167, 168, 169, 142,
            170, 171, 172, 173, 174, 38, 175, 176, 136,
            177, 178, 179, 180, 181, 136, 182, 183, 184,
            185, 186, 187, 188, 48, 189, 190, 191, 192,
            193, 194, 38, 195, 196, 197, 198, 199, 200,
            201, 202, 203, 204, 38, 205, 206, 207, 208,
            58, -13, 209, 210, 211, 212, 213, 214, 84,
            215, 216, 217, 218, 219, 220, 84, 221, 222,
            223, 224, 225, -14, 226, 227, 228, 229, 230,
            38, 231, 232, 233, 234, 48, 235, 236, 237,
            238, 38, 239, 240, 241, 38, -15, 242, 243,
            244, 245, 246, 247, 248, 249, 250, 251, 252,
            253, 254, 255, 256, 257, 258, 259, 260, 261,
            262, 58, 263, 264, 265, 124, 266, 267, 268,
            269, 270, 271, 272, 273, 38, 274, 275, 276,
            224, 277, 278, 279, 38, 280, 281, 282, 283,
            284, 285, 286, 287, 38, 288, 289, 136, 290,
            291, 292, 293, 38, -16, 294, 295, 296, 297,
            298, 48, 299, 76, 300, 301, 38, 302, 303,
            304, 305, 269, -17, 306, 307, 308, 309, 310,
            38, 84, 311, 312, 313, 314, 124, 315, 316,
            317, 38, 318, 319, 320, 321, 322, 176, 323,
            324, 325, 326, 327, 328, 38, -18, 329, 330,
            331, 38, 332, 333, 334, 335, 336, 337, 338,
            38, 339, 340, 341, 342, 343, 344, 345, 38,
            0, 346, 0, 0, 0, 0
    };
    public static final byte[] ACCEPTS = {
            -1, -1, 89, 89, 88, 92, 54, 61, 92,
            -1, 3, 42, 68, 81, 74, 71, 84, 43,
            44, 66, 79, 64, 62, 77, 50, 65, 63,
            78, 49, 2, -1, -1, 2, 2, 67, -1,
            -1, 91, 90, 80, 1, 2, 2, -1, -1,
            2, -1, -1, 2, 1, -1, -1, -1, 2,
            1, -1, 1, 1, 1, 57, 87, 52, 69,
            82, 59, 51, 58, 53, 60, 70, 83, 56,
            41, 41, 47, 48, 76, 86, 73, 41, 41,
            41, 41, 41, 39, 41, 41, 41, 41, 41,
            40, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 6, 41, 41, 41, 41, 23,
            41, 41, 41, 14, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 28, 41, 41, 41, 41,
            41, 21, 41, 41, 41, 41, 7, 41, 41,
            41, 41, 41, 41, 15, 41, 41, 41, 41,
            41, 16, 8, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 12, 41, 41, 41, 41, 41,
            41, 40, 41, 41, 41, 41, 41, 5, 41,
            41, 41, 41, 41, 41, 41, 41, 26, 41,
            9, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 11, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 18,
            41, 41, 41, 37, 41, 41, 20, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 34, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 38, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 27, 41, 41, 19, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            31, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 30, 41, 41, 41, 17, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            40, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 25, 41, 41, 41,
            41, 41, 41, 41, 35, 41, 41, 41, 41,
            41, 41, 41, 41, 33, 41, 41, 41, 41,
            41, 41, 41, 13, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 41, 4, 41, 41,
            41, 41, 41, 41, 41, 41, 41, 41, 41,
            22, 41, 41, 41, 41, 41, 41, 41, 41,
            41, 36, 41, 41, 41, 41, 41, 41, 41,
            41, 41, 41, 41, 41, 29, 41, 41, 41,
            41, 10, 41, 41, 41, 41, 41, 41, 41,
            24, 41, 41, 41, 41, 41, 41, 41, 32,
            45, 75, 85, 72, 46, 55
    };

    public static int getTransition(int transition, int state) {
        short index = INDICES[state];
        if (index < 0) return FULL[~index][transition] & 0xFFFF;
        final PackedEntry entry = PACKED[index];
        int v = entry.data[transition >> 2] & 0xFF;
        v >>= 2 * (transition & 3);
        v &= 3;
        v *= 9;
        return (entry.values >>> v) & 511;
    }

    // current parse stream
    private final char[] mSource;
    private final int mStart;
    private final int mLimit;
    private int mScanOffset;

    public Lexer(char[] source) {
        mSource = source;
        mStart = 0;
        mLimit = source.length;
    }

    public Lexer(char[] source, int offset, int length) {
        mSource = source;
        mStart = offset;
        mLimit = offset + length;
        mScanOffset = offset;
    }

    // @formatter:off
    public long next() {
        // start state (1) to reject state (0), the last state is the accepting state
        final int offset = mScanOffset;
        int state = 1;
        for (;;) {
            if (mScanOffset >= mLimit) {
                if (offset == mLimit || ACCEPTS[state] == DFA.INVALID) {
                    return Token.make(Token.TK_END_OF_FILE, offset - mStart, 0);
                }
                break;
            }
            int c = (mSource[mScanOffset] - NFAtoDFA.START_CHAR);
            if (c < 0 || c > NFAtoDFA.END_CHAR - NFAtoDFA.START_CHAR) {
                // Choose '\e' as invalid char which is greater than start char,
                // and should not appear in actual input.
                c = 27 - NFAtoDFA.START_CHAR;
            }
            int newState = getTransition(MAPPINGS[c], state);
            if (newState == 0) {
                break;
            }
            state = newState;
            ++mScanOffset;
        }
        return Token.make(ACCEPTS[state] & 0xFF, offset - mStart, mScanOffset - offset);
    }
    // @formatter:on

    public int offset() {
        return mScanOffset - mStart;
    }

    public void offset(int offset) {
        mScanOffset = offset + mStart;
    }
}
