/*
 * Modern UI.
 * Copyright (C) 2019-2024 BloCamLimb. All rights reserved.
 *
 * Modern UI is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Modern UI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Modern UI. If not, see <https://www.gnu.org/licenses/>.
 */

package icyllis.modernui.test

import icyllis.modernui.ModernUI
import icyllis.modernui.fragment.Fragment
import icyllis.modernui.util.DataSet
import icyllis.modernui.util.Log
import icyllis.modernui.view.Gravity
import icyllis.modernui.view.LayoutInflater
import icyllis.modernui.view.View
import icyllis.modernui.view.View.OnFocusChangeListener
import icyllis.modernui.view.ViewGroup
import icyllis.modernui.widget.*

fun main() {
    System.setProperty("java.awt.headless", "true")
    Log.setLevel(Log.DEBUG)
    ModernUI().use { app -> app.run(TestViewPager()) }
}

class TestViewPager : Fragment() {
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: DataSet?
    ): View {
        val pager = ViewPager(context)
        pager.adapter = MyAdapter()
        pager.isFocusableInTouchMode = true
        pager.isKeyboardNavigationCluster = true

        // press 'tab' key to take focus, and use arrow keys
        pager.onFocusChangeListener = OnFocusChangeListener { v, hasFocus ->
            Log.info(
                null,
                "{} focus change: {}",
                v,
                hasFocus
            )
        }
        run {
            val indicator = LinearPagerIndicator(context)
            indicator.setPager(pager)
            val lp = ViewPager.LayoutParams()
            lp.height = pager.dp(30F)
            lp.isDecor = true
            lp.gravity = Gravity.CENTER_HORIZONTAL
            pager.addView(indicator, lp)
        }
        val lp = FrameLayout.LayoutParams(pager.dp(480F), pager.dp(360F))
        lp.gravity = Gravity.CENTER
        pager.layoutParams = lp

        // used when pages change too fast
        //pager.setOffscreenPageLimit(2);
        return pager
    }

    internal class MyAdapter : PagerAdapter() {
        override fun getCount(): Int {
            return 7
        }

        override fun instantiateItem(container: ViewGroup, position: Int): Any {
            val tv = TextView(container.context)
            tv.text = "This is page ${position + 1}"
            tv.gravity = Gravity.CENTER
            container.addView(tv)
            return tv
        }

        override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
            container.removeView(`object` as View)
        }

        override fun isViewFromObject(view: View, `object`: Any): Boolean {
            return view === `object`
        }
    }
}
