open Core_kernel[@@warning "-D"]
open Regular.Std
open Bap.Std

module Bin = Bin_prot.Utils.Make_binable(struct
    module Binable = String
    type t = Uuidm.t
    let to_binable = Uuidm.to_bytes
    let of_binable s = match Uuidm.of_bytes s with
      | None -> invalid_arg "Bad UUID format"
      | Some uuid -> uuid
  end)
[@@warning "-D"]

module Stringable = struct
  type t = Uuidm.t
  let of_string s = match Uuidm.of_string s with
    | None -> invalid_arg "Bad UUID format"
    | Some uuid -> uuid
  let to_string s = Uuidm.to_string s
end

module Sexp = Sexpable.Of_stringable(Stringable)

include Uuidm

include Regular.Make(struct
    let compare = Uuidm.compare
    include Bin
    include Sexp
    include Stringable
    let hash = Hashtbl.hash
    let module_name = None
    let version = "1.0.0"

    let pp ppf t = Uuidm.print ppf t[@@warning "-D"]
  end)

let of_string = Stringable.of_string
