# 🧑‍💻 **Chaicode - 30 Days JavaScript Challenge** 🎯

> ## _[30-Days-JavaScript-Challenge](https://courses.chaicode.com/learn/home) 🚀 by [Hitesh Choudhary Sir](https://www.linkedin.com/in/hiteshchoudhary/). This repository contains `Assignment and Assignment Solution Codes` of 30 Days JavaScript Challenge._ ❤️

<br/>

## 🔥 **Clone this Repository** 💫

You need to write the following commands on the `terminal screen` so that you can run this project locally.

```bash
https://github.com/Bharat2044/Chaicode-30_days_javascript_challenge.git
```

### Go to the Project Directory

```sh
cd Chaicode-30_days_javascript_challenge
```

### Run the File

```sh
node fileName.js
```

<br/>

## 👨‍💻 **Assignment Question with Solutions** 👀

## 📚 [_Day 01 - Variables and Data Types_](./Day%2001%20-%20Variables%20and%20Data%20Types/)

- 📒 [**Assignment**](./Day%2001%20-%20Variables%20and%20Data%20Types/Assignment/)
  - 📝 [_Readme File_](./Day%2001%20-%20Variables%20and%20Data%20Types/Assignment/Day%201%20-%20Variables%20and%20Data%20Types%20Assignment.md)
  - 📝 [_PDF File_](./Day%2001%20-%20Variables%20and%20Data%20Types/Assignment/Day%201%20-%20Variables%20and%20Data%20Types%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Variable Declaration](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Variable%20Declaration/)
    - [Activity 2 - Constant Declaration](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Constant%20Declaration/)
    - [Activity 3 - Data Types](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Data%20Types/)
    - [Activity 4 - Reassigning Variables](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Reassigning%20Variables/)
    - [Activity 5 - Understanding Const](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Understanding%20Const/)
  - 💻 [**Feature Request**](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Feature%20Request/)
    - [1. Variable Types Console Log](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Feature%20Request/1.%20Variable%20Types%20Console%20Log/)
    - [2. Reassignment Demo](./Day%2001%20-%20Variables%20and%20Data%20Types/Solutions/Feature%20Request/2.%20Reassignment%20Demo/)

## 📚 [_Day 02 - Operators_](./Day%2002%20-%20Operators/)

- 📒 [**Assignment**](./Day%2002%20-%20Operators/Assignment/)
  - 📝 [_Readme File_](./Day%2002%20-%20Operators/Assignment/Day%202%20-%20Operators%20Assignment.md)
  - 📝 [_PDF File_](./Day%2002%20-%20Operators/Assignment/Day%202-%20Operators%20Assignmet.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2002%20-%20Operators/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2002%20-%20Operators/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Arithmetic Operations](./Day%2002%20-%20Operators/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Arithmetic%20Operations/)
    - [Activity 2 - Assignment Operators](./Day%2002%20-%20Operators/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Assignment%20Operators/)
    - [Activity 3 - Comparison Operators](./Day%2002%20-%20Operators/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Comparison%20Operators/)
    - [Activity 4 - Logical Operators](./Day%2002%20-%20Operators/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Logical%20Operators/)
    - [Activity 5 - Ternary Operator](./Day%2002%20-%20Operators/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Ternary%20Operator/)
  - 💻 [**Feature Request**](./Day%2002%20-%20Operators/Solutions/Feature%20Request/)
    - [1. Arithmetic Operations Script](./Day%2002%20-%20Operators/Solutions/Feature%20Request/1.%20Arithmetic%20Operations%20Script/)
    - [2. Comparison and Logical Operators Script](./Day%2002%20-%20Operators/Solutions/Feature%20Request/2.%20Comparison%20and%20Logical%20Operators%20Script/)
    - [3. Ternary Operator Script](./Day%2002%20-%20Operators/Solutions/Feature%20Request/3.%20Ternary%20Operator%20Script/)

## 📚 [_Day 03 - Control Structures_](./Day%2003%20-%20Control%20Structures/)

- 📒 [**Assignment**](./Day%2003%20-%20Control%20Structures/Assignment/)
  - 📝 [_Readme File_](./Day%2003%20-%20Control%20Structures/Assignment/Day%203%20-%20Control%20Structures%20Assignment.md)
  - 📝 [_PDF File_](./Day%2003%20-%20Control%20Structures/Assignment/Day%203%20-%20Control%20Structures%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2003%20-%20Control%20Structures/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2003%20-%20Control%20Structures/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - If-Else Statements](./Day%2003%20-%20Control%20Structures/Solutions/Tasks%20or%20Activities/Activity%201%20-%20If-Else%20Statements/)
    - [Activity 2 - Nested If-Else Statements](./Day%2003%20-%20Control%20Structures/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Nested%20If-Else%20Statements/)
    - [Activity 3 - Switch Case](./Day%2003%20-%20Control%20Structures/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Switch%20Case/)
    - [Activity 4 - Conditional (Ternary) Operator](<./Day%2003%20-%20Control%20Structures/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Conditional%20(Ternary)%20Operator/>)
    - [Activity 5 - Combining Conditions](./Day%2003%20-%20Control%20Structures/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Combining%20Conditions/)
  - 💻 [**Feature Request**](./Day%2003%20-%20Control%20Structures/Solutions/Feature%20Request/)
    - [1. Number Check Script](./Day%2003%20-%20Control%20Structures/Solutions/Feature%20Request/1.%20Number%20Check%20Script/)
    - [2. Voting Eligibility Script](./Day%2003%20-%20Control%20Structures/Solutions/Feature%20Request/2.%20Voting%20Eligibility%20Script/)
    - [3. Day of the Week Script](./Day%2003%20-%20Control%20Structures/Solutions/Feature%20Request/3.%20Day%20of%20the%20Week%20Script/)
    - [4. Grade Assignment Script](./Day%2003%20-%20Control%20Structures/Solutions/Feature%20Request/4.%20Grade%20Assignment%20Script/)
    - [5. Leap Year Check Script](./Day%2003%20-%20Control%20Structures/Solutions/Feature%20Request/5.%20Leap%20Year%20Check%20Script/)

## 📚 [_Day 04 - Loops_](./Day%2004%20-%20Loops/)

- 📒 [**Assignment**](./Day%2004%20-%20Loops/Assignment/)
  - 📝 [_Readme File_](./Day%2004%20-%20Loops/Assignment/Day%204%20-%20Loops%20Assignment.md)
  - 📝 [_PDF File_](./Day%2004%20-%20Loops/Assignment/Day%204%20-%20Loops%20Assignment.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2004%20-%20Loops/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2004%20-%20Loops/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - For Loop](./Day%2004%20-%20Loops/Solutions/Tasks%20or%20Activities/Activity%201%20-%20For%20Loop/)
    - [Activity 2 - While Loop](./Day%2004%20-%20Loops/Solutions/Tasks%20or%20Activities/Activity%202%20-%20While%20Loop/)
    - [Activity 3 - Do...While Loop](./Day%2004%20-%20Loops/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Do...While%20Loop/)
    - [Activity 4 - Nested Loops](./Day%2004%20-%20Loops/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Nested%20Loop/)
    - [Activity 5 - Loop Control Statements](./Day%2004%20-%20Loops/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Loop%20Control%20Statements/)
  - 💻 [**Feature Request**](./Day%2004%20-%20Loops/Solutions/Feature%20Request/)
    - [1. Number Printing Script](./Day%2004%20-%20Loops/Solutions/Feature%20Request/1.%20Number%20Printing%20Script/)
    - [2. Multiplication Table Script](./Day%2004%20-%20Loops/Solutions/Feature%20Request/2.%20Multiplication%20Table%20Script/)
    - [3. Pattern Printing Script](./Day%2004%20-%20Loops/Solutions/Feature%20Request/3.%20Pattern%20Printing%20Script/)
    - [4. Sum Calculation Script](./Day%2004%20-%20Loops/Solutions/Feature%20Request/4.%20Sum%20Calculation%20Script/)
    - [5. Factorial Calculation Script](./Day%2004%20-%20Loops/Solutions/Feature%20Request/5.%20Factorial%20Calculation%20Script/)

## 📚 [_Day 05 - Functions_](./Day%2005%20-%20Functions/)

- 📒 [**Assignment**](./Day%2005%20-%20Functions/Assignment/)
  - 📝 [_Readme File_](./Day%2005%20-%20Functions/Assignment/Day%205%20-%20Functions%20Assignment.md)
  - 📝 [_PDF File_](./Day%2005%20-%20Functions/Assignment/Day%20-%205%20Functions%20Assignment.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2005%20-%20Functions/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2005%20-%20Functions/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Function Declaration](./Day%2005%20-%20Functions/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Function%20Declaration/)
    - [Activity 2 - Function Expression](./Day%2005%20-%20Functions/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Function%20Expression/)
    - [Activity 3 - Arrow Functions](./Day%2005%20-%20Functions/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Arrow%20Functions/)
    - [Activity 4 - Function Parameters and Default Values](./Day%2005%20-%20Functions/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Function%20Parameters%20and%20Default%20Values/)
    - [Activity 5 - Higher-Order Functions](./Day%2005%20-%20Functions/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Higher-Order%20Functions/)
  - 💻 [**Feature Request**](./Day%2005%20-%20Functions/Solutions/Feature%20Request/)
    - [1. Even or Odd Function Script](./Day%2005%20-%20Functions/Solutions/Feature%20Request/1.%20Even%20or%20Odd%20Function%20Script/)
    - [2. Square Calculation Function Script](./Day%2005%20-%20Functions/Solutions/Feature%20Request/2.%20Square%20Calculation%20Function%20Script/)
    - [3. Concatenation Function Script](./Day%2005%20-%20Functions/Solutions/Feature%20Request/3.%20Concatenation%20Function%20Script/)
    - [4. Sum Calculation Arrow Function Script](./Day%2005%20-%20Functions/Solutions/Feature%20Request/4.%20Sum%20Calculation%20Arrow%20Function%20Script/)
    - [5. Higher-Order Function Script](./Day%2005%20-%20Functions/Solutions/Feature%20Request/5.%20Higher-Order%20Function%20Script/)

## 📚 [_Day 06 - Arrays_](./Day%2006%20-%20Arrays/)

- 📒 [**Assignment**](./Day%2006%20-%20Arrays/Assignment/)
  - 📝 [_Readme File_](./Day%2006%20-%20Arrays/Assignment/Day%206%20-%20Arrays%20Assignment.md)
  - 📝 [_PDF File_](./Day%2006%20-%20Arrays/Assignment/Day%206%20-%20Arrays%20Assignment.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2006%20-%20Arrays/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2006%20-%20Arrays/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Array Creation and Access](./Day%2006%20-%20Arrays/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Array%20Creation%20and%20Access/)
    - [Activity 2 - Array Methods (Basic)](<./Day%2006%20-%20Arrays/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Array%20Methods%20(Basic)/>)
    - [Activity 3 - Array Methods (Intermediate)](<./Day%2006%20-%20Arrays/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Array%20Methods%20(Intermediate)/>)
    - [Activity 4 - Array Iteration](./Day%2006%20-%20Arrays/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Array%20Iteration/)
    - [Activity 5 - Multi-dimensional Arrays](./Day%2006%20-%20Arrays/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Multi-dimensional%20Arrays/)
  - 💻 [**Feature Request**](./Day%2006%20-%20Arrays/Solutions/Feature%20Request/)
    - [1. Array Manipulation Script](./Day%2006%20-%20Arrays/Solutions/Feature%20Request/1.%20Array%20Manipulation%20Script/)
    - [2. Array Transformation Script](./Day%2006%20-%20Arrays/Solutions/Feature%20Request/2.%20Array%20Transformation%20Script/)
    - [3. Array Iteration Script](./Day%2006%20-%20Arrays/Solutions/Feature%20Request/3.%20Array%20Iteration%20Script/)
    - [4. Two-dimensional Array Script](./Day%2006%20-%20Arrays/Solutions/Feature%20Request/4.%20Two-dimensional%20Array%20Script/)

## 📚 [_Day 07 - Objects_](./Day%2007%20-%20Objects/)

- 📒 [**Assignment**](./Day%2007%20-%20Objects/Assignment/)
  - 📝 [_Readme File_](./Day%2007%20-%20Objects/Assignment/Day%207%20-%20Objects%20Assignment.md)
  - 📝 [_PDF File_](./Day%2007%20-%20Objects/Assignment/Day%207%20-%20Objects%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2007%20-%20Objects/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2007%20-%20Objects/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Object Creation and Access](./Day%2007%20-%20Objects/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Object%20Creation%20and%20Access/)
    - [Activity 2 - Object Methods](./Day%2007%20-%20Objects/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Object%20Methods/)
    - [Activity 3 - Nested Objects](./Day%2007%20-%20Objects/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Nested%20Objects/)
    - [Activity 4 - The this Keyword](./Day%2007%20-%20Objects/Solutions/Tasks%20or%20Activities/Activity%204%20-%20The%20this%20Keyword/)
    - [Activity 5 - Object Iteration](./Day%2007%20-%20Objects/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Object%20Iteration/)
  - 💻 [**Feature Request**](./Day%2007%20-%20Objects/Solutions/Feature%20Request/)
    - [1. Book Object Script](./Day%2007%20-%20Objects/Solutions/Feature%20Request/1.%20Book%20Object%20Script/)
    - [2. Library Object Script](./Day%2007%20-%20Objects/Solutions/Feature%20Request/2.%20Library%20Object%20Script/)
    - [3. Object Iteration Script](./Day%2007%20-%20Objects/Solutions/Feature%20Request/3.%20Object%20Iteration%20Script/)
    - [4. Two-dimensional Array Script](./Day%2006%20-%20Arrays/Solutions/Feature%20Request/4.%20Two-dimensional%20Array%20Script/)

## 📚 [_Day 08 - ES6+ Features_](./Day%2008%20-%20ES6+%20Features/)

- 📒 [**Assignment**](./Day%2008%20-%20ES6+%20Features/Assignment/)
  - 📝 [_Readme File_](./Day%2008%20-%20ES6+%20Features/Assignment/Day%208%20-%20ES6+%20Features%20Assignment.md/)
  - 📝 [_PDF File_](./Day%2008%20-%20ES6+%20Features/Assignment/Day%208%20-%20ES6+%20Features%20Assignment.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2008%20-%20ES6+%20Features/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2008%20-%20ES6+%20Features/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Template Literals](./Day%2008%20-%20ES6+%20Features/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Template%20Literals/)
    - [Activity 2 - Destructuring](./Day%2008%20-%20ES6+%20Features/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Destructuring/)
    - [Activity 3 - Spread and Rest Operators](./Day%2008%20-%20ES6+%20Features/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Spread%20and%20Rest%20Operators/)
    - [Activity 4 - Default Parameters](./Day%2008%20-%20ES6+%20Features/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Default%20Parameters/)
    - [Activity 5 - Enhanced Object Literals](./Day%2008%20-%20ES6+%20Features/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Enhanced%20Object%20Literals/)
  - 💻 [**Feature Request**](./Day%2008%20-%20ES6+%20Features/Solutions/Feature%20Request/)
    - [1. Template Literals Script](./Day%2008%20-%20ES6+%20Features/Solutions/Feature%20Request/1.%20Template%20Literals%20Script/)
    - [2. Destructuring Script](./Day%2008%20-%20ES6+%20Features/Solutions/Feature%20Request/2.%20Destructuring%20Script/)
    - [3. Spread and Rest Operators Script](./Day%2008%20-%20ES6+%20Features/Solutions/Feature%20Request/3.%20Spread%20and%20Rest%20Operators%20Script/solution.js)
    - [4. Default Parameters Script](./Day%2008%20-%20ES6+%20Features/Solutions/Feature%20Request/4.%20Default%20Parameters%20Script/)
    - [5. Enhanced Object Literals Script](./Day%2008%20-%20ES6+%20Features/Solutions/Feature%20Request/5.%20Enhanced%20Object%20Literals%20Script/)

## 📚 [_Day 09 - DOM Manipulation_](./Day%2009%20-%20DOM%20Manipulation/)

- 📒 [**Assignment**](./Day%2009%20-%20DOM%20Manipulation/Assignment/)
  - 📝 [_Readme File_](./Day%2009%20-%20DOM%20Manipulation/Assignment/Day%209%20-%20DOM%20Manipulation%20Assignment.md)
  - 📝 [_PDF File_](./Day%2009%20-%20DOM%20Manipulation/Assignment/Day%209%20-%20DOM%20Manipulation%20Assignment.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2009%20-%20DOM%20Manipulation/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2009%20-%20DOM%20Manipulation/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Selecting and Manipulating Elements](./Day%2009%20-%20DOM%20Manipulation/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Selecting%20and%20Manipulating%20Elements/)
    - [Activity 2 - Creating and Appending Elements](./Day%2009%20-%20DOM%20Manipulation/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Creating%20and%20Appending%20Elements/)
    - [Activity 3 - Removing Elements](./Day%2009%20-%20DOM%20Manipulation/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Removing%20Elements/)
    - [Activity 4 - Modifying Attributes and Classes](./Day%2009%20-%20DOM%20Manipulation/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Modifying%20Attributes%20and%20Classes/)
    - [Activity 5 - Event Handling](./Day%2009%20-%20DOM%20Manipulation/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Event%20Handling/)
  - 💻 [**Feature Request**](./Day%2009%20-%20DOM%20Manipulation/Solutions/Feature%20Request/)
    - [1. Text Content Manipulation Script](./Day%2009%20-%20DOM%20Manipulation/Solutions/Feature%20Request/1.%20Text%20Content%20Manipulation%20Script/)
    - [2. Element Creation Script](./Day%2009%20-%20DOM%20Manipulation/Solutions/Feature%20Request/2.%20Element%20Creation%20Script/)
    - [3. Element Removal Script](./Day%2009%20-%20DOM%20Manipulation/Solutions/Feature%20Request/3.%20Element%20Removal%20Script/)
    - [4. Attribute Modification Script](./Day%2009%20-%20DOM%20Manipulation/Solutions/Feature%20Request/4.%20Attribute%20Modification%20Script/)
    - [5. Event Handling Script](./Day%2009%20-%20DOM%20Manipulation/Solutions/Feature%20Request/5.%20Event%20Handling%20Script/)

## 📚 [_Day 10 - Event Handling_](./Day%2010%20-%20Event%20Handling/)

- 📒 [**Assignment**](./Day%2010%20-%20Event%20Handling/Assignment/)
  - 📝 [_Readme File_](./Day%2010%20-%20Event%20Handling/Assignment/Day%2010%20-%20Event%20Handling%20Assignment.md)
  - 📝 [_PDF File_](./Day%2010%20-%20Event%20Handling/Assignment/Day%2010%20-%20Event%20Handling%20Assignment.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2010%20-%20Event%20Handling/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2010%20-%20Event%20Handling/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Basic Event Handling](./Day%2010%20-%20Event%20Handling/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Basic%20Event%20Handling/)
    - [Activity 2 - Mouse Events](./Day%2010%20-%20Event%20Handling/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Mouse%20Events/)
    - [Activity 3 - Keyboard Events](./Day%2010%20-%20Event%20Handling/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Keyboard%20Events/)
    - [Activity 4 - Form Events](./Day%2010%20-%20Event%20Handling/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Form%20Events/)
    - [Activity 5 - Event Delegation](./Day%2010%20-%20Event%20Handling/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Event%20Delegation/)
  - 💻 [**Feature Request**](./Day%2010%20-%20Event%20Handling/Solutions/Feature%20Request/)
    - [1. Click Event Script](./Day%2010%20-%20Event%20Handling/Solutions/Feature%20Request/1.%20Click%20Event%20Script/)
    - [2. Mouse Events Script](./Day%2010%20-%20Event%20Handling/Solutions/Feature%20Request/2.%20Mouse%20Events%20Script/)
    - [3. Keyboard Events Script](./Day%2010%20-%20Event%20Handling/Solutions/Feature%20Request/3.%20Keyboard%20Events%20Script/)
    - [4. Form Events Script](./Day%2010%20-%20Event%20Handling/Solutions/Feature%20Request/4.%20Form%20Events%20Script/)
    - [5. Event Delegation Script](./Day%2010%20-%20Event%20Handling/Solutions/Feature%20Request/5.%20Event%20Delegation%20Script/)

## 📚 [_Day 11 - Promises and Async/Await_](./Day%2011%20-%20Promises%20and%20Async-Await/)

- 📒 [**Assignment**](./Day%2011%20-%20Promises%20and%20Async-Await/Assignment/)
  - 📝 [_Readme File_](./Day%2011%20-%20Promises%20and%20Async-Await/Assignment/Day%2011%20-%20Promises%20and%20Async-Await%20Assignment.md)
  - 📝 [_PDF File_](./Day%2011%20-%20Promises%20and%20Async-Await/Assignment/Day%2011%20-%20Promises%20and%20Async-Await%20Assignment.jpg)
- 🖥️ [**Assignment Solutions**](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Understanding Promises](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Understanding%20Promises/)
    - [Activity 2 - Chaining Promises](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Chaining%20Promises/)
    - [Activity 3 - Using Async/Await](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Using%20Async-Await/)
    - [Activity 4 - Fetching Data from an API](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Fetching%20Data%20from%20an%20API/)
    - [Activity 5 - Concurrent Promises](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Concurrent%20Promises/)
  - 💻 [**Feature Request**](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Feature%20Request/)
    - [1. Promise Creation Script](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Feature%20Request/1.%20Promise%20Creation%20Script/)
    - [2. Promise Chaining Script](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Feature%20Request/2.%20Promise%20Chaining%20Script/)
    - [3. Async/Await Script](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Feature%20Request/3.%20Async-Await%20Script/)
    - [4. API Fetch Script](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Feature%20Request/4.%20API%20Fetch%20Script/)
    - [5. Concurrent Promises Script](./Day%2011%20-%20Promises%20and%20Async-Await/Solutions/Feature%20Request/5.%20Concurrent%20Promises%20Script/)

## 📚 [_Day 12 - Error Handling_](./Day%2012%20-%20Error%20Handling/)

- 📒 [**Assignment**](./Day%2012%20-%20Error%20Handling/Assignment/)
  - 📝 [_Readme File_](./Day%2012%20-%20Error%20Handling/Assignment/Day%2012%20-%20Error%20Handling%20Assignment.md)
  - 📝 [_PDF File_](./Day%2012%20-%20Error%20Handling/Assignment/Day%2012%20-%20Error%20Handling%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2012%20-%20Error%20Handling/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2012%20-%20Error%20Handling/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Basic Error Handling with Try-Catch](./Day%2012%20-%20Error%20Handling/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Basic%20Error%20Handling%20with%20Try-Catch/)
    - [Activity 2 - Finally Block](./Day%2012%20-%20Error%20Handling/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Finally%20Block/)
    - [Activity 3 - Custom Error Objects](./Day%2012%20-%20Error%20Handling/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Custom%20Error%20Objects/)
    - [Activity 4 - Error Handling in Promises](./Day%2012%20-%20Error%20Handling/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Error%20Handling%20in%20Promises/)
    - [Activity 5 - Graceful Error Handling in Fetch](./Day%2012%20-%20Error%20Handling/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Graceful%20Error%20Handling%20in%20Fetch/)
  - 💻 [**Feature Request**](./Day%2012%20-%20Error%20Handling/Solutions/Feature%20Request/)
    - [1. Basic Error Handling Script](./Day%2012%20-%20Error%20Handling/Solutions/Feature%20Request/1.%20Basic%20Error%20Handling%20Script/)
    - [2. Custom Error Script](./Day%2012%20-%20Error%20Handling/Solutions/Feature%20Request/2.%20Custom%20Error%20Script/)
    - [3. Promise Error Handling Script](./Day%2012%20-%20Error%20Handling/Solutions/Feature%20Request/3.%20Promise%20Error%20Handling%20Script/)
    - [4. Fetch Error Handling Script](./Day%2012%20-%20Error%20Handling/Solutions/Feature%20Request/4.%20Fetch%20Error%20Handling%20Script/)

## 📚 [_Day 13 - Modules_](./Day%2013%20-%20Modules/)

- 📒 [**Assignment**](./Day%2013%20-%20Modules/Assignment/)
  - 📝 [_Readme File_](./Day%2013%20-%20Modules/Assignment/Day%2013%20-%20Modules%20Assignment.md)
  - 📝 [_PDF File_](./Day%2013%20-%20Modules/Assignment/Day%2013%20-%20Modules%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2013%20-%20Modules/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2013%20-%20Modules/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Creating and Exporting Modules](./Day%2013%20-%20Modules/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Creating%20and%20Exporting%20Modules/)
    - [Activity 2 - Named and Default Exports](./Day%2013%20-%20Modules/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Named%20and%20Default%20Exports/)
    - [Activity 3 - Importing Entire Modules](./Day%2013%20-%20Modules/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Importing%20Entire%20Modules/)
    - [Activity 4 - Using Third-Party Modules](./Day%2013%20-%20Modules/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Using%20Third-Party%20Modules/)
    - [Activity 5 - Module Bundling (Optional)](<./Day%2013%20-%20Modules/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Module%20Bundling%20(Optional)/>)
  - 💻 [**Feature Request**](./Day%2013%20-%20Modules/Solutions/Feature%20Request/)
    - [1. Basic Module Script](./Day%2013%20-%20Modules/Solutions/Feature%20Request/1.%20Basic%20Module%20Script/)
    - [2. Named and Default Exports Script](./Day%2013%20-%20Modules/Solutions/Feature%20Request/2.%20Named%20and%20Default%20Exports%20Script/)
    - [3. Third-Party Module Script](./Day%2013%20-%20Modules/Solutions/Feature%20Request/3.%20Third-Party%20Module%20Script/)
    - [4. Module Bundling Script](./Day%2013%20-%20Modules/Solutions/Feature%20Request/4.%20Module%20Bundling%20Script/)

## 📚 [_Day 14 - Classes_](./Day%2014%20-%20Classes/)

- 📒 [**Assignment**](./Day%2014%20-%20Classes/Assignment/)
  - 📝 [_Readme File_](./Day%2014%20-%20Classes/Assignment/Day%2014%20-%20Classes%20Assignment.md)
  - 📝 [_PDF File_](./Day%2014%20-%20Classes/Assignment/Day%2014%20-%20Classes%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2014%20-%20Classes/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2014%20-%20Classes/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Class Definition](./Day%2014%20-%20Classes/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Class%20Definition/)
    - [Activity 2 - Class Inheritance](./Day%2014%20-%20Classes/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Class%20Inheritance/)
    - [Activity 3 - Static Methods and Properties](./Day%2014%20-%20Classes/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Static%20Methods%20and%20Properties/)
    - [Activity 4 - Getters and Setters](./Day%2014%20-%20Classes/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Getters%20and%20Setters/)
    - [Activity 5 - Private Fields (Optional)](<./Day%2014%20-%20Classes/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Private%20Fields%20(Optional)/>)
  - 💻 [**Feature Request**](./Day%2014%20-%20Classes/Solutions/Feature%20Request/)
    - [1. Basic Class Script](./Day%2014%20-%20Classes/Solutions/Feature%20Request/1.%20Basic%20Class%20Script/)
    - [2. Class Inheritance Script](./Day%2014%20-%20Classes/Solutions/Feature%20Request/2.%20Class%20Inheritance%20Script/)
    - [3. Static Methods and Properties Script](./Day%2014%20-%20Classes/Solutions/Feature%20Request/3.%20Static%20Methods%20and%20Properties%20Script/)
    - [4. Getters and Setters Script](./Day%2014%20-%20Classes/Solutions/Feature%20Request/4.%20Getters%20and%20Setters%20Script/)
    - [5. Private Fields Script](./Day%2014%20-%20Classes/Solutions/Feature%20Request/5.%20Private%20Fields%20Script/)

## 📚 [_Day 15 - Closures_](./Day%2015%20-%20Closures/)

- 📒 [**Assignment**](./Day%2015%20-%20Closures/Assignment/)
  - 📝 [_Readme File_](./Day%2015%20-%20Closures/Assignment/Day%2015%20-%20Closures%20Assignment.md)
  - 📝 [_PDF File_](./Day%2015%20-%20Closures/Assignment/Day%2015%20-%20Closures%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2015%20-%20Closures/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2015%20-%20Closures/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Understanding Closures](./Day%2015%20-%20Closures/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Understanding%20Closures/)
    - [Activity 2 - Practical Closures](./Day%2015%20-%20Closures/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Practical%20Closures/)
    - [Activity 3 - Closures in Loops](./Day%2015%20-%20Closures/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Closures%20in%20Loops/)
    - [Activity 4 - Module Pattern](./Day%2015%20-%20Closures/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Module%20Pattern/)
    - [Activity 5 - Memoization](./Day%2015%20-%20Closures/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Memoization/)
  - 💻 [**Feature Request**](./Day%2015%20-%20Closures/Solutions/Feature%20Request/)
    - [1. Basic Closure Script](./Day%2015%20-%20Closures/Solutions/Feature%20Request/1.%20Basic%20Closure%20Script/)
    - [2. Counter Closure Script](./Day%2015%20-%20Closures/Solutions/Feature%20Request/2.%20Counter%20Closure%20Script/)
    - [3. Unique ID Generator Script](./Day%2015%20-%20Closures/Solutions/Feature%20Request/3.%20Unique%20ID%20Generator%20Script/)
    - [4. Loop Closure Script](./Day%2015%20-%20Closures/Solutions/Feature%20Request/4.%20Loop%20Closure%20Script/)
    - [5. Memoization Script](./Day%2015%20-%20Closures/Solutions/Feature%20Request/5.%20Memoization%20Script/)

## 📚 [_Day 16 - Recursion_](./Day%2016%20-%20Recursion/)

- 📒 [**Assignment**](./Day%2016%20-%20Recursion/Assignment/)
  - 📝 [_Readme File_](./Day%2016%20-%20Recursion/Assignment/Day%2016%20-%20Recursion%20Assignment.md)
  - 📝 [_PDF File_](./Day%2016%20-%20Recursion/Assignment/Day%2016%20-%20Recursion%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2016%20-%20Recursion/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2016%20-%20Recursion/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Basic Recursion](./Day%2016%20-%20Recursion/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Basic%20Recursion/)
    - [Activity 2 - Recursion with Arrays](./Day%2016%20-%20Recursion/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Recursion%20with%20Arrays/)
    - [Activity 3 - String Manipulation with Recursion](./Day%2016%20-%20Recursion/Solutions/Tasks%20or%20Activities/Activity%203%20-%20String%20Manipulation%20with%20Recursion/)
    - [Activity 4 - Recursive Search](./Day%2016%20-%20Recursion/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Recursive%20Search/)
    - [Activity 5 - Tree Traversal (Optional)](<./Day%2016%20-%20Recursion/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Tree%20Traversal%20(Optional)/>)
  - 💻 [**Feature Request**](./Day%2016%20-%20Recursion/Solutions/Feature%20Request/)
    - [1. Factorial and Fibonacci Script](./Day%2016%20-%20Recursion/Solutions/Feature%20Request/1.%20Factorial%20and%20Fibonacci%20Script/)
    - [2. Array Recursion Script](./Day%2016%20-%20Recursion/Solutions/Feature%20Request/2.%20Array%20Recursion%20Script/)
    - [3. String Recursion Script](./Day%2016%20-%20Recursion/Solutions/Feature%20Request/3.%20String%20Recursion%20Script/)
    - [4. Recursive Search Script](./Day%2016%20-%20Recursion/Solutions/Feature%20Request/4.%20Recursive%20Search%20Script/)
    - [5. Tree Traversal Script](./Day%2016%20-%20Recursion/Solutions/Feature%20Request/5.%20Tree%20Traversal%20Script/)

## 📚 [_Day 17 - Data Structures_](./Day%2017%20-%20Data%20Structures/)

- 📒 [**Assignment**](./Day%2017%20-%20Data%20Structures/Assignment/)
  - 📝 [_Readme File_](./Day%2017%20-%20Data%20Structures/Assignment/Day%2017%20-%20Data%20Structures%20Assignment.md)
  - 📝 [_PDF File_](./Day%2017%20-%20Data%20Structures/Assignment/Day%2017%20-%20Data%20Structures%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2017%20-%20Data%20Structures/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2017%20-%20Data%20Structures/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Linked List](./Day%2017%20-%20Data%20Structures/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Linked%20List/)
    - [Activity 2 - Stack](./Day%2017%20-%20Data%20Structures/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Stack/)
    - [Activity 3 - Queue](./Day%2017%20-%20Data%20Structures/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Queue/)
    - [Activity 4 - Binary Tree](./Day%2017%20-%20Data%20Structures/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Binary%20Tree/)
    - [Activity 5 - Graph (Optional)](<./Day%2017%20-%20Data%20Structures/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Graph%20(Optional)/>)
  - 💻 [**Feature Request**](./Day%2017%20-%20Data%20Structures/Solutions/Feature%20Request/)
    - [1. Linked List Script](./Day%2017%20-%20Data%20Structures/Solutions/Feature%20Request/1.%20Linked%20List%20Script/)
    - [2. Stack Script](./Day%2017%20-%20Data%20Structures/Solutions/Feature%20Request/2.%20Stack%20Script/)
    - [3. Queue Script](./Day%2017%20-%20Data%20Structures/Solutions/Feature%20Request/3.%20Queue%20Script/)
    - [4. Binary Tree Script](./Day%2017%20-%20Data%20Structures/Solutions/Feature%20Request/4.%20Binary%20Tree%20Script/)
    - [5. Graph Script](./Day%2017%20-%20Data%20Structures/Solutions/Feature%20Request/5.%20Graph%20Script/)

## 📚 [_Day 18 - Algorithms_](./Day%2018%20-%20Algorithms/)

- 📒 [**Assignment**](./Day%2018%20-%20Algorithms/Assignment/)
  - 📝 [_Readme File_](./Day%2018%20-%20Algorithms/Assignment/Day%2018%20-%20Algorithms%20Assignment.md)
  - 📝 [_PDF File_](./Day%2018%20-%20Algorithms/Assignment/Day%2018%20-%20Algorithms%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2018%20-%20Algorithms/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2018%20-%20Algorithms/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Sorting Algorithms](./Day%2018%20-%20Algorithms/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Sorting%20Algorithms/)
    - [Activity 2 - Searching Algorithms](./Day%2018%20-%20Algorithms/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Searching%20Algorithms/)
    - [Activity 3 - String Algorithms](./Day%2018%20-%20Algorithms/Solutions/Tasks%20or%20Activities/Activity%203%20-%20String%20Algorithms/)
    - [Activity 4 - Array Algorithms](./Day%2018%20-%20Algorithms/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Array%20Algorithms/)
    - [Activity 5 - Dynamic Programming (Optional)](<./Day%2018%20-%20Algorithms/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Dynamic%20Programming%20(Optional)/>)
  - 💻 [**Feature Request**](./Day%2018%20-%20Algorithms/Solutions/Feature%20Request/)
    - [1. Sorting Algorithm Script](./Day%2018%20-%20Algorithms/Solutions/Feature%20Request/1.%20Sorting%20Algorithm%20Script/)
    - [2. Searching Algorithm Script](./Day%2018%20-%20Algorithms/Solutions/Feature%20Request/2.%20Searching%20Algorithm%20Script/)
    - [3. String Algorithm Script](./Day%2018%20-%20Algorithms/Solutions/Feature%20Request/3.%20String%20Algorithm%20Script/)
    - [4. Array Algorithm Script](./Day%2018%20-%20Algorithms/Solutions/Feature%20Request/4.%20Array%20Algorithm%20Script/)
    - [5. Dynamic Programming Script](./Day%2018%20-%20Algorithms/Solutions/Feature%20Request/5.%20Dynamic%20Programming%20Script/)

## 📚 [_Day 19 - Regular Expressions_](./Day%2019%20-%20Regular%20Expressions/)

- 📒 [**Assignment**](./Day%2019%20-%20Regular%20Expressions/Assignment/)
  - 📝 [_Readme File_](./Day%2019%20-%20Regular%20Expressions/Assignment/Day%2019%20-%20Regular%20Expressions%20Assignment.md)
  - 📝 [_PDF File_](./Day%2019%20-%20Regular%20Expressions/Assignment/Day%2019%20-%20Regular%20Expressions%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2019%20-%20Regular%20Expressions/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2019%20-%20Regular%20Expressions/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Basic Regular Expressions](./Day%2019%20-%20Regular%20Expressions/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Basic%20Regular%20Expressions/)
    - [Activity 2 - Character Classes and Quantifiers](./Day%2019%20-%20Regular%20Expressions/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Character%20Classes%20and%20Quantifiers/)
    - [Activity 3 - Grouping and Capturing](./Day%2019%20-%20Regular%20Expressions/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Grouping%20and%20Capturing/)
    - [Activity 4 - Assertions and Boundaries](./Day%2019%20-%20Regular%20Expressions/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Assertions%20and%20Boundaries/)
    - [Activity 5 - Practical Applications](./Day%2019%20-%20Regular%20Expressions/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Practical%20Applications/)
  - 💻 [**Feature Request**](./Day%2019%20-%20Regular%20Expressions/Solutions/Feature%20Request/)
    - [1. Basic Regex Script](./Day%2019%20-%20Regular%20Expressions/Solutions/Feature%20Request/1.%20Basic%20Regex%20Script/)
    - [2. Character Classes and Quantifiers Script](./Day%2019%20-%20Regular%20Expressions/Solutions/Feature%20Request/2.%20Character%20Classes%20and%20Quantifiers%20Script/)
    - [3. Grouping and Capturing Script](./Day%2019%20-%20Regular%20Expressions/Solutions/Feature%20Request/3.%20Grouping%20and%20Capturing%20Script/)
    - [4. Assertions and Boundaries Script](./Day%2019%20-%20Regular%20Expressions/Solutions/Feature%20Request/4.%20Assertions%20and%20Boundaries%20Script/)
    - [5. Validation Script](./Day%2019%20-%20Regular%20Expressions/Solutions/Feature%20Request/5.%20Validation%20Script/)

## 📚 [_Day 20 - LocalStorage and SessionStorage_](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/)

- 📒 [**Assignment**](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Assignment/)
  - 📝 [_Readme File_](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Assignment/Day%2020%20-%20LocalStorage%20and%20SessionStorage%20Assignment.md)
  - 📝 [_PDF File_](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Assignment/Day%2020%20-%20LocalStorage%20and%20SessionStorage%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Understanding LocalStorage](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Understanding%20LocalStorage/)
    - [Activity 2 - Using LocalStorage](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Using%20LocalStorage/)
    - [Activity 3 - Understanding SessionStorage](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Understanding%20SessionStorage/)
    - [Activity 4 - Using SessionStorage](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Using%20SessionStorage/)
    - [Activity 5 - Comparing LocalStorage and SessionStorage](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Comparing%20LocalStorage%20and%20SessionStorage/)
  - 💻 [**Feature Request**](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Feature%20Request/)
    - [1. LocalStorage Script](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Feature%20Request/1.%20LocalStorage%20Script/)
    - [2. SessionStorage Script](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Feature%20Request/2.%20SessionStorage%20Script/)
    - [3. Storage Comparison Script](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Feature%20Request/3.%20Storage%20Comparison%20Script/)
    - [4. Clear Storage Script](./Day%2020%20-%20LocalStorage%20and%20SessionStorage/Solutions/Feature%20Request/4.%20Clear%20Storage%20Script/)

## 📚 [_Day 21 - LeetCode Easy_](./Day%2021%20-%20LeetCode%20Easy/)

- 📒 [**Assignment**](./Day%2021%20-%20LeetCode%20Easy/Assignment/)
  - 📝 [_Readme File_](./Day%2021%20-%20LeetCode%20Easy/Assignment/Day%2021%20-%20LeetCode%20Easy%20Assignment.md)
  - 📝 [_PDF File_](./Day%2021%20-%20LeetCode%20Easy/Assignment/Day%2021%20-%20LeetCode%20Easy%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2021%20-%20LeetCode%20Easy/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2021%20-%20LeetCode%20Easy/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Two Sum](./Day%2021%20-%20LeetCode%20Easy/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Two%20Sum/)
    - [Activity 2 - Reverse Integer](./Day%2021%20-%20LeetCode%20Easy/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Reverse%20Integer/)
    - [Activity 3 - Palindrome Number](./Day%2021%20-%20LeetCode%20Easy/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Palindrome%20Number/)
    - [Activity 4 - Merge Two Sorted Lists](./Day%2021%20-%20LeetCode%20Easy/Solutions/Tasks%20or%20Activities/Activity%204%20-%20Merge%20Two%20Sorted%20Lists/)
    - [Activity 5 - Valid Parentheses](./Day%2021%20-%20LeetCode%20Easy/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Valid%20Parentheses/)
  - 💻 [**Feature Request**](./Day%2021%20-%20LeetCode%20Easy/Solutions/Feature%20Request/)
    - [1. Two Sum Script](./Day%2021%20-%20LeetCode%20Easy/Solutions/Feature%20Request/1.%20Two%20Sum%20Script/)
    - [2. Reverse Integer Script](./Day%2021%20-%20LeetCode%20Easy/Solutions/Feature%20Request/2.%20Reverse%20Integer%20Script/)
    - [3. Palindrome Number Script](./Day%2021%20-%20LeetCode%20Easy/Solutions/Feature%20Request/3.%20Palindrome%20Number%20Script/)
    - [4. Merge Two Sorted Lists Script](./Day%2021%20-%20LeetCode%20Easy/Solutions/Feature%20Request/4.%20Merge%20Two%20Sorted%20Lists%20Script/)
    - [5. Valid Parentheses Script](./Day%2021%20-%20LeetCode%20Easy/Solutions/Feature%20Request/5.%20Valid%20Parentheses%20Script/)

## 📚 [_Day 22 - LeetCode Medium_](./Day%2022%20-%20LeetCode%20Medium/)

- 📒 [**Assignment**](./Day%2022%20-%20LeetCode%20Medium/Assignment/)
  - 📝 [_Readme File_](./Day%2022%20-%20LeetCode%20Medium/Assignment/Day%2022%20-%20LeetCode%20Medium%20Assignment.md)
  - 📝 [_PDF File_](./Day%2022%20-%20LeetCode%20Medium/Assignment/Day%2022%20-%20LeetCode%20Medium%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2022%20-%20LeetCode%20Medium/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2022%20-%20LeetCode%20Medium/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Add Two Numbers](./Day%2022%20-%20LeetCode%20Medium/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Add%20Two%20Numbers/)
    - [Activity 2 - Longest Substring Without Repeating Characters](./Day%2022%20-%20LeetCode%20Medium/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Longest%20Substring%20Without%20Repeating%20Characters/)
    - [Activity 3 - Container With Most Water](./Day%2022%20-%20LeetCode%20Medium/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Container%20With%20Most%20Water/)
    - [Activity 4 - 3Sum](./Day%2022%20-%20LeetCode%20Medium/Solutions/Tasks%20or%20Activities/Activity%204%20-%203Sum/)
    - [Activity 5 - Group Anagrams](./Day%2022%20-%20LeetCode%20Medium/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Group%20Anagrams/)
  - 💻 [**Feature Request**](./Day%2022%20-%20LeetCode%20Medium/Solutions/Feature%20Request/)
    - [1. Add Two Numbers Script](./Day%2022%20-%20LeetCode%20Medium/Solutions/Feature%20Request/1.%20Add%20Two%20Numbers%20Script/)
    - [2. Longest Substring Script](./Day%2022%20-%20LeetCode%20Medium/Solutions/Feature%20Request/2.%20Longest%20Substring%20Script/)
    - [3. Container With Most Water Script](./Day%2022%20-%20LeetCode%20Medium/Solutions/Feature%20Request/3.%20Container%20With%20Most%20Water%20Script/)
    - [4. 3Sum Script](./Day%2022%20-%20LeetCode%20Medium/Solutions/Feature%20Request/4.%203Sum%20Script//)
    - [5. Group Anagrams Script](./Day%2022%20-%20LeetCode%20Medium/Solutions/Feature%20Request/5.%20Group%20Anagrams%20Script/)

## 📚 [_Day 23 - LeetCode Hard_](./Day%2023%20-%20LeetCode%20Hard/)

- 📒 [**Assignment**](./Day%2023%20-%20LeetCode%20Hard/Assignment/)
  - 📝 [_Readme File_](./Day%2023%20-%20LeetCode%20Hard/Assignment/Day%2023%20-%20LeetCode%20Hard%20Assignment.md)
  - 📝 [_PDF File_](./Day%2023%20-%20LeetCode%20Hard/Assignment/Day%2023%20-%20LeetCode%20Hard%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2023%20-%20LeetCode%20Hard/Solutions/)
  - 💻 [**Tasks / Activities**](./Day%2023%20-%20LeetCode%20Hard/Solutions/Tasks%20or%20Activities/)
    - [Activity 1 - Median of Two Sorted Arrays](./Day%2023%20-%20LeetCode%20Hard/Solutions/Tasks%20or%20Activities/Activity%201%20-%20Median%20of%20Two%20Sorted%20Arrays/)
    - [Activity 2 - Merge k Sorted Lists](./Day%2023%20-%20LeetCode%20Hard/Solutions/Tasks%20or%20Activities/Activity%202%20-%20Merge%20k%20Sorted%20Lists/)
    - [Activity 3 - Trapping Rain Water](./Day%2023%20-%20LeetCode%20Hard/Solutions/Tasks%20or%20Activities/Activity%203%20-%20Trapping%20Rain%20Water/)
    - [Activity 4 - N-Queens](./Day%2023%20-%20LeetCode%20Hard/Solutions/Tasks%20or%20Activities/Activity%204%20-%20N-Queens/)
    - [Activity 5 - Word Ladder](./Day%2023%20-%20LeetCode%20Hard/Solutions/Tasks%20or%20Activities/Activity%205%20-%20Word%20Ladder/)
  - 💻 [**Feature Request**](./Day%2023%20-%20LeetCode%20Hard/Solutions/Feature%20Request/)
    - [1. Median of Two Sorted Arrays Script](./Day%2023%20-%20LeetCode%20Hard/Solutions/Feature%20Request/1.%20Median%20of%20Two%20Sorted%20Arrays%20Script/)
    - [2. Merge k Sorted Lists Script](./Day%2023%20-%20LeetCode%20Hard/Solutions/Feature%20Request/2.%20Merge%20k%20Sorted%20Lists%20Script/)
    - [3. Trapping Rain Water Script](./Day%2023%20-%20LeetCode%20Hard/Solutions/Feature%20Request/3.%20Trapping%20Rain%20Water%20Script/)
    - [4. N-Queens Script](./Day%2023%20-%20LeetCode%20Hard/Solutions/Feature%20Request/4.%20N-Queens%20Script/)
    - [5. Word Ladder Script](./Day%2023%20-%20LeetCode%20Hard/Solutions/Feature%20Request/5.%20Word%20Ladder%20Script/)

## 📚 [_Day 24 - Project 1: Weather App_](./Day%2024%20-%20Project%201%20-%20Weather%20App/)

- 📒 [**Assignment**](./Day%2024%20-%20Project%201%20-%20Weather%20App/Assignment/)
  - 📝 [_Readme File_](./Day%2024%20-%20Project%201%20-%20Weather%20App/Assignment/Day%2024%20-%20Project%201%20-%20Weather%20App%20Assignment.md)
  - 📝 [_PDF File_](./Day%2024%20-%20Project%201%20-%20Weather%20App/Assignment/Day%2024%20-%20Project%201%20-%20Weather%20App%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2024%20-%20Project%201%20-%20Weather%20App/Solutions/)
  - 💻 [Tasks / Activities](./Day%2024%20-%20Project%201%20-%20Weather%20App/Solutions/)

## 📚 [_Day 25 - Project 2: MovieSearch App_](./Day%2025%20-%20Project%202%20-%20MovieSearch%20App/)

- 📒 [**Assignment**](./Day%2025%20-%20Project%202%20-%20MovieSearch%20App/Assignment/)
  - 📝 [_Readme File_](./Day%2025%20-%20Project%202%20-%20MovieSearch%20App/Assignment/Day%2025%20-%20Project%202%20-%20MovieSearch%20App%20Assignment.md)
  - 📝 [_PDF File_](./Day%2025%20-%20Project%202%20-%20MovieSearch%20App/Assignment/Day%2025%20-%20Project%202%20-%20MovieSearch%20App%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2025%20-%20Project%202%20-%20MovieSearch%20App/Solutions/)
  - 💻 [Tasks / Activities](./Day%2025%20-%20Project%202%20-%20MovieSearch%20App/Solutions/)

## 📚 [_Day 26 - Project 3: Chat Application_](./Day%2026%20-%20Project%203%20-%20Chat%20Application/)

- 📒 [**Assignment**](./Day%2026%20-%20Project%203%20-%20Chat%20Application/Assignment/)
  - 📝 [_Readme File_](./Day%2026%20-%20Project%203%20-%20Chat%20Application/Assignment/Day%2026%20-%20Project%203%20-%20Chat%20Application%20Assignment.md)
  - 📝 [_PDF File_](./Day%2026%20-%20Project%203%20-%20Chat%20Application/Assignment/Day%2026%20-%20Project%203%20-%20Chat%20Application%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2026%20-%20Project%203%20-%20Chat%20Application/Solutions/)
  - 💻 [Tasks / Activities](./Day%2026%20-%20Project%203%20-%20Chat%20Application/Solutions/)

## 📚 [_Day 27 - Project 4: Task Management App_](./Day%2027%20-%20Project%204%20-%20Task%20Management%20App/)

- 📒 [**Assignment**](./Day%2027%20-%20Project%204%20-%20Task%20Management%20App/Assignment/)
  - 📝 [_Readme File_](./Day%2027%20-%20Project%204%20-%20Task%20Management%20App/Assignment/Day%2027%20-%20Project%204%20-%20Task%20Management%20App%20Assignment.md)
  - 📝 [_PDF File_](./Day%2027%20-%20Project%204%20-%20Task%20Management%20App/Assignment/Day%2027%20-%20Project%204%20-%20Task%20Management%20App%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2027%20-%20Project%204%20-%20Task%20Management%20App/Solutions/)
  - 💻 [Tasks / Activities](./Day%2027%20-%20Project%204%20-%20Task%20Management%20App/Solutions/)

## 📚 [_Day 28 - Project 5: E-commerce Website_](./Day%2028%20-%20Project%205%20-%20E-commerce%20Website/)

- 📒 [**Assignment**](./Day%2028%20-%20Project%205%20-%20E-commerce%20Website/Assignment/)
  - 📝 [_Readme File_](./Day%2028%20-%20Project%205%20-%20E-commerce%20Website/Assignment/Day%2028%20-%20Project%205%20-%20E-commerce%20Website%20Assignment.md)
  - 📝 [_PDF File_](./Day%2028%20-%20Project%205%20-%20E-commerce%20Website/Assignment/Day%2028%20-%20Project%205%20-%20E-commerce%20Website%20Assignment.png)
- 🖥️ [**Assignment Solutions**](./Day%2028%20-%20Project%205%20-%20E-commerce%20Website/Solutions/)
  - 💻 [Tasks / Activities](./Day%2028%20-%20Project%205%20-%20E-commerce%20Website/Solutions/)

<br />

## 🔗 **Let's Connect** 🤝

[![LinkedIn](https://img.shields.io/badge/LinkedIn-%230077B5.svg?logo=linkedin&logoColor=white)](https://www.linkedin.com/in/bharat2044/)
[![Twitter](https://img.shields.io/badge/Twitter-%231DA1F2.svg?logo=Twitter&logoColor=white)](https://twitter.com/bharat__2044)
[![Stack Overflow](https://img.shields.io/badge/-Stackoverflow-FE7A16?logo=stack-overflow&logoColor=white)](https://stackoverflow.com/users/21453213/bharat2044)
<a href='https://medium.com/@Bharat2044' target="_blank"><img alt='Medium' src='https://img.shields.io/badge/Medium-100000?style=plastic&logo=Medium&logoColor=000000&labelColor=475AC7&color=475AC7'/></a>
[![Discord](https://img.shields.io/badge/Discord-%237289DA.svg?logo=discord&logoColor=white)](https://discordapp.com/users/1202345957216231446)
[![Instagram](https://img.shields.io/badge/Instagram-%23E4405F.svg?logo=Instagram&logoColor=white)](https://www.instagram.com/bharat__2044)
