"""
Given a Binary Search Tree and a target number, return true if there exist two elements in the BST such that their sum is equal to the given target.

Example 1:

Input: 
    5
   / \
  3   6
 / \   \
2   4   7

Target = 9

Output: True
 

Example 2:

Input: 
    5
   / \
  3   6
 / \   \
2   4   7

Target = 28

Output: False
"""

# Definition for a binary tree node.
# class TreeNode(object):
#     def __init__(self, x):
#         self.val = x
#         self.left = None
#         self.right = None

class Solution(object):
    def findTarget(self, root, k):
        """
        :type root: TreeNode
        :type k: int
        :rtype: bool
        """
        self.seen = set()
        self.exist = False
        def traverse(node):
            if not node:
                return
            if k - node.val in self.seen:
                self.exist = True
                return
            self.seen.add(node.val)
            traverse(node.left)
            traverse(node.right)
        traverse(root)
        return self.exist

# Definition for a binary tree node.
# class TreeNode:
#     def __init__(self, x):
#         self.val = x
#         self.left = None
#         self.right = None

class Solution:
    def findTarget(self, root: TreeNode, k: int) -> bool:
        
        self.seen = set()
        
        def dfs(node):
            if not node:
                return False
            if k - node.val in self.seen:
                return True
            self.seen.add(node.val)
            return dfs(node.left) or dfs(node.right)
        
        return dfs(root)
