"""
Find Peak Element

A peak element is an element that is greater than its neighbors.

Given an input array nums, where nums[i] ≠ nums[i+1], find a peak element and return its index.

The array may contain multiple peaks, in that case return the index to any one of the peaks is fine.

You may imagine that nums[-1] = nums[n] = -∞.

Example 1:

Input: nums = [1,2,3,1]
Output: 2
Explanation: 3 is a peak element and your function should return the index number 2.
Example 2:

Input: nums = [1,2,1,3,5,6,4]
Output: 1 or 5 
Explanation: Your function can return either index number 1 where the peak element is 2, 
             or index number 5 where the peak element is 6.
Note:

Your solution should be in logarithmic complexity.
"""

"""
Binary Search and move based on whether the current index number is larger or smaller than the next one

Time: O(log(N))
Space: O(1)
"""
class Solution:
    def findPeakElement(self, nums: List[int]) -> int:
        l, r = 0, len(nums)-1
        while l < r:
            mid = (l+r)//2
            if nums[mid] > nums[mid+1]:
                r = mid
            else:
                l = mid+1
        return l


class Solution:
    def findPeakElement(self, nums):
        """
        :type nums: List[int]
        :rtype: int
        """
        if len(nums) == 1:
            return 0

        for n in range(len(nums)):
            if not n:
                if nums[n] > nums[n + 1]:
                    return n
            elif n == len(nums) - 1:
                if nums[n] > nums[n - 1]:
                    return n
            elif nums[n] > nums[n - 1] and nums[n] > nums[n + 1]:
                return n

class Solution:
    def findPeakElement(self, nums: List[int]) -> int:
        return self.search(nums, 0, len(nums)-1)
    
    def search(self, nums, l, r):
        if l == r:
            return l
        mid = (l+r)//2
        if nums[mid] > nums[mid+1]:
            return self.search(nums, l, mid)
        return self.search(nums, mid+1, r)
