"""
Best Time To Buy And Sell Stock With Transaction Fee

Your are given an array of integers prices, for which the i-th element is the price of a given stock on day i; and a non-negative integer fee representing a transaction fee.

You may complete as many transactions as you like, but you need to pay the transaction fee for each transaction. You may not buy more than 1 share of a stock at a time (ie. you must sell the stock share before you buy again.)

Return the maximum profit you can make.

Example 1:
Input: prices = [1, 3, 2, 8, 4, 9], fee = 2
Output: 8
Explanation: The maximum profit can be achieved by:
Buying at prices[0] = 1
Selling at prices[3] = 8
Buying at prices[4] = 4
Selling at prices[5] = 9
The total profit is ((8 - 1) - 2) + ((9 - 4) - 2) = 8.
Note:

0 < prices.length <= 50000.
0 < prices[i] < 50000.
0 <= fee < 50000.
"""

"""
DP
Intuition and Algorithm

At the end of the i-th day, we maintain cash, the maximum profit we could have if we did not have a share of stock, and hold, the maximum profit we could have if we owned a share of stock.

To transition from the i-th day to the i+1-th day, we either sell our stock cash = max(cash, hold + prices[i] - fee) or buy a stock hold = max(hold, cash - prices[i]). At the end, we want to return cash. We can transform cash first without using temporary variables because selling and buying on the same day can't be better than just continuing to hold the stock.

Time: O(N)
Space: O(1)
"""
class Solution:
    def maxProfit(self, prices: List[int], fee: int) -> int:
        cash, hold = 0, -prices[0]
        for i in range(1, len(prices)):
            cash = max(cash, hold + prices[i] - fee)
            hold = max(hold, cash - prices[i])
        return cash

# O(N) Space
class Solution:
    def maxProfit(self, prices: List[int], fee: int) -> int:
        holding = [0]*len(prices)
        cash = [0]*len(prices)
        holding[0] = -prices[0]
        
        for i in range(1, len(prices)):
            cash[i] = max(cash[i-1], prices[i] + holding[i-1] - fee)
            holding[i] = max(holding[i-1], cash[i-1] - prices[i])
        
        return cash[-1]

class Solution:
    def maxProfit(self, prices: List[int], fee: int) -> int:
        if len(prices) < 2:
            return 0
        
        buy = [0]*len(prices)
        sell = [0]*len(prices)
        buy[0] = -prices[0]
        
        for i in range(1, len(prices)):
            buy[i] = max(sell[i-1]-prices[i], buy[i-1])
            sell[i] = max(prices[i]+buy[i-1]-fee, sell[i-1])
        
        return sell[-1]
