For properly rendered formulas, click here:https://nbviewer.jupyter.org/github/BenPortner/mirrors_prevent_climate_change/blob/master/mirrors_RF.html

# <div style="line-height:1.5"> Can mirrors prevent climate change? A comparison of the climate impact of artificial albedo enhancement versus synthetic fuel production and afforestation</div>

Author: Benjamin W. Portner, Bauhaus Luftfahrt e.V., Willy-Messerschmitt-Straße 1, 82024 Taufkirchen

<h1>Table of Contents<span class="tocSkip"></span></h1>
<div class="toc"><ul class="toc-item"><li><span><a href="#Research-question" data-toc-modified-id="Research-question-1"><span class="toc-item-num">1&nbsp;&nbsp;</span>Research question</a></span></li><li><span><a href="#Radiative-forcing-of-mirrors" data-toc-modified-id="Radiative-forcing-of-mirrors-2"><span class="toc-item-num">2&nbsp;&nbsp;</span>Radiative forcing of mirrors</a></span><ul class="toc-item"><li><span><a href="#Earth's-energy-budget" data-toc-modified-id="Earth's-energy-budget-2.1"><span class="toc-item-num">2.1&nbsp;&nbsp;</span>Earth's energy budget</a></span></li><li><span><a href="#The-potential-of-mirrors" data-toc-modified-id="The-potential-of-mirrors-2.2"><span class="toc-item-num">2.2&nbsp;&nbsp;</span>The potential of mirrors</a></span></li></ul></li><li><span><a href="#Radiative-forcing-of-CO2" data-toc-modified-id="Radiative-forcing-of-CO2-3"><span class="toc-item-num">3&nbsp;&nbsp;</span>Radiative forcing of CO<sub>2</sub></a></span></li><li><span><a href="#Mirror-CO2-compensation" data-toc-modified-id="Mirror-CO2-compensation-4"><span class="toc-item-num">4&nbsp;&nbsp;</span>Mirror CO<sub>2</sub> compensation</a></span></li><li><span><a href="#Comparison-to-other-CO2-mitigation-strategies" data-toc-modified-id="Comparison-to-other-CO2-mitigation-strategies-5"><span class="toc-item-num">5&nbsp;&nbsp;</span>Comparison to other CO<sub>2</sub>-mitigation strategies</a></span><ul class="toc-item"><li><span><a href="#Sun-to-Liquid" data-toc-modified-id="Sun-to-Liquid-5.1"><span class="toc-item-num">5.1&nbsp;&nbsp;</span>Sun-to-Liquid</a></span></li><li><span><a href="#Afforestation" data-toc-modified-id="Afforestation-5.2"><span class="toc-item-num">5.2&nbsp;&nbsp;</span>Afforestation</a></span></li></ul></li><li><span><a href="#Conclusion" data-toc-modified-id="Conclusion-6"><span class="toc-item-num">6&nbsp;&nbsp;</span>Conclusion</a></span></li></ul></div>

## Research question
Given that land is a limited resource, what is more effective in tackling climate change: building mirrors that reflect the incoming sun light or building a synthetic fuel plant to replace fossil fuels?

## Radiative forcing of mirrors

### Earth's energy budget

<img src="https://upload.wikimedia.org/wikipedia/commons/b/bb/The-NASA-Earth%27s-Energy-Budget-Poster-Radiant-Energy-System-satellite-infrared-radiation-fluxes.jpg" style="width:60%"> </img>




Image courtesy of NASA: Loeb et al., J. Clim 2009 & Trenberth et al, BAMS 2009. Hosting powered by Wikipedia.

Quoting Wikipedia (https://en.wikipedia.org/wiki/Solar_constant): 
The amount of solar energy received by a flat object at a distance of one Astronomical Unit (AU) from the sun is defined as the solar constant: $\sigma = 1361 \frac{W}{m^2}$. This amount is very constant even through different activity periods of the sun. The actual amount of energy arriving at the top of the earth's atmosphere varies between 1412 W/m2 in early January and 1321 W/m2 in early July due to the elliptic shape of the earth's orbit. The solar constant presents the annual mean received by the earth's cross-section ($\pi R_E^2$). Thanks to the rotation of the earth, this amount is spread among its surface ($4\pi R_E^2$). The average incoming radiation on the earth's surface is thus:

$ F_{in} = \sigma \cdot \dfrac{\pi R_E^2}{4 \pi R_E^2} \approx 340 \, \frac{W}{m^2}$

This is the amount labeled "incoming solar radiation" in above graphic. Of the 340 W/m2, approximately 30% are reflected back into space by the atmosphere and the earth's surface. This value presents the earth's average albedo (atmsopheric + surface). Another 23% of the incoming radiation are absorbed by the atmosphere and re-emitted as infrared radiation. Effectively, 186 W/m2 (55%) reach the surface of the earth (before surface reflection). 

$F_{surface} = 186  \, \frac{W}{m^2}$

The average surface albedo is the ratio of reflected radiation to incoming radiation:

$\epsilon_{surface} = \frac{22.9}{186} \approx 0.12 $

By using mirrors, this value can be increased. More energy would be reflected back to space, less energy would be absorbed and turned into infrared radiation. Thus, increasing surface albedo would have a cooling effect on the climate. In the next section, I will try to quantify this effect.

### The potential of mirrors

As stated before, installing mirrors effectively means increasing the earth surface's albedo. Albedo is a rather uncommon term to describe the efficiency of light reflection for mirrors. Instead, the term reflectivity is used (although it's definition is identical to that of albedo). Reflectivity depends on many factors such as wavelength of the incoming light, mirror material thickness, and its elemental composition.

<img src="https://upload.wikimedia.org/wikipedia/commons/e/e7/Solar_spectrum_en.svg" style="width:60%"> </img>

Image courtesy of Wikipedia: https://en.wikipedia.org/wiki/File:Solar_spectrum_en.svg

Above graphic shows the spectral composition of sunlight, both at the top of the atmosphere (yellow) and at the earth's surface (red). Clearly, most of the energy at the surface is carried in the visible and near-infrared spectrum. Smaller amounts fall in the UV-A and -B range and in the IR-B range. An ideal mirror would be insensitive to the difference. In reality, mirrors are usually sensitive either to short wavelengths or to long ones. Aluminum for example "will reflect 85 to 90% of the light in the visible to near-ultraviolet range, but experiences a drop in its reflectance between 800 and 900 nm". Silver on the other hand "can reflect up to 98 or 99% of light to wavelengths as long as 2000 nm, but loses nearly all reflectivity at wavelengths shorter than 350 nm" (https://en.wikipedia.org/wiki/Mirror#Tolerances). Silver would probably be the best candidate for our mirrors. However, aluminum is the more likely choice for large-scale application for economic reasons. Considering this, let us assume a reflectivity $\epsilon_{mirror}$ of 50%

$ F_{reflected} = F_{surface} \cdot \epsilon_{mirror} \approx 93 \, \frac{W}{m^2}$

After reflection from the mirror, radiation will again hit the atmosphere. The energy flux leaving earth is defined by the transmissivity of the earth's atmosphere:

$ F_{out} = F_{reflected} \cdot \theta_{atmosphere} $

The transmissivity can be approximated from the first graphic. Of the incoming solar radiation, 23% were absorbed by the atmosphere. This energy will be re-emitted partly to the earth's surface and partly to space. For this analysis, I assume the distribution is 50:50. Another 23% of the incoming solar radiation was reflected back to space. Consequently, the same amount will be reflected back to the earth when coming from the opposite side. A small part will then be re-re-reflected by the surface and so on. This amount is neglected here. All of the reflected radiation is treated as not transmitted. Thus:

$ \theta_{atmosphere} \approx 1 - 0.23 \cdot 0.5 - 0.23 \approx 0.66 $

Inserting yields

$ F_{out} = 61 \, \frac{W}{m^2} $

After installing the mirror, 61 W/m2 are reflected from earth back to space. Before installation, 23 W/m2 were reflected due to surface albedo. The difference is the change in our earth's energy balance:

$ \Delta F = 23 \, \frac{W}{m^2} - 61 \, \frac{W}{m^2} = -38 \, \frac{W}{m^2} $

The area in the denominator refers to area of the mirror. Radiative forcing is usually expressed in reference to the earth's surface area. The radiative forcing (RF) of a field of mirrors is thus:

$ RF = \Delta F \cdot \dfrac{A_{mirror}}{A_{earth}} \approx \Delta F \cdot \dfrac{A_{mirror}}{510.1 \cdot 10^6 km^2} $

## Radiative forcing of CO<sub>2</sub>

CO2 is a so-called greenhouse gas (GHG). GHGs are good transmitters of radiation of short wavelengths and are good absorbers of radiation of long wavelengths. Thus, they permit energy in the form of sun light to reach earth and they prevent long-wavelength radiation from escaping to space. Thanks to this effect, the average surface temperature on earth is at a cozy 14°C rather than freezing -18°C if it didn't have an atmosphere (https://en.wikipedia.org/wiki/Greenhouse_effect).

If the concentration of GHGs in the atmosphere increases, so will the earth's temperature. This change can be equivalently expressed as an increase in incoming (and thus outgoing, assuming equilibrium) solar radiation. This is what scientists call radiative forcing $\Delta F$. For a change in CO<sub>2</sub> concentration, radiative forcing can be approximated by a logarithmic relationship (https://en.wikipedia.org/wiki/Radiative_forcing):

$ RF \, \left[\dfrac{W}{m^2} \right] = 5.35 \ln \left(\dfrac{C}{C_0}\right) = 5.35 \ln \left(\dfrac{C_0 + \Delta C}{C_0} \right)$

Where $c_0$ is the reference concentration measured in volumetric parts per million (ppm-v). Today, the concentration of CO<sub>2</sub> in the atmosphere is approximately $c_0 = 400$ ppm-v.

Now, let us express this equation in terms of mass rather than concentration, for easier handling. One ppm-v of CO<sub>2</sub> corresponds roughly to 2.13 Gt of carbon (https://cdiac.ess-dive.lbl.gov/pns/faq.html). Thus:

$ \Delta C \, [ppm\text{-}v] \approx  2.13  \Delta m_{C} \, [Gt] \approx 7.81 \Delta m_{CO_2} \, [Gt]$

Inserting yields:

$ RF \, \left[\dfrac{W}{m^2} \right] = 5.35 \ln\bigg(1 + 0.02 \,\Delta m_{CO_2} [Gt] \bigg)$


## Mirror CO<sub>2</sub> compensation

Let us use what we know to answer a practical question: What mirror area would be necessary to compensate the aviation sector's CO<sub>2</sub> emissions? 

Aviation CO<sub>2</sub> emissions in 2018 amounted to 0.895 Gt (https://www.atag.org/facts-figures.html). However, not all of this CO<sub>2</sub> adds to radiative forcing. Part of the emitted CO<sub>2</sub> is absorbed by the earth's oceans and plants. In the past, about 45% of emitted CO<sub>2</sub> stayed in the atmosphere, whereas 55% were absorbed (https://earthobservatory.nasa.gov/features/CarbonCycle/page5.php). The atmospheric CO<sub>2</sub> increase was thus:

$ \Delta m_{CO_2} \approx 0.45 \cdot 0.895 \, Gt \approx 0.4 \, Gt $

The corresponding radiative forcing amounts to:

$ RF_{aviation} = 0.04 \, \dfrac{W}{m^2} $


Now, how much mirror area is necessary to compensate this RF? Expressing the area in percent of the earth's surface:

$ 
\dfrac{ A_{mirror} }{ A_{earth} } 
= - \dfrac{ RF_{aviation} }{ \Delta F_{mirror} } \cdot 100\%
\approx 0.1 \% 
$

By covering 0.1% of the earth's surface (ca. 54 Mio. km<sup>2</sup>) with mirrors, one could compensate the aviation industry's CO<sub>2</sub> emissions of the year 2018 (not taking into account non-CO<sub>2</sub> effects). Note that the result is actually a rate. Each year, more CO<sub>2</sub> is emitted and more mirrors would need to be built.

## Comparison to other CO<sub>2</sub>-mitigation strategies

### Sun-to-Liquid

Horizon 2020 project Sun-to-Liquid (S2L) proposes a path to produce jet fuel from atmospheric CO<sub>2</sub> using energy from concentrated sunlight. The chain from captured CO<sub>2</sub> to fuel is long and each step adds to technical losses and material requirements. Thus, the question arises: Is it worth going all the way to producing fuel or would it be more efficient to just reflect solar radiation back to space using the same mirrors?

No industrial plant exists to-date, so my estimates are based on Christoph's calculation for a scaled-up design. The plant produces 30,300 liters of fuel per hectare and year. The produced fuel's life-cycle GHG emissions (well-to-wake) amount to 0.6 kg CO<sub>2</sub>-equivalents per liter burned. Fossil jet fuel produces around 2.9 kg CO<sub>2</sub>-equivalents per liter throughout its life cycle. The total emission savings per hectare for one year are then:

$ \Delta m_{S2L} 
= 30300 \, \dfrac{L}{ha} \cdot \left(2.9 - 0.6 \right) \dfrac{kg_{CO_2-eq}}{L} 
\approx 7.0 \, \dfrac{kg_{CO_2-eq}}{m^2}$

What area would be necessary to compensate aviation's emissions for the year 2018?

$ 
\dfrac{ A_{S2L} }{ A_{earth} } 
= \dfrac{ \Delta m_{CO_2}}{ \Delta m_{S2L} \cdot A_{earth} } \cdot 100\%
\approx - \dfrac{ 400 \cdot 10^9 kg_{CO_2} }{ 7.0 \, \frac{kg_{CO_2-eq}}{m^2} \cdot 510.1 \cdot 10^{12} m^2 } \cdot 100\%
\approx 0.01 \% 
$

The S2L plant is around 10 times more area-efficient than using mirrors. Note that the S2L emission savings account for non-CO<sub>2</sub> effects. The number given for the aviation industry's emissions accounts for CO<sub>2</sub> only. The real area demand would be higher if non-CO<sub>2</sub> emissions are included.

### Afforestation
Forests store between 100 and 500 tonnes of Carbon per hectare (http://www.fao.org/3/y0900e/y0900e06.htm). This translates to 360-1800 t CO<sub>2</sub> absorbed per hectare. Assuming the lower bound, the area needed to compensate one year of aviation emissions is:

$\dfrac{ A_{mirror} }{ A_{earth} } = 
\dfrac{0.4 \cdot 10^{9} t}{360 \frac{t}{ha} \cdot A_{earth}} \cdot 100\% \approx 0.002 \%
$

Thus, afforestation is at least 50 times more area-efficient than using mirrors and at least 5 times more area-efficient than the S2L plant. Using the upper range value:

$\dfrac{ A_{mirror} }{ A_{earth} } = 
\dfrac{0.4 \cdot 10^{9} t}{1600 \frac{t}{ha} \cdot A_{earth}} \cdot 100\% \approx 0.0005 \%
$

Afforestation is at most 20 times more area-efficient than the S2L plant.

## Conclusion 

Both afforestation and fuel production using solar energy are more area-efficient in preventing climate change than mirrors. Afforestation is likely to be more area-efficient than S2L, making it the most effective scenario.
