﻿Imports System.Net.Http
Imports System.Text.RegularExpressions

Namespace Controller
    Public Class HttpRequests
        Public Shared Sub AutoDirectOCR(image As Bitmap)
            Dim imageData As Byte() = ConvertToByteArray(image)
            AutoDirectOCR(imageData)
        End Sub

        'Auto decides which party's API to use
        Public Shared Sub AutoDirectOCR(image As Byte())
            Dim config As Model.Configuration = Model.Configuration.Load()
            Select Case config.Mode
                Case Model.Configuration.ProcessMode.A9T9
                    A9T9_OCR(image, config.A9T9_Apikey, config.A9T9_Lang.ToString(), config.A9T9_TimeOut)
                Case Model.Configuration.ProcessMode.Sogou
                    Sogou_OCR(image, config.Sogou_TimeOut)
                Case Model.Configuration.ProcessMode.SauceNAO
                    SauceNAO(image, config.SauceNAO_Timeout)
            End Select
        End Sub

        Public Shared Async Function A9T9_OCR(imageData As Byte(), apikey As String, language As String, timeOut As Integer) As Threading.Tasks.Task
            Dim loadingBox = Initiating()
            Try
                Using httpClient As HttpClient = New HttpClient()
                    httpClient.Timeout = New TimeSpan(0, 0, timeOut)
                    Using form As MultipartFormDataContent = New MultipartFormDataContent()
                        form.Add(New StringContent(apikey), "apikey")
                        'Dim cmbLanguage As String = "eng"
                        Dim cmbLanguage As String = language
                        form.Add(New StringContent(cmbLanguage), "language")

                        form.Add(New ByteArrayContent(imageData, 0, imageData.Length), "image", "image.jpg")

                        ' tray_text changes to program name after this step
                        Using response As HttpResponseMessage = Await httpClient.PostAsync("https://api.ocr.space/Parse/Image", form)
                            Dim strContent As String = Await response.Content.ReadAsStringAsync()

                            Debug.WriteLine(strContent)

                            Dim parsedText As String = GetParsedTextFromA9T9(strContent)
                            Clipboard.Clear()
                            Clipboard.SetText(parsedText)
                            'If MessageBox.Show(parsedText, "A9T9 - " & language, MessageBoxButtons.OKCancel) = DialogResult.OK Then Clipboard.SetText(parsedText)  ' BUG: does not pop up. fix: wait. Cause: bad response

                            loadingBox.Teminate(parsedText)

                            'Warning: Consuming a lot of Memory, even closed
                            Dim OutputForm1 = New OutputForm(parsedText)
                            'If OutputForm1.ShowDialog() = True Then Clipboard.SetText(parsedText)
                            OutputForm1.ShowActivated = False  ' Prevents OutputForm from being focused  ' reference: https://social.msdn.microsoft.com/Forums/vstudio/en-US/36aef35e-0b42-41d0-8504-9eade152536b/activate-wpf-window-without-losing-focus-on-previous-opened-applicationwindow?forum=wpf
                            OutputForm1.Show()

                            ' for RAM releases
                            parsedText = Nothing
                            strContent = Nothing

                        End Using
                        imageData = Nothing
                    End Using
                End Using
            Catch exception As Exception
                If loadingBox Is Nothing Then
                    MessageBox.Show("Ooops" & vbCrLf & exception.Message)
                Else
                    loadingBox.ShowError(exception)
                End If

            End Try
            Finalizing()
        End Function

        Public Shared Async Function Sogou_OCR(imageData As Byte(), timeOut As Integer) As Threading.Tasks.Task
            Dim loadingBox = Initiating()
            Dim strContent As String
            Try
                Const url As String = "https://ocr.shouji.sogou.com/v2/ocr/json"
                Using httpClient As New HttpClient()
                    httpClient.Timeout = New TimeSpan(0, 0, timeOut)  ' time out after no response 
                    Using Form As New MultipartFormDataContent()  ' declare message body
                        Form.Add(New ByteArrayContent(imageData, 0, imageData.Length), "pic", "15142736450092d849c01ac1eaa31.jpg")  ' add image to message body; BUG: file name may necessarily be "1111111.jpg"
                        Using response As HttpResponseMessage = Await httpClient.PostAsync(url, Form)  ' get response through POST method
                            strContent = Await response.Content.ReadAsStringAsync()
                            Dim parsedText As String = GetParsedTextFromSogou(strContent)
                            Clipboard.Clear()
                            Clipboard.SetText(parsedText)
                            'If MessageBox.Show(parsedText, "Sogou", MessageBoxButtons.OKCancel) = DialogResult.OK Then Clipboard.SetText(parsedText)

                            loadingBox.Teminate(parsedText)

                            'Warning: Consuming a lot of Memory, even closed
                            Dim OutputForm1 = New OutputForm(parsedText)
                            'If OutputForm1.ShowDialog() = True Then Clipboard.SetText(parsedText)
                            OutputForm1.ShowActivated = False  ' Prevents OutputForm from being focused  ' reference: https://social.msdn.microsoft.com/Forums/vstudio/en-US/36aef35e-0b42-41d0-8504-9eade152536b/activate-wpf-window-without-losing-focus-on-previous-opened-applicationwindow?forum=wpf
                            OutputForm1.Show()

                        End Using
                        imageData = Nothing
                    End Using
                End Using
            Catch ex As Exception  ' HttpRequestException not working
                If loadingBox Is Nothing Then
                    'MessageBox.Show(ex.Message & vbCrLf & "Width: " & Form1._mRect.Width & " " & "Height: " & Form1._mRect.Height)  'TODO: delect _mRect's info
                    MessageBox.Show(ex.Message)
                    'Test result: either minimum of Width or Height is 50

                Else
                    loadingBox.ShowError(ex)
                End If
            End Try
            Finalizing()
        End Function

        'http://saucenao.com/ - a image reserve search engine; TODO: Add other engine's entry
        Public Shared Async Function SauceNAO(imageData As Byte(), timeOut As Integer) As Threading.Tasks.Task
            Dim loadingBox = Initiating()
            Try
                Using httpClient As HttpClient = New HttpClient()
                    httpClient.Timeout = New TimeSpan(0, 0, timeOut)
                    Using form As MultipartFormDataContent = New MultipartFormDataContent()
                        form.Add(New ByteArrayContent(imageData, 0, imageData.Length), "file", "111111.jpg")

                        ' tray_text changes to program name after this step
                        Using response As HttpResponseMessage = Await httpClient.PostAsync("https://saucenao.com/search.php", form)
                            Dim strContent As String = Await response.Content.ReadAsStringAsync()

                            loadingBox.Teminate()

                            'Not necessarily Google link, also other reverse search engine's link includes in strContent
                            Dim parsedGoogleLink As String = GetGoogleLinkFromSauceNAO(strContent)
                            Process.Start(parsedGoogleLink)

                            ' for RAM releases
                            strContent = Nothing

                        End Using
                        imageData = Nothing
                    End Using
                End Using
            Catch exception As Exception
                If loadingBox Is Nothing Then
                    MessageBox.Show("Ooops" & vbCrLf & exception.Message)
                Else
                    loadingBox.ShowError(exception)
                End If
            End Try
            Finalizing()
        End Function

        Private Shared Function Initiating()
            'Form1.tray.Text = "Processing"
            Dim loadingBox As New LoadingBox
            loadingBox.Show()
            Return loadingBox
        End Function

        Private Shared Sub Finalizing()
            GC.Collect()  ' uneffective
            'Form1.tray.Text = "Screenshot OCR"
        End Sub

        ''' <summary>
        ''' Convert Bitmap to Byte()
        ''' https://dotnettips.wordpress.com/2007/12/16/convert-bitmap-to-byte-array/
        ''' </summary>
        ''' <param name="value"></param>
        ''' <returns></returns>
        Private Shared Function ConvertToByteArray(ByVal value As Bitmap) As Byte()
            Dim bitmapBytes As Byte()
            Using stream As New System.IO.MemoryStream()
                Try  'Since null value cannot be detected, use Try instead
                    value.Save(stream, value.RawFormat)
                Catch ex As Exception
                    value.Save(stream, System.Drawing.Imaging.ImageFormat.Jpeg)
                End Try
                bitmapBytes = stream.ToArray()
            End Using
            Return bitmapBytes
        End Function

#Region "text operations"
        'analyses response documents and returns useful text
        Private Shared Function GetParsedTextFromA9T9(ByVal content As String) As String
            ' (?<="ParsedText"\s*:\s*").*?(?=(?<!\\)")
            Dim pattern As String = "(?<=" & Chr(34) & "ParsedText" & Chr(34) & "\s*:\s*" & Chr(34) & ").*?(?=(?<!\\)" & Chr(34) & ")"
            Dim match = Regex.Match(content, pattern)
            If match.Success Then
                Dim plainText = match.Value.Replace("\r\n", vbCrLf).Replace("\" & Chr(34), Chr(34)).Replace("\\", "\")

                If Model.Configuration.Load().EraseAllNewlines Then
                    Return ReplaceNewlines(plainText)
                Else
                    Return plainText
                End If
            Else
                ' https://stackoverflow.com/questions/13151322/how-to-raise-an-exception-in-vb-net
                Throw New System.Exception("This is a failure on getting proper response from API. Regex pattern did not match the responding text")
            End If
        End Function

        Private Shared Function GetParsedTextFromSogou(content As String) As String
            Dim pattern As String
            'Check if OCR succeeds. This may be unnecessary
            ' (?<="success"\s*:\s*).+?(?=\s*\})
            pattern = "(?<=" & Chr(34) & "success" & Chr(34) & "\s*:\s*).+?(?=\s*\})"
            Dim match = Regex.Match(content, pattern)
            If match.Success Then
                If Int(match.Value) = 0 Then Throw New System.Exception("OCR fails to find any word")
            Else
                ' How to Throw an error https://stackoverflow.com/questions/13151322/how-to-raise-an-exception-in-vb-net
                Throw New System.Exception("This is a failure on getting proper response from API. Regex pattern did not match the responding text")
            End If

            'parse content
            Dim parsedText As String = ""
            ' (?<="content"\s*:\s*").+?(?=(?<!\\)")
            pattern = "(?<=" & Chr(34) & "content" & Chr(34) & "\s*:\s*" & Chr(34) & ").+?(?=(?<!\\)" & Chr(34) & ")"
            Dim matches = Regex.Matches(content, pattern)
            For Each match In matches
                parsedText &= match.Value.Replace("\n", vbNewLine).Replace("\" & Chr(34), Chr(34)).Replace("\\", "\")
            Next

            If Model.Configuration.Load().EraseAllNewlines Then
                Return ReplaceNewlines(parsedText)
            Else
                Return parsedText
            End If
        End Function

        'match google image search link in response's text
        Private Shared Function GetGoogleLinkFromSauceNAO(rawText As String)
            '(?<=<a href=")(.*?google.*?)(?=">)
            Dim pattern As String = "(?<=<a href=" & Chr(34) & ")(.*?google.*?)(?=" & Chr(34) & ">)"
            Dim firstMatch As Match = Regex.Match(rawText, pattern)
            If Not firstMatch.Success Then
                Throw New System.Exception("This is a failure on getting proper response from API. Regex pattern failed to match the responding text")
            End If
            Return firstMatch.Value
        End Function

        'Erases all '\n'
        Private Shared Function ReplaceNewlines(plainText As String)
            Dim patternNewline2Space As String = "(?<=[a-zA-Z0-9_])" & vbNewLine & "(?=[a-zA-Z0-9_])"  ' '\w' in VB matches Chinese characters
            plainText = Regex.Replace(plainText, patternNewline2Space, " ", RegexOptions.None)
            plainText = plainText.Replace(vbNewLine, "")
            Return plainText
        End Function
#End Region
    End Class
End Namespace
