#pragma once

#include <XR.h>

// Note: these headers are from OpenXR-MixedReality not OpenXR-SDK
#include <openxr/openxr.h>
#include <openxr/openxr_platform.h>

#include <XrUtility/XrEnumerate.h>
#include <XrUtility/XrExtensions.h>
#include <XrUtility/XrStruct.h>
#include <XrUtility/XrHandle.h>
#include <XrUtility/XrMath.h>
#include <SampleShared/XrViewConfiguration.h>

#include <assert.h>
#include <stdexcept>

namespace xr
{
    // Move the types included from XrViewConfiguration into the xr namespace.
    using namespace sample;

#define GET_XR_RESULT_NAME_SWITCH_CASE(result) case result: return #result
    inline const char* GetXrResultName(XrResult result) noexcept
    {
        switch (result)
        {
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_SUCCESS);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_TIMEOUT_EXPIRED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_SESSION_LOSS_PENDING);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_EVENT_UNAVAILABLE);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_SPACE_BOUNDS_UNAVAILABLE);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_SESSION_NOT_FOCUSED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_FRAME_DISCARDED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_VALIDATION_FAILURE);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_RUNTIME_FAILURE);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_OUT_OF_MEMORY);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_API_VERSION_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_INITIALIZATION_FAILED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_FUNCTION_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_FEATURE_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_EXTENSION_NOT_PRESENT);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_LIMIT_REACHED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SIZE_INSUFFICIENT);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_HANDLE_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_INSTANCE_LOST);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SESSION_RUNNING);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SESSION_NOT_RUNNING);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SESSION_LOST);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SYSTEM_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_PATH_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_PATH_COUNT_EXCEEDED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_PATH_FORMAT_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_PATH_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_LAYER_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_LAYER_LIMIT_EXCEEDED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SWAPCHAIN_RECT_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SWAPCHAIN_FORMAT_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_ACTION_TYPE_MISMATCH);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SESSION_NOT_READY);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_SESSION_NOT_STOPPING);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_TIME_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_REFERENCE_SPACE_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_FILE_ACCESS_ERROR);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_FILE_CONTENTS_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_FORM_FACTOR_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_FORM_FACTOR_UNAVAILABLE);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_API_LAYER_NOT_PRESENT);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_CALL_ORDER_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_GRAPHICS_DEVICE_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_POSE_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_INDEX_OUT_OF_RANGE);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_VIEW_CONFIGURATION_TYPE_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_ENVIRONMENT_BLEND_MODE_UNSUPPORTED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_NAME_DUPLICATED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_NAME_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_ACTIONSET_NOT_ATTACHED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_ACTIONSETS_ALREADY_ATTACHED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_LOCALIZED_NAME_DUPLICATED);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_LOCALIZED_NAME_INVALID);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_ANDROID_THREAD_SETTINGS_ID_INVALID_KHR);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_ANDROID_THREAD_SETTINGS_FAILURE_KHR);
            GET_XR_RESULT_NAME_SWITCH_CASE(XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT);
        default:
            return "Unrecognized XrResult";
        }
    }
#undef GET_XR_RESULT_NAME_SWITCH_CASE

    inline void XrCheck(XrResult result)
    {
        if (XR_FAILED(result))
        {
            throw std::runtime_error{ GetXrResultName(result) };
        }
    }

    inline void XrAssert(XrResult result)
    {
        assert(!XR_FAILED(result));
        (void)result;
    }
}
