// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.TextAnalytics.Models
{
    /// <summary>
    /// The AnalyzeTextLROTask.
    /// Please note <see cref="AnalyzeTextLROTask"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AbstractiveSummarizationLROTask"/>, <see cref="CustomEntitiesLROTask"/>, <see cref="CustomMultiLabelClassificationLROTask"/>, <see cref="CustomSingleLabelClassificationLROTask"/>, <see cref="EntityLinkingLROTask"/>, <see cref="EntitiesLROTask"/>, <see cref="ExtractiveSummarizationLROTask"/>, <see cref="HealthcareLROTask"/>, <see cref="KeyPhraseLROTask"/>, <see cref="PiiLROTask"/> and <see cref="SentimentAnalysisLROTask"/>.
    /// </summary>
    internal abstract partial class AnalyzeTextLROTask : TaskIdentifier
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextLROTask"/>. </summary>
        protected AnalyzeTextLROTask()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextLROTask"/>. </summary>
        /// <param name="taskName"></param>
        /// <param name="kind"> Enumeration of supported long-running Text Analysis tasks. </param>
        internal AnalyzeTextLROTask(string taskName, AnalyzeTextLROTaskKind kind) : base(taskName)
        {
            Kind = kind;
        }

        /// <summary> Enumeration of supported long-running Text Analysis tasks. </summary>
        internal AnalyzeTextLROTaskKind Kind { get; set; }
    }
}
