// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.TextAnalytics.Models
{
    /// <summary> Enumeration of supported Text Analysis long-running operation task results. </summary>
    internal readonly partial struct AnalyzeTextLROResultsKind : IEquatable<AnalyzeTextLROResultsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextLROResultsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeTextLROResultsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SentimentAnalysisLROResultsValue = "SentimentAnalysisLROResults";
        private const string EntityRecognitionLROResultsValue = "EntityRecognitionLROResults";
        private const string PiiEntityRecognitionLROResultsValue = "PiiEntityRecognitionLROResults";
        private const string KeyPhraseExtractionLROResultsValue = "KeyPhraseExtractionLROResults";
        private const string EntityLinkingLROResultsValue = "EntityLinkingLROResults";
        private const string HealthcareLROResultsValue = "HealthcareLROResults";
        private const string ExtractiveSummarizationLROResultsValue = "ExtractiveSummarizationLROResults";
        private const string CustomEntityRecognitionLROResultsValue = "CustomEntityRecognitionLROResults";
        private const string CustomSingleLabelClassificationLROResultsValue = "CustomSingleLabelClassificationLROResults";
        private const string CustomMultiLabelClassificationLROResultsValue = "CustomMultiLabelClassificationLROResults";
        private const string AbstractiveSummarizationLROResultsValue = "AbstractiveSummarizationLROResults";

        /// <summary> SentimentAnalysisLROResults. </summary>
        public static AnalyzeTextLROResultsKind SentimentAnalysisLROResults { get; } = new AnalyzeTextLROResultsKind(SentimentAnalysisLROResultsValue);
        /// <summary> EntityRecognitionLROResults. </summary>
        public static AnalyzeTextLROResultsKind EntityRecognitionLROResults { get; } = new AnalyzeTextLROResultsKind(EntityRecognitionLROResultsValue);
        /// <summary> PiiEntityRecognitionLROResults. </summary>
        public static AnalyzeTextLROResultsKind PiiEntityRecognitionLROResults { get; } = new AnalyzeTextLROResultsKind(PiiEntityRecognitionLROResultsValue);
        /// <summary> KeyPhraseExtractionLROResults. </summary>
        public static AnalyzeTextLROResultsKind KeyPhraseExtractionLROResults { get; } = new AnalyzeTextLROResultsKind(KeyPhraseExtractionLROResultsValue);
        /// <summary> EntityLinkingLROResults. </summary>
        public static AnalyzeTextLROResultsKind EntityLinkingLROResults { get; } = new AnalyzeTextLROResultsKind(EntityLinkingLROResultsValue);
        /// <summary> HealthcareLROResults. </summary>
        public static AnalyzeTextLROResultsKind HealthcareLROResults { get; } = new AnalyzeTextLROResultsKind(HealthcareLROResultsValue);
        /// <summary> ExtractiveSummarizationLROResults. </summary>
        public static AnalyzeTextLROResultsKind ExtractiveSummarizationLROResults { get; } = new AnalyzeTextLROResultsKind(ExtractiveSummarizationLROResultsValue);
        /// <summary> CustomEntityRecognitionLROResults. </summary>
        public static AnalyzeTextLROResultsKind CustomEntityRecognitionLROResults { get; } = new AnalyzeTextLROResultsKind(CustomEntityRecognitionLROResultsValue);
        /// <summary> CustomSingleLabelClassificationLROResults. </summary>
        public static AnalyzeTextLROResultsKind CustomSingleLabelClassificationLROResults { get; } = new AnalyzeTextLROResultsKind(CustomSingleLabelClassificationLROResultsValue);
        /// <summary> CustomMultiLabelClassificationLROResults. </summary>
        public static AnalyzeTextLROResultsKind CustomMultiLabelClassificationLROResults { get; } = new AnalyzeTextLROResultsKind(CustomMultiLabelClassificationLROResultsValue);
        /// <summary> AbstractiveSummarizationLROResults. </summary>
        public static AnalyzeTextLROResultsKind AbstractiveSummarizationLROResults { get; } = new AnalyzeTextLROResultsKind(AbstractiveSummarizationLROResultsValue);
        /// <summary> Determines if two <see cref="AnalyzeTextLROResultsKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeTextLROResultsKind left, AnalyzeTextLROResultsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeTextLROResultsKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeTextLROResultsKind left, AnalyzeTextLROResultsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeTextLROResultsKind"/>. </summary>
        public static implicit operator AnalyzeTextLROResultsKind(string value) => new AnalyzeTextLROResultsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeTextLROResultsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeTextLROResultsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
