// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.TextAnalytics.Models
{
    /// <summary> The AnalyzeTextKeyPhraseExtractionInput. </summary>
    internal partial class AnalyzeTextKeyPhraseExtractionInput : AnalyzeTextTask
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextKeyPhraseExtractionInput"/>. </summary>
        public AnalyzeTextKeyPhraseExtractionInput()
        {
            Kind = AnalyzeTextTaskKind.KeyPhraseExtraction;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextKeyPhraseExtractionInput"/>. </summary>
        /// <param name="kind"> Enumeration of supported Text Analysis tasks. </param>
        /// <param name="analysisInput"></param>
        /// <param name="parameters"> Supported parameters for a Key Phrase Extraction task. </param>
        internal AnalyzeTextKeyPhraseExtractionInput(AnalyzeTextTaskKind kind, MultiLanguageAnalysisInput analysisInput, KeyPhraseTaskParameters parameters) : base(kind)
        {
            AnalysisInput = analysisInput;
            Parameters = parameters;
            Kind = kind;
        }

        /// <summary> Gets or sets the analysis input. </summary>
        public MultiLanguageAnalysisInput AnalysisInput { get; set; }
        /// <summary> Supported parameters for a Key Phrase Extraction task. </summary>
        public KeyPhraseTaskParameters Parameters { get; set; }
    }
}
