// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.TextAnalytics.Models
{
    /// <summary> The AnalyzeTextEntityRecognitionInput. </summary>
    internal partial class AnalyzeTextEntityRecognitionInput : AnalyzeTextTask
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntityRecognitionInput"/>. </summary>
        public AnalyzeTextEntityRecognitionInput()
        {
            Kind = AnalyzeTextTaskKind.EntityRecognition;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeTextEntityRecognitionInput"/>. </summary>
        /// <param name="kind"> Enumeration of supported Text Analysis tasks. </param>
        /// <param name="analysisInput"></param>
        /// <param name="parameters"> Supported parameters for an Entity Recognition task. </param>
        internal AnalyzeTextEntityRecognitionInput(AnalyzeTextTaskKind kind, MultiLanguageAnalysisInput analysisInput, EntitiesTaskParameters parameters) : base(kind)
        {
            AnalysisInput = analysisInput;
            Parameters = parameters;
            Kind = kind;
        }

        /// <summary> Gets or sets the analysis input. </summary>
        public MultiLanguageAnalysisInput AnalysisInput { get; set; }
        /// <summary> Supported parameters for an Entity Recognition task. </summary>
        public EntitiesTaskParameters Parameters { get; set; }
    }
}
