// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.TextAnalytics.Models
{
    /// <summary> An object representing a single summary with context for given document. </summary>
    internal partial class AbstractiveSummaryInternal
    {
        /// <summary> Initializes a new instance of <see cref="AbstractiveSummaryInternal"/>. </summary>
        /// <param name="text"> The text of the summary. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="text"/> is null. </exception>
        public AbstractiveSummaryInternal(string text)
        {
            Argument.AssertNotNull(text, nameof(text));

            Text = text;
            Contexts = new ChangeTrackingList<SummaryContextInternal>();
        }

        /// <summary> Initializes a new instance of <see cref="AbstractiveSummaryInternal"/>. </summary>
        /// <param name="text"> The text of the summary. </param>
        /// <param name="contexts"> The context list of the summary. </param>
        internal AbstractiveSummaryInternal(string text, IList<SummaryContextInternal> contexts)
        {
            Text = text;
            Contexts = contexts;
        }

        /// <summary> The text of the summary. </summary>
        public string Text { get; set; }
        /// <summary> The context list of the summary. </summary>
        public IList<SummaryContextInternal> Contexts { get; }
    }
}
