// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.TextAnalytics.Models
{
    /// <summary> An object representing the results for an Abstractive Summarization task. </summary>
    internal partial class AbstractiveSummarizationLROResult : AnalyzeTextLROResult
    {
        /// <summary> Initializes a new instance of <see cref="AbstractiveSummarizationLROResult"/>. </summary>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        /// <param name="results"> An object representing the pre-build summarization results of each document. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        public AbstractiveSummarizationLROResult(DateTimeOffset lastUpdateDateTime, TextAnalyticsOperationStatus status, AbstractiveSummarizationResult results) : base(lastUpdateDateTime, status)
        {
            Argument.AssertNotNull(results, nameof(results));

            Results = results;
            Kind = AnalyzeTextLROResultsKind.AbstractiveSummarizationLROResults;
        }

        /// <summary> Initializes a new instance of <see cref="AbstractiveSummarizationLROResult"/>. </summary>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        /// <param name="kind"> Enumeration of supported Text Analysis long-running operation task results. </param>
        /// <param name="taskName"></param>
        /// <param name="results"> An object representing the pre-build summarization results of each document. </param>
        internal AbstractiveSummarizationLROResult(DateTimeOffset lastUpdateDateTime, TextAnalyticsOperationStatus status, AnalyzeTextLROResultsKind kind, string taskName, AbstractiveSummarizationResult results) : base(lastUpdateDateTime, status, kind, taskName)
        {
            Results = results;
            Kind = kind;
        }

        /// <summary> An object representing the pre-build summarization results of each document. </summary>
        public AbstractiveSummarizationResult Results { get; set; }
    }
}
