// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.TextAnalytics.Legacy.Models
{
    internal static partial class TokenSentimentValueExtensions
    {
        public static string ToSerialString(this TokenSentimentValue value) => value switch
        {
            TokenSentimentValue.Positive => "positive",
            TokenSentimentValue.Mixed => "mixed",
            TokenSentimentValue.Negative => "negative",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TokenSentimentValue value.")
        };

        public static TokenSentimentValue ToTokenSentimentValue(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "positive")) return TokenSentimentValue.Positive;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "mixed")) return TokenSentimentValue.Mixed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "negative")) return TokenSentimentValue.Negative;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TokenSentimentValue value.");
        }
    }
}
